/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.SqlResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.IFMIsqlFacade;
import com.kingdee.eas.hr.base.TableCopyEnum;
import com.kingdee.eas.hr.base.client.AbstractTableCopyUI;
import com.kingdee.eas.hr.base.client.CheckLogin;
import com.kingdee.eas.hr.base.client.DuplicateVerifier;
import com.kingdee.eas.hr.base.client.f7.EditorCreator;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import oracle.sql.DATE;
import org.apache.log4j.Logger;

public class TableCopyUI
extends AbstractTableCopyUI {
    private static final Logger logger = CoreUIObject.getLogger(TableCopyUI.class);
    private String tarTable = null;
    private String srcTable = null;
    private List allTables = null;
    private DefaultComboBoxModel srcModel = new DefaultComboBoxModel();
    private KDTDefaultCellEditor txtEditor = new KDTDefaultCellEditor((JTextField)new KDTextField());
    private KDTDefaultCellEditor colEditor = new KDTDefaultCellEditor((JComboBox)new KDComboBox((ComboBoxModel)this.srcModel));
    private final String UPDATE = "update";
    private final String SET = "set";
    private final String SELECT = "select";
    private final String FROM = "from";
    private final String WHERE = "where";
    private final String INSERT = "insert into";

    public TableCopyUI() throws Exception {
        boolean b = new CheckLogin((Component)((Object)this)).isLogin();
        if (!b) {
            this.abort();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblConfig.checkParsed();
        this.tblConfig.getColumn("type").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)EditorCreator.getCBEditor(TableCopyEnum.class.getName())));
        this.tblConfig.getColumn("function").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
    }

    private SqlResult executeSQL(String sql) throws BOSException, EASBizException, SQLException {
        IFMIsqlFacade isql = FMIsqlFacadeFactory.getRemoteInstance();
        SqlResult rs = null;
        try {
            rs = isql.executeSql(sql);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return rs;
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        super.actionCheck_actionPerformed(e);
    }

    @Override
    public void actionConfig_actionPerformed(ActionEvent e) throws Exception {
        String tmpSrc;
        String tmpTar = this.txtTarTable.getText();
        if (!DuplicateVerifier.checkDup(this.tarTable, tmpTar)) {
            this.tarTable = tmpTar;
            this.clear();
            if (StringUtils.isEmpty((String)this.tarTable)) {
                return;
            }
            this.fillTable();
        }
        if (!DuplicateVerifier.checkDup(this.srcTable, tmpSrc = this.txtSrcTable.getText())) {
            this.srcTable = tmpSrc;
            this.srcModel.removeAllElements();
            if (StringUtils.isEmpty((String)this.srcTable)) {
                return;
            }
            IRow row = null;
            int size = this.tblConfig.getRowCount();
            for (int i = 0; i < size; ++i) {
                row = this.tblConfig.getRow(i);
                row.getCell("value").setValue(null);
            }
            this.loadModel(this.srcTable);
        }
    }

    private void clear() {
        this.tblConfig.removeRows();
        this.txtSql.setText(null);
    }

    private void loadModel(String srcTable) throws Exception {
        SqlResult rs = this.executeSQL("SHOW COLUMNS FROM " + srcTable.trim().toUpperCase());
        List rowSets = rs.getRowSets();
        if (rowSets.size() > 0) {
            IRowSet rowSet = null;
            for (int i = 0; i < rowSets.size(); ++i) {
                rowSet = (IRowSet)rowSets.get(i);
                while (rowSet.next()) {
                    this.srcModel.addElement(rowSet.getObject("COLUMN_NAME"));
                }
            }
        }
    }

    private void fillTable() throws Exception {
        if (StringUtils.isEmpty((String)this.tarTable)) {
            return;
        }
        this.tblConfig.removeRows();
        SqlResult rs = this.executeSQL("SHOW COLUMNS FROM " + this.tarTable.trim().toUpperCase());
        List rowSets = rs.getRowSets();
        if (rowSets.size() > 0) {
            for (int i = 0; i < rowSets.size(); ++i) {
                this.fillData(this.tblConfig, (IRowSet)rowSets.get(i));
            }
        }
    }

    private void fillData(KDTable tblMain, IRowSet rs) throws SQLException {
        while (rs.next()) {
            IRow row = tblMain.addRow();
            row.getCell("tarColumn").setValue(rs.getObject("COLUMN_NAME"));
            row.getCell("tarColType").setValue(rs.getObject("DATA_TYPE"));
            row.getCell("type").setValue((Object)TableCopyEnum.Input);
            row.getCell("value").setEditor((ICellEditor)this.txtEditor);
        }
    }

    @Override
    protected void tblConfig_editStopped(KDTEditEvent e) throws Exception {
        int col = e.getColIndex();
        int rowIndex = e.getRowIndex();
        IRow row = this.tblConfig.getRow(rowIndex);
        Object data = null;
        Object oldData = null;
        if (col == this.tblConfig.getColumn("type").getColumnIndex() && !DuplicateVerifier.checkDup(data = e.getValue(), oldData = e.getOldValue())) {
            row.getCell("value").setValue(null);
            if (TableCopyEnum.Input.equals(data)) {
                row.getCell("value").setEditor((ICellEditor)this.txtEditor);
            } else {
                row.getCell("value").setEditor((ICellEditor)this.colEditor);
            }
        }
    }

    @Override
    public void actionExecute_actionPerformed(ActionEvent e) throws Exception {
        String sql = this.txtSql.getText();
        if (!StringUtils.isEmpty((String)sql)) {
            this.executeSQL(sql);
        }
    }

    @Override
    public void actionSql_actionPerformed(ActionEvent e) throws Exception {
        this.txtSql.setText(this.buildSql());
    }

    private String buildSql() throws Exception {
        String sql = null;
        int size = this.tblConfig.getRowCount();
        if (size <= 0) {
            return sql;
        }
        StringBuffer tarCols = null;
        StringBuffer srcCols = null;
        String col = null;
        String tarColType = null;
        TableCopyEnum type = null;
        Object value = null;
        Object function = null;
        IRow row = null;
        boolean isHaveSrcCol = false;
        boolean isFunction = false;
        for (int i = 0; i < size; ++i) {
            row = this.tblConfig.getRow(i);
            value = row.getCell("value").getValue();
            col = row.getCell("tarColumn").getValue().toString();
            tarColType = row.getCell("tarColType").getValue().toString();
            type = (TableCopyEnum)((Object)row.getCell("type").getValue());
            function = row.getCell("function").getValue();
            isFunction = function != null && (Boolean)function != false;
            if (value == null || StringUtils.isEmpty((String)value.toString())) continue;
            if (tarCols == null) {
                tarCols = new StringBuffer();
                srcCols = new StringBuffer();
            } else {
                tarCols.append(",");
                srcCols.append(",");
            }
            tarCols.append(col);
            if (TableCopyEnum.srcTable.equals((Object)type)) {
                srcCols.append(value);
                isHaveSrcCol = true;
                continue;
            }
            if (isFunction) {
                srcCols.append(value);
                continue;
            }
            if (StringUtils.indexOfIgnoreCase((String)tarColType, (String)"CHAR") >= 0) {
                srcCols.append("'");
                srcCols.append(value);
                srcCols.append("'");
                continue;
            }
            if (StringUtils.indexOfIgnoreCase((String)tarColType, (String)"DATE") >= 0 || StringUtils.indexOfIgnoreCase((String)tarColType, (String)"TIME") >= 0) {
                SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                srcCols.append("{ts'" + sFormat.format(DATE.parseFormat((String)value.toString(), (String)"yyyy-MM-dd")) + "'}");
                continue;
            }
            srcCols.append(value);
        }
        if (tarCols != null) {
            StringBuffer iSql = new StringBuffer();
            iSql.append("insert into");
            iSql.append(" ");
            iSql.append(this.tarTable);
            iSql.append(" (");
            iSql.append(tarCols);
            iSql.append(") ");
            if (isHaveSrcCol) {
                iSql.append("select");
                iSql.append(" ");
                iSql.append(srcCols);
                iSql.append(" ");
                iSql.append("from");
                iSql.append(" ");
                iSql.append(this.srcTable);
            } else {
                iSql.append("values");
                iSql.append("(");
                iSql.append(srcCols);
                iSql.append(")");
            }
            sql = iSql.toString();
        }
        return sql;
    }

    @Override
    protected void txtTarTable_inputMethodTextChanged(InputMethodEvent e) throws Exception {
        super.txtTarTable_inputMethodTextChanged(e);
    }

    @Override
    protected void txtTarTable_keyTyped(KeyEvent e) throws Exception {
        super.txtTarTable_keyTyped(e);
    }

    @Override
    protected void txtSrcTable_inputMethodTextChanged(InputMethodEvent e) throws Exception {
        super.txtSrcTable_inputMethodTextChanged(e);
    }

    @Override
    protected void txtSrcTable_keyTyped(KeyEvent e) throws Exception {
        super.txtSrcTable_keyTyped(e);
    }

    @Override
    protected void lstTarTable_mouseClicked(MouseEvent e) throws Exception {
        super.lstTarTable_mouseClicked(e);
    }

    @Override
    protected void lstSrcTable_mouseClicked(MouseEvent e) throws Exception {
        super.lstSrcTable_mouseClicked(e);
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }
}

