/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.AffairActionReasonCollection;
import com.kingdee.eas.hr.base.AffairActionReasonInfo;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRBizDefChangeReasonCollection;
import com.kingdee.eas.hr.base.HRBizDefEmpTypeCollection;
import com.kingdee.eas.hr.base.HRBizDefOutEmpTypeCollection;
import com.kingdee.eas.hr.base.HRBizDefineCollection;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.client.f7.EditorCreator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class HRBizDefineClientUtils {
    public static ICellEditor getOutEmpTypeEditor(String hrBizDefineID) {
        HRBizDefineInfo hrBizDefineInfo = HRBizDefineClientUtils.getHRBizDefineInfo(hrBizDefineID);
        if (hrBizDefineInfo == null) {
            return EditorCreator.getChkBoxCellEditor();
        }
        EmployeeTypeCollection empTypeColl = HRBizDefineClientUtils.getEmpTypeCollection(hrBizDefineInfo);
        return new KDTDefaultCellEditor((JComboBox)EditorCreator.getEmpTypeEditor(empTypeColl));
    }

    public static ICellEditor getOutEmpTypeEditor(HRBizDefineInfo hrBizDefineInfo) {
        if (hrBizDefineInfo == null) {
            return new KDTDefaultCellEditor((JComboBox)new KDComboBox());
        }
        EmployeeTypeCollection empTypeColl = HRBizDefineClientUtils.getEmpTypeCollection(hrBizDefineInfo);
        return new KDTDefaultCellEditor((JComboBox)EditorCreator.getEmpTypeEditor(empTypeColl));
    }

    public static void setOutEmpTypeEditor(String hrBizDefineID, KDComboBox combo) {
        combo.removeAllItems();
        HRBizDefineInfo hrBizDefineInfo = HRBizDefineClientUtils.getHRBizDefineInfo(hrBizDefineID);
        EmployeeTypeCollection empTypeColl = HRBizDefineClientUtils.getEmpTypeCollection(hrBizDefineInfo);
        if (empTypeColl != null && empTypeColl.size() > 0) {
            DefaultComboBoxModel model = new DefaultComboBoxModel();
            Iterator iter = empTypeColl.iterator();
            while (iter.hasNext()) {
                model.addElement(iter.next());
            }
            combo.setModel(model);
        }
    }

    public static void setOutEmpTypeEditor(HRBizDefineInfo hrBizDefineInfo, KDComboBox combo) {
        combo.removeAllItems();
        EmployeeTypeCollection empTypeColl = HRBizDefineClientUtils.getEmpTypeCollection(hrBizDefineInfo);
        if (empTypeColl != null && empTypeColl.size() > 0) {
            DefaultComboBoxModel model = new DefaultComboBoxModel();
            Iterator iter = empTypeColl.iterator();
            while (iter.hasNext()) {
                model.addElement(iter.next());
            }
            combo.setModel(model);
        }
    }

    public static EmployeeTypeCollection getDefaultEmpType() {
        return new EmployeeTypeCollection();
    }

    public static HashSet getInEmpTypeIdSet(String classUIName) throws EASBizException, BOSException {
        HRBizDefineCollection hrBizDefineColl = HRBizDefineFactory.getRemoteInstance().getHRBizDefineCollByUI(classUIName);
        if (hrBizDefineColl == null || hrBizDefineColl.size() == 0) {
            return null;
        }
        HashSet<String> inEmpTypeIdSet = new HashSet<String>();
        HRBizDefEmpTypeCollection bizDefInEmpType = null;
        EmployeeTypeInfo empTypeInfo = null;
        for (int i = 0; i < hrBizDefineColl.size(); ++i) {
            bizDefInEmpType = hrBizDefineColl.get(i).getInEmpTypes();
            if (bizDefInEmpType == null || bizDefInEmpType.size() == 0) continue;
            for (int j = 0; j < bizDefInEmpType.size(); ++j) {
                empTypeInfo = bizDefInEmpType.get(j).getEmpType();
                inEmpTypeIdSet.add(empTypeInfo.getId().toString());
            }
        }
        return inEmpTypeIdSet;
    }

    public static EmployeeTypeCollection getEmpTypeCollection(HRBizDefineInfo hrBizDefineInfo) {
        if (hrBizDefineInfo == null) {
            return null;
        }
        HRBizDefOutEmpTypeCollection bizDefOutEmpType = hrBizDefineInfo.getOutEmpTypes();
        EmployeeTypeCollection empTypeColl = null;
        if (bizDefOutEmpType == null || bizDefOutEmpType.size() == 0) {
            empTypeColl = HRBizDefineClientUtils.getDefaultEmpType();
        } else {
            EmployeeTypeInfo empTypeInfo = null;
            empTypeColl = new EmployeeTypeCollection();
            for (int j = 0; j < bizDefOutEmpType.size(); ++j) {
                empTypeInfo = bizDefOutEmpType.get(j).getEmpType();
                empTypeColl.add(empTypeInfo);
            }
        }
        return empTypeColl;
    }

    public static ICellEditor getAffairActionEditor(String hrBizDefineID) {
        HRBizDefineInfo hrBizDefineInfo = HRBizDefineClientUtils.getHRBizDefineInfo(hrBizDefineID);
        if (hrBizDefineInfo == null) {
            return new KDTDefaultCellEditor((JComboBox)new KDComboBox());
        }
        AffairActionReasonCollection reasonColl = HRBizDefineClientUtils.getAffairActionReason(hrBizDefineInfo);
        return new KDTDefaultCellEditor((JComboBox)EditorCreator.getComboxEditor(reasonColl.toArray()));
    }

    public static KDTDefaultCellEditor getAffairActionEditor(HRBizDefineInfo hrBizDefineInfo) {
        if (hrBizDefineInfo == null) {
            return new KDTDefaultCellEditor((JComboBox)new KDComboBox());
        }
        AffairActionReasonCollection reasonColl = HRBizDefineClientUtils.getAffairActionReason(hrBizDefineInfo);
        return new KDTDefaultCellEditor((JComboBox)EditorCreator.getComboxEditor(reasonColl.toArray()));
    }

    public static void setAffairActionEditor(String hrBizDefineID, KDComboBox combo) {
        combo.removeAllItems();
        HRBizDefineInfo hrBizDefineInfo = HRBizDefineClientUtils.getHRBizDefineInfo(hrBizDefineID);
        AffairActionReasonCollection reasonColl = HRBizDefineClientUtils.getAffairActionReason(hrBizDefineInfo);
        if (reasonColl != null && reasonColl.size() > 0) {
            DefaultComboBoxModel model = new DefaultComboBoxModel();
            Iterator iter = reasonColl.iterator();
            while (iter.hasNext()) {
                model.addElement(iter.next());
            }
            combo.setModel(model);
        }
    }

    public static void setAffairActionEditor(HRBizDefineInfo hrBizDefineInfo, KDComboBox combo) {
        combo.removeAllItems();
        AffairActionReasonCollection reasonColl = HRBizDefineClientUtils.getAffairActionReason(hrBizDefineInfo);
        if (reasonColl != null && reasonColl.size() > 0) {
            DefaultComboBoxModel model = new DefaultComboBoxModel();
            Iterator iter = reasonColl.iterator();
            while (iter.hasNext()) {
                model.addElement(iter.next());
            }
            combo.setModel(model);
        }
    }

    public static AffairActionReasonCollection getAffairActionReason(HRBizDefineInfo hrBizDefineInfo) {
        int j;
        AffairActionReasonCollection reasonColl = new AffairActionReasonCollection();
        if (hrBizDefineInfo == null) {
            return reasonColl;
        }
        HRBizDefChangeReasonCollection bizDefReason = hrBizDefineInfo.getActionReasons();
        if (bizDefReason == null || bizDefReason.size() == 0) {
            return reasonColl;
        }
        int size = bizDefReason.size();
        ArrayList<AffairActionReasonInfo> ls = new ArrayList<AffairActionReasonInfo>(size);
        for (j = 0; j < size; ++j) {
            ls.add(bizDefReason.get(j).getActionReason());
        }
        Collections.sort(ls, new Comparator<AffairActionReasonInfo>(){

            @Override
            public int compare(AffairActionReasonInfo o1, AffairActionReasonInfo o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        });
        for (j = 0; j < size; ++j) {
            reasonColl.add((AffairActionReasonInfo)ls.get(j));
        }
        return reasonColl;
    }

    public static AffairActionReasonCollection getAllAffairActionReason() {
        return new AffairActionReasonCollection();
    }

    public static HRBizDefineInfo getHRBizDefineInfo(String hrBizDefineID) {
        HRBizDefineInfo hrBizDefineInfo = null;
        try {
            hrBizDefineInfo = HRBizDefineFactory.getRemoteInstance().getHRBizDefineInfo((IObjectPK)new ObjectUuidPK(hrBizDefineID), HRBizDefineClientUtils.getBizDefineSelector());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return hrBizDefineInfo;
    }

    public static SelectorItemCollection getBizDefineSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("empTypeField"));
        sic.add(new SelectorItemInfo("juridicalPerson"));
        sic.add(new SelectorItemInfo("assignType"));
        sic.add(new SelectorItemInfo("positionStatus"));
        sic.add(new SelectorItemInfo("empTypes.empType.id"));
        sic.add(new SelectorItemInfo("empTypes.empType.name"));
        sic.add(new SelectorItemInfo("empTypes.empType.number"));
        sic.add(new SelectorItemInfo("empTypes.empType.isOnTheStrength"));
        sic.add(new SelectorItemInfo("empTypes.empType.inService"));
        sic.add(new SelectorItemInfo("empTypes.empType.workRelation"));
        sic.add(new SelectorItemInfo("outEmpTypes.empType.id"));
        sic.add(new SelectorItemInfo("outEmpTypes.empType.name"));
        sic.add(new SelectorItemInfo("outEmpTypes.empType.number"));
        sic.add(new SelectorItemInfo("outEmpTypes.empType.isOnTheStrength"));
        sic.add(new SelectorItemInfo("outEmpTypes.empType.inService"));
        sic.add(new SelectorItemInfo("outEmpTypes.empType.workRelation"));
        sic.add(new SelectorItemInfo("actionReasons.actionReason.id"));
        sic.add(new SelectorItemInfo("actionReasons.actionReason.name"));
        sic.add(new SelectorItemInfo("actionReasons.actionReason.number"));
        sic.add(new SelectorItemInfo("variationReasons.variationReason.id"));
        sic.add(new SelectorItemInfo("variationReasons.variationReason.name"));
        sic.add(new SelectorItemInfo("variationReasons.variationReason.number"));
        sic.add(new SelectorItemInfo("entrys.affairActionOperate"));
        sic.add(new SelectorItemInfo("isQuickAddNew"));
        sic.add(new SelectorItemInfo("isEmpModify"));
        sic.add(new SelectorItemInfo("entrys.changeReason"));
        sic.add(new SelectorItemInfo("entrys.empTypeField"));
        sic.add(new SelectorItemInfo("entrys.positionField"));
        sic.add(new SelectorItemInfo("entrys.seq"));
        return sic;
    }
}

