/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.formula;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.hr.base.formula.HRCalcultor;
import com.kingdee.eas.hr.base.formula.HRFormulaInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class HRCmpCalculator
implements HRCalcultor {
    private static final Logger logger = Logger.getLogger(HRCmpCalculator.class);
    protected ICalculateContextProvider provider;
    protected Context ctx = null;
    protected Map orgUnitMap = new HashMap();
    protected Map hrDataMap = new HashMap(250);
    protected List cmpFormulaList = new ArrayList();
    protected SortedParameterArray params;
    protected Map bgFormulaMapFromBook = null;
    private String sheetName;

    public HRCmpCalculator(ICalculateContextProvider provider, Context ctx, String sheetName) {
        this.setProvider(provider);
        this.setCtx(ctx);
        this.setBgFormulaMapFromBook();
        this.setSheetName(sheetName);
    }

    public void execute(ICalculateContextProvider provider, Context ctx, SortedParameterArray params) {
        this.setProvider(provider);
        this.setCtx(ctx);
        this.params = params;
        this.execute(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(SortedParameterArray params) {
        this.params = params;
        try {
            this.parseParams(params);
            this.calculate();
            this.fillValue();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            SyntaxErrorException exception = new SyntaxErrorException(128L, (Object)ex);
            for (int i = 0; i < params.size(); ++i) {
                params.getParameter(i).setValue((Object)exception);
            }
        }
        finally {
            this.clear();
        }
    }

    protected void parseParams(SortedParameterArray params) throws Exception {
        if (params == null || params.isEmpty()) {
            return;
        }
        Parameter _parameter = null;
        String orgUnitNumber = null;
        HRFormulaInfo formulaInfo = null;
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            _parameter = params.getParameter(i);
            if (_parameter.getValue() != null && _parameter.getValue() instanceof SyntaxErrorException || !this.checkParams(_parameter)) continue;
            formulaInfo = this.getFormulaInfo(_parameter);
            orgUnitNumber = formulaInfo.getOrgNumber();
            if (StringUtils.isEmpty((String)orgUnitNumber)) {
                orgUnitNumber = ContextUtil.getCurrentHRUnit((Context)this.ctx).getNumber();
            }
            if (this.needSetOrgNumber()) {
                formulaInfo.setOrgNumber(orgUnitNumber);
            }
            this.doOtherThingForSub(formulaInfo);
        }
    }

    protected boolean needSetOrgNumber() {
        return true;
    }

    protected abstract void calculate() throws Exception;

    protected abstract void fillValue() throws Exception;

    protected boolean checkParams(Parameter parameter) throws Exception {
        return true;
    }

    protected void doOtherThingForSub(HRFormulaInfo formulaInfo) {
        this.cmpFormulaList.add(formulaInfo);
    }

    protected HRFormulaInfo getFormulaInfo(Parameter parameter) {
        return new HRFormulaInfo(parameter);
    }

    private void setBgFormulaMapFromBook() {
        IReportPropertyAdapter adapter = null;
        adapter = this.getProvider().getReportAdapter();
        this.bgFormulaMapFromBook = (Map)adapter.getReportProperty("Report_FormulaMap");
        if (this.bgFormulaMapFromBook == null) {
            this.bgFormulaMapFromBook = new HashMap();
        }
    }

    public Map getBgFormulaMapFromBook() {
        return this.bgFormulaMapFromBook;
    }

    public void setProvider(ICalculateContextProvider provider) {
        this.provider = provider;
    }

    protected ICalculateContextProvider getProvider() {
        return this.provider;
    }

    protected void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    protected Context getCtx() {
        return this.ctx;
    }

    public Map getOrgUnitMap() {
        return this.orgUnitMap;
    }

    public Map getHrDataMap() {
        return this.hrDataMap;
    }

    protected void clear() {
        this.getOrgUnitMap().clear();
        this.getHrDataMap().clear();
        this.getBgFormulaMapFromBook().clear();
        this.cmpFormulaList.clear();
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }
}

