/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodBatchQuery;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodFillParameter;
import com.kingdee.bos.ctrl.excel.model.struct.INeedSheetInfo;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.FormulaMoverFactoryForOther;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fi.rpt.BizFormulaMover;
import com.kingdee.eas.hr.base.formula.HRCmpCalculator;
import com.kingdee.eas.hr.base.formula.HRCmpSalCalculator;
import com.kingdee.eas.hr.base.formula.HrCmpFunCalculator;
import com.kingdee.eas.hr.base.formula.HrCmpSumCalculator;
import com.kingdee.eas.hr.base.formula.HrEmpCountCalculator;
import com.kingdee.eas.hr.base.formula.HrFixedCmpFunCalculator;
import com.kingdee.eas.hr.base.formula.HrPersonPlanCountCalculator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import org.apache.log4j.Logger;

public class HRReportBatchCalculatorImpl
implements IMethodBatchQuery,
INeedSheetInfo,
IMethodFillParameter,
ICalculator {
    Context ServerCtx = null;
    private ICalculateContextProvider context;
    private String sheetName;
    private static String _BAD_FUNCTION_ = "#BAD FUNCTION: ";
    private static final Logger logger = CoreUIObject.getLogger(HRReportBatchCalculatorImpl.class);

    public boolean batchQuery(Map methods) {
        for (Map.Entry e : methods.entrySet()) {
            String method = (String)e.getKey();
            SortedParameterArray param = (SortedParameterArray)e.getValue();
            this.batchMethodQuery(this.context, method, param);
        }
        return true;
    }

    public void batchMethodQuery(ICalculateContextProvider context, String methodName, SortedParameterArray params) {
        HRCmpCalculator calculator = null;
        if (methodName.equalsIgnoreCase("HrCmpSalariatPoint")) {
            calculator = new HRCmpSalCalculator(context, this.ServerCtx, this.getSheetName());
            calculator.execute(params);
        } else if (methodName.equalsIgnoreCase("HrCmpFun")) {
            calculator = new HrCmpFunCalculator(context, this.ServerCtx, this.getSheetName());
            calculator.execute(params);
        } else if (methodName.equalsIgnoreCase("hrEmpCount")) {
            calculator = new HrEmpCountCalculator(context, this.ServerCtx, this.getSheetName());
            calculator.execute(params);
        } else if (methodName.equalsIgnoreCase("HrPersonPlanCount")) {
            calculator = new HrPersonPlanCountCalculator(context, this.ServerCtx, this.getSheetName());
            calculator.execute(params);
        } else if (methodName.equalsIgnoreCase("HrFixedCmpFun")) {
            calculator = new HrFixedCmpFunCalculator(context, this.ServerCtx, this.getSheetName());
            calculator.execute(params);
        } else if (methodName.equalsIgnoreCase("HrCmpSum")) {
            calculator = new HrCmpSumCalculator(context, this.ServerCtx, this.getSheetName());
            calculator.execute(params);
        }
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public boolean getTrendParameters(Map info) {
        String methodName = (String)info.get("Method_Name");
        Object[] args = (Object[])info.get("Parameters");
        CellBlock fromCbe = (CellBlock)info.get("Block_From");
        CellBlock toCbe = (CellBlock)info.get("Block_To");
        int direction = this.getDirection(fromCbe, toCbe);
        BizFormulaMover mover = FormulaMoverFactoryForOther.getFormulaMover((Map)info);
        int len = ((Object[])args[0]).length;
        Object[] arg = new Object[len];
        System.arraycopy((Object[])args[0], 0, arg, 0, len);
        int[] hasChangedParas = mover.getModifiedParasIndexs();
        for (int i = 0; i < args.length; ++i) {
            mover.move(direction, methodName, Arrays.asList(arg));
            for (int j = 0; j < hasChangedParas.length; ++j) {
                if (direction == 4 || direction == 1) {
                    ((Object[])args[args.length - 1 - i])[hasChangedParas[j]] = new Variant(arg[hasChangedParas[j]], 11);
                    continue;
                }
                ((Object[])args[i])[hasChangedParas[j]] = new Variant(arg[hasChangedParas[j]], 11);
            }
        }
        return true;
    }

    private int getDirection(CellBlock fromCbe, CellBlock toCbe) {
        int fromCol1 = fromCbe.getCol();
        int fromCol2 = fromCbe.getCol2();
        int fromRow1 = fromCbe.getRow();
        int fromRow2 = fromCbe.getRow2();
        int toCol1 = toCbe.getCol();
        int toCol2 = toCbe.getCol2();
        int toRow1 = toCbe.getRow();
        int toRow2 = toCbe.getRow2();
        if (fromRow1 > toRow1) {
            return 1;
        }
        if (fromRow2 < toRow2) {
            return 3;
        }
        if (fromCol1 > toCol1) {
            return 4;
        }
        if (fromCol2 < toCol2) {
            return 2;
        }
        return 0;
    }

    public void initCalculateContext(ICalculateContextProvider context) {
        this.context = context;
        this.ServerCtx = context.getServerContext();
    }

    public BigDecimal hrCmpSalariatPoint(String hrOrgUnit, String salPointID, String hrCmpSchemeItem, String salPointSalGradeNumber) {
        return null;
    }

    public BigDecimal hrCmpFun(String hrOrgUnit, String hrCmpPeriod, int periodNum, String hrCmpScheme, String hrCmpSchemeItem, String hrEmpFilter) throws EASBizException, BOSException {
        return null;
    }

    public int hrEmpCount(String hrOrgUnit, String hrDimension, String hrEmpFilter, String hrEmpStatMode) throws EASBizException, BOSException {
        return 0;
    }

    public BigDecimal hrFixedCmpFun(String hrOrgUnit, String hrCmpFixedItem, String hrCmpFixedItemFilter) throws EASBizException, BOSException {
        return null;
    }

    public BigDecimal hrCmpSum(String hrOrgUnit, int beginYear, int beginPeriod, int endYear, int endPeriod, String hrCmpScheme, String hrCmpSchemeItem, String hrEmpFilter) throws EASBizException, BOSException {
        return null;
    }

    public int HrPersonPlanCount(String hrOrgUnit, String hrPersonPlanScheme, String hrPersonPlanPeriod, String hrPersonPlanFilter) throws EASBizException, BOSException {
        return 0;
    }
}

