/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class HRDBUtil {
    private static Logger logger = Logger.getLogger(HRDBUtil.class);
    public static final String CONFIG_EXCEPTION = "CONFIG_EXCEPTION";
    private static final int MAX_DATA_ROW = 8000;

    public static void executeBatch(Context ctx, String sql, List paramsList) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            Object[] params = null;
            int k = 1;
            boolean flag = false;
            for (int i = 0; i < paramsList.size(); ++i) {
                params = (Object[])paramsList.get(i);
                for (int j = 0; j < params.length; ++j) {
                    if (params[j] != null) {
                        ps.setObject(j + 1, params[j]);
                        continue;
                    }
                    ps.setNull(j + 1, 12);
                }
                ps.addBatch();
                if (i == k * 8000) {
                    flag = true;
                }
                if (i <= k * 8000 || !flag) continue;
                ps.executeBatch();
                ++k;
                flag = false;
                ps.clearBatch();
            }
            if (!flag) {
                ps.executeBatch();
            }
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)sql, (Throwable)exc);
                throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public static int getTableColumnLen(Context ctx, String table, String column) throws BOSException {
        ResultSet rs;
        Statement statement;
        Connection conn;
        block7: {
            int n;
            if (StringUtils.isEmpty((String)table) || StringUtils.isEmpty((String)column)) {
                return 0;
            }
            String sql = "select top 1 " + column + " from " + table;
            conn = null;
            statement = null;
            rs = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
            }
            catch (SQLException exc) {
                SQLUtils.cleanup((Connection)conn);
                throw new BOSException(CONFIG_EXCEPTION, (Throwable)exc);
            }
            try {
                int type;
                statement = conn.createStatement();
                rs = statement.executeQuery(sql);
                ResultSetMetaData rsmd = rs.getMetaData();
                if (rsmd.getColumnCount() <= 0 || (type = rsmd.getColumnType(1)) != 1 && type != 12 && type != -1) break block7;
                n = rsmd.getColumnDisplaySize(1);
            }
            catch (SQLException exc) {
                try {
                    logger.error((Object)("333 sql is:" + sql), (Throwable)exc);
                    throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
            return n;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return 0;
    }

    public static String createTempTable(Context ctx, Collection columnValueColl, String columnKey) throws BOSException {
        String temporaryTableName = null;
        String sql = " create TABLE aa (" + columnKey + " varchar(44) not null primary key) ";
        try {
            temporaryTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql);
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        StringBuffer sbInsert = new StringBuffer(512);
        sbInsert.append(" INSERT INTO ").append(temporaryTableName).append("(" + columnKey + ")VALUES (?)");
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sbInsert.toString());
            String ID = null;
            Iterator iter = columnValueColl.iterator();
            int count = 0;
            while (iter.hasNext()) {
                ID = (String)iter.next();
                ps.setString(1, ID);
                ps.addBatch();
                if (++count != 8000) continue;
                ps.executeBatch();
                ps.clearBatch();
                count = 0;
            }
            if (count > 0) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return temporaryTableName;
    }

    public static void updateInfoState(Context ctx, String id, String StateField, int state) throws SQLDataException, BOSException {
        IMetaDataLoader metaData = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String tableName = metaData.getEntity(BOSUuid.read((String)id).getType()).getTable().getName();
        String sql = "UPDATE " + tableName + " SET " + StateField + "=? WHERE FID=?";
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            pstmt = con.prepareStatement(sql);
            pstmt.setInt(1, state);
            pstmt.setString(2, id);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)con);
    }
}

