/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.util.StringUtility;
import com.kingdee.eas.hr.base.AffairActionReasonCollection;
import com.kingdee.eas.hr.base.AffairActionReasonFactory;
import com.kingdee.eas.hr.base.AffairActionReasonInfo;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.app.AbstractAffairActionReasonControllerBean;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class AffairActionReasonControllerBean
extends AbstractAffairActionReasonControllerBean {
    private final int startlevel = 1;
    public static final int MaxLongNumber = 160;
    public static final int MaxDisplayName = 160;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.AffairActionReasonControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AffairActionReasonInfo actionReasonInfo = (AffairActionReasonInfo)model;
        AffairActionReasonInfo parent = this.getFullParent(ctx, model);
        actionReasonInfo.setIsLeaf(true);
        if (parent == null || parent.getId().equals((Object)actionReasonInfo.getId())) {
            actionReasonInfo.setLevel(1);
            actionReasonInfo.setLongNumber(actionReasonInfo.getNumber());
            actionReasonInfo.setDisplayName(actionReasonInfo.getName());
            this.checkLongNumberLenth(ctx, actionReasonInfo);
            this.checkDisplayNameLength(ctx, actionReasonInfo);
            this.checkLongNumberDuplicate(ctx, actionReasonInfo);
        } else {
            actionReasonInfo.setLevel(parent.getLevel() + 1);
            actionReasonInfo.setLongNumber(parent.getLongNumber() + "!" + actionReasonInfo.getNumber());
            this.LinkDisplayName(parent, actionReasonInfo);
            this.checkLongNumberLenth(ctx, actionReasonInfo);
            this.checkDisplayNameLength(ctx, actionReasonInfo);
            this.checkLongNumberDuplicate(ctx, actionReasonInfo);
            if (parent.isIsLeaf()) {
                parent.setIsLeaf(false);
                super._update(ctx, (IObjectPK)new ObjectUuidPK(parent.getId()), (IObjectValue)parent);
            }
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)actionReasonInfo);
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AffairActionReasonInfo actionReasonInfo = (AffairActionReasonInfo)model;
        AffairActionReasonInfo oldActionReasonInfo = this.getAffairActionReasonInfo(ctx, pk);
        String oldDisplayName = oldActionReasonInfo.getDisplayName();
        String oldLongNumber = oldActionReasonInfo.getLongNumber();
        if (actionReasonInfo.getDisplayName() == null) {
            actionReasonInfo.setDisplayName(oldDisplayName);
            this.checkDisplayNameLength(ctx, actionReasonInfo);
        }
        if (actionReasonInfo.getLongNumber() == null) {
            actionReasonInfo.setLongNumber(oldLongNumber);
            this.checkLongNumberLenth(ctx, actionReasonInfo);
        }
        if (oldLongNumber == null) {
            String propertyAlias = this.getPropertyAlias(ctx, (CoreBaseInfo)actionReasonInfo, "longNumber");
            throw new BaseException(BaseException.CHECKFIELDISNULL, new Object[]{propertyAlias});
        }
        if (actionReasonInfo.containsKey("number") && oldLongNumber != null) {
            String longNumber = "";
            String number = "";
            longNumber = oldLongNumber;
            number = actionReasonInfo.getNumber();
            AffairActionReasonInfo parent = this.getFullParent(ctx, (IObjectValue)actionReasonInfo);
            if (parent == null || parent.getId().equals((Object)actionReasonInfo.getId())) {
                actionReasonInfo.setLongNumber(actionReasonInfo.getNumber());
                actionReasonInfo.setDisplayName(actionReasonInfo.getName());
                this.checkLongNumberLenth(ctx, actionReasonInfo);
                this.checkDisplayNameLength(ctx, actionReasonInfo);
            } else {
                actionReasonInfo.setLongNumber(parent.getLongNumber() + "!" + actionReasonInfo.getNumber());
                this.LinkDisplayName(parent, actionReasonInfo);
                this.checkLongNumberLenth(ctx, actionReasonInfo);
                this.checkDisplayNameLength(ctx, actionReasonInfo);
            }
            this.checkLongNumberDuplicate(ctx, actionReasonInfo);
            int level = actionReasonInfo.getLongNumber().split("!").length;
            actionReasonInfo.setLevel(level);
            if (longNumber != null && !longNumber.equals(actionReasonInfo.getLongNumber())) {
                this.updateChildLongNumberByNumberUpdated(ctx, actionReasonInfo, longNumber);
                this.updateChildDisplayNameByNameUpdated(ctx, actionReasonInfo, oldDisplayName, oldLongNumber);
            }
            if (oldDisplayName != null && !oldDisplayName.equals(actionReasonInfo.getDisplayName())) {
                this.updateChildDisplayNameByNameUpdated(ctx, actionReasonInfo, oldDisplayName, longNumber);
            }
        }
        this.checkDisplayNameLength(ctx, actionReasonInfo);
        super._update(ctx, pk, (IObjectValue)actionReasonInfo);
        this.syncParentIsLeafStatus(ctx, oldActionReasonInfo.getParent(), actionReasonInfo.getParent());
    }

    private AffairActionReasonInfo getFullParent(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AffairActionReasonInfo actionReasonInfo = (AffairActionReasonInfo)model;
        AffairActionReasonInfo parent = actionReasonInfo.getParent();
        if (parent == null || parent.getId().equals((Object)actionReasonInfo.getId())) {
            return null;
        }
        parent = AffairActionReasonFactory.getLocalInstance(ctx).getAffairActionReasonInfo((IObjectPK)new ObjectUuidPK(parent.getId()));
        actionReasonInfo.setParent(parent);
        return parent;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AffairActionReasonInfo actionReasonInfo = (AffairActionReasonInfo)model;
        IObjectPK newPK = super._submit(ctx, (IObjectValue)actionReasonInfo);
        AffairActionReasonInfo conrrespondReason = actionReasonInfo.getCorrespond();
        if (conrrespondReason != null) {
            conrrespondReason.setCorrespond(actionReasonInfo);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("correspond"));
            this._updatePartial(ctx, (IObjectValue)conrrespondReason, selector);
        }
        return newPK;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AffairActionReasonInfo reasonInfo = this.getAffairActionReasonInfo(ctx, pk);
        AffairActionReasonInfo conrrespondReason = reasonInfo.getCorrespond();
        if (conrrespondReason != null) {
            conrrespondReason.setCorrespond(null);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("correspond"));
            this._updatePartial(ctx, (IObjectValue)conrrespondReason, selector);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected AffairActionReasonInfo _getCorrespondActionReason(Context ctx, AffairActionReasonInfo affairActionReasonInfo) throws BOSException, EASBizException {
        AffairActionReasonInfo actionReason = null;
        if (affairActionReasonInfo.getId() != null) {
            SelectorItemCollection selectorItemColl = new SelectorItemCollection();
            selectorItemColl.add(new SelectorItemInfo("correspond.id"));
            selectorItemColl.add(new SelectorItemInfo("correspond.name"));
            selectorItemColl.add(new SelectorItemInfo("correspond.number"));
            selectorItemColl.add(new SelectorItemInfo("correspond.isInnerReason"));
            selectorItemColl.add(new SelectorItemInfo("correspond.longNumber"));
            AffairActionReasonInfo curActionReason = super.getAffairActionReasonInfo(ctx, (IObjectPK)new ObjectUuidPK(affairActionReasonInfo.getId().toString()), selectorItemColl);
            actionReason = curActionReason.getCorrespond();
        }
        return actionReason;
    }

    private void LinkDisplayName(AffairActionReasonInfo parent, AffairActionReasonInfo info) {
        String disPlayName = null;
        String parentDisplayName = parent.getDisplayName();
        disPlayName = parentDisplayName != null ? parentDisplayName + "_" + info.getName() : info.getName();
        info.setDisplayName(disPlayName);
    }

    private void checkLongNumberLenth(Context ctx, AffairActionReasonInfo info) throws EASBizException, BOSException {
        int len;
        String propertyAlias = null;
        propertyAlias = this.getPropertyAlias(ctx, (CoreBaseInfo)info, "longNumber");
        int n = len = info.getLongNumber() == null ? -1 : info.getLongNumber().length();
        if (len > 160) {
            throw new BaseException(BaseException.CHECKFIELDLENGTH, new Object[]{propertyAlias, String.valueOf(160)});
        }
    }

    private void checkDisplayNameLength(Context ctx, AffairActionReasonInfo info) throws EASBizException, BOSException {
        int len;
        String propertyAlias = null;
        propertyAlias = this.getPropertyAlias(ctx, (CoreBaseInfo)info, "displayName");
        int n = len = info.getDisplayName() == null ? -1 : info.getDisplayName().length();
        if (len > 160) {
            throw new BaseException(BaseException.CHECKFIELDLENGTH, new Object[]{propertyAlias, String.valueOf(160)});
        }
    }

    private String getPropertyAlias(Context ctx, CoreBaseInfo info, String propertyName) {
        String alias = null;
        PropertyInfo property = this.getProperty(ctx, info, propertyName);
        if (property != null) {
            alias = property.getAlias();
        }
        return alias;
    }

    private PropertyInfo getProperty(Context ctx, CoreBaseInfo info, String propertyName) {
        EntityObjectInfo entity = this.getBOSEntity(ctx, info);
        PropertyInfo property = null;
        property = entity.getPropertyByNameRuntime(propertyName);
        return property;
    }

    private void checkLongNumberDuplicate(Context ctx, AffairActionReasonInfo info) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", (Object)info.getLongNumber(), CompareType.EQUALS));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this.exists(ctx, filterInfo)) {
            String longNumber = this._getPropertyAlias(ctx, (DataBaseInfo)info, "longNumber") + " : " + info.getLongNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{longNumber});
        }
    }

    private void updateChildLongNumberByNumberUpdated(Context ctx, AffairActionReasonInfo info, String oldLongNumber) throws BOSException, EASBizException {
        String longNumber = info.getLongNumber();
        FilterItemInfo filterItemInfo = new FilterItemInfo("longNumber", (Object)(oldLongNumber + "!" + "%"), CompareType.LIKE);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(filterItemInfo);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        AffairActionReasonCollection affairActionReasonCollection = this.getAffairActionReasonCollection(ctx, view);
        AffairActionReasonInfo temp = null;
        Iterator iterator = affairActionReasonCollection.iterator();
        while (iterator.hasNext()) {
            temp = (AffairActionReasonInfo)iterator.next();
            String temps = StringUtility.castRegular((String)oldLongNumber);
            temp.setLongNumber(temp.getLongNumber().replaceFirst(temps, longNumber));
            this.checkLongNumberLenth(ctx, temp);
            int level = temp.getLongNumber().split("!").length;
            temp.setLevel(level);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(temp.getId()), (IObjectValue)temp);
        }
    }

    private void updateChildDisplayNameByNameUpdated(Context ctx, AffairActionReasonInfo info, String oldDisplayName, String oldLongNumber) throws BOSException, EASBizException {
        String displayName = info.getDisplayName();
        FilterItemInfo filterItemInfo = new FilterItemInfo("longNumber", (Object)(info.getLongNumber() + "!" + "%"), CompareType.LIKE);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(filterItemInfo);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        AffairActionReasonCollection affairActionReasonCollection = this.getAffairActionReasonCollection(ctx, view);
        AffairActionReasonInfo temp = null;
        Iterator iterator = affairActionReasonCollection.iterator();
        while (iterator.hasNext()) {
            temp = (AffairActionReasonInfo)iterator.next();
            if (oldDisplayName != null) {
                if (temp.getDisplayName() != null) {
                    if (temp.getDisplayName().indexOf(oldDisplayName) > 1) {
                        return;
                    }
                    String temps = StringUtility.castRegular((String)oldDisplayName);
                    temp.setDisplayName(temp.getDisplayName().replaceFirst(temps + "_", displayName + "_"));
                } else {
                    temp.setDisplayName(displayName);
                }
            } else {
                temp.setDisplayName(displayName);
            }
            this.checkDisplayNameLength(ctx, temp);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(temp.getId()), (IObjectValue)temp);
        }
    }

    private void syncParentIsLeafStatus(Context ctx, AffairActionReasonInfo oldParentInfo, AffairActionReasonInfo parentInfo) throws EASBizException, BOSException {
        if (oldParentInfo != null && oldParentInfo.getId() != null && parentInfo != null && parentInfo.getId() != null && oldParentInfo.getId().toString().equals(parentInfo.getId().toString())) {
            return;
        }
        if (oldParentInfo != null && oldParentInfo.getId() != null) {
            this.updateIsLeafState(ctx, oldParentInfo.getId().toString());
        }
        if (parentInfo != null && parentInfo.getId() != null) {
            this.updateIsLeafState(ctx, parentInfo.getId().toString());
        }
    }

    private void updateIsLeafState(Context ctx, String parentId) throws BOSException, EASBizException {
        boolean isLeaf = this.isLeaf(ctx, parentId);
        if (isLeaf) {
            this.updateIsLeafState(ctx, parentId, true);
        } else {
            this.updateIsLeafState(ctx, parentId, false);
        }
    }

    private boolean isLeaf(Context ctx, String parentId) throws BOSException {
        boolean isLeaf = false;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)parentId));
        viewInfo.setFilter(filter);
        AffairActionReasonCollection affairActionReasonCollection = this.getAffairActionReasonCollection(ctx, viewInfo);
        isLeaf = affairActionReasonCollection.size() <= 0;
        return isLeaf;
    }

    private void updateIsLeafState(Context ctx, String parentId, boolean isLeaf) throws EASBizException, BOSException {
        if (this.exists(ctx, (IObjectPK)new ObjectUuidPK(parentId))) {
            AffairActionReasonInfo affairActionReasonInfo = this.getAffairActionReasonInfo(ctx, (IObjectPK)new ObjectUuidPK(parentId));
            affairActionReasonInfo.setIsLeaf(isLeaf);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("isLeaf"));
            this.updatePartial(ctx, (CoreBaseInfo)affairActionReasonInfo, selector);
        }
    }
}

