/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.AgeSegmentCollection;
import com.kingdee.eas.hr.base.AgeSegmentFactory;
import com.kingdee.eas.hr.base.AgeSegmentInfo;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.IAgeSegment;
import com.kingdee.eas.hr.base.app.AbstractAgeSegmentControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class AgeSegmentControllerBean
extends AbstractAgeSegmentControllerBean {
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkAge(ctx, model);
        this.checkAgeCross(ctx, model);
        AgeSegmentInfo info = (AgeSegmentInfo)model;
        CtrlUnitInfo cu = new CtrlUnitInfo();
        cu.setId(BOSUuid.read((String)"11111111-1111-1111-1111-111111111111CCE7AED4"));
        info.setCU(cu);
        super._addnew(ctx, pk, (IObjectValue)info);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkAge(ctx, model);
        this.checkAgeCross(ctx, model);
        AgeSegmentInfo info = (AgeSegmentInfo)model;
        CtrlUnitInfo cu = new CtrlUnitInfo();
        cu.setId(BOSUuid.read((String)"11111111-1111-1111-1111-111111111111CCE7AED4"));
        info.setCU(cu);
        return super._addnew(ctx, (IObjectValue)info);
    }

    @Override
    protected void _sort(Context ctx, String[] ids, int[] orders) throws BOSException, EASBizException {
        IMetaDataLoader metaData = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String tableName = metaData.getEntity(this.getBOSType()).getTable().getName();
        String sql = "UPDATE " + tableName + " SET FIndex=? WHERE FID=?";
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql);
            for (int i = 0; i < ids.length; ++i) {
                pstmt.setInt(1, orders[i]);
                pstmt.setString(2, ids[i]);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)con);
    }

    void checkAge(Context ctx, IObjectValue model) throws BaseException {
        AgeSegmentInfo segInfo = (AgeSegmentInfo)model;
        if (Integer.parseInt(Integer.toString(segInfo.getStartAge())) > Integer.parseInt(Integer.toString(segInfo.getEndAge()))) {
            throw new BaseException(BaseException.ENDAGE_MUST_BIG_STARTAGE);
        }
    }

    void checkAgeCross(Context ctx, IObjectValue model) throws BOSException, BaseException {
        AgeSegmentInfo segInfo = (AgeSegmentInfo)model;
        IAgeSegment iAge = AgeSegmentFactory.getLocalInstance(ctx);
        AgeSegmentCollection segInfos = iAge.getAgeSegmentCollection();
        int maxAge = 0;
        int minAge = 150;
        for (int i = 0; i < segInfos.size(); ++i) {
            if (segInfo.getId() != null && segInfo.getId().toString().equals(segInfos.get(i).getId().toString())) {
                maxAge = 150;
                minAge = 0;
                continue;
            }
            if (segInfos.get(i).getEndAge() > maxAge) {
                maxAge = segInfos.get(i).getEndAge();
            }
            if (segInfos.get(i).getStartAge() < minAge) {
                minAge = segInfos.get(i).getStartAge();
            }
            if (segInfo.getStartAge() == segInfos.get(i).getStartAge() || segInfo.getEndAge() == segInfos.get(i).getEndAge() || segInfo.getStartAge() == segInfos.get(i).getStartAge() && segInfo.getEndAge() == segInfos.get(i).getEndAge()) {
                throw new BaseException(BaseException.AGESEGMENT_NOT_REPEAT);
            }
            if ((segInfo.getStartAge() < segInfos.get(i).getStartAge() || segInfo.getStartAge() > segInfos.get(i).getEndAge()) && (segInfo.getEndAge() < segInfos.get(i).getStartAge() || segInfo.getEndAge() > segInfos.get(i).getEndAge())) continue;
            throw new BaseException(BaseException.AGESEGMENT_NOT_CROSS);
        }
        if (segInfos.size() == 0) {
            maxAge = 150;
            minAge = 0;
        }
        if (segInfo.getStartAge() < minAge && segInfo.getEndAge() < maxAge && segInfo.getEndAge() > minAge || segInfo.getStartAge() > minAge && segInfo.getStartAge() < maxAge && segInfo.getEndAge() > maxAge || segInfo.getStartAge() < minAge && segInfo.getEndAge() > maxAge) {
            throw new BaseException(BaseException.AGESEGMENT_NOT_CROSS);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkAge(ctx, model);
        this.checkAgeCross(ctx, model);
        this._checkNameDup(ctx, model);
        return super._submit(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkAge(ctx, model);
        this.checkAgeCross(ctx, model);
        super._update(ctx, pk, model);
    }
}

