/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.CnToSpell;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.hraux.DegreeFactory;
import com.kingdee.eas.basedata.hraux.DiplomaFactory;
import com.kingdee.eas.basedata.hraux.FolkFactory;
import com.kingdee.eas.basedata.hraux.PoliticalFaceFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.IEmployeeType;
import com.kingdee.eas.hr.base.ITechPostType;
import com.kingdee.eas.hr.base.ITechnicalPost;
import com.kingdee.eas.hr.base.TechPostTypeCollection;
import com.kingdee.eas.hr.base.TechPostTypeFactory;
import com.kingdee.eas.hr.base.TechPostTypeInfo;
import com.kingdee.eas.hr.base.TechnicalPostCollection;
import com.kingdee.eas.hr.base.TechnicalPostFactory;
import com.kingdee.eas.hr.base.TechnicalPostInfo;
import com.kingdee.eas.hr.base.app.AbstractBaseInnerFacadeControllerBean;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.org.IPersonPlanScheme;
import com.kingdee.eas.hr.org.PersonPlanSchemeFactory;
import com.kingdee.eas.hr.org.PersonPlanSchemeInfo;
import com.kingdee.eas.hr.org.PersonPlanType;
import com.kingdee.eas.hr.org.SchemeStatus;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BaseInnerFacadeControllerBean
extends AbstractBaseInnerFacadeControllerBean {
    @Override
    protected void _InputStandardTechnicalPost(Context ctx, IObjectCollection techCols) throws BOSException, EASBizException {
        this._inputStandardTechnicalPost(ctx, techCols);
    }

    @Override
    protected void _inputStandardTechnicalPost(Context ctx, IObjectCollection techCols) throws BOSException, EASBizException {
        TechnicalPostCollection postCols = (TechnicalPostCollection)techCols;
        ITechnicalPost iTech = TechnicalPostFactory.getLocalInstance((Context)ctx);
        ITechPostType iType = TechPostTypeFactory.getLocalInstance((Context)ctx);
        CtrlUnitInfo ctrlInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        HROrgUnitInfo hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        for (int i = 0; i < postCols.size(); ++i) {
            TechnicalPostInfo info = postCols.get(i);
            TechPostTypeInfo typeInfo = this.checkTechPostTypeExist(ctx, info);
            if (typeInfo == null) {
                TechPostTypeInfo tInfo = info.getCategory();
                tInfo.setId(null);
                tInfo.setCU(ctrlInfo);
                tInfo.setHrOrgUnit(hrInfo);
                tInfo.setIsStandard(0);
                IObjectPK pk = iType.addnew((CoreBaseInfo)tInfo);
                tInfo.setId(BOSUuid.read((String)pk.toString()));
                TechnicalPostInfo aInfo = postCols.get(i);
                aInfo.setId(null);
                aInfo.setCU(ctrlInfo);
                aInfo.setCategory(tInfo);
                aInfo.setIsStandard(0);
                aInfo.setHrOrgUnit(hrInfo);
                iTech.addnew((CoreBaseInfo)aInfo);
                continue;
            }
            TechnicalPostInfo aInfo = postCols.get(i);
            aInfo.setId(null);
            aInfo.setCategory(typeInfo);
            aInfo.setIsStandard(0);
            aInfo.setCU(ctrlInfo);
            aInfo.setHrOrgUnit(hrInfo);
            iTech.addnew((CoreBaseInfo)aInfo);
        }
    }

    TechPostTypeInfo checkTechPostTypeExist(Context ctx, TechnicalPostInfo info) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getCategory().getName()));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isStandard", (Object)0));
        view.setFilter(filter);
        ITechPostType iType = TechPostTypeFactory.getLocalInstance((Context)ctx);
        TechPostTypeCollection postCols = iType.getTechPostTypeCollection(view);
        if (postCols.size() != 0) {
            return postCols.get(0);
        }
        return null;
    }

    @Override
    protected ArrayList _getAdminTreeData(Context ctx, boolean includePosition, boolean includeVirtualOrg, HashSet hroSet) throws BOSException, EASBizException {
        return this._getAdminTreeData(ctx, includePosition, includeVirtualOrg, hroSet, false);
    }

    @Override
    protected HashMap _getParamValueByOrg(Context ctx, String paramNumber, Set orgList) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)paramNumber) || orgList == null || orgList.size() == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator iter = orgList.iterator();
        String key = null;
        String paramValue = null;
        while (iter.hasNext()) {
            key = (String)iter.next();
            paramValue = ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)paramNumber, (IObjectPK)new ObjectUuidPK(key), (boolean)true);
            map.put(key, paramValue);
        }
        return map;
    }

    @Override
    protected HashMap _getBaseData(Context ctx, ArrayList typeList) throws BOSException, EASBizException {
        if (typeList == null || typeList.size() == 0) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String oql = "select id,name";
        String key = null;
        int size = typeList.size();
        for (int i = 0; i < size; ++i) {
            key = typeList.get(i).toString();
            if (DiplomaFactory.class.getName().equals(key)) {
                map.put(DiplomaFactory.class.getName(), DiplomaFactory.getLocalInstance((Context)ctx).getDiplomaCollection(oql));
                continue;
            }
            if (FolkFactory.class.getName().equals(key)) {
                map.put(FolkFactory.class.getName(), FolkFactory.getLocalInstance((Context)ctx).getFolkCollection(oql));
                continue;
            }
            if (EmployeeTypeFactory.class.getName().equals(key)) {
                String filter = oql + " where inService = 1 and isEnabled = 1";
                map.put(EmployeeTypeFactory.class.getName(), EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeCollection(filter));
                continue;
            }
            if (PoliticalFaceFactory.class.getName().equals(key)) {
                map.put(PoliticalFaceFactory.class.getName(), PoliticalFaceFactory.getLocalInstance((Context)ctx).getPoliticalFaceCollection(oql));
                continue;
            }
            if (PoliticalFaceFactory.class.getName().equals(key)) {
                map.put(PoliticalFaceFactory.class.getName(), PoliticalFaceFactory.getLocalInstance((Context)ctx).getPoliticalFaceCollection(oql));
                continue;
            }
            if (typeList.get(i).toString().equals(DegreeFactory.class.getName())) {
                map.put(DegreeFactory.class.getName(), DegreeFactory.getLocalInstance((Context)ctx).getDegreeCollection(oql));
                continue;
            }
            if (!"EmployeeTypeDetail".equals(key)) continue;
            HashMap<String, EmployeeTypeCollection> details = new HashMap<String, EmployeeTypeCollection>();
            IEmployeeType employeeType = EmployeeTypeFactory.getLocalInstance((Context)ctx);
            String filter = oql + " where inService = 0 and isEnabled = 1";
            details.put("0", employeeType.getEmployeeTypeCollection(filter));
            filter = oql + " where inService = 1 and isEnabled = 1";
            details.put("1", employeeType.getEmployeeTypeCollection(filter));
            filter = oql + " where inService = 2 and isEnabled = 1";
            details.put("2", employeeType.getEmployeeTypeCollection(filter));
            filter = oql + " where inService = 3 and isEnabled = 1";
            details.put("3", employeeType.getEmployeeTypeCollection(filter));
            filter = oql + " where inService = 4 and isEnabled = 1";
            details.put("4", employeeType.getEmployeeTypeCollection(filter));
            map.put("EmployeeTypeDetail", details);
        }
        return map;
    }

    @Override
    protected HashMap _getAdminOrgData(Context ctx, boolean includePosition, HashSet hroSet, String adminId) throws BOSException, EASBizException {
        return this._getAdminOrgData(ctx, includePosition, hroSet, adminId, false);
    }

    private ArrayList getAdminList(Context ctx, HashSet hroSet, boolean includeSealup, String rootId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("SELECT FLongNumber ");
        sql.append(" FROM T_ORG_Admin ");
        sql.append(" INNER JOIN T_PM_OrgRange ON T_ORG_Admin.FID = T_PM_OrgRange.FOrgID ");
        if (hroSet != null && hroSet.size() > 0) {
            sql.append(" INNER JOIN T_ORG_UnitRelation ON T_ORG_UnitRelation.FFromUnitID = T_ORG_Admin.FID");
        }
        sql.append(" WHERE T_PM_OrgRange.FType = 20 ");
        if (!StringUtils.isEmpty((String)rootId)) {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("select flongnumber from t_org_admin where fid = '" + rootId + "'"));
            try {
                if (rowSet.next()) {
                    sql.append("and t_org_admin.flongnumber like '");
                    sql.append(rowSet.getString("flongnumber"));
                    sql.append("%' ");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (includeSealup) {
            sql.append("AND T_ORG_Admin.FIsSealUp = 0 ");
        }
        sql.append(" AND T_PM_OrgRange.FUserID='");
        sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        if (hroSet != null && hroSet.size() > 0) {
            sql.append("' AND T_ORG_UnitRelation.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5' AND T_ORG_UnitRelation.FToUnitID IN (");
            Iterator iter = hroSet.iterator();
            while (iter.hasNext()) {
                sql.append("'");
                sql.append(iter.next());
                if (!iter.hasNext()) continue;
                sql.append("',");
            }
            sql.append("') ORDER BY FLongNumber ");
        } else {
            sql.append("' ORDER BY FLongNumber ");
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> adminList = new ArrayList<String>();
        try {
            while (rows.next()) {
                adminList.add(rows.getString("FLongNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (adminList.size() == 0) {
            return null;
        }
        return adminList;
    }

    private String getRootAdminID(Context ctx, ArrayList adminList) throws BOSException, EASBizException {
        if (adminList == null || adminList.size() == 0) {
            return null;
        }
        String longNumber = adminList.get(0).toString();
        int size = adminList.size();
        for (int i = 1; i < size; ++i) {
            for (int count = 0; adminList.get(i).toString().indexOf(longNumber) == -1 && count < 20; ++count) {
                longNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
            }
        }
        StringBuffer sql = new StringBuffer("SELECT FID FROM T_ORG_Admin WHERE FLongNumber = '");
        sql.append(longNumber);
        sql.append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                return rows.getString("FID");
            }
            return null;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected ArrayList _getOrgChartData(Context ctx) throws BOSException, EASBizException {
        return this._getOrgChartData(ctx, false);
    }

    @Override
    protected ArrayList _getAdminTreeData(Context ctx, boolean includePosition, boolean includeVirtualOrg, HashSet hroSet, boolean includeSealup, boolean showHiddenInChart) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("SELECT FLongNumber ");
        sql.append(" FROM T_ORG_Admin ");
        sql.append(" INNER JOIN T_PM_OrgRange ON T_ORG_Admin.FID = T_PM_OrgRange.FOrgID ");
        if (hroSet != null && hroSet.size() > 0) {
            sql.append(" INNER JOIN T_ORG_UnitRelation ON T_ORG_UnitRelation.FFromUnitID = T_ORG_Admin.FID");
        }
        sql.append(" WHERE T_PM_OrgRange.FType = 20 ");
        if (includeSealup) {
            sql.append("AND T_ORG_Admin.FIsSealUp = 0 ");
        }
        sql.append(" AND T_PM_OrgRange.FUserID='");
        sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        if (hroSet != null && hroSet.size() > 0) {
            sql.append("' AND T_ORG_UnitRelation.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5' AND T_ORG_UnitRelation.FToUnitID IN (");
            Iterator iter = hroSet.iterator();
            while (iter.hasNext()) {
                sql.append("'");
                sql.append(iter.next());
                if (!iter.hasNext()) continue;
                sql.append("',");
            }
            sql.append("') ORDER BY FLongNumber ");
        } else {
            sql.append("' ORDER BY FLongNumber ");
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> adminList = new ArrayList<String>();
        try {
            while (rows.next()) {
                adminList.add(rows.getString("FLongNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (adminList.size() == 0) {
            return null;
        }
        String longNumber = adminList.get(0).toString();
        int size = adminList.size();
        for (int i = 1; i < size; ++i) {
            if (adminList.get(i).toString().indexOf(longNumber) != -1) continue;
            longNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
        }
        sql = new StringBuffer("SELECT T_ORG_Admin.FID,FParentID,FSortCode,FName_" + ctx.getLocale() + ",FLongNumber,FIsLeaf, FLevel ");
        sql.append("FROM T_ORG_Admin ");
        if (!showHiddenInChart) {
            sql.append("LEFT OUTER JOIN T_HR_AdminOther ON T_ORG_Admin.FID=T_HR_AdminOther.FAdminOrgUnitID ");
        }
        sql.append("WHERE (FLongNumber = '");
        sql.append(longNumber);
        sql.append("' OR FLongNumber LIKE '");
        sql.append(longNumber);
        sql.append("!%') ");
        if (!includeVirtualOrg) {
            sql.append(" AND FIsVirtual = 0 ");
        }
        if (includeSealup) {
            sql.append("AND FIsSealUp = 0 ");
        }
        if (!showHiddenInChart) {
            sql.append("AND (T_HR_AdminOther.FIsVisibleInOrgChart=1 OR T_HR_AdminOther.FIsVisibleInOrgChart IS NULL) ");
        }
        sql.append(" ORDER BY FLongNumber ");
        ArrayList<Object> returnList = new ArrayList<Object>();
        returnList.add(adminList);
        returnList.add(DbUtil.executeQuery((Context)ctx, (String)sql.toString()));
        if (includePosition) {
            sql = new StringBuffer("SELECT distinct P.FID id ,P.FName_");
            sql.append(ctx.getLocale());
            sql.append(" name, CASE P.FID WHEN A.FResponPositionID THEN 1 ELSE 0 END AS DEFAULTPOSITION ,");
            sql.append(" FAdminOrgUnitID,P.FIndex PFIndex  ");
            sql.append(" FROM T_ORG_Position P ");
            sql.append(" INNER JOIN T_ORG_Admin A ON P.FAdminOrgUnitID=A.FID ");
            sql.append(" INNER JOIN T_PM_OrgRange R ON A.FID = R.FOrgID ");
            sql.append(" WHERE R.FType = 20 AND R.FUserID='");
            sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            sql.append("' ");
            boolean isDistabled = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AFFAIR", null);
            if (!isDistabled) {
                sql.append(" AND (P.FDeletedStatus =1 OR P.FDeletedStatus IS NULL) ");
            }
            if (includeSealup) {
                sql.append("AND A.FIsSealUp = 0 ");
            }
            sql.append("ORDER BY DEFAULTPOSITION DESC,PFIndex ASC");
            returnList.add(DbUtil.executeQuery((Context)ctx, (String)sql.toString()));
        } else {
            returnList.add("NoPositionData");
        }
        sql = new StringBuffer("SELECT DISTINCT FFromUnitID, FToUnitID ");
        sql.append(" FROM T_ORG_UnitRelation ");
        sql.append(" INNER JOIN T_PM_OrgRange ON T_ORG_UnitRelation.FFromUnitID = T_PM_OrgRange.FOrgID ");
        sql.append(" WHERE T_PM_OrgRange.FType = 20 AND T_PM_OrgRange.FUserID='");
        sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        sql.append("' AND T_ORG_UnitRelation.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5'");
        rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            FullOrgUnitCollection orgCollection = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), OrgType.HRO, null, "HR_Org_View");
            HashSet<String> hrOrgSet = new HashSet<String>();
            if (orgCollection != null) {
                int n = orgCollection.size();
                for (int i = 0; i < n; ++i) {
                    hrOrgSet.add(orgCollection.get(i).getId().toString());
                }
            }
            String hrOrgId = null;
            String fromUnitId = null;
            HashSet<String> hasPermissionOrgSet = new HashSet<String>();
            while (rows.next()) {
                fromUnitId = rows.getString("FFromUnitID");
                hrOrgId = rows.getString("FToUnitID");
                if (!hrOrgSet.contains(hrOrgId)) continue;
                hasPermissionOrgSet.add(fromUnitId);
            }
            returnList.add(hasPermissionOrgSet);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return returnList;
    }

    @Override
    protected ArrayList _getAdminTreeData(Context ctx, boolean includePosition, boolean includeVirtualOrg, HashSet hroSet, boolean includeSealup) throws BOSException, EASBizException {
        return this._getAdminTreeData(ctx, includePosition, includeVirtualOrg, hroSet, includeSealup, true);
    }

    @Override
    protected HashMap _getAdminOrgData(Context ctx, boolean includePosition, HashSet hroSet, String adminId, boolean includeSealup) throws BOSException, EASBizException {
        return this._getAdminOrgData(ctx, includePosition, hroSet, adminId, includeSealup, true);
    }

    @Override
    protected ArrayList _getOrgChartData(Context ctx, boolean includeSealup) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        MetaDataPK queryPK = null;
        MetaDataPK queryPK2 = null;
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            queryPK = new MetaDataPK("com.kingdee.eas.hr.org.app.PositionOfAdminQuery");
            queryPK2 = new MetaDataPK("com.kingdee.eas.hr.org.app.PersonOfPositionQuery");
            CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId()));
        } else {
            queryPK = new MetaDataPK("com.kingdee.eas.hr.org.app.AdminOfPositionQuery");
            queryPK2 = new MetaDataPK("com.kingdee.eas.hr.org.app.PositionOfPersonQuery");
            filterInfo.getFilterItems().add(new FilterItemInfo("PMUser.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()));
        }
        if (includeSealup) {
            filterInfo.getFilterItems().add(new FilterItemInfo("ADMINORGUNIT.IsSealUp", (Object)0));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("ADMINORGUNIT.responPosition.deletedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        ArrayList<IRowSet> list = new ArrayList<IRowSet>(2);
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)queryExcu.getSQL());
        list.add(rows);
        queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK2);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows2 = DbUtil.executeQuery((Context)ctx, (String)queryExcu.getSQL());
        list.add(rows2);
        return list;
    }

    @Override
    protected void _initComplexPingYin(Context ctx) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)"update t_bd_person set FFullNamePingyin=null,FSimpleNamePingyin=null");
    }

    @Override
    protected void _updatePersonNamePingYin(Context ctx) throws BOSException, EASBizException {
        String sql = "select fname_" + ctx.getLocale() + " as fname ,fid  from t_bd_person where FFullNamePingYin is null";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String[]> paramList = new ArrayList<String[]>();
        try {
            while (rs.next()) {
                String name = rs.getString("fname");
                String fid = rs.getString("fid");
                String fullNamePingYin = CnToSpell.getSpell((String)name, (boolean)false);
                String simpleNamePingYin = CnToSpell.getSpell((String)name, (boolean)true);
                if (fullNamePingYin == null || simpleNamePingYin == null) continue;
                paramList.add(new String[]{fullNamePingYin, simpleNamePingYin, fid});
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String updateSql = "update t_bd_person set FFullNamePingYin=?,FSimpleNamePingYin=? where Fid=?";
        HRUtil.executeBatch(ctx, updateSql, paramList);
    }

    @Override
    protected HashMap _getAdminOrgData(Context ctx, boolean includePosition, HashSet hroSet, String adminId, boolean includeSealup, boolean showVirtualOrg) throws BOSException, EASBizException {
        String rootId = adminId;
        HashMap map = new HashMap();
        ArrayList adminList = this.getAdminList(ctx, hroSet, includeSealup, rootId);
        if (adminList == null || adminList.size() == 0) {
            return null;
        }
        if (StringUtils.isEmpty((String)adminId)) {
            rootId = this.getRootAdminID(ctx, adminList);
        }
        if (StringUtils.isEmpty((String)rootId)) {
            return null;
        }
        StringBuffer sql = new StringBuffer("SELECT FID,FParentID,FSortCode,FName_" + ctx.getLocale() + ",FNumber,FLongNumber,FIsLeaf, FLevel, FIsSealUp ");
        sql.append("FROM T_ORG_Admin ");
        sql.append(" WHERE (FParentID = '");
        sql.append(rootId);
        if (StringUtils.isEmpty((String)adminId)) {
            sql.append("' OR FID = '");
            sql.append(rootId);
        }
        sql.append("') ");
        if (!showVirtualOrg) {
            sql.append(" AND FIsVirtual = 0 ");
        }
        if (includeSealup) {
            sql.append("AND FIsSealUp = 0 ");
        }
        sql.append(" ORDER BY FSortCode,FLongNumber");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            HashMap<String, Integer> adminNodeType = new HashMap<String, Integer>();
            String longNumber = null;
            while (rows.next()) {
                int type = 0;
                longNumber = rows.getString("FLongNumber");
                if (adminList.contains(longNumber)) {
                    type = 1;
                } else {
                    int length = adminList.size();
                    for (int t = 0; t < length; ++t) {
                        if (adminList.get(t).toString().indexOf(longNumber + "!") == -1) continue;
                        type = 2;
                        break;
                    }
                }
                adminNodeType.put(rows.getString("FID"), type);
            }
            map.put("AdminNodeType", adminNodeType);
            rows.beforeFirst();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        map.put("AdminRowSet", rows);
        if (includePosition) {
            StringBuffer adminSql = new StringBuffer("SELECT FID ");
            adminSql.append(" FROM T_ORG_Admin ");
            adminSql.append(" WHERE (FParentID = '");
            adminSql.append(rootId);
            adminSql.append("' OR FID = '");
            adminSql.append(rootId);
            adminSql.append("') ");
            if (includeSealup) {
                adminSql.append("AND FIsSealUp = 0 ");
            }
            StringBuffer positionSql = new StringBuffer("SELECT DISTINCT P.FID id ,P.FName_");
            positionSql.append(ctx.getLocale());
            positionSql.append(" name, CASE P.FID WHEN A.FResponPositionID THEN 1 ELSE 0 END AS DEFAULTPOSITION ,");
            positionSql.append(" FAdminOrgUnitID,P.FIndex PFIndex  ");
            positionSql.append(" FROM T_ORG_Position P ");
            positionSql.append(" INNER JOIN T_ORG_Admin A ON P.FAdminOrgUnitID = A.FID ");
            positionSql.append(" WHERE FAdminOrgUnitID IN( ");
            positionSql.append(adminSql.toString());
            positionSql.append(") ");
            boolean isDistabled = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AFFAIR", null);
            if (!isDistabled) {
                positionSql.append(" AND (P.FDeletedStatus =1 OR P.FDeletedStatus IS NULL) ");
            }
            if (!showVirtualOrg) {
                sql.append(" AND A.FIsVirtual = 0 ");
            }
            if (includeSealup) {
                positionSql.append("AND A.FIsSealUp = 0 ");
            }
            positionSql.append(" ORDER BY DEFAULTPOSITION DESC,PFIndex ASC");
            map.put("PositionRowSet", DbUtil.executeQuery((Context)ctx, (String)positionSql.toString()));
        }
        return map;
    }

    @Override
    protected IRowSet _getSelectPersonRowSet(Context ctx, String queryPk, Set idSet) throws BOSException, EASBizException {
        TempTablePool pool = null;
        IRowSet rows = null;
        MetaDataPK queryPK = new MetaDataPK(queryPk);
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        String tmpTable = null;
        if (idSet != null && idSet.size() > 100) {
            tmpTable = this.createIdTmpTable(ctx, pool, idSet);
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)("select FID from " + tmpTable), CompareType.INNER));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        }
        viewInfo.setFilter(fi);
        queryExcu.setObjectView(viewInfo);
        rows = queryExcu.executeQuery();
        if (tmpTable != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tmpTable);
        }
        return rows;
    }

    private String createIdTmpTable(Context ctx, TempTablePool pool, Set idSet) throws BOSException {
        pool = TempTablePool.getInstance((Context)ctx);
        String cSql = " create TABLE  t1 (FID varchar(44) not null primary key) ";
        String tmpTableName = null;
        try {
            tmpTableName = pool.createTempTable(cSql);
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        finally {
            if (pool != null && tmpTableName != null) {
                pool.releaseTable(tmpTableName);
            }
        }
        StringBuffer sbInsert = new StringBuffer("insert into ");
        sbInsert.append(tmpTableName + " ( FID ) values (?) \n");
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            list.add(new Object[]{it.next()});
        }
        HRUtil.executeBatch(ctx, sbInsert.toString(), list);
        return tmpTableName;
    }

    private Map getCurPersonPlanCount(Context ctx, Set adminSet, String schemeId) throws BOSException {
        HashMap<String, Integer> planMap = new HashMap<String, Integer>();
        if (adminSet == null || adminSet.isEmpty() || StringUtils.isEmpty((String)schemeId)) {
            return planMap;
        }
        Calendar now = Calendar.getInstance(ctx.getLocale());
        Iterator iterator = adminSet.iterator();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT SUM(FPlan1), SUM(FPlan2) ,SUM(FPlan3), SUM(FPlan4),");
        sql.append("SUM(FPlan5), SUM(FPlan6), SUM( FPlan7), SUM(FPlan8),");
        sql.append("SUM(FPlan9), SUM(FPlan10), SUM(FPlan11), SUM(FPlan12), FAdminOrgID ");
        sql.append("FROM T_HR_PersonPlan WHERE FAdminOrgID IN ('");
        sql.append(iterator.next());
        while (iterator.hasNext()) {
            sql.append("', '").append(iterator.next());
        }
        sql.append("') AND FSchemeID = '");
        sql.append(schemeId);
        sql.append("' AND FYear = ");
        sql.append(now.get(1));
        sql.append(" GROUP BY FAdminOrgID");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            int curMonth = now.get(2) + 1;
            while (rowSet.next()) {
                String adminId = rowSet.getString("FAdminOrgID");
                int sum = rowSet.getInt(curMonth);
                planMap.put(adminId, sum);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return planMap;
    }

    private Map getCurPersonPlanCount(Context ctx, Set adminSet, String schemeId, boolean includeChild) throws BOSException {
        if (!includeChild) {
            return this.getCurPersonPlanCount(ctx, adminSet, schemeId);
        }
        if (adminSet == null || adminSet.isEmpty() || StringUtils.isEmpty((String)schemeId)) {
            return new HashMap();
        }
        HashMap<String, Set> parentMap = new HashMap<String, Set>();
        HashSet childSet = new HashSet();
        Map numberMap = this.getAdminNumber(ctx, adminSet);
        for (Map.Entry entry : numberMap.entrySet()) {
            String adminId = (String)entry.getKey();
            String longNumber = (String)entry.getValue();
            Set tmpChildSet = this.getChildAdmin(ctx, longNumber);
            parentMap.put(adminId, tmpChildSet);
            childSet.addAll(tmpChildSet);
        }
        Map planMap = this.getCurPersonPlanCount(ctx, childSet, schemeId);
        HashMap<String, Integer> planMap2 = new HashMap<String, Integer>();
        Iterator iterator = parentMap.entrySet().iterator();
        while (iterator.hasNext()) {
            int sum = 0;
            boolean existPersonPlan = false;
            Map.Entry entry = iterator.next();
            String parentId = (String)entry.getKey();
            if (!adminSet.contains(parentId)) continue;
            Set childIdSet = (Set)entry.getValue();
            for (String childId : childIdSet) {
                Object obj = planMap.get(childId);
                if (!(obj instanceof Integer)) continue;
                existPersonPlan = true;
                sum += ((Integer)obj).intValue();
            }
            if (!existPersonPlan) continue;
            planMap2.put(parentId, sum);
        }
        return planMap2;
    }

    private Set getChildAdmin(Context ctx, String longNumber) throws BOSException {
        HashSet<String> childSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from t_org_admin where flongnumber like '");
        sql.append(longNumber).append("%'");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                childSet.add(rowSet.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return childSet;
    }

    private Map getAdminNumber(Context ctx, Set adminIdSet) throws BOSException {
        HashMap<String, String> numberMap = new HashMap<String, String>();
        if (adminIdSet == null || adminIdSet.isEmpty()) {
            return numberMap;
        }
        Iterator iterator = adminIdSet.iterator();
        StringBuffer sql = new StringBuffer();
        sql.append("select fid, flongnumber from t_org_admin ");
        sql.append("where fid in ('");
        sql.append(iterator.next());
        while (iterator.hasNext()) {
            sql.append("', '").append(iterator.next());
        }
        sql.append("')");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                String adminId = rowSet.getString("fid");
                String longNumber = rowSet.getString("flongnumber");
                numberMap.put(adminId, longNumber);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return numberMap;
    }

    @Override
    protected List _getPersonPlanNumber(Context ctx, Set adminIDSet) throws BOSException, EASBizException {
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        try {
            Map<String, Integer> personPlanMap = new HashMap();
            Map<String, Integer> allPersonPlanMap = new HashMap();
            HashMap<String, Integer> realNumMap = new HashMap<String, Integer>();
            HashMap<String, Integer> allRealNumMap = new HashMap<String, Integer>();
            String curHROrg = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            AdminOrgUnitInfo admin = null;
            String longNumber = null;
            if (adminIDSet == null) {
                adminIDSet = this._getUserHRAdminOrg(ctx);
            }
            IRowSet rows = null;
            IPersonPlanScheme iPPScheme = PersonPlanSchemeFactory.getLocalInstance((Context)ctx);
            PersonPlanSchemeInfo schemeInfo = iPPScheme.getDefaultScheme(curHROrg);
            if (schemeInfo != null && schemeInfo.getStatus() == SchemeStatus.EXECUTE) {
                if (schemeInfo.getPlanType() == PersonPlanType.POSITION) {
                    String schemeId = schemeInfo.getId().toString();
                    personPlanMap = this.getCurPersonPlanCount(ctx, adminIDSet, schemeId);
                    allPersonPlanMap = this.getCurPersonPlanCount(ctx, adminIDSet, schemeId, true);
                } else if (schemeInfo.getPlanType() == PersonPlanType.PERSON) {
                    for (String adminID : adminIDSet) {
                        int count = this.getPlanPersonNumByPerson(ctx, curHROrg, adminID, schemeInfo);
                        personPlanMap.put(adminID, count);
                        int totalCount = this.getAllPlanPersonNumByPerson(ctx, curHROrg, adminID, schemeInfo);
                        allPersonPlanMap.put(adminID, totalCount);
                    }
                }
            }
            list.add(personPlanMap);
            list.add(allPersonPlanMap);
            boolean is_affair = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AFFAIR", null);
            for (String adminID : adminIDSet) {
                int count;
                String hroID = this.getEntrustHRO(ctx, adminID);
                boolean isSum = true;
                if (!StringUtils.isEmpty((String)hroID)) {
                    isSum = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_SUM_ADMIN", (String)hroID);
                }
                StringBuffer perSql = new StringBuffer();
                perSql.append(" select count(p.FID) as perNum from T_BD_Person p \n");
                perSql.append(" inner join T_ORG_PositionMember pp on pp.FPersonID = p.FID \n");
                perSql.append(" inner join T_ORG_Position pos on pp.FPositionID = pos.FID \n");
                perSql.append(" inner join T_HR_BDEmployeeType et on p.FEmployeeTypeID = et.FID \n");
                perSql.append(" where pos.FAdminOrgUnitID ='");
                perSql.append(adminID);
                perSql.append("' \n and (et.FinService = 1 or et.FinService =4 )\n");
                if (!is_affair) {
                    perSql.append(" and pos.FDeletedStatus =1 \n");
                }
                if (!isSum) {
                    perSql.append(" and pp.FIsPrimary =1 ");
                }
                if ((rows = DbUtil.executeQuery((Context)ctx, (String)perSql.toString())).next()) {
                    count = rows.getInt("perNum");
                    realNumMap.put(adminID, count);
                }
                admin = iAdmin.getAdminOrgUnitInfo((IObjectPK)new ObjectStringPK(adminID));
                longNumber = admin.getLongNumber();
                perSql = new StringBuffer();
                perSql.append(" select count(p.FID) as perNum from T_BD_Person p \n");
                perSql.append(" inner join T_ORG_PositionMember pp on pp.FPersonID = p.FID \n");
                perSql.append(" inner join T_ORG_Position pos on pp.FPositionID = pos.FID \n");
                perSql.append(" inner join T_HR_BDEmployeeType et on p.FEmployeeTypeID = et.FID \n");
                perSql.append(" inner join T_ORG_Admin adm on pos.FAdminOrgUnitID = adm.FID \n");
                perSql.append(" where (adm.FID ='");
                perSql.append(adminID);
                perSql.append("' or adm.FLongNumber like '");
                perSql.append(longNumber);
                perSql.append("!%') and adm.FIsSealUp = 0 \n");
                perSql.append(" and (et.FinService = 1 or et.FinService =4 )\n");
                if (!is_affair) {
                    perSql.append(" and pos.FDeletedStatus =1 \n");
                }
                if (!isSum) {
                    perSql.append(" and pp.FIsPrimary =1 ");
                }
                if (!(rows = DbUtil.executeQuery((Context)ctx, (String)perSql.toString())).next()) continue;
                count = rows.getInt("perNum");
                allRealNumMap.put(adminID, count);
            }
            list.add(realNumMap);
            list.add(allRealNumMap);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    protected HashSet _getUserHRAdminOrg(Context ctx) throws BOSException, EASBizException {
        HashSet<String> adminSet = new HashSet<String>();
        String userID = null;
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            throw new BOSException("current hrOrgUnit is null !");
        }
        if (ContextUtil.getCurrentUserInfo((Context)ctx) == null) {
            throw new BOSException("current user is null !");
        }
        userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation \n");
        sql.append(" WHERE FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5' \n");
        sql.append("AND FFromUnitID IN \n");
        sql.append("( SELECT FOrgID FROM T_PM_OrgRange \n");
        sql.append("WHERE FUserID = '");
        sql.append(userID);
        sql.append("' \n");
        sql.append("AND FType = ");
        sql.append(20);
        sql.append(")");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rows.next()) {
                adminSet.add(rows.getString("FFromUnitID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return adminSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getPlanPersonNumByPerson(Context ctx, String curHROrg, String adminID, PersonPlanSchemeInfo schemeInfo) throws BOSException {
        int count = 0;
        Calendar now = Calendar.getInstance(ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("select * from T_HR_PersonPlan where FHROrgUnitID ='");
        sql.append(curHROrg);
        sql.append("' and FAdminOrgID ='");
        sql.append(adminID);
        sql.append("' and FSchemeID ='");
        sql.append(schemeInfo.getId().toString());
        sql.append("' AND FYear = ");
        sql.append(now.get(1));
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            block12: while (row.next()) {
                int i;
                int periodType = row.getInt("FPeriod");
                if (periodType == 3) {
                    count = row.getInt("FPlan" + (now.get(2) + 1));
                    continue;
                }
                if (periodType == 2) {
                    switch (now.get(2) + 1) {
                        case 1: 
                        case 2: 
                        case 3: {
                            count = row.getInt("FPlan1") + row.getInt("FPlan2") + row.getInt("FPlan3");
                            continue block12;
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            count = row.getInt("FPlan4") + row.getInt("FPlan5") + row.getInt("FPlan6");
                            continue block12;
                        }
                        case 7: 
                        case 8: 
                        case 9: {
                            count = row.getInt("FPlan7") + row.getInt("FPlan8") + row.getInt("FPlan9");
                            continue block12;
                        }
                        case 10: 
                        case 11: 
                        case 12: {
                            count = row.getInt("FPlan10") + row.getInt("FPlan11") + row.getInt("FPlan12");
                            continue block12;
                        }
                    }
                    count = 0;
                    continue;
                }
                if (periodType == 1) {
                    switch (now.get(2) + 1) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            for (i = 1; i <= 6; count += row.getInt("FPlan" + i), ++i) {
                            }
                            continue block12;
                        }
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            for (i = 7; i <= 12; count += row.getInt("FPlan" + i), ++i) {
                            }
                            continue block12;
                        }
                    }
                    count = 0;
                    continue;
                }
                for (i = 1; i <= 12; count += row.getInt("FPlan" + i), ++i) {
                }
            }
            return count;
        }
        catch (SQLException e) {
            throw new BOSException();
        }
    }

    private int getAllPlanPersonNumByPerson(Context ctx, String curHROrg, String adminID, PersonPlanSchemeInfo schemeInfo) throws BOSException, EASBizException {
        int count = 0;
        int totalCount = 0;
        Calendar now = Calendar.getInstance(ctx.getLocale());
        IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitInfo admin = iAdmin.getAdminOrgUnitInfo((IObjectPK)new ObjectStringPK(adminID));
        String longNumber = admin.getLongNumber();
        StringBuffer sql = new StringBuffer();
        sql.append("select pp.* from T_HR_PersonPlan pp \n");
        sql.append(" inner join T_ORG_Admin adm on pp.FAdminOrgID = adm.FID \n");
        sql.append(" where pp.FHROrgUnitID ='");
        sql.append(curHROrg);
        sql.append("' and (adm.FID ='");
        sql.append(adminID);
        sql.append("' or adm.FLongNumber like '");
        sql.append(longNumber);
        sql.append("!%') and adm.FIsSealUp = 0 and pp.FSchemeID ='");
        sql.append(schemeInfo.getId().toString());
        sql.append("' AND pp.FYear = ");
        sql.append(now.get(1));
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (row.next()) {
                block17: {
                    int i;
                    block19: {
                        int periodType;
                        block18: {
                            block16: {
                                periodType = row.getInt("FPeriod");
                                if (periodType != 3) break block16;
                                count = row.getInt("FPlan" + (now.get(2) + 1));
                                break block17;
                            }
                            if (periodType != 2) break block18;
                            switch (now.get(2) + 1) {
                                case 1: 
                                case 2: 
                                case 3: {
                                    count = row.getInt("FPlan1") + row.getInt("FPlan2") + row.getInt("FPlan3");
                                    break;
                                }
                                case 4: 
                                case 5: 
                                case 6: {
                                    count = row.getInt("FPlan4") + row.getInt("FPlan5") + row.getInt("FPlan6");
                                    break;
                                }
                                case 7: 
                                case 8: 
                                case 9: {
                                    count = row.getInt("FPlan7") + row.getInt("FPlan8") + row.getInt("FPlan9");
                                    break;
                                }
                                case 10: 
                                case 11: 
                                case 12: {
                                    count = row.getInt("FPlan10") + row.getInt("FPlan11") + row.getInt("FPlan12");
                                    break;
                                }
                                default: {
                                    count = 0;
                                    break;
                                }
                            }
                            break block17;
                        }
                        if (periodType != 1) break block19;
                        switch (now.get(2) + 1) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                for (i = 1; i <= 6; ++i) {
                                    count += row.getInt("FPlan" + i);
                                }
                                break block17;
                            }
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: {
                                for (i = 7; i <= 12; ++i) {
                                    count += row.getInt("FPlan" + i);
                                }
                                break block17;
                            }
                            default: {
                                count = 0;
                                break;
                            }
                        }
                        break block17;
                    }
                    for (i = 1; i <= 12; ++i) {
                        count += row.getInt("FPlan" + i);
                    }
                }
                totalCount += count;
            }
        }
        catch (SQLException e) {
            throw new BOSException();
        }
        return totalCount;
    }

    private String getEntrustHRO(Context ctx, String adminID) throws BOSException {
        String hroID = null;
        StringBuffer sb = new StringBuffer();
        sb.append(" select FToUnitID from T_ORG_UnitRelation ");
        sb.append(" where FFromUnitID ='");
        sb.append(adminID);
        sb.append("' and FTypeRelationID ='00000000-0000-0000-0000-0000000000100FE9F8B5'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (rows.next()) {
                hroID = rows.getString("FToUnitID");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return hroID;
    }

    @Override
    protected HashMap _getAdminOrgDataByHR(Context ctx, boolean includePosition, HashSet hroSet, String adminId, boolean includeSealup, boolean showVirtualOrg) throws BOSException, EASBizException {
        String rootId = adminId;
        HashMap map = new HashMap();
        if (StringUtils.isEmpty((String)rootId)) {
            ArrayList adminList = this.getAdminListByHR(ctx, hroSet, includeSealup);
            if (adminList == null || adminList.size() == 0) {
                return null;
            }
            map.put("AdminRangeList", adminList);
            rootId = this.getRootAdminID(ctx, adminList);
            if (StringUtils.isEmpty((String)rootId)) {
                return null;
            }
        }
        StringBuffer sql = new StringBuffer("SELECT FID,FParentID,FSortCode,FName_" + ctx.getLocale() + ",FLongNumber,FIsLeaf, FLevel, FIsSealUp ");
        sql.append("FROM T_ORG_Admin ");
        sql.append(" WHERE (FParentID = '");
        sql.append(rootId);
        if (StringUtils.isEmpty((String)adminId)) {
            sql.append("' OR FID = '");
            sql.append(rootId);
        }
        sql.append("') ");
        if (!showVirtualOrg) {
            sql.append(" AND FIsVirtual = 0 ");
        }
        if (includeSealup) {
            sql.append("AND FIsSealUp = 0 ");
        }
        sql.append(" ORDER BY FSortCode,FLongNumber");
        map.put("AdminRowSet", DbUtil.executeQuery((Context)ctx, (String)sql.toString()));
        if (includePosition) {
            StringBuffer adminSql = new StringBuffer("SELECT FID ");
            adminSql.append(" FROM T_ORG_Admin ");
            adminSql.append(" WHERE (FParentID = '");
            adminSql.append(rootId);
            adminSql.append("' OR FID = '");
            adminSql.append(rootId);
            adminSql.append("') ");
            if (includeSealup) {
                adminSql.append("AND FIsSealUp = 0 ");
            }
            StringBuffer positionSql = new StringBuffer("SELECT DISTINCT P.FID id ,P.FName_");
            positionSql.append(ctx.getLocale());
            positionSql.append(" name, CASE P.FID WHEN A.FResponPositionID THEN 1 ELSE 0 END AS DEFAULTPOSITION ,");
            positionSql.append(" FAdminOrgUnitID,P.FIndex PFIndex  ");
            positionSql.append(" FROM T_ORG_Position P ");
            positionSql.append(" INNER JOIN T_ORG_Admin A ON P.FAdminOrgUnitID = A.FID ");
            positionSql.append(" WHERE FAdminOrgUnitID IN( ");
            positionSql.append(adminSql.toString());
            positionSql.append(") ");
            boolean isDistabled = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AFFAIR", null);
            if (!isDistabled) {
                positionSql.append(" AND (P.FDeletedStatus =1 OR P.FDeletedStatus IS NULL) ");
            }
            if (!showVirtualOrg) {
                sql.append(" AND A.FIsVirtual = 0 ");
            }
            if (includeSealup) {
                positionSql.append("AND A.FIsSealUp = 0 ");
            }
            positionSql.append(" ORDER BY DEFAULTPOSITION DESC,PFIndex ASC");
            map.put("PositionRowSet", DbUtil.executeQuery((Context)ctx, (String)positionSql.toString()));
        }
        return map;
    }

    private ArrayList getAdminListByHR(Context ctx, HashSet hroSet, boolean includeSealup) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select adminOrg.FLongNumber from T_ORG_Admin adminOrg where adminOrg.fid in (");
        sql.append("select unitRelation.FFromUnitId from T_ORG_UnitRelation as unitRelation ");
        sql.append("inner join T_ORG_TypeRelation as relationType ON unitRelation.FTypeRelationID = relationType.FID ");
        sql.append("where relationType.FFromType = 0 AND relationType.FToType = 16 ");
        if (hroSet != null && hroSet.size() > 0) {
            sql.append(" and unitRelation.FToUnitID in (");
            Iterator iter = hroSet.iterator();
            while (iter.hasNext()) {
                sql.append("'");
                sql.append(iter.next());
                if (!iter.hasNext()) continue;
                sql.append("',");
            }
            sql.append("')");
        }
        sql.append(")");
        if (includeSealup) {
            sql.append("and adminOrg.FIsSealUp = 0 order by adminOrg.FLongNumber");
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> adminList = new ArrayList<String>();
        try {
            while (rows.next()) {
                adminList.add(rows.getString("FLongNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (adminList.size() == 0) {
            return null;
        }
        return adminList;
    }

    @Override
    protected ArrayList _getStandbyChartData(Context ctx, boolean includeSealup) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        MetaDataPK queryPK = null;
        MetaDataPK queryPK2 = null;
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            queryPK = new MetaDataPK("com.kingdee.eas.hr.org.app.PositionOfAdminQuery");
            queryPK2 = new MetaDataPK("com.kingdee.eas.hr.standby.app.StandbyPersonQuery");
            CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId()));
        } else {
            queryPK = new MetaDataPK("com.kingdee.eas.hr.org.app.AdminOfPositionQuery");
            queryPK2 = new MetaDataPK("com.kingdee.eas.hr.standby.app.StandbyPersonQuery");
            filterInfo.getFilterItems().add(new FilterItemInfo("PMUser.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()));
        }
        if (includeSealup) {
            filterInfo.getFilterItems().add(new FilterItemInfo("ADMINORGUNIT.IsSealUp", (Object)0));
        }
        viewInfo.setFilter(filterInfo);
        ArrayList<IRowSet> list = new ArrayList<IRowSet>(2);
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)queryExcu.getSQL());
        list.add(rows);
        queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK2);
        EntityViewInfo standbyViewInfo = new EntityViewInfo();
        try {
            FilterInfo standbyFilter = new FilterInfo("ISSTANDBY = 1");
            standbyViewInfo.setFilter(standbyFilter);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        queryExcu.setObjectView(standbyViewInfo);
        IRowSet rows2 = DbUtil.executeQuery((Context)ctx, (String)queryExcu.getSQL());
        list.add(rows2);
        return list;
    }
}

