/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.AbstractEmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmpInfoSinglePageInfo;
import com.kingdee.eas.hr.base.EmpLaborRelationCollection;
import com.kingdee.eas.hr.base.EmpLaborRelationException;
import com.kingdee.eas.hr.base.EmpLaborRelationHisCollection;
import com.kingdee.eas.hr.base.EmpLaborRelationHisFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationHisInfo;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.HRBizDefineTypeEnum;
import com.kingdee.eas.hr.base.IEmpLaborRelationHis;
import com.kingdee.eas.hr.base.VariationReasonFactory;
import com.kingdee.eas.hr.base.VariationReasonInfo;
import com.kingdee.eas.hr.base.app.AbstractEmpLaborRelationControllerBean;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.util.ShrEmpNaturalMonthUtil;
import com.kingdee.eas.hr.emp.PersonPositionHisCollection;
import com.kingdee.eas.hr.emp.PersonPositionHisFactory;
import com.kingdee.eas.hr.emp.PersonPositionHisInfo;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptPersonPositionUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptPersonTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class EmpLaborRelationControllerBean
extends AbstractEmpLaborRelationControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.EmpLaborRelationControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super.delete(ctx, pk);
    }

    @Override
    public void delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        super.delete(ctx, arrayPK);
    }

    @Override
    protected void _updateCurrentAndHisByCareer(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        EmpLaborRelationInfo info = (EmpLaborRelationInfo)model;
        this.checkEmpLaborRelation(ctx, info);
        String personId = info.getPerson().getId().toString();
        Date enterDate = info.getEnterDate();
        if (!StringUtils.isEmpty((String)personId) && enterDate != null) {
            String updatePersonHireDateSql = "update t_bd_person set fHireDate=" + HRUtilExtend.getDateStringWithoutMininuteTs(enterDate) + " where fid='" + personId + "'";
            DbUtil.execute((Context)ctx, (String)updatePersonHireDateSql);
            String updatePersonHisHireDateSql = "update t_bd_personhis set fHireDate=" + HRUtilExtend.getDateStringWithoutMininuteTs(enterDate) + " where fhistoryrelateid='" + personId + "' and FLEFFDT = {ts'2199-12-31 00:00:00'}";
            DbUtil.execute((Context)ctx, (String)updatePersonHisHireDateSql);
        }
        this.setProbationField(ctx, info);
        this._update(ctx, pk, model);
        this.updateHisByCareer(ctx, info);
        if (info.getEnterDate() != null) {
            SHREmpOptPersonTool.updatePersonEFFDT((Context)ctx, (String)info.getPerson().getId().toString(), (Date)info.getEnterDate(), null);
        }
        try {
            String number = null;
            if (null != info.getEnrollSource()) {
                VariationReasonInfo actionReason;
                String sql = "SELECT FNUMBER number FROM T_HR_EnrollSource WHERE  FID= '" + info.getEnrollSource().getId() + "'  ";
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (rowSet.next()) {
                    number = rowSet.getString("number");
                }
                if (null != number && null != (actionReason = VariationReasonFactory.getLocalInstance(ctx).getVariationReasonInfo("where number = '" + number + "'"))) {
                    String empsql = "select action.id,action.bizDefineType where person = '" + info.getPerson().getId() + "'endDateTime <=" + info.getLEFFDT() + " order by endDateTime asc";
                    EmpPosOrgRelationCollection empCollection = EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationCollection(empsql);
                    AbstractEmpPosOrgRelationInfo empPosOrgRelation = null;
                    if (null != empCollection) {
                        for (int i = 0; i < empCollection.size(); ++i) {
                            HRBizDefineInfo action = empCollection.get(i).getAction();
                            if (!"P/OSDCPfQXqU0TB/LQoA6uZovtk=".equals(action.get("id").toString()) && 1 != Integer.parseInt(action.get("bizDefineType").toString())) continue;
                            empPosOrgRelation = empCollection.get(i);
                            break;
                        }
                    }
                    if (empPosOrgRelation != null) {
                        empPosOrgRelation.setActionReason(actionReason);
                        EmpPosOrgRelationFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(empPosOrgRelation.getId()), (CoreBaseInfo)empPosOrgRelation);
                    }
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"update the change record exception", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"find an exception", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"find an exception", (Throwable)e);
        }
    }

    private void checkEmpLaborRelation(Context ctx, EmpLaborRelationInfo info) throws BOSException, EASBizException {
        if (null == info.getEnterDate()) {
            return;
        }
        StringBuffer oql = new StringBuffer();
        oql.append(" where person='").append(info.getPerson().getId().toString()).append("'");
        oql.append(" and careerId = '").append(info.getCareerId()).append("'");
        oql.append(" and isinner = 1");
        oql.append(" order by endDateTime asc");
        IEmpLaborRelationHis iEmpLaborRelationHis = EmpLaborRelationHisFactory.getLocalInstance(ctx);
        EmpLaborRelationHisCollection emplaborColl = iEmpLaborRelationHis.getEmpLaborRelationHisCollection(oql.toString());
        if (emplaborColl != null && emplaborColl.size() > 0) {
            Date maxLeffdt = this.getMaxLeffdt(emplaborColl);
            if (DateTimeUtils.dayAfter((Date)info.getEnterDate(), (Date)maxLeffdt)) {
                throw new EmpLaborRelationException(EmpLaborRelationException.TIME_AFTER_LEFFDT, new String[]{maxLeffdt.toString()});
            }
        }
        if (!"career1".equals(info.getCareerId()) && emplaborColl != null && emplaborColl.size() > 0 && DateTimeUtils.dayBefore((Date)info.getEnterDate(), (Date)emplaborColl.get(0).getEFFDT())) {
            throw new EmpLaborRelationException(EmpLaborRelationException.TIME_BEFORE_EFFDT, new String[]{emplaborColl.get(0).getEFFDT().toString()});
        }
        EmpPosOrgRelationCollection empPosColl = EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationCollection("select EFFDT,action.id,action.bizDefineType where person.id = '" + info.getPerson().getId().toString() + "' and isInner=1 and assignType=1 order by LEFFDT desc");
        if (empPosColl.size() > 1 && DateTimeUtils.dayAfter((Date)info.getEnterDate(), (Date)empPosColl.get(0).getEFFDT()) && !EmpLaborRelationControllerBean.isEnrollAgainAction(empPosColl.get(0).getAction())) {
            throw new EmpLaborRelationException(EmpLaborRelationException.ENTERDATE_CANT_AFTER_EMPPOS_EFFDT);
        }
    }

    private static boolean isEnrollAgainAction(HRBizDefineInfo action) {
        return action.getBizDefineType().equals((Object)HRBizDefineTypeEnum.REINVITE) || HRBizDefineTypeEnum.ENROLLAGAIN.equals((Object)action.getBizDefineType());
    }

    private void setProbationField(Context ctx, EmpLaborRelationInfo info) throws EASBizException {
        if (info.getTryoutMonth() < 0) {
            info.setTryoutMonth(0);
        }
        if (info.getEnterDate() == null) {
            info.setPlanFormalDate(null);
        } else if (info.getTryoutMonth() > 0) {
            info.setPlanFormalDate(HRUtilExtend.getPlanFormalDate(info.getEnterDate(), info.getTryoutMonth()));
        } else if (info.getPlanFormalDate() != null) {
            this.calTryoutMonth(info);
        }
    }

    private void calTryoutMonth(EmpLaborRelationInfo info) throws EASBizException {
        if (!DateTimeUtils.dayAfter((Date)info.getPlanFormalDate(), (Date)info.getEnterDate())) {
            throw new EmpLaborRelationException(EmpLaborRelationException.PLANFORMALDATE_MUST_AFTER_ENTERDATE);
        }
        info.setTryoutMonth(ShrEmpNaturalMonthUtil.getProbation(info.getEnterDate(), DateUtil.getBeforeDay((Date)info.getPlanFormalDate())));
    }

    private void updateHisByCareer(Context ctx, EmpLaborRelationInfo info) throws BOSException, EASBizException {
        EmpLaborRelationHisCollection hisColl = EmpLaborRelationHisFactory.getLocalInstance(ctx).getEmpLaborRelationHisCollection("where person.id = '" + info.getPerson().getId().toString() + "' and careerId = '" + info.getCareerId() + "' order by startDateTime DESC");
        if (hisColl.size() > 0) {
            LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
            for (int i = 0; i < hisColl.size(); ++i) {
                EmpLaborRelationHisInfo hisInfo = hisColl.get(i);
                Object[] params = new Object[]{hisInfo.getTryoutMonth() != 0 ? info.getTryoutMonth() : 0, hisInfo.getEnrollSource() != null && null != info.getEnrollSource() ? info.getEnrollSource().getId().toString() : null, hisInfo.getEnterDate() != null ? info.getEnterDate() : null, hisInfo.getPlanFormalDate() != null ? info.getPlanFormalDate() : null, hisInfo.getReinviteDate() != null ? info.getReinviteDate() : null, hisInfo.getId().toString()};
                paramsList.add(params);
            }
            StringBuffer updateSql = new StringBuffer("update T_HR_EmpLaborRelationHis ").append("set FTryoutMonth = ?").append(", FEnrollSourceID = ?").append(", FEnterDate = ?").append(", FPlanFormalDate = ?").append(", FReinviteDate = ?").append(" where Fid = ?");
            DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramsList);
        }
        EmpLaborRelationHisInfo latestHisInfo = hisColl.get(0);
        Enumeration e = info.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if ("id".equalsIgnoreCase(key) || "historyRelateID".equalsIgnoreCase(key)) continue;
            latestHisInfo.put(key, info.get(key));
        }
        EmpLaborRelationHisFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(latestHisInfo.getId()), latestHisInfo);
    }

    private void updatePersonPositionData(Context ctx, EmpLaborRelationInfo info) throws BOSException, EASBizException {
        if (info.getEnterDate() != null) {
            String personId = info.getPerson().getId().toString();
            PersonPositionHisCollection ppHisColl = PersonPositionHisFactory.getLocalInstance((Context)ctx).getPersonPositionHisCollection("where person.id = '" + personId + "' and startDateTime=" + HRUtilExtend.getDateStringWithMinuteTs(info.getStartDateTime()) + "  order by EFFDT DESC");
            if (ppHisColl.size() > 0) {
                PersonPositionHisInfo ppHisInfo = ppHisColl.get(0);
                ppHisInfo.setJoinDate(info.getEnterDate());
                ppHisInfo.setJoinCompanyYears(SHREmpOptPersonPositionUtil.calWorkTimeYears((Context)ctx, (Date)ppHisInfo.getJoinDate(), (Date)ppHisInfo.getLeftCompanyDate(), (float)ppHisInfo.getAdjustCoValue()));
                PersonPositionHisFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(ppHisInfo.getId()), (EmpInfoSinglePageInfo)ppHisInfo);
                StringBuilder sql = new StringBuilder("select top 1 FJoinDate,FJoinCompanyYears,FLastUpdateUserId,FLastUpdateTime from T_HR_PersonPositionHis where Fpersonid='").append(personId).append("' order by FEFFDT DESC");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                try {
                    if (rs.next()) {
                        sql = new StringBuilder("update T_HR_PersonPosition set FJoinDate = ?,FJoinCompanyYears = ?,FLastUpdateUserId = ?,FLastUpdateTime = ? where Fpersonid = '").append(personId).append("'");
                        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{rs.getDate("FJoinDate"), Float.valueOf(rs.getFloat("FJoinCompanyYears")), rs.getString("FLastUpdateUserId"), rs.getTimestamp("FLastUpdateTime")});
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    @Override
    protected void _updateEmpLaborHisByCareer(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        EmpLaborRelationHisInfo info = (EmpLaborRelationHisInfo)model;
        this.checkEmpLaborRelationHis(ctx, info);
        this.setHisProbationField(ctx, info);
        this.updateLaborHisByCareer(ctx, info);
    }

    private void updateLaborHisByCareer(Context ctx, EmpLaborRelationHisInfo info) throws BOSException, EASBizException {
        IEmpLaborRelationHis iEmpLaborRelationHis;
        EmpLaborRelationHisCollection hisColl;
        if (info.getEnterDate() != null) {
            SHREmpOptPersonTool.updatePersonEFFDT((Context)ctx, (String)info.getPerson().getId().toString(), (Date)info.getEnterDate(), null);
        }
        if ((hisColl = (iEmpLaborRelationHis = EmpLaborRelationHisFactory.getLocalInstance(ctx)).getEmpLaborRelationHisCollection("where person.id = '" + info.getPerson().getId().toString() + "' and careerId = '" + info.getCareerId() + "' order by startDateTime DESC")).size() > 0) {
            LinkedList<Object[]> paramsList = new LinkedList<Object[]>();
            for (int i = 0; i < hisColl.size(); ++i) {
                EmpLaborRelationHisInfo hisInfo = hisColl.get(i);
                Object[] params = new Object[]{hisInfo.getTryoutMonth() != 0 ? info.getTryoutMonth() : 0, hisInfo.getEnrollSource() != null && null != info.getEnrollSource() ? info.getEnrollSource().getId().toString() : null, hisInfo.getEnterDate() != null ? info.getEnterDate() : null, hisInfo.getPlanFormalDate() != null ? info.getPlanFormalDate() : null, hisInfo.getReinviteDate() != null ? info.getReinviteDate() : null, hisInfo.getId().toString()};
                paramsList.add(params);
            }
            StringBuffer updateSql = new StringBuffer("update T_HR_EmpLaborRelationHis ").append("set FTryoutMonth = ?").append(", FEnrollSourceID = ?").append(", FEnterDate = ?").append(", FPlanFormalDate = ?").append(", FReinviteDate = ?").append(" where Fid = ?");
            DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramsList);
        }
        StringBuffer oql = new StringBuffer();
        oql.append(" where person='").append(info.getPerson().getId().toString()).append("'");
        oql.append(" and careerId = '").append(info.getCareerId()).append("'");
        EmpLaborRelationCollection emplaborColl = this.getEmpLaborRelationCollection(ctx, oql.toString());
        if (emplaborColl != null && emplaborColl.size() > 0) {
            for (int i = 0; i < emplaborColl.size(); ++i) {
                emplaborColl.get(i).setTryoutMonth(emplaborColl.get(i).getTryoutMonth() != 0 ? info.getTryoutMonth() : 0);
                emplaborColl.get(i).setEnrollSource(emplaborColl.get(i).getEnrollSource() != null && null != info.getEnrollSource() ? info.getEnrollSource() : null);
                emplaborColl.get(i).setEnterDate(emplaborColl.get(i).getEnterDate() != null ? info.getEnterDate() : null);
                emplaborColl.get(i).setPlanFormalDate(emplaborColl.get(i).getPlanFormalDate() != null ? info.getPlanFormalDate() : null);
                emplaborColl.get(i).setReinviteDate(emplaborColl.get(i).getReinviteDate() != null ? info.getReinviteDate() : null);
                this.update(ctx, (IObjectPK)new ObjectUuidPK(emplaborColl.get(i).getId()), emplaborColl.get(i));
            }
        }
    }

    private void setHisProbationField(Context ctx, EmpLaborRelationHisInfo info) throws EASBizException {
        if (info.getTryoutMonth() < 0) {
            info.setTryoutMonth(0);
        }
        if (info.getEnterDate() == null) {
            info.setPlanFormalDate(null);
        } else if (info.getTryoutMonth() > 0) {
            info.setPlanFormalDate(DateTimeUtils.addMonth((Date)info.getEnterDate(), (int)info.getTryoutMonth()));
        } else if (info.getPlanFormalDate() != null) {
            this.calTryoutMonth(info);
        }
    }

    private void calTryoutMonth(EmpLaborRelationHisInfo info) throws EASBizException {
        if (!DateTimeUtils.dayAfter((Date)info.getPlanFormalDate(), (Date)info.getEnterDate())) {
            throw new EmpLaborRelationException(EmpLaborRelationException.PLANFORMALDATE_MUST_AFTER_ENTERDATE);
        }
        int dateAdjustVal = DateTimeUtils.dayBefore((Date)info.getPlanFormalDate(), (Date)info.getEnterDate()) ? 1 : 0;
        int tryoutMonth = (DateTimeUtils.getYear((Date)info.getPlanFormalDate()) - DateTimeUtils.getYear((Date)info.getEnterDate())) * 12 + (DateTimeUtils.getMonth((Date)info.getPlanFormalDate()) - DateTimeUtils.getMonth((Date)info.getEnterDate())) - dateAdjustVal;
        info.setTryoutMonth(tryoutMonth);
    }

    private void checkEmpLaborRelationHis(Context ctx, EmpLaborRelationHisInfo info) throws BOSException, EASBizException {
        if (null == info.getEnterDate()) {
            return;
        }
        Date curDate = HRUtilExtend.getCurDateWithTruncated();
        if (DateTimeUtils.dayBefore((Date)curDate, (Date)info.getEnterDate())) {
            throw new EmpLaborRelationException(EmpLaborRelationException.TIME_AFTER_NOW);
        }
        StringBuffer oql = new StringBuffer();
        oql.append(" where person='").append(info.getPerson().getId().toString()).append("'");
        oql.append(" and careerId = '").append(info.getCareerId()).append("'");
        oql.append(" and isinner = 1");
        oql.append(" order by endDateTime asc");
        IEmpLaborRelationHis iEmpLaborRelationHis = EmpLaborRelationHisFactory.getLocalInstance(ctx);
        EmpLaborRelationHisCollection emplaborColl = iEmpLaborRelationHis.getEmpLaborRelationHisCollection(oql.toString());
        if (emplaborColl != null && emplaborColl.size() > 0) {
            Date maxLeffdt = this.getMaxLeffdt(emplaborColl);
            if (DateTimeUtils.dayAfter((Date)info.getEnterDate(), (Date)maxLeffdt)) {
                throw new EmpLaborRelationException(EmpLaborRelationException.TIME_AFTER_LEFFDT, new String[]{maxLeffdt.toString()});
            }
        }
        if (!"career1".equals(info.getCareerId()) && emplaborColl != null && emplaborColl.size() > 0 && DateTimeUtils.dayBefore((Date)info.getEnterDate(), (Date)emplaborColl.get(0).getEFFDT())) {
            throw new EmpLaborRelationException(EmpLaborRelationException.TIME_BEFORE_EFFDT, new String[]{emplaborColl.get(0).getEFFDT().toString()});
        }
        EmpPosOrgRelationCollection empPosColl = EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationCollection("select EFFDT,action.id,action.bizDefineType where person.id = '" + info.getPerson().getId().toString() + "' and isInner=1 and assignType=1 order by LEFFDT desc");
        if (empPosColl.size() > 1 && DateTimeUtils.dayAfter((Date)info.getEnterDate(), (Date)empPosColl.get(0).getEFFDT()) && !EmpLaborRelationControllerBean.isEnrollAgainAction(empPosColl.get(0).getAction())) {
            throw new EmpLaborRelationException(EmpLaborRelationException.ENTERDATE_CANT_AFTER_EMPPOS_EFFDT);
        }
    }

    private Date getMaxLeffdt(EmpLaborRelationHisCollection emplaborColl) {
        Date maxLeffdt = null;
        for (int i = 0; i < emplaborColl.size(); ++i) {
            Date leffdt = emplaborColl.get(i).getLEFFDT();
            if (maxLeffdt != null && !DateTimeUtils.dayAfter((Date)leffdt, (Date)maxLeffdt)) continue;
            maxLeffdt = leffdt;
        }
        return maxLeffdt;
    }
}

