/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.JobCategoryCollection;
import com.kingdee.eas.basedata.org.JobCategoryFactory;
import com.kingdee.eas.basedata.org.JobCategoryInfo;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.JobFamilyFactory;
import com.kingdee.eas.basedata.org.JobFamilyInfo;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.JobSubCategoryCollection;
import com.kingdee.eas.basedata.org.JobSubCategoryFactory;
import com.kingdee.eas.basedata.org.JobSubCategoryInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.AffairActionReasonFactory;
import com.kingdee.eas.hr.base.AffairActionReasonInfo;
import com.kingdee.eas.hr.base.AssignTypeEnum;
import com.kingdee.eas.hr.base.BaseBizException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFacadeFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.PositionStatuEnum;
import com.kingdee.eas.hr.base.VariationReasonFactory;
import com.kingdee.eas.hr.base.VariationReasonInfo;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.org.JobGradeCollection;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class EmpPorOrgRelationImport
extends AbstractDataTransmission {
    private static final String RESOURCE = "com.kingdee.eas.hr.emp.EmployeeInputResource";
    private static final String EMP_RESOURCE = "com.kingdee.eas.hr.base.EmpOrgPosImportResource";

    public CoreBaseInfo transmit(Hashtable importData, Context ctx) throws TaskExternalException {
        EmpPosOrgRelationCollection empPosOrgColl = new EmpPosOrgRelationCollection();
        EmpPosOrgRelationInfo result = new EmpPosOrgRelationInfo();
        int size = importData.size();
        for (int lineIndex = 0; lineIndex < size; ++lineIndex) {
            EmpPosOrgRelationInfo info = this.fillEmpPosOrgRelationInfo(importData, ctx, lineIndex);
            empPosOrgColl.add(info);
        }
        result.put("empPosColl", (Object)empPosOrgColl);
        return result;
    }

    protected EmpPosOrgRelationInfo fillEmpPosOrgRelationInfo(Hashtable importData, Context ctx, int lineIndex) throws TaskExternalException {
        Hashtable hsData = (Hashtable)importData.get(new Integer(lineIndex));
        EmpPosOrgRelationInfo info = new EmpPosOrgRelationInfo();
        info.setIsInner(false);
        String personNumber = (String)((DataToken)hsData.get((Object)"FPersonNumber")).data;
        try {
            Date effectDate;
            PersonInfo personInfo = HRUtilExtend.getPersonInfoByNumber(ctx, personNumber);
            if (personInfo == null) {
                throw new TaskExternalException(ResourceBase.getString((String)EMP_RESOURCE, (String)"NumberOfPersonNotExist", (Locale)ctx.getLocale()));
            }
            info.setPerson(personInfo);
            String txtVal = (String)((DataToken)hsData.get((Object)"FEFFDT")).data;
            if (!StringUtils.isEmpty((String)txtVal)) {
                effectDate = this.parseDate(txtVal, "yyyy-MM-dd", ctx);
                info.setEFFDT(effectDate);
            }
            if (!StringUtils.isEmpty((String)(txtVal = (String)((DataToken)hsData.get((Object)"FLEFFDT")).data))) {
                effectDate = this.parseDate(txtVal, "yyyy-MM-dd", ctx);
                info.setLEFFDT(effectDate);
            }
            txtVal = (String)((DataToken)hsData.get((Object)"FAdminOrgTxt")).data;
            info.setAdminOrgTxt(txtVal);
            txtVal = (String)((DataToken)hsData.get((Object)"FPositionTxt")).data;
            info.setPositionTxt(txtVal);
            if (hsData.get("FPositionNum") != null && !StringUtils.isEmpty((String)(txtVal = (String)((DataToken)hsData.get((Object)"FPositionNum")).data))) {
                PositionInfo position = this.getPositionInfo(ctx, txtVal);
                info.setPosition(position);
            }
            txtVal = (String)((DataToken)hsData.get((Object)"FCorporateunitTxt")).data;
            info.setCorporateunitTxt(txtVal);
            txtVal = (String)((DataToken)hsData.get((Object)"FEmployeeType")).data;
            if (!StringUtils.isEmpty((String)txtVal)) {
                info.setEmployeeType(this.getEmployeeTypeInfo(ctx, txtVal));
            }
            if ("1".equals(StringUtils.trim((String)(txtVal = (String)((DataToken)hsData.get((Object)"FAssignType")).data)))) {
                info.setAssignType(AssignTypeEnum.MAIN);
            } else if ("0".equals(StringUtils.trim((String)txtVal))) {
                info.setAssignType(AssignTypeEnum.PARTTIME);
            } else {
                throw new TaskExternalException(ResourceBase.getString((String)EMP_RESOURCE, (String)"AssignTypeInputError", (Locale)ctx.getLocale()));
            }
            txtVal = (String)((DataToken)hsData.get((Object)"FRemark")).data;
            info.setPositionstatus(PositionStatuEnum.Active);
            info.setRemark(txtVal);
            txtVal = (String)((DataToken)hsData.get((Object)"FAction")).data;
            if (!StringUtils.isEmpty((String)txtVal)) {
                info.setAction(this.getHRBizDefineInfo(ctx, txtVal));
            }
            if (!StringUtils.isEmpty((String)(txtVal = (String)((DataToken)hsData.get((Object)"FActionType")).data))) {
                info.setActionType(this.getAffairActionReasonIno(ctx, txtVal));
            }
            if ((DataToken)hsData.get("FJob_number") != null && !StringUtils.isEmpty((String)(txtVal = (String)((DataToken)hsData.get((Object)"FJob_number")).data))) {
                JobInfo jobInfo = this.getJobInfo(ctx, txtVal);
                info.setJob(jobInfo);
                info.setJobTxt(jobInfo.getName());
            }
            txtVal = (String)((DataToken)hsData.get((Object)"FJobTxt")).data;
            info.setJobTxt(txtVal);
            txtVal = (String)((DataToken)hsData.get((Object)"FActionReason")).data;
            if (!StringUtils.isEmpty((String)txtVal)) {
                info.setActionReason(this.getVariationReasonInfo(ctx, txtVal));
            }
            if ((DataToken)hsData.get("FJobFamily_number") != null && !StringUtils.isEmpty((String)(txtVal = (String)((DataToken)hsData.get((Object)"FJobFamily_number")).data))) {
                info.setJobFamily(this.getJobFamilyInfo(ctx, txtVal));
            }
            if ((DataToken)hsData.get("FJobCategory_number") != null && !StringUtils.isEmpty((String)(txtVal = (String)((DataToken)hsData.get((Object)"FJobCategory_number")).data))) {
                info.setJobCategory(this.getJobCategoryInfo(ctx, txtVal));
            }
            if ((DataToken)hsData.get("FJobSubCategory_number") != null && !StringUtils.isEmpty((String)(txtVal = (String)((DataToken)hsData.get((Object)"FJobSubCategory_number")).data))) {
                info.setJobSubCategory(this.getJobSubCategoryInfo(ctx, txtVal));
            }
            if ((DataToken)hsData.get("FJobGrade_number") != null && !StringUtils.isEmpty((String)(txtVal = (String)((DataToken)hsData.get((Object)"FJobGrade_number")).data))) {
                info.setJobGrade(this.getJobGradeInfo(ctx, txtVal));
            }
            if ((DataToken)hsData.get("FAdminOrg_number") != null && !StringUtils.isEmpty((String)(txtVal = (String)((DataToken)hsData.get((Object)"FAdminOrg_number")).data))) {
                info.setAdminOrg(this.getAdminOrgInfo(ctx, txtVal));
            }
            if ((DataToken)hsData.get("FPosition_number") != null && !StringUtils.isEmpty((String)(txtVal = (String)((DataToken)hsData.get((Object)"FPosition_number")).data))) {
                info.setPosition(this.getPositionInfo(ctx, txtVal));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (ParseException e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EmployeeInputResourceDATE_ERROR", (Locale)ctx.getLocale()), (Throwable)e);
        }
        return info;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        EmpPosOrgRelationCollection empColl = (EmpPosOrgRelationCollection)((Object)coreBaseInfo.get("empPosColl"));
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        boolean isAddNew = true;
        isAddNew = datataskMode == 8;
        try {
            EmpPosOrgRelationFacadeFactory.getLocalInstance(ctx).importEmpPosOrgRelation(empColl, isAddNew);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private Date parseDate(String date, String format, Context ctx) throws ParseException {
        try {
            return DateTimeUtils.parseDate((String)date, (String)format);
        }
        catch (ParseException pe) {
            throw new ParseException(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"69_EmployeeDataImport", (Locale)ctx.getLocale()) + format + "\"" + ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"70_EmployeeDataImport", (Locale)ctx.getLocale()) + date, -1);
        }
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EmpPosOrgRelationFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public String getMainField() {
        return "FPersonNumber";
    }

    public int getSubmitType() {
        return 1;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isInner", (Object)0, CompareType.EQUALS));
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.base.app.EmpPosOrgRelationInnerQuery";
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        HashMap<String, String[]> exportMap = new HashMap<String, String[]>();
        exportMap.put("queryFiled", new String[]{"person.number", "EFFDT", "LEFFDT", "corporateunitTxt", "adminOrgTxt", "positionTxt", "assignType", "remark"});
        exportMap.put("excelFiled", new String[]{"FPersonNumber", "FEFFDT", "FLEFFDT", "FCorporateunitTxt", "FAdminOrgTxt", "FPositionTxt", "FAssignType", "FRemark"});
        return this.transeExport(rs, exportMap);
    }

    private Hashtable transeExport(IRowSet rs, Map map) throws TaskExternalException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] queryFiled = (String[])map.get("queryFiled");
        String[] excelFiled = (String[])map.get("excelFiled");
        try {
            int size = queryFiled.length;
            for (int i = 0; i < size; ++i) {
                if (rs.getString(queryFiled[i]) == null) continue;
                hashtable.put(excelFiled[i], rs.getString(queryFiled[i]));
            }
        }
        catch (SQLException ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return hashtable;
    }

    private PositionInfo getPositionInfo(Context ctx, String number) throws BOSException {
        PositionInfo position = null;
        String oql = "select id,name where number ='" + number + "'";
        try {
            position = (PositionInfo)PositionFactory.getLocalInstance((Context)ctx).getDataBaseInfo(oql);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)((Object)new BaseBizException(BaseBizException.POSI_GET_WRONG)));
        }
        return position;
    }

    private EmployeeTypeInfo getEmployeeTypeInfo(Context ctx, String number) throws BOSException {
        EmployeeTypeInfo employeeTypeInfo = null;
        String oql = "select id,name where number ='" + number + "'";
        try {
            employeeTypeInfo = (EmployeeTypeInfo)EmployeeTypeFactory.getLocalInstance((Context)ctx).getDataBaseInfo(oql);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)((Object)new BaseBizException(BaseBizException.WORK_RELTION_GET_ERROR)));
        }
        return employeeTypeInfo;
    }

    private HRBizDefineInfo getHRBizDefineInfo(Context ctx, String number) throws BOSException {
        HRBizDefineInfo hrBizDefineInfo = null;
        String oql = "select id,name where number ='" + number + "'";
        try {
            hrBizDefineInfo = HRBizDefineFactory.getLocalInstance(ctx).getHRBizDefineInfo(oql);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)((Object)new BaseBizException(BaseBizException.CHANGE_OPTION_GET_ERROR)));
        }
        return hrBizDefineInfo;
    }

    private AffairActionReasonInfo getAffairActionReasonIno(Context ctx, String number) throws BOSException {
        AffairActionReasonInfo affairActionReasonInfo = null;
        String oql = "select id,name where number ='" + number + "'";
        try {
            affairActionReasonInfo = AffairActionReasonFactory.getLocalInstance(ctx).getAffairActionReasonInfo(oql);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)((Object)new BaseBizException(BaseBizException.CHANGE_TYPE_GET_ERROR)));
        }
        return affairActionReasonInfo;
    }

    private VariationReasonInfo getVariationReasonInfo(Context ctx, String number) throws BOSException {
        VariationReasonInfo variationReasonInfo = null;
        String oql = "select id,name where number ='" + number + "'";
        try {
            variationReasonInfo = VariationReasonFactory.getLocalInstance(ctx).getVariationReasonInfo(oql);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)((Object)new BaseBizException(BaseBizException.CHANGE_REASON_GET_ERROR)));
        }
        return variationReasonInfo;
    }

    private JobInfo getJobInfo(Context ctx, String number) throws BOSException {
        JobInfo jobInfo = null;
        String oql = "select id,name where number ='" + number + "'";
        try {
            jobInfo = JobFactory.getLocalInstance((Context)ctx).getJobInfo(oql);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)((Object)new BaseBizException(BaseBizException.POSI_GET_ERROR)));
        }
        return jobInfo;
    }

    private JobFamilyInfo getJobFamilyInfo(Context ctx, String number) throws BOSException {
        JobFamilyInfo jobFamilyInfo = null;
        String oql = "select id,name where number ='" + number + "'";
        try {
            jobFamilyInfo = JobFamilyFactory.getLocalInstance((Context)ctx).getJobFamilyInfo(oql);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)((Object)new BaseBizException(BaseBizException.POSI_FAMILY_ERROR)));
        }
        return jobFamilyInfo;
    }

    private JobCategoryInfo getJobCategoryInfo(Context ctx, String number) throws BOSException {
        JobCategoryInfo jobCategoryInfo = null;
        String oql = "select id,name where number ='" + number + "'";
        JobCategoryCollection jobCatColl = JobCategoryFactory.getLocalInstance((Context)ctx).getJobCategoryCollection(oql);
        if (jobCatColl.size() <= 0) {
            throw new BOSException((Throwable)((Object)new BaseBizException(BaseBizException.POSI_CLASS_ERROR)));
        }
        jobCategoryInfo = jobCatColl.get(0);
        return jobCategoryInfo;
    }

    private JobSubCategoryInfo getJobSubCategoryInfo(Context ctx, String number) throws BOSException {
        JobSubCategoryInfo jobSubCategoryInfo = null;
        String oql = "select id,name where number ='" + number + "'";
        JobSubCategoryCollection jobCatColl = JobSubCategoryFactory.getLocalInstance((Context)ctx).getJobSubCategoryCollection(oql);
        if (jobCatColl.size() <= 0) {
            throw new BOSException((Throwable)((Object)new BaseBizException(BaseBizException.POSI_CHILD_CLASS_GET_ERROR)));
        }
        jobSubCategoryInfo = jobCatColl.get(0);
        return jobSubCategoryInfo;
    }

    private JobGradeInfo getJobGradeInfo(Context ctx, String number) throws BOSException {
        JobGradeInfo jobGradeInfo = null;
        String oql = "select id,name where number ='" + number + "'";
        JobGradeCollection jobGradeColl = JobGradeFactory.getLocalInstance((Context)ctx).getJobGradeCollection(oql);
        if (jobGradeColl.size() <= 0) {
            throw new BOSException((Throwable)((Object)new BaseBizException(BaseBizException.GRADE_GET_ERROR)));
        }
        jobGradeInfo = jobGradeColl.get(0);
        return jobGradeInfo;
    }

    private AdminOrgUnitInfo getAdminOrgInfo(Context ctx, String number) throws BOSException {
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        String oql = "select id,name where number ='" + number + "'";
        AdminOrgUnitCollection adminOrgUnitColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(oql);
        if (adminOrgUnitColl.size() <= 0) {
            throw new BOSException((Throwable)((Object)new BaseBizException(BaseBizException.ORG_GET_ERROR)));
        }
        adminOrgUnitInfo = adminOrgUnitColl.get(0);
        return adminOrgUnitInfo;
    }
}

