/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonHisCollection;
import com.kingdee.eas.basedata.person.PersonHisFactory;
import com.kingdee.eas.basedata.person.PersonHisInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.app.update.UpdateAffairWaitingAuditedData;
import com.kingdee.eas.hr.base.AffairActioniOperateException;
import com.kingdee.eas.hr.base.AssignTypeEnum;
import com.kingdee.eas.hr.base.EmpFlowInOutCollection;
import com.kingdee.eas.hr.base.EmpFlowInOutFactory;
import com.kingdee.eas.hr.base.EmpFlowInOutInfo;
import com.kingdee.eas.hr.base.EmpHRORelationHisCollection;
import com.kingdee.eas.hr.base.EmpHRORelationHisFactory;
import com.kingdee.eas.hr.base.EmpHRORelationHisInfo;
import com.kingdee.eas.hr.base.EmpInfoSinglePageInfo;
import com.kingdee.eas.hr.base.EmpLaborRelationFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationHisCollection;
import com.kingdee.eas.hr.base.EmpLaborRelationHisFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationHisInfo;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmpPostExperienceHisCollection;
import com.kingdee.eas.hr.base.EmpPostExperienceHisFactory;
import com.kingdee.eas.hr.base.EmpPostExperienceHisInfo;
import com.kingdee.eas.hr.base.EmpSalaryAdjustmentCollection;
import com.kingdee.eas.hr.base.EmpSalaryAdjustmentFactory;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRAffairActionTransactionLogCollection;
import com.kingdee.eas.hr.base.HRAffairActionTransactionLogFactory;
import com.kingdee.eas.hr.base.HRAffairActionTransactionLogInfo;
import com.kingdee.eas.hr.base.HRBaseException;
import com.kingdee.eas.hr.base.HRBizData;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.IEmpFlowInOut;
import com.kingdee.eas.hr.base.IEmpHRORelationHis;
import com.kingdee.eas.hr.base.IEmpLaborRelation;
import com.kingdee.eas.hr.base.IEmpLaborRelationHis;
import com.kingdee.eas.hr.base.IEmpPosOrgRelation;
import com.kingdee.eas.hr.base.IEmpPostExperienceHis;
import com.kingdee.eas.hr.base.IEmpSalaryAdjustment;
import com.kingdee.eas.hr.base.SHRCheckRuleInfo;
import com.kingdee.eas.hr.base.app.AbstractEmpPosOrgRelationFacadeControllerBean;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationFacadeHelper;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.base.app.EmpPostExperienceHisHelper;
import com.kingdee.eas.hr.base.app.HRBizDefineManager;
import com.kingdee.eas.hr.base.app.RecoveryOtherEntityInfoManager;
import com.kingdee.eas.hr.base.app.his.HistoryVersionUtil;
import com.kingdee.eas.hr.base.app.update.UpdateEmpInnerWorkExpData;
import com.kingdee.eas.hr.base.app.update.UpdateEmpJobGrade;
import com.kingdee.eas.hr.base.app.update.UpdateEmpPosOrgRelationData;
import com.kingdee.eas.hr.base.app.util.HRBizDefineAffairUtils;
import com.kingdee.eas.hr.base.app.util.SHREmpPosOrgRelationDomainUtil;
import com.kingdee.eas.hr.base.check.CheckResultInfo;
import com.kingdee.eas.hr.base.check.SHRAffairActionCheckTool;
import com.kingdee.eas.hr.base.util.EmpPosOrgRelationUtil;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.EmpPosJobGradeRelationCollection;
import com.kingdee.eas.hr.emp.EmpPosJobGradeRelationFactory;
import com.kingdee.eas.hr.emp.EmpPosJobGradeRelationInfo;
import com.kingdee.eas.hr.emp.EmpPostRankCollection;
import com.kingdee.eas.hr.emp.EmpPostRankFactory;
import com.kingdee.eas.hr.emp.EmpPostRankInfo;
import com.kingdee.eas.hr.emp.EmployeeTypeEnum;
import com.kingdee.eas.hr.emp.IEmpPosJobGradeRelation;
import com.kingdee.eas.hr.emp.IEmpPostRank;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.IPersonPositionExtend;
import com.kingdee.eas.hr.emp.IPersonPositionExtendHIS;
import com.kingdee.eas.hr.emp.IPersonPositionHis;
import com.kingdee.eas.hr.emp.PersonOtherInfoCollection;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoHISCollection;
import com.kingdee.eas.hr.emp.PersonOtherInfoHISFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoHISInfo;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionExtendFactory;
import com.kingdee.eas.hr.emp.PersonPositionExtendHISCollection;
import com.kingdee.eas.hr.emp.PersonPositionExtendHISFactory;
import com.kingdee.eas.hr.emp.PersonPositionExtendHISInfo;
import com.kingdee.eas.hr.emp.PersonPositionExtendInfo;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionHisCollection;
import com.kingdee.eas.hr.emp.PersonPositionHisFactory;
import com.kingdee.eas.hr.emp.PersonPositionHisInfo;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.app.util.EmpPostRankUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptBizManageTool;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptPersonPositionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.HRBizDefineTypeEnum;
import com.kingdee.shr.base.bizmanage.ISHRBizManageMsgManage;
import com.kingdee.shr.base.bizmanage.PersonBURelaConfirmCollection;
import com.kingdee.shr.base.bizmanage.PersonBURelaConfirmFactory;
import com.kingdee.shr.base.bizmanage.PersonBizManageFacadeFactory;
import com.kingdee.shr.base.bizmanage.PersonChangeMsgCollection;
import com.kingdee.shr.base.bizmanage.PersonChangeMsgFactory;
import com.kingdee.shr.base.bizmanage.PersonChangeMsgInfo;
import com.kingdee.shr.base.bizmanage.SHRBizManageMsgManageFactory;
import com.kingdee.shr.base.bizmanage.app.PersonBizManageFacadeControllerBean;
import com.kingdee.shr.base.bizmanage.constant.BizManageMsgConstants;
import com.kingdee.shr.base.bizmanage.constant.CommonConstants;
import com.kingdee.shr.base.bizmanage.util.SHRBizManageCommonTool;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EmpPosOrgRelationFacadeControllerBean
extends AbstractEmpPosOrgRelationFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.EmpPosOrgRelationFacadeControllerBean");

    @Override
    protected IObjectCollection _getAffairRelateEmpPosOrgRelation(Context ctx, String affairEntryID, String personID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personID) || StringUtils.isEmpty((String)affairEntryID)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
        filterInfo.getFilterItems().add(new FilterItemInfo("flowInAffairID", (Object)affairEntryID));
        filterInfo.getFilterItems().add(new FilterItemInfo("flowOutAffairID", (Object)affairEntryID));
        filterInfo.setMaskString("#0 and (#1 or #2)");
        view.setFilter(filterInfo);
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        view.setSelector(helper.getSelector());
        SorterItemCollection sortCollection = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("startDateTime");
        sortInfo.setSortType(SortType.DESCEND);
        sortCollection.add(sortInfo);
        sortInfo = new SorterItemInfo("assignType");
        sortInfo.setSortType(SortType.DESCEND);
        sortCollection.add(sortInfo);
        sortInfo = new SorterItemInfo("positionstatus");
        sortInfo.setSortType(SortType.DESCEND);
        sortCollection.add(sortInfo);
        view.setSorter(sortCollection);
        return EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationCollection(view);
    }

    @Override
    protected IObjectCollection _getStartDateAfterAppointDateRecord(Context ctx, String personID, Date appointDate) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personID) || appointDate == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
        filterInfo.getFilterItems().add(new FilterItemInfo("isInner", (Object)new Integer(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("assignType", (Object)AssignTypeEnum.MAIN));
        filterInfo.getFilterItems().add(new FilterItemInfo("startDateTime", (Object)appointDate, CompareType.GREATER));
        filterInfo.setMaskString("#0 and #1 and #2 and #3");
        view.setFilter(filterInfo);
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        view.setSelector(helper.getSelector());
        SorterItemCollection sortCollection = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("startDateTime");
        sortInfo.setSortType(SortType.DESCEND);
        sortCollection.add(sortInfo);
        view.setSorter(sortCollection);
        return EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationCollection(view);
    }

    @Override
    protected void _recoveryEmpPosOrgRelation(Context ctx, IObjectCollection empPosOrgRelCollection, String affairEntryID) throws BOSException, EASBizException {
        int i;
        EmpPosOrgRelationInfo info = null;
        EmpPosOrgRelationCollection empPosOrgRelColl = (EmpPosOrgRelationCollection)empPosOrgRelCollection;
        EmpPosOrgRelationFacadeHelper.recoveryEmpFlowInOut(ctx, empPosOrgRelColl.get(0).getPerson().getId().toString(), affairEntryID);
        EmpPosOrgRelationCollection flowInColl = new EmpPosOrgRelationCollection();
        EmpPosOrgRelationCollection modifyColl = new EmpPosOrgRelationCollection();
        for (i = 0; i < empPosOrgRelColl.size(); ++i) {
            info = empPosOrgRelColl.get(i);
            if (affairEntryID.equals(info.getFlowInAffairID())) {
                flowInColl.add(info);
                continue;
            }
            modifyColl.add(info);
        }
        for (i = 0; i < flowInColl.size(); ++i) {
            info = flowInColl.get(i);
            EmpPosOrgRelationFacadeHelper.recoveryEmpPostExp(ctx, info, "IN_TYPE");
            if (AssignTypeEnum.MAIN.equals((Object)info.getAssignType())) {
                EmpPosOrgRelationFacadeHelper.recoveryEmpLaborRelation(ctx, info, "IN_TYPE");
                EmpPosOrgRelationFacadeHelper.recoveryPersonPosition(ctx, info, "IN_TYPE");
                EmpPosOrgRelationFacadeHelper.recoveryEmpPostRank(ctx, info, "IN_TYPE");
                EmpPosOrgRelationFacadeHelper.recoveryPersonHis(ctx, info);
                EmpPosOrgRelationFacadeHelper.recoveryPersonOtherInfo(ctx, info);
                EmpPosOrgRelationFacadeHelper.recoveryPersonAndHis(ctx, info, affairEntryID, "IN_TYPE");
            }
            if (info.getPositionstatus().getValue() > 0) {
                EmpPosOrgRelationFacadeHelper.deletePositionMember(ctx, info);
            }
            EmpPosOrgRelationFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(info.getId()));
        }
        for (i = 0; i < modifyColl.size(); ++i) {
            info = modifyColl.get(i);
            if (AssignTypeEnum.MAIN.equals((Object)info.getAssignType())) {
                EmpPosOrgRelationFacadeHelper.recoveryEmpLaborRelation(ctx, info, "OUT_TYPE");
                EmpPosOrgRelationFacadeHelper.recoveryPersonPosition(ctx, info, "OUT_TYPE");
                EmpPosOrgRelationFacadeHelper.recoveryEmpPostRank(ctx, info, "OUT_TYPE");
                EmpPosOrgRelationFacadeHelper.recoveryPersonAndHis(ctx, info, affairEntryID, "OUT_TYPE");
            }
            EmpPosOrgRelationFacadeHelper.recoveryEmpPostExp(ctx, info, "OUT_TYPE");
            SHREmpPosOrgRelationDomainUtil.addNewPositionMember(ctx, info);
            this.modifyEmpPosOrgRelation(ctx, info);
        }
        RecoveryOtherEntityInfoManager.recoveryPageContractInfo(ctx, empPosOrgRelColl.get(0));
    }

    private void modifyEmpPosOrgRelation(Context ctx, EmpPosOrgRelationInfo info) throws EASBizException, BOSException {
        info.setLEFFDT(HRUtil.getMaxEndDate());
        info.setEndDateTime(HistoryVersionUtil.getMaxEndDate());
        info.setIsLatestInAday(true);
        info.setFlowOutAffairID(null);
        EmpPosOrgRelationFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
    }

    @Override
    protected IObjectValue _getAppointDateMainlineRecord(Context ctx, String personID, Date appointDate) throws BOSException, EASBizException {
        appointDate = DateTimeUtils.truncateDate((Date)appointDate);
        FilterInfo filterInfo = new FilterInfo();
        EntityViewInfo view = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
        filterInfo.getFilterItems().add(new FilterItemInfo("assignType", (Object)new Integer(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo(HistoryConstant.EFFDT, (Object)appointDate, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)appointDate, CompareType.GREATER_EQUALS));
        filterInfo.setMaskString("#0 and #1 and #2 and #3 ");
        view.setFilter(filterInfo);
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        view.setSelector(helper.getSelector());
        EmpPosOrgRelationCollection empPosOrgRelColl = EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationCollection(view);
        if (empPosOrgRelColl == null || empPosOrgRelColl.size() == 0) {
            return null;
        }
        return empPosOrgRelColl.get(0);
    }

    @Override
    protected void _operateHRBizDefine(Context ctx, HRBizData hrBizData) throws BOSException, EASBizException {
        HRBizDefineManager manager = new HRBizDefineManager();
        HRBizDefineAffairUtils.validateBizData(ctx, hrBizData);
        this.checkCompulsoryRule(ctx, hrBizData);
        manager.process(ctx, hrBizData);
    }

    private void checkCompulsoryRule(Context ctx, HRBizData hrBizData) throws BOSException, EASBizException, HRBaseException {
        int bizDefineType = 0;
        if (hrBizData.getHrbizDefine().getBizDefineType() == null) {
            HRBizDefineInfo bizDefineInfo = HRBizDefineFactory.getLocalInstance(ctx).getHRBizDefineInfo((IObjectPK)new ObjectUuidPK(hrBizData.getHrbizDefine().getId().toString()));
            bizDefineType = bizDefineInfo.getBizDefineType().getValue();
        } else {
            bizDefineType = hrBizData.getHrbizDefine().getBizDefineType().getValue();
        }
        CheckResultInfo checkResultInfo = SHRAffairActionCheckTool.checkCompulsoryRule(ctx, hrBizData, bizDefineType);
        List errorMsgRuleList = checkResultInfo.getErrorMsgRuleList();
        StringBuffer errorInfo = new StringBuffer();
        if (errorMsgRuleList != null) {
            int size = errorMsgRuleList.size();
            for (int i = 0; i < size; ++i) {
                SHRCheckRuleInfo ruleInfo = (SHRCheckRuleInfo)errorMsgRuleList.get(i);
                if (i == 0) {
                    errorInfo.append(ruleInfo.getRuleDescription());
                    continue;
                }
                errorInfo.append(";").append(ruleInfo.getRuleDescription());
            }
            if (errorMsgRuleList.size() > 0) {
                Object[] msg = new String[]{errorInfo.toString()};
                throw new HRBaseException(HRBaseException.PERSONPLANISOVER, msg);
            }
        }
    }

    @Override
    protected IObjectValue _getEmpPosOrgRelationValue(Context ctx, String recordID) throws BOSException, EASBizException {
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        return EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationInfo((IObjectPK)new ObjectUuidPK(recordID), helper.getSelector());
    }

    @Override
    protected IObjectValue _getEmpPosOrgRelationByPositionAndDate(Context ctx, String personID, String positionID, String adminID, Date appointDate) throws BOSException, EASBizException {
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        return helper.getSamePositionActiveRecord(ctx, personID, positionID, adminID, appointDate);
    }

    @Override
    protected IObjectValue _getAppointDatePrimaryActiveRecord(Context ctx, String personID, Date appointDate) throws BOSException, EASBizException {
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        EmpPosOrgRelationCollection empposorgRelationColl = helper.getAppointDateActivePrimaryPosition(ctx, personID, appointDate);
        if (empposorgRelationColl != null && empposorgRelationColl.size() > 0) {
            if (empposorgRelationColl.size() > 1) {
                throw new AffairActioniOperateException(AffairActioniOperateException.TWOPRIMARYPOSITIONEXIST);
            }
            return empposorgRelationColl.get(0);
        }
        return null;
    }

    @Override
    protected void _versionUpdate(Context ctx) throws BOSException, EASBizException {
        UpdateEmpPosOrgRelationData updater = new UpdateEmpPosOrgRelationData();
        updater.update(ctx);
        UpdateAffairWaitingAuditedData updateAffair = new UpdateAffairWaitingAuditedData();
        updateAffair.update(ctx);
        UpdateEmpJobGrade jobGradeUpdater = new UpdateEmpJobGrade();
        jobGradeUpdater.update(ctx);
        UpdateEmpInnerWorkExpData workExpDate = new UpdateEmpInnerWorkExpData();
        workExpDate.update(ctx);
    }

    @Override
    protected IObjectValue _getCurrentMainlinePositon(Context ctx, String personID) throws BOSException, EASBizException {
        return this._getAppointDatePrimaryActiveRecord(ctx, personID, new Date());
    }

    @Override
    protected EmpPosOrgRelationCollection _getCurrentMainlinePositonCollection(Context ctx, Set personIdSet) throws BOSException, EASBizException {
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        EmpPosOrgRelationCollection empposorgRelationColl = helper.getAppointDateActiveMainlinePosition(ctx, personIdSet, new Date());
        return empposorgRelationColl;
    }

    @Override
    protected EmpPosOrgRelationCollection _getAllEmpPosOrgRelationOfPerson(Context ctx, String personId) throws BOSException, EASBizException {
        CoreBaseCollection otherColl;
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        EmpPosOrgRelationCollection coll = helper.getPersonAllEmpPosRelation(ctx, personId);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            EmpPosOrgRelationInfo info = coll.get(0);
            info.setAdminOrgTxt(info.getAdminOrg().getDisplayName());
            info.setPositionTxt(info.getPosition().getName());
            info.setCorporateunitTxt(info.getLaborRelation().getCorporateunit().getName());
        }
        try {
            otherColl = EmpPosOrgRelationUtil.getOtherEmpPosOrgRelationCollection(ctx, personId, null);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        coll.addObjectCollection((IObjectCollection)otherColl);
        return coll;
    }

    @Override
    protected void _importEmpPosOrgRelation(Context ctx, EmpPosOrgRelationCollection empPosColl, boolean isAddNew) throws BOSException, EASBizException {
        IEmpPosOrgRelation iEmpPosOrgRelation = EmpPosOrgRelationFactory.getLocalInstance(ctx);
        if (!isAddNew && empPosColl.size() > 0) {
            String personId = empPosColl.get(0).getPerson().getId().toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
            filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)false));
            iEmpPosOrgRelation.delete(filter);
        }
        int size = empPosColl.size();
        for (int i = 0; i < size; ++i) {
            iEmpPosOrgRelation.addnew((CoreBaseInfo)empPosColl.get(i));
        }
    }

    @Override
    protected String _updateInnerEmpPosOrgRelation(Context ctx, EmpPosOrgRelationInfo info) throws BOSException, EASBizException {
        String retMsg = null;
        EmpPosOrgRelationInfo oldInfo = EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationInfo("select *,laborRelation.laborRelationState.id,person.name where id = '" + info.getId().toString() + "'");
        info.getLaborRelation().setId(oldInfo.getLaborRelation().getId());
        info.setHrOrgUnit(SHREmpOptBizManageTool.getManageHROByAdminOrg((Context)ctx, (String)info.getAdminOrg().getId().toString()));
        AdminOrgUnitCollection orgColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("select company.id where id = '" + info.getAdminOrg().getId().toString() + "'");
        if (orgColl.size() > 0) {
            info.setCompany(orgColl.get(0).getCompany());
        }
        info.setFlowInAffairID(oldInfo.getFlowInAffairID());
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setStartDateTime(info.getEFFDT());
        info.setEndDateTime(HistoryVersionUtil.getMaxEndDate());
        info.setLEFFDT(HRUtil.getMaxEndDate());
        info.setRemark(this.getAdjustEnrollMsg(ctx, oldInfo, info));
        EmpPosOrgRelationFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId().toString()), (CoreBaseInfo)info);
        this.doWithCurrentFlowInfo(ctx, info);
        if (!DateTimeUtils.dayEquals((Date)info.getLEFFDT(), (Date)HRUtil.getMaxEndDate())) {
            this.doWithFlowIn(ctx, info);
        }
        if (oldInfo.getAssignType() == AssignTypeEnum.MAIN) {
            this.updateEmpLaborRelation(ctx, info, oldInfo);
            this.updatePosMemAndPersonPosition(ctx, info, oldInfo);
            EmpPostExperienceHisHelper.updateEmpPostExp(ctx, oldInfo, info);
            EmpPostRankUtil.updateEmpPosRankByEmpOrgRela((Context)ctx, (EmpPosOrgRelationInfo)info, (EmpPosOrgRelationInfo)oldInfo);
            this.updateEmployeeTypeOfPerson(ctx, info, oldInfo, info.getLaborRelation());
            retMsg = this.updateEnrollErrorRelatedBizDate(ctx, info, oldInfo);
            this.updatePersonPositionExtend(ctx, info, oldInfo);
            this.updateHRAffairActionLogInfo(ctx, info, oldInfo);
        }
        ArrayList<String> empRelaIdList = new ArrayList<String>();
        empRelaIdList.add(info.getId().toString());
        if (!info.getBoolean("flag")) {
            this._modifyPersonBizManageForErrorEnroll(ctx, info);
        }
        this.updateEmpSalaryAdjustment(ctx, info, oldInfo);
        return retMsg;
    }

    protected void updateEmpSalaryAdjustment(Context ctx, EmpPosOrgRelationInfo newInfo, EmpPosOrgRelationInfo oldInfo) throws BOSException, EASBizException {
        IEmpSalaryAdjustment empSalaryAdjustmentService = EmpSalaryAdjustmentFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String personId = oldInfo.getPerson().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("affairId", (Object)oldInfo.getFlowInAffairID(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("effect", (Object)oldInfo.getEFFDT(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        EmpSalaryAdjustmentCollection empSalaryAdjustmentCollection = empSalaryAdjustmentService.getEmpSalaryAdjustmentCollection(viewInfo);
        if (empSalaryAdjustmentCollection != null && empSalaryAdjustmentCollection.size() > 0) {
            String sql = "update T_HR_EmpSalaryAdjustment set FEffect = ? , FSalaryDealState = ? , FIsAdjust = ? where FPersonId = ? and FAffairId = ? and FEffect = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{newInfo.getEFFDT(), 0, 1, personId, oldInfo.getFlowInAffairID(), oldInfo.getEFFDT()});
        }
    }

    private void updateHRAffairActionLogInfo(Context ctx, EmpPosOrgRelationInfo info, EmpPosOrgRelationInfo oldInfo) throws BOSException, EASBizException {
        HRAffairActionTransactionLogCollection coll;
        if (!StringUtils.isEmpty((String)oldInfo.getFlowInAffairID()) && (coll = HRAffairActionTransactionLogFactory.getLocalInstance(ctx).getHRAffairActionTransactionLogCollection("where affairEntryID = '" + oldInfo.getFlowInAffairID() + "'")).size() > 0) {
            HRAffairActionTransactionLogInfo logInfo = coll.get(0);
            logInfo.setNumber("ENROLL_MODIFY");
            logInfo.setLastUpdateTime(info.getLastUpdateTime());
            HRAffairActionTransactionLogFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(logInfo.getId()), (CoreBaseInfo)logInfo);
        }
    }

    private String getAdjustEnrollMsg(Context ctx, EmpPosOrgRelationInfo oldInfo, EmpPosOrgRelationInfo info) throws EASBizException, BOSException {
        StringBuilder adjustEnrollMsg = new StringBuilder(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label135", (Context)ctx));
        if (!DateTimeUtils.dayEquals((Date)oldInfo.getEFFDT(), (Date)info.getEFFDT())) {
            adjustEnrollMsg.append(MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label144", (Context)ctx), HRUtilExtend.getDateStringWithoutMininute(info.getEFFDT())));
        }
        if (!oldInfo.getPosition().getId().toString().equals(info.getPosition().getId().toString())) {
            if (info.getPosition().getName() == null) {
                info.setPosition(PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(info.getPosition().getId())));
            }
            adjustEnrollMsg.append(MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label145", (Context)ctx), info.getPosition().getName()));
        }
        if (!oldInfo.getLaborRelation().getLaborRelationState().getId().toString().equals(info.getLaborRelation().getLaborRelationState().getId().toString())) {
            EmployeeTypeInfo emptype = info.getLaborRelation().getLaborRelationState();
            if (emptype.getName() == null) {
                emptype = EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeInfo((IObjectPK)new ObjectUuidPK(emptype.getId()));
            }
            adjustEnrollMsg.append(MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label146", (Context)ctx), emptype.getName()));
        }
        return adjustEnrollMsg.substring(0, adjustEnrollMsg.length() - 1);
    }

    private String updateEnrollErrorRelatedBizDate(Context ctx, EmpPosOrgRelationInfo info, EmpPosOrgRelationInfo oldInfo) throws BOSException, EASBizException {
        String personId = info.getPerson().getId().toString();
        PersonHisCollection personHisColl = PersonHisFactory.getLocalInstance((Context)ctx).getPersonHisCollection("where historyRelateID = '" + personId + "' order by EFFDT ASC");
        PersonPositionCollection ppColl = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection("where person.id = '" + personId + "'");
        EmpLaborRelationInfo laborInfo = EmpLaborRelationFactory.getLocalInstance(ctx).getEmpLaborRelationInfo((IObjectPK)new ObjectUuidPK(oldInfo.getLaborRelation().getId()));
        Date empPosEFFDT = oldInfo.getEFFDT();
        Date personEFFDT = personHisColl.get(0).getEFFDT();
        Date ppJoinGroupDate = ppColl.get(0).getJoinGroupDate();
        Date ppJoinGroupDateCur = ppColl.get(0).getJoinGroupDateCur();
        Date ppJoinDate = ppColl.get(0).getJoinDate();
        Date enterDate = laborInfo.getEnterDate();
        PersonHisInfo pHisInfo = null;
        if (personHisColl.size() > 1 && (DateTimeUtils.dayBefore((Date)(pHisInfo = personHisColl.get(1)).getEFFDT(), (Date)info.getEFFDT()) || DateTimeUtils.dayEquals((Date)pHisInfo.getEFFDT(), (Date)info.getEFFDT()))) {
            throw new EmpPosOrgRelationException(EmpPosOrgRelationException.ADJUSTDATE_CANT_AFTER_AFTERCHANGE_EFFDT, new Object[]{HRUtilExtend.getDateStringWithoutMininute(pHisInfo.getEFFDT())});
        }
        pHisInfo = personHisColl.get(0);
        if (!(!DateTimeUtils.dayEquals((Date)empPosEFFDT, (Date)personEFFDT) || enterDate != null && !DateTimeUtils.dayEquals((Date)empPosEFFDT, (Date)enterDate) || ppJoinGroupDate != null && !DateTimeUtils.dayEquals((Date)empPosEFFDT, (Date)ppJoinGroupDate) || ppJoinGroupDateCur != null && !DateTimeUtils.dayEquals((Date)empPosEFFDT, (Date)ppJoinGroupDateCur) || ppJoinDate != null && !DateTimeUtils.dayEquals((Date)empPosEFFDT, (Date)ppJoinDate))) {
            pHisInfo.setEFFDT(info.getEFFDT());
            PersonHisFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(pHisInfo.getId()), (CoreBaseInfo)pHisInfo);
            this.updatePersonCurrent(ctx, info);
            PersonPositionInfo ppInfo = ppColl.get(0);
            ppInfo.setEFFDT(info.getEFFDT());
            ppInfo.setStartDateTime(info.getStartDateTime());
            ppInfo.setJoinGroupDate(info.getEFFDT());
            ppInfo.setJoinGroupDateCur(info.getEFFDT());
            ppInfo.setJoinDate(info.getEFFDT());
            float joinGroupYears = SHREmpOptPersonPositionUtil.calWorkTimeYears((Context)ctx, (Date)ppInfo.getEFFDT(), (Date)new Date(), (float)ppInfo.getAdjustGroupVal());
            ppInfo.setJoinGroupYears(joinGroupYears);
            float joinGroupCurYears = SHREmpOptPersonPositionUtil.calWorkTimeYears((Context)ctx, (Date)ppInfo.getEFFDT(), (Date)new Date(), (float)ppInfo.getAdjustGroupCurVal());
            ppInfo.setJoinGroupCurYears(joinGroupCurYears);
            ppInfo.setJoinCompanyYears(SHREmpOptPersonPositionUtil.calWorkTimeYears((Context)ctx, (Date)info.getEFFDT(), (Date)ppInfo.getLeftCompanyDate(), (float)ppInfo.getAdjustCoValue()));
            PersonPositionFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(ppInfo.getId()), (EmpInfoSinglePageInfo)ppInfo);
            PersonPositionHisInfo ppHisInfo = PersonPositionHisFactory.getLocalInstance((Context)ctx).getPersonPositionHisCollection("where person.id = '" + personId + "' order by startDateTime DESC").get(0);
            ppHisInfo.setEFFDT(info.getEFFDT());
            ppHisInfo.setStartDateTime(info.getStartDateTime());
            ppHisInfo.setJoinGroupDate(info.getEFFDT());
            ppHisInfo.setJoinGroupDateCur(info.getEFFDT());
            ppHisInfo.setJoinDate(info.getEFFDT());
            ppHisInfo.setJoinGroupYears(joinGroupYears);
            ppHisInfo.setJoinCompanyYears(SHREmpOptPersonPositionUtil.calWorkTimeYears((Context)ctx, (Date)info.getEFFDT(), (Date)ppHisInfo.getLeftCompanyDate(), (float)ppInfo.getAdjustCoValue()));
            PersonPositionHisFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(ppHisInfo.getId()), (EmpInfoSinglePageInfo)ppHisInfo);
            this.updatePersonOtherInfoEffdt(ctx, info, personId);
            laborInfo.setEFFDT(info.getEFFDT());
            laborInfo.setStartDateTime(info.getStartDateTime());
            laborInfo.setEnterDate(info.getEFFDT());
            if (laborInfo.getTryoutMonth() != 0) {
                laborInfo.setPlanFormalDate(DateTimeUtils.addMonth((Date)laborInfo.getEnterDate(), (int)laborInfo.getTryoutMonth()));
            }
            EmpLaborRelationFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(laborInfo.getId()), laborInfo);
            EmpLaborRelationHisInfo laborHisInfo = EmpLaborRelationHisFactory.getLocalInstance(ctx).getEmpLaborRelationHisCollection("where person.id = '" + personId + "' order by startDateTime DESC").get(0);
            laborHisInfo.setEFFDT(info.getEFFDT());
            laborHisInfo.setStartDateTime(info.getStartDateTime());
            laborHisInfo.setEnterDate(info.getEFFDT());
            laborHisInfo.setPlanFormalDate(laborInfo.getPlanFormalDate());
            EmpLaborRelationHisFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(laborHisInfo.getId()), laborHisInfo);
            String updatePersonHireDateSql = "update T_BD_PERSON set FHIREDATE = ? where FID = ?";
            DbUtil.execute((Context)ctx, (String)updatePersonHireDateSql.toString(), (Object[])new Object[]{laborHisInfo.getEnterDate(), laborHisInfo.getPerson().getId().toString()});
            String updatePersonHisHireDateSql = "update T_BD_PERSONHIS  set FHIREDATE = ? where FHISTORYRELATEID = ? and FLEFFDT = {ts'2199-12-31 00:00:00'}";
            DbUtil.execute((Context)ctx, (String)updatePersonHisHireDateSql.toString(), (Object[])new Object[]{laborHisInfo.getEnterDate(), laborHisInfo.getPerson().getId().toString()});
            return null;
        }
        logger.error((Object)("SHRServerResource.getString--->" + SHRServerResource.getString((String)"com.kingdee.eas.hr.base.EmpPosOrgRelationResource", (String)"PLS_MODIFY_DATE_MANUALLY", (Locale)ctx.getLocale())));
        logger.error((Object)("ctx.getLocale()--->" + ctx.getLocale().getLanguage() + "    Locale.getDefault()--->" + Locale.getDefault().getLanguage()));
        return ResourceBase.getString((String)"com.kingdee.eas.hr.base.EmpPosOrgRelationResource", (String)"PLS_MODIFY_DATE_MANUALLY", (Locale)ctx.getLocale());
    }

    private void updatePersonOtherInfoEffdt(Context ctx, EmpPosOrgRelationInfo info, String personId) throws BOSException, EASBizException {
        PersonOtherInfoHISCollection personOtherHISColl;
        PersonOtherInfoCollection personOtherColl = PersonOtherInfoFactory.getLocalInstance((Context)ctx).getPersonOtherInfoCollection("where person.id = '" + personId + "'");
        if (personOtherColl != null && personOtherColl.size() > 0) {
            PersonOtherInfoInfo personOtherInfo = personOtherColl.get(0);
            personOtherInfo.setEFFDT(info.getEFFDT());
            PersonOtherInfoFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(personOtherInfo.getId()), (CoreBaseInfo)personOtherInfo);
        }
        if ((personOtherHISColl = PersonOtherInfoHISFactory.getLocalInstance((Context)ctx).getPersonOtherInfoHISCollection("where person.id = '" + personId + "' order by EFFDT DESC")) != null && personOtherHISColl.size() > 0) {
            PersonOtherInfoHISInfo personOtherInfohis = personOtherHISColl.get(0);
            personOtherInfohis.setEFFDT(info.getEFFDT());
            PersonOtherInfoHISFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(personOtherInfohis.getId()), (CoreBaseInfo)personOtherInfohis);
        }
    }

    private void updatePersonCurrent(Context ctx, EmpPosOrgRelationInfo info) throws BOSException, EASBizException {
        String personId = info.getPerson().getId().toString();
        StringBuilder sql = new StringBuilder("select top 1 FEFFDT,FLastUpdateUserId,FLastUpdateTime from T_BD_PersonHis where FHistoryRelateId='").append(personId).append("' order by FEFFDT DESC");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                sql = new StringBuilder("update T_BD_Person set FEFFDT = ?,FLastUpdateUserId = ?,FLastUpdateTime = ? where Fid = '").append(personId).append("'");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{rs.getDate("FEFFDT"), rs.getString("FLastUpdateUserId"), rs.getDate("FLastUpdateTime")});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private void updatePosMemAndPersonPosition(Context ctx, EmpPosOrgRelationInfo info, EmpPosOrgRelationInfo oldInfo) throws BOSException, EASBizException {
        EmployeeTypeInfo employeeTypeInfo;
        if (!info.isIsInner() || oldInfo.getAssignType() == AssignTypeEnum.PARTTIME) {
            return;
        }
        String lastUpdateTime = HRUtilExtend.getDateStringWithMinuteTs(new Date(info.getLastUpdateTime().getTime()));
        StringBuffer sql = new StringBuffer();
        String personId = info.getPerson().getId().toString();
        String positionId = info.getPosition().getId().toString();
        if (PositionMemberFactory.getLocalInstance((Context)ctx).exists("where person='" + personId + "'")) {
            if (null != info.getLaborRelation() && null != info.getLaborRelation().getLaborRelationState()) {
                employeeTypeInfo = EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeInfo((IObjectPK)new ObjectUuidPK(info.getLaborRelation().getLaborRelationState().getId()));
                if (null != employeeTypeInfo && (EmployeeTypeEnum.DIMISSION.equals((Object)employeeTypeInfo.getInService()) || EmployeeTypeEnum.RETIRE.equals((Object)employeeTypeInfo.getInService()))) {
                    PositionMemberFactory.getLocalInstance((Context)ctx).delete("where person='" + personId + "'");
                    StringBuffer noPos = new StringBuffer("update t_bd_person set fgkadmin = '");
                    noPos.append(info.getAdminOrg().getId().toString()).append("'").append(" where fid ='").append(personId).append("'").append(";");
                    DbUtil.execute((Context)ctx, (String)noPos.toString());
                } else {
                    sql.append("update T_ORG_PositionMember set FPositionID='").append(positionId).append("' ,FHROrgUnitId='").append(info.getHrOrgUnit().getId()).append("' ,FLastUpdateTime=").append(lastUpdateTime).append(" ,FLastUpdateUserID='").append(info.getLastUpdateUser().getId().toString()).append("' where FPersonID='").append(personId).append("'").append(" and FPositionID='").append(oldInfo.getPosition().getId().toString()).append("'");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                }
            }
        } else if (null != info.getLaborRelation() && null != info.getLaborRelation().getLaborRelationState() && null != (employeeTypeInfo = EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeInfo((IObjectPK)new ObjectUuidPK(info.getLaborRelation().getLaborRelationState().getId()))) && !EmployeeTypeEnum.DIMISSION.equals((Object)employeeTypeInfo.getInService()) && !EmployeeTypeEnum.RETIRE.equals((Object)employeeTypeInfo.getInService())) {
            PositionMemberInfo positionMember = new PositionMemberInfo();
            positionMember.setPosition(info.getPosition());
            positionMember.setPerson(info.getPerson());
            positionMember.setHrOrgUnit(info.getHrOrgUnit());
            PositionMemberFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)positionMember);
        }
        sql = new StringBuffer();
        String oldEffdt = HRUtilExtend.getDateStringWithoutMininuteTs(oldInfo.getEFFDT());
        String newEffdt = HRUtilExtend.getDateStringWithoutMininuteTs(info.getEFFDT());
        if (info.getCompany() != null) {
            sql.append("update T_HR_PersonPosition set FPrimaryPositionID='").append(positionId).append("' ,FPersonDep='").append(info.getAdminOrg().getId()).append("' ,FCompanyId='").append(info.getCompany().getId()).append("' ,FHROrgUnitId='").append(info.getHrOrgUnit().getId()).append("' ,FLastUpdateTime=").append(lastUpdateTime).append(" ,FLastUpdateUserID='").append(info.getLastUpdateUser().getId().toString()).append("' where FPersonID='").append(personId).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        if (info.getCompany() != null) {
            sql = new StringBuffer();
            sql.append("update T_HR_PersonPositionHis set FPrimaryPositionID='").append(positionId).append("' ,FPersonDep='").append(info.getAdminOrg().getId()).append("' ,FCompanyId='").append(info.getCompany().getId()).append("' ,FHROrgUnitId='").append(info.getHrOrgUnit().getId()).append("' ,FLastUpdateTime=").append(lastUpdateTime).append(" ,FLastUpdateUserID='").append(info.getLastUpdateUser().getId().toString()).append("' where FPersonID='").append(personId).append("'").append(" and FisInner=1");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void updateEmpLaborRelation(Context ctx, EmpPosOrgRelationInfo info, EmpPosOrgRelationInfo oldInfo) throws BOSException, EASBizException {
        EmpLaborRelationInfo relaInfo = oldInfo.getLaborRelation();
        if (relaInfo != null) {
            IEmpLaborRelation iEmpLaborRelation = EmpLaborRelationFactory.getLocalInstance(ctx);
            EmpLaborRelationInfo laborRelaInfo = iEmpLaborRelation.getEmpLaborRelationInfo((IObjectPK)new ObjectUuidPK(relaInfo.getId().toString()));
            laborRelaInfo.setEFFDT(info.getEFFDT());
            laborRelaInfo.setLaborRelationState(info.getLaborRelation().getLaborRelationState());
            String laborStateId = info.getLaborRelation().getLaborRelationState().getId().toString();
            EmployeeTypeInfo employeeType = EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeInfo((IObjectPK)new ObjectUuidPK(laborStateId));
            laborRelaInfo.setEmployeeModle(employeeType.getEmployeeModle());
            laborRelaInfo.setHrOrgUnit(info.getHrOrgUnit());
            laborRelaInfo.setEmployerUnit(info.getHrOrgUnit());
            laborRelaInfo.setStartDateTime(info.getEFFDT());
            laborRelaInfo.setLastUpdateTime(info.getLastUpdateTime());
            laborRelaInfo.setLastUpdateUser(info.getLastUpdateUser());
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("EFFDT"));
            selectors.add(new SelectorItemInfo("laborRelationState"));
            selectors.add(new SelectorItemInfo("employeeModle"));
            selectors.add(new SelectorItemInfo("hrOrgUnit"));
            selectors.add(new SelectorItemInfo("employerUnit"));
            selectors.add(new SelectorItemInfo("startDateTime"));
            selectors.add(new SelectorItemInfo("lastUpdateTime"));
            selectors.add(new SelectorItemInfo("lastUpdateUser"));
            EmpLaborRelationFactory.getLocalInstance(ctx).updatePartial(laborRelaInfo, selectors);
            String oql = "where isInner=1 and  person.id ='" + info.getPerson().getId().toString() + "' and EFFDT = " + HRUtilExtend.getDateStringWithoutMininuteTs(oldInfo.getEFFDT());
            EmpLaborRelationHisInfo hisInfo = EmpLaborRelationHisFactory.getLocalInstance(ctx).getEmpLaborRelationHisInfo(oql);
            for (int i = 0; i < selectors.size(); ++i) {
                SelectorItemInfo selectorItem = selectors.get(i);
                String updateKey = selectorItem.getPropertyName();
                hisInfo.put(updateKey, laborRelaInfo.get(updateKey));
            }
            EmpLaborRelationHisFactory.getLocalInstance(ctx).updatePartial(hisInfo, selectors);
        }
    }

    private void updateEmployeeTypeOfPerson(Context ctx, EmpPosOrgRelationInfo info, EmpPosOrgRelationInfo oldInfo, EmpLaborRelationInfo laborRelaInfo) throws BOSException, EASBizException {
        if (info.getAssignType() == AssignTypeEnum.PARTTIME || !info.isIsInner()) {
            return;
        }
        String personId = info.getPerson().getId().toString();
        StringBuffer sql = new StringBuffer();
        String lastUpdateTime = HRUtilExtend.getDateStringWithMinuteTs(new Date(info.getLastUpdateTime().getTime()));
        sql = new StringBuffer();
        sql.append("update T_BD_Person set FEmployeeTypeID='").append(info.getLaborRelation().getLaborRelationState().getId()).append("', FLastUpdateUserID = '").append(info.getLastUpdateUser().getId().toString()).append("', FLastUpdateTime = ").append(lastUpdateTime).append(" where FID='").append(personId).append("' and FEmployeeTypeID <> '").append(info.getLaborRelation().getLaborRelationState().getId()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_BD_PersonHis set FEmployeeTypeID='").append(info.getLaborRelation().getLaborRelationState().getId()).append("', FLastUpdateUserID = '").append(info.getLastUpdateUser().getId().toString()).append("', FLastUpdateTime = ").append(lastUpdateTime).append(" where FHistoryRelateID='").append(personId).append("' and FEmployeeTypeID <> '").append(info.getLaborRelation().getLaborRelationState().getId()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void updatePersonPositionExtend(Context ctx, EmpPosOrgRelationInfo info, EmpPosOrgRelationInfo oldInfo) throws BOSException {
        Date effdt = oldInfo.getEFFDT();
        String personId = info.getPerson().getId().toString();
        StringBuilder sql = new StringBuilder("update T_HR_PersonPositionExtendHis set FEFFDT = ").append(HRUtilExtend.getDateStringWithoutMininuteTs(info.getEFFDT())).append(",").append(" FLastUpdateUserId = '").append(info.getLastUpdateUser().getId().toString()).append("',").append(" FLastUpdateTime = ").append(HRUtilExtend.getDateStringWithMinuteTs(new Date(info.getLastUpdateTime().getTime()))).append(" where FPersonId ='").append(personId).append("' and FEFFDT = ").append(HRUtilExtend.getDateStringWithoutMininuteTs(effdt));
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuilder("select top 1 FEFFDT,FLastUpdateUserId,FLastUpdateTime from T_HR_PersonPositionExtendHis where fpersonid='").append(personId).append("' order by FEFFDT DESC");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                sql = new StringBuilder("update T_HR_PersonPositionExtend set FEFFDT = ?,FLastUpdateUserId = ?,FLastUpdateTime = ? where FPersonId = '").append(personId).append("'");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{rs.getDate("FEFFDT"), rs.getString("FLastUpdateUserId"), rs.getDate("FLastUpdateTime")});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private void doWithCurrentFlowInfo(Context ctx, EmpPosOrgRelationInfo info) throws BOSException, EASBizException {
        SelectorItemCollection selector;
        EmpFlowInOutInfo inoutInfo;
        int i;
        EmpPosOrgRelationInfo oldInfo = EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()));
        String flowInAffairID = oldInfo.getFlowInAffairID();
        String flowOutAffairID = oldInfo.getFlowOutAffairID();
        String oql = "";
        oql = !StringUtils.isEmpty((String)flowOutAffairID) ? "select * where flowInAffairID='" + flowInAffairID + "' and flowOutAffairID='" + flowOutAffairID + "'" : "select * where flowInAffairID='" + flowInAffairID + "' and flowOutAffairID is null";
        IEmpFlowInOut iEmpFlowInOut = EmpFlowInOutFactory.getLocalInstance(ctx);
        EmpFlowInOutCollection empInColl = iEmpFlowInOut.getEmpFlowInOutCollection(oql);
        int size = empInColl.size();
        for (i = 0; i < size; ++i) {
            inoutInfo = empInColl.get(i);
            inoutInfo.setEFFDT(info.getEFFDT());
            inoutInfo.setLEFFDT(info.getLEFFDT());
            inoutInfo.setAdminOrg(info.getAdminOrg());
            inoutInfo.setPosition(info.getPosition());
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("EFFDT"));
            selector.add(new SelectorItemInfo("LEFFDT"));
            selector.add(new SelectorItemInfo("adminOrg"));
            selector.add(new SelectorItemInfo("position"));
            iEmpFlowInOut.updatePartial((CoreBaseInfo)inoutInfo, selector);
        }
        oql = "select * where flowInAffairID='" + flowInAffairID + "' and flowOutAffairID='" + flowInAffairID + "'";
        empInColl = iEmpFlowInOut.getEmpFlowInOutCollection(oql);
        size = empInColl.size();
        for (i = 0; i < size; ++i) {
            inoutInfo = empInColl.get(i);
            inoutInfo.setEFFDT(info.getEFFDT());
            inoutInfo.setLEFFDT(info.getLEFFDT());
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("EFFDT"));
            selector.add(new SelectorItemInfo("LEFFDT"));
            iEmpFlowInOut.updatePartial((CoreBaseInfo)inoutInfo, selector);
        }
    }

    private void doWithFlowIn(Context ctx, EmpPosOrgRelationInfo info) throws BOSException, EASBizException {
        EmpPosOrgRelationInfo oldInfo = EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()));
        String flowOutAffairID = oldInfo.getFlowOutAffairID();
        String oql = "select * where flowInAffairID='" + flowOutAffairID + "'";
        IEmpFlowInOut iEmpFlowInOut = EmpFlowInOutFactory.getLocalInstance(ctx);
        EmpFlowInOutCollection empOutColl = iEmpFlowInOut.getEmpFlowInOutCollection(oql);
        int size = empOutColl.size();
        for (int i = 0; i < size; ++i) {
            SelectorItemCollection selector;
            EmpFlowInOutInfo inoutInfo = empOutColl.get(i);
            if (inoutInfo.getFlowInAffairID().equals(inoutInfo.getFlowOutAffairID())) {
                inoutInfo.setEFFDT(DateTimeUtils.addDay((Date)info.getLEFFDT(), (long)1L));
                inoutInfo.setAdminOrg(info.getAdminOrg());
                inoutInfo.setPosition(info.getPosition());
                selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("EFFDT"));
                selector.add(new SelectorItemInfo("adminOrg"));
                selector.add(new SelectorItemInfo("position"));
                iEmpFlowInOut.updatePartial((CoreBaseInfo)inoutInfo, selector);
                continue;
            }
            inoutInfo.setEFFDT(DateTimeUtils.addDay((Date)info.getLEFFDT(), (long)1L));
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("EFFDT"));
            iEmpFlowInOut.updatePartial((CoreBaseInfo)inoutInfo, selector);
        }
    }

    @Override
    protected boolean _verifyEmpPostExperienceHis(Context ctx, String personId, String positionId, Date effect, AssignTypeEnum assignTypeEnum) throws BOSException, EASBizException {
        return EmpPostExperienceHisHelper._verifyEmpPostExperienceHis(ctx, personId, positionId, effect, assignTypeEnum);
    }

    @Override
    protected Map _modifyPersonBizManageForErrorEnroll(Context ctx, EmpPosOrgRelationInfo empRelaInfo) throws BOSException, EASBizException {
        ISHRBizManageMsgManage instance;
        ArrayList<String> empRelaList = new ArrayList<String>();
        empRelaList.add(empRelaInfo.getId().toString());
        PersonBizManageFacadeFactory.getLocalInstance((Context)ctx).modifyPersonBizManageForErrorEnroll(empRelaList);
        PersonChangeMsgInfo changeMsgInfo = PersonBizManageFacadeControllerBean.assemblePersonChangeMsgInfo((Context)ctx, (EmpPosOrgRelationInfo)empRelaInfo);
        changeMsgInfo.setBizDefineType(HRBizDefineTypeEnum.ENROLLADJUST);
        changeMsgInfo.setDealState(true);
        PersonChangeMsgFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)changeMsgInfo);
        PersonChangeMsgCollection personMsgColl = new PersonChangeMsgCollection();
        personMsgColl.add(changeMsgInfo);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(BizManageMsgConstants.PARAM_PERSON_MSGCOLL, personMsgColl);
        param.put(BizManageMsgConstants.IS_SUPPLEMENT_BILL, "false");
        List bizManageTypeIdList = SHRBizManageCommonTool.getEnableBizManageTypeIdList((Context)ctx);
        for (String bizManageTypeId : bizManageTypeIdList) {
            instance = SHRBizManageMsgManageFactory.getInstance((Context)ctx, (String)bizManageTypeId, (int)0);
            instance.addPersonChangeMsgByBizType(ctx, param);
        }
        String sql = "select curEmpOrgRelation.position.id,oldEmpOrgRelation.position.id,* where confirmState = 0 and affairActionOperate is not null and bizManageType='" + CommonConstants.BIZMANAGETYPE_EMP01 + "' and isEmpInit = 0 and bizDefineType = " + 42 + " and person.id = '" + changeMsgInfo.getPerson() + "' order by changeDate asc,changeMsgId asc,bizDefineType asc,bizDefineEntrySeq asc";
        PersonBURelaConfirmCollection coll = PersonBURelaConfirmFactory.getLocalInstance((Context)ctx).getPersonBURelaConfirmCollection(sql.toString());
        instance = SHRBizManageMsgManageFactory.getInstance((Context)ctx, (String)CommonConstants.BIZMANAGETYPE_EMP01, (int)0);
        instance.addEnablePersonManageInfo(ctx, coll);
        return null;
    }

    @Override
    protected void _importPersonDealPersonBURelation(Context ctx, List personIdList, boolean isEmpInit) throws BOSException, EASBizException {
        PersonBizManageFacadeFactory.getLocalInstance((Context)ctx).deletePersonBizManageByPerson(personIdList, isEmpInit);
        SHREmpOptBizManageTool distributeTool = new SHREmpOptBizManageTool();
        distributeTool.batchWritePersonEmpOrgChangeMsgData(ctx, personIdList, isEmpInit);
    }

    @Override
    protected void _updateNewestEmpPosOrgRelation(Context ctx, EmpPosOrgRelationInfo empRelaInfo) throws BOSException, EASBizException {
        IEmpPosOrgRelation bean = EmpPosOrgRelationFactory.getLocalInstance(ctx);
        if (empRelaInfo.getId() != null && bean.exists((IObjectPK)new ObjectUuidPK(empRelaInfo.getId()))) {
            EmpPosOrgRelationInfo info = bean.getEmpPosOrgRelationInfo((IObjectPK)new ObjectUuidPK(empRelaInfo.getId()));
            if (empRelaInfo.get("bizDate") != null) {
                Date bizDate = (Date)empRelaInfo.get("bizDate");
                if (info.isIsInner() && (empRelaInfo.getEFFDT().equals(bizDate) || empRelaInfo.getEFFDT().equals(HRUtil.getAftereDate(bizDate)))) {
                    bean.update((IObjectPK)new ObjectUuidPK(empRelaInfo.getId()), (CoreBaseInfo)empRelaInfo);
                }
            } else {
                Date date = new Date();
                if (info.isIsInner() && info.getEFFDT().before(date) && info.getLEFFDT().after(date)) {
                    bean.update((IObjectPK)new ObjectUuidPK(empRelaInfo.getId()), (CoreBaseInfo)empRelaInfo);
                }
            }
        }
    }

    @Override
    protected void _updateEarlistEFFDT(Context ctx, EmpPosOrgRelationInfo empRelaInfo) throws BOSException, EASBizException {
        logger.info((Object)"updateEarlistEFFDT start");
        this.checkEFFDT(ctx, empRelaInfo);
        EmpPosOrgRelationFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(empRelaInfo.getId()), (CoreBaseInfo)empRelaInfo);
        this.updatePersonPositionEFFDT(ctx, empRelaInfo);
        this.updatePersonPositionExtend(ctx, empRelaInfo);
        this.updateEmpLaborRelationEFFDT(ctx, empRelaInfo);
        this.updateEmpPostExperienceHisEFFDT(ctx, empRelaInfo);
        this.updateFlowInOutEFFDT(ctx, empRelaInfo);
        this.updateEmpPostRankEFFDT(ctx, empRelaInfo);
        this.updateEmpHroRelationHis(ctx, empRelaInfo);
        logger.info((Object)"updateEarlistEFFDT end");
    }

    private void updateEmpHroRelationHis(Context ctx, EmpPosOrgRelationInfo empRelaInfo) throws EASBizException, BOSException {
        IEmpHRORelationHis iEmpHRORelationHis = EmpHRORelationHisFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" where empOrgRelation='").append(empRelaInfo.getId().toString()).append("'");
        EmpHRORelationHisCollection empHroColl = iEmpHRORelationHis.getEmpHRORelationHisCollection(oql.toString());
        if (empHroColl != null && empHroColl.size() > 0) {
            for (int i = 0; i < empHroColl.size(); ++i) {
                EmpHRORelationHisInfo info = empHroColl.get(i);
                info.setEFFDT(empRelaInfo.getEFFDT());
                iEmpHRORelationHis.update((IObjectPK)new ObjectUuidPK(info.getId()), info);
            }
        }
    }

    private void updatePersonPositionExtend(Context ctx, EmpPosOrgRelationInfo empRelaInfo) throws EASBizException, BOSException {
        IPersonPositionExtendHIS ppHisBean = PersonPositionExtendHISFactory.getLocalInstance((Context)ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" where person='").append(empRelaInfo.getPerson().getId().toString()).append("'");
        oql.append(" order by EFFDT asc");
        PersonPositionExtendHISCollection ppColl = ppHisBean.getPersonPositionExtendHISCollection(oql.toString());
        if (ppColl != null && ppColl.size() > 0) {
            IPersonPositionExtend iPersonPosition;
            PersonPositionExtendInfo pp;
            PersonPositionExtendHISInfo pphis = ppColl.get(0);
            pphis.setEFFDT(empRelaInfo.getEFFDT());
            ppHisBean.update((IObjectPK)new ObjectUuidPK(pphis.getId()), (EmpInfoSinglePageInfo)pphis);
            if (DateTimeUtils.dayEquals((Date)pphis.getLEFFDT(), (Date)HRUtil.getMaxEndDate()) && (pp = (iPersonPosition = PersonPositionExtendFactory.getLocalInstance((Context)ctx)).getPersonPositionExtendInfo(" where person = '" + pphis.getPerson().getId().toString() + "'")) != null) {
                pp.setEFFDT(empRelaInfo.getEFFDT());
                iPersonPosition.update((IObjectPK)new ObjectUuidPK(pp.getId()), (EmpInfoSinglePageInfo)pp);
            }
        }
    }

    private void updateEmpPostRankEFFDT(Context ctx, EmpPosOrgRelationInfo empRelaInfo) throws EASBizException, BOSException {
        IEmpPosJobGradeRelation iEmpPosJobGradeRelation = EmpPosJobGradeRelationFactory.getLocalInstance((Context)ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" where affairId='").append(empRelaInfo.getFlowInAffairID().toString()).append("'");
        EmpPosJobGradeRelationCollection empJobRelaColl = iEmpPosJobGradeRelation.getEmpPosJobGradeRelationCollection(oql.toString());
        if (empJobRelaColl == null || empJobRelaColl.size() == 0) {
            return;
        }
        IEmpPostRank iEmpPostRank = EmpPostRankFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < empJobRelaColl.size(); ++i) {
            EmpPosJobGradeRelationInfo empJobRela = empJobRelaColl.get(i);
            EmpPostRankInfo empPostRankInfo = iEmpPostRank.getEmpPostRankInfo((IObjectPK)new ObjectUuidPK(empJobRela.getEmpPostRank().getId()));
            empPostRankInfo.setEFFDT(empRelaInfo.getEFFDT());
            iEmpPostRank.update((IObjectPK)new ObjectUuidPK(empPostRankInfo.getId()), empPostRankInfo);
            empJobRela.setEffdt(empRelaInfo.getEFFDT());
            empJobRela.setStartDateTime(empRelaInfo.getEFFDT());
            iEmpPosJobGradeRelation.update((IObjectPK)new ObjectUuidPK(empJobRela.getId()), empJobRela);
        }
    }

    private void updateFlowInOutEFFDT(Context ctx, EmpPosOrgRelationInfo empRelaInfo) throws BOSException, EASBizException {
        IEmpFlowInOut empflowBean = EmpFlowInOutFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" where person='").append(empRelaInfo.getPerson().getId().toString()).append("'");
        oql.append(" and empPosOrgRelation = '").append(empRelaInfo.getId().toString()).append("'");
        oql.append(" order by EFFDT");
        EmpFlowInOutCollection empExpColl = empflowBean.getEmpFlowInOutCollection(oql.toString());
        if (empExpColl != null && empExpColl.size() > 0) {
            EmpFlowInOutInfo empflow = empExpColl.get(0);
            empflow.setEFFDT(empRelaInfo.getEFFDT());
            empflowBean.update((IObjectPK)new ObjectUuidPK(empflow.getId()), (CoreBaseInfo)empflow);
        }
    }

    private void updateEmpPostExperienceHisEFFDT(Context ctx, EmpPosOrgRelationInfo empRelaInfo) throws BOSException, EASBizException {
        String endDateTimeTS = HistoryVersionUtil.getDateTimeTs(empRelaInfo.getEndDateTime());
        IEmpPostExperienceHis empExpHisBean = EmpPostExperienceHisFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" where person='").append(empRelaInfo.getPerson().getId().toString()).append("'");
        oql.append(" and adminOrg = '").append(empRelaInfo.getAdminOrg().getId().toString()).append("'");
        oql.append(" and position = '").append(empRelaInfo.getPosition().getId().toString()).append("'");
        oql.append(" and startDateTime<=").append(endDateTimeTS).append(" and endDateTime>=").append(endDateTimeTS);
        oql.append(" and isinner = 1");
        oql.append(" order by endDateTime asc");
        EmpPostExperienceHisCollection empExpColl = empExpHisBean.getEmpPostExperienceHisCollection(oql.toString());
        if (empExpColl != null && empExpColl.size() > 0) {
            EmpPostExperienceHisInfo empExphis = empExpColl.get(0);
            empExphis.setEffdt(empRelaInfo.getEFFDT());
            empExphis.setStartDateTime(empRelaInfo.getEFFDT());
            empExpHisBean.update((IObjectPK)new ObjectUuidPK(empExphis.getId()), empExphis);
        }
    }

    private void updateEmpLaborRelationEFFDT(Context ctx, EmpPosOrgRelationInfo empRelaInfo) throws BOSException, EASBizException {
        String endDateTimeTS = HistoryVersionUtil.getDateTimeTs(empRelaInfo.getEndDateTime());
        IEmpLaborRelationHis empLaborHisBean = EmpLaborRelationHisFactory.getLocalInstance(ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" where person='").append(empRelaInfo.getPerson().getId().toString()).append("'");
        oql.append(" and startDateTime<=").append(endDateTimeTS).append(" and endDateTime>=").append(endDateTimeTS);
        oql.append(" and isinner = 1");
        oql.append(" order by endDateTime asc");
        EmpLaborRelationHisCollection empLaborColl = empLaborHisBean.getEmpLaborRelationHisCollection(oql.toString());
        if (empLaborColl != null && empLaborColl.size() > 0) {
            IEmpLaborRelation iEmpLaborRelation;
            EmpLaborRelationInfo empLabor;
            EmpLaborRelationHisInfo empLaborhis = empLaborColl.get(0);
            empLaborhis.setEFFDT(empRelaInfo.getEFFDT());
            empLaborhis.setStartDateTime(empRelaInfo.getEFFDT());
            empLaborHisBean.update((IObjectPK)new ObjectUuidPK(empLaborhis.getId()), empLaborhis);
            if (DateTimeUtils.dayEquals((Date)empLaborhis.getLEFFDT(), (Date)HRUtil.getMaxEndDate()) && empLaborhis.getHistoryRelateID() != null && (empLabor = (iEmpLaborRelation = EmpLaborRelationFactory.getLocalInstance(ctx)).getEmpLaborRelationInfo(" where id = '" + empLaborhis.getHistoryRelateID().toString() + "'")) != null) {
                empLabor.setEFFDT(empRelaInfo.getEFFDT());
                empLabor.setStartDateTime(empRelaInfo.getEFFDT());
                iEmpLaborRelation.update((IObjectPK)new ObjectUuidPK(empLabor.getId()), empLabor);
            }
        }
    }

    private void updatePersonPositionEFFDT(Context ctx, EmpPosOrgRelationInfo empRelaInfo) throws BOSException, EASBizException {
        String endDateTimeTS = HistoryVersionUtil.getDateTimeTs(empRelaInfo.getEndDateTime());
        IPersonPositionHis ppHisBean = PersonPositionHisFactory.getLocalInstance((Context)ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" where person='").append(empRelaInfo.getPerson().getId().toString()).append("'");
        oql.append(" and startDateTime<=").append(endDateTimeTS).append(" and endDateTime>=").append(endDateTimeTS);
        oql.append(" and isinner = 1");
        oql.append(" order by endDateTime asc");
        PersonPositionHisCollection ppColl = ppHisBean.getPersonPositionHisCollection(oql.toString());
        if (ppColl != null && ppColl.size() > 0) {
            IPersonPosition iPersonPosition;
            PersonPositionInfo pp;
            PersonPositionHisInfo pphis = ppColl.get(0);
            pphis.setEFFDT(empRelaInfo.getEFFDT());
            pphis.setStartDateTime(empRelaInfo.getEFFDT());
            ppHisBean.update((IObjectPK)new ObjectUuidPK(pphis.getId()), (EmpInfoSinglePageInfo)pphis);
            if (DateTimeUtils.dayEquals((Date)pphis.getLEFFDT(), (Date)HRUtil.getMaxEndDate()) && pphis.getHistoryRelateID() != null && (pp = (iPersonPosition = PersonPositionFactory.getLocalInstance((Context)ctx)).getPersonPositionInfo(" where id = '" + pphis.getHistoryRelateID().toString() + "'")) != null) {
                pp.setEFFDT(empRelaInfo.getEFFDT());
                pp.setStartDateTime(empRelaInfo.getEFFDT());
                iPersonPosition.update((IObjectPK)new ObjectUuidPK(pp.getId()), (EmpInfoSinglePageInfo)pp);
            }
        }
    }

    private void checkEFFDT(Context ctx, EmpPosOrgRelationInfo empRelaInfo) throws BOSException, EASBizException {
        EmpHRORelationHisInfo personBURelationInfo = SHREmpOptBizManageTool.getEmpHRORelationHisInfo((Context)ctx, (String)empRelaInfo.getPerson().getId().toString());
        if (personBURelationInfo == null || personBURelationInfo == null) {
            throw new EmpPosOrgRelationException(EmpPosOrgRelationException.PERSON_NO_HRO);
        }
        Date curDate = HRUtilExtend.getCurDateWithTruncated();
        if (DateTimeUtils.dayBefore((Date)curDate, (Date)empRelaInfo.getEFFDT())) {
            throw new EmpPosOrgRelationException(EmpPosOrgRelationException.TIME_AFTER_NOW);
        }
        PersonHisCollection personColl = PersonHisFactory.getLocalInstance((Context)ctx).getPersonHisCollection("where historyRelateID = '" + empRelaInfo.getPerson().getId().toString() + "' order by effdt asc");
        if (personColl.size() > 0 && DateTimeUtils.dayBefore((Date)empRelaInfo.getEFFDT(), (Date)personColl.get(0).getEFFDT())) {
            throw new EmpPosOrgRelationException(EmpPosOrgRelationException.JOINDATE_CANT_BEFORE_PERSON_EFFDT, new Object[]{HRUtilExtend.getDateStringWithoutMininute(personColl.get(0).getEFFDT())});
        }
        this.checkEmpPosOrgRelationTime(ctx, empRelaInfo);
        this.checkEmpPostRankTime(ctx, empRelaInfo);
    }

    private void checkEmpPostRankTime(Context ctx, EmpPosOrgRelationInfo empRelaInfo) throws EASBizException, BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("where person='").append(empRelaInfo.getPerson().getId().toString()).append("'");
        oql.append(" and source <> 1");
        oql.append(" and empPositionType = 1");
        oql.append("order by EFFDT ");
        EmpPostRankCollection empPostRankCollection = EmpPostRankFactory.getLocalInstance((Context)ctx).getEmpPostRankCollection(oql.toString());
        if (empPostRankCollection != null && empPostRankCollection.size() > 0) {
            EmpPostRankInfo empPostRankInfo = empPostRankCollection.get(0);
            if (DateTimeUtils.dayAfter((Date)empRelaInfo.getEFFDT(), (Date)empPostRankInfo.getLEFFDT()) || DateTimeUtils.dayEquals((Date)empRelaInfo.getEFFDT(), (Date)empRelaInfo.getLEFFDT())) {
                throw new EmpPosOrgRelationException(EmpPosOrgRelationException.TIME_AFTER_POSTRANKLEFFDT, new String[]{empPostRankInfo.getLEFFDT().toString()});
            }
        }
    }

    private void checkEmpPosOrgRelationTime(Context ctx, EmpPosOrgRelationInfo empRelaInfo) throws EASBizException, BOSException {
        IEmpPosOrgRelation iEmpPosOrgRelation;
        EmpPosOrgRelationCollection empColl;
        if (DateTimeUtils.dayAfter((Date)empRelaInfo.getEFFDT(), (Date)empRelaInfo.getLEFFDT())) {
            throw new EmpPosOrgRelationException(EmpPosOrgRelationException.TIME_AFTER_FIRSTLEFFDT, new String[]{empRelaInfo.getLEFFDT().toString()});
        }
        String effdt = HistoryVersionUtil.getDateTimeTs(empRelaInfo.getEFFDT());
        StringBuffer oql = new StringBuffer();
        oql.append("select position.name,adminOrg.displayName,effdt,leffdt where person='").append(empRelaInfo.getPerson().getId().toString()).append("'");
        oql.append("and (");
        oql.append(" ( effdt<=").append(effdt).append(" and leffdt>=").append(effdt).append(" )");
        oql.append(" or ( effdt>=").append(effdt).append(" )");
        oql.append(" )");
        oql.append(" and assignType = 1");
        oql.append(" and isinner <> 1");
        oql.append(" and isSystem = 1");
        if (empRelaInfo.getId() != null) {
            oql.append(" and id <> '").append(empRelaInfo.getId().toString()).append("'");
        }
        if ((empColl = (iEmpPosOrgRelation = EmpPosOrgRelationFactory.getLocalInstance(ctx)).getEmpPosOrgRelationCollection(oql.toString())) != null && empColl.size() > 0) {
            String msg = "";
            for (int i = 0; i < empColl.size(); ++i) {
                msg = msg + MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label147", (Context)ctx), empColl.get(i).getEFFDT(), empColl.get(i).getLEFFDT(), empColl.get(i).getPosition().getName(), empColl.get(i).getAdminOrg().getDisplayName());
            }
            throw new EmpPosOrgRelationException(EmpPosOrgRelationException.TIME_REPEAT, new Object[]{msg});
        }
    }
}

