/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HrUserHisPermCollection;
import com.kingdee.eas.hr.base.HrUserHisPermFactory;
import com.kingdee.eas.hr.base.PersonStatusEnum;
import com.kingdee.eas.hr.base.UserPermSetInfo;
import com.kingdee.eas.hr.base.app.AbstractUserPermSetControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class UserPermSetControllerBean
extends AbstractUserPermSetControllerBean {
    private static final long serialVersionUID = -7032206597577208997L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.UserPermSetControllerBean");

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        UserPermSetInfo userPermSetInfo = (UserPermSetInfo)model;
        if (userPermSetInfo.isIsInherit() && PersonStatusEnum.NONEPOSITION.equals((Object)userPermSetInfo.getPersonStatus())) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)userPermSetInfo.getAdminOrgUnit().getId()));
            filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)userPermSetInfo.getPosition().getId()));
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)userPermSetInfo.getInheritPerson().getId()));
            filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)userPermSetInfo.getInheritUser().getId()));
            viewInfo.setFilter(filter);
            HrUserHisPermCollection userPerms = HrUserHisPermFactory.getLocalInstance(ctx).getHrUserHisPermCollection(viewInfo);
            if (userPerms.size() > 0) {
                userPermSetInfo.setHrUserHisPerm(userPerms.get(0));
            }
        } else {
            userPermSetInfo.setHrUserHisPerm(null);
        }
        return super.submit(ctx, model);
    }

    @Override
    protected UserCollection _getPersonOfUserCollection(Context ctx, PersonInfo personInfo) throws BOSException, EASBizException {
        UserCollection userColl = new UserCollection();
        if (personInfo != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personInfo.getId().toString()));
            viewInfo.setFilter(filter);
            userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection(viewInfo);
        }
        return userColl;
    }

    @Override
    protected UserCollection _getPositionOfUserCollection(Context ctx, AdminOrgUnitInfo adminOrg, PositionInfo positionInfo) throws BOSException, EASBizException {
        UserCollection userColl = new UserCollection();
        if (positionInfo != null) {
            this.fillCurrentUserOfPosition(ctx, adminOrg, positionInfo, userColl);
            this.fillHistoryUserOfPosition(ctx, adminOrg, positionInfo, userColl);
        }
        return userColl;
    }

    private void fillHistoryUserOfPosition(Context ctx, AdminOrgUnitInfo adminOrg, PositionInfo positionInfo, UserCollection userColl) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)adminOrg.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionInfo.getId().toString()));
        viewInfo.setFilter(filter);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("user.person.id"));
        selectors.add(new SelectorItemInfo("user.person.number"));
        selectors.add(new SelectorItemInfo("user.person.name"));
        selectors.add(new SelectorItemInfo("user.id"));
        selectors.add(new SelectorItemInfo("user.name"));
        selectors.add(new SelectorItemInfo("user.number"));
        viewInfo.setSelector(selectors);
        SorterItemCollection sortItemColl = new SorterItemCollection();
        sortItemColl.add(new SorterItemInfo("user.person.name"));
        viewInfo.setSorter(sortItemColl);
        HrUserHisPermCollection coll = HrUserHisPermFactory.getLocalInstance(ctx).getHrUserHisPermCollection(viewInfo);
        UserInfo userInfo = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            userInfo = coll.get(i).getUser();
            userInfo.put("PersonStatusEnum", (Object)PersonStatusEnum.NONEPOSITION);
            userColl.add(coll.get(i).getUser());
        }
    }

    private void fillCurrentUserOfPosition(Context ctx, AdminOrgUnitInfo adminOrg, PositionInfo positionInfo, UserCollection userColl) throws BOSException {
        MetaDataPK queyrPk = MetaDataPK.create((String)"com.kingdee.eas.hr.base.app.PositionOfPersonUserQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("personDep.id", (Object)adminOrg.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("primaryPosition.id", (Object)positionInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("User.id", null, CompareType.ISNOT));
        SorterItemCollection sortItemColl = new SorterItemCollection();
        sortItemColl.add(new SorterItemInfo("person.name"));
        viewInfo.setSorter(sortItemColl);
        viewInfo.setFilter(filter);
        IQueryExecutor executor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queyrPk);
        executor.setObjectView(viewInfo);
        IRowSet rs = executor.executeQuery();
        UserInfo userInfo = null;
        PersonInfo person = null;
        try {
            while (rs.next()) {
                userInfo = new UserInfo();
                person = new PersonInfo();
                person.setId(BOSUuid.read((String)rs.getString("person.id")));
                person.setNumber(rs.getString("person.number"));
                person.setName(rs.getString("person.name"));
                if (StringUtils.isEmpty((String)rs.getString("User.id"))) continue;
                userInfo.setId(BOSUuid.read((String)rs.getString("User.id")));
                userInfo.setNumber(rs.getString("User.number"));
                userInfo.setPerson(person);
                userInfo.put("PersonStatusEnum", (Object)PersonStatusEnum.ONPOSITION);
                userColl.add(userInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

