/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.util.StringUtility;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.VariationReasonCollection;
import com.kingdee.eas.hr.base.VariationReasonFactory;
import com.kingdee.eas.hr.base.VariationReasonInfo;
import com.kingdee.eas.hr.base.app.AbstractVariationReasonControllerBean;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class VariationReasonControllerBean
extends AbstractVariationReasonControllerBean {
    private final int startlevel = 1;
    public static final int MaxLongNumber = 160;
    public static final int MaxDisplayName = 160;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.VariationReasonControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        VariationReasonInfo variationReasonInfo = (VariationReasonInfo)model;
        VariationReasonInfo parent = this.getFullParent(ctx, model);
        variationReasonInfo.setIsLeaf(true);
        if (parent == null || parent.getId().equals((Object)variationReasonInfo.getId())) {
            variationReasonInfo.setLevel(1);
            variationReasonInfo.setLongNumber(variationReasonInfo.getNumber());
            variationReasonInfo.setDisplayName(variationReasonInfo.getName());
            this.checkLongNumberLenth(ctx, variationReasonInfo);
            this.checkDisplayNameLength(ctx, variationReasonInfo);
            this.checkLongNumberDuplicate(ctx, variationReasonInfo);
        } else {
            variationReasonInfo.setLevel(parent.getLevel() + 1);
            variationReasonInfo.setLongNumber(parent.getLongNumber() + "!" + variationReasonInfo.getNumber());
            this.LinkDisplayName(parent, variationReasonInfo);
            this.checkLongNumberLenth(ctx, variationReasonInfo);
            this.checkDisplayNameLength(ctx, variationReasonInfo);
            this.checkLongNumberDuplicate(ctx, variationReasonInfo);
            if (parent.isIsLeaf()) {
                parent.setIsLeaf(false);
                super._update(ctx, (IObjectPK)new ObjectUuidPK(parent.getId()), (IObjectValue)parent);
            }
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)variationReasonInfo);
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        VariationReasonInfo variationReasonInfo = (VariationReasonInfo)model;
        VariationReasonInfo oldVariationReasonInfo = this.getVariationReasonInfo(ctx, pk);
        String oldDisplayName = oldVariationReasonInfo.getDisplayName();
        String oldLongNumber = oldVariationReasonInfo.getLongNumber();
        if (variationReasonInfo.getDisplayName() == null) {
            variationReasonInfo.setDisplayName(oldDisplayName);
            this.checkDisplayNameLength(ctx, variationReasonInfo);
        }
        if (variationReasonInfo.getLongNumber() == null) {
            variationReasonInfo.setLongNumber(oldLongNumber);
            this.checkLongNumberLenth(ctx, variationReasonInfo);
        }
        if (oldLongNumber == null) {
            String propertyAlias = this.getPropertyAlias(ctx, (CoreBaseInfo)variationReasonInfo, "longNumber");
            throw new BaseException(BaseException.CHECKFIELDISNULL, new Object[]{propertyAlias});
        }
        if (variationReasonInfo.containsKey("number") && oldLongNumber != null) {
            String longNumber = "";
            String number = "";
            longNumber = oldLongNumber;
            number = variationReasonInfo.getNumber();
            VariationReasonInfo parent = this.getFullParent(ctx, (IObjectValue)variationReasonInfo);
            if (parent == null || parent.getId().equals((Object)variationReasonInfo.getId())) {
                variationReasonInfo.setLongNumber(variationReasonInfo.getNumber());
                variationReasonInfo.setDisplayName(variationReasonInfo.getName());
                this.checkLongNumberLenth(ctx, variationReasonInfo);
                this.checkDisplayNameLength(ctx, variationReasonInfo);
            } else {
                variationReasonInfo.setLongNumber(parent.getLongNumber() + "!" + variationReasonInfo.getNumber());
                this.LinkDisplayName(parent, variationReasonInfo);
                this.checkLongNumberLenth(ctx, variationReasonInfo);
                this.checkDisplayNameLength(ctx, variationReasonInfo);
            }
            this.checkLongNumberDuplicate(ctx, variationReasonInfo);
            int level = variationReasonInfo.getLongNumber().split("!").length;
            variationReasonInfo.setLevel(level);
            if (longNumber != null && !longNumber.equals(variationReasonInfo.getLongNumber())) {
                this.updateChildLongNumberByNumberUpdated(ctx, variationReasonInfo, longNumber);
                this.updateChildDisplayNameByNameUpdated(ctx, variationReasonInfo, oldDisplayName, oldLongNumber);
            }
            if (oldDisplayName != null && !oldDisplayName.equals(variationReasonInfo.getDisplayName())) {
                this.updateChildDisplayNameByNameUpdated(ctx, variationReasonInfo, oldDisplayName, longNumber);
            }
        }
        this.checkDisplayNameLength(ctx, variationReasonInfo);
        super._update(ctx, pk, (IObjectValue)variationReasonInfo);
        this.syncParentIsLeafStatus(ctx, oldVariationReasonInfo.getParent(), variationReasonInfo.getParent());
    }

    private VariationReasonInfo getFullParent(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        VariationReasonInfo variationReasonInfo = (VariationReasonInfo)model;
        VariationReasonInfo parent = variationReasonInfo.getParent();
        if (parent == null || parent.getId().equals((Object)variationReasonInfo.getId())) {
            return null;
        }
        parent = VariationReasonFactory.getLocalInstance(ctx).getVariationReasonInfo((IObjectPK)new ObjectUuidPK(parent.getId()));
        variationReasonInfo.setParent(parent);
        return parent;
    }

    private void LinkDisplayName(VariationReasonInfo parent, VariationReasonInfo info) {
        String disPlayName = null;
        String parentDisplayName = parent.getDisplayName();
        disPlayName = parentDisplayName != null ? parentDisplayName + "_" + info.getName() : info.getName();
        info.setDisplayName(disPlayName);
    }

    private void checkLongNumberLenth(Context ctx, VariationReasonInfo info) throws EASBizException, BOSException {
        int len;
        String propertyAlias = null;
        propertyAlias = this.getPropertyAlias(ctx, (CoreBaseInfo)info, "longNumber");
        int n = len = info.getLongNumber() == null ? -1 : info.getLongNumber().length();
        if (len > 160) {
            throw new BaseException(BaseException.CHECKFIELDLENGTH, new Object[]{propertyAlias, String.valueOf(160)});
        }
    }

    private void checkDisplayNameLength(Context ctx, VariationReasonInfo info) throws EASBizException, BOSException {
        int len;
        String propertyAlias = null;
        propertyAlias = this.getPropertyAlias(ctx, (CoreBaseInfo)info, "displayName");
        int n = len = info.getDisplayName() == null ? -1 : info.getDisplayName().length();
        if (len > 160) {
            throw new BaseException(BaseException.CHECKFIELDLENGTH, new Object[]{propertyAlias, String.valueOf(160)});
        }
    }

    private String getPropertyAlias(Context ctx, CoreBaseInfo info, String propertyName) {
        String alias = null;
        PropertyInfo property = this.getProperty(ctx, info, propertyName);
        if (property != null) {
            alias = property.getAlias();
        }
        return alias;
    }

    private PropertyInfo getProperty(Context ctx, CoreBaseInfo info, String propertyName) {
        EntityObjectInfo entity = this.getBOSEntity(ctx, info);
        PropertyInfo property = null;
        property = entity.getPropertyByNameRuntime(propertyName);
        return property;
    }

    private void checkLongNumberDuplicate(Context ctx, VariationReasonInfo info) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", (Object)info.getLongNumber(), CompareType.EQUALS));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this.exists(ctx, filterInfo)) {
            String longNumber = this._getPropertyAlias(ctx, (DataBaseInfo)info, "longNumber") + " : " + info.getLongNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{longNumber});
        }
    }

    private void updateChildLongNumberByNumberUpdated(Context ctx, VariationReasonInfo info, String oldLongNumber) throws BOSException, EASBizException {
        String longNumber = info.getLongNumber();
        FilterItemInfo filterItemInfo = new FilterItemInfo("longNumber", (Object)(oldLongNumber + "!" + "%"), CompareType.LIKE);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(filterItemInfo);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        VariationReasonCollection variationReasonCollection = this.getVariationReasonCollection(ctx, view);
        VariationReasonInfo temp = null;
        Iterator iterator = variationReasonCollection.iterator();
        while (iterator.hasNext()) {
            temp = (VariationReasonInfo)iterator.next();
            String temps = StringUtility.castRegular((String)oldLongNumber);
            temp.setLongNumber(temp.getLongNumber().replaceFirst(temps, longNumber));
            this.checkLongNumberLenth(ctx, temp);
            int level = temp.getLongNumber().split("!").length;
            temp.setLevel(level);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(temp.getId()), (IObjectValue)temp);
        }
    }

    private void updateChildDisplayNameByNameUpdated(Context ctx, VariationReasonInfo info, String oldDisplayName, String oldLongNumber) throws BOSException, EASBizException {
        String displayName = info.getDisplayName();
        FilterItemInfo filterItemInfo = new FilterItemInfo("longNumber", (Object)(info.getLongNumber() + "!" + "%"), CompareType.LIKE);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(filterItemInfo);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        VariationReasonCollection variationReasonCollection = this.getVariationReasonCollection(ctx, view);
        VariationReasonInfo temp = null;
        Iterator iterator = variationReasonCollection.iterator();
        while (iterator.hasNext()) {
            temp = (VariationReasonInfo)iterator.next();
            if (oldDisplayName != null) {
                if (temp.getDisplayName() != null) {
                    if (temp.getDisplayName().indexOf(oldDisplayName) > 1) {
                        return;
                    }
                    String temps = StringUtility.castRegular((String)oldDisplayName);
                    temp.setDisplayName(temp.getDisplayName().replaceFirst(temps + "_", displayName + "_"));
                } else {
                    temp.setDisplayName(displayName);
                }
            } else {
                temp.setDisplayName(displayName);
            }
            this.checkDisplayNameLength(ctx, temp);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(temp.getId()), (IObjectValue)temp);
        }
    }

    private void syncParentIsLeafStatus(Context ctx, VariationReasonInfo oldParentInfo, VariationReasonInfo parentInfo) throws EASBizException, BOSException {
        if (oldParentInfo != null && oldParentInfo.getId() != null && parentInfo != null && parentInfo.getId() != null && oldParentInfo.getId().toString().equals(parentInfo.getId().toString())) {
            return;
        }
        if (oldParentInfo != null && oldParentInfo.getId() != null) {
            this.updateIsLeafState(ctx, oldParentInfo.getId().toString());
        }
        if (parentInfo != null && parentInfo.getId() != null) {
            this.updateIsLeafState(ctx, parentInfo.getId().toString());
        }
    }

    private void updateIsLeafState(Context ctx, String parentId) throws BOSException, EASBizException {
        boolean isLeaf = this.isLeaf(ctx, parentId);
        if (isLeaf) {
            this.updateIsLeafState(ctx, parentId, true);
        } else {
            this.updateIsLeafState(ctx, parentId, false);
        }
    }

    private boolean isLeaf(Context ctx, String parentId) throws BOSException {
        boolean isLeaf = false;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)parentId));
        viewInfo.setFilter(filter);
        VariationReasonCollection variationReasonCollection = this.getVariationReasonCollection(ctx, viewInfo);
        isLeaf = variationReasonCollection.size() <= 0;
        return isLeaf;
    }

    private void updateIsLeafState(Context ctx, String parentId, boolean isLeaf) throws EASBizException, BOSException {
        if (this.exists(ctx, (IObjectPK)new ObjectUuidPK(parentId))) {
            VariationReasonInfo variationReasonInfo = this.getVariationReasonInfo(ctx, (IObjectPK)new ObjectUuidPK(parentId));
            variationReasonInfo.setIsLeaf(isLeaf);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("isLeaf"));
            this.updatePartial(ctx, (CoreBaseInfo)variationReasonInfo, selector);
        }
    }
}

