/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app.his;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.util.DateTimeUtils;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class HistoryVersionUtil {
    public static final int VERSION_INIT = 1;
    public static final String isLatestInAday = "isLatestInAday";
    public static final String EARLIEST_EFFDT = "1900-01-01 00:00:00";
    public static final String MAX_ENDDATE = "2199-12-31 23:59:59";
    public static final String startDateTime = "startDateTime";
    public static final String endDateTime = "endDateTime";

    public static FilterInfo getPointDateFilterInfo(Date appointDate) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.EFFDT, (Object)appointDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)appointDate, CompareType.GREATER_EQUALS));
        return filter;
    }

    public static FilterInfo getPointDateLatestFilterInfo(Date appointDate) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.EFFDT, (Object)appointDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)appointDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(isLatestInAday, (Object)true, CompareType.EQUALS));
        return filter;
    }

    public static FilterInfo getEFFDTAfterPointDateFilterInfo(Date appointDate) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.EFFDT, (Object)appointDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(isLatestInAday, (Object)true, CompareType.EQUALS));
        return filter;
    }

    public static FilterInfo getPointDateTimeFilterInfo(Date startDateTime) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(startDateTime, (Object)startDateTime, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(endDateTime, (Object)startDateTime, CompareType.GREATER_EQUALS));
        return filter;
    }

    public static Date getPreRecordEndDateTime(Date startDateTime) throws BOSException {
        if (startDateTime == null) {
            throw new BOSException("startDateTime is null");
        }
        Date endDateTime = DateTimeUtils.addSecond((Date)startDateTime, (long)-1L);
        return endDateTime;
    }

    public static Date getMaxEndDate() {
        try {
            return DateTimeUtils.parseDate((String)MAX_ENDDATE);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getMaxEndDateTs() {
        return "{ts '2199-12-31 23:59:59'}";
    }

    public static String getDateTimeTs(Date dateTime) {
        String dateStr = DateTimeUtils.format((Date)dateTime, (String)"yyyy-MM-dd HH:mm:ss");
        return " {ts'" + dateStr + "'} ";
    }

    public static Date getStartDateTimeFromEFFDT(Date effdt) {
        Calendar now = Calendar.getInstance();
        int hour = now.get(11);
        int minutes = now.get(12);
        int seconds = now.get(13);
        Date startTime = DateTimeUtils.addSecond((Date)effdt, (long)seconds);
        startTime = DateTimeUtils.addMinute((Date)startTime, (long)minutes);
        startTime = DateTimeUtils.addHour((Date)startTime, (long)hour);
        return startTime;
    }

    public static Date getStartDateTimeFromMax(Date max) {
        Date startTime = DateTimeUtils.addMinute((Date)max, (long)5L);
        return startTime;
    }

    public static Date getDateTimeFromDate(Date date) {
        Date dateTime = DateTimeUtils.addSecond((Date)date, (long)59L);
        dateTime = DateTimeUtils.addMinute((Date)dateTime, (long)59L);
        dateTime = DateTimeUtils.addHour((Date)dateTime, (long)23L);
        return dateTime;
    }
}

