/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonException;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.hr.affair.EnrollBillEntryFactory;
import com.kingdee.eas.hr.affair.EnrollBillEntryInfo;
import com.kingdee.eas.hr.affair.IEnrollBillEntry;
import com.kingdee.eas.hr.base.HRBillBaseEntryCollection;
import com.kingdee.eas.hr.base.HROrgContextManagerFacadeFactory;
import com.kingdee.eas.hr.base.IHROrgContextManagerFacade;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.emp.app.util.EMPhelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class CheckPersonIdCardProcessor
extends AbstractBusinessProcessor {
    private boolean isIDCardVerify = true;
    private static final String paramNum = "IS_IDCARD_VERIFY";
    private static Logger logger = Logger.getLogger(CheckPersonIdCardProcessor.class);

    public CheckPersonIdCardProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchResults.getObjCollection() == null || batchResults.getObjCollection().size() == 0) {
            return;
        }
        PersonInfo pInfo = (PersonInfo)batchResults.getObjCollection().getObject(0);
        this._checkIdCardNumberAndPassportNumber(this.ctx, pInfo);
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return null;
    }

    private void _checkIdCardNumberAndPassportNumber(Context ctx, PersonInfo pInfo) throws BOSException, EASBizException {
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        if (pInfo != null) {
            String idCardNumber = pInfo.getIdCardNO();
            String passportNumber = pInfo.getPassportNO();
            this.isIDCardVerify = this.isIDcardVerify(ctx, pInfo);
            if (!StringUtils.isEmpty((String)idCardNumber)) {
                new IDCardCommonUtil(idCardNumber, this.isIDCardVerify);
                String _idCardNumber = null;
                String hrOrgUnit = null;
                if (pInfo.getHrOrgUnit() == null) {
                    if (pInfo.get("PositionList") != null) {
                        hrOrgUnit = EMPhelper.getPositionHROrgUnitID((Context)ctx, (String)EMPhelper.getPrimaryPositionId((PositionMemberCollection)((PositionMemberCollection)pInfo.get("PositionList"))));
                    } else if (pInfo.get("position") != null) {
                        hrOrgUnit = ((PositionInfo)pInfo.get("position")).getId().toString();
                    }
                } else {
                    hrOrgUnit = pInfo.getHrOrgUnit().getId().toString();
                }
                boolean isCheckIDCard18To15 = false;
                isCheckIDCard18To15 = hrOrgUnit == null ? HRParamUtil.getParamOfHR((Context)ctx, (String)"IsCheckIDCardNO18To15", null) : HRParamUtil.getParamOfHR((Context)ctx, (String)"IsCheckIDCardNO18To15", (String)hrOrgUnit);
                _idCardNumber = !isCheckIDCard18To15 ? idCardNumber : (idCardNumber.length() == 15 ? IDCardCommonUtil.IDCardNO15To18(idCardNumber) : IDCardCommonUtil.IDCardNO18To15(idCardNumber));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)idCardNumber, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)_idCardNumber, CompareType.EQUALS));
                filter.setMaskString("#0 or #1");
                if (pInfo.getId() != null) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)pInfo.getId().toString(), CompareType.NOTEQUALS));
                    filter.setMaskString("(#0 or #1) and #2");
                }
                EntityViewInfo viewInfo = new EntityViewInfo();
                viewInfo.setFilter(filter);
                SelectorItemCollection selector = viewInfo.getSelector();
                selector.add("id");
                selector.add("name");
                selector.add("number");
                PersonCollection pCol = iPerson.getPersonCollection(viewInfo);
                if (pCol != null && pCol.size() > 0) {
                    StringBuffer numbers = null;
                    int size = pCol.size();
                    for (int i = 0; i < size; ++i) {
                        if (numbers == null) {
                            numbers = new StringBuffer();
                        } else {
                            numbers.append(",");
                        }
                        numbers.append(pCol.get(i).getNumber());
                    }
                    throw new PersonException(PersonException.CARDNO_MUST_ONLY, new Object[]{pInfo.getNumber(), numbers == null ? "" : numbers.toString()});
                }
                GregorianCalendar cal = new GregorianCalendar();
                cal = new GregorianCalendar();
                SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                StringBuffer oql = new StringBuffer("select bill.number,number where idCardNumber = '");
                oql.append(idCardNumber.trim());
                oql.append("' ");
                Object enrollBillID = pInfo.get("PersonEnroll");
                if (enrollBillID != null && enrollBillID instanceof String) {
                    oql.append(" and bill.id != '");
                    oql.append((String)enrollBillID);
                    oql.append("' ");
                }
                oql.append(" and (bill.bizState = -1 or bill.bizState = 0 or bill.bizState = 1 or (bill.bizState = 3 and enrollDate > {ts'" + sFormat.format(cal.getTime()) + "'}))");
                IEnrollBillEntry iEnrollBillEntry = EnrollBillEntryFactory.getLocalInstance((Context)ctx);
                HRBillBaseEntryCollection coll = iEnrollBillEntry.getHRBillBaseEntryCollection(oql.toString());
                if (coll.size() > 0) {
                    throw new PersonException(PersonException.ENROLL_IDCARDNO_DUP, new Object[]{((EnrollBillEntryInfo)coll.get(0)).getBill().getNumber(), ((EnrollBillEntryInfo)coll.get(0)).getNumber()});
                }
            } else if (pInfo.getIdCardNO() != null) {
                pInfo.setIdCardNO(null);
            }
            if (!StringUtils.isEmpty((String)passportNumber)) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("passportNO", (Object)passportNumber, CompareType.EQUALS));
                if (pInfo.getId() != null) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)pInfo.getId(), CompareType.NOTEQUALS));
                }
                if (iPerson.exists(filter)) {
                    throw new PersonException(PersonException.PASSNO_MUST_ONLY, new Object[]{pInfo.getNumber()});
                }
            } else if (pInfo.getPassportNO() != null) {
                pInfo.setPassportNO(null);
            }
        }
    }

    public boolean isIDcardVerify(Context ctx, PersonInfo pInfo) throws BOSException, EASBizException {
        HROrgUnitInfo hrOrgUnit = null;
        String hrOrgId = null;
        String personID = null;
        if (pInfo == null) {
            return this.isIDCardVerify;
        }
        if (pInfo.getHrOrgUnit() != null) {
            hrOrgUnit = pInfo.getHrOrgUnit();
        } else if (pInfo.getId() != null) {
            personID = pInfo.getId().toString();
            IHROrgContextManagerFacade hrOrgContextManager = HROrgContextManagerFacadeFactory.getLocalInstance(ctx);
            hrOrgUnit = hrOrgContextManager.getHROByPerson(personID);
        }
        if (hrOrgUnit == null) {
            hrOrgUnit = ContextUtil.getCurrentHRUnit((Context)ctx);
        }
        if (hrOrgUnit != null) {
            hrOrgId = hrOrgUnit.getId().toString();
        }
        this.isIDCardVerify = HRParamUtil.getParamOfHR((Context)ctx, (String)paramNum, (String)hrOrgId);
        this.outputLog("bd_personControlBean:Get isIDCardVerify Param " + this.isIDCardVerify + " From Hro " + hrOrgId);
        return this.isIDCardVerify;
    }
}

