/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app.update;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmpJobGradeFactory;
import com.kingdee.eas.hr.base.EmpJobGradeInfo;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.Date;

public class UpdateEmpJobGrade {
    public void update(Context ctx) throws BOSException, EASBizException {
        this.updateJobGradeHistory(ctx);
        this.updateJobGradeCurrent(ctx);
    }

    private void updateJobGradeHistory(Context ctx) throws BOSException, EASBizException {
        String sql = "select jobgradehis.FJobGradeID FJobGradeID,ISNULL(jobgradehis.FJobGradeStartDate, jobgradehis.fcreatetime) feffectstartdate,  isnull(jobgradehis.FJobGradeEndDate,jobgradehis.fcreatetime) Feffectenddate,  jobgradehis.fpersonid fpersonid from T_HR_EmployeeJobGradeHistory jobgradehis where jobgradehis.fpersonid not in (select fpersonid from t_hr_empjobgrade) and jobgradehis.FJobGradeID is not null order by fpersonid,feffectstartdate asc ,Feffectenddate asc ";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowset.next()) {
                EmpJobGradeInfo empjobgradeInfo = new EmpJobGradeInfo();
                JobGradeInfo jobGradeInfo = new JobGradeInfo();
                jobGradeInfo.setId(BOSUuid.read((String)rowset.getString("FJobGradeID")));
                empjobgradeInfo.setJobGrade(jobGradeInfo);
                Date effectStartDate = rowset.getDate("feffectstartdate");
                if (effectStartDate == null) {
                    effectStartDate = DateTimeUtils.truncateDate((Date)new Date());
                }
                empjobgradeInfo.setEffectStartDate(effectStartDate);
                Date effectEndDate = rowset.getDate("Feffectenddate");
                if (effectEndDate == null) {
                    effectEndDate = DateTimeUtils.truncateDate((Date)new Date());
                }
                empjobgradeInfo.setEffectEndDate(effectEndDate);
                PersonInfo pInfo = new PersonInfo();
                pInfo.setId(BOSUuid.read((String)rowset.getString("fpersonid")));
                empjobgradeInfo.setPerson(pInfo);
                EmpJobGradeFactory.getLocalInstance(ctx).addNewOnly(empjobgradeInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateJobGradeCurrent(Context ctx) throws BOSException, EASBizException {
        String sql = "select pp.fpersonid fpersonid,pp.FJobGrade fjobgradeid,pp.FJobGradeEndDate feffectstartdate from t_hr_personposition pp  where pp.fjobgrade is not null  and pp.fjobgrade not in (   select empjobgrade.fjobgradeid from t_hr_empjobgrade empjobgrade where empjobgrade.fpersonid = pp.fpersonid and empjobgrade.FEffectStartDate<=getDate() and empjobgrade.FEffectEndDate >getDate())";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowset.next()) {
                EmpJobGradeInfo empjobgradeInfo = new EmpJobGradeInfo();
                JobGradeInfo jobGradeInfo = new JobGradeInfo();
                jobGradeInfo.setId(BOSUuid.read((String)rowset.getString("FJobGradeID")));
                empjobgradeInfo.setJobGrade(jobGradeInfo);
                Date effectStartDate = rowset.getDate("feffectstartdate");
                if (effectStartDate == null) {
                    effectStartDate = this.getLatestDate(ctx, rowset.getString("fpersonid"));
                    if (effectStartDate == null) {
                        effectStartDate = DateTimeUtils.truncateDate((Date)new Date());
                    }
                } else {
                    effectStartDate = DateTimeUtils.truncateDate((Date)effectStartDate);
                }
                empjobgradeInfo.setEffectStartDate(effectStartDate);
                empjobgradeInfo.setEffectEndDate(HRUtil.getMaxEndDate());
                PersonInfo pInfo = new PersonInfo();
                pInfo.setId(BOSUuid.read((String)rowset.getString("fpersonid")));
                empjobgradeInfo.setPerson(pInfo);
                EmpJobGradeFactory.getLocalInstance(ctx).addNewOnly(empjobgradeInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Date getLatestDate(Context ctx, String personid) {
        String sql = "select top 1 feffectenddate from t_hr_empjobgrade where fpersonid = ? order by feffectstartdate desc ,feffectenddate desc ";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{personid});
            if (rowSet.next()) {
                return DateUtil.getAfterDay((Date)rowSet.getDate("feffectenddate"));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }
}

