/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app.update;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.AssignTypeEnum;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.PositionStatuEnum;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationHelper;
import com.kingdee.eas.hr.base.app.util.EmpPosOrgUtil;
import com.kingdee.eas.hr.base.app.util.HROperateHandlerUtil;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;

public class UpdateEmpPosOrgRelationData {
    public void update(Context ctx) throws BOSException, EASBizException {
        this.updatePositionMember(ctx);
        this.updateGKPerson(ctx);
    }

    private void updateGKPerson(Context ctx) throws BOSException, EASBizException {
        String sql = "select pp.fpersonid fpersonid,pp.fprimarypositionid fpositionid,pp.fpersondep fadminorgunitid,pp.FLeftDate feffectdate ,pp.fgkadminid fgkadminid,person.femployeetypeid femployeetypeid from t_hr_personposition pp inner join t_bd_person person on person.fid=pp.fpersonid where pp.fpersonid not in( select fpersonid from t_hr_emporgrelation )  and person.femployeetypeid is not null and pp.fpersondep is not null ";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
        EmpPosOrgRelationHelper helper = new EmpPosOrgRelationHelper();
        EmpPosOrgRelationInfo info = null;
        HROperateHandlerUtil.setHaveOperatePermission(ctx);
        try {
            while (rowset.next()) {
                info = new EmpPosOrgRelationInfo();
                PersonInfo pInfo = new PersonInfo();
                pInfo.setId(BOSUuid.read((String)rowset.getString("fpersonid")));
                info.setPerson(pInfo);
                AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
                String adminID = rowset.getString("fadminorgunitid");
                adminInfo.setId(BOSUuid.read((String)adminID));
                info.setAdminOrg(adminInfo);
                Date effectDate = rowset.getDate("feffectdate");
                if (effectDate == null) {
                    effectDate = new Date();
                }
                info.setEFFDT(effectDate);
                info.setLEFFDT(HRUtil.getMaxEndDate());
                info.setAssignType(AssignTypeEnum.MAIN);
                info.setPositionstatus(PositionStatuEnum.Active);
                helper.cleanInfo(info);
                EmpPosOrgRelationFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            HROperateHandlerUtil.unSetHaveOperatePermission(ctx);
        }
    }

    private void updatePositionMember(Context ctx) throws BOSException, EASBizException {
        String sql = "select pm.fpersonid fpersonid,pm.fpositionid fpositionid,pm.fisprimary fprimary,ISNULL(pm.fbegindate,pm.fcreatetime) feffectdate,p.fadminorgunitid fadminorgunitid,person.femployeetypeid employeetypeid  from t_org_positionmember pm inner join t_org_position p on p.fid = pm.fpositionid inner join  t_bd_person person on person.fid=pm.fpersonid  where pm.fpersonid not in( select fpersonid from t_hr_emporgrelation ) and person.femployeetypeid is not null ";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
        EmpPosOrgRelationHelper helper = new EmpPosOrgRelationHelper();
        EmpPosOrgRelationInfo info = null;
        HROperateHandlerUtil.setHaveOperatePermission(ctx);
        try {
            while (rowset.next()) {
                info = new EmpPosOrgRelationInfo();
                PersonInfo pInfo = new PersonInfo();
                pInfo.setId(BOSUuid.read((String)rowset.getString("fpersonid")));
                info.setPerson(pInfo);
                PositionInfo poInfo = new PositionInfo();
                poInfo.setId(BOSUuid.read((String)rowset.getString("fpositionid")));
                info.setPosition(poInfo);
                AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
                adminInfo.setId(BOSUuid.read((String)rowset.getString("fadminorgunitid")));
                info.setAdminOrg(adminInfo);
                Date effectDate = rowset.getDate("feffectdate");
                if (effectDate == null) {
                    effectDate = new Date();
                }
                info.setEFFDT(effectDate);
                info.setLEFFDT(HRUtil.getMaxEndDate());
                info.setAssignType(EmpPosOrgUtil.getAssignType(rowset.getBoolean("fprimary")));
                info.setPositionstatus(PositionStatuEnum.Active);
                helper.cleanInfo(info);
                EmpPosOrgRelationFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            HROperateHandlerUtil.unSetHaveOperatePermission(ctx);
        }
    }
}

