/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class HRCheckEffectDateUtil {
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private static Logger logger = Logger.getLogger(HRCheckEffectDateUtil.class);

    public Map<String, Object> checkSHREffectDate(Context ctx, String orgID, java.util.Date date, boolean isContainSubOrg) throws BOSException {
        AdminOrgUnitInfo info = HRCheckEffectDateUtil.getAdminOrgInfo(ctx, orgID);
        HashMap<String, Object> respone = new HashMap<String, Object>();
        String longnumber = null;
        String name = null;
        if (null != info) {
            longnumber = info.getLongNumber();
            name = info.getName();
        }
        Map<String, Object> res1 = this.checkParentOrgEffectDate(ctx, longnumber, date);
        logger.error((Object)("All parent organizations res1===" + res1.toString()));
        Map<String, Object> res3 = this.checkPerPosEffectDate(ctx, orgID, date, isContainSubOrg, longnumber);
        logger.error((Object)("All employees are currently employed res3===" + res3.toString()));
        Map<String, Object> res4 = this.checkSubOrgEffectDate(ctx, longnumber, date);
        logger.error((Object)("All subordinate organizations res4===" + res4.toString()));
        if ("false".equalsIgnoreCase(res1.get("success").toString()) || "false".equalsIgnoreCase(res3.get("success").toString()) || "false".equalsIgnoreCase(res4.get("success").toString())) {
            respone.put("sucess", false);
            respone.put("message", SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label128", (Context)ctx));
            return respone;
        }
        ArrayList<java.util.Date> minDateList = new ArrayList<java.util.Date>();
        ArrayList<java.util.Date> maxDateList = new ArrayList<java.util.Date>();
        if (!"".equalsIgnoreCase(res1.get("date").toString())) {
            maxDateList.add((java.util.Date)res1.get("date"));
        }
        if (!"".equalsIgnoreCase(res3.get("date").toString())) {
            minDateList.add((java.util.Date)res3.get("date"));
        }
        if (!"".equalsIgnoreCase(res4.get("date").toString())) {
            minDateList.add((java.util.Date)res4.get("date"));
        }
        java.util.Date minDate = HRCheckEffectDateUtil.getMinDate(minDateList);
        java.util.Date maxDate = HRCheckEffectDateUtil.getMaxDate(maxDateList);
        String message = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label129", (Context)ctx), name);
        respone.put("sucess", true);
        if (null != minDate) {
            respone.put("sucess", false);
            message = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label130", (Context)ctx), message, this.format.format(minDate));
        }
        if (null != maxDate) {
            respone.put("sucess", false);
            message = null == minDate ? MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label131", (Context)ctx), message, this.format.format(maxDate)) : MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label132", (Context)ctx), message, this.format.format(maxDate));
        }
        respone.put("message", message);
        return respone;
    }

    public Map<String, Object> checkParentOrgEffectDate(Context ctx, String longnumber, java.util.Date date) throws BOSException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("success", true);
        res.put("date", "");
        if (StringUtil.isEmpty((String)longnumber)) {
            res.put("success", false);
            return res;
        }
        Set<String> parentNumSet = this.getParentIdSet(longnumber);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", parentNumSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isStartSHR", (Object)1));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        AdminOrgUnitCollection adminOrgUnitCollection = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(viewInfo);
        ArrayList<String> orgIdList = new ArrayList<String>();
        int size = adminOrgUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            orgIdList.add(adminOrgUnitCollection.get(i).getId().toString());
        }
        if (orgIdList.size() > 0) {
            String orgIdSetString = HRUtilExtend.getStrFromList(orgIdList);
            StringBuffer sql = new StringBuffer();
            sql.append("select FHISTORYRELATEID,min(feffdt)  from T_ORG_ADMINHis ").append(" where FHISTORYRELATEID in (select fid from T_ORG_ADMIN where fid in ").append(orgIdSetString).append(")").append(" group by FHISTORYRELATEID order by min(feffdt) desc");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                Date maxEffdtDate;
                if (rs.next() && DateTimeUtils.dayBefore((java.util.Date)date, (java.util.Date)(maxEffdtDate = rs.getDate(2)))) {
                    res.put("date", maxEffdtDate);
                }
            }
            catch (SQLException e1) {
                throw new BOSException((Throwable)e1);
            }
        }
        return res;
    }

    private Set<String> getParentIdSet(String longnumber) {
        String[] parentNumArray = longnumber.split("!");
        HashSet<String> parentNumSet = new HashSet<String>();
        String parentNum = "";
        int size = parentNumArray.length - 1;
        for (int i = 0; i < size; ++i) {
            parentNum = i == 0 ? parentNumArray[i] : parentNum + "!" + parentNumArray[i];
            parentNumSet.add(parentNum);
        }
        return parentNumSet;
    }

    public Map<String, Object> checkParentPosEffectDate(Context ctx, String orgID, java.util.Date date) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("success", true);
        res.put("date", "");
        StringBuffer buf = new StringBuffer();
        buf.append("select fHistoryRelateId,min(feffdt) from t_org_positionHis where fHistoryRelateId in (");
        buf.append("select fparentid from T_ORG_PositionHierarchy where fchildid in (");
        buf.append("select pos.fid from T_ORG_Position pos inner join T_org_admin  org on pos.fadminorgunitId=org.fid and org.fid='" + orgID + "'))");
        buf.append("  group by fHistoryRelateId order by min(feffdt) asc");
        try {
            Date feffdt;
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
            if (rowset.next() && null != (feffdt = rowset.getDate(2)) && feffdt.getTime() < date.getTime()) {
                res.put("date", feffdt);
            }
        }
        catch (Exception e) {
            res.put("success", false);
            e.printStackTrace();
        }
        return res;
    }

    public Map<String, Object> checkPerPosEffectDate(Context ctx, String orgID, java.util.Date date, boolean isContainSubOrg, String longnumber) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("success", true);
        res.put("date", "");
        StringBuffer buf = new StringBuffer();
        if (!isContainSubOrg) {
            buf.append("select feffdt from T_HR_EMPORGRELATION where fisinner=1 and fpositionid in (");
            buf.append("select pos.fid from T_ORG_Position pos inner join T_org_admin  org on pos.fadminorgunitId=org.fid and org.fid='" + orgID + "')");
            buf.append(" order by feffdt asc");
        } else {
            buf.append("select feffdt from T_HR_EMPORGRELATION where fisinner=1 and fpositionid in (");
            buf.append("select pos.fid from T_ORG_Position pos inner join T_org_admin  org on pos.fadminorgunitId=org.fid and (org.flongnumber='" + longnumber + "' or org.flongnumber like '" + longnumber + "!%'))");
            buf.append(" order by feffdt asc");
        }
        try {
            Date FBeginDate;
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
            if (rowset.next() && null != (FBeginDate = rowset.getDate("feffdt")) && FBeginDate.getTime() < date.getTime()) {
                res.put("date", FBeginDate);
            }
        }
        catch (Exception e) {
            res.put("success", false);
            e.printStackTrace();
        }
        return res;
    }

    public Map<String, Object> checkSubOrgEffectDate(Context ctx, String longnumber, java.util.Date date) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("success", true);
        res.put("date", "");
        StringBuffer sql = new StringBuffer();
        sql.append("select FHISTORYRELATEID,min(feffdt)  from T_ORG_ADMINHis ").append(" where FHISTORYRELATEID in (select fid from T_ORG_ADMIN where fisstartshr=1 and flongnumber like '").append(longnumber).append("!%'").append(")").append("  group by FHISTORYRELATEID order by min(feffdt)");
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowset.next()) {
                Date feffdt = rowset.getDate(2);
                if (null == feffdt || feffdt.getTime() >= date.getTime()) continue;
                res.put("date", feffdt);
                break;
            }
        }
        catch (Exception e) {
            res.put("success", false);
            e.printStackTrace();
        }
        return res;
    }

    public Map<String, Object> checkSubPosEffectDate(Context ctx, String orgID, java.util.Date date) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("success", true);
        res.put("date", "");
        ArrayList<java.util.Date> effdtList = new ArrayList<java.util.Date>();
        StringBuffer buf = new StringBuffer();
        buf.append("select hie.fisleaf as fisleaf,hie.flongnumber as flongnumber,min(posHis.feffdt) as feffdt from T_ORG_PositionHierarchy hie").append(" left join t_org_positionHis posHis on posHis.fhistoryrelateid=hie.fchildid where hie.fparentid in  ").append(" (select pos.fid from T_ORG_Position pos inner join T_org_admin org on pos.fadminorgunitId=org.fid and org.fid='").append(orgID).append("' and org.fIsStartSHR=1)").append(" group by posHis.fhistoryrelateid,fisleaf,flongnumber");
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
            while (rowset.next()) {
                Date feffdt = rowset.getDate("feffdt");
                String longnumber = rowset.getString("flongnumber");
                boolean fisleaf = rowset.getBoolean("fisleaf");
                if (fisleaf) {
                    effdtList.add(feffdt);
                    continue;
                }
                StringBuffer sqlbuf = new StringBuffer();
                sqlbuf.append("select posHis.fHistoryRelateId as fHistoryRelateId,min(posHis.feffdt) as feffdt from t_org_positionHis posHis").append(" where posHis.fHistoryRelateId in ").append("    (select pos.fid from T_ORG_PositionHierarchy hie left join T_org_position pos on pos.fid=hie.fchildid").append(" \t\tinner join t_org_admin org on org.fid=pos.fadminorgunitId ").append("       where org.fIsStartSHR=1 flongnumber like '").append(longnumber).append("!%')").append("  group by posHis.fHistoryRelateId");
                IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sqlbuf.toString());
                while (set.next()) {
                    Date feffdt1 = set.getDate("feffdt");
                    effdtList.add(feffdt1);
                }
            }
        }
        catch (Exception e) {
            res.put("success", false);
            e.printStackTrace();
        }
        java.util.Date min = HRCheckEffectDateUtil.getMinDate(effdtList);
        if (null != min && date.getTime() > min.getTime()) {
            res.put("date", min);
        }
        return res;
    }

    public static AdminOrgUnitInfo getAdminOrgInfo(Context ctx, String orgID) {
        AdminOrgUnitInfo info = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgID));
        evi.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("longnumber"));
        selector.add(new SelectorItemInfo("name"));
        AdminOrgUnitCollection con = null;
        try {
            con = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (null != con && con.size() > 0) {
            info = con.get(0);
        }
        return info;
    }

    public static java.util.Date getMinDate(List<java.util.Date> list) {
        java.util.Date resDate = null;
        if (null == list || list.size() <= 0) {
            return resDate;
        }
        resDate = list.get(0);
        for (int i = 0; i < list.size() - 1; ++i) {
            if (resDate.getTime() <= list.get(i + 1).getTime()) continue;
            resDate = list.get(i + 1);
        }
        return resDate;
    }

    public static java.util.Date getMaxDate(List<java.util.Date> list) {
        java.util.Date resDate = null;
        if (null == list || list.size() <= 0) {
            return resDate;
        }
        resDate = list.get(0);
        for (int i = 0; i < list.size() - 1; ++i) {
            if (resDate.getTime() >= list.get(i + 1).getTime()) continue;
            resDate = list.get(i + 1);
        }
        return resDate;
    }
}

