/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.hr.base.HRBaseException;
import com.kingdee.eas.hr.base.formula.HRCmpCalculator;
import com.kingdee.eas.hr.base.formula.HRFormulaInfo;
import com.kingdee.eas.hr.base.formula.SalPointFormulaInfo;
import com.kingdee.eas.hr.compensation.SalariatSchemeFactory;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class HRCmpSalCalculator
extends HRCmpCalculator {
    private static Logger logger = Logger.getLogger(HRCmpSalCalculator.class);
    private Map hroFormulaMap = new HashMap();

    public HRCmpSalCalculator(ICalculateContextProvider provider, Context ctx, String sheetName) {
        super(provider, ctx, sheetName);
    }

    @Override
    protected boolean checkParams(Parameter parameter) throws Exception {
        HRBaseException _exception = new HRBaseException(HRBaseException.ORGUNITNUMBERISERROR);
        SyntaxErrorException exception = new SyntaxErrorException(128L);
        SyntaxErrorException orgException = new SyntaxErrorException(128L, (Object)_exception.getMessage());
        String orgUnitNumber = (String)((Variant)parameter.getArgs()[0]).getValue();
        String salAllName = (String)((Variant)parameter.getArgs()[1]).getValue();
        String cmpItemNumber = (String)((Variant)parameter.getArgs()[2]).getValue();
        if (StringUtils.isEmpty((String)salAllName) || StringUtils.isEmpty((String)cmpItemNumber)) {
            parameter.setValue((Object)exception);
            return false;
        }
        if (orgUnitNumber.indexOf(";") >= 0) {
            parameter.setValue((Object)orgException);
            return false;
        }
        return true;
    }

    @Override
    protected HRFormulaInfo getFormulaInfo(Parameter parameter) {
        return new SalPointFormulaInfo(parameter);
    }

    @Override
    protected void doOtherThingForSub(HRFormulaInfo formulaInfo) {
        String key = formulaInfo.getOrgNumber();
        List<HRFormulaInfo> orgFormulaList = null;
        if (this.hroFormulaMap.containsKey(key)) {
            orgFormulaList = (List)this.hroFormulaMap.get(key);
        } else {
            orgFormulaList = new ArrayList();
            this.hroFormulaMap.put(key, orgFormulaList);
        }
        orgFormulaList.add(formulaInfo);
    }

    @Override
    protected void fillValue() throws Exception {
    }

    @Override
    protected void clear() {
        super.clear();
        this.hroFormulaMap.clear();
    }

    @Override
    protected void calculate() throws Exception {
        if (this.hroFormulaMap == null || this.hroFormulaMap.isEmpty()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select top 1 sch.fid,sch.FPOINTTABLENAME as tableName ").append(" from t_hr_salariatsch sch inner join t_org_hro h on h.fid = sch.fhrorgunitid ").append(" where sch.FSTATE = 1 and h.fnumber = ?");
        Set keySet = this.hroFormulaMap.keySet();
        String hroNumber = null;
        String salSchemeID = null;
        String tableName = null;
        List salFormulaList = null;
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            Map salPointMap;
            hroNumber = iter.next().toString();
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString(), (Object[])new Object[]{hroNumber});
            while (rs.next()) {
                salSchemeID = rs.getString("fid");
                tableName = rs.getString("tableName");
            }
            double standardBase = 1.0;
            if (salSchemeID != null) {
                ObjectUuidPK schemePK = new ObjectUuidPK(BOSUuid.read((String)salSchemeID));
                SalariatSchemeInfo salariatSchemeInfo = (SalariatSchemeInfo)SalariatSchemeFactory.getLocalInstance((Context)this.ctx).getValue((IObjectPK)schemePK);
                boolean isStandardBase = salariatSchemeInfo.isFlagStandardBase();
                if (isStandardBase && (standardBase = salariatSchemeInfo.getStandardBase()) <= 0.0) {
                    standardBase = 1.0;
                }
            }
            if ((salPointMap = this.getSalPointMap(salSchemeID)) == null) continue;
            salFormulaList = (List)this.hroFormulaMap.get(hroNumber);
            SalPointFormulaInfo salFormulaInfo = null;
            String salPointID = null;
            for (int i = 0; i < salFormulaList.size(); ++i) {
                salFormulaInfo = (SalPointFormulaInfo)salFormulaList.get(i);
                salPointID = (String)salPointMap.get(salFormulaInfo.getSalAllName());
                if (StringUtils.isEmpty((String)salPointID)) {
                    salFormulaInfo.setValue(new BigDecimal("0.00"));
                    continue;
                }
                salFormulaInfo.setSalPointID(salPointID);
            }
            if (HRUtils.getParamValue((Context)this.ctx, (String)"hr_cmp_011", null)) {
                this.doSalPointSalGrade(salSchemeID, tableName, salFormulaList, standardBase);
                continue;
            }
            this.doSalPointSalGradeFalse(tableName, salFormulaList, standardBase);
        }
    }

    private void doSalPointSalGrade(String salSchemeID, String tableName, List salFormulaList, double standardBase) throws Exception {
        Map salPointGradeMap = this.getSalPointSalGradeNumber(this.ctx, salSchemeID);
        StringBuffer sql = new StringBuffer(1024);
        sql.append(" select * ");
        sql.append(" from ").append(tableName);
        IRowSet result = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        IRowSetMetaData metaData = result.getRowSetMetaData();
        boolean isContainPointSalGradeCol = false;
        int size = metaData.getColumnCount() + 1;
        for (int i = 1; i < size; ++i) {
            if (!"FSalPointSalGradeID".equalsIgnoreCase(metaData.getColumnName(i))) continue;
            isContainPointSalGradeCol = true;
            break;
        }
        if (!isContainPointSalGradeCol) {
            throw new Exception(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.NO_SALPOINTSALGRADE"));
        }
        BigDecimal value = null;
        String salPointID = null;
        SalPointFormulaInfo salFormulaInfo = null;
        String salPointSalGradeNumber = null;
        block1: while (result.next()) {
            salPointID = result.getString("FPointID");
            String salPointSalGradeID = result.getString("FSalPointSalGradeID");
            String newPointId = null;
            String itemNumber = null;
            String salPointSalGradeNewID = "";
            for (int i = 0; i < salFormulaList.size(); ++i) {
                salFormulaInfo = (SalPointFormulaInfo)salFormulaList.get(i);
                newPointId = salFormulaInfo.getSalPointID();
                itemNumber = salFormulaInfo.getCmpItemNumber();
                salPointSalGradeNumber = salFormulaInfo.getSalPointSalGradeNumber();
                if (!StringUtils.isEmpty((String)salPointSalGradeNumber) && salPointGradeMap != null) {
                    salPointSalGradeNewID = (String)salPointGradeMap.get(salPointSalGradeNumber);
                }
                if (!salPointID.equals(newPointId) || !StringUtils.isEmpty((String)salPointSalGradeNewID) && !salPointSalGradeNewID.equals(salPointSalGradeID) || StringUtils.isEmpty((String)salPointSalGradeNumber) && !StringUtils.isEmpty((String)salPointSalGradeID)) continue;
                value = result.getBigDecimal(itemNumber);
                if (value != null) {
                    value = value.multiply(BigDecimal.valueOf(standardBase));
                }
                salFormulaInfo.setValue(value);
                continue block1;
            }
        }
    }

    private void doSalPointSalGradeFalse(String tableName, List salFormulaList, double standardBase) throws Exception {
        StringBuffer sql = new StringBuffer(1024);
        sql.append(" select * ");
        sql.append(" from ").append(tableName);
        IRowSet result = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        BigDecimal value = new BigDecimal("0.00");
        String salPointID = null;
        SalPointFormulaInfo salFormulaInfo = null;
        block0: while (result.next()) {
            salPointID = result.getString("FPointID");
            String newPointId = null;
            String itemNumber = null;
            for (int i = 0; i < salFormulaList.size(); ++i) {
                salFormulaInfo = (SalPointFormulaInfo)salFormulaList.get(i);
                newPointId = salFormulaInfo.getSalPointID();
                itemNumber = salFormulaInfo.getCmpItemNumber();
                if (!salPointID.equals(newPointId)) continue;
                value = result.getBigDecimal(itemNumber);
                if (value != null) {
                    value = value.multiply(BigDecimal.valueOf(standardBase));
                }
                salFormulaInfo.setValue(value);
                continue block0;
            }
        }
    }

    private Map getSalPointMap(String salSchemeID) throws BOSException {
        if (StringUtils.isEmpty((String)salSchemeID)) {
            return null;
        }
        String localLanguage = this.ctx.getLocale().getLanguage();
        HashMap<String, String> salPointMap = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select parent.fname_" + localLanguage + "||' - '||sub.fname_" + localLanguage + " as allName,sub.fid as id ");
        sb.append(" from t_hr_salariattree sub inner join t_hr_salariattree parent on sub.fparentid = parent.fid  ");
        sb.append(" where  sub.fschemeid = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString(), (Object[])new Object[]{salSchemeID});
        String salPointID = null;
        String allName = null;
        try {
            while (rs.next()) {
                salPointID = rs.getString("id");
                allName = rs.getString("allName");
                salPointMap.put(allName, salPointID);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return salPointMap;
    }

    private Map getSalPointSalGradeNumber(Context ctx, String salSchemeID) {
        String sql = "select * from T_HR_SalariatPointSalariaGrade where fsalariatSchemeID =? ";
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{salSchemeID});
            while (rs.next()) {
                map.put(rs.getString("fnumber"), rs.getString("FID"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
        return map;
    }
}

