/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.MutableTreeNode;
import org.apache.commons.lang3.CharUtils;
import org.apache.log4j.Logger;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class OrgStringUtil {
    private static Logger logger = Logger.getLogger(OrgStringUtil.class);
    private static String SEPARATOR_IDS = "@79931a4a-aa3a-4271-fe04-0a8c01c3d56a1234@";

    public static String orgInfoArr2String(Object[] orgInfos) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < orgInfos.length; ++i) {
            if (i != 0) {
                result.append(SEPARATOR_IDS);
            }
            AdminOrgUnitInfo orgInfo = (AdminOrgUnitInfo)orgInfos[i];
            result.append(orgInfo.getId().toString());
        }
        return result.toString();
    }

    public static Object[] string2OrgInfoArr(String orgArrStr) {
        return OrgStringUtil.string2OrgInfoArr(null, orgArrStr, true);
    }

    public static Object[] string2OrgInfoArr(Context ctx, String orgArrStr, boolean isNeedInfo) {
        ArrayList<Object> orgInfos = new ArrayList<Object>();
        String[] ids = orgArrStr.split(SEPARATOR_IDS);
        StringBuffer oql = new StringBuffer();
        oql.append("select id,number, isVirtual, longNumber,name,displayName,level,parent.id where id in (");
        for (int i = 0; i < ids.length; ++i) {
            if (i != 0) {
                oql.append(",");
            }
            oql.append("'");
            oql.append(ids[i]);
            oql.append("'");
            if (isNeedInfo) continue;
            AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
            adminInfo.setId(BOSUuid.read((String)ids[i]));
            orgInfos.add(adminInfo);
        }
        oql.append(")");
        if (!isNeedInfo) {
            return orgInfos.toArray();
        }
        try {
            int i;
            HashMap<String, AdminOrgUnitInfo> adminMap = new HashMap<String, AdminOrgUnitInfo>();
            IAdminOrgUnit iadmin = null;
            iadmin = ctx == null ? AdminOrgUnitFactory.getRemoteInstance() : AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            AdminOrgUnitCollection col = iadmin.getAdminOrgUnitCollection(oql.toString());
            for (i = 0; i < col.size(); ++i) {
                AdminOrgUnitInfo admininfo = col.get(i);
                adminMap.put(admininfo.getId().toString(), admininfo);
            }
            for (i = 0; i < ids.length; ++i) {
                if (adminMap.get(ids[i]) == null) continue;
                orgInfos.add(adminMap.get(ids[i]));
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return orgInfos.toArray();
    }

    public static String positionInfoArr2String(Object[] posiInfos) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < posiInfos.length; ++i) {
            if (i != 0) {
                result.append(SEPARATOR_IDS);
            }
            PositionInfo posiInfo = (PositionInfo)posiInfos[i];
            result.append(posiInfo.getId().toString());
        }
        return result.toString();
    }

    public static Object[] string2PositionInfoArr(Context ctx, String posiArrStr, boolean isNeedInfo) {
        ArrayList<Object> posiInfos = new ArrayList<Object>();
        String[] ids = posiArrStr.split(SEPARATOR_IDS);
        StringBuffer oql = new StringBuffer();
        oql.append("select id,name,number,adminOrgUnit.id,adminOrgUnit.* where id in (");
        for (int i = 0; i < ids.length; ++i) {
            if (i != 0) {
                oql.append(",");
            }
            oql.append("'");
            oql.append(ids[i]);
            oql.append("'");
            if (isNeedInfo) continue;
            PositionInfo posiInfo = new PositionInfo();
            posiInfo.setId(BOSUuid.read((String)ids[i]));
            posiInfos.add(posiInfo);
        }
        oql.append(")");
        if (!isNeedInfo) {
            return posiInfos.toArray();
        }
        try {
            int i;
            HashMap<String, PositionInfo> posiMap = new HashMap<String, PositionInfo>();
            IPosition iposi = null;
            iposi = ctx == null ? PositionFactory.getRemoteInstance() : PositionFactory.getLocalInstance((Context)ctx);
            PositionCollection col = iposi.getPositionCollection(oql.toString());
            for (i = 0; i < col.size(); ++i) {
                PositionInfo posiInfo = col.get(i);
                posiMap.put(posiInfo.getId().toString(), posiInfo);
            }
            for (i = 0; i < ids.length; ++i) {
                if (posiMap.get(ids[i]) == null) continue;
                posiInfos.add(posiMap.get(ids[i]));
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return posiInfos.toArray();
    }

    public static Object[] string2PositionInfoArr(String posiArrStr) {
        return OrgStringUtil.string2PositionInfoArr(null, posiArrStr, true);
    }

    public static String getOrgIdsSql(Object[] orgs) {
        StringBuffer sql = new StringBuffer();
        if (orgs != null) {
            for (int i = 0; i < orgs.length; ++i) {
                if (i != 0) {
                    sql.append(",");
                }
                OrgUnitInfo org = (OrgUnitInfo)orgs[i];
                sql.append("'");
                sql.append(org.getId().toString());
                sql.append("'");
            }
        }
        return sql.toString();
    }

    public static String getOrgsSqlIncludeChild(String orgIdCol, String orgLongNumbercol, Object[] orgs) {
        ArrayList<OrgUnitInfo> leafOrgList = new ArrayList<OrgUnitInfo>();
        ArrayList<OrgUnitInfo> noneLeafOrgList = new ArrayList<OrgUnitInfo>();
        StringBuffer sql = new StringBuffer();
        if (orgs != null) {
            OrgUnitInfo org;
            int i;
            sql.append("(");
            for (i = 0; i < orgs.length; ++i) {
                org = (OrgUnitInfo)orgs[i];
                if (org.isIsLeaf()) {
                    leafOrgList.add(org);
                    continue;
                }
                noneLeafOrgList.add(org);
            }
            if (leafOrgList.size() > 0) {
                sql.append(orgIdCol);
                sql.append(" in (");
                for (i = 0; i < leafOrgList.size(); ++i) {
                    if (i != 0) {
                        sql.append(",");
                    }
                    org = (OrgUnitInfo)leafOrgList.get(i);
                    sql.append("'");
                    sql.append(org.getId().toString());
                    sql.append("'");
                }
                sql.append(")");
            }
            if (leafOrgList.size() > 0 && noneLeafOrgList.size() > 0) {
                sql.append(" or ");
            }
            if (noneLeafOrgList.size() > 0) {
                for (i = 0; i < noneLeafOrgList.size(); ++i) {
                    if (i != 0) {
                        sql.append(" or ");
                    }
                    if (StringUtils.isEmpty((String)(org = (OrgUnitInfo)noneLeafOrgList.get(i)).getLongNumber())) {
                        throw new RuntimeException(org + "[" + org.getId().toString() + "] 's longNumber is empty!");
                    }
                    sql.append(orgLongNumbercol);
                    sql.append(" like '");
                    sql.append(org.getLongNumber());
                    sql.append("%' ");
                }
            }
            sql.append(")");
        }
        return sql.toString();
    }

    public static List getRootAdminsFromTree(Map treeNodeHashMap, Object[] orgs) {
        int i;
        if (treeNodeHashMap == null || treeNodeHashMap.keySet().size() == 0) {
            return new ArrayList();
        }
        ArrayList<Object> adminIdList = new ArrayList<Object>();
        HashSet<String> orgsSet = new HashSet<String>();
        for (i = 0; i < orgs.length; ++i) {
            if (orgs[i] == null) continue;
            orgsSet.add(((AdminOrgUnitInfo)orgs[i]).getId().toString());
        }
        for (i = 0; i < orgs.length; ++i) {
            AdminOrgUnitInfo adminInfo;
            String adminId;
            DefaultKingdeeTreeNode treeNode;
            if (orgs[i] == null || (treeNode = (DefaultKingdeeTreeNode)treeNodeHashMap.get(adminId = (adminInfo = (AdminOrgUnitInfo)orgs[i]).getId().toString())) == null) continue;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)treeNode.getParent();
            boolean isParentInOrgsSet = false;
            for (int j = 0; j < 1000 && node != null; node = (DefaultKingdeeTreeNode)node.getParent(), ++j) {
                if (!orgsSet.contains(((AdminOrgUnitInfo)node.getUserObject()).getId().toString())) continue;
                isParentInOrgsSet = true;
                break;
            }
            if (isParentInOrgsSet) continue;
            adminIdList.add(treeNode.getUserObject());
        }
        return adminIdList;
    }

    public static DefaultKingdeeTreeNode reBuildTreeNodeByOrgs(Map treeNodeHashMap, Object[] orgs) {
        return OrgStringUtil.reBuildTreeNodeByOrgs(treeNodeHashMap, orgs, true);
    }

    public static DefaultKingdeeTreeNode reBuildTreeNodeByOrgs(Map treeNodeHashMap, Object[] orgs, boolean showVirtualOrg) {
        List rootAdminList = OrgStringUtil.getRootAdminsFromTree(treeNodeHashMap, orgs);
        if (rootAdminList.size() > 1) {
            DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
            for (int i = 0; i < rootAdminList.size(); ++i) {
                AdminOrgUnitInfo rootAdminInfo = (AdminOrgUnitInfo)rootAdminList.get(i);
                DefaultKingdeeTreeNode rootAdmin = (DefaultKingdeeTreeNode)treeNodeHashMap.get(rootAdminInfo.getId().toString());
                if (!showVirtualOrg) {
                    if (rootAdminInfo.isIsVirtual()) continue;
                    root.add((MutableTreeNode)rootAdmin);
                    continue;
                }
                root.add((MutableTreeNode)rootAdmin);
            }
            return root;
        }
        if (rootAdminList.size() == 1) {
            AdminOrgUnitInfo rootAdminInfo = (AdminOrgUnitInfo)rootAdminList.get(0);
            DefaultKingdeeTreeNode root = null;
            if (!showVirtualOrg) {
                if (!rootAdminInfo.isIsVirtual()) {
                    root = (DefaultKingdeeTreeNode)treeNodeHashMap.get(rootAdminInfo.getId().toString());
                }
            } else {
                root = (DefaultKingdeeTreeNode)treeNodeHashMap.get(rootAdminInfo.getId().toString());
            }
            return root;
        }
        return null;
    }

    public static DefaultKingdeeTreeNode buildTreeNodeByOrgs(Object[] orgs) {
        TreeMap<String, Object> longNumberOrgMap = new TreeMap<String, Object>();
        HashMap<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        ArrayList<DefaultKingdeeTreeNode> rootOrgList = new ArrayList<DefaultKingdeeTreeNode>();
        for (int i = 0; i < orgs.length; ++i) {
            longNumberOrgMap.put(((AdminOrgUnitInfo)orgs[i]).getLongNumber(), orgs[i]);
        }
        Iterator it = longNumberOrgMap.entrySet().iterator();
        for (Map.Entry entry : longNumberOrgMap.entrySet()) {
            logger.info(entry.getKey());
        }
        for (Map.Entry entry : longNumberOrgMap.entrySet()) {
            AdminOrgUnitInfo org = (AdminOrgUnitInfo)entry.getValue();
            String longNumber = org.getLongNumber();
            int lastIndex = longNumber.lastIndexOf(33);
            String parentLongNumber = null;
            if (lastIndex > 0) {
                parentLongNumber = longNumber.substring(0, lastIndex);
            }
            if (nodeMap.get(parentLongNumber) != null) {
                DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)nodeMap.get(parentLongNumber);
                DefaultKingdeeTreeNode treeNode = new DefaultKingdeeTreeNode();
                treeNode.setUserObject((Object)org);
                parentNode.add((MutableTreeNode)treeNode);
                nodeMap.put(org.getLongNumber(), treeNode);
                continue;
            }
            for (int i = 0; i < orgs.length; ++i) {
                if (!longNumber.startsWith(((AdminOrgUnitInfo)orgs[i]).getLongNumber()) || org == orgs[i]) continue;
                return null;
            }
            DefaultKingdeeTreeNode rootTreeNode = new DefaultKingdeeTreeNode();
            rootTreeNode.setUserObject((Object)org);
            nodeMap.put(org.getLongNumber(), rootTreeNode);
            rootOrgList.add(rootTreeNode);
        }
        if (rootOrgList.size() > 1) {
            DefaultKingdeeTreeNode rootTreeNode = new DefaultKingdeeTreeNode();
            for (int i = 0; i < rootOrgList.size(); ++i) {
                DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)rootOrgList.get(i);
                rootTreeNode.add((MutableTreeNode)treeNode);
            }
            return rootTreeNode;
        }
        return (DefaultKingdeeTreeNode)rootOrgList.get(0);
    }

    public static ZipFile parseZipFile(File unZipFile) throws IOException {
        ZipFile utfFile = new ZipFile(unZipFile, "UTF-8");
        ZipEntry ze = null;
        String zeName = null;
        Enumeration zList = utfFile.getEntries();
        boolean isUtfEncode = true;
        while (zList.hasMoreElements()) {
            ze = (ZipEntry)zList.nextElement();
            zeName = ze.getName();
            if (zeName == null || !OrgStringUtil.isMessyCode(zeName)) continue;
            isUtfEncode = false;
            break;
        }
        return isUtfEncode ? utfFile : new ZipFile(unZipFile, "GBK");
    }

    public static boolean isMessyCode(String strName) {
        Pattern pattern = Pattern.compile("\\s*|\t*|\r*|\n*");
        Matcher m = pattern.matcher(strName);
        String after = m.replaceAll("");
        String temp = after.replaceAll("\\p{P}", "");
        char[] ch = temp.trim().toCharArray();
        int length = ch != null ? ch.length : 0;
        String str = null;
        for (int i = 0; i < length; ++i) {
            char c = ch[i];
            if (CharUtils.isAsciiAlphanumeric((char)c) || (str = String.valueOf(c)).matches("[\u4e00-\u9fa5]+") || Character.isWhitespace(c)) continue;
            return true;
        }
        return false;
    }
}

