/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.ICodingRuleManageFacade;
import com.kingdee.eas.hr.base.client.IHRBillEditUIBiz;
import com.kingdee.eas.hr.base.util.CodingRuleData;
import com.kingdee.eas.hr.contract.ContractChangeBizBillFactory;
import com.kingdee.eas.hr.contract.ContractChangeBizBillInfo;
import com.kingdee.eas.hr.contract.client.AbstractContractChangeBizBillEditUI;
import com.kingdee.eas.hr.contract.client.ContractChangeBizBillEditUIBiz;
import com.kingdee.eas.hr.emp.ContractTypeInfo;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ContractChangeBizBillEditUI
extends AbstractContractChangeBizBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ContractChangeBizBillEditUI.class);
    protected final Color CANNOT_INPUT_COLOR = new Color(208, 208, 208);
    protected final Color MUST_INPUT_COLOR = new Color(252, 251, 223);
    private String resourceStr = "com.kingdee.eas.hr.contract.ContractResource";

    public void onLoad() throws Exception {
        super.onLoad();
        if ("EDIT".equals(this.getOprtState()) || "ADDNEW".equals(this.getOprtState())) {
            this.setContractNoStyle();
        }
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        if ("VIEW".equals(this.getOprtState())) {
            this.btnColumnCopyAll.setEnabled(false);
            this.btnColumnCopySelect.setEnabled(false);
            this.menuItemColumnCopyAll.setEnabled(false);
            this.menuItemColumnCopySelect.setEnabled(false);
        }
    }

    protected IHRBillEditUIBiz getBillBiz() {
        if (this.biz == null) {
            return new ContractChangeBizBillEditUIBiz();
        }
        return this.biz;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ContractChangeBizBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected DetailPanel getIgnoredDetailPanel() {
        this.kdtEntrys_detailPanel.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.contract.ContractResource", (String)"EMPLOYEE_CONTRACT"));
        return this.kdtEntrys_detailPanel;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        ContractChangeBizBillInfo objectValue = new ContractChangeBizBillInfo();
        UserInfo info = SysContext.getSysContext().getCurrentUserInfo();
        objectValue.setBillState(HRBillStateEnum.SAVED);
        objectValue.setApplier(info.getPerson());
        return objectValue;
    }

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        this.kdtEntrys_detailPanel.getAddNewLineButton().setEnabled(false);
        this.kdtEntrys_detailPanel.getInsertLineButton().setEnabled(false);
        this.kdtEntrys_detailPanel.getRemoveLinesButton().setEnabled(false);
    }

    public void actionColumnCopyAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkContractType(true)) {
            ((ContractChangeBizBillEditUIBiz)this.biz).copyColumn(this.kdtEntrys, false);
        }
    }

    private boolean checkContractType(boolean isColumnCopyAll) {
        KDTSelectBlock sb = null;
        int size = this.kdtEntrys.getSelectManager().size();
        if (size <= 0) {
            MsgBox.showError((String)EASResource.getString((String)this.resourceStr, (String)"SELECT_NOTHING"));
            return false;
        }
        sb = this.kdtEntrys.getSelectManager().get(0);
        int rowBegin = sb.getTop();
        int column = sb.getLeft();
        int contractTypeIndex = this.kdtEntrys.getColumnIndex("contractType");
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.kdtEntrys);
        if (column != this.kdtEntrys.getColumnIndex("contractTemplet")) {
            return true;
        }
        ContractTypeInfo ctBeginInfo = (ContractTypeInfo)this.kdtEntrys.getCell(rowBegin, contractTypeIndex).getValue();
        if (ctBeginInfo == null) {
            return false;
        }
        ContractTypeInfo ctInfo = null;
        if (isColumnCopyAll) {
            int rowCount = this.kdtEntrys.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                ctInfo = (ContractTypeInfo)this.kdtEntrys.getCell(i, contractTypeIndex).getValue();
                if (ctInfo != null && ctInfo.getId().equals((Object)ctBeginInfo.getId())) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourceStr, (String)"CONTRACTTYPE_MISMATCH"));
                return false;
            }
        } else {
            for (int i = 0; i < rows.length; ++i) {
                ctInfo = (ContractTypeInfo)this.kdtEntrys.getCell(rows[i], contractTypeIndex).getValue();
                if (ctInfo != null && ctInfo.getId().equals((Object)ctBeginInfo.getId())) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourceStr, (String)"CONTRACTTYPE_MISMATCH"));
                return false;
            }
        }
        return true;
    }

    public void actionColumnCopySelect_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkContractType(false)) {
            ((ContractChangeBizBillEditUIBiz)this.biz).copyColumn(this.kdtEntrys, true);
        }
    }

    private HROrgUnitInfo getCurrentHRO() {
        HROrgUnitInfo orgUnitInfo = (HROrgUnitInfo)this.getUIContext().get(OrgType.HRO);
        if (orgUnitInfo == null) {
            orgUnitInfo = SysContext.getSysContext().getCurrentHRUnit();
        }
        return orgUnitInfo;
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    private void setContractNoStyle() throws EASBizException, BOSException {
        IRow row = null;
        EmployeeContractInfo contractInfo = new EmployeeContractInfo();
        Context mainOrgContext = this.getBillBiz().getContext().getMainOrgContext();
        CtrlUnitInfo ctrlUnitInfo = FrameWorkUtils.getCurrentCtrlUnit((Context)mainOrgContext);
        if (StringUtils.isEmpty((String)ctrlUnitInfo.getName()) || StringUtils.isEmpty((String)ctrlUnitInfo.getNumber())) {
            String oql = "SELECT id, name, number WHERE id = '" + ctrlUnitInfo.getId().toString() + "'";
            CtrlUnitInfo tmpInfo = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo(oql);
            ctrlUnitInfo.setName(tmpInfo.getName());
            ctrlUnitInfo.setNumber(tmpInfo.getNumber());
        }
        contractInfo.setCU(ctrlUnitInfo);
        ICodingRuleManageFacade icrmFacade = CodingRuleManageFacadeFactory.getRemoteInstanceWithObjectContext((Context)mainOrgContext);
        CodingRuleData codingRuleData = null;
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.kdtEntrys.getRow(i);
            contractInfo.setEmployee((PersonInfo)row.getCell("person").getValue());
            codingRuleData = icrmFacade.getCodingRuleData((IObjectValue)contractInfo, this.getCurrentHRO().getId().toString());
            if (codingRuleData.isExistRule() && !codingRuleData.isModifable()) {
                this.kdtEntrys.getColumn("contractNo").getStyleAttributes().setLocked(true);
                this.kdtEntrys.getColumn("contractNo").getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
                continue;
            }
            this.kdtEntrys.getColumn("contractNo").getStyleAttributes().setLocked(false);
            this.kdtEntrys.getColumn("contractNo").getStyleAttributes().setBackground(this.MUST_INPUT_COLOR);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setContractNoStyle();
    }
}

