/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.contract.HRContractInfoCollection;
import com.kingdee.eas.hr.contract.HRContractInfoFactory;
import com.kingdee.eas.hr.contract.HRContractInfoInfo;
import com.kingdee.eas.hr.contract.IHRContractInfo;
import com.kingdee.eas.hr.contract.IPersonContractPageInfo;
import com.kingdee.eas.hr.contract.PersonContractPageInfoCollection;
import com.kingdee.eas.hr.contract.PersonContractPageInfoFactory;
import com.kingdee.eas.hr.contract.PersonContractPageInfoInfo;
import com.kingdee.eas.hr.contract.PersonContractState;
import com.kingdee.eas.hr.contract.util.ContractUtils;
import com.kingdee.eas.hr.emp.ContractTempletFactory;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.elecontract.EContractSignImgFactory;
import com.kingdee.shr.elecontract.IEContractSignImg;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.preentry.PreEntryPersonCollection;
import com.kingdee.shr.preentry.PreEntryPersonFactory;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElectronicContractUtils {
    private static final Logger logger = LoggerFactory.getLogger(ElectronicContractUtils.class);

    public static void setEmployeeContractInfoIsElectronicSign(Context ctx, EmployeeContractInfo contractInfo, ContractTempletInfo templetInfo) throws EASBizException, BOSException {
        if (templetInfo.get("isElectronicSign") == null) {
            templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(templetInfo.getId().toString()));
        }
        contractInfo.setIsElectronicSign(templetInfo.isIsElectronicSign());
    }

    public static void syncContractToHRContractInfo(Context ctx, String preEntryPersonId, String contractId) throws EASBizException, BOSException {
        EmployeeContractInfo employeeContractInfo = ContractUtils.getEmployeeContractInfo(ctx, contractId);
        IHRContractInfo iHRContractInfo = HRContractInfoFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("preEntryPerson.id", (Object)preEntryPersonId));
        filter.getFilterItems().add(new FilterItemInfo("contractNo", (Object)employeeContractInfo.getContractNo()));
        viewInfo.setFilter(filter);
        HRContractInfoCollection hrInfoColl = iHRContractInfo.getHRContractInfoCollection(viewInfo);
        HRContractInfoInfo contractInfo = new HRContractInfoInfo();
        if (hrInfoColl.size() > 0) {
            contractInfo = hrInfoColl.get(0);
        }
        if (StringUtils.isEmpty((String)employeeContractInfo.getEntryID())) {
            contractInfo.setBillState(HRBillStateEnum.AUDITED);
        }
        contractInfo.put("toUnit", employeeContractInfo.getToUnit());
        contractInfo.setDelegatePerson(employeeContractInfo.getDelegatePerson());
        contractInfo.put("state", employeeContractInfo.getState());
        contractInfo.put("newState", employeeContractInfo.getNewState());
        contractInfo.put("effectDate", employeeContractInfo.getEffectDate());
        contractInfo.put("entryBizDate", employeeContractInfo.getEffectDate());
        contractInfo.put("recordDate", employeeContractInfo.getRecordDate());
        contractInfo.put("contractLimitAuto", employeeContractInfo.getContractLimitAuto());
        contractInfo.put("endDateReal", employeeContractInfo.getEndDateReal());
        contractInfo.put("contractLimitAutoReal", employeeContractInfo.getContractLimitAutoReal());
        contractInfo.setEmployeeContract(employeeContractInfo);
        PreEntryPersonInfo preEntrPerson = ElectronicContractUtils.getPreEntryPersonInfo(ctx, preEntryPersonId);
        if (preEntrPerson != null && preEntrPerson.getRealPersonId() != null) {
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(preEntrPerson.getRealPersonId());
            contractInfo.setEmployee(personInfo);
        }
        contractInfo.setPreEntryPerson(preEntrPerson);
        ContractUtils.setHRContractInfoInfo(ctx, (CoreBaseInfo)employeeContractInfo, contractInfo);
        iHRContractInfo.save(contractInfo);
    }

    public static void syncLaborContractToPersonContractPageInfo(Context ctx, String preEntryPersonId, String contractId) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select id where contractTemplet.contractType.isLaborContract= 1 ").append(" and id='").append(contractId).append("'");
        boolean isLaborContract = EmployeeContractFactory.getLocalInstance((Context)ctx).exists(sql.toString());
        if (isLaborContract) {
            ElectronicContractUtils.refreshEmployeeContractPageInfo(ctx, preEntryPersonId);
        }
    }

    public static String refreshEmployeeContractPageInfo(Context ctx, String preEntryPersonId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 empContract.fid from T_HR_EmployeeContract empContract ").append(" inner join T_HR_ContractTemplet contractTemplet on contractTemplet.fid = empContract.FContractTempletID").append(" inner join T_HR_ContractType contractType  on contractTemplet.FContractTypeID = contractType.fid ").append("\twhere contractType.FIsLaborContract=1 and FPreEntryPersonId ='").append(preEntryPersonId).append("'").append(" \tand empContract.FEffectDate<=CURDATE() and empContract.FState in (1, 2, 4, 5) order by empContract.FState asc, empContract.FEffectDate desc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                EmployeeContractInfo contractInfo = new EmployeeContractInfo();
                String laborContractId = rs.getString(1);
                contractInfo.setId(BOSUuid.read((String)laborContractId));
                sql = new StringBuffer();
                sql.append("select * where preEntryPerson.id='").append(preEntryPersonId).append("'");
                IPersonContractPageInfo iPersonContractPageInfo = PersonContractPageInfoFactory.getLocalInstance(ctx);
                PersonContractPageInfoCollection pageInfoColl = iPersonContractPageInfo.getPersonContractPageInfoCollection(sql.toString());
                PersonContractPageInfoInfo pageInfo = null;
                if (pageInfoColl.size() > 0) {
                    pageInfo = pageInfoColl.get(0);
                    pageInfo.setEmployeeContract(contractInfo);
                    pageInfo.setIsNeedSignContract(true);
                    pageInfo.setHasSignContract(PersonContractState.hasSign);
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("isNeedSignContract"));
                    selector.add(new SelectorItemInfo("hasSignContract"));
                    selector.add(new SelectorItemInfo("employeeContract"));
                    iPersonContractPageInfo.updatePartial(pageInfo, selector);
                } else {
                    pageInfo = new PersonContractPageInfoInfo();
                    pageInfo.setId(BOSUuid.create((BOSObjectType)pageInfo.getBOSType()));
                    PreEntryPersonInfo preEntryPersonInfo = new PreEntryPersonInfo();
                    preEntryPersonInfo.setId(BOSUuid.read((String)preEntryPersonId));
                    pageInfo.setPreEntryPerson(preEntryPersonInfo);
                    PreEntryPersonInfo preEntrPerson = ElectronicContractUtils.getPreEntryPersonInfo(ctx, preEntryPersonId);
                    if (preEntrPerson != null && preEntrPerson.getRealPersonId() != null) {
                        PersonInfo personInfo = new PersonInfo();
                        personInfo.setId(preEntrPerson.getRealPersonId());
                        pageInfo.setPerson(personInfo);
                    }
                    pageInfo.setEmployeeContract(contractInfo);
                    pageInfo.setIsNeedSignContract(true);
                    pageInfo.setHasSignContract(PersonContractState.hasSign);
                    iPersonContractPageInfo.addnew(pageInfo);
                }
                return laborContractId;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static PreEntryPersonInfo getPreEntryPersonInfo(Context ctx, String preEntryPersonId) throws BOSException {
        PreEntryPersonCollection preEntryPersonColl = PreEntryPersonFactory.getLocalInstance((Context)ctx).getPreEntryPersonCollection("where id= '" + preEntryPersonId + "'");
        if (preEntryPersonColl.size() > 0) {
            return preEntryPersonColl.get(0);
        }
        return null;
    }

    public static String getSignatureId(Context ctx, String eContractSealTypeId, KDContractConfigInfo contractConfigInfo) throws BOSException, EASBizException {
        IEContractSignImg ieContractSignImg = EContractSignImgFactory.getLocalInstance((Context)ctx);
        String signatureId = "";
        String contractConfigId = contractConfigInfo.getId().toString();
        String sql = "where kdContractConfig = '" + contractConfigId + "' and eContractSealType = '" + eContractSealTypeId + "'";
        logger.info("eContractSealTypeFilterSql is " + sql);
        if (ieContractSignImg.exists(sql)) {
            return ieContractSignImg.getEContractSignImgInfo(sql).getSignatrueId();
        }
        sql = "where kdContractConfig = '" + contractConfigId + "' and eContractSealType = '" + "00000000-0000-0000-0000-00000000000057D8E364" + "'";
        if (ieContractSignImg.exists(sql)) {
            return ieContractSignImg.getEContractSignImgInfo(sql).getSignatrueId();
        }
        return signatureId;
    }
}

