/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.elecontract.util;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.AffairActioniOperateException;
import com.kingdee.eas.hr.base.EmpLaborRelationCollection;
import com.kingdee.eas.hr.base.EmpLaborRelationFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.IEmpLaborRelation;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.util.ShrEmpNaturalMonthUtil;
import com.kingdee.eas.hr.contract.AbstractEmpEleContractSignRecordInfo;
import com.kingdee.eas.hr.contract.AbstractEmpOtherEleContractSignRecordInfo;
import com.kingdee.eas.hr.contract.ContractBillMiddleCollection;
import com.kingdee.eas.hr.contract.ContractBillMiddleFactory;
import com.kingdee.eas.hr.contract.ContractBillMiddleInfo;
import com.kingdee.eas.hr.contract.ContractPreNewSignBizBillEntryCollection;
import com.kingdee.eas.hr.contract.ContractPreNewSignBizBillEntryFactory;
import com.kingdee.eas.hr.contract.ContractPreNewSignBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractPreNewSignBizBillFactory;
import com.kingdee.eas.hr.contract.ContractPreNewSignBizBillInfo;
import com.kingdee.eas.hr.contract.EContractSignState;
import com.kingdee.eas.hr.contract.EmpEleContractCompanyTaskCollection;
import com.kingdee.eas.hr.contract.EmpEleContractCompanyTaskFactory;
import com.kingdee.eas.hr.contract.EmpEleContractCompanyTaskInfo;
import com.kingdee.eas.hr.contract.EmpEleContractDelLogFactory;
import com.kingdee.eas.hr.contract.EmpEleContractException;
import com.kingdee.eas.hr.contract.EmpEleContractMessageException;
import com.kingdee.eas.hr.contract.EmpEleContractSendMessageFacadeFactory;
import com.kingdee.eas.hr.contract.EmpEleContractServiceFacadeFactory;
import com.kingdee.eas.hr.contract.EmpEleContractSignRecordCollection;
import com.kingdee.eas.hr.contract.EmpEleContractSignRecordFactory;
import com.kingdee.eas.hr.contract.EmpEleContractSignRecordInfo;
import com.kingdee.eas.hr.contract.EmpEleContractTaskFacadeFactory;
import com.kingdee.eas.hr.contract.EmpOtherEleContractServiceFacadeFactory;
import com.kingdee.eas.hr.contract.EmpOtherEleContractSignRecordCollection;
import com.kingdee.eas.hr.contract.EmpOtherEleContractSignRecordFactory;
import com.kingdee.eas.hr.contract.EmpOtherEleContractSignRecordInfo;
import com.kingdee.eas.hr.contract.EmpTaskMessageLogInfo;
import com.kingdee.eas.hr.contract.IContractBillMiddle;
import com.kingdee.eas.hr.contract.IContractPreNewSignBizBillEntry;
import com.kingdee.eas.hr.contract.IEmpEleContractDelLog;
import com.kingdee.eas.hr.contract.IEmpEleContractServiceFacade;
import com.kingdee.eas.hr.contract.IEmpEleContractSignRecord;
import com.kingdee.eas.hr.contract.IEmpEleContractTaskFacade;
import com.kingdee.eas.hr.contract.IEmpOtherEleContractSignRecord;
import com.kingdee.eas.hr.contract.ISHRElectronicTemplate;
import com.kingdee.eas.hr.contract.OtherFollowPreNewConEntryFactory;
import com.kingdee.eas.hr.contract.OtherFollowPreNewConEntryInfo;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateCollection;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateFactory;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateInfo;
import com.kingdee.eas.hr.contract.util.BoAttchAssoBillUtils;
import com.kingdee.eas.hr.contract.util.CloudServiceExceptionUtil;
import com.kingdee.eas.hr.contract.util.HttpClientUtil;
import com.kingdee.eas.hr.elecontract.util.EmpEleContractFollowUtils;
import com.kingdee.eas.hr.elecontract.util.EmpElectronicContractUtilsEx;
import com.kingdee.eas.hr.elecontract.util.EmpElectronicOtherContractUtils;
import com.kingdee.eas.hr.elecontract.util.EmpElectronicOtherContractUtilsEx;
import com.kingdee.eas.hr.emp.ContractClassifyEnum;
import com.kingdee.eas.hr.emp.ContractPartyAdminCollection;
import com.kingdee.eas.hr.emp.ContractPartyAdminFactory;
import com.kingdee.eas.hr.emp.ContractPartyAdminInfo;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.EmployeeContractCollection;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.EmployeeOtherContractCollection;
import com.kingdee.eas.hr.emp.EmployeeOtherContractFactory;
import com.kingdee.eas.hr.emp.EmployeeOtherContractInfo;
import com.kingdee.eas.hr.emp.IEmployeeContract;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.eas.hr.emp.PersonContactMethodCollection;
import com.kingdee.eas.hr.emp.PersonContactMethodFactory;
import com.kingdee.eas.hr.emp.PersonContactMethodInfo;
import com.kingdee.eas.hr.emp.SignTypeEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.attachment.ISHRAttachmentExt;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.elecontract.EContractSyncFileRecordCollection;
import com.kingdee.shr.elecontract.EContractSyncFileRecordFactory;
import com.kingdee.shr.elecontract.EContractSyncFileRecordInfo;
import com.kingdee.shr.elecontract.IEContractSyncFileRecord;
import com.kingdee.shr.elecontract.IKDContractConfigRecord;
import com.kingdee.shr.elecontract.KDContractConfigCollection;
import com.kingdee.shr.elecontract.KDContractConfigFactory;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.KDContractConfigRecordCollection;
import com.kingdee.shr.elecontract.KDContractConfigRecordFactory;
import com.kingdee.shr.elecontract.KDContractConfigRecordInfo;
import com.kingdee.shr.elecontract.SSCPersonAuthResult;
import com.kingdee.shr.elecontract.app.KDContractServiceStatus;
import com.kingdee.shr.elecontract.util.Base64Utils;
import com.kingdee.shr.elecontract.util.CheckHRCloudLicenseUtils;
import com.kingdee.shr.elecontract.util.ContactBillMiddleUtils;
import com.kingdee.shr.elecontract.util.ElectronicContractUtils;
import com.kingdee.shr.elecontract.util.ElectronicTemplateSqlUtils;
import com.kingdee.shr.elecontract.util.RowSetUtils;
import com.kingdee.shr.elecontract.util.TSPServerInstance;
import com.kingdee.shr.elecontract.vo.ETemplateFieldType;
import com.kingdee.shr.elecontract.vo.PersonThreeEleInfo;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.preentry.PreEntryCollection;
import com.kingdee.shr.preentry.PreEntryFactory;
import com.kingdee.shr.preentry.PreEntryInfo;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.shr.smsplatform.service.ISMSStrategy;
import com.kingdee.shr.smsplatform.service.NewSignSMSStrategy;
import com.kingdee.shr.smsplatform.service.SMSSendEntry;
import com.kingdee.shr.smsplatform.service.SignOverSMSStrategy;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmpElectronicContractUtils {
    public static final Logger logger = LoggerFactory.getLogger(EmpElectronicContractUtils.class);

    public static Map<String, Object> getViewEContract(Context ctx, String recordId, String contractId, Map<String, Object> params) throws EASBizException, BOSException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        EmpEleContractSignRecordInfo signRecordInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)recordId));
        filter.getFilterItems().add(new FilterItemInfo("contract.id", (Object)contractId));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("contractNO"));
        selector.add(new SelectorItemInfo("eContractNO"));
        selector.add(new SelectorItemInfo("isCreate"));
        selector.add(new SelectorItemInfo("hasFileCallback"));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(selector);
        IEmpEleContractSignRecord empEleContractSignRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpEleContractSignRecordCollection empEleContractSignRecordCollection = empEleContractSignRecordLocalInstance.getEmpEleContractSignRecordCollection(viewInfo);
        if (empEleContractSignRecordCollection.size() > 0) {
            signRecordInfo = empEleContractSignRecordCollection.get(0);
        }
        if (signRecordInfo != null && signRecordInfo.isIsCreate() && signRecordInfo.isHasFileCallback()) {
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("billId", signRecordInfo.getId().toString());
            dataMap.put("contractId", contractId);
            dataMap.put("contractNo", signRecordInfo.getContractNO());
            dataMap.put("isDefault", "1");
            IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
            Map result = (Map)osfServiceFacade.processService("empPreViewEContractV2Service", dataMap);
            return result;
        }
        data.put("isSuccess", false);
        return data;
    }

    public static Map<String, Object> preViewEContract(Context ctx, String recordId, String contractId, boolean isRequireNew, Map<String, Object> params) throws EASBizException, BOSException {
        Object object;
        HashMap<String, Object> data = new HashMap<String, Object>();
        IEmployeeContract employeeContractLocalInstance = EmployeeContractFactory.getLocalInstance((Context)ctx);
        EmployeeContractInfo employeeContractInfo = EmpElectronicContractUtilsEx.getEmployeeContractInfo(employeeContractLocalInstance, contractId);
        boolean isContinue = true;
        String eContractNo = "";
        if (ContractClassifyEnum.ElectronicSsc.equals((Object)employeeContractInfo.getContractClassify())) {
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("billId", employeeContractInfo.getId().toString());
            dataMap.put("contractNo", employeeContractInfo.getContractNo());
            dataMap.put("isDefault", "999");
            IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
            Map result = (Map)osfServiceFacade.processService("sSCPreViewEContractV2Service", dataMap);
            isContinue = false;
            return result;
        }
        IEmpEleContractSignRecord empEleContractSignRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpEleContractSignRecordInfo signRecordInfo = null;
        signRecordInfo = StringUtils.isEmpty((String)recordId) ? EmpElectronicContractUtilsEx.getEmpEleContractSignRecordInfo(empEleContractSignRecordLocalInstance, employeeContractInfo.getId().toString()) : empEleContractSignRecordLocalInstance.getEmpEleContractSignRecordInfo((IObjectPK)new ObjectUuidPK(recordId));
        boolean isNeedSave = false;
        boolean isNeedAdd = false;
        boolean isNeedUpdate = false;
        SelectorItemCollection selector = new SelectorItemCollection();
        if (signRecordInfo != null) {
            EContractSignState signStatus = signRecordInfo.getSignStatus();
            if (isRequireNew && (signStatus.equals((Object)EContractSignState.employeesignover) || signStatus.equals((Object)EContractSignState.enterprisesignover) || signStatus.equals((Object)EContractSignState.abandon))) {
                if (!signRecordInfo.isIsInvalid()) {
                    signRecordInfo.setIsInvalid(true);
                    SelectorItemCollection selector1 = new SelectorItemCollection();
                    selector1.add(new SelectorItemInfo("isInvalid"));
                    empEleContractSignRecordLocalInstance.updatePartial(signRecordInfo, selector1);
                }
                isNeedAdd = true;
            } else if (signStatus.equals((Object)EContractSignState.uninitiated)) {
                signRecordInfo.setIsCreate(false);
                signRecordInfo.setEcreateTime(null);
                selector.add(new SelectorItemInfo("isCreate"));
                selector.add(new SelectorItemInfo("ecreateTime"));
                isNeedUpdate = true;
                eContractNo = signRecordInfo.getEContractNO();
            } else if (signStatus.equals((Object)EContractSignState.nosign) || signStatus.equals((Object)EContractSignState.signing) || signStatus.equals((Object)EContractSignState.complete) || signStatus.equals((Object)EContractSignState.employeesignover) || signStatus.equals((Object)EContractSignState.enterprisesignover) || signStatus.equals((Object)EContractSignState.partyASigned) || signRecordInfo.isIsPersonSign() || signRecordInfo.isIsCompanySign()) {
                HashMap<String, String> dataMap = new HashMap<String, String>();
                dataMap.put("billId", signRecordInfo.getId().toString());
                dataMap.put("contractId", employeeContractInfo.getId().toString());
                dataMap.put("contractNo", employeeContractInfo.getContractNo());
                dataMap.put("isDefault", "1");
                IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
                Map result = (Map)osfServiceFacade.processService("empPreViewEContractV2Service", dataMap);
                isContinue = false;
                return result;
            }
        }
        if (signRecordInfo == null || isNeedAdd) {
            String contractNo = employeeContractInfo.getContractNo();
            PersonInfo personInfo = employeeContractInfo.getEmployee();
            PreEntryPersonInfo preEntryPersonInfo = employeeContractInfo.getPreEntryPerson();
            signRecordInfo = new EmpEleContractSignRecordInfo();
            LabContractFirstPartyInfo labContractFirstParty = employeeContractInfo.getLabContractFirstParty();
            KDContractConfigInfo kdContractConfigInfo = EmpElectronicContractUtilsEx.getKDContractConfigByLabContractFirstParty(ctx, labContractFirstParty.getId().toString());
            eContractNo = EmpElectronicContractUtils.getEContractNumber(ctx, empEleContractSignRecordLocalInstance, kdContractConfigInfo, contractNo);
            signRecordInfo.setPerson(personInfo);
            signRecordInfo.setPreEntryPerson(preEntryPersonInfo);
            signRecordInfo.setContract(employeeContractInfo);
            signRecordInfo.setContractNO(employeeContractInfo.getContractNo());
            signRecordInfo.setEContractNO(eContractNo);
            signRecordInfo.setSignStatus(EContractSignState.uninitiated);
            signRecordInfo.setKdContractConfig(kdContractConfigInfo);
            signRecordInfo.setIsInvalid(false);
            isNeedSave = true;
        }
        if (!isContinue) {
            return data;
        }
        ContractTempletInfo contractTemplet = employeeContractInfo.getContractTemplet();
        if (!contractTemplet.isIsElectronicSign() || employeeContractInfo.getContractClassify() != null && employeeContractInfo.getContractClassify().getValue() == 0) {
            throw new EmpEleContractException(EmpEleContractException.BATCHEMPLOYEESIGN_IS_FAIL_FOR_CONTRACTTEMPLET);
        }
        EmpElectronicContractUtilsEx.verifyContractIsFreeOrEnd(ctx, employeeContractInfo);
        if (isNeedSave) {
            IObjectPK pk = empEleContractSignRecordLocalInstance.save((CoreBaseInfo)signRecordInfo);
            signRecordInfo.setId(BOSUuid.read((String)pk.toString()));
        }
        if (isNeedUpdate) {
            empEleContractSignRecordLocalInstance.updatePartial(signRecordInfo, selector);
        }
        BoAttchAssoBillUtils.deleteBoAttchAssoBill(ctx, eContractNo, null);
        EmpElectronicContractUtilsEx.copyAndSaveEmployeeContractToMiddle(ctx, employeeContractInfo);
        SHRElectronicTemplateInfo shrElectronicTemplateInfo = EmpElectronicContractUtilsEx.getSHRElectronicTemplateInfoByEmployeeContract(ctx, employeeContractInfo);
        String csTemplateId = shrElectronicTemplateInfo.getCsTemplateId();
        boolean isCsTemplate = StringUtils.isEmpty((String)csTemplateId);
        if (!signRecordInfo.isIsCreate() && isCsTemplate) {
            logger.error("EmpElectronicContractUtilsEx.batchEmployeeSign isCsTemplate : " + isCsTemplate + " \u65e7\u6a21\u677f\u751f\u6210\u7535\u5b50\u5408\u540c");
            object = EmpEleContractServiceFacadeFactory.getLocalInstance(ctx).createEContract(signRecordInfo, employeeContractInfo, shrElectronicTemplateInfo);
        } else if (!signRecordInfo.isIsCreate()) {
            logger.error("EmpElectronicContractUtilsEx.batchEmployeeSign isCsTemplate : " + isCsTemplate + " \u65b0\u6a21\u677f\u751f\u6210\u7535\u5b50\u5408\u540c");
            object = EmpEleContractServiceFacadeFactory.getLocalInstance(ctx).createEContractForNewTemplate(signRecordInfo, employeeContractInfo, shrElectronicTemplateInfo);
        }
        data.put("contractId", contractId);
        data.put("recordId", signRecordInfo.getId().toString());
        data.put("eContractNo", signRecordInfo.getEContractNO());
        data.put("isWaiting", true);
        return data;
    }

    public static void batchEmployeeSign(Context ctx, String contractId, String signStatusString, BatchMessageTipsBody body, Boolean batchAgain) throws EASBizException, BOSException {
        IEmployeeContract employeeContractLocalInstance = EmployeeContractFactory.getLocalInstance((Context)ctx);
        String operation = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label27", (Context)ctx);
        EmpElectronicContractUtilsEx.checkEmpEleContractSignRecordSignStatus(signStatusString, operation, batchAgain);
        EmployeeContractInfo employeeContractInfo = EmpElectronicContractUtilsEx.getEmployeeContractInfo(employeeContractLocalInstance, contractId);
        EmpElectronicContractUtilsEx.verifyContractIsFreeOrEnd(ctx, employeeContractInfo);
        EmpElectronicContractUtilsEx.verifyContractSignStatusAndContractClassify(ctx, employeeContractInfo);
        EmpElectronicContractUtilsEx.checkKDContractConfigIsAuth(ctx, employeeContractInfo);
        EmpElectronicContractUtilsEx.checkPersonStatus(ctx, employeeContractInfo);
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = EmpElectronicContractUtilsEx.generateEmpEleContractSignRecord(ctx, employeeContractInfo, null, null);
        IEmpEleContractSignRecord signRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        Map serverMap = null;
        try {
            serverMap = TSPServerInstance.getServerInfo((Context)ctx);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        EmpElectronicContractUtils.checkHRCloudLincense(ctx, empEleContractSignRecordInfo.getEContractNO(), serverMap);
        EmpElectronicContractUtilsEx.updateEmployeeContractSignStatus(ctx, contractId, EContractSignState.nosign);
        if (empEleContractSignRecordInfo.getSignStatus() != EContractSignState.nosign) {
            EmpElectronicContractUtilsEx.updateEmployeeSignRecordSignStatus(ctx, signRecordLocalInstance, empEleContractSignRecordInfo, EContractSignState.nosign);
        }
        EmpElectronicContractUtilsEx.copyAndSaveEmployeeContractToMiddle(ctx, employeeContractInfo);
        SHRElectronicTemplateInfo shrElectronicTemplateInfo = EmpElectronicContractUtilsEx.getSHRElectronicTemplateInfoByEmployeeContract(ctx, employeeContractInfo);
        String csTemplateId = shrElectronicTemplateInfo.getCsTemplateId();
        boolean isCsTemplate = StringUtils.isEmpty((String)csTemplateId);
        if (!empEleContractSignRecordInfo.isIsCreate() && isCsTemplate) {
            logger.error("EmpElectronicContractUtilsEx.batchEmployeeSign isCsTemplate : " + isCsTemplate + " \u65e7\u6a21\u677f\u751f\u6210\u7535\u5b50\u5408\u540c");
            EmpEleContractServiceFacadeFactory.getLocalInstance(ctx).createEContract(empEleContractSignRecordInfo, employeeContractInfo, shrElectronicTemplateInfo);
        } else if (!empEleContractSignRecordInfo.isIsCreate()) {
            logger.error("EmpElectronicContractUtilsEx.batchEmployeeSign isCsTemplate : " + isCsTemplate + " \u65b0\u6a21\u677f\u751f\u6210\u7535\u5b50\u5408\u540c");
            EmpEleContractServiceFacadeFactory.getLocalInstance(ctx).createEContractForNewTemplate(empEleContractSignRecordInfo, employeeContractInfo, shrElectronicTemplateInfo);
        }
        EmpTaskMessageLogInfo result = null;
        if (!isCsTemplate) {
            logger.error("EmpElectronicContractUtilsEx.batchEmployeeSign isCsTemplate : " + isCsTemplate + " \u65b0\u6a21\u677f\u53d1\u9001\u6d88\u606f");
            result = EmpElectronicContractUtilsEx.sendPersonSignMessageForNewTemplate(ctx, empEleContractSignRecordInfo, employeeContractInfo, contractId);
        } else {
            logger.error("EmpElectronicContractUtilsEx.batchEmployeeSign isCsTemplate : " + isCsTemplate + " \u65e7\u6a21\u677f\u53d1\u9001\u6d88\u606f");
            result = EmpElectronicContractUtilsEx.sendPersonSignMessage(ctx, empEleContractSignRecordInfo, employeeContractInfo);
        }
        if (result.isIsSend() && result.isSendResult()) {
            body.setMuitTipsState(Boolean.TRUE.booleanValue());
            String label0 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractMessageResource", (String)"label0", (Context)ctx);
            String realObj = MessageFormat.format(label0, result.getType().getAlias());
            body.setMuitTipsMessage(realObj);
        } else {
            body.setMuitTipsState(Boolean.FALSE.booleanValue());
            body.setMuitTipsMessage(result.getReason());
        }
    }

    public static void batchCompanySign(Context ctx, String contractId, String permItemId, String signStatusString, BatchMessageTipsBody body) throws EASBizException, BOSException, InterruptedException {
        IEmpEleContractSignRecord empEleContractSignRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        String operation = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label28", (Context)ctx);
        EmpElectronicContractUtilsEx.checkEmpEleContractSignRecordSignStatus(signStatusString, operation, false);
        EmployeeContractInfo employeeContract = EmpElectronicContractUtilsEx.getEmployeeContractInfo(ctx, contractId);
        EmpElectronicContractUtilsEx.checkKDContractConfigIsAuth(ctx, employeeContract);
        EmpElectronicContractUtilsEx.checkContractPartyAdminRange(ctx, employeeContract.getLabContractFirstParty(), permItemId);
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = EmpElectronicContractUtilsEx.getEmpEleContractSignRecordInfo(empEleContractSignRecordLocalInstance, contractId);
        EmpElectronicContractUtilsEx.checkEmpEleContractStatus(ctx, empEleContractSignRecordInfo);
        String eContractNO = empEleContractSignRecordInfo.getEContractNO();
        EmpEleContractCompanyTaskInfo empEleContractCompanyTaskInfo = EmpElectronicContractUtilsEx.getEmpEleContractCompanyTaskInfo(ctx, eContractNO);
        boolean isRequest = false;
        Timestamp requestTime = null;
        long timeDiff = 0L;
        if (empEleContractCompanyTaskInfo != null) {
            isRequest = empEleContractCompanyTaskInfo.isIsRequest();
            requestTime = empEleContractCompanyTaskInfo.getRequestTime();
            if (requestTime != null) {
                timeDiff = System.currentTimeMillis() - requestTime.getTime();
            }
        }
        boolean isLongEnough = false;
        if (timeDiff > 30000L) {
            isLongEnough = true;
        }
        if (isRequest && requestTime != null && !isLongEnough) {
            String label16 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label16", (Context)ctx);
            logger.error("EmpElectronicContractUtilsEx.batchCompanySign label16 : " + label16);
            EmpElectronicContractUtils.pollingProcess(ctx, empEleContractSignRecordInfo, contractId, body);
        } else {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("signStatus"));
            EmployeeContractInfo employeeContractInfo = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(contractId), selector);
            if (EContractSignState.nosign.equals((Object)employeeContractInfo.getSignStatus())) {
                IEmpEleContractServiceFacade empEleContractServiceFacade = EmpEleContractServiceFacadeFactory.getLocalInstance(ctx);
                Object res = null;
                if (empEleContractSignRecordInfo.getPerson() != null) {
                    String personId = empEleContractSignRecordInfo.getPerson().getId().toString();
                    logger.error("EmpElectronicContractUtilsEx.batchCompanySign checkPersonHashAuth personId : " + personId + " res : " + res);
                    res = empEleContractServiceFacade.checkPersonHashAuth(empEleContractSignRecordInfo.getPerson().getId().toString(), null, contractId, eContractNO);
                } else if (empEleContractSignRecordInfo.getPreEntryPerson() != null) {
                    String preEntryPersonId = empEleContractSignRecordInfo.getPreEntryPerson().getId().toString();
                    logger.error("EmpElectronicContractUtilsEx.batchCompanySign checkPersonHashAuth preEntryPersonId : " + preEntryPersonId + " res : " + res);
                    res = empEleContractServiceFacade.checkPersonHashAuth(empEleContractSignRecordInfo.getPreEntryPerson().getId().toString(), null, contractId, eContractNO);
                }
                logger.error("EmpElectronicContractUtilsEx.batchCompanySign checkPersonHashAuth res : " + res);
                Map resMap = (Map)res;
                String userId = (String)resMap.get("userId");
                if (!StringUtils.isEmpty((String)userId) && SSCPersonAuthResult.SUCCESS.equals(resMap.get("result"))) {
                    String recordId = empEleContractSignRecordInfo.getId().toString();
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("userId", userId);
                    param.put("eContractNo", eContractNO);
                    param.put("contractId", contractId);
                    param.put("recordId", recordId);
                    param.put("isQueryCompanySign", false);
                    Object result = empEleContractServiceFacade.getEmpEleContractSignStatus(param);
                    logger.error("EmpElectronicContractUtilsEx.batchCompanySign getEmpEleContractSignStatus result : " + result);
                    com.alibaba.fastjson.JSONObject resObj = null;
                    resObj = result instanceof com.alibaba.fastjson.JSONObject ? (com.alibaba.fastjson.JSONObject)result : com.alibaba.fastjson.JSONObject.parseObject((String)result.toString());
                    int code = resObj.getIntValue("code");
                    boolean isPersonSign = false;
                    if (code == 0) {
                        com.alibaba.fastjson.JSONObject data = resObj.getJSONObject("data");
                        int signStatus = data.getIntValue("signStatus");
                        if (signStatus == 1) {
                            isPersonSign = true;
                        }
                        if (!isPersonSign) {
                            String label24 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label24", (Context)ctx);
                            throw new BOSException(label24);
                        }
                    }
                }
            }
            IEmpEleContractTaskFacade empEleContractTaskFacade = EmpEleContractTaskFacadeFactory.getLocalInstance(ctx);
            if (empEleContractSignRecordInfo.isIsCompanySign() && empEleContractSignRecordInfo.isIsSigned()) {
                String label25 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label25", (Context)ctx);
                logger.error("EmpElectronicContractUtilsEx.batchCompanySign label25 : " + label25);
                body.setMuitTipsState(true);
                String label21 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label21", (Context)ctx);
                body.setMuitTipsMessage(label21);
            } else {
                String label26 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label26", (Context)ctx);
                logger.error("EmpElectronicContractUtilsEx.batchCompanySign label26 : " + label26);
                empEleContractTaskFacade.sendCompanySign(empEleContractSignRecordInfo, contractId);
                EmpElectronicContractUtils.pollingProcess(ctx, empEleContractSignRecordInfo, contractId, body);
            }
        }
    }

    public static void batchContractOver(Context ctx, String contractId, String signStatusString, BatchMessageTipsBody body) throws BOSException, EASBizException {
        IEmpEleContractSignRecord empEleContractSignRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        String operation = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label29", (Context)ctx);
        EmpElectronicContractUtilsEx.checkEmpEleContractSignRecordSignStatus(signStatusString, operation, false);
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = EmpElectronicContractUtilsEx.getEmpEleContractSignRecordInfo(empEleContractSignRecordLocalInstance, contractId);
        if (empEleContractSignRecordInfo != null) {
            EContractSignState signStatus = empEleContractSignRecordInfo.getSignStatus();
            if (signStatus == null) {
                throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_SIGNSTATUS_IS_NULL);
            }
            if (0 == signStatus.getValue()) {
                empEleContractSignRecordInfo.setSignStatus(EContractSignState.employeesignover);
                empEleContractSignRecordInfo.setIsInvalid(Boolean.TRUE);
                empEleContractSignRecordInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
                empEleContractSignRecordInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("signStatus"));
                selector.add(new SelectorItemInfo("isInvalid"));
                selector.add(new SelectorItemInfo("lastUpdateTime"));
                selector.add(new SelectorItemInfo("lastUpdateUser"));
                empEleContractSignRecordLocalInstance.updatePartial(empEleContractSignRecordInfo, selector);
                EmpElectronicContractUtilsEx.updateEmployeeContractSignStatus(ctx, contractId, EContractSignState.employeesignover);
                EmpElectronicContractUtilsEx.updateContractPreNewSignBizBillEntrySignStatus(ctx, empEleContractSignRecordInfo, EContractSignState.employeesignover);
                body.setMuitTipsState(Boolean.TRUE.booleanValue());
                String label21 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label21", (Context)ctx);
                body.setMuitTipsMessage(label21);
            } else if (1 == signStatus.getValue()) {
                empEleContractSignRecordInfo.setSignStatus(EContractSignState.enterprisesignover);
                empEleContractSignRecordInfo.setIsInvalid(Boolean.TRUE);
                empEleContractSignRecordInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
                empEleContractSignRecordInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("signStatus"));
                selector.add(new SelectorItemInfo("isInvalid"));
                selector.add(new SelectorItemInfo("lastUpdateTime"));
                selector.add(new SelectorItemInfo("lastUpdateUser"));
                empEleContractSignRecordLocalInstance.updatePartial(empEleContractSignRecordInfo, selector);
                EmpElectronicContractUtilsEx.updateEmployeeContractSignStatus(ctx, contractId, EContractSignState.enterprisesignover);
                EmpElectronicContractUtilsEx.updateContractPreNewSignBizBillEntrySignStatus(ctx, empEleContractSignRecordInfo, EContractSignState.enterprisesignover);
                body.setMuitTipsState(Boolean.TRUE.booleanValue());
                String label21 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label21", (Context)ctx);
                body.setMuitTipsMessage(label21);
            } else {
                if (2 == signStatus.getValue()) {
                    throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_IS_ALREADY_COMPLETED);
                }
                if (3 == signStatus.getValue() || 4 == signStatus.getValue()) {
                    throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_IS_ALREADY_TERMINATED);
                }
            }
        } else {
            throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_CANNOT_OVER);
        }
    }

    public static void batchAbandonContract(Context ctx, String contractId, BatchMessageTipsBody body) throws BOSException, EASBizException {
        IEmpEleContractSignRecord empEleContractSignRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpElectronicContractUtilsEx.checkEmployeeContractContractClassify(ctx, contractId);
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = EmpElectronicContractUtilsEx.getEmpEleContractSignRecordInfo(empEleContractSignRecordLocalInstance, contractId);
        if (empEleContractSignRecordInfo != null) {
            EContractSignState signStatus = empEleContractSignRecordInfo.getSignStatus();
            if (signStatus == null) {
                throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_SIGNSTATUS_IS_NULL);
            }
            if (2 != signStatus.getValue()) {
                throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_IS_SIGNING);
            }
        } else {
            throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_CANNOT_ABANDON);
        }
        empEleContractSignRecordInfo.setSignStatus(EContractSignState.abandon);
        empEleContractSignRecordInfo.setIsInvalid(Boolean.TRUE);
        empEleContractSignRecordInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
        empEleContractSignRecordInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("signStatus"));
        selector.add(new SelectorItemInfo("isInvalid"));
        selector.add(new SelectorItemInfo("lastUpdateTime"));
        selector.add(new SelectorItemInfo("lastUpdateUser"));
        empEleContractSignRecordLocalInstance.updatePartial(empEleContractSignRecordInfo, selector);
        EmpElectronicContractUtilsEx.updateEmployeeContractSignStatus(ctx, contractId, EContractSignState.abandon);
        EmpElectronicContractUtilsEx.updateContractPreNewSignBizBillEntrySignStatus(ctx, empEleContractSignRecordInfo, EContractSignState.abandon);
        EmpElectronicContractUtilsEx.deleteEmpEleContractSHRAttachmentExt(ctx, contractId);
        body.setMuitTipsState(Boolean.TRUE.booleanValue());
        String label21 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label21", (Context)ctx);
        body.setMuitTipsMessage(label21);
    }

    public static EmployeeContractInfo getEmployeeContractInfo(IEmployeeContract employeeContractLocalInstance, String contractId) throws EASBizException, BOSException {
        EmployeeContractInfo empContractInfo = employeeContractLocalInstance.getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(contractId), EmpElectronicContractUtilsEx.getSelectorCollection());
        return empContractInfo;
    }

    public static EmployeeContractInfo getEmployeeContractInfo(Context ctx, String contractId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("labContractFirstParty.id"));
        selector.add(new SelectorItemInfo("labContractFirstParty.name"));
        selector.add(new SelectorItemInfo("labContractFirstParty.number"));
        EmployeeContractInfo empContractInfo = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(contractId), selector);
        return empContractInfo;
    }

    public static EmpEleContractSignRecordInfo getEmpEleContractSignRecordInfo(IEmpEleContractSignRecord empEleContractSignRecordLocalInstance, String contractId) throws BOSException {
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contract.id", (Object)contractId));
        filter.getFilterItems().add(new FilterItemInfo("isInvalid", (Object)0, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        EmpEleContractSignRecordCollection empEleContractSignRecordCollection = empEleContractSignRecordLocalInstance.getEmpEleContractSignRecordCollection(viewInfo);
        if (empEleContractSignRecordCollection.size() > 0) {
            empEleContractSignRecordInfo = empEleContractSignRecordCollection.get(0);
        }
        return empEleContractSignRecordInfo;
    }

    public static EmpEleContractSignRecordInfo getEmpEleContractSignRecordInfoFromPreEntry(IEmpEleContractSignRecord empEleContractSignRecordLocalInstance, String contractId, SelectorItemCollection selector) throws BOSException {
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contract.id", (Object)contractId));
        viewInfo.setFilter(filter);
        if (selector != null && selector.size() > 0) {
            viewInfo.setSelector(selector);
        }
        SorterItemCollection sorterColls = new SorterItemCollection();
        SorterItemInfo sorter = new SorterItemInfo("createTime");
        sorter.setSortType(SortType.DESCEND);
        sorterColls.add(sorter);
        viewInfo.setSorter(sorterColls);
        EmpEleContractSignRecordCollection empEleContractSignRecordCollection = empEleContractSignRecordLocalInstance.getEmpEleContractSignRecordCollection(viewInfo);
        if (empEleContractSignRecordCollection.size() > 0) {
            empEleContractSignRecordInfo = empEleContractSignRecordCollection.get(0);
        }
        return empEleContractSignRecordInfo;
    }

    public static EmpEleContractSignRecordInfo getEmpEleConSignRecordInfo(IEmpEleContractSignRecord empEleContractSignRecordLocalInstance, String contractId) throws BOSException {
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contract.id", (Object)contractId));
        viewInfo.setFilter(filter);
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo sortItem = new SorterItemInfo("createTime");
        sortItem.setSortType(SortType.DESCEND);
        sortColl.add(sortItem);
        viewInfo.setSorter(sortColl);
        EmpEleContractSignRecordCollection empEleContractSignRecordCollection = empEleContractSignRecordLocalInstance.getEmpEleContractSignRecordCollection(viewInfo);
        if (empEleContractSignRecordCollection.size() > 0) {
            empEleContractSignRecordInfo = empEleContractSignRecordCollection.get(0);
        }
        return empEleContractSignRecordInfo;
    }

    public static void copyAndSaveEmployeeContractToMiddle(Context ctx, EmployeeContractInfo employeeContractInfo) throws BOSException, EASBizException {
        BigDecimal contractAgreedSalary;
        BigDecimal compensation;
        BigDecimal penalty;
        String contractLimit;
        PersonInfo personInfo;
        IContractBillMiddle contractBillMiddleLocalInstance = ContractBillMiddleFactory.getLocalInstance(ctx);
        ContractBillMiddleInfo contractBillMiddleInfo = EmpElectronicContractUtilsEx.getContractBillMiddleInfoByContractId(ctx, contractBillMiddleLocalInstance, employeeContractInfo.getId().toString());
        boolean isNewMiddle = false;
        if (contractBillMiddleInfo == null) {
            isNewMiddle = true;
            contractBillMiddleInfo = new ContractBillMiddleInfo();
        }
        EmpPosOrgRelationQueryHelper empPosOrgRelationQueryHelper = new EmpPosOrgRelationQueryHelper();
        EmpPosOrgRelationCollection mianCurrntEmpOrgRelation = empPosOrgRelationQueryHelper.getMianCurrntEmpOrgRelation(ctx, employeeContractInfo.getEmployee().getId().toString());
        EmpPosOrgRelationInfo empPosOrgRelationInfo = null;
        logger.error("EmpElectronicContractUtilsEx.copyAndSaveEmployeeContractToMiddle mianCurrntEmpOrgRelation.size : " + mianCurrntEmpOrgRelation.size());
        if (mianCurrntEmpOrgRelation.size() > 0) {
            empPosOrgRelationInfo = mianCurrntEmpOrgRelation.get(0);
        }
        if (empPosOrgRelationInfo != null) {
            logger.error("EmpElectronicContractUtilsEx.copyAndSaveEmployeeContractToMiddle empPosOrgRelationInfo : " + empPosOrgRelationInfo.getId());
        } else {
            logger.error("EmpElectronicContractUtilsEx.copyAndSaveEmployeeContractToMiddle empPosOrgRelationInfo is null ");
        }
        ContactBillMiddleUtils.copyData((Context)ctx, (IObjectValue)employeeContractInfo, (IObjectValue)contractBillMiddleInfo);
        if (empPosOrgRelationInfo != null) {
            contractBillMiddleInfo.setPosition(empPosOrgRelationInfo.getPosition());
            contractBillMiddleInfo.setAdminOrg(empPosOrgRelationInfo.getAdminOrg());
            contractBillMiddleInfo.setBillId(null);
            contractBillMiddleInfo.setEntryId(null);
            contractBillMiddleInfo.setBizDate(employeeContractInfo.getEffectDate());
            contractBillMiddleInfo.setContractType(employeeContractInfo.getContractTemplet().getContractType());
            if (employeeContractInfo.getTestBeginDate() != null && employeeContractInfo.getTestEndDate() != null) {
                Integer tryoutMonth = 0;
                EmpLaborRelationInfo currentTableInfo = null;
                IEmpLaborRelation iEmpLaborRelation = EmpLaborRelationFactory.getLocalInstance((Context)ctx);
                String personId = employeeContractInfo.getEmployee().getId().toString();
                String oql = "select tryoutMonth  where person ='" + personId + "'";
                EmpLaborRelationCollection currentColl = iEmpLaborRelation.getEmpLaborRelationCollection(oql);
                if (currentColl.size() == 0 || currentColl.size() > 1) {
                    throw new AffairActioniOperateException(AffairActioniOperateException.EMP_OLDEMPTYPE_ERROR);
                }
                currentTableInfo = currentColl.get(0);
                if (currentTableInfo != null) {
                    tryoutMonth = currentTableInfo.getTryoutMonth();
                }
                if (tryoutMonth == 0) {
                    tryoutMonth = ShrEmpNaturalMonthUtil.getProbation((Date)employeeContractInfo.getTestBeginDate(), (Date)employeeContractInfo.getTestEndDate());
                }
                if (tryoutMonth != null && tryoutMonth > 0) {
                    contractBillMiddleInfo.setTryoutMonth(tryoutMonth);
                }
            } else if (!isNewMiddle && contractBillMiddleInfo.get("tryoutMonth") != null) {
                contractBillMiddleInfo.put("tryoutMonth", null);
            }
        }
        if ((personInfo = EmpElectronicContractUtilsEx.getPersonInfo(ctx, employeeContractInfo.getEmployee().getId().toString())) != null) {
            contractBillMiddleInfo.setIdCardNo(personInfo.getIdCardNO());
            contractBillMiddleInfo.setPassportNo(personInfo.getPassportNO());
        }
        if (!StringUtils.isEmpty((String)(contractLimit = contractBillMiddleInfo.getContractLimit()))) {
            BigDecimal bigDecimal = new BigDecimal(contractLimit);
            BigDecimal setScale = bigDecimal.setScale(1);
            contractBillMiddleInfo.setContractLimit(setScale.toString());
        }
        if ((penalty = contractBillMiddleInfo.getPenalty()) != null) {
            contractBillMiddleInfo.setPenalty(penalty.setScale(2));
        }
        if ((compensation = contractBillMiddleInfo.getCompensation()) != null) {
            contractBillMiddleInfo.setCompensation(compensation.setScale(2));
        }
        if ((contractAgreedSalary = contractBillMiddleInfo.getContractAgreedSalary()) != null) {
            contractBillMiddleInfo.setContractAgreedSalary(contractAgreedSalary.setScale(2));
        }
        contractBillMiddleLocalInstance.save((CoreBaseInfo)contractBillMiddleInfo);
        logger.error("EmpElectronicContractUtilsEx.copyAndSaveEmployeeContractToMiddle contractBillMiddleInfo : " + contractBillMiddleInfo.getId());
    }

    public static void checkEmpEleContractSignRecordSignStatus(String signStatus, String operation, Boolean batchAgain) throws EmpEleContractException {
        int signStatusValue;
        if (!(StringUtils.isEmpty((String)signStatus) || 3 != (signStatusValue = Integer.parseInt(signStatus)) && 4 != signStatusValue && 5 != signStatusValue)) {
            String alias = "";
            switch (signStatusValue) {
                case 3: {
                    alias = EContractSignState.employeesignover.getAlias();
                    break;
                }
                case 4: {
                    alias = EContractSignState.enterprisesignover.getAlias();
                    break;
                }
                case 5: {
                    alias = EContractSignState.abandon.getAlias();
                    break;
                }
                default: {
                    alias = "";
                }
            }
            if (batchAgain.booleanValue()) {
                return;
            }
            throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_CANNOT_BATCH_OPERATE_AGAIN, new Object[]{alias, operation});
        }
    }

    public static void checkContractPartyAdminRange(Context ctx, LabContractFirstPartyInfo labContractFirstPartyInfo, String permItemId) throws EASBizException, BOSException {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        Set userAdminRangeIdSet = SHRUserOrgPermissionApi.getUserAdminRangeIdSet((Context)ctx, (String)userId, (String)permItemId);
        logger.error("EmpElectronicContractUtilsEx.checkContractPartyAdminRange userAdminRangeIdSet : " + userAdminRangeIdSet + " permItemId : " + permItemId);
        Set<String> contractPartyAdminRangeIdSet = EmpElectronicContractUtilsEx.getContractPartyAdminRangeIdSet(ctx, labContractFirstPartyInfo.getId().toString());
        logger.error("EmpElectronicContractUtilsEx.checkContractPartyAdminRange contractPartyAdminRangeIdSet : " + contractPartyAdminRangeIdSet);
        if (contractPartyAdminRangeIdSet != null && contractPartyAdminRangeIdSet.size() > 0) {
            HashSet resSet = new HashSet();
            resSet.addAll(userAdminRangeIdSet);
            logger.error("EmpElectronicContractUtilsEx.checkContractPartyAdminRange resSet1 : " + resSet);
            resSet.retainAll(contractPartyAdminRangeIdSet);
            logger.error("EmpElectronicContractUtilsEx.checkContractPartyAdminRange resSet2 : " + resSet);
            if (resSet.size() == 0) {
                throw new EmpEleContractException(EmpEleContractException.CONTRACTPARTYADMIN_NOT_IN_RANGE, new Object[]{labContractFirstPartyInfo.getName()});
            }
        }
    }

    public static void checkKDContractConfigIsAuth(Context ctx, EmployeeContractInfo employeeContractInfo) throws EASBizException, BOSException {
        LabContractFirstPartyInfo labContractFirstParty = employeeContractInfo.getLabContractFirstParty();
        if (labContractFirstParty == null) {
            throw new EmpEleContractException(EmpEleContractException.LAB_CONTRACT_FIRST_PARTY_TIP);
        }
        KDContractConfigCollection contractConfigCollection = KDContractConfigFactory.getLocalInstance((Context)ctx).getKDContractConfigCollection("where labContractFirstParty.id='" + labContractFirstParty.getId().toString() + "'");
        if (contractConfigCollection == null || contractConfigCollection.isEmpty()) {
            String label40 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label40", (Context)ctx);
            throw new BOSException(label40);
        }
        EmpElectronicOtherContractUtilsEx.checkKDContractConfigIsAuth(ctx, contractConfigCollection.get(0));
    }

    public static Set<String> getContractPartyAdminRangeIdSet(Context ctx, String labContractFirstPartyId) throws BOSException {
        HashSet<String> contractPartyAdminSet = new HashSet<String>();
        try {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("id"));
            selectorItemCollection.add(new SelectorItemInfo("isContainLowerOrg"));
            selectorItemCollection.add(new SelectorItemInfo("adminOrg.id"));
            selectorItemCollection.add(new SelectorItemInfo("adminOrg.longNumber"));
            view.setSelector(selectorItemCollection);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("labContractFirstParty", (Object)labContractFirstPartyId));
            view.setFilter(filter);
            ContractPartyAdminCollection contractPartyAdminCollection = ContractPartyAdminFactory.getLocalInstance((Context)ctx).getContractPartyAdminCollection(view);
            for (int i = 0; i < contractPartyAdminCollection.size(); ++i) {
                ContractPartyAdminInfo contractPartyAdminInfo = contractPartyAdminCollection.get(i);
                AdminOrgUnitInfo adminOrgInfo = contractPartyAdminInfo.getAdminOrg();
                if (contractPartyAdminInfo.isIsContainLowerOrg()) {
                    String longNumber = adminOrgInfo.getLongNumber();
                    String sql = "SELECT FID FROM T_ORG_Admin WHERE FLongNumber LIKE '" + longNumber + "!%'";
                    IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
                    while (executeQuery.next()) {
                        contractPartyAdminSet.add(executeQuery.getString("FID"));
                    }
                    contractPartyAdminSet.add(adminOrgInfo.getId().toString());
                    continue;
                }
                if (adminOrgInfo == null || adminOrgInfo.getId() == null) continue;
                contractPartyAdminSet.add(adminOrgInfo.getId().toString());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return contractPartyAdminSet;
    }

    public static Map<String, Object> getViewPreEntryEContract(Context ctx, String billId, String entryId, String contractNo, Map<String, Object> params) throws EASBizException, BOSException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        return data;
    }

    public static Map<String, Object> preViewPreEntryEContract(Context ctx, String billId, String entryId, String contractNo, boolean isRequireNew, Map<String, Object> params) throws EASBizException, BOSException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        boolean isLabor = true;
        if (!StringUtils.isEmpty((String)entryId) && BOSUuid.read((String)entryId).getType().toString().equals("76DC66A4")) {
            isLabor = false;
        }
        String contractId = "";
        ContractPreNewSignBizBillInfo conPreNewSignBBInfo = ContractPreNewSignBizBillFactory.getLocalInstance(ctx).getContractPreNewSignBizBillInfo((IObjectPK)new ObjectUuidPK(billId));
        if (isLabor) {
            boolean isContinue = true;
            String eContractNo = "";
            IEmployeeContract employeeContractLocalInstance = EmployeeContractFactory.getLocalInstance((Context)ctx);
            EmployeeContractInfo employeeContractInfo = EmpElectronicContractUtilsEx.getEmployeeContractByContractNo(employeeContractLocalInstance, contractNo);
            contractId = employeeContractInfo.getId().toString();
            IEmpEleContractSignRecord empEleContractSignRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
            EmpEleContractSignRecordInfo signRecordInfo = EmpElectronicContractUtilsEx.getEmpEleContractSignRecordInfoFromPreEntry(empEleContractSignRecordLocalInstance, employeeContractInfo.getId().toString(), null);
            ContractPreNewSignBizBillEntryInfo conPreNewSignBBEntryInfo = conPreNewSignBBInfo.getEntrys().get(0);
            boolean isNeedSave = false;
            boolean isNeedAdd = false;
            boolean isNeedUpdate = false;
            SelectorItemCollection selector = new SelectorItemCollection();
            if (signRecordInfo != null) {
                EContractSignState signStatus = signRecordInfo.getSignStatus();
                if (isRequireNew && (signStatus.equals((Object)EContractSignState.employeesignover) || signStatus.equals((Object)EContractSignState.enterprisesignover))) {
                    if (!signRecordInfo.isIsInvalid()) {
                        signRecordInfo.setIsInvalid(true);
                        SelectorItemCollection selector1 = new SelectorItemCollection();
                        selector1.add(new SelectorItemInfo("isInvalid"));
                        empEleContractSignRecordLocalInstance.updatePartial(signRecordInfo, selector1);
                    }
                    isNeedAdd = true;
                } else if (signStatus.equals((Object)EContractSignState.uninitiated)) {
                    signRecordInfo.setIsCreate(false);
                    signRecordInfo.setEcreateTime(null);
                    selector.add(new SelectorItemInfo("isCreate"));
                    selector.add(new SelectorItemInfo("ecreateTime"));
                    eContractNo = signRecordInfo.getEContractNO();
                    isNeedUpdate = true;
                } else if (signStatus.equals((Object)EContractSignState.nosign) || signStatus.equals((Object)EContractSignState.signing) || signStatus.equals((Object)EContractSignState.complete) || signStatus.equals((Object)EContractSignState.employeesignover) || signStatus.equals((Object)EContractSignState.enterprisesignover) || signStatus.equals((Object)EContractSignState.partyASigned) || signStatus.equals((Object)EContractSignState.abandon) || signRecordInfo.isIsPersonSign() || signRecordInfo.isIsCompanySign()) {
                    HashMap<String, String> dataMap = new HashMap<String, String>();
                    dataMap.put("billId", signRecordInfo.getId().toString());
                    dataMap.put("contractId", employeeContractInfo.getId().toString());
                    dataMap.put("contractNo", employeeContractInfo.getContractNo());
                    dataMap.put("isDefault", "1");
                    IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
                    Map result = (Map)osfServiceFacade.processService("empPreViewEContractV2Service", dataMap);
                    isContinue = false;
                    return result;
                }
            }
            if (signRecordInfo == null || isNeedAdd) {
                contractNo = employeeContractInfo.getContractNo();
                PersonInfo personInfo = employeeContractInfo.getEmployee();
                PreEntryPersonInfo preEntryPersonInfo = employeeContractInfo.getPreEntryPerson();
                signRecordInfo = new EmpEleContractSignRecordInfo();
                LabContractFirstPartyInfo labContractFirstParty = employeeContractInfo.getLabContractFirstParty();
                KDContractConfigInfo kdContractConfigInfo = EmpElectronicContractUtilsEx.getKDContractConfigByLabContractFirstParty(ctx, labContractFirstParty.getId().toString());
                if (kdContractConfigInfo == null) {
                    // empty if block
                }
                eContractNo = EmpElectronicContractUtils.getEContractNumber(ctx, empEleContractSignRecordLocalInstance, kdContractConfigInfo, contractNo);
                signRecordInfo.setPerson(personInfo);
                signRecordInfo.setPreEntryPerson(preEntryPersonInfo);
                signRecordInfo.setContract(employeeContractInfo);
                signRecordInfo.setContractNO(employeeContractInfo.getContractNo());
                signRecordInfo.setEContractNO(eContractNo);
                signRecordInfo.setSignStatus(EContractSignState.uninitiated);
                signRecordInfo.setKdContractConfig(kdContractConfigInfo);
                signRecordInfo.setBillId(conPreNewSignBBInfo.getId());
                signRecordInfo.setEntryId(conPreNewSignBBEntryInfo.getId());
                signRecordInfo.setIsInvalid(false);
                isNeedSave = true;
            }
            if (!isContinue) {
                return data;
            }
            ContractTempletInfo contractTemplet = employeeContractInfo.getContractTemplet();
            if (!contractTemplet.isIsElectronicSign() || employeeContractInfo.getContractClassify() != null && employeeContractInfo.getContractClassify().getValue() == 0) {
                throw new EmpEleContractException(EmpEleContractException.BATCHEMPLOYEESIGN_IS_FAIL_FOR_CONTRACTTEMPLET);
            }
            EmpElectronicContractUtilsEx.verifyContractIsFreeOrEnd(ctx, employeeContractInfo);
            if (isNeedSave) {
                IObjectPK pk = empEleContractSignRecordLocalInstance.save((CoreBaseInfo)signRecordInfo);
                signRecordInfo.setId(BOSUuid.read((String)pk.toString()));
            }
            if (isNeedUpdate) {
                empEleContractSignRecordLocalInstance.updatePartial(signRecordInfo, selector);
            }
            BoAttchAssoBillUtils.deleteBoAttchAssoBill(ctx, eContractNo, null);
            EmpElectronicContractUtilsEx.copyAndSaveEmployeeContractToMiddleForPreEntryPreson(ctx, employeeContractInfo, conPreNewSignBBInfo, conPreNewSignBBEntryInfo);
            SHRElectronicTemplateInfo shrElectronicTemplateInfo = EmpElectronicContractUtilsEx.getSHRElectronicTemplateInfoByEmployeeContract(ctx, employeeContractInfo);
            String csTemplateId = shrElectronicTemplateInfo.getCsTemplateId();
            boolean isCsTemplate = StringUtils.isEmpty((String)csTemplateId);
            if (!signRecordInfo.isIsCreate() && isCsTemplate) {
                logger.error("EmpElectronicContractUtilsEx.batchPreEntryPersonSign isCsTemplate : " + isCsTemplate + " \u65e7\u6a21\u677f\u751f\u6210\u7535\u5b50\u5408\u540c");
                EmpEleContractServiceFacadeFactory.getLocalInstance(ctx).createEContract(signRecordInfo, employeeContractInfo, shrElectronicTemplateInfo);
            } else if (!signRecordInfo.isIsCreate()) {
                logger.error("EmpElectronicContractUtilsEx.batchPreEntryPersonSign isCsTemplate : " + isCsTemplate + " \u65b0\u6a21\u677f\u751f\u6210\u7535\u5b50\u5408\u540c");
                EmpEleContractServiceFacadeFactory.getLocalInstance(ctx).createEContractForNewTemplate(signRecordInfo, employeeContractInfo, shrElectronicTemplateInfo);
            }
            data.put("contractId", contractId);
            data.put("recordId", signRecordInfo.getId().toString());
            data.put("eContractNo", signRecordInfo.getEContractNO());
            data.put("isWaiting", true);
        } else {
            String eContractNo = "";
            OtherFollowPreNewConEntryInfo otherFollowPreNewConEntryInfo = OtherFollowPreNewConEntryFactory.getLocalInstance(ctx).getOtherFollowPreNewConEntryInfo((IObjectPK)new ObjectUuidPK(entryId));
            EmployeeOtherContractInfo employeeOtherContractInfo = EmpElectronicOtherContractUtils.getEmpOtherContractByContractNo(ctx, otherFollowPreNewConEntryInfo.getContractNo());
            contractId = employeeOtherContractInfo.getId().toString();
            ContractTempletInfo contractTemplet = employeeOtherContractInfo.getContractTemplet();
            if (!contractTemplet.isIsElectronicSign() || employeeOtherContractInfo.getContractClassify() != null && employeeOtherContractInfo.getContractClassify().getValue() == 0) {
                throw new EmpEleContractException(EmpEleContractException.BATCHEMPLOYEESIGN_IS_FAIL_FOR_CONTRACTTEMPLET);
            }
            boolean isContinue = true;
            IEmpOtherEleContractSignRecord otherContractSignRecordInstance = EmpOtherEleContractSignRecordFactory.getLocalInstance(ctx);
            EmpOtherEleContractSignRecordInfo signRecordInfo = EmpElectronicOtherContractUtilsEx.getOtherEmpEleContractSignRecordInfoFromPreEntry(otherContractSignRecordInstance, employeeOtherContractInfo.getId().toString(), null);
            boolean isNeedSave = false;
            boolean isNeedAdd = false;
            boolean isNeedUpdate = false;
            SelectorItemCollection selector = new SelectorItemCollection();
            if (signRecordInfo != null) {
                EContractSignState signStatus = signRecordInfo.getSignStatus();
                if (isRequireNew && (signStatus.equals((Object)EContractSignState.employeesignover) || signStatus.equals((Object)EContractSignState.enterprisesignover))) {
                    if (!signRecordInfo.isIsInvalid()) {
                        signRecordInfo.setIsInvalid(true);
                        SelectorItemCollection selector1 = new SelectorItemCollection();
                        selector1.add(new SelectorItemInfo("isInvalid"));
                        otherContractSignRecordInstance.updatePartial(signRecordInfo, selector1);
                    }
                    isNeedAdd = true;
                } else if (signStatus.equals((Object)EContractSignState.uninitiated)) {
                    signRecordInfo.setIsCreate(false);
                    signRecordInfo.setEcreateTime(null);
                    selector.add(new SelectorItemInfo("isCreate"));
                    selector.add(new SelectorItemInfo("ecreateTime"));
                    eContractNo = signRecordInfo.getEContractNO();
                    isNeedUpdate = true;
                } else if (signStatus.equals((Object)EContractSignState.nosign) || signStatus.equals((Object)EContractSignState.signing) || signStatus.equals((Object)EContractSignState.partyASigned) || signStatus.equals((Object)EContractSignState.complete) || signStatus.equals((Object)EContractSignState.employeesignover) || signStatus.equals((Object)EContractSignState.enterprisesignover) || signStatus.equals((Object)EContractSignState.abandon) || signRecordInfo.isIsPersonSign() || signRecordInfo.isIsSecondPartySign() || signRecordInfo.isIsFirstPartySign()) {
                    HashMap<String, String> dataMap = new HashMap<String, String>();
                    dataMap.put("billId", signRecordInfo.getId().toString());
                    dataMap.put("contractId", employeeOtherContractInfo.getId().toString());
                    dataMap.put("contractNo", employeeOtherContractInfo.getContractNo());
                    dataMap.put("isDefault", "1");
                    IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
                    Map result = (Map)osfServiceFacade.processService("empPreViewEContractV2Service", dataMap);
                    isContinue = false;
                    return result;
                }
            }
            if (signRecordInfo == null || isNeedAdd) {
                contractNo = employeeOtherContractInfo.getContractNo();
                PersonInfo personInfo = employeeOtherContractInfo.getEmployee();
                PreEntryPersonInfo preEntryPersonInfo = employeeOtherContractInfo.getPreEntryPerson();
                signRecordInfo = new EmpOtherEleContractSignRecordInfo();
                LabContractFirstPartyInfo labContractFirstParty = employeeOtherContractInfo.getLabContractFirstParty();
                KDContractConfigInfo kdContractConfigInfo = EmpElectronicContractUtilsEx.getKDContractConfigByLabContractFirstParty(ctx, labContractFirstParty.getId().toString());
                eContractNo = EmpElectronicOtherContractUtilsEx.getEContractNumber(ctx, otherContractSignRecordInstance, kdContractConfigInfo, contractNo);
                signRecordInfo.setPerson(personInfo);
                signRecordInfo.setPreEntryPerson(preEntryPersonInfo);
                signRecordInfo.setContract(employeeOtherContractInfo);
                signRecordInfo.setContractNO(contractNo);
                signRecordInfo.setEContractNO(eContractNo);
                signRecordInfo.setSignStatus(EContractSignState.uninitiated);
                signRecordInfo.setKdContractConfig(kdContractConfigInfo);
                signRecordInfo.setBillId(conPreNewSignBBInfo.getId());
                signRecordInfo.setEntryId(otherFollowPreNewConEntryInfo.getId());
                signRecordInfo.setIsInvalid(false);
                isNeedSave = true;
            }
            if (!isContinue) {
                return data;
            }
            SignTypeEnum sSignType = employeeOtherContractInfo.getContractTemplet().getSignType();
            if (sSignType != null) {
                logger.error("EmpElectronicOtherContractUtilsEx  update EmployeeOtherContract  signState : " + sSignType.toString() + "====contractId=" + contractId);
            } else {
                logger.error("EmpElectronicOtherContractUtilsEx  update EmployeeOtherContract  signState  is null ====contractId=" + contractId);
            }
            if (isNeedSave) {
                IObjectPK pk = otherContractSignRecordInstance.save((CoreBaseInfo)signRecordInfo);
                signRecordInfo.setId(BOSUuid.read((String)pk.toString()));
                EmpElectronicOtherContractUtilsEx.updateOtherEmployeeContractSignStatus(ctx, contractId, EContractSignState.uninitiated);
            }
            if (isNeedUpdate) {
                otherContractSignRecordInstance.updatePartial(signRecordInfo, selector);
            }
            BoAttchAssoBillUtils.deleteBoAttchAssoBill(ctx, eContractNo, null);
            EmpElectronicOtherContractUtilsEx.updateOtherEmployeeContractSignStatus(ctx, employeeOtherContractInfo.getId().toString(), EContractSignState.uninitiated);
            EmpElectronicOtherContractUtilsEx.updateOtherFollowPreNewConEntrySignStatus(ctx, otherFollowPreNewConEntryInfo, EContractSignState.uninitiated);
            EmpElectronicOtherContractUtilsEx.copyAndSaveEmployeeContractToMiddleForPreEntryPreson(ctx, employeeOtherContractInfo, conPreNewSignBBInfo, otherFollowPreNewConEntryInfo);
            SHRElectronicTemplateInfo shrEleTemplateInfo = EmpElectronicOtherContractUtilsEx.getSHRElectronicTemplateInfoByEmployeeContract(ctx, employeeOtherContractInfo);
            String csTempId = shrEleTemplateInfo.getCsTemplateId();
            boolean isCsTemp = StringUtils.isEmpty((String)csTempId);
            if (!signRecordInfo.isIsCreate() && isCsTemp) {
                logger.error("EmpElectronicContractUtilsEx.batchPreEntryPersonSign isCsTemp : " + isCsTemp + " \u65e7\u6a21\u677f\u751f\u6210\u5176\u4ed6\u7535\u5b50\u5408\u540c");
                EmpOtherEleContractServiceFacadeFactory.getLocalInstance(ctx).createEContract(signRecordInfo, employeeOtherContractInfo, shrEleTemplateInfo, new HashMap());
            } else if (!signRecordInfo.isIsCreate()) {
                logger.error("EmpElectronicContractUtilsEx.batchPreEntryPersonSign isCsTemp : " + isCsTemp + " \u65b0\u6a21\u677f\u751f\u6210\u5176\u4ed6\u7535\u5b50\u5408\u540c");
                EmpOtherEleContractServiceFacadeFactory.getLocalInstance(ctx).createEContractForNewTemplate(signRecordInfo, employeeOtherContractInfo, shrEleTemplateInfo, new HashMap());
            }
            data.put("contractId", contractId);
            data.put("recordId", signRecordInfo.getId().toString());
            data.put("eContractNo", signRecordInfo.getEContractNO());
            data.put("isWaiting", true);
        }
        return data;
    }

    public static void batchPreEntryPersonSign(Context ctx, String contractNo, String billState, BatchMessageTipsBody body, Boolean batchAgain) throws EASBizException, BOSException {
        IEmployeeContract employeeContractLocalInstance = EmployeeContractFactory.getLocalInstance((Context)ctx);
        ContractPreNewSignBizBillInfo conPreNewSignBBInfo = ContractPreNewSignBizBillFactory.getLocalInstance(ctx).getContractPreNewSignBizBillInfo((IObjectPK)new ObjectUuidPK(body.getId()));
        ContractPreNewSignBizBillEntryInfo conPreNewSignBBEntryInfo = conPreNewSignBBInfo.getEntrys().get(0);
        EmpElectronicContractUtilsEx.checkBillState(billState);
        EmployeeContractInfo employeeContractInfo = EmpElectronicContractUtilsEx.getEmployeeContractByContractNo(employeeContractLocalInstance, contractNo);
        String contractId = employeeContractInfo.getId().toString();
        EmpElectronicContractUtilsEx.verifyContractSignStatusAndContractClassify(ctx, employeeContractInfo);
        EmpElectronicContractUtilsEx.checkKDContractConfigIsAuth(ctx, employeeContractInfo);
        EmpElectronicContractUtilsEx.checkPersonStatus(ctx, employeeContractInfo);
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = EmpElectronicContractUtilsEx.generateEmpEleContractSignRecord(ctx, employeeContractInfo, conPreNewSignBBInfo, conPreNewSignBBEntryInfo);
        Map serverMap = null;
        try {
            serverMap = TSPServerInstance.getServerInfo((Context)ctx);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        EmpElectronicContractUtils.checkHRCloudLincense(ctx, empEleContractSignRecordInfo.getEContractNO(), serverMap);
        EmpElectronicContractUtilsEx.updateEmployeeContractSignStatus(ctx, contractId, EContractSignState.nosign);
        EmpElectronicContractUtilsEx.updateContractPreNewSignBizBillEntrySignStatus(ctx, empEleContractSignRecordInfo, EContractSignState.nosign);
        EmpElectronicContractUtilsEx.copyAndSaveEmployeeContractToMiddleForPreEntryPreson(ctx, employeeContractInfo, conPreNewSignBBInfo, conPreNewSignBBEntryInfo);
        SHRElectronicTemplateInfo shrElectronicTemplateInfo = EmpElectronicContractUtilsEx.getSHRElectronicTemplateInfoByEmployeeContract(ctx, employeeContractInfo);
        String csTemplateId = shrElectronicTemplateInfo.getCsTemplateId();
        boolean isCsTemplate = StringUtils.isEmpty((String)csTemplateId);
        if (!empEleContractSignRecordInfo.isIsCreate() && isCsTemplate) {
            logger.error("EmpElectronicContractUtilsEx.batchPreEntryPersonSign isCsTemplate : " + isCsTemplate + " \u65e7\u6a21\u677f\u751f\u6210\u7535\u5b50\u5408\u540c");
            EmpEleContractServiceFacadeFactory.getLocalInstance(ctx).createEContract(empEleContractSignRecordInfo, employeeContractInfo, shrElectronicTemplateInfo);
        } else if (!empEleContractSignRecordInfo.isIsCreate()) {
            logger.error("EmpElectronicContractUtilsEx.batchPreEntryPersonSign isCsTemplate : " + isCsTemplate + " \u65b0\u6a21\u677f\u751f\u6210\u7535\u5b50\u5408\u540c");
            EmpEleContractServiceFacadeFactory.getLocalInstance(ctx).createEContractForNewTemplate(empEleContractSignRecordInfo, employeeContractInfo, shrElectronicTemplateInfo);
        }
        EmpElectronicContractUtils.dealEmpEleContractFollow(ctx, conPreNewSignBBInfo);
        EmpTaskMessageLogInfo result = null;
        if (!isCsTemplate) {
            logger.error("EmpElectronicContractUtilsEx.batchPreEntryPersonSign isCsTemplate : " + isCsTemplate + " \u65b0\u6a21\u677f\u53d1\u9001\u6d88\u606f");
            result = EmpElectronicContractUtilsEx.sendPersonSignMessageForNewTemplate(ctx, empEleContractSignRecordInfo, employeeContractInfo, contractId);
        } else {
            logger.error("EmpElectronicContractUtilsEx.batchPreEntryPersonSign isCsTemplate : " + isCsTemplate + " \u65e7\u6a21\u677f\u53d1\u9001\u6d88\u606f");
            result = EmpElectronicContractUtilsEx.sendPersonSignMessage(ctx, empEleContractSignRecordInfo, employeeContractInfo);
        }
        if (result.isIsSend() && result.isSendResult()) {
            EmpEleContractFollowUtils.updateEContractTotalStateInBill(ctx, conPreNewSignBBInfo, EContractSignState.nosign);
            body.setMuitTipsState(Boolean.TRUE.booleanValue());
            String label0 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractMessageResource", (String)"label0", (Context)ctx);
            String realObj = MessageFormat.format(label0, result.getType().getAlias());
            body.setMuitTipsMessage(realObj);
        } else {
            body.setMuitTipsState(Boolean.FALSE.booleanValue());
            body.setMuitTipsMessage(result.getReason());
        }
    }

    public static void batchPreEntryPersonCompanySign(Context ctx, String contractNo, String permItemId, BatchMessageTipsBody body) throws EASBizException, BOSException, InterruptedException {
        IEmpEleContractSignRecord empEleContractSignRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = EmpElectronicContractUtilsEx.getEmpEleContractSignRecordInfoByContractNo(empEleContractSignRecordLocalInstance, contractNo);
        String contractId = empEleContractSignRecordInfo.getContract().getId().toString();
        EmployeeContractInfo employeeContract = EmpElectronicContractUtilsEx.getEmployeeContractInfo(ctx, contractId);
        EmpElectronicContractUtilsEx.checkKDContractConfigIsAuth(ctx, employeeContract);
        EmpElectronicContractUtilsEx.checkContractPartyAdminRange(ctx, employeeContract.getLabContractFirstParty(), permItemId);
        ContractPreNewSignBizBillInfo conPreNewSignBBInfo = ContractPreNewSignBizBillFactory.getLocalInstance(ctx).getContractPreNewSignBizBillInfo((IObjectPK)new ObjectUuidPK(empEleContractSignRecordInfo.getBillId()));
        EmpEleContractFollowUtils.checkEmpEleContractTotalStatus(ctx, conPreNewSignBBInfo);
        String eContractNO = empEleContractSignRecordInfo.getEContractNO();
        EmpEleContractCompanyTaskInfo empEleContractCompanyTaskInfo = EmpElectronicContractUtilsEx.getEmpEleContractCompanyTaskInfo(ctx, eContractNO);
        boolean isRequest = false;
        Timestamp requestTime = null;
        if (empEleContractCompanyTaskInfo != null) {
            isRequest = empEleContractCompanyTaskInfo.isIsRequest();
            requestTime = empEleContractCompanyTaskInfo.getRequestTime();
        }
        if (isRequest && requestTime != null) {
            String label16 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label16", (Context)ctx);
            logger.error("EmpElectronicContractUtilsEx.batchCompanySign label16 : " + label16);
            EmpElectronicContractUtils.pollingProcess(ctx, empEleContractSignRecordInfo, contractId, body);
        } else {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("signStatus"));
            EmployeeContractInfo employeeContractInfo = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(contractId), selector);
            if (EContractSignState.nosign.equals((Object)employeeContractInfo.getSignStatus())) {
                IEmpEleContractServiceFacade empEleContractServiceFacade = EmpEleContractServiceFacadeFactory.getLocalInstance(ctx);
                Object res = null;
                if (empEleContractSignRecordInfo.getPerson() != null) {
                    String personId = empEleContractSignRecordInfo.getPerson().getId().toString();
                    logger.error("EmpElectronicContractUtilsEx.batchCompanySign checkPersonHashAuth personId : " + personId + " res : " + res);
                    res = empEleContractServiceFacade.checkPersonHashAuth(empEleContractSignRecordInfo.getPerson().getId().toString(), null, contractId, eContractNO);
                } else if (empEleContractSignRecordInfo.getPreEntryPerson() != null) {
                    String preEntryPersonId = empEleContractSignRecordInfo.getPreEntryPerson().getId().toString();
                    logger.error("EmpElectronicContractUtilsEx.batchCompanySign checkPersonHashAuth preEntryPersonId : " + preEntryPersonId + " res : " + res);
                    res = empEleContractServiceFacade.checkPersonHashAuth(empEleContractSignRecordInfo.getPreEntryPerson().getId().toString(), null, contractId, eContractNO);
                }
                logger.error("EmpElectronicContractUtilsEx.batchCompanySign checkPersonHashAuth res : " + res);
                Map resMap = (Map)res;
                String userId = (String)resMap.get("userId");
                if (!StringUtils.isEmpty((String)userId) && SSCPersonAuthResult.SUCCESS.equals(resMap.get("result"))) {
                    String recordId = empEleContractSignRecordInfo.getId().toString();
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("userId", userId);
                    param.put("eContractNo", eContractNO);
                    param.put("contractId", contractId);
                    param.put("recordId", recordId);
                    param.put("isQueryCompanySign", false);
                    Object result = empEleContractServiceFacade.getEmpEleContractSignStatus(param);
                    logger.error("EmpElectronicContractUtilsEx.batchCompanySign getEmpEleContractSignStatus result : " + result);
                    com.alibaba.fastjson.JSONObject resObj = null;
                    resObj = result instanceof com.alibaba.fastjson.JSONObject ? (com.alibaba.fastjson.JSONObject)result : com.alibaba.fastjson.JSONObject.parseObject((String)result.toString());
                    int code = resObj.getIntValue("code");
                    boolean isPersonSign = false;
                    if (code == 0) {
                        com.alibaba.fastjson.JSONObject data = resObj.getJSONObject("data");
                        int signStatus = data.getIntValue("signStatus");
                        if (signStatus == 1) {
                            isPersonSign = true;
                        }
                        if (!isPersonSign) {
                            String label24 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label24", (Context)ctx);
                            throw new BOSException(label24);
                        }
                    }
                }
            }
            IEmpEleContractTaskFacade empEleContractTaskFacade = EmpEleContractTaskFacadeFactory.getLocalInstance(ctx);
            if (empEleContractSignRecordInfo.isIsCompanySign() && empEleContractSignRecordInfo.isIsSigned()) {
                String label25 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label25", (Context)ctx);
                logger.error("EmpElectronicContractUtilsEx.batchCompanySign label25 : " + label25);
                body.setMuitTipsState(true);
                String label21 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label21", (Context)ctx);
                body.setMuitTipsMessage(label21);
            } else {
                String label26 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label26", (Context)ctx);
                logger.error("EmpElectronicContractUtilsEx.batchCompanySign label26 : " + label26);
                empEleContractTaskFacade.sendCompanySign(empEleContractSignRecordInfo, contractId);
                EmpElectronicContractUtils.pollingProcess(ctx, empEleContractSignRecordInfo, contractId, body);
            }
        }
        ContractPreNewSignBizBillInfo contractPreNewSignBizBillInfo = ContractPreNewSignBizBillFactory.getLocalInstance(ctx).getContractPreNewSignBizBillInfo((IObjectPK)new ObjectUuidPK(body.getId()));
        if (contractPreNewSignBizBillInfo.getOtherEntrys() != null && contractPreNewSignBizBillInfo.getOtherEntrys().size() > 0) {
            for (int i = 0; i < contractPreNewSignBizBillInfo.getOtherEntrys().size(); ++i) {
                OtherFollowPreNewConEntryInfo otherFollowPreNewConEntryInfo = contractPreNewSignBizBillInfo.getOtherEntrys().get(i);
                EmployeeOtherContractInfo employeeOtherContractInfo = EmpElectronicOtherContractUtils.getEmpOtherContractByContractNo(ctx, otherFollowPreNewConEntryInfo.getContractNo());
                int signValue = employeeOtherContractInfo.getSignStatus().getValue();
                String signStatus = String.valueOf(signValue);
                int signType = employeeOtherContractInfo.getSignType().getValue();
                if (0 == signType) continue;
                EmpElectronicOtherContractUtilsEx.batchCompanySign(ctx, employeeOtherContractInfo.getId().toString(), permItemId, signStatus, body);
            }
        }
    }

    public static void batchPreEntryPersonContractOver(Context ctx, String contractNo, String billState, BatchMessageTipsBody body) throws BOSException, EASBizException {
        IEmpEleContractSignRecord empEleContractSignRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        ContractPreNewSignBizBillInfo conPreNewSignBBInfo = ContractPreNewSignBizBillFactory.getLocalInstance(ctx).getContractPreNewSignBizBillInfo((IObjectPK)new ObjectUuidPK(body.getId()));
        EmpElectronicContractUtilsEx.checkBillStateBeforeContractOver(billState);
        EmpEleContractFollowUtils.checkContractBizBillSignStatus(conPreNewSignBBInfo.getTotalState());
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = EmpElectronicContractUtilsEx.getEmpEleContractSignRecordInfoByContractNo(empEleContractSignRecordLocalInstance, contractNo);
        if (empEleContractSignRecordInfo != null) {
            String label21;
            SelectorItemCollection selector;
            EContractSignState signStatus = empEleContractSignRecordInfo.getSignStatus();
            EmployeeContractInfo employeeContractInfo = empEleContractSignRecordInfo.getContract();
            if (employeeContractInfo == null || employeeContractInfo.getId() == null) {
                throw new EmpEleContractException(EmpEleContractException.EMPELECONTRACTSIGNRECORD_CONTRACT_IS_NULL);
            }
            String contractId = employeeContractInfo.getId().toString();
            if (signStatus == null) {
                throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_SIGNSTATUS_IS_NULL);
            }
            if (0 == signStatus.getValue()) {
                empEleContractSignRecordInfo.setSignStatus(EContractSignState.employeesignover);
                empEleContractSignRecordInfo.setIsInvalid(true);
                empEleContractSignRecordInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
                empEleContractSignRecordInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
                selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("signStatus"));
                selector.add(new SelectorItemInfo("isInvalid"));
                selector.add(new SelectorItemInfo("lastUpdateTime"));
                selector.add(new SelectorItemInfo("lastUpdateUser"));
                empEleContractSignRecordLocalInstance.updatePartial(empEleContractSignRecordInfo, selector);
                EmpElectronicContractUtilsEx.updateEmployeeContractSignStatus(ctx, contractId, EContractSignState.employeesignover);
                EmpElectronicContractUtilsEx.updateContractPreNewSignBizBillEntrySignStatus(ctx, empEleContractSignRecordInfo, EContractSignState.employeesignover);
                body.setMuitTipsState(Boolean.TRUE.booleanValue());
                label21 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label21", (Context)ctx);
                body.setMuitTipsMessage(label21);
            } else if (1 == signStatus.getValue()) {
                empEleContractSignRecordInfo.setSignStatus(EContractSignState.enterprisesignover);
                empEleContractSignRecordInfo.setIsInvalid(true);
                empEleContractSignRecordInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
                empEleContractSignRecordInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
                selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("signStatus"));
                selector.add(new SelectorItemInfo("isInvalid"));
                selector.add(new SelectorItemInfo("lastUpdateTime"));
                selector.add(new SelectorItemInfo("lastUpdateUser"));
                empEleContractSignRecordLocalInstance.updatePartial(empEleContractSignRecordInfo, selector);
                EmpElectronicContractUtilsEx.updateEmployeeContractSignStatus(ctx, contractId, EContractSignState.enterprisesignover);
                EmpElectronicContractUtilsEx.updateContractPreNewSignBizBillEntrySignStatus(ctx, empEleContractSignRecordInfo, EContractSignState.enterprisesignover);
                body.setMuitTipsState(Boolean.TRUE.booleanValue());
                label21 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label21", (Context)ctx);
                body.setMuitTipsMessage(label21);
            } else {
                if (2 == signStatus.getValue()) {
                    throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_IS_ALREADY_COMPLETED);
                }
                if (3 == signStatus.getValue() || 4 == signStatus.getValue()) {
                    throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_IS_ALREADY_TERMINATED);
                }
            }
        } else {
            throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_CANNOT_OVER);
        }
        if (conPreNewSignBBInfo.getOtherEntrys() != null && conPreNewSignBBInfo.getOtherEntrys().size() > 0) {
            for (int i = 0; i < conPreNewSignBBInfo.getOtherEntrys().size(); ++i) {
                OtherFollowPreNewConEntryInfo otherFollowPreNewConEntryInfo = conPreNewSignBBInfo.getOtherEntrys().get(i);
                EmployeeOtherContractInfo employeeOtherContractInfo = EmpElectronicOtherContractUtils.getEmpOtherContractByContractNo(ctx, otherFollowPreNewConEntryInfo.getContractNo());
                int signValue = employeeOtherContractInfo.getSignStatus().getValue();
                String signStatus = String.valueOf(signValue);
                EmpElectronicOtherContractUtils.batchContractOver(ctx, employeeOtherContractInfo.getId().toString(), signStatus, body, true);
            }
        }
        if (conPreNewSignBBInfo.getTotalState() == EContractSignState.nosign) {
            EmpEleContractFollowUtils.updateEContractTotalStateInBill(ctx, conPreNewSignBBInfo, EContractSignState.employeesignover);
        }
        if (conPreNewSignBBInfo.getTotalState() == EContractSignState.signing) {
            EmpEleContractFollowUtils.updateEContractTotalStateInBill(ctx, conPreNewSignBBInfo, EContractSignState.enterprisesignover);
        }
    }

    public static void batchPreEntryPersonAbandonContract(Context ctx, String contractNo, String billState, BatchMessageTipsBody body) throws BOSException, EASBizException {
        IEmpEleContractSignRecord empEleContractSignRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        ContractPreNewSignBizBillInfo conPreNewSignBBInfo = ContractPreNewSignBizBillFactory.getLocalInstance(ctx).getContractPreNewSignBizBillInfo((IObjectPK)new ObjectUuidPK(body.getId()));
        EmpElectronicContractUtilsEx.checkBillStateBeforeAbandonContract(billState);
        EmpEleContractFollowUtils.checkContractBizBillTotalStatus(conPreNewSignBBInfo.getTotalState());
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = EmpElectronicContractUtilsEx.getEmpEleContractSignRecordInfoByContractNo(empEleContractSignRecordLocalInstance, contractNo);
        if (empEleContractSignRecordInfo != null) {
            EContractSignState signStatus = empEleContractSignRecordInfo.getSignStatus();
            EmployeeContractInfo employeeContractInfo = empEleContractSignRecordInfo.getContract();
            if (employeeContractInfo == null || employeeContractInfo.getId() == null) {
                throw new EmpEleContractException(EmpEleContractException.EMPELECONTRACTSIGNRECORD_CONTRACT_IS_NULL);
            }
            String contractId = employeeContractInfo.getId().toString();
            if (signStatus == null) {
                throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_SIGNSTATUS_IS_NULL);
            }
            if (2 == signStatus.getValue()) {
                empEleContractSignRecordInfo.setSignStatus(EContractSignState.abandon);
                empEleContractSignRecordInfo.setIsInvalid(true);
                empEleContractSignRecordInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
                empEleContractSignRecordInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("signStatus"));
                selector.add(new SelectorItemInfo("isInvalid"));
                selector.add(new SelectorItemInfo("lastUpdateTime"));
                selector.add(new SelectorItemInfo("lastUpdateUser"));
                empEleContractSignRecordLocalInstance.updatePartial(empEleContractSignRecordInfo, selector);
                EmpElectronicContractUtilsEx.updateEmployeeContractSignStatus(ctx, contractId, EContractSignState.abandon);
                EmpElectronicContractUtilsEx.updateContractPreNewSignBizBillEntrySignStatus(ctx, empEleContractSignRecordInfo, EContractSignState.abandon);
                EmpElectronicContractUtilsEx.deleteEmpEleContractSHRAttachmentExt(ctx, contractId);
                body.setMuitTipsState(Boolean.TRUE.booleanValue());
                String label21 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label21", (Context)ctx);
                body.setMuitTipsMessage(label21);
            } else {
                if (5 == signStatus.getValue()) {
                    throw new EmpEleContractException(EmpEleContractException.ELECTRONIC_CONTRACT_IS_ALREADY_ABANDON);
                }
                if (2 != signStatus.getValue()) {
                    throw new EmpEleContractException(EmpEleContractException.ELECTRONIC_CONTRACT_SIGNING_STATUS_IS_NOT_COMPLETE, new Object[]{signStatus.getAlias()});
                }
            }
        } else {
            throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_CANNOT_ABANDON);
        }
        if (conPreNewSignBBInfo.getOtherEntrys() != null && conPreNewSignBBInfo.getOtherEntrys().size() > 0) {
            for (int i = 0; i < conPreNewSignBBInfo.getOtherEntrys().size(); ++i) {
                OtherFollowPreNewConEntryInfo otherFollowPreNewConEntryInfo = conPreNewSignBBInfo.getOtherEntrys().get(i);
                EmployeeOtherContractInfo employeeOtherContractInfo = EmpElectronicOtherContractUtils.getEmpOtherContractByContractNo(ctx, otherFollowPreNewConEntryInfo.getContractNo());
                EmpElectronicOtherContractUtils.batchAbandonContract(ctx, employeeOtherContractInfo.getId().toString(), body);
            }
        }
        EmpEleContractFollowUtils.updateEContractTotalStateInBill(ctx, conPreNewSignBBInfo, EContractSignState.abandon);
    }

    public static void dealEmpEleContractFollow(Context ctx, ContractPreNewSignBizBillInfo conPreNewSignBBInfo) throws EASBizException, BOSException {
        if (conPreNewSignBBInfo.getOtherEntrys() != null && conPreNewSignBBInfo.getOtherEntrys().size() > 0) {
            for (int i = 0; i < conPreNewSignBBInfo.getOtherEntrys().size(); ++i) {
                OtherFollowPreNewConEntryInfo otherFollowPreNewConEntryInfo = conPreNewSignBBInfo.getOtherEntrys().get(i);
                EmployeeOtherContractInfo employeeOtherContractInfo = EmpElectronicOtherContractUtils.getEmpOtherContractByContractNo(ctx, otherFollowPreNewConEntryInfo.getContractNo());
                EmpElectronicOtherContractUtilsEx.verifyOtherContractIsFreeOrEnd(ctx, employeeOtherContractInfo);
                EmpElectronicOtherContractUtilsEx.verifyOtherContractSignStatusAndContractClassify(ctx, employeeOtherContractInfo);
                EmpOtherEleContractSignRecordInfo empOtherEleContractSignRecordInfo = EmpElectronicOtherContractUtils.generateOtherEmpEleContractSignRecord(ctx, employeeOtherContractInfo, conPreNewSignBBInfo, otherFollowPreNewConEntryInfo);
                EmpElectronicOtherContractUtilsEx.updateOtherEmployeeContractSignStatus(ctx, employeeOtherContractInfo.getId().toString(), EContractSignState.nosign);
                EmpElectronicOtherContractUtilsEx.updateOtherFollowPreNewConEntrySignStatus(ctx, otherFollowPreNewConEntryInfo, EContractSignState.nosign);
                EmpElectronicOtherContractUtilsEx.copyAndSaveEmployeeContractToMiddleForPreEntryPreson(ctx, employeeOtherContractInfo, conPreNewSignBBInfo, otherFollowPreNewConEntryInfo);
                SHRElectronicTemplateInfo shrEleTemplateInfo = EmpElectronicOtherContractUtilsEx.getSHRElectronicTemplateInfoByEmployeeContract(ctx, employeeOtherContractInfo);
                String csTempId = shrEleTemplateInfo.getCsTemplateId();
                boolean isCsTemp = StringUtils.isEmpty((String)csTempId);
                if (!empOtherEleContractSignRecordInfo.isIsCreate() && isCsTemp) {
                    logger.error("EmpElectronicContractUtilsEx.batchPreEntryPersonSign isCsTemp : " + isCsTemp + " \u65e7\u6a21\u677f\u751f\u6210\u5176\u4ed6\u7535\u5b50\u5408\u540c");
                    EmpOtherEleContractServiceFacadeFactory.getLocalInstance(ctx).createEContract(empOtherEleContractSignRecordInfo, employeeOtherContractInfo, shrEleTemplateInfo, new HashMap());
                    continue;
                }
                if (empOtherEleContractSignRecordInfo.isIsCreate()) continue;
                logger.error("EmpElectronicContractUtilsEx.batchPreEntryPersonSign isCsTemp : " + isCsTemp + " \u65b0\u6a21\u677f\u751f\u6210\u5176\u4ed6\u7535\u5b50\u5408\u540c");
                EmpOtherEleContractServiceFacadeFactory.getLocalInstance(ctx).createEContractForNewTemplate(empOtherEleContractSignRecordInfo, employeeOtherContractInfo, shrEleTemplateInfo, new HashMap());
            }
        }
    }

    public static EmployeeContractInfo getEmployeeContractByContractNo(IEmployeeContract employeeContractLocalInstance, String contractNo) throws EASBizException, BOSException {
        EmployeeContractInfo employeeContractInfo = new EmployeeContractInfo();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("contractNo", (Object)contractNo));
        view.setFilter(filterInfo);
        SelectorItemCollection selectorCollection = EmpElectronicContractUtilsEx.getSelectorCollection();
        view.setSelector(selectorCollection);
        EmployeeContractCollection employeeContractCollection = employeeContractLocalInstance.getEmployeeContractCollection(view);
        if (employeeContractCollection != null && employeeContractCollection.size() == 1) {
            employeeContractInfo = employeeContractCollection.get(0);
        } else {
            if (employeeContractCollection == null || employeeContractCollection.size() == 0) {
                throw new EmpEleContractException(EmpEleContractException.GET_EMPLOYEE_IS_NULL_BY_CONTRACTNO, new Object[]{contractNo});
            }
            if (employeeContractCollection != null && employeeContractCollection.size() > 1) {
                throw new EmpEleContractException(EmpEleContractException.GET_EMPLOYEE_IS_MORE_BY_CONTRACTNO, new Object[]{contractNo});
            }
        }
        return employeeContractInfo;
    }

    public static void copyAndSaveEmployeeContractToMiddleForPreEntryPreson(Context ctx, EmployeeContractInfo employeeContractInfo, ContractPreNewSignBizBillInfo cpnsbbInfo, ContractPreNewSignBizBillEntryInfo cpnsbbentryInfo) throws BOSException, EASBizException {
        BigDecimal contractAgreedSalary;
        BigDecimal compensation;
        BigDecimal penalty;
        String contractLimit;
        PreEntryInfo preEntryInfo;
        IContractBillMiddle contractBillMiddleLocalInstance = ContractBillMiddleFactory.getLocalInstance(ctx);
        ContractBillMiddleInfo contractBillMiddleInfo = EmpElectronicContractUtilsEx.getContractBillMiddleInfoByContractId(ctx, contractBillMiddleLocalInstance, employeeContractInfo.getId().toString());
        if (contractBillMiddleInfo == null) {
            contractBillMiddleInfo = new ContractBillMiddleInfo();
        }
        if ((preEntryInfo = EmpElectronicContractUtilsEx.getPreEntryInfoByPreEntryPresonId(ctx, employeeContractInfo.getPreEntryPerson().getId().toString())) != null) {
            logger.error("EmpElectronicContractUtilsEx.copyAndSaveEmployeeContractToMiddleForPreEntryPreson preEntryInfo : " + preEntryInfo.getId());
        } else {
            logger.error("EmpElectronicContractUtilsEx.copyAndSaveEmployeeContractToMiddleForPreEntryPreson preEntryInfo is null ");
        }
        ContactBillMiddleUtils.copyData((Context)ctx, (IObjectValue)employeeContractInfo, (IObjectValue)contractBillMiddleInfo);
        if (preEntryInfo != null) {
            PreEntryPersonInfo preEntryPersonInfo;
            contractBillMiddleInfo.setPosition(preEntryInfo.getPosition());
            contractBillMiddleInfo.setAdminOrg(preEntryInfo.getAdminOrg());
            contractBillMiddleInfo.setBillId(cpnsbbInfo.getId());
            contractBillMiddleInfo.setEntryId(cpnsbbentryInfo.getId());
            contractBillMiddleInfo.setBizDate(employeeContractInfo.getEffectDate());
            contractBillMiddleInfo.setContractType(employeeContractInfo.getContractTemplet().getContractType());
            Integer tryoutMonth = 0;
            if (employeeContractInfo.getTestBeginDate() != null && employeeContractInfo.getTestEndDate() != null) {
                tryoutMonth = ShrEmpNaturalMonthUtil.getProbation((Date)employeeContractInfo.getTestBeginDate(), (Date)employeeContractInfo.getTestEndDate());
            }
            if (tryoutMonth != null && tryoutMonth > 0) {
                contractBillMiddleInfo.setTryoutMonth(tryoutMonth);
            }
            if (preEntryInfo.getTalent() != null && (preEntryPersonInfo = preEntryInfo.getTalent()) != null) {
                contractBillMiddleInfo.setIdCardNo(preEntryPersonInfo.getIdCardNO());
                contractBillMiddleInfo.setPassportNo(preEntryPersonInfo.getPassportNO());
            }
        }
        if (!StringUtils.isEmpty((String)(contractLimit = contractBillMiddleInfo.getContractLimit()))) {
            BigDecimal bigDecimal = new BigDecimal(contractLimit);
            BigDecimal setScale = bigDecimal.setScale(1);
            contractBillMiddleInfo.setContractLimit(setScale.toString());
        }
        if ((penalty = contractBillMiddleInfo.getPenalty()) != null) {
            contractBillMiddleInfo.setPenalty(penalty.setScale(2));
        }
        if ((compensation = contractBillMiddleInfo.getCompensation()) != null) {
            contractBillMiddleInfo.setCompensation(compensation.setScale(2));
        }
        if ((contractAgreedSalary = contractBillMiddleInfo.getContractAgreedSalary()) != null) {
            contractBillMiddleInfo.setContractAgreedSalary(contractAgreedSalary.setScale(2));
        }
        contractBillMiddleLocalInstance.save((CoreBaseInfo)contractBillMiddleInfo);
        logger.error("EmpElectronicContractUtilsEx.copyAndSaveEmployeeContractToMiddleForPreEntryPreson contractBillMiddleInfo : " + contractBillMiddleInfo.getId());
    }

    public static PreEntryInfo getPreEntryInfoByPreEntryPresonId(Context ctx, String preEntryPresonId) throws BOSException {
        PreEntryInfo preEntryInfo = null;
        SelectorItemCollection selectorItemCollection = EmpElectronicContractUtilsEx.getSelectorItemCollection();
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.setSelector(selectorItemCollection);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("talent.id", (Object)preEntryPresonId));
        entityView.setFilter(filterInfo);
        PreEntryCollection preEntryCollection = PreEntryFactory.getLocalInstance((Context)ctx).getPreEntryCollection(entityView);
        if (preEntryCollection != null && preEntryCollection.size() > 0) {
            preEntryInfo = preEntryCollection.get(0);
        }
        return preEntryInfo;
    }

    public static EmpEleContractSignRecordInfo getEmpEleContractSignRecordInfoByContractNo(IEmpEleContractSignRecord empEleContractSignRecordLocalInstance, String contractNo) throws EASBizException, BOSException {
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contractNO", (Object)contractNo));
        filter.getFilterItems().add(new FilterItemInfo("isInvalid", (Object)0, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        EmpEleContractSignRecordCollection empEleContractSignRecordCollection = empEleContractSignRecordLocalInstance.getEmpEleContractSignRecordCollection(viewInfo);
        if (empEleContractSignRecordCollection != null && empEleContractSignRecordCollection.size() == 1) {
            empEleContractSignRecordInfo = empEleContractSignRecordCollection.get(0);
        } else {
            if (empEleContractSignRecordCollection == null || empEleContractSignRecordCollection.size() == 0) {
                throw new EmpEleContractException(EmpEleContractException.GET_EMPELESIGNRECORD_IS_NULL_BY_CONTRACTNO, new Object[]{contractNo});
            }
            if (empEleContractSignRecordCollection != null && empEleContractSignRecordCollection.size() > 1) {
                throw new EmpEleContractException(EmpEleContractException.GET_EMPELESIGNRECORD_IS_MORE_BY_CONTRACTNO, new Object[]{contractNo});
            }
        }
        return empEleContractSignRecordInfo;
    }

    public static EmpEleContractSignRecordInfo getEmpEleContractSignRecordByContractNo(Context ctx, String contractNO) throws BOSException, EASBizException {
        EmpEleContractSignRecordInfo recordInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (!StringUtils.isEmpty((String)contractNO)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("contractNO", (Object)contractNO));
        }
        view.setFilter(filterInfo);
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo sortItem = new SorterItemInfo("createTime");
        sortItem.setSortType(SortType.DESCEND);
        sortColl.add(sortItem);
        view.setSorter(sortColl);
        EmpEleContractSignRecordCollection recordCollection = EmpEleContractSignRecordFactory.getLocalInstance(ctx).getEmpEleContractSignRecordCollection(view);
        if (recordCollection.size() > 0) {
            recordInfo = recordCollection.get(0);
        }
        return recordInfo;
    }

    public static void checkBillState(String billState) throws EASBizException {
        int parseInt = Integer.parseInt(billState);
        if (3 != parseInt) {
            throw new EmpEleContractException(EmpEleContractException.BILLSTATE_IS_NOT_AUDITED);
        }
    }

    public static void checkBillStateBeforeContractOver(String billState) throws EASBizException {
        int parseInt = Integer.parseInt(billState);
        if (3 != parseInt) {
            throw new EmpEleContractException(EmpEleContractException.BILLSTATE_IS_NOT_AUDITED_CANNOT_OVER);
        }
    }

    public static void checkBillStateBeforeAbandonContract(String billState) throws EASBizException {
        int parseInt = Integer.parseInt(billState);
        if (3 != parseInt) {
            throw new EmpEleContractException(EmpEleContractException.BILLSTATE_IS_NOT_AUDITED_CANNOT_ABANDON);
        }
    }

    public static EmpEleContractSignRecordInfo generateEmpEleContractSignRecord(Context ctx, EmployeeContractInfo employeeContractInfo, HRBillBaseInfo billBaseInfo, HRBillBaseEntryInfo hrBillBaseEntryInfo) throws EASBizException, BOSException {
        String contractNo = employeeContractInfo.getContractNo();
        ContractTempletInfo contractTemplet = employeeContractInfo.getContractTemplet();
        PersonInfo personInfo = employeeContractInfo.getEmployee();
        PreEntryPersonInfo preEntryPersonInfo = employeeContractInfo.getPreEntryPerson();
        IEmpEleContractSignRecord empEleContractSignRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        if (contractTemplet.isIsElectronicSign() && employeeContractInfo.getContractClassify() != null && employeeContractInfo.getContractClassify().getValue() == 2) {
            EmpEleContractSignRecordInfo empEleContractSignRecordInfo = EmpElectronicContractUtilsEx.getEmpEleContractSignRecordInfo(empEleContractSignRecordLocalInstance, employeeContractInfo.getId().toString());
            if (empEleContractSignRecordInfo != null) {
                logger.error("EmpElectronicContractUtilsEx.generateEmpEleContractSignRecord empEleContractSignRecordInfo : " + empEleContractSignRecordInfo.getId());
            }
            if (empEleContractSignRecordInfo == null) {
                logger.error("EmpElectronicContractUtilsEx.generateEmpEleContractSignRecord empEleContractSignRecordInfo is null");
                empEleContractSignRecordInfo = new EmpEleContractSignRecordInfo();
                LabContractFirstPartyInfo labContractFirstParty = employeeContractInfo.getLabContractFirstParty();
                KDContractConfigInfo kdContractConfigInfo = EmpElectronicContractUtilsEx.getKDContractConfigByLabContractFirstParty(ctx, labContractFirstParty);
                String eContractNo = EmpElectronicContractUtils.getEContractNumber(ctx, empEleContractSignRecordLocalInstance, kdContractConfigInfo, contractNo);
                empEleContractSignRecordInfo.setPerson(personInfo);
                empEleContractSignRecordInfo.setPreEntryPerson(preEntryPersonInfo);
                empEleContractSignRecordInfo.setContract(employeeContractInfo);
                empEleContractSignRecordInfo.setContractNO(employeeContractInfo.getContractNo());
                empEleContractSignRecordInfo.setEContractNO(eContractNo);
                empEleContractSignRecordInfo.setSignStatus(EContractSignState.nosign);
                empEleContractSignRecordInfo.setKdContractConfig(kdContractConfigInfo);
                empEleContractSignRecordInfo.setIsInvalid(false);
                if (billBaseInfo != null) {
                    empEleContractSignRecordInfo.setBillId(billBaseInfo.getId());
                }
                if (hrBillBaseEntryInfo != null) {
                    empEleContractSignRecordInfo.setEntryId(hrBillBaseEntryInfo.getId());
                }
                IObjectPK pk = empEleContractSignRecordLocalInstance.save((CoreBaseInfo)empEleContractSignRecordInfo);
                empEleContractSignRecordInfo.setId(BOSUuid.read((String)pk.toString()));
                return empEleContractSignRecordInfo;
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            if (empEleContractSignRecordInfo.getKdContractConfig() == null) {
                LabContractFirstPartyInfo labContractFirstParty = employeeContractInfo.getLabContractFirstParty();
                KDContractConfigInfo kdContractConfigInfo = EmpElectronicContractUtilsEx.getKDContractConfigByLabContractFirstParty(ctx, labContractFirstParty);
                empEleContractSignRecordInfo.setKdContractConfig(kdContractConfigInfo);
                String eContractNo = EmpElectronicContractUtils.getEContractNumber(ctx, empEleContractSignRecordLocalInstance, kdContractConfigInfo, contractNo);
                empEleContractSignRecordInfo.setContractNO(employeeContractInfo.getContractNo());
                empEleContractSignRecordInfo.setEContractNO(eContractNo);
                selector.add(new SelectorItemInfo("kdContractConfig"));
                selector.add(new SelectorItemInfo("contractNO"));
                selector.add(new SelectorItemInfo("eContractNO"));
            }
            if (EContractSignState.uninitiated.equals((Object)empEleContractSignRecordInfo.getSignStatus())) {
                empEleContractSignRecordInfo.setSignStatus(EContractSignState.nosign);
                empEleContractSignRecordInfo.setIsCreate(false);
                empEleContractSignRecordInfo.setEcreateTime(null);
                empEleContractSignRecordInfo.setIsFillSuccess(false);
                selector.add(new SelectorItemInfo("signStatus"));
                selector.add(new SelectorItemInfo("isCreate"));
                selector.add(new SelectorItemInfo("ecreateTime"));
                selector.add(new SelectorItemInfo("isFillSuccess"));
            }
            if (selector.size() > 0) {
                empEleContractSignRecordLocalInstance.updatePartial(empEleContractSignRecordInfo, selector);
            }
            return empEleContractSignRecordInfo;
        }
        throw new EmpEleContractException(EmpEleContractException.BATCHEMPLOYEESIGN_IS_FAIL_FOR_CONTRACTTEMPLET);
    }

    public static EmpEleContractSignRecordInfo repairEmpEleContractSignRecord(Context ctx, ContractBillMiddleInfo contractBillMiddleInfo) throws EASBizException, BOSException {
        String contractNo = contractBillMiddleInfo.getContractNo();
        ContractTempletInfo contractTemplet = contractBillMiddleInfo.getContractTemplet();
        PersonInfo personInfo = contractBillMiddleInfo.getPerson();
        PreEntryPersonInfo preEntryPersonInfo = contractBillMiddleInfo.getPreEntryPerson();
        IEmpEleContractSignRecord empEleContractSignRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        if (contractTemplet.isIsElectronicSign()) {
            EmpEleContractSignRecordInfo empEleContractSignRecordInfo = new EmpEleContractSignRecordInfo();
            LabContractFirstPartyInfo labContractFirstParty = contractBillMiddleInfo.getLabContractFirstParty();
            KDContractConfigInfo kdContractConfigInfo = EmpElectronicContractUtilsEx.getKDContractConfigByLabContractFirstParty(ctx, labContractFirstParty);
            String eContractNo = EmpElectronicContractUtils.getEContractNumber(ctx, empEleContractSignRecordLocalInstance, kdContractConfigInfo, contractNo);
            empEleContractSignRecordInfo.setPerson(personInfo);
            empEleContractSignRecordInfo.setPreEntryPerson(preEntryPersonInfo);
            EmployeeContractInfo employeeContractInfo = new EmployeeContractInfo();
            employeeContractInfo.setId(contractBillMiddleInfo.getContractId());
            empEleContractSignRecordInfo.setContract(employeeContractInfo);
            empEleContractSignRecordInfo.setContractNO(contractBillMiddleInfo.getContractNo());
            empEleContractSignRecordInfo.setEContractNO(eContractNo);
            empEleContractSignRecordInfo.setSignStatus(EContractSignState.nosign);
            empEleContractSignRecordInfo.setKdContractConfig(kdContractConfigInfo);
            empEleContractSignRecordInfo.setIsInvalid(false);
            IObjectPK pk = empEleContractSignRecordLocalInstance.save((CoreBaseInfo)empEleContractSignRecordInfo);
            empEleContractSignRecordInfo.setId(BOSUuid.read((String)pk.toString()));
            return empEleContractSignRecordInfo;
        }
        throw new EmpEleContractException(EmpEleContractException.NOT_SUPPORT__ELECTRONIC_SIGNATURE);
    }

    public static void verifyContractIsFreeOrEnd(Context ctx, EmployeeContractInfo employeeContractInfo) throws EmpEleContractException {
        String name = "";
        if (employeeContractInfo.getEmployee() != null) {
            name = employeeContractInfo.getEmployee().getName();
        } else if (employeeContractInfo.getPreEntryPerson() != null) {
            name = employeeContractInfo.getPreEntryPerson().getName();
        }
        if (employeeContractInfo.getState() != null && (employeeContractInfo.getState().getValue() == 5 || employeeContractInfo.getState().getValue() == 4)) {
            String state = employeeContractInfo.getState().getAlias();
            throw new EmpEleContractException(EmpEleContractException.CANNOT_BATCH_EMPLOYEE_SIGN_FOR_STATE, new Object[]{name, employeeContractInfo.getContractNo(), state});
        }
    }

    public static void verifyContractSignStatusAndContractClassify(Context ctx, EmployeeContractInfo employeeContractInfo) throws EmpEleContractException {
        ContractTempletInfo contractTemplet = employeeContractInfo.getContractTemplet();
        if (!contractTemplet.isIsElectronicSign() || employeeContractInfo.getContractClassify() != null && employeeContractInfo.getContractClassify().getValue() == 0) {
            throw new EmpEleContractException(EmpEleContractException.BATCHEMPLOYEESIGN_IS_FAIL_FOR_CONTRACTTEMPLET);
        }
        if (contractTemplet.isIsElectronicSign() && employeeContractInfo.getContractClassify() != null && employeeContractInfo.getContractClassify().getValue() == 1) {
            throw new EmpEleContractException(EmpEleContractException.BATCHEMPLOYEESIGN_IS_FAIL_FOR_FROM_SSC);
        }
        if (employeeContractInfo.getSignStatus() == null) {
            throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_SIGNSTATUS_IS_NULL);
        }
        if (employeeContractInfo.getSignStatus() != null && (employeeContractInfo.getSignStatus().getValue() == 1 || employeeContractInfo.getSignStatus().getValue() == 2 || employeeContractInfo.getSignStatus().getValue() == 6)) {
            throw new EmpEleContractException(EmpEleContractException.CANNOT_BATCH_EMPLOYEE_SIGN);
        }
    }

    public static EmpTaskMessageLogInfo sendPersonSignMessage(Context ctx, EmpEleContractSignRecordInfo empEleContractSignRecordInfo, EmployeeContractInfo employeeContractInfo) throws EASBizException, BOSException {
        EmpTaskMessageLogInfo empTaskMessageLogInfo = (EmpTaskMessageLogInfo)EmpEleContractSendMessageFacadeFactory.getLocalInstance(ctx).sendPersonSignMessage(empEleContractSignRecordInfo, employeeContractInfo);
        return empTaskMessageLogInfo;
    }

    public static EmpTaskMessageLogInfo sendPersonSignMessageForNewTemplate(Context ctx, EmpEleContractSignRecordInfo empEleContractSignRecordInfo, EmployeeContractInfo employeeContractInfo, String contractId) throws EASBizException, BOSException {
        EmpTaskMessageLogInfo empTaskMessageLogInfo = null;
        try {
            String label8 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractMessageResource", (String)"label8", (Context)ctx);
            logger.error("EmpElectronicContractUtilsEx.sendPersonSignMessageForNewTemplate label8 : " + label8);
            Thread.sleep(2000L);
            boolean isbreak = true;
            int times = 0;
            while (isbreak) {
                Boolean isCreate = EmpElectronicContractUtilsEx.checkElectronicContractIsCreate(ctx, contractId);
                logger.error("EmpElectronicContractUtilsEx.sendPersonSignMessageForNewTemplate times : " + ++times);
                if (!isCreate.booleanValue()) {
                    Thread.sleep(2000L);
                } else {
                    isbreak = false;
                    empTaskMessageLogInfo = (EmpTaskMessageLogInfo)EmpEleContractSendMessageFacadeFactory.getLocalInstance(ctx).sendPersonSignMessage(empEleContractSignRecordInfo, employeeContractInfo);
                }
                if (isCreate.booleanValue() || times <= 15) continue;
                isbreak = false;
                if (empTaskMessageLogInfo != null) continue;
                empTaskMessageLogInfo = new EmpTaskMessageLogInfo();
                BOSUuid contractUuid = BOSUuid.read((String)employeeContractInfo.getId().toString());
                empTaskMessageLogInfo.setBusinessId(contractUuid);
                empTaskMessageLogInfo.setBusinessType("PERSON_SIGN");
                empTaskMessageLogInfo.setSendResult(false);
                empTaskMessageLogInfo.setIsSend(false);
                String label9 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractMessageResource", (String)"label9", (Context)ctx);
                logger.error("EmpElectronicContractUtilsEx.sendPersonSignMessageForNewTemplate label9 : " + label9);
                empTaskMessageLogInfo.setReason(label9);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return empTaskMessageLogInfo;
    }

    public static void checkPersonStatus(Context ctx, EmployeeContractInfo employeeContractInfo) throws BOSException, EASBizException {
        PersonInfo personInfo = employeeContractInfo.getEmployee();
        String personId = "";
        if (personInfo != null) {
            personId = personInfo.getId() != null ? personInfo.getId().toString() : "";
        } else if (employeeContractInfo.getPreEntryPerson() != null) {
            PreEntryPersonInfo preEntryPerson = employeeContractInfo.getPreEntryPerson();
            personId = preEntryPerson.getId() != null ? preEntryPerson.getId().toString() : "";
        }
        HashMap<String, String> osfDataMap = new HashMap<String, String>();
        osfDataMap.put("personId", personId);
        IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
        Map osfResult = (Map)osfServiceFacade.processService("checkPersonBeforeSendPersonSignMessageService", osfDataMap);
        if (osfResult == null || osfResult.size() <= 0 || osfResult.get(personId) == null) {
            String label12 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label3", (Context)ctx);
            String realObj = MessageFormat.format(label12, personId);
            throw new BOSException(realObj);
        }
        logger.error("EmpElectronicContractUtilsEx.checkPersonStatus osfResult : " + osfResult);
        Map dataMap = (Map)osfResult.get(personId);
        String idCardNO = (String)dataMap.get("idCardNO");
        String nCell = (String)dataMap.get("nCell");
        String wxOpenId = (String)dataMap.get("wxOpenId");
        String openId = (String)dataMap.get("openId");
        int sendMessageType = (Integer)dataMap.get("sendMessageType");
        StringBuffer msg = new StringBuffer();
        if (StringUtils.isEmpty((String)idCardNO)) {
            msg.append("NO_IDCARD_NO");
        }
        if (StringUtils.isEmpty((String)nCell)) {
            if (msg.length() > 0) {
                msg.append(",").append("NO_CELL");
            } else {
                msg.append("NO_CELL");
            }
        }
        if (1 == sendMessageType && StringUtils.isEmpty((String)openId)) {
            if (msg.length() > 0) {
                msg.append(",").append("NO_OPEN_ID");
            } else {
                msg.append("NO_OPEN_ID");
            }
        }
        if (2 == sendMessageType && StringUtils.isEmpty((String)wxOpenId)) {
            if (msg.length() > 0) {
                msg.append(",").append("NO_WX");
            } else {
                msg.append("NO_WX");
            }
        }
        if (msg.length() > 0) {
            String realObj = EmpElectronicContractUtils.getMsgInfo(ctx, msg.toString());
            throw new BOSException(realObj);
        }
    }

    public static String getMsgInfo(Context ctx, String msg) {
        if ("NO_IDCARD_NO".equals(msg)) {
            String label4 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label4", (Context)ctx);
            return label4;
        }
        if ("NO_IDCARD_NO,NO_CELL".equals(msg)) {
            String label5 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label5", (Context)ctx);
            return label5;
        }
        if ("NO_IDCARD_NO,NO_OPEN_ID".equals(msg)) {
            String label8 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label8", (Context)ctx);
            return label8;
        }
        if ("NO_IDCARD_NO,NO_WX".equals(msg)) {
            String label9 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label9", (Context)ctx);
            return label9;
        }
        if ("NO_IDCARD_NO,NO_CELL,NO_OPEN_ID".equals(msg)) {
            String label10 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label10", (Context)ctx);
            return label10;
        }
        if ("NO_IDCARD_NO,NO_CELL,NO_WX".equals(msg)) {
            String label11 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label11", (Context)ctx);
            return label11;
        }
        if ("NO_CELL".equals(msg)) {
            String label6 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label6", (Context)ctx);
            return label6;
        }
        if ("NO_CELL,NO_OPEN_ID".equals(msg)) {
            String label12 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label12", (Context)ctx);
            return label12;
        }
        if ("NO_CELL,NO_WX".equals(msg)) {
            String label13 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label13", (Context)ctx);
            return label13;
        }
        if ("NO_OPEN_ID".equals(msg)) {
            String label7 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label7", (Context)ctx);
            return label7;
        }
        String label14 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label14", (Context)ctx);
        return label14;
    }

    public static void pollingProcess(Context ctx, EmpEleContractSignRecordInfo empEleContractSignRecordInfo, String contractId, BatchMessageTipsBody body) throws InterruptedException, BOSException, EASBizException {
        String label17 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label17", (Context)ctx);
        logger.error("EmpElectronicContractUtilsEx.pollingProcess label17 : " + label17);
        String eContractNO = empEleContractSignRecordInfo.getEContractNO();
        Thread.sleep(2000L);
        boolean isbreak = true;
        int times = 0;
        while (isbreak) {
            EmpEleContractCompanyTaskInfo empEleContractCompanyTaskInfo = EmpElectronicContractUtilsEx.getEmpEleContractCompanyTaskInfo(ctx, eContractNO);
            boolean isCallBack = empEleContractCompanyTaskInfo.isIsCallBack();
            String resultCodeStr = empEleContractCompanyTaskInfo.getResultCode();
            int resultCode = 0;
            if (!StringUtils.isEmpty((String)resultCodeStr)) {
                resultCode = Integer.parseInt(resultCodeStr);
            }
            String label18 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label18", (Context)ctx);
            String realObj = MessageFormat.format(label18, ++times);
            logger.error("EmpElectronicContractUtilsEx.pollingProcess label18 : " + realObj);
            if (empEleContractCompanyTaskInfo != null) {
                String label19 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label19", (Context)ctx);
                logger.error("EmpElectronicContractUtilsEx.pollingProcess label19 : " + label19 + " : " + empEleContractCompanyTaskInfo.getId());
            }
            if (isCallBack && 0 == resultCode) {
                isbreak = false;
                String label20 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label20", (Context)ctx);
                throw new BOSException(label20);
            }
            if (isCallBack && 1 == resultCode) {
                isbreak = false;
                body.setMuitTipsState(true);
                String label21 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label21", (Context)ctx);
                body.setMuitTipsMessage(label21);
            } else if (!isCallBack && times > 15) {
                isbreak = false;
                String label22 = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label22", (Context)ctx), 15);
                logger.error("EmpElectronicContractUtilsEx.pollingProcess label22 : " + label22);
                IEmpEleContractServiceFacade empEleContractServiceFacade = EmpEleContractServiceFacadeFactory.getLocalInstance(ctx);
                String recordId = empEleContractSignRecordInfo.getId().toString();
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("eContractNo", eContractNO);
                param.put("contractId", contractId);
                param.put("recordId", recordId);
                param.put("isQueryCompanySign", true);
                logger.error("EmpElectronicContractUtilsEx.pollingProcess param : " + param);
                Object result = empEleContractServiceFacade.getEmpEleContractSignStatus(param);
                String label23 = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label23", (Context)ctx), result);
                logger.error("EmpElectronicContractUtilsEx.pollingProcess label23 : " + label23);
                com.alibaba.fastjson.JSONObject resObj = null;
                resObj = result instanceof com.alibaba.fastjson.JSONObject ? (com.alibaba.fastjson.JSONObject)result : com.alibaba.fastjson.JSONObject.parseObject((String)result.toString());
                int code = resObj.getIntValue("code");
                if (code == 0) {
                    com.alibaba.fastjson.JSONObject data = resObj.getJSONObject("data");
                    int signStatus = data.getIntValue("signStatus");
                    if (signStatus == 1) {
                        EmpElectronicContractUtilsEx.updateEmpEleContractCompanyTaskInfo(ctx, empEleContractCompanyTaskInfo, true);
                        EmpElectronicContractUtilsEx.updateKDContractConfigRecordState(ctx, eContractNO);
                        IEmployeeContract employeeContractLocalInstance = EmployeeContractFactory.getLocalInstance((Context)ctx);
                        EmployeeContractInfo employeeContractInfo = EmpElectronicContractUtilsEx.getEmployeeContractInfo(employeeContractLocalInstance, contractId);
                        boolean isSigned = true;
                        if (empEleContractSignRecordInfo.getBillId() != null) {
                            isSigned = EmpEleContractFollowUtils.isSignComplete(ctx, empEleContractSignRecordInfo.getBillId().toString());
                        }
                        if (isSigned) {
                            logger.error("EmpElectronicContractUtils_pollingProcess sendSignCompleteMessage ");
                            EmpEleContractSendMessageFacadeFactory.getLocalInstance(ctx).sendSignCompleteMessage(empEleContractSignRecordInfo, employeeContractInfo);
                            body.setMuitTipsState(true);
                            String label21 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label21", (Context)ctx);
                            body.setMuitTipsMessage(label21);
                        }
                    } else {
                        isbreak = false;
                        String label20 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label20", (Context)ctx);
                        throw new BOSException(label20);
                    }
                }
            }
            if (!isbreak) continue;
            Thread.sleep(2000L);
        }
    }

    public static EmpEleContractCompanyTaskInfo getEmpEleContractCompanyTaskInfo(Context ctx, String eContractNO) throws BOSException {
        EmpEleContractCompanyTaskInfo empEleContractCompanyTaskInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contractNo", (Object)eContractNO));
        view.setFilter(filter);
        EmpEleContractCompanyTaskCollection empEleContractCompanyTaskCollection = EmpEleContractCompanyTaskFactory.getLocalInstance(ctx).getEmpEleContractCompanyTaskCollection(view);
        if (empEleContractCompanyTaskCollection.size() > 0) {
            empEleContractCompanyTaskInfo = empEleContractCompanyTaskCollection.get(0);
        }
        return empEleContractCompanyTaskInfo;
    }

    public static void updateEmpEleContractCompanyTaskInfo(Context ctx, EmpEleContractCompanyTaskInfo empEleContractCompanyTaskInfo, boolean isSuccess) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        if (isSuccess) {
            Timestamp curTimestamp = EmpElectronicContractUtilsEx.getCurTimestamp();
            empEleContractCompanyTaskInfo.setIsCallBack(true);
            empEleContractCompanyTaskInfo.setCallBackTime(curTimestamp);
            empEleContractCompanyTaskInfo.setResultCode("1");
            empEleContractCompanyTaskInfo.setResultDesc("");
            empEleContractCompanyTaskInfo.setUserId("");
            empEleContractCompanyTaskInfo.setIsFinish(true);
            empEleContractCompanyTaskInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
            empEleContractCompanyTaskInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
            selector.add(new SelectorItemInfo("isCallBack"));
            selector.add(new SelectorItemInfo("callbackTime"));
            selector.add(new SelectorItemInfo("resultCode"));
            selector.add(new SelectorItemInfo("resultDesc"));
            selector.add(new SelectorItemInfo("userId"));
            selector.add(new SelectorItemInfo("isFinish"));
            selector.add(new SelectorItemInfo("lastUpdateTime"));
            selector.add(new SelectorItemInfo("lastUpdateUser"));
            EmpEleContractCompanyTaskFactory.getLocalInstance(ctx).updatePartial(empEleContractCompanyTaskInfo, selector);
        } else {
            empEleContractCompanyTaskInfo.setIsRequest(false);
            empEleContractCompanyTaskInfo.setRequestTime(null);
            empEleContractCompanyTaskInfo.setIsCallBack(false);
            empEleContractCompanyTaskInfo.setCallBackTime(null);
            empEleContractCompanyTaskInfo.setResultCode("0");
            empEleContractCompanyTaskInfo.setResultDesc("");
            empEleContractCompanyTaskInfo.setUserId("");
            empEleContractCompanyTaskInfo.setIsFinish(false);
            empEleContractCompanyTaskInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
            empEleContractCompanyTaskInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
            selector.add(new SelectorItemInfo("isRequest"));
            selector.add(new SelectorItemInfo("requestTime"));
            selector.add(new SelectorItemInfo("isCallBack"));
            selector.add(new SelectorItemInfo("callbackTime"));
            selector.add(new SelectorItemInfo("resultCode"));
            selector.add(new SelectorItemInfo("resultDesc"));
            selector.add(new SelectorItemInfo("isFinish"));
            selector.add(new SelectorItemInfo("lastUpdateTime"));
            selector.add(new SelectorItemInfo("lastUpdateUser"));
            EmpEleContractCompanyTaskFactory.getLocalInstance(ctx).updatePartial(empEleContractCompanyTaskInfo, selector);
        }
    }

    public static void updateKDContractConfigRecordState(Context ctx, String eContractNO) throws EASBizException, BOSException {
        logger.info("updateKDContractConfigRecordState_ is " + eContractNO);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("fileNo"));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("result"));
        filterInfo.getFilterItems().add(new FilterItemInfo("fileNo", (Object)eContractNO));
        filterInfo.getFilterItems().add(new FilterItemInfo("result", (Object)false));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)2));
        view.setFilter(filterInfo);
        view.setSelector(selector);
        IKDContractConfigRecord ikdContractConfigRecord = KDContractConfigRecordFactory.getLocalInstance((Context)ctx);
        KDContractConfigRecordCollection recordCollection = ikdContractConfigRecord.getKDContractConfigRecordCollection(view);
        logger.info("recordCollection_ is " + recordCollection);
        if (recordCollection != null && recordCollection.size() > 0) {
            logger.error("EmpElectronicContractUtilsEx.updateKDContractConfigRecordState eContractNo : " + eContractNO);
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("state"));
            selector.add(new SelectorItemInfo("result"));
            selector.add(new SelectorItemInfo("lastUpdateTime"));
            selector.add(new SelectorItemInfo("lastUpdateUser"));
            KDContractConfigRecordInfo recordInfo = recordCollection.get(0);
            recordInfo.setResult(true);
            recordInfo.setState(BaseItemStateEnum.ENABLE);
            recordInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
            recordInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
            ikdContractConfigRecord.updatePartial(recordInfo, selector);
        }
    }

    public static KDContractConfigInfo getKDContractConfigByLabContractFirstParty(Context ctx, LabContractFirstPartyInfo labContractFirstParty) throws BOSException, EASBizException {
        String labContractFirstPartyId = labContractFirstParty != null ? (labContractFirstParty.getId() != null ? labContractFirstParty.getId().toString() : "") : "";
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("labContractFirstParty.id", (Object)labContractFirstPartyId));
        viewInfo.setFilter(filter);
        KDContractConfigInfo kdContractConfigInfo = null;
        KDContractConfigCollection kdContractConfigCollection = KDContractConfigFactory.getLocalInstance((Context)ctx).getKDContractConfigCollection(viewInfo);
        if (kdContractConfigCollection != null && kdContractConfigCollection.size() > 0) {
            kdContractConfigInfo = kdContractConfigCollection.get(0);
            if (kdContractConfigInfo == null) {
                throw new EmpEleContractException(EmpEleContractException.CONTRACT_CONFIG_IS_NOT_OPEN, new Object[]{labContractFirstParty == null ? "" : labContractFirstParty.getName()});
            }
            if (kdContractConfigInfo.getServiceStatus() != KDContractServiceStatus.REGISTSUCC) {
                throw new EmpEleContractException(EmpEleContractException.KDCONTRACTSERVICE_NO_REGISTSUCC, new Object[]{labContractFirstParty == null ? "" : labContractFirstParty.getName()});
            }
        } else {
            throw new EmpEleContractException(EmpEleContractException.CONTRACT_CONFIG_IS_NOT_OPEN, new Object[]{labContractFirstParty == null ? "" : labContractFirstParty.getName()});
        }
        return kdContractConfigInfo;
    }

    public static KDContractConfigInfo getKDContractConfigByLabContractFirstParty(Context ctx, String labContractFirstPartyId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("labContractFirstParty.id", (Object)labContractFirstPartyId));
        viewInfo.setFilter(filter);
        KDContractConfigInfo kdContractConfigInfo = null;
        KDContractConfigCollection kdContractConfigCollection = KDContractConfigFactory.getLocalInstance((Context)ctx).getKDContractConfigCollection(viewInfo);
        if (kdContractConfigCollection != null && kdContractConfigCollection.size() > 0) {
            kdContractConfigInfo = kdContractConfigCollection.get(0);
        }
        return kdContractConfigInfo;
    }

    public static SHRElectronicTemplateInfo getSHRElectronicTemplateInfo(Context ctx, ContractTempletInfo templetInfo) throws BOSException, EmpEleContractException {
        ISHRElectronicTemplate electronicTemplateLocalInstance = SHRElectronicTemplateFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contractTemplet.id", (Object)templetInfo.getId().toString()));
        viewInfo.setFilter(filter);
        SHRElectronicTemplateCollection electronicTemplateInfoColl = electronicTemplateLocalInstance.getSHRElectronicTemplateCollection(viewInfo);
        if (electronicTemplateInfoColl.size() <= 0) {
            throw new EmpEleContractException(EmpEleContractException.NOT_FOUND_ELECTRONIC_TEMPLATE);
        }
        SHRElectronicTemplateInfo electronicTemplateInfo = electronicTemplateInfoColl.get(0);
        return electronicTemplateInfo;
    }

    public static SHRElectronicTemplateInfo getSHRElectronicTemplateInfoByEmployeeContract(Context ctx, EmployeeContractInfo employeeContractInfo) throws BOSException, EmpEleContractException {
        ISHRElectronicTemplate electronicTemplateLocalInstance = SHRElectronicTemplateFactory.getLocalInstance(ctx);
        ContractTempletInfo contractTempletInfo = employeeContractInfo.getContractTemplet();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contractTemplet.id", (Object)contractTempletInfo.getId().toString()));
        viewInfo.setFilter(filter);
        SHRElectronicTemplateCollection electronicTemplateInfoColl = electronicTemplateLocalInstance.getSHRElectronicTemplateCollection(viewInfo);
        if (electronicTemplateInfoColl.size() <= 0) {
            throw new EmpEleContractException(EmpEleContractException.NOT_FOUND_ELECTRONIC_TEMPLATE);
        }
        SHRElectronicTemplateInfo electronicTemplateInfo = electronicTemplateInfoColl.get(0);
        return electronicTemplateInfo;
    }

    public static String getEContractNumber(Context ctx, IEmpEleContractSignRecord empEleContractSignRecordLocalInstance, KDContractConfigInfo kdContractConfigInfo, String contractNo) throws EASBizException, BOSException {
        String no = "";
        if (!StringUtils.isEmpty((String)contractNo)) {
            if (kdContractConfigInfo != null) {
                no = no + contractNo + "-" + kdContractConfigInfo.getClientKDAppId();
            } else {
                String systemTimeStamp = EmpElectronicContractUtilsEx.getSystemTimeStamp();
                no = no + contractNo + "-" + systemTimeStamp;
            }
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        FilterItemInfo filterItemInfo = new FilterItemInfo("eContractNO", (Object)no);
        filterItems.add(filterItemInfo);
        IEmpEleContractDelLog empEleContractDelLogLocalInstance = EmpEleContractDelLogFactory.getLocalInstance(ctx);
        while (empEleContractSignRecordLocalInstance.exists(filter) || empEleContractDelLogLocalInstance.exists(filter)) {
            filterItems.remove(filterItemInfo);
            String systemTimeStamp = EmpElectronicContractUtilsEx.getSystemTimeStamp();
            no = no + "-" + systemTimeStamp;
            filterItemInfo = new FilterItemInfo("eContractNO", (Object)no);
            filterItems.add(filterItemInfo);
        }
        return no;
    }

    public static String getSystemTimeStamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSSS");
        String id = sdf.format(System.currentTimeMillis());
        return id;
    }

    public static ContractBillMiddleInfo getContractBillMiddleInfoByContractId(Context ctx, IContractBillMiddle contractBillMiddleLocalInstance, String contractId) throws BOSException {
        ContractBillMiddleInfo middle = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contractId", (Object)contractId));
        viewInfo.setFilter(filter);
        logger.error("EmpElectronicContractUtilsEx.getContractBillMiddleInfoByContractId viewInfo : " + Base64Utils.encode((String)viewInfo.toString()));
        ContractBillMiddleCollection collection = ContractBillMiddleFactory.getLocalInstance(ctx).getContractBillMiddleCollection(viewInfo);
        if (collection.size() > 0) {
            middle = collection.get(0);
        }
        return middle;
    }

    public static PersonInfo getPersonInfo(Context ctx, String personId) throws EASBizException, BOSException {
        PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId), EmpElectronicContractUtilsEx.getPersonSelectorCollection());
        return personInfo;
    }

    public static PersonThreeEleInfo getPersonThreeInfo(Context ctx, String personId) throws BOSException {
        EntityViewInfo view;
        FilterInfo filter;
        SelectorItemCollection sic;
        PersonThreeEleInfo info = null;
        BOSUuid bosUuid = BOSUuid.read((String)personId);
        String bosType = bosUuid.getType().toString();
        if ("80EF7DED".equals(bosType)) {
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("cell"));
            sic.add(new SelectorItemInfo("idCardNO"));
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)personId));
            view = new EntityViewInfo();
            view.setSelector(sic);
            view.setFilter(filter);
            PersonCollection personColls = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(view);
            if (personColls.size() > 0) {
                info = new PersonThreeEleInfo(bosUuid);
                PersonInfo personInfo = personColls.get(0);
                info.setName(personInfo.getName());
                info.setMobile(personInfo.getCell());
                info.setIdCardNO(personInfo.getIdCardNO());
                return info;
            }
        }
        if ("33E8F2DB".equals(bosType)) {
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("cellPhone"));
            sic.add(new SelectorItemInfo("talent.id"));
            sic.add(new SelectorItemInfo("talent.name"));
            sic.add(new SelectorItemInfo("talent.idCardNO"));
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("talent.id", (Object)personId));
            view = new EntityViewInfo();
            view.setSelector(sic);
            view.setFilter(filter);
            PreEntryCollection preEntryColls = PreEntryFactory.getLocalInstance((Context)ctx).getPreEntryCollection(view);
            if (preEntryColls.size() > 0) {
                info = new PersonThreeEleInfo(bosUuid);
                PreEntryInfo preEntryInfo = preEntryColls.get(0);
                info.setName(preEntryInfo.getTalent().getName());
                info.setMobile(preEntryInfo.getCellPhone());
                info.setIdCardNO(preEntryInfo.getTalent().getIdCardNO());
                return info;
            }
        }
        return null;
    }

    public static PersonContactMethodInfo getPersonContactMethodInfo(Context ctx, String personId) throws BOSException, EmpEleContractMessageException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("nCell"));
        viewInfo.setSelector(selector);
        PersonContactMethodCollection personContactMethodCollection = PersonContactMethodFactory.getLocalInstance((Context)ctx).getPersonContactMethodCollection(viewInfo);
        if (personContactMethodCollection != null && personContactMethodCollection.size() > 0) {
            return personContactMethodCollection.get(0);
        }
        throw new EmpEleContractMessageException(EmpEleContractMessageException.GET_NCELL_FAIL, new Object[]{personId});
    }

    public static PreEntryInfo getPreEntryInfo(Context ctx, String preEntryPersonId) throws BOSException, EmpEleContractMessageException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("cellPhone"));
        selector.add(new SelectorItemInfo("talent.id"));
        selector.add(new SelectorItemInfo("talent.idCardNO"));
        selector.add(new SelectorItemInfo("talent.passportNO"));
        selector.add(new SelectorItemInfo("adminOrg.company.name"));
        selector.add(new SelectorItemInfo("hrOrgUnit.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("talent.id", (Object)preEntryPersonId));
        view.setFilter(filter);
        view.setSelector(selector);
        PreEntryCollection preEntryPersoncolls = PreEntryFactory.getLocalInstance((Context)ctx).getPreEntryCollection(view);
        if (preEntryPersoncolls != null && preEntryPersoncolls.size() > 0) {
            return preEntryPersoncolls.get(0);
        }
        throw new EmpEleContractMessageException(EmpEleContractMessageException.GET_PREEBTRY_FAIL, new Object[]{preEntryPersonId});
    }

    public static EContractSignState getEmpEleContractSignRecordSignStatus(Context ctx, String contractId) throws BOSException, EASBizException {
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contract.id", (Object)contractId));
        filter.getFilterItems().add(new FilterItemInfo("isInvalid", (Object)0, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("signStatus"));
        viewInfo.setSelector(selector);
        EmpEleContractSignRecordCollection empEleContractSignRecordCollection = EmpEleContractSignRecordFactory.getLocalInstance(ctx).getEmpEleContractSignRecordCollection(viewInfo);
        if (empEleContractSignRecordCollection.size() > 0) {
            empEleContractSignRecordInfo = empEleContractSignRecordCollection.get(0);
        }
        if (empEleContractSignRecordInfo == null) {
            throw new EmpEleContractException(EmpEleContractException.GET_EMPELECONTRACTSIGNRECORD_BY_CONTRACTID_IS_ERROR, new Object[]{"ID", contractId});
        }
        return empEleContractSignRecordInfo.getSignStatus();
    }

    public static String getEContractNOByContractId(Context ctx, String contractId) throws BOSException, EASBizException {
        IEmpEleContractSignRecord empEleContractSignRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = EmpElectronicContractUtilsEx.getEmpEleContractSignRecordInfo(empEleContractSignRecordLocalInstance, contractId);
        if (empEleContractSignRecordInfo == null) {
            throw new EmpEleContractException(EmpEleContractException.GET_EMPELECONTRACTSIGNRECORD_BY_CONTRACTID_IS_ERROR, new Object[]{"ID", contractId});
        }
        String eContractNO = empEleContractSignRecordInfo.getEContractNO();
        return eContractNO;
    }

    public static String getEContractNOByContractNO(Context ctx, String contractNO) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contractNo", (Object)contractNO));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(selector);
        EmployeeContractInfo employeeContractInfo = null;
        EmployeeContractCollection employeeContractCollection = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractCollection(viewInfo);
        if (employeeContractCollection != null && employeeContractCollection.size() > 0) {
            employeeContractInfo = employeeContractCollection.get(0);
        }
        if (employeeContractInfo == null) {
            throw new EmpEleContractException(EmpEleContractException.GET_EMPLOYEECONTRACT_BY_CONTRACTNO_IS_ERROR, new Object[]{"contractNO", contractNO});
        }
        String contractId = employeeContractInfo.getId() != null ? employeeContractInfo.getId().toString() : "";
        IEmpEleContractSignRecord empEleContractSignRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = EmpElectronicContractUtilsEx.getEmpEleConSignRecordInfo(empEleContractSignRecordLocalInstance, contractId);
        if (empEleContractSignRecordInfo == null) {
            throw new EmpEleContractException(EmpEleContractException.GET_EMPELECONTRACTSIGNRECORD_BY_CONTRACTID_IS_ERROR, new Object[]{"id", contractNO});
        }
        String eContractNO = empEleContractSignRecordInfo.getEContractNO();
        return eContractNO;
    }

    public static LabContractFirstPartyInfo getLabContractFirstPartyByContractNo(Context ctx, String contractNO) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contractNo", (Object)contractNO));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("contractNo"));
        selector.add(new SelectorItemInfo("labContractFirstParty.id"));
        selector.add(new SelectorItemInfo("labContractFirstParty.name"));
        selector.add(new SelectorItemInfo("labContractFirstParty.number"));
        viewInfo.setSelector(selector);
        EmployeeContractInfo employeeContractInfo = null;
        LabContractFirstPartyInfo labContractFirstParty = null;
        EmployeeOtherContractInfo empOtherContractInfo = null;
        EmployeeContractCollection employeeContractCollection = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractCollection(viewInfo);
        if (employeeContractCollection != null && employeeContractCollection.size() > 0) {
            employeeContractInfo = employeeContractCollection.get(0);
            labContractFirstParty = employeeContractInfo.getLabContractFirstParty();
        }
        if (employeeContractInfo == null) {
            EmployeeOtherContractCollection empOtherContractCollection = EmployeeOtherContractFactory.getLocalInstance((Context)ctx).getEmployeeOtherContractCollection(viewInfo);
            if (empOtherContractCollection != null && empOtherContractCollection.size() > 0) {
                empOtherContractInfo = empOtherContractCollection.get(0);
            }
            if (empOtherContractInfo == null) {
                throw new EmpEleContractException(EmpEleContractException.GET_EMPLOYEECONTRACT_BY_CONTRACTNO_IS_ERROR, new Object[]{"contractNO", contractNO});
            }
            labContractFirstParty = empOtherContractInfo.getLabContractFirstParty();
        }
        return labContractFirstParty;
    }

    public static void reverseEmployeeContractSignStatus(Context ctx, IEmployeeContract employeeContractLocalInstance, EmployeeContractInfo employeeContractInfo, EmpEleContractSignRecordInfo empEleContractSignRecordInfo) throws EASBizException, BOSException {
        employeeContractInfo.setSignStatus(empEleContractSignRecordInfo.getSignStatus());
        employeeContractInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
        employeeContractInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("signStatus"));
        selectors.add(new SelectorItemInfo("lastUpdateTime"));
        selectors.add(new SelectorItemInfo("lastUpdateUser"));
        employeeContractLocalInstance.updatePartial((CoreBaseInfo)employeeContractInfo, selectors);
    }

    public static Map<String, String> assembleContractInfoData(Context ctx, String contractId, SHRElectronicTemplateInfo electronicTemplateInfo, PersonInfo person) throws BOSException, EmpEleContractException {
        HashMap<String, String> hashMap;
        block6: {
            HashMap<String, String> infoMap = new HashMap();
            JSONArray configList = new JSONArray();
            if (StringUtils.isEmpty((String)electronicTemplateInfo.getConfig())) {
                throw new EmpEleContractException(EmpEleContractException.SHRELECTRONICTEMPLATE_CONFIG_IS_NULL);
            }
            String config = electronicTemplateInfo.getConfig();
            configList = JSONArray.parseArray((String)config);
            logger.error("EmpElectronicContractUtilsEx.assembleContractInfoData configList " + configList);
            Map fieldFormConfig = ElectronicContractUtils.sortFieidFormConfig((Context)ctx, (JSONArray)configList);
            JSONArray queryField = (JSONArray)fieldFormConfig.get(ETemplateFieldType.QueryField.getValue());
            JSONArray cmpItem = (JSONArray)fieldFormConfig.get(ETemplateFieldType.CmpItem.getValue());
            JSONArray other = (JSONArray)fieldFormConfig.get(ETemplateFieldType.Other.getValue());
            Map mulMap = (Map)fieldFormConfig.get(ETemplateFieldType.Mul.getValue());
            HashMap<String, JSONArray> params = new HashMap<String, JSONArray>();
            params.put("selectorFields", queryField);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("contractId", (Object)contractId));
            IRowSet executeQuerySet = null;
            try {
                Map queryParam = ElectronicTemplateSqlUtils.getBizQueryParam((Context)ctx, params, (SHRElectronicTemplateInfo)electronicTemplateInfo, (FilterInfo)filterInfo);
                executeQuerySet = DbUtil.executeQuery((Context)ctx, (String)queryParam.get("sql").toString());
                infoMap = RowSetUtils.transformRowSetValue((Context)ctx, infoMap, (JSONArray)queryField, (IRowSet)executeQuerySet, (Map)queryParam);
                ElectronicContractUtils.processMulFieldData((Context)ctx, infoMap, (Map)mulMap, (Map)queryParam);
                ElectronicContractUtils.processCmpItemData((Context)ctx, infoMap, (JSONArray)cmpItem, (PersonInfo)person);
                ElectronicContractUtils.processOtherData((Context)ctx, infoMap, (JSONArray)other, (PersonInfo)person);
                hashMap = infoMap;
                if (executeQuerySet == null) break block6;
            }
            catch (Exception e) {
                try {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (executeQuerySet != null) {
                        SQLUtils.cleanup(executeQuerySet);
                    }
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)executeQuerySet);
        }
        return hashMap;
    }

    public static Boolean checkElectronicContractIsCreate(Context ctx, String contractId) throws BOSException {
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = EmpElectronicContractUtilsEx.getEmpEleContractSignRecordInfo(ctx, contractId);
        if (empEleContractSignRecordInfo != null) {
            return empEleContractSignRecordInfo.isIsCreate();
        }
        logger.error("EmpElectronicContractUtilsEx.checkElectronicContractIsCreate empEleContractSignRecordInfo is null : false");
        return false;
    }

    public static EmpEleContractSignRecordInfo getEmpEleContractSignRecordInfo(Context ctx, String contractId) throws BOSException {
        EmpEleContractSignRecordInfo empEleContractSignRecordInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contract.id", (Object)contractId));
        filter.getFilterItems().add(new FilterItemInfo("isInvalid", (Object)0, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        IEmpEleContractSignRecord empEleContractSignRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpEleContractSignRecordCollection empEleContractSignRecordCollection = empEleContractSignRecordLocalInstance.getEmpEleContractSignRecordCollection(viewInfo);
        if (empEleContractSignRecordCollection.size() > 0) {
            empEleContractSignRecordInfo = empEleContractSignRecordCollection.get(0);
        }
        return empEleContractSignRecordInfo;
    }

    public static String addContractNumber(Context ctx, LabContractFirstPartyInfo labContractFirstParty, String number) throws EASBizException, BOSException {
        KDContractConfigInfo kdContractConfigInfo = EmpElectronicContractUtilsEx.getKDContractConfigByLabContractFirstParty(ctx, labContractFirstParty);
        String no = "";
        if (!StringUtils.isEmpty((String)number)) {
            no = no + number + "-" + kdContractConfigInfo.getClientKDAppId();
        }
        logger.error("ElectronicContractUtils addContractNumber no : " + no);
        return no;
    }

    public static String getShortUrl(Context ctx, String pageBaseUrl, String tspServerUrl, String serviceId, String personId, String nCell, String contractNo, String contractId) throws EASBizException {
        String scheme = "EmpEle_Contract";
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        StringBuffer longUrl = new StringBuffer();
        longUrl.append(pageBaseUrl);
        longUrl.append("?mobile=");
        try {
            longUrl.append(URLEncoder.encode(nCell, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            longUrl.append(nCell);
            logger.error(e.getMessage(), (Throwable)e);
        }
        longUrl.append("&kdAppId=");
        longUrl.append(serviceId);
        longUrl.append("&contractNo=");
        longUrl.append(contractNo);
        longUrl.append("&serviceId=");
        longUrl.append(serviceId);
        longUrl.append("&sHRVer=861");
        longUrl.append("&contractP=true");
        longUrl.append("&isEmp=true");
        dataMap.put("preEntryId", personId + ";" + contractId + ";" + nCell);
        dataMap.put("companyId", serviceId);
        dataMap.put("longUrl", longUrl);
        dataMap.put("scheme", scheme);
        String tspInterfaceUrl = tspServerUrl + "/econtract/preentry/getShortUrl?randomuuid=" + HttpClientUtil.generateShortUuid();
        String label1 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractMessageResource", (String)"label1", (Context)ctx);
        logger.error("EmpElectronicContractUtilsEx.getShortUrl label1 : " + label1 + " dataMap : " + dataMap);
        logger.error("EmpElectronicContractUtilsEx.getShortUrl label1 : " + label1 + " tspInterfaceUrl : " + tspInterfaceUrl);
        JSONObject jsonObejct = HttpClientUtil.postForm(ctx, tspInterfaceUrl, dataMap);
        String label2 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractMessageResource", (String)"label2", (Context)ctx);
        logger.error("EmpElectronicContractUtilsEx.getShortUrl label2 : " + label2 + jsonObejct.toString());
        int status = jsonObejct.getInt("status");
        String shortUrl = "";
        if (status == 200) {
            String label3 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractMessageResource", (String)"label3", (Context)ctx);
            logger.error("EmpElectronicContractUtilsEx.getShortUrl label3 : " + label3);
            try {
                JSONObject jsData = jsonObejct.getJSONObject("result");
                if (!"0".equals(jsData.getString("errcode"))) {
                    String label5 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractMessageResource", (String)"label5", (Context)ctx);
                    throw CloudServiceExceptionUtil.getCloudServiceException(Integer.parseInt(jsData.getString("errcode")), jsData.getString("data"), label5);
                }
                String label4 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractMessageResource", (String)"label4", (Context)ctx);
                logger.error("EmpElectronicContractUtilsEx.getShortUrl label4 : " + label4);
                shortUrl = jsData.getString("data");
            }
            catch (Exception e) {
                String label5 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractMessageResource", (String)"label5", (Context)ctx);
                throw CloudServiceExceptionUtil.getCloudServiceException(status, jsonObejct.toString(), label5);
            }
        } else {
            String label5 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractMessageResource", (String)"label5", (Context)ctx);
            throw CloudServiceExceptionUtil.getCloudServiceException(status, jsonObejct.toString(), label5);
        }
        return shortUrl;
    }

    public static boolean sendPhoneMessage(Context ctx, String tspServerUrl, String serviceId, String phone, String messageServiceId, Map<String, Object> params) throws EASBizException {
        HashMap<String, String> queryParamsCondition = new HashMap<String, String>();
        HashMap<String, String> presetParValMap = new HashMap<String, String>();
        presetParValMap.put("presetName", String.valueOf(params.get("0")));
        presetParValMap.put("presetCompanyFullName", String.valueOf(params.get("presetCompanyFullName")));
        HashMap<String, String> cloudParams = new HashMap<String, String>();
        cloudParams.put("shorturl", String.valueOf(params.get("shorturl")));
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("contractNum", String.valueOf(params.get("contractNum")));
        boolean isPreEntryPerson = Boolean.valueOf(String.valueOf(params.get("isPreEntryPerson")));
        Object[] mapObjs = new Object[]{presetParValMap, queryParamsCondition, cloudParams, customParams};
        Map result = new HashMap();
        logger.error("EmpElectronicContractUtilsEx.sendPhoneMessage   phone= : " + phone + "    params=" + params + "  ===isPreEntryPerson=" + isPreEntryPerson);
        if (isPreEntryPerson) {
            queryParamsCondition.put("billId", String.valueOf(params.get("billId")));
            queryParamsCondition.put("entryId", String.valueOf(params.get("entryId")));
            result = "HRSSC_Contract_Pre_Sign_PACKAGE".equals(messageServiceId) ? SMSSendEntry.sendSMS((ISMSStrategy)new NewSignSMSStrategy("PRE_ENTRY_SIGN", phone, String.valueOf(params.get("hrOrgUnitId")), mapObjs), (Context)ctx) : SMSSendEntry.sendSMS((ISMSStrategy)new SignOverSMSStrategy("PRE_ENTRY_SIGN_OVER", phone, String.valueOf(params.get("hrOrgUnitId")), mapObjs), (Context)ctx);
        } else {
            queryParamsCondition.put("contractId", String.valueOf(params.get("contractId")));
            queryParamsCondition.put("contractNo", String.valueOf(params.get("contractNo")));
            result = "tsprz016".equals(messageServiceId) ? SMSSendEntry.sendSMS((ISMSStrategy)new NewSignSMSStrategy("EMP_NEWSIGN", phone, String.valueOf(params.get("hrOrgUnitId")), mapObjs), (Context)ctx) : SMSSendEntry.sendSMS((ISMSStrategy)new SignOverSMSStrategy("EMP_SIGNOVER", phone, String.valueOf(params.get("hrOrgUnitId")), mapObjs), (Context)ctx);
        }
        return null != (Integer)result.get("code") && 0 == (Integer)result.get("code");
    }

    public static ContractBillMiddleInfo getContractBillMiddleInfo(Context ctx, Map param) throws BOSException {
        ContractBillMiddleInfo contractBillMiddleInfo = null;
        String contractNO = (String)param.get("contractNO");
        contractNO = EmpElectronicContractUtilsEx.getRealContractNo(ctx, contractNO);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("contractNo", (Object)contractNO));
        filterInfo.getFilterItems().add(new FilterItemInfo("contractId is not null"));
        view.setFilter(filterInfo);
        SelectorItemCollection selectorCollection = EmpElectronicContractUtilsEx.getContractBillMiddleSelectorCollection();
        view.setSelector(selectorCollection);
        logger.error("EmpElectronicContractUtilsEx.getContractBillMiddleInfo  view : " + Base64Utils.encode((String)view.toString()));
        ContractBillMiddleCollection contractBillMiddleCollection = ContractBillMiddleFactory.getLocalInstance(ctx).getContractBillMiddleCollection(view);
        if (contractBillMiddleCollection != null && contractBillMiddleCollection.size() > 0) {
            contractBillMiddleInfo = contractBillMiddleCollection.get(0);
        }
        return contractBillMiddleInfo;
    }

    public static ContractBillMiddleInfo getContractBillMiddleInfo(Context ctx, String eContractNO) throws BOSException {
        ContractBillMiddleInfo contractBillMiddleInfo = null;
        String contractNO = EmpElectronicContractUtilsEx.getRealContractNo(ctx, eContractNO);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("contractNo", (Object)contractNO));
        filterInfo.getFilterItems().add(new FilterItemInfo("contractId is not null"));
        view.setFilter(filterInfo);
        SelectorItemCollection selectorCollection = EmpElectronicContractUtilsEx.getContractBillMiddleSelectorCollection();
        view.setSelector(selectorCollection);
        logger.error("EmpElectronicContractUtilsEx.getContractBillMiddleInfo  view : " + Base64Utils.encode((String)view.toString()));
        ContractBillMiddleCollection contractBillMiddleCollection = ContractBillMiddleFactory.getLocalInstance(ctx).getContractBillMiddleCollection(view);
        if (contractBillMiddleCollection != null && contractBillMiddleCollection.size() > 0) {
            contractBillMiddleInfo = contractBillMiddleCollection.get(0);
        }
        return contractBillMiddleInfo;
    }

    public static String getRealContractNo(Context ctx, String eContractNO) throws BOSException {
        AbstractEmpEleContractSignRecordInfo empEleContractSignRecordInfo = null;
        String contractNO = "";
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("eContractNO", (Object)eContractNO));
        filter.getFilterItems().add(new FilterItemInfo("isInvalid", (Object)0, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("contractNO"));
        viewInfo.setSelector(selector);
        IEmpEleContractSignRecord empEleContractSignRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpEleContractSignRecordCollection empEleContractSignRecordCollection = empEleContractSignRecordLocalInstance.getEmpEleContractSignRecordCollection(viewInfo);
        logger.error("EmpElectronicContractUtilsEx.getRealContractNo viewInfo : " + Base64Utils.encode((String)viewInfo.toString()));
        if (empEleContractSignRecordCollection != null && empEleContractSignRecordCollection.size() > 0) {
            empEleContractSignRecordInfo = empEleContractSignRecordCollection.get(0);
        }
        if (empEleContractSignRecordInfo != null) {
            contractNO = empEleContractSignRecordInfo.getContractNO();
        }
        if (StringUtils.isEmpty((String)contractNO)) {
            logger.error("EmpElectronicContractUtilsEx.getRealContractNo other viewInfo : " + Base64Utils.encode((String)viewInfo.toString()));
            AbstractEmpOtherEleContractSignRecordInfo otherRecord = null;
            IEmpOtherEleContractSignRecord otherContractSignRecordLocalInstance = EmpOtherEleContractSignRecordFactory.getLocalInstance(ctx);
            EmpOtherEleContractSignRecordCollection otherCollection = otherContractSignRecordLocalInstance.getEmpOtherEleContractSignRecordCollection(viewInfo);
            if (otherCollection != null && otherCollection.size() > 0) {
                otherRecord = otherCollection.get(0);
            }
            if (otherRecord != null) {
                contractNO = otherRecord.getContractNO();
            }
        }
        logger.error("EmpElectronicContractUtilsEx.getRealContractNo contractNO : " + contractNO);
        return contractNO;
    }

    public static ContractBillMiddleInfo getContractBillMiddleInfoById(Context ctx, String contractBillMiddleId) throws BOSException {
        ContractBillMiddleInfo contractBillMiddleInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)contractBillMiddleId));
        view.setFilter(filterInfo);
        SelectorItemCollection selectorCollection = EmpElectronicContractUtilsEx.getContractBillMiddleSelectorCollection();
        view.setSelector(selectorCollection);
        logger.error("EmpElectronicContractUtilsEx.getContractBillMiddleInfoById  view : " + Base64Utils.encode((String)view.toString()));
        ContractBillMiddleCollection contractBillMiddleCollection = ContractBillMiddleFactory.getLocalInstance(ctx).getContractBillMiddleCollection(view);
        if (contractBillMiddleCollection != null && contractBillMiddleCollection.size() > 0) {
            contractBillMiddleInfo = contractBillMiddleCollection.get(0);
        }
        return contractBillMiddleInfo;
    }

    public static Timestamp getCurTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static void checkEmpEleContractStatus(Context ctx, EmpEleContractSignRecordInfo empEleContractSignRecordInfo) throws BOSException, EASBizException {
        int signStatusValue;
        EContractSignState signStatus = empEleContractSignRecordInfo.getSignStatus();
        int n = signStatusValue = signStatus != null ? signStatus.getValue() : -999;
        if (signStatus != null && signStatusValue != 1) {
            throw new EmpEleContractException(EmpEleContractException.ELECTRONIC_CONTRACT_SIGNING_STATUS_IS_NOT_SIGNING, new Object[]{signStatus.getAlias()});
        }
        if (signStatusValue == -999) {
            throw new EmpEleContractException(EmpEleContractException.ELECTRONIC_CONTRACT_SIGNING_STATUS_IS_NULL);
        }
    }

    public static void checkEmployeeContractContractClassify(Context ctx, String contractId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)contractId));
        view.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("contractClassify"));
        view.setSelector(selector);
        EmployeeContractCollection employeeContractCollection = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractCollection(view);
        EmployeeContractInfo employeeContractInfo = null;
        if (employeeContractCollection != null && employeeContractCollection.size() > 0) {
            employeeContractInfo = employeeContractCollection.get(0);
        }
        if (employeeContractInfo == null || employeeContractInfo.getContractClassify() == null) {
            if (employeeContractInfo != null) {
                logger.error("EmpElectronicContractUtilsEx.checkEmployeeContractContractClassify  employeeContractInfo : " + employeeContractInfo.getId() + " contractClassify() : " + employeeContractInfo.getContractClassify());
            } else {
                logger.error("EmpElectronicContractUtilsEx.checkEmployeeContractContractClassify  employeeContractInfo is null ");
            }
            throw new EmpEleContractException(EmpEleContractException.GET_EMPLOYEE_IS_NULL_BY_CONTRACTID, new Object[]{contractId});
        }
        if (1 == employeeContractInfo.getContractClassify().getValue()) {
            throw new EmpEleContractException(EmpEleContractException.BATCHABANDONCONTRACT_FAIL_FOR_SSC_CONTRACT);
        }
    }

    private static void checkHRCloudLincense(Context ctx, String eContractNo, Map<String, String> serverMap) throws EASBizException {
        String serviceId = serverMap.get("service_id");
        CheckHRCloudLicenseUtils.checkLicenseCount((Context)ctx, (String)serviceId, (String)"8", (String)eContractNo);
    }

    public static void updateEmployeeContractSignStatus(Context ctx, String contractId, EContractSignState signState) throws BOSException, EASBizException {
        IEmployeeContract employeeContractLocalInstance = EmployeeContractFactory.getLocalInstance((Context)ctx);
        EmployeeContractInfo employeeContractInfo = employeeContractLocalInstance.getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(contractId));
        employeeContractInfo.setSignStatus(signState);
        if (2 == signState.getValue()) {
            employeeContractInfo.setIsElectronicSign(true);
        }
        if (5 == signState.getValue()) {
            employeeContractInfo.setIsElectronicSign(false);
        }
        employeeContractInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
        employeeContractInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("signStatus"));
        if (2 == signState.getValue() || 5 == signState.getValue()) {
            selector.add(new SelectorItemInfo("isElectronicSign"));
        }
        selector.add(new SelectorItemInfo("lastUpdateTime"));
        selector.add(new SelectorItemInfo("lastUpdateUser"));
        logger.error("EmpElectronicContractUtilsEx.updateEmployeeContractSignStatus signState : " + (Object)((Object)signState));
        employeeContractLocalInstance.updatePartial((CoreBaseInfo)employeeContractInfo, selector);
    }

    public static void updateEmployeeSignRecordSignStatus(Context ctx, IEmpEleContractSignRecord signRecordLocalInstance, EmpEleContractSignRecordInfo signRecordInfo, EContractSignState signState) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        signRecordInfo.setSignStatus(signState);
        signRecordInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
        signRecordInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
        selector.add(new SelectorItemInfo("lastUpdateTime"));
        selector.add(new SelectorItemInfo("lastUpdateUser"));
        selector.add(new SelectorItemInfo("signStatus"));
        logger.error("EmpElectronicContractUtilsEx.updateEmployeeContractSignStatus signState : " + (Object)((Object)signState));
        signRecordLocalInstance.updatePartial(signRecordInfo, selector);
    }

    public static void updateContractPreNewSignBizBillEntrySignStatus(Context ctx, EmpEleContractSignRecordInfo empEleContractSignRecordInfo, EContractSignState signState) throws EASBizException, BOSException {
        if (empEleContractSignRecordInfo.getPreEntryPerson() != null) {
            IContractPreNewSignBizBillEntry contractPreNewSignBizBillEntryLocalInstance = ContractPreNewSignBizBillEntryFactory.getLocalInstance(ctx);
            String preEnrtryPersonId = empEleContractSignRecordInfo.getPreEntryPerson().getId().toString();
            ContractPreNewSignBizBillEntryInfo contractPreNewSignBizBillEntryInfo = null;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("preEntryPerson.id", (Object)preEnrtryPersonId));
            filterInfo.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)HRBillStateEnum.AUDITED));
            view.setFilter(filterInfo);
            logger.error("EmpElectronicContractUtilsEx.updateContractPreNewSignBizBillEntrySignStatus view : " + Base64Utils.encode((String)view.toString()));
            ContractPreNewSignBizBillEntryCollection contractPreNewSignBizBillEntryCollection = contractPreNewSignBizBillEntryLocalInstance.getContractPreNewSignBizBillEntryCollection(view);
            if (contractPreNewSignBizBillEntryCollection != null && contractPreNewSignBizBillEntryCollection.size() > 0) {
                contractPreNewSignBizBillEntryInfo = contractPreNewSignBizBillEntryCollection.get(0);
            }
            if (contractPreNewSignBizBillEntryInfo != null) {
                logger.error("EmpElectronicContractUtilsEx.updateContractPreNewSignBizBillEntrySignStatus contractPreNewSignBizBillEntryInfo : " + contractPreNewSignBizBillEntryInfo.getId());
            } else {
                logger.error("EmpElectronicContractUtilsEx.updateContractPreNewSignBizBillEntrySignStatus contractPreNewSignBizBillEntryInfo is null ");
            }
            if (contractPreNewSignBizBillEntryInfo != null) {
                contractPreNewSignBizBillEntryInfo.setSignState(signState);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("signState"));
                contractPreNewSignBizBillEntryLocalInstance.updatePartial((CoreBaseInfo)contractPreNewSignBizBillEntryInfo, selector);
            }
        }
    }

    public static void ProcessingSucceededOrFailed(BatchMessageTipsBody body, HashMap<String, Integer> hashMap) {
        if (body.isMuitTipsState()) {
            int success = hashMap.get("success");
            hashMap.put("success", ++success);
        } else {
            int failure = hashMap.get("failure");
            hashMap.put("failure", ++failure);
        }
    }

    public static void deleteEmpEleContractSignRecordInfo(IEmpEleContractSignRecord contractSignRecordInstance, String contractId) throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)contractId)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("contract.id", (Object)contractId));
            contractSignRecordInstance.delete(filter);
        }
    }

    public static void deleteContractBillMiddleInfo(Context ctx, String contractId) throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)contractId)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("contractId", (Object)contractId));
            ContractBillMiddleFactory.getLocalInstance(ctx).delete(filter);
        }
    }

    public static void deleteEmpEleContractSHRAttachmentExt(Context ctx, String contractId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boId", (Object)contractId));
        view.setFilter(filterInfo);
        logger.error("EmpElectronicContractUtilsEx.deleteEmpEleContractSHRAttachmentExt view : " + Base64Utils.encode((String)view.toString()));
        IEContractSyncFileRecord eContractSyncFileRecordLocalInstance = EContractSyncFileRecordFactory.getLocalInstance((Context)ctx);
        EContractSyncFileRecordCollection eContractSyncFileRecordCollection = eContractSyncFileRecordLocalInstance.getEContractSyncFileRecordCollection(view);
        logger.error("EmpElectronicContractUtilsEx.deleteEmpEleContractSHRAttachmentExt eContractSyncFileRecordCollection : " + eContractSyncFileRecordCollection.size());
        if (eContractSyncFileRecordCollection != null && eContractSyncFileRecordCollection.size() > 0) {
            for (int i = 0; i < eContractSyncFileRecordCollection.size(); ++i) {
                EContractSyncFileRecordInfo eContractSyncFileRecordInfo = eContractSyncFileRecordCollection.get(i);
                BOSUuid attachmentId = eContractSyncFileRecordInfo.getAttachmentId();
                String eContractSyncFileRecordId = eContractSyncFileRecordInfo.getId().toString();
                EmpElectronicContractUtilsEx.deleteEContractSyncFileRecordInfo(eContractSyncFileRecordLocalInstance, eContractSyncFileRecordId);
                EmpElectronicContractUtilsEx.deleteAttachmentInfo(ctx, attachmentId);
            }
        }
    }

    public static void deleteEContractSyncFileRecordInfo(IEContractSyncFileRecord eContractSyncFileRecordLocalInstance, String eContractSyncFileRecordId) throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)eContractSyncFileRecordId)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eContractSyncFileRecordId));
            logger.error("EmpElectronicContractUtilsEx.deleteEContractSyncFileRecordInfo filter : " + filter);
            eContractSyncFileRecordLocalInstance.delete(filter);
        }
    }

    public static void deleteAttachmentInfo(Context ctx, BOSUuid attachmentId) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("attachment", (Object)attachmentId));
        ISHRAttachmentExt ishrAttachmentExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
        IBoAttchAsso iBoAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
        logger.error("EmpElectronicContractUtilsEx.deleteAttachmentInfo filterInfo : " + filterInfo);
        if (attachmentId != null) {
            ishrAttachmentExt.delete(filterInfo);
            iBoAttchAsso.delete(filterInfo);
            AttachmentFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(attachmentId.toString()));
        }
    }

    public static SelectorItemCollection getSelectorCollection() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("employee.id"));
        selector.add(new SelectorItemInfo("employee.name"));
        selector.add(new SelectorItemInfo("employee.number"));
        selector.add(new SelectorItemInfo("employee.idCardNO"));
        selector.add(new SelectorItemInfo("employee.nCell"));
        selector.add(new SelectorItemInfo("contractTemplet.id"));
        selector.add(new SelectorItemInfo("contractTemplet.name"));
        selector.add(new SelectorItemInfo("contractTemplet.number"));
        selector.add(new SelectorItemInfo("contractTemplet.isElectronicSign"));
        selector.add(new SelectorItemInfo("contractTemplet.contractType.id"));
        selector.add(new SelectorItemInfo("contractTemplet.contractType.name"));
        selector.add(new SelectorItemInfo("contractTemplet.contractType.isLaborContract"));
        selector.add(new SelectorItemInfo("contractTemplet.contractType.isRenewWarn"));
        selector.add(new SelectorItemInfo("labContractFirstParty.id"));
        selector.add(new SelectorItemInfo("labContractFirstParty.name"));
        selector.add(new SelectorItemInfo("labContractFirstParty.number"));
        selector.add(new SelectorItemInfo("hrOrgUnit.id"));
        selector.add(new SelectorItemInfo("hrOrgUnit.name"));
        selector.add(new SelectorItemInfo("hrOrgUnit.number"));
        selector.add(new SelectorItemInfo("ContractLimit.id"));
        selector.add(new SelectorItemInfo("ContractLimit.name"));
        selector.add(new SelectorItemInfo("ContractLimit.number"));
        selector.add(new SelectorItemInfo("ContSerLimit.id"));
        selector.add(new SelectorItemInfo("ContSerLimit.name"));
        selector.add(new SelectorItemInfo("ContSerLimit.number"));
        selector.add(new SelectorItemInfo("sourceContract.id"));
        selector.add(new SelectorItemInfo("sourceContract.name"));
        selector.add(new SelectorItemInfo("sourceContract.number"));
        selector.add(new SelectorItemInfo("partyUnitsItem.id"));
        selector.add(new SelectorItemInfo("partyUnitsItem.name"));
        selector.add(new SelectorItemInfo("partyUnitsItem.number"));
        selector.add(new SelectorItemInfo("adminOrg.id"));
        selector.add(new SelectorItemInfo("adminOrg.name"));
        selector.add(new SelectorItemInfo("adminOrg.number"));
        selector.add(new SelectorItemInfo("preEntryPerson.id"));
        selector.add(new SelectorItemInfo("preEntryPerson.name"));
        selector.add(new SelectorItemInfo("preEntryPerson.number"));
        return selector;
    }

    public static SelectorItemCollection getPersonSelectorCollection() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("idCardNO"));
        selector.add(new SelectorItemInfo("passportNO"));
        selector.add(new SelectorItemInfo("nCell"));
        return selector;
    }

    public static SelectorItemCollection getEmpEleContractSignRecordSelectorCollection() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("eContractNO"));
        selector.add(new SelectorItemInfo("isCreate"));
        selector.add(new SelectorItemInfo("isPersonSign"));
        selector.add(new SelectorItemInfo("isCompanySign"));
        selector.add(new SelectorItemInfo("contract.id"));
        selector.add(new SelectorItemInfo("contract.contractClassify"));
        selector.add(new SelectorItemInfo("contract.contractTemplet.id"));
        selector.add(new SelectorItemInfo("contract.contractTemplet.isElectronicSign"));
        return selector;
    }

    public static SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add(new SelectorItemInfo("*"));
        selectorColl.add(new SelectorItemInfo("talent.id"));
        selectorColl.add(new SelectorItemInfo("talent.name"));
        selectorColl.add(new SelectorItemInfo("talent.number"));
        selectorColl.add(new SelectorItemInfo("talent.idCardNO"));
        selectorColl.add(new SelectorItemInfo("talent.passportNO"));
        selectorColl.add(new SelectorItemInfo("talent.addressTX"));
        selectorColl.add(new SelectorItemInfo("position.id"));
        selectorColl.add(new SelectorItemInfo("position.name"));
        selectorColl.add(new SelectorItemInfo("position.number"));
        selectorColl.add(new SelectorItemInfo("adminOrg.id"));
        selectorColl.add(new SelectorItemInfo("adminOrg.name"));
        selectorColl.add(new SelectorItemInfo("adminOrg.number"));
        selectorColl.add(new SelectorItemInfo("adminOrg.displayName"));
        selectorColl.add(new SelectorItemInfo("adminOrg.company.id"));
        selectorColl.add(new SelectorItemInfo("adminOrg.company.name"));
        selectorColl.add(new SelectorItemInfo("adminOrg.company.number"));
        selectorColl.add(new SelectorItemInfo("adminOrg.company.displayName"));
        selectorColl.add(new SelectorItemInfo("adminOrg.department.id"));
        selectorColl.add(new SelectorItemInfo("adminOrg.department.name"));
        selectorColl.add(new SelectorItemInfo("adminOrg.department.number"));
        selectorColl.add(new SelectorItemInfo("adminOrg.department.displayName"));
        selectorColl.add(new SelectorItemInfo("hrOrgUnit.id"));
        selectorColl.add(new SelectorItemInfo("hrOrgUnit.name"));
        selectorColl.add(new SelectorItemInfo("hrOrgUnit.number"));
        selectorColl.add(new SelectorItemInfo("hrOrgUnit.displayName"));
        return selectorColl;
    }

    public static SelectorItemCollection getContractBillMiddleSelectorCollection() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("auditor.id"));
        selector.add(new SelectorItemInfo("auditor.name"));
        selector.add(new SelectorItemInfo("auditor.number"));
        selector.add(new SelectorItemInfo("handler.id"));
        selector.add(new SelectorItemInfo("handler.name"));
        selector.add(new SelectorItemInfo("handler.number"));
        selector.add(new SelectorItemInfo("billAdminOrg.id"));
        selector.add(new SelectorItemInfo("billAdminOrg.name"));
        selector.add(new SelectorItemInfo("billAdminOrg.number"));
        selector.add(new SelectorItemInfo("hrOrgUnit.id"));
        selector.add(new SelectorItemInfo("hrOrgUnit.name"));
        selector.add(new SelectorItemInfo("hrOrgUnit.number"));
        selector.add(new SelectorItemInfo("adminOrg.id"));
        selector.add(new SelectorItemInfo("adminOrg.name"));
        selector.add(new SelectorItemInfo("adminOrg.number"));
        selector.add(new SelectorItemInfo("position.id"));
        selector.add(new SelectorItemInfo("position.name"));
        selector.add(new SelectorItemInfo("position.number"));
        selector.add(new SelectorItemInfo("ContractServerLimit.id"));
        selector.add(new SelectorItemInfo("ContractServerLimit.name"));
        selector.add(new SelectorItemInfo("ContractServerLimit.number"));
        selector.add(new SelectorItemInfo("contractType.id"));
        selector.add(new SelectorItemInfo("contractType.name"));
        selector.add(new SelectorItemInfo("contractType.number"));
        selector.add(new SelectorItemInfo("contractTemplet.id"));
        selector.add(new SelectorItemInfo("contractTemplet.name"));
        selector.add(new SelectorItemInfo("contractTemplet.number"));
        selector.add(new SelectorItemInfo("contractTemplet.isElectronicSign"));
        selector.add(new SelectorItemInfo("contractTemplet.signType"));
        selector.add(new SelectorItemInfo("applier.id"));
        selector.add(new SelectorItemInfo("applier.name"));
        selector.add(new SelectorItemInfo("applier.number"));
        selector.add(new SelectorItemInfo("delegatePerson.id"));
        selector.add(new SelectorItemInfo("delegatePerson.name"));
        selector.add(new SelectorItemInfo("delegatePerson.number"));
        selector.add(new SelectorItemInfo("labContractFirstParty.id"));
        selector.add(new SelectorItemInfo("labContractFirstParty.name"));
        selector.add(new SelectorItemInfo("labContractFirstParty.number"));
        selector.add(new SelectorItemInfo("person.id"));
        selector.add(new SelectorItemInfo("person.name"));
        selector.add(new SelectorItemInfo("person.number"));
        selector.add(new SelectorItemInfo("person.idCardNO"));
        selector.add(new SelectorItemInfo("person.nCell"));
        selector.add(new SelectorItemInfo("person.idCardAddress"));
        selector.add(new SelectorItemInfo("preEntryPerson.id"));
        selector.add(new SelectorItemInfo("preEntryPerson.name"));
        selector.add(new SelectorItemInfo("preEntryPerson.number"));
        selector.add(new SelectorItemInfo("preEntryPerson.idCardAddress"));
        selector.add(new SelectorItemInfo("sourceContract.id"));
        selector.add(new SelectorItemInfo("sourceContract.name"));
        selector.add(new SelectorItemInfo("sourceContract.number"));
        return selector;
    }
}

