/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.elecontract.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.util.ShrEmpNaturalMonthUtil;
import com.kingdee.eas.hr.contract.ContractBillMiddleFactory;
import com.kingdee.eas.hr.contract.ContractBillMiddleInfo;
import com.kingdee.eas.hr.contract.ContractPreNewSignBizBillInfo;
import com.kingdee.eas.hr.contract.EContractSignState;
import com.kingdee.eas.hr.contract.EmpEleContractCompanyTaskCollection;
import com.kingdee.eas.hr.contract.EmpEleContractCompanyTaskFactory;
import com.kingdee.eas.hr.contract.EmpEleContractCompanyTaskInfo;
import com.kingdee.eas.hr.contract.EmpEleContractDelLogFactory;
import com.kingdee.eas.hr.contract.EmpEleContractException;
import com.kingdee.eas.hr.contract.EmpOtherEleContractSendMessageFacadeFactory;
import com.kingdee.eas.hr.contract.EmpOtherEleContractServiceFacadeFactory;
import com.kingdee.eas.hr.contract.EmpOtherEleContractSignRecordCollection;
import com.kingdee.eas.hr.contract.EmpOtherEleContractSignRecordFactory;
import com.kingdee.eas.hr.contract.EmpOtherEleContractSignRecordInfo;
import com.kingdee.eas.hr.contract.EmpOtherEleContractTaskFacadeFactory;
import com.kingdee.eas.hr.contract.EmpTaskMessageLogInfo;
import com.kingdee.eas.hr.contract.IContractBillMiddle;
import com.kingdee.eas.hr.contract.IEmpEleContractDelLog;
import com.kingdee.eas.hr.contract.IEmpOtherEleContractServiceFacade;
import com.kingdee.eas.hr.contract.IEmpOtherEleContractSignRecord;
import com.kingdee.eas.hr.contract.IEmpOtherEleContractTaskFacade;
import com.kingdee.eas.hr.contract.IOtherFollowPreNewConEntry;
import com.kingdee.eas.hr.contract.ISHRElectronicTemplate;
import com.kingdee.eas.hr.contract.OtherFollowPreNewConEntryFactory;
import com.kingdee.eas.hr.contract.OtherFollowPreNewConEntryInfo;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateCollection;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateFactory;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateInfo;
import com.kingdee.eas.hr.contract.util.BoAttchAssoBillUtils;
import com.kingdee.eas.hr.elecontract.util.EmpEleContractFollowUtils;
import com.kingdee.eas.hr.elecontract.util.EmpElectronicContractUtilsEx;
import com.kingdee.eas.hr.elecontract.util.EmpElectronicOtherContractUtilsEx;
import com.kingdee.eas.hr.emp.ContractClassifyEnum;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.EmployeeOtherContractCollection;
import com.kingdee.eas.hr.emp.EmployeeOtherContractFactory;
import com.kingdee.eas.hr.emp.EmployeeOtherContractInfo;
import com.kingdee.eas.hr.emp.IEmployeeOtherContract;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.eas.hr.emp.SignTypeEnum;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.elecontract.IKDContractConfigRecord;
import com.kingdee.shr.elecontract.KDContractConfigAuthRecordFactory;
import com.kingdee.shr.elecontract.KDContractConfigCollection;
import com.kingdee.shr.elecontract.KDContractConfigFactory;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.KDContractConfigRecordCollection;
import com.kingdee.shr.elecontract.KDContractConfigRecordFactory;
import com.kingdee.shr.elecontract.KDContractConfigRecordInfo;
import com.kingdee.shr.elecontract.SSCPersonAuthResult;
import com.kingdee.shr.elecontract.app.KDContractServiceStatus;
import com.kingdee.shr.elecontract.util.CheckHRCloudLicenseUtils;
import com.kingdee.shr.elecontract.util.ContactBillMiddleUtils;
import com.kingdee.shr.elecontract.util.ElectronicContractUtils;
import com.kingdee.shr.elecontract.util.TSPServerInstance;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.preentry.PreEntryInfo;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmpElectronicOtherContractUtils {
    public static final Logger logger = LoggerFactory.getLogger(EmpElectronicOtherContractUtils.class);
    public static final String LAB_PARTYA = "partA";
    public static final String LAB_PARTYB = "partB";

    public static Map<String, Object> getViewEContract(Context ctx, String recordId, String contractId, Map<String, Object> params) throws EASBizException, BOSException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        EmpOtherEleContractSignRecordInfo signRecordInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)recordId));
        filter.getFilterItems().add(new FilterItemInfo("contract.id", (Object)contractId));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("contractNO"));
        selector.add(new SelectorItemInfo("eContractNO"));
        selector.add(new SelectorItemInfo("isCreate"));
        selector.add(new SelectorItemInfo("hasFileCallback"));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(selector);
        IEmpOtherEleContractSignRecord otherContractSignRecordInstance = EmpOtherEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpOtherEleContractSignRecordCollection signRecordCollection = otherContractSignRecordInstance.getEmpOtherEleContractSignRecordCollection(viewInfo);
        if (signRecordCollection.size() > 0) {
            signRecordInfo = signRecordCollection.get(0);
        }
        if (signRecordInfo != null && signRecordInfo.isIsCreate() && signRecordInfo.isHasFileCallback()) {
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("billId", signRecordInfo.getId().toString());
            dataMap.put("contractId", contractId);
            dataMap.put("contractNo", signRecordInfo.getContractNO());
            dataMap.put("isDefault", "1");
            IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
            Map result = (Map)osfServiceFacade.processService("empPreViewEContractV2Service", dataMap);
            return result;
        }
        data.put("isSuccess", false);
        return data;
    }

    public static Map<String, Object> preViewEContract(Context ctx, String recordId, String contractId, boolean isRequireNew, Map<String, Object> params) throws EASBizException, BOSException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        IEmployeeOtherContract employeeContractLocalInstance = EmployeeOtherContractFactory.getLocalInstance((Context)ctx);
        EmployeeOtherContractInfo empOtherContractInfo = EmpElectronicOtherContractUtilsEx.getEmployeeOtherContractInfo(employeeContractLocalInstance, contractId);
        ContractTempletInfo contractTemplet = empOtherContractInfo.getContractTemplet();
        if (!contractTemplet.isIsElectronicSign() || empOtherContractInfo.getContractClassify() != null && empOtherContractInfo.getContractClassify().getValue() == 0) {
            throw new EmpEleContractException(EmpEleContractException.BATCHEMPLOYEESIGN_IS_FAIL_FOR_CONTRACTTEMPLET);
        }
        boolean isContinue = true;
        String eContractNo = "";
        if (ContractClassifyEnum.ElectronicSsc.equals((Object)empOtherContractInfo.getContractClassify())) {
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("billId", empOtherContractInfo.getId().toString());
            dataMap.put("contractNo", empOtherContractInfo.getContractNo());
            dataMap.put("isDefault", "999");
            IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
            Map result = (Map)osfServiceFacade.processService("sSCPreViewEContractV2Service", dataMap);
            isContinue = false;
            return result;
        }
        IEmpOtherEleContractSignRecord otherContractSignRecordInstance = EmpOtherEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpOtherEleContractSignRecordInfo signRecordInfo = null;
        signRecordInfo = StringUtils.isEmpty((String)recordId) ? EmpElectronicOtherContractUtilsEx.getOtherEmpEleContractSignRecordInfo(otherContractSignRecordInstance, empOtherContractInfo.getId().toString()) : otherContractSignRecordInstance.getEmpOtherEleContractSignRecordInfo((IObjectPK)new ObjectUuidPK(recordId));
        boolean isNeedSave = false;
        boolean isNeedAdd = false;
        boolean isNeedUpdate = false;
        SelectorItemCollection selector = new SelectorItemCollection();
        if (signRecordInfo != null) {
            EContractSignState signStatus = signRecordInfo.getSignStatus();
            if (isRequireNew && (signStatus.equals((Object)EContractSignState.employeesignover) || signStatus.equals((Object)EContractSignState.enterprisesignover) || signStatus.equals((Object)EContractSignState.abandon))) {
                if (!signRecordInfo.isIsInvalid()) {
                    signRecordInfo.setIsInvalid(true);
                    SelectorItemCollection selector1 = new SelectorItemCollection();
                    selector1.add(new SelectorItemInfo("isInvalid"));
                    otherContractSignRecordInstance.updatePartial(signRecordInfo, selector1);
                }
                isNeedAdd = true;
            } else if (signStatus.equals((Object)EContractSignState.uninitiated)) {
                signRecordInfo.setIsCreate(false);
                signRecordInfo.setEcreateTime(null);
                selector.add(new SelectorItemInfo("isCreate"));
                selector.add(new SelectorItemInfo("ecreateTime"));
                isNeedUpdate = true;
                eContractNo = signRecordInfo.getEContractNO();
            } else if (signStatus.equals((Object)EContractSignState.nosign) || signStatus.equals((Object)EContractSignState.signing) || signStatus.equals((Object)EContractSignState.partyASigned) || signStatus.equals((Object)EContractSignState.complete) || signStatus.equals((Object)EContractSignState.employeesignover) || signStatus.equals((Object)EContractSignState.enterprisesignover) || signRecordInfo.isIsPersonSign() || signRecordInfo.isIsSecondPartySign() || signRecordInfo.isIsFirstPartySign()) {
                HashMap<String, String> dataMap = new HashMap<String, String>();
                dataMap.put("billId", signRecordInfo.getId().toString());
                dataMap.put("contractId", empOtherContractInfo.getId().toString());
                dataMap.put("contractNo", empOtherContractInfo.getContractNo());
                dataMap.put("isDefault", "1");
                IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
                Map result = (Map)osfServiceFacade.processService("empPreViewEContractV2Service", dataMap);
                isContinue = false;
                return result;
            }
        }
        if (signRecordInfo == null || isNeedAdd) {
            String contractNo = empOtherContractInfo.getContractNo();
            PersonInfo personInfo = empOtherContractInfo.getEmployee();
            PreEntryPersonInfo preEntryPersonInfo = empOtherContractInfo.getPreEntryPerson();
            signRecordInfo = new EmpOtherEleContractSignRecordInfo();
            LabContractFirstPartyInfo labContractFirstParty = empOtherContractInfo.getLabContractFirstParty();
            KDContractConfigInfo kdContractConfigInfo = EmpElectronicContractUtilsEx.getKDContractConfigByLabContractFirstParty(ctx, labContractFirstParty.getId().toString());
            eContractNo = EmpElectronicOtherContractUtils.getEContractNumber(ctx, otherContractSignRecordInstance, kdContractConfigInfo, contractNo);
            signRecordInfo.setPerson(personInfo);
            signRecordInfo.setPreEntryPerson(preEntryPersonInfo);
            signRecordInfo.setContract(empOtherContractInfo);
            signRecordInfo.setContractNO(empOtherContractInfo.getContractNo());
            signRecordInfo.setEContractNO(eContractNo);
            signRecordInfo.setSignStatus(EContractSignState.uninitiated);
            signRecordInfo.setKdContractConfig(kdContractConfigInfo);
            signRecordInfo.setIsInvalid(false);
            isNeedSave = true;
        }
        if (!isContinue) {
            return data;
        }
        empOtherContractInfo.setSignType(empOtherContractInfo.getContractTemplet().getSignType());
        SignTypeEnum sSignType = empOtherContractInfo.getContractTemplet().getSignType();
        if (sSignType != null) {
            logger.error("EmpElectronicOtherContractUtilsEx  update EmployeeOtherContract  signState : " + sSignType.toString() + "====contractId=" + contractId);
        } else {
            logger.error("EmpElectronicOtherContractUtilsEx  update EmployeeOtherContract  signState  is null ====contractId=" + contractId);
        }
        EmpElectronicOtherContractUtilsEx.verifyOtherContractIsFreeOrEnd(ctx, empOtherContractInfo);
        if (isNeedSave) {
            IObjectPK pk = otherContractSignRecordInstance.save((CoreBaseInfo)signRecordInfo);
            signRecordInfo.setId(BOSUuid.read((String)pk.toString()));
        }
        if (isNeedUpdate) {
            otherContractSignRecordInstance.updatePartial(signRecordInfo, selector);
        }
        BoAttchAssoBillUtils.deleteBoAttchAssoBill(ctx, eContractNo, null);
        EmpElectronicOtherContractUtilsEx.copyAndSaveEmployeeContractToMiddle(ctx, empOtherContractInfo);
        SHRElectronicTemplateInfo shrElectronicTemplateInfo = EmpElectronicOtherContractUtilsEx.getSHRElectronicTemplateInfoByEmployeeContract(ctx, empOtherContractInfo);
        String csTemplateId = shrElectronicTemplateInfo.getCsTemplateId();
        boolean isCsTemplate = StringUtils.isEmpty((String)csTemplateId);
        if (!signRecordInfo.isIsCreate() && isCsTemplate) {
            logger.error("EmpElectronicOtherContractUtilsEx.batchEmployeeSign isCsTemplate : " + isCsTemplate + " \u65e7\u6a21\u677f\u751f\u6210\u7535\u5b50\u5408\u540c");
            EmpOtherEleContractServiceFacadeFactory.getLocalInstance(ctx).createEContract(signRecordInfo, empOtherContractInfo, shrElectronicTemplateInfo, new HashMap());
        } else if (!signRecordInfo.isIsCreate()) {
            logger.error("EmpElectronicOtherContractUtilsEx.batchEmployeeSign isCsTemplate : " + isCsTemplate + " \u65b0\u6a21\u677f\u751f\u6210\u7535\u5b50\u5408\u540c");
            EmpOtherEleContractServiceFacadeFactory.getLocalInstance(ctx).createEContractForNewTemplate(signRecordInfo, empOtherContractInfo, shrElectronicTemplateInfo, new HashMap());
        }
        data.put("contractId", contractId);
        data.put("recordId", signRecordInfo.getId().toString());
        data.put("eContractNo", signRecordInfo.getEContractNO());
        data.put("isWaiting", true);
        return data;
    }

    public static void checkEmpEleContractSignRecordSignStatus(String signStatus, String operation, Boolean batchAgain) throws EmpEleContractException {
        int signStatusValue;
        if (!(StringUtils.isEmpty((String)signStatus) || 3 != (signStatusValue = Integer.parseInt(signStatus)) && 4 != signStatusValue && 5 != signStatusValue)) {
            String alias = "";
            switch (signStatusValue) {
                case 3: {
                    alias = EContractSignState.employeesignover.getAlias();
                    break;
                }
                case 4: {
                    alias = EContractSignState.enterprisesignover.getAlias();
                    break;
                }
                case 5: {
                    alias = EContractSignState.abandon.getAlias();
                    break;
                }
                default: {
                    alias = "";
                }
            }
            if (batchAgain.booleanValue()) {
                return;
            }
            throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_CANNOT_BATCH_OPERATE_AGAIN, new Object[]{alias, operation});
        }
    }

    public static EmployeeOtherContractInfo getEmployeeOtherContractInfo(IEmployeeOtherContract employeeContractLocalInstance, String contractId) throws EASBizException, BOSException {
        EmployeeOtherContractInfo empContractInfo = employeeContractLocalInstance.getEmployeeOtherContractInfo((IObjectPK)new ObjectUuidPK(contractId), EmpElectronicOtherContractUtilsEx.getSelectorCollection());
        return empContractInfo;
    }

    public static EmployeeOtherContractInfo getEmpOtherContractByContractNo(Context ctx, String contractNo) throws EASBizException, BOSException {
        EmployeeOtherContractInfo employeeOtherContractInfo = new EmployeeOtherContractInfo();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("contractNo", (Object)contractNo));
        view.setFilter(filterInfo);
        SelectorItemCollection selectorCollection = EmpElectronicContractUtilsEx.getSelectorCollection();
        view.setSelector(selectorCollection);
        EmployeeOtherContractCollection employeeOtherContractCollection = EmployeeOtherContractFactory.getLocalInstance((Context)ctx).getEmployeeOtherContractCollection(view);
        if (employeeOtherContractCollection != null && employeeOtherContractCollection.size() == 1) {
            employeeOtherContractInfo = employeeOtherContractCollection.get(0);
        } else {
            if (employeeOtherContractCollection == null || employeeOtherContractCollection.size() == 0) {
                throw new EmpEleContractException(EmpEleContractException.GET_EMPLOYEE_IS_NULL_BY_CONTRACTNO, new Object[]{contractNo});
            }
            if (employeeOtherContractCollection != null && employeeOtherContractCollection.size() > 1) {
                throw new EmpEleContractException(EmpEleContractException.GET_EMPLOYEE_IS_MORE_BY_CONTRACTNO, new Object[]{contractNo});
            }
        }
        return employeeOtherContractInfo;
    }

    public static SelectorItemCollection getSelectorCollection() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("employee.id"));
        selector.add(new SelectorItemInfo("employee.name"));
        selector.add(new SelectorItemInfo("employee.number"));
        selector.add(new SelectorItemInfo("employee.idCardNO"));
        selector.add(new SelectorItemInfo("employee.nCell"));
        selector.add(new SelectorItemInfo("contractTemplet.id"));
        selector.add(new SelectorItemInfo("contractTemplet.name"));
        selector.add(new SelectorItemInfo("contractTemplet.number"));
        selector.add(new SelectorItemInfo("contractTemplet.signType"));
        selector.add(new SelectorItemInfo("contractTemplet.isElectronicSign"));
        selector.add(new SelectorItemInfo("contractTemplet.contractType.id"));
        selector.add(new SelectorItemInfo("contractTemplet.contractType.name"));
        selector.add(new SelectorItemInfo("contractTemplet.contractType.isLaborContract"));
        selector.add(new SelectorItemInfo("contractTemplet.contractType.isRenewWarn"));
        selector.add(new SelectorItemInfo("labContractFirstParty.id"));
        selector.add(new SelectorItemInfo("labContractFirstParty.name"));
        selector.add(new SelectorItemInfo("labContractFirstParty.number"));
        selector.add(new SelectorItemInfo("hrOrgUnit.id"));
        selector.add(new SelectorItemInfo("hrOrgUnit.name"));
        selector.add(new SelectorItemInfo("hrOrgUnit.number"));
        selector.add(new SelectorItemInfo("ContractLimit.id"));
        selector.add(new SelectorItemInfo("ContractLimit.name"));
        selector.add(new SelectorItemInfo("ContractLimit.number"));
        selector.add(new SelectorItemInfo("ContSerLimit.id"));
        selector.add(new SelectorItemInfo("ContSerLimit.name"));
        selector.add(new SelectorItemInfo("ContSerLimit.number"));
        selector.add(new SelectorItemInfo("sourceContract.id"));
        selector.add(new SelectorItemInfo("sourceContract.name"));
        selector.add(new SelectorItemInfo("sourceContract.number"));
        selector.add(new SelectorItemInfo("partyUnitsItem.id"));
        selector.add(new SelectorItemInfo("partyUnitsItem.name"));
        selector.add(new SelectorItemInfo("partyUnitsItem.number"));
        selector.add(new SelectorItemInfo("adminOrg.id"));
        selector.add(new SelectorItemInfo("adminOrg.name"));
        selector.add(new SelectorItemInfo("adminOrg.number"));
        selector.add(new SelectorItemInfo("preEntryPerson.id"));
        selector.add(new SelectorItemInfo("preEntryPerson.name"));
        selector.add(new SelectorItemInfo("preEntryPerson.number"));
        selector.add(new SelectorItemInfo("labContractCParty.id"));
        selector.add(new SelectorItemInfo("labContractCParty.name"));
        selector.add(new SelectorItemInfo("labContractCParty.number"));
        return selector;
    }

    public static void verifyOtherContractIsFreeOrEnd(Context ctx, EmployeeOtherContractInfo employeeContractInfo) throws EmpEleContractException {
        String name = "";
        if (employeeContractInfo.getEmployee() != null) {
            name = employeeContractInfo.getEmployee().getName();
        } else if (employeeContractInfo.getPreEntryPerson() != null) {
            name = employeeContractInfo.getPreEntryPerson().getName();
        }
        if (employeeContractInfo.getState() != null && (employeeContractInfo.getState().getValue() == 5 || employeeContractInfo.getState().getValue() == 4)) {
            String state = employeeContractInfo.getState().getAlias();
            throw new EmpEleContractException(EmpEleContractException.CANNOT_BATCH_EMPLOYEE_SIGN_FOR_STATE, new Object[]{name, employeeContractInfo.getContractNo(), state});
        }
    }

    public static void verifyOtherContractSignStatusAndContractClassify(Context ctx, EmployeeOtherContractInfo employeeContractInfo) throws EmpEleContractException {
        ContractTempletInfo contractTemplet = employeeContractInfo.getContractTemplet();
        if (!contractTemplet.isIsElectronicSign() || employeeContractInfo.getContractClassify() != null && employeeContractInfo.getContractClassify().getValue() == 0) {
            throw new EmpEleContractException(EmpEleContractException.BATCHEMPLOYEESIGN_IS_FAIL_FOR_CONTRACTTEMPLET);
        }
        if (contractTemplet.isIsElectronicSign() && employeeContractInfo.getContractClassify() != null && employeeContractInfo.getContractClassify().getValue() == 1) {
            throw new EmpEleContractException(EmpEleContractException.BATCHEMPLOYEESIGN_IS_FAIL_FOR_FROM_SSC);
        }
        if (employeeContractInfo.getSignStatus() == null) {
            throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_SIGNSTATUS_IS_NULL);
        }
        if (employeeContractInfo.getSignStatus() != null && (employeeContractInfo.getSignStatus().getValue() == 1 || employeeContractInfo.getSignStatus().getValue() == 2 || employeeContractInfo.getSignStatus().getValue() == 6)) {
            throw new EmpEleContractException(EmpEleContractException.CANNOT_BATCH_EMPLOYEE_SIGN);
        }
    }

    private static void checkHRCloudLincense(Context ctx, String eContractNo, Map<String, String> serverMap) throws EASBizException {
        String serviceId = serverMap.get("service_id");
        CheckHRCloudLicenseUtils.checkLicenseCount((Context)ctx, (String)serviceId, (String)"8", (String)eContractNo);
    }

    public static void checkOtherPersonStatus(Context ctx, EmployeeOtherContractInfo employeeContractInfo) throws BOSException, EASBizException {
        PersonInfo personInfo = employeeContractInfo.getEmployee();
        String personId = "";
        if (personInfo != null) {
            personId = personInfo.getId() != null ? personInfo.getId().toString() : "";
        } else if (employeeContractInfo.getPreEntryPerson() != null) {
            PreEntryPersonInfo preEntryPerson = employeeContractInfo.getPreEntryPerson();
            personId = preEntryPerson.getId() != null ? preEntryPerson.getId().toString() : "";
        }
        HashMap<String, String> osfDataMap = new HashMap<String, String>();
        osfDataMap.put("personId", personId);
        IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
        Map osfResult = (Map)osfServiceFacade.processService("checkPersonBeforeSendPersonSignMessageService", osfDataMap);
        if (osfResult == null || osfResult.size() <= 0 || osfResult.get(personId) == null) {
            String label12 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label3", (Context)ctx);
            String realObj = MessageFormat.format(label12, personId);
            throw new BOSException(realObj);
        }
        logger.error("EmpElectronicOtherContractUtilsEx.checkPersonStatus osfResult : " + osfResult);
        Map dataMap = (Map)osfResult.get(personId);
        String idCardNO = (String)dataMap.get("idCardNO");
        String nCell = (String)dataMap.get("nCell");
        String wxOpenId = (String)dataMap.get("wxOpenId");
        String openId = (String)dataMap.get("openId");
        int sendMessageType = (Integer)dataMap.get("sendMessageType");
        StringBuffer msg = new StringBuffer();
        if (StringUtils.isEmpty((String)idCardNO)) {
            msg.append("NO_IDCARD_NO");
        }
        if (StringUtils.isEmpty((String)nCell)) {
            if (msg.length() > 0) {
                msg.append(",").append("NO_CELL");
            } else {
                msg.append("NO_CELL");
            }
        }
        if (1 == sendMessageType && StringUtils.isEmpty((String)openId)) {
            if (msg.length() > 0) {
                msg.append(",").append("NO_OPEN_ID");
            } else {
                msg.append("NO_OPEN_ID");
            }
        }
        if (2 == sendMessageType && StringUtils.isEmpty((String)wxOpenId)) {
            if (msg.length() > 0) {
                msg.append(",").append("NO_WX");
            } else {
                msg.append("NO_WX");
            }
        }
        if (msg.length() > 0) {
            String realObj = EmpElectronicOtherContractUtils.getMsgInfo(ctx, msg.toString());
            throw new BOSException(realObj);
        }
    }

    public static String getMsgInfo(Context ctx, String msg) {
        if ("NO_IDCARD_NO".equals(msg)) {
            String label4 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label4", (Context)ctx);
            return label4;
        }
        if ("NO_IDCARD_NO,NO_CELL".equals(msg)) {
            String label5 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label5", (Context)ctx);
            return label5;
        }
        if ("NO_IDCARD_NO,NO_OPEN_ID".equals(msg)) {
            String label8 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label8", (Context)ctx);
            return label8;
        }
        if ("NO_IDCARD_NO,NO_WX".equals(msg)) {
            String label9 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label9", (Context)ctx);
            return label9;
        }
        if ("NO_IDCARD_NO,NO_CELL,NO_OPEN_ID".equals(msg)) {
            String label10 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label10", (Context)ctx);
            return label10;
        }
        if ("NO_IDCARD_NO,NO_CELL,NO_WX".equals(msg)) {
            String label11 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label11", (Context)ctx);
            return label11;
        }
        if ("NO_CELL".equals(msg)) {
            String label6 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label6", (Context)ctx);
            return label6;
        }
        if ("NO_CELL,NO_OPEN_ID".equals(msg)) {
            String label12 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label12", (Context)ctx);
            return label12;
        }
        if ("NO_CELL,NO_WX".equals(msg)) {
            String label13 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label13", (Context)ctx);
            return label13;
        }
        if ("NO_OPEN_ID".equals(msg)) {
            String label7 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label7", (Context)ctx);
            return label7;
        }
        String label14 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label14", (Context)ctx);
        return label14;
    }

    public static EmpOtherEleContractSignRecordInfo getOtherEmpEleContractSignRecordInfo(IEmpOtherEleContractSignRecord empEleContractSignRecordLocalInstance, String contractId) throws BOSException {
        EmpOtherEleContractSignRecordInfo empEleContractSignRecordInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contract.id", (Object)contractId));
        filter.getFilterItems().add(new FilterItemInfo("isInvalid", (Object)0, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        EmpOtherEleContractSignRecordCollection empEleContractSignRecordCollection = empEleContractSignRecordLocalInstance.getEmpOtherEleContractSignRecordCollection(viewInfo);
        if (empEleContractSignRecordCollection.size() > 0) {
            empEleContractSignRecordInfo = empEleContractSignRecordCollection.get(0);
        }
        return empEleContractSignRecordInfo;
    }

    public static EmpOtherEleContractSignRecordInfo getOtherEmpEleContractSignRecordInfoFromPreEntry(IEmpOtherEleContractSignRecord empEleContractSignRecordLocalInstance, String contractId, SelectorItemCollection selector) throws BOSException {
        EmpOtherEleContractSignRecordInfo empEleContractSignRecordInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contract.id", (Object)contractId));
        viewInfo.setFilter(filter);
        if (selector != null && selector.size() > 0) {
            viewInfo.setSelector(selector);
        }
        SorterItemCollection sorterColls = new SorterItemCollection();
        SorterItemInfo sorter = new SorterItemInfo("createTime");
        sorter.setSortType(SortType.DESCEND);
        sorterColls.add(sorter);
        viewInfo.setSorter(sorterColls);
        EmpOtherEleContractSignRecordCollection empEleContractSignRecordCollection = empEleContractSignRecordLocalInstance.getEmpOtherEleContractSignRecordCollection(viewInfo);
        if (empEleContractSignRecordCollection.size() > 0) {
            empEleContractSignRecordInfo = empEleContractSignRecordCollection.get(0);
        }
        return empEleContractSignRecordInfo;
    }

    public static EmpOtherEleContractSignRecordInfo getOtherEmpEleConSignRecordInfo(IEmpOtherEleContractSignRecord empEleContractSignRecordLocalInstance, String contractId) throws BOSException {
        EmpOtherEleContractSignRecordInfo empEleContractSignRecordInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contract.id", (Object)contractId));
        viewInfo.setFilter(filter);
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo sortItem = new SorterItemInfo("createTime");
        sortItem.setSortType(SortType.DESCEND);
        sortColl.add(sortItem);
        viewInfo.setSorter(sortColl);
        EmpOtherEleContractSignRecordCollection empEleContractSignRecordCollection = empEleContractSignRecordLocalInstance.getEmpOtherEleContractSignRecordCollection(viewInfo);
        if (empEleContractSignRecordCollection.size() > 0) {
            empEleContractSignRecordInfo = empEleContractSignRecordCollection.get(0);
        }
        return empEleContractSignRecordInfo;
    }

    public static String getEContractNumber(Context ctx, IEmpOtherEleContractSignRecord empEleContractSignRecordLocalInstance, KDContractConfigInfo kdContractConfigInfo, String contractNo) throws EASBizException, BOSException {
        String no = "";
        if (!StringUtils.isEmpty((String)contractNo)) {
            if (kdContractConfigInfo != null) {
                no = no + contractNo + "-" + kdContractConfigInfo.getClientKDAppId();
            } else {
                String systemTimeStamp = EmpElectronicContractUtilsEx.getSystemTimeStamp();
                no = no + contractNo + "-" + systemTimeStamp;
            }
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        FilterItemInfo filterItemInfo = new FilterItemInfo("eContractNO", (Object)no);
        filterItems.add(filterItemInfo);
        IEmpEleContractDelLog empEleContractDelLogLocalInstance = EmpEleContractDelLogFactory.getLocalInstance(ctx);
        while (empEleContractSignRecordLocalInstance.exists(filter) || empEleContractDelLogLocalInstance.exists(filter)) {
            filterItems.remove(filterItemInfo);
            String systemTimeStamp = EmpElectronicContractUtilsEx.getSystemTimeStamp();
            no = no + "-" + systemTimeStamp;
            filterItemInfo = new FilterItemInfo("eContractNO", (Object)no);
            filterItems.add(filterItemInfo);
        }
        return no;
    }

    public static EmpOtherEleContractSignRecordInfo repairEmpEleContractSignRecord(Context ctx, ContractBillMiddleInfo contractBillMiddleInfo) throws EASBizException, BOSException {
        String contractNo = contractBillMiddleInfo.getContractNo();
        ContractTempletInfo contractTemplet = contractBillMiddleInfo.getContractTemplet();
        PersonInfo personInfo = contractBillMiddleInfo.getPerson();
        PreEntryPersonInfo preEntryPersonInfo = contractBillMiddleInfo.getPreEntryPerson();
        IEmpOtherEleContractSignRecord empEleContractSignRecordLocalInstance = EmpOtherEleContractSignRecordFactory.getLocalInstance(ctx);
        if (contractTemplet.isIsElectronicSign()) {
            EmpOtherEleContractSignRecordInfo empEleContractSignRecordInfo = new EmpOtherEleContractSignRecordInfo();
            LabContractFirstPartyInfo labContractFirstParty = contractBillMiddleInfo.getLabContractFirstParty();
            KDContractConfigInfo kdContractConfigInfo = EmpElectronicContractUtilsEx.getKDContractConfigByLabContractFirstParty(ctx, labContractFirstParty);
            String eContractNo = EmpElectronicOtherContractUtils.getEContractNumber(ctx, empEleContractSignRecordLocalInstance, kdContractConfigInfo, contractNo);
            empEleContractSignRecordInfo.setPerson(personInfo);
            empEleContractSignRecordInfo.setPreEntryPerson(preEntryPersonInfo);
            EmployeeOtherContractInfo employeeContractInfo = new EmployeeOtherContractInfo();
            employeeContractInfo.setId(contractBillMiddleInfo.getContractId());
            empEleContractSignRecordInfo.setContract(employeeContractInfo);
            empEleContractSignRecordInfo.setContractNO(contractBillMiddleInfo.getContractNo());
            empEleContractSignRecordInfo.setEContractNO(eContractNo);
            empEleContractSignRecordInfo.setSignStatus(EContractSignState.nosign);
            empEleContractSignRecordInfo.setKdContractConfig(kdContractConfigInfo);
            empEleContractSignRecordInfo.setIsInvalid(false);
            IObjectPK pk = empEleContractSignRecordLocalInstance.save((CoreBaseInfo)empEleContractSignRecordInfo);
            empEleContractSignRecordInfo.setId(BOSUuid.read((String)pk.toString()));
            return empEleContractSignRecordInfo;
        }
        throw new EmpEleContractException(EmpEleContractException.NOT_SUPPORT__ELECTRONIC_SIGNATURE);
    }

    public static String getSystemTimeStamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSSS");
        String id = sdf.format(System.currentTimeMillis());
        return id;
    }

    public static KDContractConfigInfo getKDContractConfigByLabContractFirstParty(Context ctx, LabContractFirstPartyInfo labContractFirstParty) throws BOSException, EmpEleContractException {
        String labContractFirstPartyId = labContractFirstParty != null ? (labContractFirstParty.getId() != null ? labContractFirstParty.getId().toString() : "") : "";
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("labContractFirstParty.id", (Object)labContractFirstPartyId));
        viewInfo.setFilter(filter);
        KDContractConfigInfo kdContractConfigInfo = null;
        KDContractConfigCollection kdContractConfigCollection = KDContractConfigFactory.getLocalInstance((Context)ctx).getKDContractConfigCollection(viewInfo);
        if (kdContractConfigCollection != null && kdContractConfigCollection.size() > 0) {
            kdContractConfigInfo = kdContractConfigCollection.get(0);
            if (kdContractConfigInfo == null) {
                throw new EmpEleContractException(EmpEleContractException.CONTRACT_CONFIG_IS_NOT_OPEN, new Object[]{labContractFirstParty == null ? "" : labContractFirstParty.getName()});
            }
            if (kdContractConfigInfo.getServiceStatus() != KDContractServiceStatus.REGISTSUCC) {
                throw new EmpEleContractException(EmpEleContractException.KDCONTRACTSERVICE_NO_REGISTSUCC, new Object[]{labContractFirstParty == null ? "" : labContractFirstParty.getName()});
            }
        } else {
            throw new EmpEleContractException(EmpEleContractException.CONTRACT_CONFIG_IS_NOT_OPEN, new Object[]{labContractFirstParty == null ? "" : labContractFirstParty.getName()});
        }
        return kdContractConfigInfo;
    }

    public static EmpOtherEleContractSignRecordInfo generateOtherEmpEleContractSignRecord(Context ctx, EmployeeOtherContractInfo employeeContractInfo, HRBillBaseInfo billBaseInfo, HRBillBaseEntryInfo hrBillBaseEntryInfo) throws EASBizException, BOSException {
        String contractNo = employeeContractInfo.getContractNo();
        ContractTempletInfo contractTemplet = employeeContractInfo.getContractTemplet();
        PersonInfo personInfo = employeeContractInfo.getEmployee();
        PreEntryPersonInfo preEntryPersonInfo = employeeContractInfo.getPreEntryPerson();
        IEmpOtherEleContractSignRecord otherContractSignRecordInstance = EmpOtherEleContractSignRecordFactory.getLocalInstance(ctx);
        if (contractTemplet.isIsElectronicSign() && employeeContractInfo.getContractClassify() != null && employeeContractInfo.getContractClassify().getValue() == 2) {
            EmpOtherEleContractSignRecordInfo otherContractSignRecordInfo = EmpElectronicOtherContractUtilsEx.getOtherEmpEleContractSignRecordInfo(otherContractSignRecordInstance, employeeContractInfo.getId().toString());
            if (otherContractSignRecordInfo != null) {
                logger.error("EmpElectronicOtherContractUtilsEx.generateOtherEmpEleContractSignRecord otherContractSignRecordInfo : " + otherContractSignRecordInfo.getId());
            }
            if (otherContractSignRecordInfo == null) {
                logger.error("EmpElectronicOtherContractUtilsEx.generateOtherEmpEleContractSignRecord otherContractSignRecordInfo is null");
                otherContractSignRecordInfo = new EmpOtherEleContractSignRecordInfo();
                LabContractFirstPartyInfo labContractFirstParty = employeeContractInfo.getLabContractFirstParty();
                if (labContractFirstParty == null) {
                    throw new EmpEleContractException(EmpEleContractException.LAB_CONTRACT_FIRST_PARTY_TIP);
                }
                KDContractConfigInfo kdContractConfigInfo = EmpElectronicOtherContractUtilsEx.getKDContractConfigByLabContractFirstParty(ctx, labContractFirstParty);
                String eContractNo = EmpElectronicOtherContractUtils.getEContractNumber(ctx, otherContractSignRecordInstance, kdContractConfigInfo, contractNo);
                otherContractSignRecordInfo.setPerson(personInfo);
                otherContractSignRecordInfo.setPreEntryPerson(preEntryPersonInfo);
                otherContractSignRecordInfo.setContract(employeeContractInfo);
                otherContractSignRecordInfo.setContractNO(employeeContractInfo.getContractNo());
                otherContractSignRecordInfo.setEContractNO(eContractNo);
                otherContractSignRecordInfo.setSignStatus(EContractSignState.nosign);
                otherContractSignRecordInfo.setKdContractConfig(kdContractConfigInfo);
                otherContractSignRecordInfo.setIsInvalid(false);
                if (billBaseInfo != null) {
                    otherContractSignRecordInfo.setBillId(billBaseInfo.getId());
                }
                if (hrBillBaseEntryInfo != null) {
                    otherContractSignRecordInfo.setEntryId(hrBillBaseEntryInfo.getId());
                }
                IObjectPK pk = otherContractSignRecordInstance.save((CoreBaseInfo)otherContractSignRecordInfo);
                otherContractSignRecordInfo.setId(BOSUuid.read((String)pk.toString()));
                return otherContractSignRecordInfo;
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            if (otherContractSignRecordInfo.getKdContractConfig() == null) {
                LabContractFirstPartyInfo labContractFirstParty = employeeContractInfo.getLabContractFirstParty();
                KDContractConfigInfo kdContractConfigInfo = EmpElectronicOtherContractUtilsEx.getKDContractConfigByLabContractFirstParty(ctx, labContractFirstParty);
                otherContractSignRecordInfo.setKdContractConfig(kdContractConfigInfo);
                String eContractNo = EmpElectronicOtherContractUtils.getEContractNumber(ctx, otherContractSignRecordInstance, kdContractConfigInfo, contractNo);
                otherContractSignRecordInfo.setContractNO(employeeContractInfo.getContractNo());
                otherContractSignRecordInfo.setEContractNO(eContractNo);
                selector.add(new SelectorItemInfo("kdContractConfig"));
                selector.add(new SelectorItemInfo("contractNO"));
                selector.add(new SelectorItemInfo("eContractNO"));
            }
            if (EContractSignState.uninitiated.equals((Object)otherContractSignRecordInfo.getSignStatus())) {
                otherContractSignRecordInfo.setSignStatus(EContractSignState.nosign);
                otherContractSignRecordInfo.setIsCreate(false);
                otherContractSignRecordInfo.setEcreateTime(null);
                otherContractSignRecordInfo.setIsFillSuccess(false);
                selector.add(new SelectorItemInfo("signStatus"));
                selector.add(new SelectorItemInfo("isCreate"));
                selector.add(new SelectorItemInfo("ecreateTime"));
                selector.add(new SelectorItemInfo("isFillSuccess"));
            }
            if (selector.size() > 0) {
                otherContractSignRecordInstance.updatePartial(otherContractSignRecordInfo, selector);
            }
            return otherContractSignRecordInfo;
        }
        throw new EmpEleContractException(EmpEleContractException.BATCHEMPLOYEESIGN_IS_FAIL_FOR_CONTRACTTEMPLET);
    }

    public static void updateOtherEmployeeContractSignStatus(Context ctx, String contractId, EContractSignState signState) throws BOSException, EASBizException {
        IEmployeeOtherContract employeeOtherContractInstance = EmployeeOtherContractFactory.getLocalInstance((Context)ctx);
        EmployeeOtherContractInfo otherContractInfo = employeeOtherContractInstance.getEmployeeOtherContractInfo((IObjectPK)new ObjectUuidPK(contractId));
        otherContractInfo.setSignStatus(signState);
        if (2 == signState.getValue()) {
            otherContractInfo.setIsElectronicSign(true);
        }
        if (5 == signState.getValue()) {
            otherContractInfo.setIsElectronicSign(false);
        }
        otherContractInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
        otherContractInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("signStatus"));
        if (2 == signState.getValue() || 5 == signState.getValue()) {
            selector.add(new SelectorItemInfo("isElectronicSign"));
        }
        selector.add(new SelectorItemInfo("lastUpdateTime"));
        selector.add(new SelectorItemInfo("lastUpdateUser"));
        logger.error("EmpElectronicOtherContractUtilsEx.updateOtherEmployeeContractSignStatus signState : " + (Object)((Object)signState));
        employeeOtherContractInstance.updatePartial((CoreBaseInfo)otherContractInfo, selector);
    }

    public static void copyAndSaveEmployeeContractToMiddle(Context ctx, EmployeeOtherContractInfo employeeContractInfo) throws BOSException, EASBizException {
        BigDecimal contractAgreedSalary;
        BigDecimal compensation;
        BigDecimal penalty;
        String contractLimit;
        PersonInfo personInfo;
        IContractBillMiddle contractBillMiddleLocalInstance = ContractBillMiddleFactory.getLocalInstance(ctx);
        ContractBillMiddleInfo contractBillMiddleInfo = EmpElectronicContractUtilsEx.getContractBillMiddleInfoByContractId(ctx, contractBillMiddleLocalInstance, employeeContractInfo.getId().toString());
        if (contractBillMiddleInfo == null) {
            contractBillMiddleInfo = new ContractBillMiddleInfo();
        }
        EmpPosOrgRelationQueryHelper empPosOrgRelationQueryHelper = new EmpPosOrgRelationQueryHelper();
        EmpPosOrgRelationCollection mianCurrntEmpOrgRelation = empPosOrgRelationQueryHelper.getMianCurrntEmpOrgRelation(ctx, employeeContractInfo.getEmployee().getId().toString());
        EmpPosOrgRelationInfo empPosOrgRelationInfo = null;
        logger.error("EmpElectronicOtherContractUtilsEx.copyAndSaveEmployeeContractToMiddle mianCurrntEmpOrgRelation.size : " + mianCurrntEmpOrgRelation.size());
        if (mianCurrntEmpOrgRelation.size() > 0) {
            empPosOrgRelationInfo = mianCurrntEmpOrgRelation.get(0);
        }
        if (empPosOrgRelationInfo != null) {
            logger.error("EmpElectronicOtherContractUtilsEx.copyAndSaveEmployeeContractToMiddle empPosOrgRelationInfo : " + empPosOrgRelationInfo.getId());
        } else {
            logger.error("EmpElectronicOtherContractUtilsEx.copyAndSaveEmployeeContractToMiddle empPosOrgRelationInfo is null ");
        }
        ContactBillMiddleUtils.copyData((Context)ctx, (IObjectValue)employeeContractInfo, (IObjectValue)contractBillMiddleInfo);
        if (empPosOrgRelationInfo != null) {
            contractBillMiddleInfo.setPosition(empPosOrgRelationInfo.getPosition());
            contractBillMiddleInfo.setAdminOrg(empPosOrgRelationInfo.getAdminOrg());
            contractBillMiddleInfo.setBillId(null);
            contractBillMiddleInfo.setEntryId(null);
            contractBillMiddleInfo.setBizDate(employeeContractInfo.getEffectDate());
            contractBillMiddleInfo.setContractType(employeeContractInfo.getContractTemplet().getContractType());
            Integer tryoutMonth = 0;
            if (employeeContractInfo.getTestBeginDate() != null && employeeContractInfo.getTestEndDate() != null) {
                tryoutMonth = ShrEmpNaturalMonthUtil.getProbation((Date)employeeContractInfo.getTestBeginDate(), (Date)employeeContractInfo.getTestEndDate());
            }
            if (tryoutMonth != null && tryoutMonth > 0) {
                contractBillMiddleInfo.setTryoutMonth(tryoutMonth);
            }
        }
        if ((personInfo = EmpElectronicContractUtilsEx.getPersonInfo(ctx, employeeContractInfo.getEmployee().getId().toString())) != null) {
            contractBillMiddleInfo.setIdCardNo(personInfo.getIdCardNO());
            contractBillMiddleInfo.setPassportNo(personInfo.getPassportNO());
        }
        if (!StringUtils.isEmpty((String)(contractLimit = contractBillMiddleInfo.getContractLimit()))) {
            BigDecimal bigDecimal = new BigDecimal(contractLimit);
            BigDecimal setScale = bigDecimal.setScale(1);
            contractBillMiddleInfo.setContractLimit(setScale.toString());
        }
        if ((penalty = contractBillMiddleInfo.getPenalty()) != null) {
            contractBillMiddleInfo.setPenalty(penalty.setScale(2));
        }
        if ((compensation = contractBillMiddleInfo.getCompensation()) != null) {
            contractBillMiddleInfo.setCompensation(compensation.setScale(2));
        }
        if ((contractAgreedSalary = contractBillMiddleInfo.getContractAgreedSalary()) != null) {
            contractBillMiddleInfo.setContractAgreedSalary(contractAgreedSalary.setScale(2));
        }
        contractBillMiddleLocalInstance.save((CoreBaseInfo)contractBillMiddleInfo);
        logger.error("EmpElectronicOtherContractUtilsEx.copyAndSaveEmployeeContractToMiddle contractBillMiddleInfo : " + contractBillMiddleInfo.getId());
    }

    public static void copyAndSaveEmployeeContractToMiddleForPreEntryPreson(Context ctx, EmployeeOtherContractInfo employeeContractInfo, ContractPreNewSignBizBillInfo cpnsbbInfo, OtherFollowPreNewConEntryInfo ofpncentryInfo) throws BOSException, EASBizException {
        BigDecimal contractAgreedSalary;
        BigDecimal compensation;
        BigDecimal penalty;
        String contractLimit;
        PreEntryInfo preEntryInfo;
        IContractBillMiddle contractBillMiddleLocalInstance = ContractBillMiddleFactory.getLocalInstance(ctx);
        ContractBillMiddleInfo contractBillMiddleInfo = EmpElectronicContractUtilsEx.getContractBillMiddleInfoByContractId(ctx, contractBillMiddleLocalInstance, employeeContractInfo.getId().toString());
        if (contractBillMiddleInfo == null) {
            contractBillMiddleInfo = new ContractBillMiddleInfo();
        }
        if ((preEntryInfo = EmpElectronicContractUtilsEx.getPreEntryInfoByPreEntryPresonId(ctx, employeeContractInfo.getPreEntryPerson().getId().toString())) != null) {
            logger.error("EmpElectronicOtherContractUtils.copyAndSaveEmployeeContractToMiddleForPreEntryPreson preEntryInfo : " + preEntryInfo.getId());
        } else {
            logger.error("EmpElectronicOtherContractUtils.copyAndSaveEmployeeContractToMiddleForPreEntryPreson preEntryInfo is null ");
        }
        ContactBillMiddleUtils.copyData((Context)ctx, (IObjectValue)employeeContractInfo, (IObjectValue)contractBillMiddleInfo);
        if (preEntryInfo != null) {
            PreEntryPersonInfo preEntryPersonInfo;
            contractBillMiddleInfo.setPosition(preEntryInfo.getPosition());
            contractBillMiddleInfo.setAdminOrg(preEntryInfo.getAdminOrg());
            contractBillMiddleInfo.setBillId(cpnsbbInfo.getId());
            contractBillMiddleInfo.setEntryId(ofpncentryInfo.getId());
            contractBillMiddleInfo.setBizDate(employeeContractInfo.getEffectDate());
            contractBillMiddleInfo.setContractType(employeeContractInfo.getContractTemplet().getContractType());
            Integer tryoutMonth = 0;
            if (employeeContractInfo.getTestBeginDate() != null && employeeContractInfo.getTestEndDate() != null) {
                tryoutMonth = ShrEmpNaturalMonthUtil.getProbation((Date)employeeContractInfo.getTestBeginDate(), (Date)employeeContractInfo.getTestEndDate());
            }
            if (tryoutMonth != null && tryoutMonth > 0) {
                contractBillMiddleInfo.setTryoutMonth(tryoutMonth);
            }
            if (preEntryInfo.getTalent() != null && (preEntryPersonInfo = preEntryInfo.getTalent()) != null) {
                contractBillMiddleInfo.setIdCardNo(preEntryPersonInfo.getIdCardNO());
                contractBillMiddleInfo.setPassportNo(preEntryPersonInfo.getPassportNO());
            }
        }
        if (!StringUtils.isEmpty((String)(contractLimit = contractBillMiddleInfo.getContractLimit()))) {
            BigDecimal bigDecimal = new BigDecimal(contractLimit);
            BigDecimal setScale = bigDecimal.setScale(1);
            contractBillMiddleInfo.setContractLimit(setScale.toString());
        }
        if ((penalty = contractBillMiddleInfo.getPenalty()) != null) {
            contractBillMiddleInfo.setPenalty(penalty.setScale(2));
        }
        if ((compensation = contractBillMiddleInfo.getCompensation()) != null) {
            contractBillMiddleInfo.setCompensation(compensation.setScale(2));
        }
        if ((contractAgreedSalary = contractBillMiddleInfo.getContractAgreedSalary()) != null) {
            contractBillMiddleInfo.setContractAgreedSalary(contractAgreedSalary.setScale(2));
        }
        contractBillMiddleLocalInstance.save((CoreBaseInfo)contractBillMiddleInfo);
        logger.error("EmpElectronicOtherContractUtils.copyAndSaveEmployeeContractToMiddleForPreEntryPreson contractBillMiddleInfo : " + contractBillMiddleInfo.getId());
    }

    public static SHRElectronicTemplateInfo getSHRElectronicTemplateInfoByEmployeeContract(Context ctx, EmployeeOtherContractInfo employeeContractInfo) throws BOSException, EmpEleContractException {
        ISHRElectronicTemplate electronicTemplateLocalInstance = SHRElectronicTemplateFactory.getLocalInstance(ctx);
        ContractTempletInfo contractTempletInfo = employeeContractInfo.getContractTemplet();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contractTemplet.id", (Object)contractTempletInfo.getId().toString()));
        viewInfo.setFilter(filter);
        SHRElectronicTemplateCollection electronicTemplateInfoColl = electronicTemplateLocalInstance.getSHRElectronicTemplateCollection(viewInfo);
        if (electronicTemplateInfoColl.size() <= 0) {
            throw new EmpEleContractException(EmpEleContractException.NOT_FOUND_ELECTRONIC_TEMPLATE);
        }
        SHRElectronicTemplateInfo electronicTemplateInfo = electronicTemplateInfoColl.get(0);
        return electronicTemplateInfo;
    }

    public static EmpOtherEleContractSignRecordInfo getEmpEleContractSignRecordInfo(Context ctx, String contractId) throws BOSException {
        EmpOtherEleContractSignRecordInfo signRecordInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contract.id", (Object)contractId));
        filter.getFilterItems().add(new FilterItemInfo("isInvalid", (Object)0, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        IEmpOtherEleContractSignRecord empSignRecordInstance = EmpOtherEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpOtherEleContractSignRecordCollection signRecordCollection = empSignRecordInstance.getEmpOtherEleContractSignRecordCollection(viewInfo);
        if (signRecordCollection.size() > 0) {
            signRecordInfo = signRecordCollection.get(0);
        }
        return signRecordInfo;
    }

    public static Boolean checkElectronicContractIsCreate(Context ctx, String contractId) throws BOSException {
        EmpOtherEleContractSignRecordInfo signRecordInfo = EmpElectronicOtherContractUtilsEx.getEmpEleContractSignRecordInfo(ctx, contractId);
        if (signRecordInfo != null) {
            return signRecordInfo.isIsCreate();
        }
        logger.error("EmpElectronicOtherContractUtilsEx.checkElectronicContractIsCreate empEleContractSignRecordInfo is null : false");
        return false;
    }

    public static EmpTaskMessageLogInfo sendPersonSignMessageForNewTemplate(Context ctx, EmpOtherEleContractSignRecordInfo empEleContractSignRecordInfo, EmployeeOtherContractInfo employeeContractInfo, String contractId) throws EASBizException, BOSException {
        EmpTaskMessageLogInfo empTaskMessageLogInfo = null;
        try {
            String label8 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractMessageResource", (String)"label8", (Context)ctx);
            logger.error("=====EmpElectronicOtherContractUtilsEx.sendPersonSignMessageForNewTemplate label8 : " + label8);
            Thread.sleep(2000L);
            boolean isbreak = true;
            int times = 0;
            while (isbreak) {
                Boolean isCreate = EmpElectronicOtherContractUtilsEx.checkElectronicContractIsCreate(ctx, contractId);
                logger.error("====EmpElectronicOtherContractUtilsEx.sendPersonSignMessageForNewTemplate times : " + ++times);
                if (!isCreate.booleanValue()) {
                    Thread.sleep(2000L);
                } else {
                    isbreak = false;
                    empTaskMessageLogInfo = (EmpTaskMessageLogInfo)EmpOtherEleContractSendMessageFacadeFactory.getLocalInstance(ctx).sendPersonSignMessage(empEleContractSignRecordInfo, employeeContractInfo);
                }
                if (isCreate.booleanValue() || times <= 15) continue;
                isbreak = false;
                if (empTaskMessageLogInfo != null) continue;
                empTaskMessageLogInfo = new EmpTaskMessageLogInfo();
                BOSUuid contractUuid = BOSUuid.read((String)employeeContractInfo.getId().toString());
                empTaskMessageLogInfo.setBusinessId(contractUuid);
                empTaskMessageLogInfo.setBusinessType("PERSON_SIGN");
                empTaskMessageLogInfo.setSendResult(false);
                empTaskMessageLogInfo.setIsSend(false);
                String label9 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractMessageResource", (String)"label9", (Context)ctx);
                logger.error("====EmpElectronicOtherContractUtilsEx.sendPersonSignMessageForNewTemplate label9 : " + label9);
                empTaskMessageLogInfo.setReason(label9);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return empTaskMessageLogInfo;
    }

    public static EmpTaskMessageLogInfo sendPersonSignMessage(Context ctx, EmpOtherEleContractSignRecordInfo empEleContractSignRecordInfo, EmployeeOtherContractInfo employeeContractInfo) throws EASBizException, BOSException {
        EmpTaskMessageLogInfo empTaskMessageLogInfo = (EmpTaskMessageLogInfo)EmpOtherEleContractSendMessageFacadeFactory.getLocalInstance(ctx).sendPersonSignMessage(empEleContractSignRecordInfo, employeeContractInfo);
        return empTaskMessageLogInfo;
    }

    public static String getEContractNOByContractId(Context ctx, String contractId) throws BOSException, EASBizException {
        IEmpOtherEleContractSignRecord empEleContractSignRecordLocalInstance = EmpOtherEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpOtherEleContractSignRecordInfo empEleContractSignRecordInfo = EmpElectronicOtherContractUtilsEx.getOtherEmpEleContractSignRecordInfo(empEleContractSignRecordLocalInstance, contractId);
        if (empEleContractSignRecordInfo == null) {
            throw new EmpEleContractException(EmpEleContractException.GET_EMPELECONTRACTSIGNRECORD_BY_CONTRACTID_IS_ERROR, new Object[]{"ID", contractId});
        }
        String eContractNO = empEleContractSignRecordInfo.getEContractNO();
        return eContractNO;
    }

    public static String getEContractNOByContractNO(Context ctx, String contractNO) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contractNo", (Object)contractNO));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(selector);
        EmployeeOtherContractInfo employeeOtherContractInfo = null;
        EmployeeOtherContractCollection employeeOtherContractCollection = EmployeeOtherContractFactory.getLocalInstance((Context)ctx).getEmployeeOtherContractCollection(viewInfo);
        if (employeeOtherContractCollection != null && employeeOtherContractCollection.size() > 0) {
            employeeOtherContractInfo = employeeOtherContractCollection.get(0);
        }
        if (employeeOtherContractInfo == null) {
            throw new EmpEleContractException(EmpEleContractException.GET_EMPLOYEECONTRACT_BY_CONTRACTNO_IS_ERROR, new Object[]{"\u7f16\u53f7", contractNO});
        }
        String contractId = employeeOtherContractInfo.getId() != null ? employeeOtherContractInfo.getId().toString() : "";
        IEmpOtherEleContractSignRecord empOtherEleConSignRecordLocalInstance = EmpOtherEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpOtherEleContractSignRecordInfo empOtherEleConSignRecordInfo = EmpElectronicOtherContractUtilsEx.getOtherEmpEleConSignRecordInfo(empOtherEleConSignRecordLocalInstance, contractId);
        if (empOtherEleConSignRecordInfo == null) {
            throw new EmpEleContractException(EmpEleContractException.GET_EMPELECONTRACTSIGNRECORD_BY_CONTRACTID_IS_ERROR, new Object[]{"id", contractNO});
        }
        String eContractNO = empOtherEleConSignRecordInfo.getEContractNO();
        return eContractNO;
    }

    public static void batchEmployeeOtherSign(Context ctx, String contractId, String signStatusString, BatchMessageTipsBody body, Boolean batchAgain) throws EASBizException, BOSException {
        String operation = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label27", (Context)ctx);
        EmpElectronicOtherContractUtilsEx.checkEmpEleContractSignRecordSignStatus(signStatusString, operation, batchAgain);
        IEmployeeOtherContract employeeContractLocalInstance = EmployeeOtherContractFactory.getLocalInstance((Context)ctx);
        EmployeeOtherContractInfo empOtherContractInfo = EmpElectronicOtherContractUtilsEx.getEmployeeOtherContractInfo(employeeContractLocalInstance, contractId);
        empOtherContractInfo.setSignType(empOtherContractInfo.getContractTemplet().getSignType());
        SignTypeEnum sSignType = empOtherContractInfo.getContractTemplet().getSignType();
        if (sSignType != null) {
            logger.error("EmpElectronicOtherContractUtilsEx  update EmployeeOtherContract  signState : " + sSignType.toString() + "====contractId=" + contractId);
        } else {
            logger.error("EmpElectronicOtherContractUtilsEx  update EmployeeOtherContract  signState  is null ====contractId=" + contractId);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("signType"));
        employeeContractLocalInstance.updatePartial((CoreBaseInfo)empOtherContractInfo, selector);
        LabContractFirstPartyInfo labContractFirstParty = empOtherContractInfo.getLabContractFirstParty();
        if (labContractFirstParty == null) {
            throw new EmpEleContractException(EmpEleContractException.LAB_CONTRACT_FIRST_PARTY_TIP);
        }
        EmpElectronicOtherContractUtilsEx.verifyOtherContractIsFreeOrEnd(ctx, empOtherContractInfo);
        EmpElectronicOtherContractUtilsEx.verifyOtherContractSignStatusAndContractClassify(ctx, empOtherContractInfo);
        KDContractConfigCollection contractConfigCollection = KDContractConfigFactory.getLocalInstance((Context)ctx).getKDContractConfigCollection("where labContractFirstParty.id='" + labContractFirstParty.getId().toString() + "'");
        if (contractConfigCollection == null || contractConfigCollection.isEmpty()) {
            String label40 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label40", (Context)ctx);
            throw new BOSException(label40);
        }
        EmpElectronicOtherContractUtilsEx.checkKDContractConfigIsAuth(ctx, contractConfigCollection.get(0));
        if (sSignType.getValue() == 2) {
            LabContractFirstPartyInfo labContractCParty = empOtherContractInfo.getLabContractCParty();
            if (labContractCParty == null) {
                throw new EmpEleContractException(EmpEleContractException.LAB_CONTRACT_C_PARTY_TIP);
            }
            KDContractConfigCollection contractBConfigCollection = KDContractConfigFactory.getLocalInstance((Context)ctx).getKDContractConfigCollection("where labContractFirstParty.id='" + labContractCParty.getId().toString() + "'");
            if (contractBConfigCollection == null || contractBConfigCollection.isEmpty()) {
                String label40 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label40", (Context)ctx);
                throw new BOSException(label40);
            }
            EmpElectronicOtherContractUtilsEx.checkKDContractConfigIsAuth(ctx, contractBConfigCollection.get(0));
        }
        EmpElectronicOtherContractUtilsEx.checkOtherPersonStatus(ctx, empOtherContractInfo);
        EmpOtherEleContractSignRecordInfo empOtherEleContractSignRecordInfo = EmpElectronicOtherContractUtilsEx.generateOtherEmpEleContractSignRecord(ctx, empOtherContractInfo, null, null);
        Map serverMap = null;
        try {
            serverMap = TSPServerInstance.getServerInfo((Context)ctx);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        EmpElectronicOtherContractUtils.checkHRCloudLincense(ctx, empOtherEleContractSignRecordInfo.getEContractNO(), serverMap);
        EmpElectronicOtherContractUtilsEx.updateOtherEmployeeContractSignStatus(ctx, contractId, EContractSignState.nosign);
        EmpElectronicOtherContractUtilsEx.copyAndSaveEmployeeContractToMiddle(ctx, empOtherContractInfo);
        SHRElectronicTemplateInfo shrElectronicTemplateInfo = EmpElectronicOtherContractUtilsEx.getSHRElectronicTemplateInfoByEmployeeContract(ctx, empOtherContractInfo);
        String csTemplateId = shrElectronicTemplateInfo.getCsTemplateId();
        boolean isCsTemplate = StringUtils.isEmpty((String)csTemplateId);
        if (!empOtherEleContractSignRecordInfo.isIsCreate() && isCsTemplate) {
            logger.error("EmpElectronicOtherContractUtilsEx.batchEmployeeSign isCsTemplate : " + isCsTemplate + " createEContract");
            EmpOtherEleContractServiceFacadeFactory.getLocalInstance(ctx).createEContract(empOtherEleContractSignRecordInfo, empOtherContractInfo, shrElectronicTemplateInfo, new HashMap());
        } else if (!empOtherEleContractSignRecordInfo.isIsCreate()) {
            logger.error("EmpElectronicOtherContractUtilsEx.batchEmployeeSign isCsTemplate : " + isCsTemplate + " createEContractForNewTemplate");
            EmpOtherEleContractServiceFacadeFactory.getLocalInstance(ctx).createEContractForNewTemplate(empOtherEleContractSignRecordInfo, empOtherContractInfo, shrElectronicTemplateInfo, new HashMap());
        }
        EmpTaskMessageLogInfo result = null;
        if (!isCsTemplate) {
            logger.error("EmpElectronicOtherContractUtilsEx.batchEmployeeSign isCsTemplate : " + isCsTemplate + " \u65b0\u6a21\u677f\u53d1\u9001\u6d88\u606f");
            result = EmpElectronicOtherContractUtilsEx.sendPersonSignMessageForNewTemplate(ctx, empOtherEleContractSignRecordInfo, empOtherContractInfo, contractId);
        } else {
            logger.error("EmpElectronicOtherContractUtilsEx.batchEmployeeSign isCsTemplate : " + isCsTemplate + " \u65e7\u6a21\u677f\u53d1\u9001\u6d88\u606f");
            result = EmpElectronicOtherContractUtilsEx.sendPersonSignMessage(ctx, empOtherEleContractSignRecordInfo, empOtherContractInfo);
        }
        if (result.isIsSend() && result.isSendResult()) {
            body.setMuitTipsState(Boolean.TRUE.booleanValue());
            String label0 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractMessageResource", (String)"label0", (Context)ctx);
            String realObj = MessageFormat.format(label0, result.getType().getAlias());
            body.setMuitTipsMessage(realObj);
        } else {
            body.setMuitTipsState(Boolean.FALSE.booleanValue());
            body.setMuitTipsMessage(result.getReason());
        }
    }

    public static void ProcessingSucceededOrFailed(BatchMessageTipsBody body, HashMap<String, Integer> hashMap) {
        if (body.isMuitTipsState()) {
            int success = hashMap.get("success");
            hashMap.put("success", ++success);
        } else {
            int failure = hashMap.get("failure");
            hashMap.put("failure", ++failure);
        }
    }

    public static EmpOtherEleContractSignRecordInfo getEmpOtherEleContractSignRecordInfo(IEmpOtherEleContractSignRecord empEleContractSignRecordLocalInstance, String contractId) throws BOSException {
        EmpOtherEleContractSignRecordInfo empEleContractSignRecordInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contract.id", (Object)contractId));
        filter.getFilterItems().add(new FilterItemInfo("isInvalid", (Object)0, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        EmpOtherEleContractSignRecordCollection otherRecords = empEleContractSignRecordLocalInstance.getEmpOtherEleContractSignRecordCollection(viewInfo);
        if (otherRecords.size() > 0) {
            empEleContractSignRecordInfo = otherRecords.get(0);
        }
        return empEleContractSignRecordInfo;
    }

    public static EmpOtherEleContractSignRecordInfo getEmpOtherEleContractSignRecordByContractNo(Context ctx, String contractNO, String billId) throws BOSException, EASBizException {
        EmpOtherEleContractSignRecordInfo recordInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (!StringUtils.isEmpty((String)contractNO)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("contractNO", (Object)contractNO));
        }
        if (!StringUtils.isEmpty((String)billId)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        }
        view.setFilter(filterInfo);
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo sortItem = new SorterItemInfo("createTime");
        sortItem.setSortType(SortType.DESCEND);
        sortColl.add(sortItem);
        view.setSorter(sortColl);
        EmpOtherEleContractSignRecordCollection recordCollection = EmpOtherEleContractSignRecordFactory.getLocalInstance(ctx).getEmpOtherEleContractSignRecordCollection(view);
        if (recordCollection.size() > 0) {
            recordInfo = recordCollection.get(0);
        }
        return recordInfo;
    }

    public static void checkEmpEleContractStatus(Context ctx, EmpOtherEleContractSignRecordInfo otherSignRecordInfo) throws BOSException, EASBizException {
        int signStatusValue;
        EContractSignState signStatus = otherSignRecordInfo.getSignStatus();
        int n = signStatusValue = signStatus != null ? signStatus.getValue() : -999;
        if (signStatus != null && signStatusValue != 1 && signStatusValue != 6) {
            throw new EmpEleContractException(EmpEleContractException.ELECTRONIC_CONTRACT_SIGNING_STATUS_IS_NOT_SIGNING, new Object[]{signStatus.getAlias()});
        }
        if (signStatusValue == -999) {
            throw new EmpEleContractException(EmpEleContractException.ELECTRONIC_CONTRACT_SIGNING_STATUS_IS_NULL);
        }
    }

    public static SelectorItemCollection getElectronicTemplateSelector() {
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("isRegister"));
        coll.add(new SelectorItemInfo("templateId"));
        coll.add(new SelectorItemInfo("isSameTime"));
        coll.add(new SelectorItemInfo("contractTemplet"));
        coll.add(new SelectorItemInfo("csTemplateId"));
        coll.add(new SelectorItemInfo("contractTemplet.id"));
        coll.add(new SelectorItemInfo("contractTemplet.signType"));
        return coll;
    }

    public static boolean checkKDContractConfigIsAuth(Context ctx, KDContractConfigInfo configInfo) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)2));
        filter.getFilterItems().add(new FilterItemInfo("config.id", (Object)configInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("enterpId", (Object)configInfo.getClientEnterpriseId()));
        boolean exists = KDContractConfigAuthRecordFactory.getLocalInstance((Context)ctx).exists(filter);
        if (!exists) {
            if (StringUtils.isEmpty((String)configInfo.getString("enterpriseName"))) {
                String oql = "select id, enterpriseName, clientEnterpriseId where id = '" + configInfo.getId().toString() + "'";
                configInfo = KDContractConfigFactory.getLocalInstance((Context)ctx).getKDContractConfigInfo(oql);
            }
            String label38 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label38", (Context)ctx, (Object[])new Object[]{configInfo.getEnterpriseName()});
            throw new BOSException(label38);
        }
        return exists;
    }

    public static void batchCompanySign(Context ctx, String contractId, String permItemId, String signStatusString, BatchMessageTipsBody body) throws EASBizException, BOSException, InterruptedException {
        LabContractFirstPartyInfo labBParty;
        IEmployeeOtherContract employeeOtherContractInstance = EmployeeOtherContractFactory.getLocalInstance((Context)ctx);
        EmployeeOtherContractInfo empOtherContractInfo = EmpElectronicOtherContractUtilsEx.getEmployeeOtherContractInfo(employeeOtherContractInstance, contractId);
        LabContractFirstPartyInfo labAParty = empOtherContractInfo.getLabContractFirstParty();
        if (labAParty == null || labAParty.getId() == null) {
            String label32 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label32", (Context)ctx);
            throw new BOSException(label32);
        }
        int signType = empOtherContractInfo.getSignType().getValue();
        if (2 == signType && ((labBParty = empOtherContractInfo.getLabContractCParty()) == null || labBParty.getId() == null)) {
            String label33 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label33", (Context)ctx);
            throw new BOSException(label33);
        }
        ContractTempletInfo contractTemplate = empOtherContractInfo.getContractTemplet();
        if (contractTemplate == null || contractTemplate.getId() == null) {
            String label34 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label34", (Context)ctx);
            throw new BOSException(label34);
        }
        if (0 == signType) {
            String label30 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label30", (Context)ctx);
            throw new BOSException(label30);
        }
        if (1 == signType || 2 == signType) {
            boolean isSignByThree;
            String operation = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label28", (Context)ctx);
            EmpElectronicOtherContractUtilsEx.checkEmpEleContractSignRecordSignStatus(signStatusString, operation, false);
            IEmpOtherEleContractSignRecord empEleContractSignRecordLocalInstance = EmpOtherEleContractSignRecordFactory.getLocalInstance(ctx);
            EmpOtherEleContractSignRecordInfo empOtherEleContractSignRecordInfo = EmpElectronicOtherContractUtilsEx.getEmpOtherEleContractSignRecordInfo(empEleContractSignRecordLocalInstance, contractId);
            EmpElectronicOtherContractUtilsEx.checkEmpEleContractStatus(ctx, empOtherEleContractSignRecordInfo);
            String eContractNO = empOtherEleContractSignRecordInfo.getEContractNO();
            logger.error("EmpElectronicOtherContractUtilsEx.batchCompanySign send company sign contractId=" + contractId + "  eContractNO=" + eContractNO);
            if (empOtherEleContractSignRecordInfo.isIsSigned()) {
                String label31 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label31", (Context)ctx);
                throw new BOSException(label31);
            }
            boolean isSignByTwo = 1 == signType && empOtherEleContractSignRecordInfo.isIsPersonSign();
            boolean bl = isSignByThree = 2 == signType && empOtherEleContractSignRecordInfo.isIsPersonSign() && empOtherEleContractSignRecordInfo.isIsSecondPartySign();
            if (isSignByTwo || isSignByThree) {
                logger.error("EmpElectronicOtherContractUtilsEx.batchCompanySign  send partA sign (partA) ");
                LabContractFirstPartyInfo labContractFirstPartyInfo = empOtherContractInfo.getLabContractFirstParty();
                EmpElectronicContractUtilsEx.checkContractPartyAdminRange(ctx, labContractFirstPartyInfo, permItemId);
                KDContractConfigInfo contractAConfigInfo = KDContractConfigFactory.getLocalInstance((Context)ctx).getKDContractConfigInfo("where labContractFirstParty.id='" + labContractFirstPartyInfo.getId().toString() + "'");
                if (contractAConfigInfo == null || contractAConfigInfo.getClientEnterpriseId() == null) {
                    logger.error("EmpElectronicOtherContractUtilsEx.batchCompanySign   send partA sign   \u5408\u540cid contractId=" + contractId + "  \u7535\u5b50\u5408\u540c\u53f7eContractNO=" + eContractNO + "  \u4f01\u4e1a\u7f16\u53f7(userId(ClientEnterpriseId) is null) \u4e3a\u7a7a,\u8bf7\u68c0\u67e5\uff01");
                    String label37 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label37", (Context)ctx);
                    throw new BOSException(label37);
                }
                EmpElectronicOtherContractUtilsEx.checkKDContractConfigIsAuth(ctx, contractAConfigInfo);
                EmpElectronicOtherContractUtilsEx.getCompanySignResult(ctx, contractId, body, empOtherContractInfo, signType, empOtherEleContractSignRecordInfo, eContractNO, contractAConfigInfo, LAB_PARTYA);
            }
            if (2 == signType && empOtherEleContractSignRecordInfo.isIsPersonSign() && !empOtherEleContractSignRecordInfo.isIsSecondPartySign() && !empOtherEleContractSignRecordInfo.isIsFirstPartySign()) {
                LabContractFirstPartyInfo labBParty2 = empOtherContractInfo.getLabContractCParty();
                EmpElectronicContractUtilsEx.checkContractPartyAdminRange(ctx, labBParty2, permItemId);
                String labPartId = labBParty2.getId().toString();
                KDContractConfigInfo contractBConfigInfo = KDContractConfigFactory.getLocalInstance((Context)ctx).getKDContractConfigInfo("where labContractFirstParty.id='" + labPartId + "'");
                if (contractBConfigInfo == null || contractBConfigInfo.getClientEnterpriseId() == null) {
                    logger.error("EmpElectronicOtherContractUtilsEx.batchCompanySign  send partA sign  contractId=" + contractId + "   eContractNO=" + eContractNO + "  (userId(ClientEnterpriseId) is null),please check\uff01");
                    String label36 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label36", (Context)ctx);
                    throw new BOSException(label36);
                }
                EmpElectronicOtherContractUtilsEx.checkKDContractConfigIsAuth(ctx, contractBConfigInfo);
                EmpElectronicOtherContractUtilsEx.getCompanySignResult(ctx, contractId, body, empOtherContractInfo, signType, empOtherEleContractSignRecordInfo, eContractNO, contractBConfigInfo, LAB_PARTYB);
            }
        }
    }

    public static void getCompanySignResult(Context ctx, String contractId, BatchMessageTipsBody body, EmployeeOtherContractInfo empOtherContractInfo, int signType, EmpOtherEleContractSignRecordInfo empOtherEleContractSignRecordInfo, String eContractNO, KDContractConfigInfo contractConfigInfo, String labParty) throws BOSException, InterruptedException, EASBizException {
        String userId = contractConfigInfo.getClientEnterpriseId();
        EmpEleContractCompanyTaskInfo empEleContractCompanyTaskInfo = EmpElectronicOtherContractUtilsEx.getEmpEleContractCompanyTaskInfo(ctx, eContractNO, userId);
        boolean isRequest = false;
        Timestamp requestTime = null;
        if (empEleContractCompanyTaskInfo != null) {
            isRequest = empEleContractCompanyTaskInfo.isIsRequest();
            requestTime = empEleContractCompanyTaskInfo.getRequestTime();
        }
        if (isRequest && requestTime != null) {
            String label16 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label16", (Context)ctx);
            logger.error("EmpElectronicOtherContractUtilsEx.batchCompanySign label16 : " + label16 + "  contractId=" + contractId + "  eContractNO=" + eContractNO + " labParty=" + labParty);
            EmpElectronicOtherContractUtils.pollingProcess(ctx, empOtherEleContractSignRecordInfo, contractId, body, labParty);
        } else {
            logger.error("EmpElectronicOtherContractUtilsEx.batchCompanySign 111    contractId=" + contractId + "  eContractNO=" + eContractNO + "  labParty=" + labParty);
            if (EContractSignState.nosign.equals((Object)empOtherContractInfo.getSignStatus())) {
                logger.error("EmpElectronicOtherContractUtilsEx.batchCompanySign 222    contractId=" + contractId + "  eContractNO=" + eContractNO + " \u52b3\u52a8\u5408\u540c\u4e3b\u4f53 labParty=" + labParty);
                EmpElectronicOtherContractUtilsEx.isPersonSign(ctx, contractId, signType, empOtherEleContractSignRecordInfo, empOtherEleContractSignRecordInfo.getEContractNO(), LAB_PARTYB);
            }
            IEmpOtherEleContractTaskFacade empOtherEleContractTaskFacade = EmpOtherEleContractTaskFacadeFactory.getLocalInstance(ctx);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("labParty", labParty);
            empOtherEleContractTaskFacade.sendCompanySign(empOtherEleContractSignRecordInfo, contractId, param);
            EmpElectronicOtherContractUtils.pollingProcess(ctx, empOtherEleContractSignRecordInfo, contractId, body, labParty);
        }
    }

    public static void isPersonSign(Context ctx, String contractId, int signType, EmpOtherEleContractSignRecordInfo empOtherEleContractSignRecordInfo, String eContractNO, String labParty) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("signStatus"));
        EmployeeOtherContractInfo employeeOtherContractInfo = EmployeeOtherContractFactory.getLocalInstance((Context)ctx).getEmployeeOtherContractInfo((IObjectPK)new ObjectUuidPK(contractId), selector);
        if (EContractSignState.nosign.equals((Object)employeeOtherContractInfo.getSignStatus())) {
            String userId;
            IEmpOtherEleContractServiceFacade empOtherEleContractServiceFacade = EmpOtherEleContractServiceFacadeFactory.getLocalInstance(ctx);
            Object res = null;
            if (empOtherEleContractSignRecordInfo.getPerson() != null) {
                String personId = empOtherEleContractSignRecordInfo.getPerson().getId().toString();
                logger.error("EmpOtherElectronicContractUtilsEx.batchCompanySign checkPersonHashAuth personId : " + personId);
                res = empOtherEleContractServiceFacade.checkPersonHashAuth(personId, null, contractId, eContractNO);
            } else if (empOtherEleContractSignRecordInfo.getPreEntryPerson() != null) {
                String preEntryPersonId = empOtherEleContractSignRecordInfo.getPreEntryPerson().getId().toString();
                logger.error("EmpOtherElectronicContractUtilsEx.batchCompanySign checkPersonHashAuth preEntryPersonId : " + preEntryPersonId);
                res = empOtherEleContractServiceFacade.checkPersonHashAuth(preEntryPersonId, null, contractId, eContractNO);
            }
            logger.error("EmpOtherElectronicContractUtilsEx.batchCompanySign checkPersonHashAuth res : " + (res != null ? res : "null"));
            Map resMap = res != null ? (Map)res : new HashMap();
            String string = userId = resMap.containsKey("userId") ? (String)resMap.get("userId") : "";
            if (!StringUtils.isEmpty((String)userId) && SSCPersonAuthResult.SUCCESS.equals(resMap.get("result"))) {
                String recordId = empOtherEleContractSignRecordInfo.getId().toString();
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("userId", userId);
                param.put("eContractNo", eContractNO);
                param.put("contractId", contractId);
                param.put("recordId", recordId);
                param.put("isQueryCompanySign", false);
                param.put("labParty", labParty);
                Object result = empOtherEleContractServiceFacade.getEmpEleContractSignStatus(param);
                logger.error("EmpOtherElectronicContractUtilsEx.batchCompanySign getEmpEleContractSignStatus result : " + result);
                JSONObject resObj = null;
                resObj = result instanceof JSONObject ? (JSONObject)result : JSONObject.parseObject((String)result.toString());
                int code = resObj.getIntValue("code");
                boolean isPersonSign = false;
                if (code == 0) {
                    JSONObject data = resObj.getJSONObject("data");
                    int signStatus = data.getIntValue("signStatus");
                    if (signStatus == 1) {
                        isPersonSign = true;
                    }
                    if (!isPersonSign) {
                        String label24 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label24", (Context)ctx);
                        throw new BOSException(label24);
                    }
                }
            }
        }
    }

    public static void pollingProcess(Context ctx, EmpOtherEleContractSignRecordInfo empOtherEleContractSignRecordInfo, String contractId, BatchMessageTipsBody body, String labParty) throws InterruptedException, BOSException, EASBizException {
        String label17 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label17", (Context)ctx);
        logger.error("EmpElectronicOtherContractUtilsEx.pollingProcess label17 : " + label17);
        String eContractNO = empOtherEleContractSignRecordInfo.getEContractNO();
        Thread.sleep(2000L);
        IEmployeeOtherContract employeeOtherContractInstance = EmployeeOtherContractFactory.getLocalInstance((Context)ctx);
        EmployeeOtherContractInfo empOtherContractInfo = EmpElectronicOtherContractUtilsEx.getEmployeeOtherContractInfo(employeeOtherContractInstance, contractId);
        KDContractConfigInfo contractAConfigInfo = KDContractConfigFactory.getLocalInstance((Context)ctx).getKDContractConfigInfo("where labContractFirstParty.id='" + empOtherContractInfo.getLabContractFirstParty().getId().toString() + "'");
        String userId = contractAConfigInfo.getClientEnterpriseId();
        KDContractConfigInfo contractBConfigInfo = null;
        LabContractFirstPartyInfo labCParty = empOtherContractInfo.getLabContractCParty();
        if (LAB_PARTYB.equals(labParty) && null != labCParty && null != labCParty.getId()) {
            String labPartId = labCParty.getId().toString();
            contractBConfigInfo = KDContractConfigFactory.getLocalInstance((Context)ctx).getKDContractConfigInfo("where labContractFirstParty.id='" + labPartId + "'");
            userId = contractBConfigInfo.getClientEnterpriseId();
        }
        boolean isbreak = true;
        int times = 0;
        while (isbreak) {
            EmpEleContractCompanyTaskInfo empEleContractCompanyTaskInfo = EmpElectronicOtherContractUtilsEx.getEmpEleContractCompanyTaskInfo(ctx, eContractNO, userId);
            boolean isCallBack = false;
            int resultCode = 0;
            if (empEleContractCompanyTaskInfo != null) {
                String label19 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label19", (Context)ctx);
                logger.error("EmpElectronicContractUtilsEx.pollingProcess label19 : " + label19 + " : " + empEleContractCompanyTaskInfo.getId());
                isCallBack = empEleContractCompanyTaskInfo.isIsCallBack();
                String resultCodeStr = empEleContractCompanyTaskInfo.getResultCode();
                if (!StringUtils.isEmpty((String)resultCodeStr)) {
                    resultCode = Integer.parseInt(resultCodeStr);
                }
            }
            String label18 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label18", (Context)ctx);
            String realObj = MessageFormat.format(label18, ++times);
            logger.error("EmpElectronicContractUtilsEx.pollingProcess label18 : " + realObj);
            if (isCallBack && 0 == resultCode) {
                isbreak = false;
                String label20 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label20", (Context)ctx);
                throw new BOSException(label20);
            }
            if (isCallBack && 1 == resultCode) {
                isbreak = false;
                body.setMuitTipsState(true);
                String label21 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label21", (Context)ctx);
                body.setMuitTipsMessage(label21);
            } else if (!isCallBack && times > 15) {
                isbreak = false;
                String label22 = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label22", (Context)ctx), 15);
                logger.error("EmpElectronicOtherContractUtilsEx.pollingProcess label22 : " + label22);
                logger.error("EmpElectronicOtherContractUtilsEx.pollingProcess  111\u5408\u540cid contractId=" + contractId + "  \u7535\u5b50\u5408\u540c\u53f7eContractNO=" + eContractNO + " \u52b3\u52a8\u5408\u540c\u4e3b\u4f53 labParty=" + labParty);
                String recordId = empOtherEleContractSignRecordInfo.getId().toString();
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("eContractNo", eContractNO);
                param.put("contractId", contractId);
                param.put("recordId", recordId);
                param.put("isQueryCompanySign", true);
                param.put("userId", userId);
                param.put("labParty", labParty);
                logger.error("EmpElectronicOtherContractUtilsEx.pollingProcess param : " + param);
                logger.error("EmpElectronicOtherContractUtilsEx.pollingProcess  222\u5408\u540cid contractId=" + contractId + "  \u7535\u5b50\u5408\u540c\u53f7eContractNO=" + eContractNO + " \u52b3\u52a8\u5408\u540c\u4e3b\u4f53 labParty=" + labParty);
                IEmpOtherEleContractServiceFacade empOtherEleContractServiceFacade = EmpOtherEleContractServiceFacadeFactory.getLocalInstance(ctx);
                Object result = empOtherEleContractServiceFacade.getEmpEleContractSignStatus(param);
                String label23 = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label23", (Context)ctx), result);
                logger.error("EmpElectronicOtherContractUtilsEx.pollingProcess label23 : " + label23);
                logger.error("EmpElectronicOtherContractUtilsEx.pollingProcess  333\u5408\u540cid contractId=" + contractId + "  \u7535\u5b50\u5408\u540c\u53f7eContractNO=" + eContractNO + " \u52b3\u52a8\u5408\u540c\u4e3b\u4f53 labParty=" + labParty);
                JSONObject resObj = null;
                resObj = result instanceof JSONObject ? (JSONObject)result : JSONObject.parseObject((String)result.toString());
                int code = resObj.getIntValue("code");
                if (code == 0) {
                    JSONObject data = resObj.getJSONObject("data");
                    int signStatus = data.getIntValue("signStatus");
                    if (signStatus == 1) {
                        empEleContractCompanyTaskInfo.setUserId(userId);
                        EmpElectronicOtherContractUtilsEx.updateEmpEleContractCompanyTaskInfo(ctx, empEleContractCompanyTaskInfo, true);
                        EmpElectronicOtherContractUtilsEx.updateKDContractConfigRecordState(ctx, eContractNO, userId);
                        if (LAB_PARTYA.equals(labParty)) {
                            IEmployeeOtherContract employeeOtherContractLocalInstance = EmployeeOtherContractFactory.getLocalInstance((Context)ctx);
                            EmployeeOtherContractInfo employeeOtherContractInfo = EmpElectronicOtherContractUtilsEx.getEmployeeOtherContractInfo(employeeOtherContractLocalInstance, contractId);
                            boolean isSigned = true;
                            if (empOtherEleContractSignRecordInfo.getBillId() != null) {
                                isSigned = EmpEleContractFollowUtils.isSignComplete(ctx, empOtherEleContractSignRecordInfo.getBillId().toString());
                            }
                            if (isSigned) {
                                logger.error("EmpElectronicOtherContractUtils_pollingProcess sendSignCompleteMessage ");
                                EmpOtherEleContractSendMessageFacadeFactory.getLocalInstance(ctx).sendSignCompleteMessage(empOtherEleContractSignRecordInfo, employeeOtherContractInfo);
                            }
                        }
                        body.setMuitTipsState(true);
                        String label21 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label21", (Context)ctx);
                        body.setMuitTipsMessage(label21);
                    } else {
                        isbreak = false;
                        String label20 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label20", (Context)ctx);
                        throw new BOSException(label20);
                    }
                }
            }
            if (!isbreak) continue;
            Thread.sleep(2000L);
        }
    }

    public static EmpEleContractCompanyTaskInfo getEmpEleContractCompanyTaskInfo(Context ctx, String eContractNO, String userId) throws BOSException {
        EmpEleContractCompanyTaskInfo empEleContractCompanyTaskInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contractNo", (Object)eContractNO));
        filter.getFilterItems().add(new FilterItemInfo("userId", (Object)userId));
        view.setFilter(filter);
        EmpEleContractCompanyTaskCollection empEleContractCompanyTaskCollection = EmpEleContractCompanyTaskFactory.getLocalInstance(ctx).getEmpEleContractCompanyTaskCollection(view);
        if (empEleContractCompanyTaskCollection.size() > 0) {
            empEleContractCompanyTaskInfo = empEleContractCompanyTaskCollection.get(0);
        }
        return empEleContractCompanyTaskInfo;
    }

    public static void updateEmpEleContractCompanyTaskInfo(Context ctx, EmpEleContractCompanyTaskInfo empEleContractCompanyTaskInfo, boolean isSuccess) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        if (isSuccess) {
            Timestamp curTimestamp = EmpElectronicContractUtilsEx.getCurTimestamp();
            empEleContractCompanyTaskInfo.setIsCallBack(true);
            empEleContractCompanyTaskInfo.setCallBackTime(curTimestamp);
            empEleContractCompanyTaskInfo.setResultCode("1");
            empEleContractCompanyTaskInfo.setResultDesc("");
            empEleContractCompanyTaskInfo.setIsFinish(true);
            empEleContractCompanyTaskInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
            empEleContractCompanyTaskInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
            selector.add(new SelectorItemInfo("isCallBack"));
            selector.add(new SelectorItemInfo("callbackTime"));
            selector.add(new SelectorItemInfo("resultCode"));
            selector.add(new SelectorItemInfo("resultDesc"));
            selector.add(new SelectorItemInfo("userId"));
            selector.add(new SelectorItemInfo("isFinish"));
            selector.add(new SelectorItemInfo("lastUpdateTime"));
            selector.add(new SelectorItemInfo("lastUpdateUser"));
            EmpEleContractCompanyTaskFactory.getLocalInstance(ctx).updatePartial(empEleContractCompanyTaskInfo, selector);
        } else {
            empEleContractCompanyTaskInfo.setIsRequest(false);
            empEleContractCompanyTaskInfo.setRequestTime(null);
            empEleContractCompanyTaskInfo.setIsCallBack(false);
            empEleContractCompanyTaskInfo.setCallBackTime(null);
            empEleContractCompanyTaskInfo.setResultCode("0");
            empEleContractCompanyTaskInfo.setResultDesc("");
            empEleContractCompanyTaskInfo.setIsFinish(false);
            empEleContractCompanyTaskInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
            empEleContractCompanyTaskInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
            selector.add(new SelectorItemInfo("isRequest"));
            selector.add(new SelectorItemInfo("requestTime"));
            selector.add(new SelectorItemInfo("isCallBack"));
            selector.add(new SelectorItemInfo("callbackTime"));
            selector.add(new SelectorItemInfo("resultCode"));
            selector.add(new SelectorItemInfo("resultDesc"));
            selector.add(new SelectorItemInfo("isFinish"));
            selector.add(new SelectorItemInfo("lastUpdateTime"));
            selector.add(new SelectorItemInfo("lastUpdateUser"));
            EmpEleContractCompanyTaskFactory.getLocalInstance(ctx).updatePartial(empEleContractCompanyTaskInfo, selector);
        }
    }

    public static void updateKDContractConfigRecordState(Context ctx, String eContractNO, String userId) throws EASBizException, BOSException {
        KDContractConfigInfo configInfo;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("fileNo"));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("result"));
        filterInfo.getFilterItems().add(new FilterItemInfo("fileNo", (Object)eContractNO));
        filterInfo.getFilterItems().add(new FilterItemInfo("result", (Object)false));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)2));
        if (!StringUtils.isEmpty((String)userId) && (configInfo = ElectronicContractUtils.getKDContractConfigByEnterpriseId((Context)ctx, (String)userId)) != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("config.id", (Object)configInfo.getId().toString()));
        }
        view.setFilter(filterInfo);
        view.setSelector(selector);
        IKDContractConfigRecord ikdContractConfigRecord = KDContractConfigRecordFactory.getLocalInstance((Context)ctx);
        KDContractConfigRecordCollection recordCollection = ikdContractConfigRecord.getKDContractConfigRecordCollection(view);
        if (recordCollection != null && recordCollection.size() > 0) {
            logger.error("EmpElectronicOtherContractUtilsEx.updateKDContractConfigRecordState eContractNo : " + eContractNO);
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("state"));
            selector.add(new SelectorItemInfo("result"));
            selector.add(new SelectorItemInfo("lastUpdateTime"));
            selector.add(new SelectorItemInfo("lastUpdateUser"));
            KDContractConfigRecordInfo recordInfo = recordCollection.get(0);
            recordInfo.setResult(true);
            recordInfo.setState(BaseItemStateEnum.ENABLE);
            recordInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
            recordInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
            ikdContractConfigRecord.updatePartial(recordInfo, selector);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void batchContractOver(Context ctx, String contractId, String signStatusString, BatchMessageTipsBody body, Boolean isPreEntry) throws BOSException, EASBizException {
        IEmpOtherEleContractSignRecord empEleContractSignRecordLocalInstance = EmpOtherEleContractSignRecordFactory.getLocalInstance(ctx);
        String operation = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label29", (Context)ctx);
        EmpElectronicOtherContractUtilsEx.checkEmpEleContractSignRecordSignStatus(signStatusString, operation, false);
        EmpOtherEleContractSignRecordInfo empEleContractSignRecordInfo = EmpElectronicOtherContractUtilsEx.getEmpOtherEleContractSignRecordInfo(empEleContractSignRecordLocalInstance, contractId);
        if (empEleContractSignRecordInfo == null) throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_CANNOT_OVER);
        EContractSignState signStatus = empEleContractSignRecordInfo.getSignStatus();
        if (signStatus == null) {
            throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_SIGNSTATUS_IS_NULL);
        }
        if (0 == signStatus.getValue()) {
            empEleContractSignRecordInfo.setSignStatus(EContractSignState.employeesignover);
            empEleContractSignRecordInfo.setIsInvalid(Boolean.TRUE);
            empEleContractSignRecordInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
            empEleContractSignRecordInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("signStatus"));
            selector.add(new SelectorItemInfo("isInvalid"));
            selector.add(new SelectorItemInfo("lastUpdateTime"));
            selector.add(new SelectorItemInfo("lastUpdateUser"));
            empEleContractSignRecordLocalInstance.updatePartial(empEleContractSignRecordInfo, selector);
            EmpElectronicOtherContractUtilsEx.updateOtherEmployeeContractSignStatus(ctx, contractId, EContractSignState.employeesignover);
            logger.error("EmpElectronicOtherContractUtilsEx.batchContractOver NOSIGN_VALUE signState : contractId = " + contractId);
            if (empEleContractSignRecordInfo.getEntryId() != null) {
                EmpEleContractFollowUtils.updateOtherFollowPreNewConEntrySignStatus(ctx, empEleContractSignRecordInfo.getEntryId().toString(), EContractSignState.employeesignover);
            }
            body.setMuitTipsState(Boolean.TRUE.booleanValue());
            String label21 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label21", (Context)ctx);
            body.setMuitTipsMessage(label21);
            return;
        } else if (1 == signStatus.getValue() || 6 == signStatus.getValue()) {
            empEleContractSignRecordInfo.setSignStatus(EContractSignState.enterprisesignover);
            empEleContractSignRecordInfo.setIsInvalid(Boolean.TRUE);
            empEleContractSignRecordInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
            empEleContractSignRecordInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("signStatus"));
            selector.add(new SelectorItemInfo("isInvalid"));
            selector.add(new SelectorItemInfo("lastUpdateTime"));
            selector.add(new SelectorItemInfo("lastUpdateUser"));
            empEleContractSignRecordLocalInstance.updatePartial(empEleContractSignRecordInfo, selector);
            EmpElectronicOtherContractUtilsEx.updateOtherEmployeeContractSignStatus(ctx, contractId, EContractSignState.enterprisesignover);
            logger.error("EmpElectronicOtherContractUtilsEx.batchContractOver  signState : contractId = " + contractId);
            if (empEleContractSignRecordInfo.getEntryId() != null) {
                EmpEleContractFollowUtils.updateOtherFollowPreNewConEntrySignStatus(ctx, empEleContractSignRecordInfo.getEntryId().toString(), EContractSignState.enterprisesignover);
            }
            body.setMuitTipsState(Boolean.TRUE.booleanValue());
            String label21 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label21", (Context)ctx);
            body.setMuitTipsMessage(label21);
            return;
        } else if (2 == signStatus.getValue()) {
            if (!isPreEntry.booleanValue() || empEleContractSignRecordInfo.getBillId() == null) throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_IS_ALREADY_COMPLETED);
            HRBillBaseInfo billBaseInfo = null;
            BOSUuid billBosId = empEleContractSignRecordInfo.getBillId();
            if (billBosId != null) {
                IHRBillBase billBase = (IHRBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)billBosId.getType());
                billBaseInfo = billBase.getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billBosId));
            }
            if (!(billBaseInfo instanceof ContractPreNewSignBizBillInfo)) return;
            ContractPreNewSignBizBillInfo conPreNewSignBBInfo = (ContractPreNewSignBizBillInfo)billBaseInfo;
            EmpElectronicOtherContractUtilsEx.OtherContractOverByTotalState(ctx, empEleContractSignRecordInfo, contractId, conPreNewSignBBInfo.getTotalState(), body);
            return;
        } else {
            if (3 != signStatus.getValue() && 4 != signStatus.getValue()) return;
            throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_IS_ALREADY_TERMINATED);
        }
    }

    public static void OtherContractOverByTotalState(Context ctx, EmpOtherEleContractSignRecordInfo empOtherEleConSignRecordInfo, String contractId, EContractSignState signStatusString, BatchMessageTipsBody body) throws BOSException, EASBizException {
        IEmpOtherEleContractSignRecord empEleContractSignRecordLocalInstance = EmpOtherEleContractSignRecordFactory.getLocalInstance(ctx);
        if (0 == signStatusString.getValue()) {
            empOtherEleConSignRecordInfo.setSignStatus(EContractSignState.employeesignover);
            empOtherEleConSignRecordInfo.setIsInvalid(Boolean.TRUE);
            empOtherEleConSignRecordInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
            empOtherEleConSignRecordInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("signStatus"));
            selector.add(new SelectorItemInfo("isInvalid"));
            selector.add(new SelectorItemInfo("lastUpdateTime"));
            selector.add(new SelectorItemInfo("lastUpdateUser"));
            empEleContractSignRecordLocalInstance.updatePartial(empOtherEleConSignRecordInfo, selector);
            EmpElectronicOtherContractUtilsEx.updateOtherEmployeeContractSignStatus(ctx, contractId, EContractSignState.employeesignover);
            logger.error("EmpElectronicOtherContractUtilsEx.batchContractOver NOSIGN_VALUE signState : contractId = " + contractId);
            if (empOtherEleConSignRecordInfo.getEntryId() != null) {
                EmpEleContractFollowUtils.updateOtherFollowPreNewConEntrySignStatus(ctx, empOtherEleConSignRecordInfo.getEntryId().toString(), EContractSignState.employeesignover);
            }
            body.setMuitTipsState(Boolean.TRUE.booleanValue());
            String label21 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label21", (Context)ctx);
            body.setMuitTipsMessage(label21);
        } else if (1 == signStatusString.getValue()) {
            empOtherEleConSignRecordInfo.setSignStatus(EContractSignState.enterprisesignover);
            empOtherEleConSignRecordInfo.setIsInvalid(Boolean.TRUE);
            empOtherEleConSignRecordInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
            empOtherEleConSignRecordInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("signStatus"));
            selector.add(new SelectorItemInfo("isInvalid"));
            selector.add(new SelectorItemInfo("lastUpdateTime"));
            selector.add(new SelectorItemInfo("lastUpdateUser"));
            empEleContractSignRecordLocalInstance.updatePartial(empOtherEleConSignRecordInfo, selector);
            EmpElectronicOtherContractUtilsEx.updateOtherEmployeeContractSignStatus(ctx, contractId, EContractSignState.enterprisesignover);
            logger.error("EmpElectronicOtherContractUtilsEx.batchContractOver  signState : contractId = " + contractId);
            if (empOtherEleConSignRecordInfo.getEntryId() != null) {
                EmpEleContractFollowUtils.updateOtherFollowPreNewConEntrySignStatus(ctx, empOtherEleConSignRecordInfo.getEntryId().toString(), EContractSignState.enterprisesignover);
            }
            body.setMuitTipsState(Boolean.TRUE.booleanValue());
            String label21 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label21", (Context)ctx);
            body.setMuitTipsMessage(label21);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void batchAbandonContract(Context ctx, String contractId, BatchMessageTipsBody body) throws BOSException, EASBizException {
        IEmpOtherEleContractSignRecord empEleContractSignRecordLocalInstance = EmpOtherEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpElectronicOtherContractUtilsEx.checkEmployeeContractContractClassify(ctx, contractId);
        EmpOtherEleContractSignRecordInfo empEleContractSignRecordInfo = EmpElectronicOtherContractUtilsEx.getOtherEmpEleContractSignRecordInfo(empEleContractSignRecordLocalInstance, contractId);
        if (empEleContractSignRecordInfo == null) throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_CANNOT_ABANDON);
        EContractSignState signStatus = empEleContractSignRecordInfo.getSignStatus();
        if (signStatus == null) {
            throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_SIGNSTATUS_IS_NULL);
        }
        if (2 != signStatus.getValue()) throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_IS_SIGNING);
        empEleContractSignRecordInfo.setSignStatus(EContractSignState.abandon);
        empEleContractSignRecordInfo.setIsInvalid(Boolean.TRUE);
        empEleContractSignRecordInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
        empEleContractSignRecordInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("signStatus"));
        selector.add(new SelectorItemInfo("isInvalid"));
        selector.add(new SelectorItemInfo("lastUpdateTime"));
        selector.add(new SelectorItemInfo("lastUpdateUser"));
        empEleContractSignRecordLocalInstance.updatePartial(empEleContractSignRecordInfo, selector);
        EmpElectronicOtherContractUtilsEx.updateOtherEmployeeContractSignStatus(ctx, contractId, EContractSignState.abandon);
        if (empEleContractSignRecordInfo.getEntryId() != null) {
            EmpEleContractFollowUtils.updateOtherFollowPreNewConEntrySignStatus(ctx, empEleContractSignRecordInfo.getEntryId().toString(), EContractSignState.abandon);
        }
        EmpElectronicContractUtilsEx.deleteEmpEleContractSHRAttachmentExt(ctx, contractId);
        body.setMuitTipsState(Boolean.TRUE.booleanValue());
        String label21 = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.EmpEleContractResource", (String)"label21", (Context)ctx);
        body.setMuitTipsMessage(label21);
    }

    public static void checkEmployeeContractContractClassify(Context ctx, String contractId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)contractId));
        view.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("contractClassify"));
        view.setSelector(selector);
        EmployeeOtherContractCollection employeeContractCollection = EmployeeOtherContractFactory.getLocalInstance((Context)ctx).getEmployeeOtherContractCollection(view);
        EmployeeOtherContractInfo employeeContractInfo = null;
        if (employeeContractCollection != null && employeeContractCollection.size() > 0) {
            employeeContractInfo = employeeContractCollection.get(0);
        }
        if (employeeContractInfo == null || employeeContractInfo.getContractClassify() == null) {
            if (employeeContractInfo != null) {
                logger.error("EmpElectronicOtherContractUtilsEx.checkEmployeeContractContractClassify  employeeContractInfo : " + employeeContractInfo.getId() + " contractClassify() : " + employeeContractInfo.getContractClassify());
            } else {
                logger.error("EmpElectronicOtherContractUtilsEx.checkEmployeeContractContractClassify  employeeContractInfo is null ");
            }
            throw new EmpEleContractException(EmpEleContractException.GET_EMPLOYEE_IS_NULL_BY_CONTRACTID, new Object[]{contractId});
        }
        if (1 == employeeContractInfo.getContractClassify().getValue()) {
            throw new EmpEleContractException(EmpEleContractException.BATCHABANDONCONTRACT_FAIL_FOR_SSC_CONTRACT);
        }
    }

    public static void updateOtherFollowPreNewConEntrySignStatus(Context ctx, OtherFollowPreNewConEntryInfo otherFollowPreNewConEntryInfo, EContractSignState signState) throws EASBizException, BOSException {
        IOtherFollowPreNewConEntry otherFollowPreNewConEntryLocalInstance = OtherFollowPreNewConEntryFactory.getLocalInstance(ctx);
        if (otherFollowPreNewConEntryInfo != null) {
            otherFollowPreNewConEntryInfo.setSignState(signState);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("signState"));
            otherFollowPreNewConEntryLocalInstance.updatePartial(otherFollowPreNewConEntryInfo, selector);
        }
    }

    public static void deleteEmpEleContractSignRecordInfo(IEmpOtherEleContractSignRecord contractOtherSignRecordInstance, String contractId) throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)contractId)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("contract.id", (Object)contractId));
            contractOtherSignRecordInstance.delete(filter);
        }
    }

    public static void deleteContractBillMiddle(IContractBillMiddle contractBillMiddleInstance, String contractId) throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)contractId)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("contractId", (Object)contractId));
            contractBillMiddleInstance.delete(filter);
        }
    }
}

