/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.contract.ContractBillBaseInfo;
import com.kingdee.eas.hr.contract.ContractBizException;
import com.kingdee.eas.hr.contract.ContractException;
import com.kingdee.eas.hr.contract.ContractPreSignBizBillEntryCollection;
import com.kingdee.eas.hr.contract.ContractPreSignBizBillEntryFactory;
import com.kingdee.eas.hr.contract.ContractPreSignBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractPreSignBizBillInfo;
import com.kingdee.eas.hr.contract.EContractSignState;
import com.kingdee.eas.hr.contract.ElectronicContractRelationFactory;
import com.kingdee.eas.hr.contract.HRContractInfoCollection;
import com.kingdee.eas.hr.contract.HRContractInfoFactory;
import com.kingdee.eas.hr.contract.HRContractInfoInfo;
import com.kingdee.eas.hr.contract.IContractPreSignBizBillEntry;
import com.kingdee.eas.hr.contract.IHRContractInfo;
import com.kingdee.eas.hr.contract.IOtherFollowPreConEntry;
import com.kingdee.eas.hr.contract.OtherFollowPreConEntryCollection;
import com.kingdee.eas.hr.contract.OtherFollowPreConEntryFactory;
import com.kingdee.eas.hr.contract.OtherFollowPreConEntryInfo;
import com.kingdee.eas.hr.contract.app.AbstractContractPreSignBizBillControllerBean;
import com.kingdee.eas.hr.contract.app.ContractPreSignBillBizBean;
import com.kingdee.eas.hr.contract.util.ContractUtils;
import com.kingdee.eas.hr.contract.util.HRContractInfoUtils;
import com.kingdee.eas.hr.emp.ContractClassifyEnum;
import com.kingdee.eas.hr.emp.ContractLimitTypeEnum;
import com.kingdee.eas.hr.emp.ContractTempletFactory;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.ContractTypeFactory;
import com.kingdee.eas.hr.emp.ContractTypeInfo;
import com.kingdee.eas.hr.emp.EmployeeContractCollection;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.EmployeeContractNewStateEnum;
import com.kingdee.eas.hr.emp.EmployeeContractSourceStateEnum;
import com.kingdee.eas.hr.emp.EmployeeContractState;
import com.kingdee.eas.hr.emp.EmployeeOtherContractFactory;
import com.kingdee.eas.hr.emp.EmployeeOtherContractInfo;
import com.kingdee.eas.hr.emp.IEmployeeContract;
import com.kingdee.eas.hr.emp.IEmployeeOtherContract;
import com.kingdee.eas.hr.emp.LabContractFirstPartyFactory;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.elecontract.util.ElectronicContractUtils;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ContractPreSignBizBillControllerBean
extends AbstractContractPreSignBizBillControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(ContractPreSignBizBillControllerBean.class);

    protected String getBillField() {
        return "bill";
    }

    protected String getEntryField() {
        return "entrys";
    }

    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.contract.app.ContractPreSignBizBillEffectFunction";
    }

    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return ContractPreSignBizBillEntryFactory.getLocalInstance(ctx);
    }

    protected IHRBillBizBean getBizBean() {
        return new ContractPreSignBillBizBean();
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ContractPreSignBizBillInfo csbbInfo = (ContractPreSignBizBillInfo)model;
        this.checkPersonHasFutureContract(ctx, csbbInfo);
        this.checkBeforeAddnewOrUpdate(ctx, csbbInfo);
        IObjectPK objectPk = super._addnew(ctx, model);
        this.addNewHrContractInfo(ctx, csbbInfo, objectPk);
        return objectPk;
    }

    private void checkBeforeAddnewOrUpdate(Context ctx, ContractPreSignBizBillInfo csbbInfo) throws ContractException, BOSException, EASBizException {
        this.checkToUnit(csbbInfo);
        this.checkDate(ctx, csbbInfo);
        this.checkPersonAndContractType(csbbInfo);
        this.checkContNoIsRepeat(ctx, csbbInfo);
        this.checkHasContractByDate(ctx, (IObjectValue)csbbInfo);
        this.checkProbation(ctx, csbbInfo);
        this.checkLabPartyIsOpenElec(ctx, csbbInfo);
    }

    @Override
    protected void setNumberFromCodingRule(Context ctx, HRBillBaseInfo model) throws BOSException, EASBizException {
        super.setNumberFromCodingRule(ctx, model);
        if (model instanceof ContractPreSignBizBillInfo) {
            OtherFollowPreConEntryCollection otherEntries;
            ContractPreSignBizBillInfo billInfo = (ContractPreSignBizBillInfo)model;
            ContractPreSignBizBillEntryCollection entries = billInfo.getEntrys();
            CtrlUnitInfo curCuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            if (entries != null) {
                ContractPreSignBizBillEntryInfo entry = null;
                EmployeeContractInfo contractInfo = new EmployeeContractInfo();
                String number = null;
                String orgID = curCuInfo.getId().toString();
                int size = entries.size();
                for (int i = 0; i < size; ++i) {
                    entry = entries.get(i);
                    contractInfo.setContractNo(billInfo.getNumber());
                    contractInfo.setPreEntryPerson(entry.getPerson());
                    contractInfo.setContractTemplet(entry.getContractTemplet());
                    ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                    if (StringUtils.isEmpty((String)orgID) || !iCodingRuleManager.isExist((IObjectValue)contractInfo, orgID)) continue;
                    number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)contractInfo, orgID);
                    while (this.isEmpContractNumberExist(ctx, number)) {
                        number = iCodingRuleManager.getNumber((IObjectValue)contractInfo, orgID);
                    }
                    if (number == null) continue;
                    entry.setContractNo(number);
                }
            }
            if ((otherEntries = ((ContractPreSignBizBillInfo)model).getOtherEntrys()) != null) {
                OtherFollowPreConEntryInfo otherEntry = null;
                EmployeeOtherContractInfo contractInfo = new EmployeeOtherContractInfo();
                String number = null;
                String orgID = curCuInfo.getId().toString();
                int size = otherEntries.size();
                for (int i = 0; i < size; ++i) {
                    otherEntry = otherEntries.get(i);
                    if (!StringUtils.isEmpty((String)otherEntry.getContractNo())) continue;
                    contractInfo.setContractNo(billInfo.getNumber());
                    contractInfo.setPreEntryPerson(otherEntry.getPerson());
                    contractInfo.setContractTemplet(otherEntry.getContractTemplet());
                    ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                    if (StringUtils.isEmpty((String)orgID) || !iCodingRuleManager.isExist((IObjectValue)contractInfo, orgID)) continue;
                    number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)contractInfo, orgID);
                    while (this.isEmpOtherContractNumberExist(ctx, number)) {
                        number = iCodingRuleManager.getNumber((IObjectValue)contractInfo, orgID);
                    }
                    if (number == null) continue;
                    otherEntry.setContractNo(number);
                }
            }
        }
        this.updateContractPreSignBillEntryContractNo(ctx, (ContractPreSignBizBillInfo)model);
    }

    protected void preProcess(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model instanceof ContractPreSignBizBillInfo) {
            ContractPreSignBizBillInfo oldContractSignBizBillInfo = this.getContractPreSignBizBillInfo(ctx, pk);
            ContractPreSignBizBillEntryCollection oldEntries = null;
            if (oldContractSignBizBillInfo != null) {
                oldEntries = oldContractSignBizBillInfo.getEntrys();
            }
            ContractPreSignBizBillEntryCollection entries = ((ContractPreSignBizBillInfo)model).getEntrys();
            ContractPreSignBizBillEntryInfo oldEntry = null;
            ContractPreSignBizBillEntryInfo entry = null;
            EmployeeContractInfo contractInfo = null;
            if (oldEntries != null) {
                boolean isDelete = true;
                int oldsize = oldEntries.size();
                for (int i = 0; i < oldsize; ++i) {
                    oldEntry = oldEntries.get(i);
                    if (entries != null) {
                        int size = entries.size();
                        for (int j = 0; j < size; ++j) {
                            entry = entries.get(j);
                            if (!oldEntry.getId().equals((Object)entry.getId())) continue;
                            isDelete = false;
                            break;
                        }
                    }
                    if (isDelete) {
                        contractInfo = new EmployeeContractInfo();
                        contractInfo.setContractNo(((ContractPreSignBizBillInfo)model).getNumber());
                        contractInfo.setPreEntryPerson(entry == null ? null : entry.getPerson());
                        contractInfo.setContractTemplet(entry == null ? null : entry.getContractTemplet());
                        this._dispachIntermitNumber(ctx, oldEntry, contractInfo);
                        continue;
                    }
                    isDelete = true;
                }
            }
        }
    }

    private void _dispachIntermitNumber(Context ctx, ContractPreSignBizBillEntryInfo entry, EmployeeContractInfo contractInfo) throws BOSException, EASBizException {
        if (entry != null && entry.getContractNo() != null) {
            CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx).recycleNumber((IObjectValue)contractInfo, null, entry.getContractNo());
        }
    }

    protected void _dispachIntermitNumber(Context ctx, IObjectPK pk) throws CodingRuleException, EASBizException, BOSException {
        ContractPreSignBizBillEntryCollection entries;
        super._dispachIntermitNumber(ctx, pk);
        ContractPreSignBizBillInfo contractsignbizbillInfo = this.getContractPreSignBizBillInfo(ctx, pk);
        if (contractsignbizbillInfo != null && (entries = contractsignbizbillInfo.getEntrys()) != null) {
            ContractPreSignBizBillEntryInfo entry = null;
            EmployeeContractInfo contractInfo = new EmployeeContractInfo();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = entries.get(i);
                if (entry.getContractNo() == null) continue;
                contractInfo.setContractNo(contractsignbizbillInfo.getNumber());
                contractInfo.setPreEntryPerson(entry.getPerson());
                contractInfo.setContractTemplet(entry.getContractTemplet());
                CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx).recycleNumber((IObjectValue)contractInfo, null, entry.getContractNo());
            }
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ContractPreSignBizBillInfo csbbInfo = (ContractPreSignBizBillInfo)model;
        this.checkBeforeAddnewOrUpdate(ctx, csbbInfo);
        this.preProcess(ctx, pk, model);
        super._update(ctx, pk, model);
        this.updateHrContractInfo(ctx, csbbInfo, pk);
    }

    private void checkToUnit(ContractPreSignBizBillInfo csbbInfo) throws ContractException {
    }

    private void checkDate(Context ctx, ContractPreSignBizBillInfo csbbInfo) throws EASBizException, BOSException {
        ContractPreSignBizBillEntryInfo csbbeInfo = null;
        int size = csbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            csbbeInfo = csbbInfo.getEntrys().get(i);
            String personParm = ContractUtils.getPersonInfo(ctx, csbbeInfo.getPerson().getId().toString());
            if (ContractLimitTypeEnum.FIXED_LIMIT.equals((Object)csbbeInfo.getContractLimitType()) && csbbeInfo.getEndDate() == null) {
                throw new ContractException(ContractException.ENDDATE_ISNULL, new Object[]{personParm});
            }
            if (csbbeInfo.getEndDate() != null) {
                if (DateTimeUtils.dayAfter((Date)csbbeInfo.getBizDate(), (Date)csbbeInfo.getEndDate())) {
                    throw new ContractException(ContractException.BIZDATE_AFTER_ENDDATE, new Object[]{personParm});
                }
                if (DateTimeUtils.dayAfter((Date)csbbeInfo.getSignDate(), (Date)csbbeInfo.getEndDate())) {
                    throw new ContractException(ContractException.SIGNDATE_AFTER_ENDDATE, new Object[]{personParm});
                }
            }
            if (csbbeInfo.getPenalty() != null && csbbeInfo.getPenalty().compareTo(ContractUtils.ZERO) < 0) {
                throw new ContractException(ContractException.PENALTY_ISMINUS, new Object[]{personParm});
            }
            if (csbbeInfo.getCompensation() != null && csbbeInfo.getCompensation().compareTo(ContractUtils.ZERO) < 0) {
                throw new ContractException(ContractException.COMPENSATION_ISMINUS, new Object[]{personParm});
            }
            if (csbbeInfo.getContinuousSignedCount() < 0) {
                throw new ContractException(ContractException.CONTINUESIGNCOUNT_ISMINUS, new Object[]{personParm});
            }
            if (csbbeInfo.getContractTemplet().getInvalidDate() == null || !DateTimeUtils.dayBefore((Date)csbbeInfo.getContractTemplet().getInvalidDate(), (Date)new Date())) continue;
            throw new ContractException(ContractException.CONTEMPLET_INVALID, new Object[]{personParm});
        }
    }

    private void checkPersonAndContractType(ContractPreSignBizBillInfo csbbInfo) throws ContractException {
        ContractPreSignBizBillEntryInfo csbbeInfo1 = null;
        ContractPreSignBizBillEntryInfo csbbeInfo2 = null;
        int size = csbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            int j;
            csbbeInfo1 = csbbInfo.getEntrys().get(i);
            boolean isNotSamePerson = false;
            boolean isNotSameContractType = false;
            int rowNum = csbbInfo.getEntrys().size();
            for (j = 0; j < rowNum; ++j) {
                csbbeInfo2 = csbbInfo.getEntrys().get(j);
                if (i == j || csbbeInfo1.getPerson().equals((Object)csbbeInfo2.getPerson())) continue;
                isNotSamePerson = true;
                break;
            }
            rowNum = csbbInfo.getEntrys().size();
            for (j = 0; j < rowNum; ++j) {
                csbbeInfo2 = csbbInfo.getEntrys().get(j);
                if (i == j || csbbeInfo1.getContractType().equals((Object)csbbeInfo2.getContractType())) continue;
                isNotSameContractType = true;
                break;
            }
            if (!isNotSamePerson || !isNotSameContractType) continue;
            throw new ContractException(ContractException.SAVELOSE);
        }
    }

    private void checkContNoIsRepeat(Context ctx, ContractPreSignBizBillInfo csbbInfo) throws BOSException, EASBizException {
        CtrlUnitInfo curCuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String orgID = curCuInfo.getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        EmployeeContractInfo contractInfo = new EmployeeContractInfo();
        if (!(!StringUtils.isEmpty((String)orgID) && iCodingRuleManager.isExist((IObjectValue)contractInfo, orgID))) {
            IEmployeeContract employeeContract = EmployeeContractFactory.getLocalInstance((Context)ctx);
            IContractPreSignBizBillEntry iCSBBE = ContractPreSignBizBillEntryFactory.getLocalInstance(ctx);
            EmployeeContractCollection ecCol = null;
            int size = csbbInfo.getEntrys().size();
            for (int i = 0; i < size; ++i) {
                ContractPreSignBizBillEntryInfo csbbeInfo = csbbInfo.getEntrys().get(i);
                StringBuffer sql = new StringBuffer();
                sql.append("select id where contractNo = '" + csbbeInfo.getContractNo() + "' ");
                ecCol = employeeContract.getEmployeeContractCollection(sql.toString());
                StringBuffer whereStr = new StringBuffer("where contractNo = '");
                whereStr.append(csbbeInfo.getContractNo());
                if (csbbInfo.getId() != null) {
                    whereStr.append("' and bill <> '");
                    whereStr.append(csbbInfo.getId().toString());
                }
                whereStr.append("' and (bill.billState in (0, 1, 2) or (bill.billState = 3 and bizDate >= ");
                whereStr.append(HRUtil.getCurrentDate());
                whereStr.append("))");
                ContractPreSignBizBillEntryCollection csbbCol = iCSBBE.getContractPreSignBizBillEntryCollection(whereStr.toString());
                if (ecCol.size() <= 0 && csbbCol.size() <= 0) continue;
                throw new ContractException(ContractException.CONTRACTNO_REPEAT, new Object[]{csbbeInfo.getContractNo()});
            }
        }
    }

    private void checkHasContractByDate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ContractPreSignBizBillInfo csbbInfo = (ContractPreSignBizBillInfo)model;
        int size = csbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            ContractPreSignBizBillEntryInfo csbbeInfo = csbbInfo.getEntrys().get(i);
            ContractTypeInfo contractTypeInfo = ContractTypeFactory.getLocalInstance((Context)ctx).getContractTypeInfo((IObjectPK)new ObjectUuidPK(csbbeInfo.getContractType().getId().toString()));
            if (!contractTypeInfo.isIsLaborContract()) continue;
            HRContractInfoInfo contractInfo = new HRContractInfoInfo();
            contractInfo.setBillID(csbbInfo.getId());
            contractInfo.setPreEntryPerson(csbbeInfo.getPerson());
            contractInfo.setEffectDate(csbbeInfo.getBizDate());
            contractInfo.setContractLimitType(csbbeInfo.getContractLimitType());
            contractInfo.setEndDate(csbbeInfo.getEndDate());
            contractInfo.put("hrOrgUnit", csbbInfo.getHrOrgUnit());
            HashSet<String> excludeContractNo = new HashSet<String>();
            excludeContractNo.add(csbbeInfo.getContractNo());
            ContractUtils.checkContractTimeIsCrossing(ctx, contractInfo, excludeContractNo, false);
        }
    }

    private void checkPersonHasFutureContract(Context ctx, ContractPreSignBizBillInfo csbbInfo) throws EASBizException, BOSException {
        ContractPreSignBizBillEntryInfo csbbeInfo = null;
        int size = csbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            csbbeInfo = csbbInfo.getEntrys().get(i);
            ContractUtils.checkPreEntryPersonHasFutureContract(ctx, csbbeInfo.getPerson().getId().toString());
        }
    }

    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        Date effectDate;
        Date now;
        ContractPreSignBizBillEntryInfo csbbeInfo = (ContractPreSignBizBillEntryInfo)entry;
        ContractPreSignBizBillInfo billInfo = csbbeInfo.getBill();
        billInfo = (ContractPreSignBizBillInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()));
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_HR_EmployeeContract where fcontractno = '").append(csbbeInfo.getContractNo()).append("'").append(" and FPreEntryPersonId='").append(csbbeInfo.getPerson().getId()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        LabContractFirstPartyInfo firstParty = billInfo.getLabContractFirstParty();
        if (rs.size() == 0) {
            EmployeeContractInfo employeeContract = new EmployeeContractInfo();
            employeeContract.setContractNo(csbbeInfo.getContractNo());
            employeeContract.setPreEntryPerson(csbbeInfo.getPerson());
            employeeContract.setContractTemplet(csbbeInfo.getContractTemplet());
            employeeContract.setRecordDate(csbbeInfo.getSignDate());
            employeeContract.setEffectDate(csbbeInfo.getBizDate());
            employeeContract.setEndDate(csbbeInfo.getEndDate());
            employeeContract.setDescription(csbbeInfo.getDescription());
            employeeContract.setState(EmployeeContractState.RECORD);
            employeeContract.setReason(csbbeInfo.getSignReason());
            employeeContract.setToUnit(billInfo.getToUnit());
            employeeContract.setDelegatePerson(billInfo.getDelegatePersonText(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            employeeContract.setDelegatePerson(billInfo.getDelegatePersonText(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            employeeContract.setDelegatePerson(billInfo.getDelegatePersonText(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            employeeContract.setToUnitAddress(billInfo.getToUnitAddress(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            employeeContract.setToUnitAddress(billInfo.getToUnitAddress(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            employeeContract.setToUnitAddress(billInfo.getToUnitAddress(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            employeeContract.setEmpIdentityNum(csbbeInfo.getIdCardNo());
            employeeContract.setEmpAddress(csbbeInfo.getAdrress());
            employeeContract.setEmpPassPortNum(csbbeInfo.getPassportNo());
            employeeContract.setHrOrgUnit(billInfo.getHrOrgUnit());
            employeeContract.setContSerLimit(csbbeInfo.getContractServerLimit());
            employeeContract.setVip(false);
            employeeContract.setTestBeginDate(csbbeInfo.getTestBeginDate());
            employeeContract.setTestEndDate(csbbeInfo.getTestEndDate());
            employeeContract.setNewState(EmployeeContractNewStateEnum.RECORDED);
            employeeContract.setContractLimitType(csbbeInfo.getContractLimitType());
            employeeContract.setThirdDelegatePerson(billInfo.getThirdDelegatePerson());
            employeeContract.setThirdUnitName(billInfo.getThirdUnit());
            employeeContract.setThirdUnitAddress(billInfo.getThirdUnitAddress());
            if (!StringUtils.isEmpty((String)csbbeInfo.getContractLimit())) {
                employeeContract.setContractLimitAuto(new BigDecimal(csbbeInfo.getContractLimit()));
            }
            employeeContract.setPenalty(csbbeInfo.getPenalty());
            employeeContract.setCompensation(csbbeInfo.getCompensation());
            employeeContract.setAppraisal(csbbeInfo.getAppraisal());
            employeeContract.setAppraDate(csbbeInfo.getAppraDate());
            employeeContract.setIsInAdmin(billInfo.isIsInAdmin());
            employeeContract.setContractSourceState(EmployeeContractSourceStateEnum.FROM_ADDED);
            employeeContract.setIsContinuousSigned(true);
            employeeContract.setContinuousSignedCount(1);
            employeeContract.setPositionString(csbbeInfo.getPositionString());
            employeeContract.setContractAgreedSalary(csbbeInfo.getContractAgreedSalary());
            employeeContract.setLabContractFirstParty(firstParty);
            employeeContract.setAdminOrg(csbbeInfo.getAdminOrg());
            employeeContract.setIsChanged(false);
            if (billInfo.getApproveType().getValue() == 1) {
                employeeContract.setIsWorkflow(true);
            } else {
                employeeContract.setIsWorkflow(false);
            }
            employeeContract.setCreator(billInfo.getCreator());
            employeeContract.setCreateTime(billInfo.getCreateTime());
            employeeContract.setEntryID(csbbeInfo.getId().toString());
            employeeContract.setCU(billInfo.getHrOrgUnit().getCU());
            employeeContract.put("notNeedGenerateObjectNumber", (Object)true);
            ContractTempletInfo templetInfo = csbbeInfo.getContractTemplet();
            templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(templetInfo.getId()));
            if (templetInfo.isIsElectronicSign() && billInfo.isIsSSCShare()) {
                employeeContract.setContractClassify(ContractClassifyEnum.ElectronicSsc);
                employeeContract.setSignStatus(EContractSignState.complete);
            } else if (!templetInfo.isIsElectronicSign() && !billInfo.isIsSSCShare()) {
                employeeContract.setContractClassify(ContractClassifyEnum.ElectronicEmp);
                employeeContract.setSignStatus(EContractSignState.nosign);
            } else {
                employeeContract.setContractClassify(ContractClassifyEnum.Normal);
            }
            employeeContract.setIsElectronicSign(templetInfo.isIsElectronicSign());
            IObjectPK contractId = EmployeeContractFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)employeeContract);
            employeeContract.setId(BOSUuid.read((String)contractId.toString()));
            this.addAttachmentForContract(ctx, employeeContract, csbbeInfo.getBill().getId().toString());
            super._entryEffect(ctx, entry);
        }
        if (!(now = new Date()).before(effectDate = this.getEffectDate(entry))) {
            this.updateHRContractInfo_afterEffect(ctx, csbbeInfo);
        }
        if (null != billInfo.getOtherEntrys()) {
            this.otherFollowPreContract(ctx, billInfo);
        }
    }

    private void otherFollowPreContract(Context ctx, ContractPreSignBizBillInfo billInfo) throws EASBizException, BOSException {
        logger.info("enter otherFollowLaborContract_");
        ContractPreSignBizBillEntryInfo entry = billInfo.getEntrys().get(0);
        OtherFollowPreConEntryCollection otherEntrys = billInfo.getOtherEntrys();
        logger.info("otherEntrys_ size is " + otherEntrys.size());
        IOtherFollowPreConEntry iOtherFollowPreConEntry = OtherFollowPreConEntryFactory.getLocalInstance(ctx);
        IEmployeeOtherContract iEmployeeOtherContract = EmployeeOtherContractFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < otherEntrys.size(); ++i) {
            String otherEntryId = otherEntrys.get(i).getId().toString();
            String oql = "where id = '" + otherEntryId + "'";
            logger.info("oql_ is : " + oql);
            OtherFollowPreConEntryInfo otherEntry = iOtherFollowPreConEntry.getOtherFollowPreConEntryInfo(oql);
            EmployeeOtherContractInfo oContractInfo = new EmployeeOtherContractInfo();
            oContractInfo.setContractNo(otherEntry.getContractNo());
            logger.info("otherEntry_ ContractNo : " + otherEntry.getContractNo());
            oContractInfo.setContractTemplet(otherEntry.getContractTemplet());
            oContractInfo.setRecordDate(otherEntry.getSignDate());
            oContractInfo.setEffectDate(otherEntry.getBizDate());
            oContractInfo.setEndDate(otherEntry.getEndDate());
            oContractInfo.setDescription(entry.getDescription());
            oContractInfo.setState(EmployeeContractState.RECORD);
            oContractInfo.setReason(entry.getSignReason());
            oContractInfo.setToUnit(billInfo.getToUnit());
            oContractInfo.setLabContractFirstParty(billInfo.getLabContractFirstParty());
            oContractInfo.setDelegatePerson(billInfo.getDelegatePersonText(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            oContractInfo.setDelegatePerson(billInfo.getDelegatePersonText(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            oContractInfo.setDelegatePerson(billInfo.getDelegatePersonText(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            oContractInfo.setToUnitAddress(billInfo.getToUnitAddress(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            oContractInfo.setToUnitAddress(billInfo.getToUnitAddress(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            oContractInfo.setToUnitAddress(billInfo.getToUnitAddress(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            oContractInfo.setEmpIdentityNum(otherEntry.getIdCardNo());
            oContractInfo.setEmpAddress(otherEntry.getAdrress());
            oContractInfo.setEmpPassPortNum(otherEntry.getPassportNo());
            oContractInfo.setHrOrgUnit(billInfo.getHrOrgUnit());
            oContractInfo.setContractLimit(null);
            oContractInfo.setContSerLimit(entry.getContractServerLimit());
            oContractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
            oContractInfo.setContractLimitType(otherEntry.getContractLimitType());
            oContractInfo.setThirdDelegatePerson(billInfo.getThirdDelegatePerson());
            oContractInfo.setThirdUnitName(billInfo.getThirdUnit());
            oContractInfo.setThirdUnitAddress(billInfo.getThirdUnitAddress());
            if (!StringUtils.isEmpty((String)otherEntry.getContractLimit())) {
                oContractInfo.setContractLimitAuto(new BigDecimal(otherEntry.getContractLimit()));
            }
            oContractInfo.setPenalty(entry.getPenalty());
            oContractInfo.setCompensation(entry.getCompensation());
            oContractInfo.setAppraisal(entry.getAppraisal());
            oContractInfo.setAppraDate(entry.getAppraDate());
            oContractInfo.setIsInAdmin(billInfo.isIsInAdmin());
            oContractInfo.setContractSourceState(EmployeeContractSourceStateEnum.FROM_ADDED);
            oContractInfo.setIsChanged(false);
            if (billInfo.getApproveType().getValue() == 1) {
                oContractInfo.setIsWorkflow(true);
            } else {
                oContractInfo.setIsWorkflow(false);
            }
            oContractInfo.setEntryID(otherEntry.getId().toString());
            oContractInfo.setPositionString(entry.getPositionString());
            oContractInfo.setContractAgreedSalary(entry.getContractAgreedSalary());
            oContractInfo.setAdminOrg(otherEntry.getAdminOrg());
            oContractInfo.setPreEntryPerson(otherEntry.getPerson());
            oContractInfo.setSignStatus(EContractSignState.complete);
            oContractInfo.setContractClassify(ContractClassifyEnum.ElectronicSsc);
            IObjectPK contractId = iEmployeeOtherContract.addnew((CoreBaseInfo)oContractInfo);
            oContractInfo.setId(BOSUuid.read((String)contractId.toString()));
        }
    }

    protected void addAttachmentForOtherContract(Context ctx, EmployeeOtherContractInfo employeeContract, String billId) throws BOSException, EASBizException {
        String strLan = ctx.getLocale().toString();
        String sql = "select FAttachmentID, FAssoType_" + strLan + " from T_BAS_BoAttchAsso where FBoID = '" + billId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs != null && rs.size() > 0) {
            StringBuffer attachmentIdStr = new StringBuffer();
            String attachmentId = null;
            HashMap<String, String> attachmentMap = new HashMap<String, String>();
            try {
                while (rs.next()) {
                    attachmentIdStr.append("'");
                    attachmentIdStr.append(rs.getString("FAttachmentID"));
                    attachmentIdStr.append("',");
                    attachmentMap.put(rs.getString("FAttachmentID"), rs.getString("FAssoType_" + strLan));
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            if (attachmentIdStr.length() > 0) {
                attachmentId = attachmentIdStr.toString().substring(0, attachmentIdStr.length() - 1);
            }
            AttachmentCollection aCol = AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentCollection("where id in (" + attachmentId + ")");
            AttachmentInfo aInfo = null;
            BoAttchAssoInfo baaInfo = null;
            IBoAttchAsso bAAF = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            int size = aCol.size();
            for (int i = 0; i < size; ++i) {
                aInfo = aCol.get(i);
                baaInfo = new BoAttchAssoInfo();
                baaInfo.setAttachment(aInfo);
                baaInfo.setAssoType(((String)attachmentMap.get(aInfo.getId().toString())).toString());
                baaInfo.setBoID(employeeContract.getId().toString());
                baaInfo.setAssoBusObjType(employeeContract.getBOSType().toString());
                bAAF.addnew(baaInfo);
            }
        }
    }

    private boolean isEmpContractNumberExist(Context ctx, String numberTemp) throws BOSException, EASBizException {
        String oql = "where contractNo ='" + numberTemp + "'";
        return EmployeeContractFactory.getLocalInstance((Context)ctx).exists(oql);
    }

    private boolean isEmpOtherContractNumberExist(Context ctx, String numberTemp) throws BOSException, EASBizException {
        String oql = "where contractNo ='" + numberTemp + "'";
        return EmployeeOtherContractFactory.getLocalInstance((Context)ctx).exists(oql);
    }

    private void updateHRContractInfo_afterEffect(Context ctx, ContractPreSignBizBillEntryInfo csbbeInfo) throws EASBizException, BOSException {
        HRContractInfoInfo hRContractInfo = HRContractInfoUtils.getHRContractInfo(ctx, csbbeInfo.getBill().getId().toString(), csbbeInfo.getContractNo());
        hRContractInfo.setState(EmployeeContractState.RECORD);
        hRContractInfo.setNewState(EmployeeContractNewStateEnum.RECORDED);
        hRContractInfo.setIsNewEmpContract(false);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("newState"));
        selector.add(new SelectorItemInfo("employeeContract"));
        selector.add(new SelectorItemInfo("isNewEmpContract"));
        String oql = "select id where contractNo='" + csbbeInfo.getContractNo() + "'";
        IEmployeeContract iEmployeeContract = EmployeeContractFactory.getLocalInstance((Context)ctx);
        EmployeeContractInfo contractInfo = iEmployeeContract.getEmployeeContractInfo(oql);
        hRContractInfo.setEmployeeContract(contractInfo);
        HRContractInfoFactory.getLocalInstance(ctx).updatePartial(hRContractInfo, selector);
    }

    protected SelectorItemCollection getBillSelector() throws BOSException, EASBizException {
        SelectorItemCollection selector = super.getBillSelector();
        selector.add(new SelectorItemInfo("toUnit"));
        selector.add(new SelectorItemInfo("delegatePersonText"));
        selector.add(new SelectorItemInfo("toUnitAddress"));
        selector.add(new SelectorItemInfo("thirdDelegatePerson"));
        selector.add(new SelectorItemInfo("thirdUnit"));
        selector.add(new SelectorItemInfo("thirdUnitAddress"));
        selector.add(new SelectorItemInfo("isInAdmin"));
        selector.add(new SelectorItemInfo("creator.id"));
        selector.add(new SelectorItemInfo("createTime"));
        selector.add(new SelectorItemInfo("labContractFirstParty"));
        return selector;
    }

    @Override
    protected HashMap _getParmaValue(Context ctx, String hrId) throws BOSException, EASBizException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        boolean isZTCustomer = EmployeeContractFactory.getLocalInstance((Context)ctx).isZhongTianCustomer();
        String contractOrgRange = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(hrId), (String)"IS_CONTRACT_002");
        boolean isShowLongName = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_CONTRACT_003", null);
        boolean isStrideHRO = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_CONTRACT_ALLHR", null);
        String allHRChoose = ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"IS_CONTRACT_ALLHR_NEW", null, (boolean)true);
        paramMap.put("isZTCustomer", isZTCustomer);
        paramMap.put("contractOrgRange", contractOrgRange);
        paramMap.put("isShowLongName", isShowLongName);
        paramMap.put("isStrideHRO", isStrideHRO);
        paramMap.put("allHRChoose", allHRChoose);
        return paramMap;
    }

    @Override
    protected void _setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setAuditEnd(ctx, billID);
        String oql = "select * where billID='" + billID + "'";
        IHRContractInfo iHRContractInfo = HRContractInfoFactory.getLocalInstance(ctx);
        HRContractInfoCollection coll = iHRContractInfo.getHRContractInfoCollection(oql);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            HRContractInfoInfo info = coll.get(i);
            iHRContractInfo.delete((IObjectPK)new ObjectUuidPK(info.getId().toString()));
        }
    }

    @Override
    protected void setHRContractInfoInfo(Context ctx, ContractBillBaseInfo billInfo, IObjectPK billId, CoreBaseInfo entryInfo, HRContractInfoInfo contractInfo) throws EASBizException, BOSException {
        super.setHRContractInfoInfo(ctx, billInfo, billId, entryInfo, contractInfo);
        contractInfo.put("preEntryPerson", entryInfo.get("person"));
        String oql = "select * where preEntryPerson.id='" + contractInfo.getPreEntryPerson().getId() + "'";
        HRContractInfoCollection coll = HRContractInfoFactory.getLocalInstance(ctx).getHRContractInfoCollection(oql);
        if (coll.size() == 0) {
            contractInfo.setIsNewEmpContract(true);
        }
    }

    @Override
    protected void updateHrContractInfo(Context ctx, ContractBillBaseInfo billInfo, IObjectPK billID) throws BOSException, EASBizException {
        IObjectCollection entrys = (IObjectCollection)billInfo.get(this.getEntryField());
        IHRContractInfo iHRContractInfo = HRContractInfoFactory.getLocalInstance(ctx);
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            HRBillBaseEntryInfo entryInfo = (HRBillBaseEntryInfo)entrys.getObject(i);
            ContractTempletInfo templateInfo = (ContractTempletInfo)entryInfo.get("contractTemplet");
            if (!ContractUtils.isLaborContract(ctx, templateInfo.getId().toString())) continue;
            String oql = "select * where billID='" + billID + "' and preEntryPerson.id='" + ((PreEntryPersonInfo)entryInfo.get("person")).getId() + "'";
            HRContractInfoInfo contractInfo = iHRContractInfo.getHRContractInfoInfo(oql);
            this.setHRContractInfoInfo(ctx, billInfo, billID, (CoreBaseInfo)entryInfo, contractInfo);
            iHRContractInfo.update((IObjectPK)new ObjectUuidPK(contractInfo.getId().toString()), contractInfo);
        }
    }

    public void setBillRelateInfo(Context ctx, BOSUuid entryID) throws EASBizException, BOSException {
        if (entryID == null) {
            return;
        }
        HRBillBaseEntryInfo entry = null;
        HRBillBaseInfo bill = null;
        String billField = this.getBillField();
        String entryField = this.getEntryField();
        entry = this.getEntryInterface(ctx).getHRBillBaseEntryInfo((IObjectPK)new ObjectUuidPK(entryID), this.getEntrySelector());
        if (entry != null && !StringUtils.isEmpty((String)billField) && !StringUtils.isEmpty((String)entryField)) {
            IObjectCollection entries;
            bill = (HRBillBaseInfo)entry.get(billField);
            if (bill != null && (entries = (IObjectCollection)(bill = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(bill.getId()), this.getBillSelector())).get(entryField)) != null) {
                entries.clear();
                entries.addObject((IObjectValue)entry);
            }
            entry.put(billField, (Object)bill);
        }
        this._entryEffect(ctx, entry);
    }

    protected void checkLabPartyIsOpenElec(Context ctx, ContractPreSignBizBillInfo csbbInfo) throws BOSException, EASBizException {
        ContractPreSignBizBillEntryCollection entrys = csbbInfo.getEntrys();
        if (entrys != null && entrys.size() > 0) {
            boolean isElec = false;
            for (int dex = 0; dex < entrys.size(); ++dex) {
                ContractPreSignBizBillEntryInfo entryInfo = entrys.get(0);
                ContractTempletInfo contractTemplet = entryInfo.getContractTemplet();
                if (contractTemplet.get("isElectronicSign") == null) {
                    contractTemplet = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(contractTemplet.getId()));
                }
                if (!contractTemplet.isIsElectronicSign()) continue;
                isElec = true;
                break;
            }
            if (isElec) {
                LabContractFirstPartyInfo labContractFirstParty = csbbInfo.getLabContractFirstParty();
                ElectronicContractUtils.checkLabContractFirstPartyIsOpenElec((Context)ctx, (LabContractFirstPartyInfo)labContractFirstParty);
                ElectronicContractUtils.checkKDContractConfigIsAuth((Context)ctx, (LabContractFirstPartyInfo)labContractFirstParty);
            }
        }
    }

    private void checkProbation(Context ctx, ContractPreSignBizBillInfo csbbInfo) throws BOSException, EASBizException {
        ContractPreSignBizBillEntryInfo csbbeInfo = null;
        EmployeeContractInfo contractInfo = null;
        int size = csbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            csbbeInfo = csbbInfo.getEntrys().get(i);
            contractInfo = new EmployeeContractInfo();
            contractInfo.setContractNo(csbbeInfo.getContractNo());
            contractInfo.setTestBeginDate(csbbeInfo.getTestBeginDate());
            contractInfo.setTestEndDate(csbbeInfo.getTestEndDate());
            contractInfo.setEffectDate(csbbeInfo.getBizDate());
            contractInfo.setEndDate(csbbeInfo.getEndDate());
            contractInfo.setContractLimitType(csbbeInfo.getContractLimitType());
            contractInfo.setPreEntryPerson(csbbeInfo.getPerson());
            if (!StringUtils.isEmpty((String)csbbeInfo.getContractLimit())) {
                contractInfo.setContractLimitAuto(new BigDecimal(csbbeInfo.getContractLimit()));
            }
            int tryoutMonth = csbbeInfo.getTryoutMonth();
            contractInfo.put("probation", (Object)tryoutMonth);
            ContractUtils.checkProbation(ctx, contractInfo);
        }
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.setLabContractFirstPartyName(ctx, model);
        this.checkPreEntryPersonHasBill(ctx, model);
        IObjectPK retValue = super._submit(ctx, model);
        this.afterProcessContractSignData(ctx, model, true);
        return retValue;
    }

    private void afterProcessContractSignData(Context ctx, IObjectValue model, boolean isAddNew) throws EASBizException, BOSException {
        ContractPreSignBizBillInfo billInfo = (ContractPreSignBizBillInfo)model;
        if (!billInfo.isIsSSCShare()) {
            return;
        }
        try {
            String clazzName = "com.kingdee.shr.econtractservice.service.ContractBizBillService";
            String methodName = "processEContractData";
            Class<?> clazz = Class.forName(clazzName);
            Method method = ReflectionUtils.findMethod(clazz, (String)methodName, (Class[])new Class[]{Context.class, IObjectValue.class, Boolean.class});
            if (method == null) {
                throw new BOSException("can not find com.kingdee.shr.econtractservice.service.ContractBizBillService processEContractData");
            }
            ReflectionUtils.invokeMethod((Method)method, clazz.newInstance(), (Object[])new Object[]{ctx, model, isAddNew});
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            if (e instanceof UndeclaredThrowableException) {
                Throwable t = e.getCause();
                logger.error(t.getMessage(), t);
                if (t instanceof EASBizException) {
                    throw (EASBizException)t;
                }
                if (t instanceof BOSException) {
                    throw (BOSException)t;
                }
                throw new BOSException(t.getMessage(), t);
            }
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        this.beforeAbortBizBill(ctx, billId);
        super._abortBizBill(ctx, billId);
        this.afterAbortBizBill(ctx, billId);
    }

    protected void beforeAbortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
    }

    protected void afterAbortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            IObjectPK[] iObjectPKArray = ElectronicContractRelationFactory.getLocalInstance(ctx).delete("where billID = '" + billId + "'");
        }
    }

    private void updateContractPreSignBillEntryContractNo(Context ctx, ContractPreSignBizBillInfo billInfo) throws EASBizException, BOSException {
        OtherFollowPreConEntryCollection otherEntryColl;
        ContractPreSignBizBillEntryCollection entryColl = billInfo.getEntrys();
        if (entryColl != null && entryColl.size() > 0) {
            for (int index = 0; index < entryColl.size(); ++index) {
                String oldNumber;
                String newNumber;
                ContractPreSignBizBillEntryInfo entryInfo = entryColl.get(index);
                ContractTempletInfo templetInfo = entryInfo.getContractTemplet();
                templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(templetInfo.getId().toString()));
                if (!templetInfo.isIsElectronicSign() || (newNumber = ElectronicContractUtils.generateContractNumber((Context)ctx, (String)(oldNumber = entryInfo.getContractNo()))).equals(oldNumber)) continue;
                entryInfo.setContractNo(newNumber);
            }
        }
        if ((otherEntryColl = billInfo.getOtherEntrys()) != null && otherEntryColl.size() > 0) {
            for (int index = 0; index < otherEntryColl.size(); ++index) {
                String oldNumber;
                OtherFollowPreConEntryInfo otherEntryInfo = otherEntryColl.get(index);
                ContractTempletInfo templetInfo = otherEntryInfo.getContractTemplet();
                templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(templetInfo.getId().toString()));
                if (!templetInfo.isIsElectronicSign()) continue;
                String newNumber = oldNumber = otherEntryInfo.getContractNo();
                if (!oldNumber.startsWith("E") && !oldNumber.startsWith("EE")) {
                    newNumber = "E" + oldNumber;
                }
                if (newNumber == null || newNumber.equals(oldNumber)) continue;
                otherEntryInfo.setContractNo(newNumber);
            }
        }
    }

    @Override
    protected void setBillUseDefault(Context ctx, IObjectValue model, IObjectValue entry) throws BOSException, EASBizException {
        ContractBillBaseInfo billInfo = (ContractBillBaseInfo)model;
        boolean useDefault = true;
        billInfo.setUseDefault(useDefault);
    }

    protected void checkPreEntryPersonHasBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ContractPreSignBizBillInfo csbbInfo = (ContractPreSignBizBillInfo)model;
        ContractPreSignBizBillEntryInfo csbbeInfo = null;
        int size = csbbInfo.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            csbbeInfo = csbbInfo.getEntrys().get(i);
            String preEntryPresonId = csbbeInfo.getPerson().getId().toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)preEntryPresonId));
            filter.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)HRBillStateEnum.SAVED.getValue(), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)HRBillStateEnum.AUDITEND.getValue(), CompareType.NOTEQUALS));
            if (csbbeInfo.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)csbbeInfo.getId().toString(), CompareType.NOTEQUALS));
            }
            if (!ContractPreSignBizBillEntryFactory.getLocalInstance(ctx).exists(filter)) continue;
            throw new ContractBizException(ContractBizException.EXCEPTION7);
        }
    }

    protected void setLabContractFirstPartyName(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ContractPreSignBizBillInfo csbbInfo = (ContractPreSignBizBillInfo)model;
        LabContractFirstPartyInfo labContractFirstParty = csbbInfo.getLabContractFirstParty();
        if (labContractFirstParty != null && labContractFirstParty.getId() != null) {
            String labContractFirstPartyName = labContractFirstParty.getName();
            if (StringUtils.isEmpty((String)labContractFirstPartyName)) {
                labContractFirstPartyName = LabContractFirstPartyFactory.getLocalInstance((Context)ctx).getLabContractFirstPartyInfo((IObjectPK)new ObjectUuidPK(labContractFirstParty.getId())).getName();
            }
            csbbInfo.setLCFPName(labContractFirstPartyName);
        }
    }
}

