/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.contract.ContractException;
import com.kingdee.eas.hr.contract.app.AbstractEmployeeOtherContractInfoFacadeControllerBean;
import com.kingdee.eas.hr.contract.util.ContractUtils;
import com.kingdee.eas.hr.emp.EmployeeContractNewStateEnum;
import com.kingdee.eas.hr.emp.EmployeeContractState;
import com.kingdee.eas.hr.emp.EmployeeOtherContractFactory;
import com.kingdee.eas.hr.emp.EmployeeOtherContractInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import org.apache.log4j.Logger;

public class EmployeeOtherContractInfoFacadeControllerBean
extends AbstractEmployeeOtherContractInfoFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.contract.app.EmployeeOtherContractInfoFacadeControllerBean");
    private final String fmt = "yyyy-MM-dd";

    @Override
    protected void _fixedOtherContractInfo(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql = new StringBuffer();
        sql.append("update T_HR_EmployeeOtherContract set fstate=1 where ").append("fState=0 and fEffectDate<=CURDATE() and (fRecordDate is not null and fRecordDate<=CURDATE())");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_HR_EmployeeOtherContract set fstate=4 ").append(" where fstate in (1,2,3) and (FToDate is null and FEndDateReal is not null and FEndDateReal<CURDATE())");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        int dbType = HRUtilExtend.getDbType((Context)ctx);
        String contractLimitEndDateSql = null;
        String contractLimitToDateSql = null;
        String curDateSql = null;
        String dialectSql = "";
        if (DbType.isOracle((int)dbType)) {
            dialectSql = "/*dialect*/";
            contractLimitEndDateSql = "round((TO_DATE(TO_CHAR(FEndDate,'YYYY-MM-DD HH24:MI:SS'),'YYYY-MM-DD HH24:MI:SS') - TO_DATE(TO_CHAR(FEffectDate,'YYYY-MM-DD HH24:MI:SS'),'YYYY-MM-DD HH24:MI:SS'))/365,1)";
            contractLimitToDateSql = "round((TO_DATE(TO_CHAR(FToDate,'YYYY-MM-DD HH24:MI:SS'),'YYYY-MM-DD HH24:MI:SS') - TO_DATE(TO_CHAR(FEffectDate,'YYYY-MM-DD HH24:MI:SS'),'YYYY-MM-DD HH24:MI:SS'))/365,1)";
            curDateSql = "TRUNC(sysdate)";
        } else {
            dialectSql = "";
            contractLimitEndDateSql = "round(DateDiff(FEffectDate,FEndDate)/31536000.0,1)";
            contractLimitToDateSql = "round(DateDiff(FEffectDate,FToDate)/31536000.0,1)";
            curDateSql = "curDate()";
        }
        sql = new StringBuffer(dialectSql);
        sql.append("update T_HR_EmployeeOtherContract set fstate=4, FEndDateReal=FEndDate, FContractLimitAutoReal=").append(contractLimitEndDateSql).append(" where (FContractLimitType='1' or FContractLimitType='3')").append(" and fstate in (1,2,3) and FEndDateReal is null and FEndDate<").append(curDateSql);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql = new StringBuffer(dialectSql);
        sql.append("update T_HR_EmployeeOtherContract set fstate=5, FEndDateReal=FToDate, FContractLimitAutoReal=").append(contractLimitToDateSql).append(" where ").append(" fstate in (1,2,3) and (FToDate is not null and FToDate<").append(curDateSql).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_HR_EmployeeOtherContract set fNewState=1 where fNewState=0 and fState=1");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_HR_EmployeeOtherContract set fNewState=fstate where fNewState in (0,1) and fState in (4,5)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        logger.error((Object)"EmployeeOtherContractFacade.fixOtherContractInfo success!");
    }

    @Override
    protected void _freeContract(Context ctx, EmployeeOtherContractInfo contractInfo) throws BOSException, EASBizException {
        EmployeeOtherContractInfo srcContract = ContractUtils.getEmployeeOtherContractInfoById(ctx, contractInfo.getId().toString());
        this.checkContractEndOrFreeException(srcContract);
        this.updateFreeContractInfo(ctx, contractInfo);
    }

    @Override
    protected void _endContract(Context ctx, EmployeeOtherContractInfo contractInfo) throws BOSException, EASBizException {
        EmployeeOtherContractInfo srcContract = ContractUtils.getEmployeeOtherContractInfoById(ctx, contractInfo.getId().toString());
        this.checkContractEndOrFreeException(srcContract);
        this.updateEndContractInfo(ctx, contractInfo);
    }

    private void updateFreeContractInfo(Context ctx, EmployeeOtherContractInfo contractInfo) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        if (contractInfo.containsKey("freeDate")) {
            selector.add(new SelectorItemInfo("freeDate"));
            contractInfo.setNewState(EmployeeContractNewStateEnum.FREED);
            selector.add(new SelectorItemInfo("newState"));
            contractInfo.setEndDateReal(contractInfo.getFreeDate());
            selector.add(new SelectorItemInfo("endDateReal"));
            contractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit(contractInfo.getEffectDate(), contractInfo.getFreeDate()));
            selector.add(new SelectorItemInfo("contractLimitAutoReal"));
            if (contractInfo.getFreeDate() != null && DateTimeUtils.dayBefore((Date)contractInfo.getFreeDate(), (Date)this.getCurDate())) {
                contractInfo.setState(EmployeeContractState.FREE);
                selector.add(new SelectorItemInfo("state"));
            }
        }
        if (contractInfo.containsKey("appraisal")) {
            selector.add(new SelectorItemInfo("appraisal"));
        }
        if (contractInfo.containsKey("appraDate")) {
            selector.add(new SelectorItemInfo("appraDate"));
        }
        if (contractInfo.containsKey("penalty")) {
            selector.add(new SelectorItemInfo("penalty"));
        }
        if (contractInfo.containsKey("compensation")) {
            selector.add(new SelectorItemInfo("compensation"));
        }
        EmployeeOtherContractInfo oldContractInfo = EmployeeOtherContractFactory.getLocalInstance((Context)ctx).getEmployeeOtherContractInfo((IObjectPK)new ObjectUuidPK(contractInfo.getId().toString()));
        if (contractInfo.containsKey("reason")) {
            if (!StringUtils.isEmpty((String)oldContractInfo.getReason())) {
                String reason = oldContractInfo.getReason() + "\n" + contractInfo.getReason();
                contractInfo.setReason(reason);
            }
            selector.add(new SelectorItemInfo("reason"));
        }
        if (contractInfo.containsKey("description")) {
            selector.add(new SelectorItemInfo("description"));
        }
        EmployeeOtherContractFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)contractInfo, selector);
    }

    private void updateEndContractInfo(Context ctx, EmployeeOtherContractInfo contractInfo) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        if (contractInfo.containsKey("endDateReal")) {
            selector.add(new SelectorItemInfo("endDateReal"));
            contractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit(contractInfo.getEffectDate(), contractInfo.getEndDateReal()));
            selector.add(new SelectorItemInfo("contractLimitAutoReal"));
            contractInfo.setNewState(EmployeeContractNewStateEnum.ENDED);
            selector.add(new SelectorItemInfo("newState"));
            if (contractInfo.getEndDate() != null && DateTimeUtils.dayBefore((Date)contractInfo.getEndDateReal(), (Date)this.getCurDate())) {
                contractInfo.setState(EmployeeContractState.END);
                selector.add(new SelectorItemInfo("state"));
            }
        }
        if (contractInfo.containsKey("appraisal")) {
            selector.add(new SelectorItemInfo("appraisal"));
        }
        if (contractInfo.containsKey("appraDate")) {
            selector.add(new SelectorItemInfo("appraDate"));
        }
        if (contractInfo.containsKey("penalty")) {
            selector.add(new SelectorItemInfo("penalty"));
        }
        if (contractInfo.containsKey("compensation")) {
            selector.add(new SelectorItemInfo("compensation"));
        }
        EmployeeOtherContractInfo oldContractInfo = EmployeeOtherContractFactory.getLocalInstance((Context)ctx).getEmployeeOtherContractInfo((IObjectPK)new ObjectUuidPK(contractInfo.getId().toString()));
        if (contractInfo.containsKey("reason")) {
            if (!StringUtils.isEmpty((String)oldContractInfo.getReason())) {
                String reason = oldContractInfo.getReason() + "\n" + contractInfo.getReason();
                contractInfo.setReason(reason);
            }
            selector.add(new SelectorItemInfo("reason"));
        }
        if (contractInfo.containsKey("description")) {
            selector.add(new SelectorItemInfo("description"));
        }
        EmployeeOtherContractFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)contractInfo, selector);
    }

    private void checkContractEndOrFreeException(EmployeeOtherContractInfo sourceContract) throws ContractException {
        if (sourceContract == null) {
            throw new ContractException(ContractException.PERSONNOTSIGNCONTRACT_OLD);
        }
        if (sourceContract.getState() == EmployeeContractState.FREE || sourceContract.getState() == EmployeeContractState.END || sourceContract.getEndDateReal() != null || sourceContract.getFreeDate() != null) {
            throw new ContractException(ContractException.ENDORFREECONTRACTCANTENDORFREE);
        }
    }

    private Date getCurDate() {
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        return curDate;
    }
}

