/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.olap.util.ByteArrayOutputStream;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfo;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfoSelector;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.util.FileGetter;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.emp.ContractTempletFactory;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.ContractTypeCollection;
import com.kingdee.eas.hr.emp.ContractTypeFactory;
import com.kingdee.eas.hr.emp.ContractTypeInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IContractTemplet;
import com.kingdee.eas.hr.emp.IContractType;
import com.kingdee.eas.hr.emp.client.AbstractContractTempletEditUI;
import com.kingdee.eas.hr.emp.client.ContractTypePromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;

public class ContractTempletEditUI
extends AbstractContractTempletEditUI {
    GregorianCalendar cal = new GregorianCalendar(2199, 11, 31);
    private String[] curAttachIds = null;
    private File theFile = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initWorkButton();
    }

    private void initAttach() {
        try {
            if (this.editData.getId() == null) {
                this.txtFileName.setText("");
            } else {
                String curTempletId = this.editData.getId().toString();
                AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
                this.curAttachIds = acm.getAttachmentIDsByBoID(curTempletId);
                if (this.curAttachIds.length > 0) {
                    ComplexAttachmentInfoSelector cais = new ComplexAttachmentInfoSelector();
                    cais.needMainName();
                    cais.needExtName();
                    ComplexAttachmentInfo attachInfo = acm.getComplexAttachmentInfo(this.curAttachIds[0], cais);
                    this.txtFileName.setText(attachInfo.getMainName() + "." + attachInfo.getExtName());
                } else {
                    this.txtFileName.setText("");
                }
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnUpload.setIcon(EASResource.getIcon((String)"imgTbtn_affixmanage"));
        this.btnUpload.setEnabled(true);
        this.txtFileName.setEditable(false);
        this.btnAddNew.setVisible(false);
        this.actionAddNew.setEnabled(false);
        this.btnEdit.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.btnRemove.setVisible(false);
        this.actionRemove.setEnabled(false);
        this.btnCopy.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.prmtContractType.setSelector((KDPromptSelector)new ContractTypePromptBox());
        this.prmtContractType.setEditable(false);
    }

    void setComboxItem() throws BOSException {
        IContractType iType = ContractTypeFactory.getRemoteInstance();
        ContractTypeCollection typeInfos = iType.getContractTypeCollection();
        DefaultComboBoxModel<ContractTypeInfo> model = new DefaultComboBoxModel<ContractTypeInfo>();
        for (int i = 0; i < typeInfos.size(); ++i) {
            model.addElement(typeInfos.get(i));
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initAttach();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        this.txtFileName.setText("");
        ContractTempletInfo info = new ContractTempletInfo();
        this.effectDate.setValue((Object)new Date());
        this.invalidDate.setValue((Object)this.cal.getTime());
        info.setEffectDate(DateTimeUtils.truncateDate((Date)((Date)this.effectDate.getValue(Date.class))));
        info.setInvalidDate(DateTimeUtils.truncateDate((Date)((Date)this.invalidDate.getValue(Date.class))));
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        HashMap map = (HashMap)this.getUIContext();
        if (map.get("SelectNode") instanceof ContractTypeInfo) {
            info.setContractType((ContractTypeInfo)map.get("SelectNode"));
        }
        info.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ContractTempletFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.editData.getContractType() == null) {
            this.prmtContractType.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_TYPE_NOT_NULL);
        }
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            this.txtNumber.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NUMBER_CAN_NOT_BLANK);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.txtName.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
        if (this.txtFileName.getText().trim().equals("")) {
            this.txtFileName.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.CONTRACTTEMPLET_CAN_NOT_BLACK);
        }
        if (this.editData.getEffectDate() == null) {
            this.effectDate.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.EFFECTDATE_CAN_NOT_BLANK);
        }
        if (this.editData.getInvalidDate() == null) {
            this.invalidDate.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.INVALIDDATE_CAN_NOT_BLANK);
        }
        if (this.editData.getEffectDate().after(this.editData.getInvalidDate())) {
            this.effectDate.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.CONCTACT_EFFECTDATE_NOT_DY_ENDDATE);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("contractType.id"));
        sic.add(new SelectorItemInfo("contractType.name"));
        sic.add(new SelectorItemInfo("contractType.number"));
        sic.add(new SelectorItemInfo("contractType.description"));
        sic.add(new SelectorItemInfo("effectDate"));
        sic.add(new SelectorItemInfo("invalidDate"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("adminCU.id"));
        sic.add(new SelectorItemInfo("CU.id"));
        return sic;
    }

    @Override
    public void actionUpload_actionPerformed(ActionEvent e) throws Exception {
        super.actionUpload_actionPerformed(e);
        AttachmentClientManager asm = AttachmentManagerFactory.getClientManager();
        this.theFile = asm.chooseFileByDialog((Component)((Object)this));
        if (this.theFile != null) {
            if (this.theFile.length() > 0xA00001L) {
                throw new EmployeeException(EmployeeException.EMPLOYEE_CONTRACT_ATTACH_SIZE_ERROR);
            }
            this.txtFileName.setText(this.theFile.getPath());
            this.checkFileNameIsExisted(this.theFile);
        }
    }

    private void checkFileNameIsExisted(File theFile) throws BOSException {
        String fileName = theFile.getName().lastIndexOf(".") < 0 ? theFile.getName() : theFile.getName().substring(0, theFile.getName().lastIndexOf("."));
        if (AttachmentFactory.getRemoteInstance().isFileNameExisted(null, fileName)) {
            MsgBox.showInfo((String)MessageFormat.format(Resrcs.getString((String)"FileNameExisted2"), theFile.getName()));
            this.initAttach();
            SysUtil.abort();
        }
    }

    public IObjectPK runSubmit() throws Exception {
        SimpleAttachmentInfo sai = null;
        if (this.theFile != null) {
            sai = new SimpleAttachmentInfo();
            sai.setMainName(StringUtil4File.getMainFileName((String)this.theFile.getName()));
            sai.setExtName(StringUtil4File.getExtendedFileName((String)this.theFile.getName()));
            try {
                sai.setContent(FileGetter.getBytesFromFile((File)this.theFile));
            }
            catch (Exception e) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream((OutputStream)bos);
                e.printStackTrace(ps);
                ps.close();
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"184_ContractTempletEditUI"), (String)new String(bos.toByteArray()), (int)0);
                SysUtil.abort();
            }
        }
        IObjectPK pk = ((IContractTemplet)this.getBizInterface()).submitContractTempletAndAttachment(this.curAttachIds, sai, (IObjectValue)this.editData);
        this.theFile = null;
        return pk;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

