/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.contract.ContractException;
import com.kingdee.eas.hr.emp.ContractTempletFactory;
import com.kingdee.eas.hr.emp.ContractTypeFactory;
import com.kingdee.eas.hr.emp.ContractTypeInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IContractTemplet;
import com.kingdee.eas.hr.emp.IContractType;
import com.kingdee.eas.hr.emp.client.AbstractContractTypeEditUI;
import com.kingdee.eas.hr.emp.client.ContractTempletListUI;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;

public class ContractTypeEditUI
extends AbstractContractTypeEditUI {
    ContractTypeInfo parentInfo = null;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("fromPage") != null && ContractTempletListUI.class.getName().equals(this.getUIContext().get("fromPage").toString())) {
            this.btnAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.btnSubmit.setVisible(false);
        }
    }

    protected IObjectValue createNewData() {
        ContractTypeInfo newType = new ContractTypeInfo();
        if ("ADDNEW".equals(this.getOprtState())) {
            newType.setParent((ContractTypeInfo)this.getUIContext().get("ParentNode"));
            newType.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
            newType.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        }
        return newType;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ContractTypeFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            this.txtNumber.requestFocusInWindow();
            throw new ContractException(ContractException.NUMBER_CANT_NULL);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.txtName.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
    }

    void checkContractTypeHasContractTemplet() throws EASBizException, BOSException {
        if (this.parentInfo != null) {
            IContractTemplet iTemp = ContractTempletFactory.getRemoteInstance();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("contractType", (Object)this.parentInfo.getId()));
            if (iTemp.exists(filter)) {
                throw new EmployeeException(EmployeeException.NOT_LEAFNODE_CONTRACT_TYPE);
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkContractTypeHasContractTemplet();
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("isLaborContract"));
        sic.add(new SelectorItemInfo("cu.id"));
        return sic;
    }

    public IObjectPK runSubmit() throws Exception {
        IContractType iType = ContractTypeFactory.getRemoteInstance();
        ContractTypeInfo parentTypeInfo = (ContractTypeInfo)this.getUIContext().get("ParentNode");
        if (this.editData.getId() == null) {
            if (parentTypeInfo == null) {
                iType.checkContractType(null, this.editData, null);
            } else {
                iType.checkContractType(parentTypeInfo.getId().toString(), this.editData, null);
            }
        } else if (parentTypeInfo == null) {
            iType.checkContractType(null, this.editData, this.editData.getId().toString());
        } else {
            iType.checkContractType(parentTypeInfo.getId().toString(), this.editData, this.editData.getId().toString());
        }
        return super.runSubmit();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        EntityControlTypeUtil.checkCanEdit((String)"S4", (String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), (String)this.editData.getCU().getId().toString());
        super.actionEdit_actionPerformed(e);
    }
}

