/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonException;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.client.IEmployeeUI;
import com.kingdee.eas.hr.emp.EmpEditItemEnum;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.PersonContactMethodCollection;
import com.kingdee.eas.hr.emp.PersonContactMethodFactory;
import com.kingdee.eas.hr.emp.PersonContactMethodInfo;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeContactMethodUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmployeeContactMethodUI
extends AbstractEmployeeContactMethodUI {
    private IEmployeeUI treeEditUI = null;

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.treeEditUI = (IEmployeeUI)this.getUIContext().get("GroupListEditUI");
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
    }

    protected boolean isShowAttachmentAction() {
        return true;
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.treeEditUI != null && this.treeEditUI.getMainBizOrgInfo() != null) {
            return this.treeEditUI.getMainBizOrgInfo().getCU();
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.treeEditUI != null && this.treeEditUI.getMainBizOrgInfo() != null) {
            return this.treeEditUI.getMainBizOrgInfo();
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCurrentHRO().getId());
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        String recordId = null;
        if (!StringUtils.isEmpty((String)this.treeEditUI.getEmployeeID())) {
            recordId = this.treeEditUI.getEmployeeID();
        }
        if (recordId != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)recordId));
            view.put("selector", (Object)this.getMergedSelector());
            view.setFilter(filter);
            PersonContactMethodCollection pcmCol = PersonContactMethodFactory.getRemoteInstance().getPersonContactMethodCollection(view);
            this.editData = pcmCol.size() <= 0 ? (PersonContactMethodInfo)this.createNewData() : pcmCol.get(0);
            this.setDataObject((IObjectValue)this.editData);
            this.editData.copyNewToOld();
        }
        return this.editData;
    }

    @Override
    public void loadFields() {
        try {
            this.getValue(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        String email = this.txtEmail.getText();
        String backupEMail = this.txtBackupEMail.getText();
        email = email.replaceAll("\u3000", " ").trim();
        backupEMail = backupEMail.replaceAll("\u3000", " ").trim();
        this.txtEmail.setText(email);
        this.txtBackupEMail.setText(backupEMail);
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        String email = this.txtEmail.getText();
        String backupEMail = this.txtBackupEMail.getText();
        email = email.replaceAll("\u3000", " ").trim();
        backupEMail = backupEMail.replaceAll("\u3000", " ").trim();
        this.txtEmail.setText(email);
        this.txtBackupEMail.setText(backupEMail);
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    protected IObjectValue createNewData() {
        PersonContactMethodInfo info = new PersonContactMethodInfo();
        PersonInfo pInfo = new PersonInfo();
        pInfo.setId(BOSUuid.read((String)this.treeEditUI.getEmployeeID()));
        info.setPerson(pInfo);
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PersonContactMethodFactory.getRemoteInstance();
    }

    public IObjectPK runSubmit() throws Exception {
        this.editData.setHrOrgUnit(this.getCurrentHRO());
        this.editData.setCU(this.getCurrentCU());
        return super.runSubmit();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        Pattern mobilePattern = Pattern.compile("^1\\d{10}$");
        Pattern phonePattern = Pattern.compile("^(\\d{3,4}-)?\\d{7,8}(-\\d{2,4})?$");
        Pattern emailPattern = Pattern.compile("^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$");
        Matcher matcher = null;
        if (!StringUtils.isEmpty((String)this.txtHomePhone.getText()) && !(matcher = phonePattern.matcher(this.txtHomePhone.getText())).find()) {
            this.txtHomePhone.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.HOMEPHONE_ERROR);
        }
        if (!StringUtils.isEmpty((String)this.txtBackupHomePhone.getText()) && !(matcher = phonePattern.matcher(this.txtBackupHomePhone.getText())).find()) {
            this.txtBackupHomePhone.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.BACKHOMEPHONE_ERROR);
        }
        if (!StringUtils.isEmpty((String)this.txtOfficePhone.getText()) && !(matcher = phonePattern.matcher(this.txtOfficePhone.getText())).find()) {
            this.txtOfficePhone.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.OFFICEPHONE_ERROR);
        }
        if (!StringUtils.isEmpty((String)this.txtBackupOfficPhone.getText()) && !(matcher = phonePattern.matcher(this.txtBackupOfficPhone.getText())).find()) {
            this.txtBackupOfficPhone.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.BACKOFFICEPHONE_ERROR);
        }
        if (!StringUtils.isEmpty((String)this.txtMobile.getText()) && !(matcher = mobilePattern.matcher(this.txtMobile.getText())).find()) {
            this.txtMobile.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.MOBILE_ERROR);
        }
        if (!StringUtils.isEmpty((String)this.txtBackupMobile.getText()) && !(matcher = mobilePattern.matcher(this.txtBackupMobile.getText())).find()) {
            this.txtBackupMobile.requestFocusInWindow();
            throw new EmployeeException(EmployeeException.BACKMOBILE_ERROR);
        }
        if (!StringUtils.isEmpty((String)this.txtEmail.getText()) && !(matcher = emailPattern.matcher(this.txtEmail.getText())).find()) {
            this.txtEmail.requestFocusInWindow();
            throw new PersonException(PersonException.EMAIL_ERROR);
        }
        if (!StringUtils.isEmpty((String)this.txtBackupEMail.getText()) && !(matcher = emailPattern.matcher(this.txtBackupEMail.getText())).find()) {
            this.txtBackupEMail.requestFocusInWindow();
            throw new PersonException(PersonException.BACKEMAIL_ERROR);
        }
    }

    protected String getClassAlise() {
        return EmpEditItemEnum.EMP_CONTACTMETHOD.getAlias();
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (this.getUIContext().get("NO_PERMISSION") == null) {
            super.handlePermissionForItemAction(action);
        }
    }

    private void changeMobileNumberToDBC() {
        this.txtHomePhone.setText(EmployeeClientUtils.ToDBC(this.txtHomePhone.getText()));
        this.txtBackupHomePhone.setText(EmployeeClientUtils.ToDBC(this.txtBackupHomePhone.getText()));
        this.txtOfficePhone.setText(EmployeeClientUtils.ToDBC(this.txtOfficePhone.getText()));
        this.txtBackupOfficPhone.setText(EmployeeClientUtils.ToDBC(this.txtBackupOfficPhone.getText()));
        this.txtMobile.setText(EmployeeClientUtils.ToDBC(this.txtMobile.getText()));
        this.txtBackupMobile.setText(EmployeeClientUtils.ToDBC(this.txtBackupMobile.getText()));
    }

    @Override
    protected void txtHomePhone_focusLost(FocusEvent e) throws Exception {
        this.txtHomePhone.setText(EmployeeClientUtils.ToDBC(this.txtHomePhone.getText()));
        super.txtHomePhone_focusLost(e);
    }

    @Override
    protected void txtBackupHomePhone_focusLost(FocusEvent e) throws Exception {
        this.txtBackupHomePhone.setText(EmployeeClientUtils.ToDBC(this.txtBackupHomePhone.getText()));
        super.txtBackupHomePhone_focusLost(e);
    }

    @Override
    protected void txtOfficePhone_focusLost(FocusEvent e) throws Exception {
        this.txtOfficePhone.setText(EmployeeClientUtils.ToDBC(this.txtOfficePhone.getText()));
        super.txtOfficePhone_focusLost(e);
    }

    @Override
    protected void txtBackupOfficPhone_focusLost(FocusEvent e) throws Exception {
        this.txtBackupOfficPhone.setText(EmployeeClientUtils.ToDBC(this.txtBackupOfficPhone.getText()));
        super.txtBackupOfficPhone_focusLost(e);
    }

    @Override
    protected void txtMobile_focusLost(FocusEvent e) throws Exception {
        this.txtMobile.setText(EmployeeClientUtils.ToDBC(this.txtMobile.getText()));
        super.txtMobile_focusLost(e);
    }

    @Override
    protected void txtBackupMobile_focusLost(FocusEvent e) throws Exception {
        this.txtBackupMobile.setText(EmployeeClientUtils.ToDBC(this.txtBackupMobile.getText()));
        super.txtBackupMobile_focusLost(e);
    }

    @Override
    protected void txtEmail_focusLost(FocusEvent e) throws Exception {
        this.txtEmail.setText(EmployeeClientUtils.ToDBC(this.txtEmail.getText()));
        super.txtEmail_focusLost(e);
    }

    @Override
    protected void txtBackupEMail_focusLost(FocusEvent e) throws Exception {
        this.txtBackupEMail.setText(EmployeeClientUtils.ToDBC(this.txtBackupEMail.getText()));
        super.txtBackupEMail_focusLost(e);
    }
}

