/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.hr.base.PositionStatuEnum;
import com.kingdee.eas.hr.base.client.CustomFilterBuilder;
import com.kingdee.eas.hr.base.client.DataProviderSetting;
import com.kingdee.eas.hr.emp.EmpOrgRelationNoteFacadeFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class EmployeeDetailNoteDataProvider
extends DefaultNoteDataProvider {
    private FilterInfo personFilter = null;
    private Map orgNameLengParamMap = new HashMap();

    public EmployeeDetailNoteDataProvider(FilterInfo personFilter, Map orgNameLengParamMap) {
        this.personFilter = personFilter;
        this.orgNameLengParamMap = orgNameLengParamMap;
        DataProviderSetting.addDataSource((DefaultNoteDataProvider)this, (DataProviderSetting)this.getDataProviderSetting());
    }

    public EmployeeDetailNoteDataProvider(FilterInfo personFilter) {
        this(personFilter, null);
    }

    private DataProviderSetting getDataProviderSetting() {
        String dsName = "ds_baseInfo";
        String query = "com.kingdee.eas.hr.emp.app.EmployeeBaseInfoQuery";
        DataProviderSetting mainDs = new DataProviderSetting(dsName);
        mainDs.setQueryPK((IMetaDataPK)new MetaDataPK(query));
        mainDs.setFilter(new DataProviderSetting.IHRCustomFilter(){

            public void build(CustomFilterBuilder builder) {
                builder.setFilter(EmployeeDetailNoteDataProvider.this.personFilter);
            }
        });
        DataProviderSetting subDs = null;
        this.addSubDs(mainDs, "ds_degree", "com.kingdee.eas.hr.emp.app.EmployeeDegreeQuery", "personId");
        subDs = this.addSubDs(mainDs, "ds_primaryPosition", "com.kingdee.eas.hr.emp.app.EmployeePrimaryPositionInfoQuery", "id");
        subDs.setFilter(new DataProviderSetting.IHRCustomFilter(){

            public void build(CustomFilterBuilder builder) {
                Date date = DateTimeUtils.truncateDate((Date)new Date());
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("baseDate", (Object)date, CompareType.LESS_EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("quitDate", (Object)date, CompareType.GREATER));
                filter.getFilterItems().add(new FilterItemInfo("FPositionStatus", (Object)PositionStatuEnum.InActive, CompareType.NOTEQUALS));
                builder.setFilter(filter);
            }
        });
        this.addSubDs(mainDs, "ds_language", "com.kingdee.eas.hr.emp.app.EmployeeLanguagePrintQuery", "Person.id");
        this.addSubDs(mainDs, "ds_contract", "com.kingdee.eas.hr.emp.app.EmployeeContractQuery", "employee.id");
        this.addSubDs(mainDs, "ds_rewordPunish", "com.kingdee.eas.hr.emp.app.PersonRewardPunishPrintQuery", "Person.id");
        this.addSubDs(mainDs, "ds_archive", "com.kingdee.eas.hr.emp.app.PersonArchivesPrintQuery", "Person.id");
        this.addSubDs(mainDs, "ds_linkMen", "com.kingdee.eas.hr.emp.app.PersonLinkmanPrintQuery", "Person.id");
        this.addSubDs(mainDs, "ds_certificate", "com.kingdee.eas.hr.emp.app.EmployeeCertifyPrintQuery", "Person.id");
        this.addSubDs(mainDs, "ds_communist", "com.kingdee.eas.hr.emp.app.PersonCommunistPrintQuery", "Person.id");
        this.addSubDs(mainDs, "ds_contactMethod", "com.kingdee.eas.hr.emp.app.PersonContactMethodPrintQuery", "Person.id");
        this.addSubDs(mainDs, "ds_workExp", "com.kingdee.eas.hr.emp.app.EmployeeWorkExpQuery", "Person.id");
        subDs = this.addSubDs(mainDs, "ds_workExpCur", "com.kingdee.eas.hr.emp.app.EmployeeWorkExpCurQuery", "Person.id");
        this.addSubDs(mainDs, "ds_family", "com.kingdee.eas.hr.emp.app.EmployeeFamilyQuery", "Person.id");
        this.addSubDs(mainDs, "ds_compet", "com.kingdee.eas.hr.emp.app.EmployeeCompetIndexQuery", "Person.id");
        this.addSubDs(mainDs, "ds_post", "com.kingdee.eas.hr.emp.app.EmployeeTechnicalPostQuery", "Person.id");
        this.addSubDs(mainDs, "ds_train", "com.kingdee.eas.hr.emp.app.EmployeeTrainQuery", "employee.id");
        this.addSubDs(mainDs, "ds_benefit", "com.kingdee.eas.hr.benefit.app.EmpBenefitQuery", "Person.id");
        this.addSubDs(mainDs, "ds_resource", "com.kingdee.eas.hr.emp.app.PersonResourcePrintQuery", "Person.id");
        return mainDs;
    }

    private DataProviderSetting addSubDs(DataProviderSetting dpSeting, String dsName, String queryName, String foreignKey) {
        DataProviderSetting subDs = new DataProviderSetting(dsName);
        subDs.setQueryPK((IMetaDataPK)new MetaDataPK(queryName));
        subDs.setForeignKey(foreignKey);
        DataProviderSetting ds = dpSeting;
        while (ds.next() != null) {
            ds = ds.next();
        }
        ds.append(subDs);
        return subDs;
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        IRowSet rs = null;
        String dsId = dataSource.getId();
        if (dsId.equalsIgnoreCase("ds_workExpCur")) {
            if (dataSource.getParamCount() < 1) {
                System.out.println("The relationship between employment history and basic employee information has not been set: template - Data - data parameter setting");
            } else {
                String personid = dataSource.getParam(0).getValue().toString();
                String compareExpr = dataSource.getParam(0).getId();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo(compareExpr, (Object)personid));
                rs = EmpOrgRelationNoteFacadeFactory.getRemoteInstance().getHisWorkExp(filter);
            }
        } else {
            rs = super.getData(dataSource);
        }
        this.handleRowSet(dataSource, rs);
        return rs;
    }

    private void handleRowSet(R1PrintDataSource dataSource, IRowSet rs) throws Exception {
        String dsId = dataSource.getId();
        if ("ds_primaryPosition".equals(dsId)) {
            this.handlePrimarPositionRowSet(rs);
        }
    }

    private void handlePrimarPositionRowSet(IRowSet rs) throws Exception {
        Map map = this.orgNameLengParamMap;
        if (map == null || map.size() == 0) {
            return;
        }
        if (map.get("btnSelected") == null || map.get("btnSelected").equals("radiobtn0")) {
            while (rs.next()) {
                String fullName = rs.getString("AdminOrgUnit.displayName");
                rs.updateString("adminOrgUnit", fullName);
            }
        } else if ("radiobtn1".equals(map.get("btnSelected"))) {
            if (map.get("adminName") != null) {
                String adminName = map.get("adminName").toString();
                while (rs.next()) {
                    String oldAdminName = rs.getString("AdminOrgUnit.displayName");
                    String newAdminName = this.setAdminNameFromCurAdmin(adminName, oldAdminName);
                    rs.updateString("adminOrgUnit", newAdminName);
                }
            }
        } else if ("radiobtn2".equals(map.get("btnSelected"))) {
            int level = 0;
            String levelStr = map.get("level").toString();
            if (levelStr != null) {
                level = Integer.parseInt(levelStr);
            }
            while (rs.next()) {
                String oldAdminName = rs.getString("AdminOrgUnit.displayName");
                String newAdminName = this.setAdminNameByLevel(level, oldAdminName);
                rs.updateString("adminOrgUnit", newAdminName);
            }
        }
        rs.beforeFirst();
    }

    private String setAdminNameFromCurAdmin(String CurAdminName, String oldAdminName) {
        int index;
        String newAdminName = null;
        String[] names = oldAdminName.split("_");
        for (index = 0; index < names.length && !CurAdminName.equals(names[index]); ++index) {
        }
        StringBuffer sb = new StringBuffer(names[index]);
        for (int i = index + 1; i < names.length; ++i) {
            sb.append("_").append(names[i]);
        }
        newAdminName = sb.toString();
        return newAdminName;
    }

    private String setAdminNameByLevel(int levelNum, String oldAdminName) {
        String newAdminName = null;
        String[] names = oldAdminName.split("_");
        int num = names.length - levelNum;
        if (num <= 0) {
            return oldAdminName;
        }
        StringBuffer sb = new StringBuffer(names[num]);
        for (int i = num + 1; i < names.length; ++i) {
            sb.append("_").append(names[i]);
        }
        newAdminName = sb.toString();
        return newAdminName;
    }
}

