/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.JobPromptBox;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.EmployeeJobGradeHistoryFactory;
import com.kingdee.eas.hr.emp.EmployeeJobGradeHistoryInfo;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeJobGradeHistoryEditUI;
import com.kingdee.eas.hr.org.JobLevelFactory;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.org.OrgHRCommonFactory;
import com.kingdee.eas.hr.org.client.JobGradePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class EmployeeJobGradeHistoryEditUI
extends AbstractEmployeeJobGradeHistoryEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EmployeeJobGradeHistoryEditUI.class);
    private String resClass = "com.kingdee.eas.hr.emp.EmployeeResource.";
    private boolean isLoaded = false;
    private boolean isChange = false;
    private HROrgUnitInfo hroInfo = null;

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.initPrompt();
        if (this.prmtPosition.getData() != null) {
            this.changePrmtJobGradeContextByCUSet((PositionInfo)this.prmtPosition.getData());
        }
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.hroInfo = (HROrgUnitInfo)this.getUIContext().get("currentHRO");
    }

    public IObjectPK runSubmit() throws Exception {
        this.editData.setCU(this.getCurrentCU());
        return super.runSubmit();
    }

    @Override
    public void loadFields() {
        this.isLoaded = false;
        try {
            this.setJobLevelFilter();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        super.loadFields();
        if (this.editData != null) {
            this.prmtJobGrade.setData((Object)this.editData.getJobGrade());
        } else {
            this.prmtJobGrade.setData(null);
        }
        this.isLoaded = true;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected IObjectValue createNewData() {
        EmployeeJobGradeHistoryInfo info = new EmployeeJobGradeHistoryInfo();
        PersonInfo pInfo = new PersonInfo();
        pInfo.setId(BOSUuid.read((String)this.getUIContext().get("PersonID").toString()));
        info.setPerson(pInfo);
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return EmployeeJobGradeHistoryFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionRemove.setVisible(false);
        } else {
            this.actionAddNew.setVisible(true);
            this.actionEdit.setVisible(true);
            this.actionCopy.setVisible(true);
            this.actionSubmit.setVisible(true);
            this.actionRemove.setVisible(true);
        }
        this.prmtPosition.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                PositionInfo pInfo = (PositionInfo)arg0.getNewValue();
                if (EmployeeJobGradeHistoryEditUI.this.isLoaded) {
                    if (pInfo == null) {
                        return;
                    }
                    EmployeeJobGradeHistoryEditUI.this.prmtJob.setData((Object)pInfo.getJob());
                    EmployeeJobGradeHistoryEditUI.this.isChange = true;
                    try {
                        EmployeeJobGradeHistoryEditUI.this.setJobLevelFilter();
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
                if (pInfo != null) {
                    EmployeeJobGradeHistoryEditUI.this.changePrmtJobGradeContextByCUSet(pInfo);
                }
            }
        });
        this.prmtJob.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    EmployeeJobGradeHistoryEditUI.this.setJobLevelFilter();
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
        this.prmtJobLevel.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    JobLevelInfo jobLevelInfo = (JobLevelInfo)arg0.getNewValue();
                    if (jobLevelInfo == null) {
                        EmployeeJobGradeHistoryEditUI.this.prmtJobGrade.setData(null);
                        return;
                    }
                    if ("EDIT".equals(EmployeeJobGradeHistoryEditUI.this.getOprtState()) || "ADDNEW".equals(EmployeeJobGradeHistoryEditUI.this.getOprtState())) {
                        String oql = "select *,jobGrade.* where id='" + jobLevelInfo.getId() + "'";
                        jobLevelInfo = JobLevelFactory.getRemoteInstance().getJobLevelInfo(oql);
                        if (null != jobLevelInfo) {
                            EmployeeJobGradeHistoryEditUI.this.prmtJobGrade.setData((Object)jobLevelInfo.getJobGrade());
                        } else {
                            EmployeeJobGradeHistoryEditUI.this.prmtJobGrade.setData(null);
                        }
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
    }

    private EntityViewInfo getEntityViewInfoByCU(HashSet cuSet) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (cuSet != null && cuSet.size() > 0) {
            Iterator it = cuSet.iterator();
            HashSet<String> cuidSet = new HashSet<String>();
            Object ob = null;
            while (it.hasNext()) {
                ob = it.next();
                if (ob instanceof CtrlUnitInfo) {
                    cuidSet.add(((CtrlUnitInfo)ob).getId().toString());
                    continue;
                }
                cuidSet.add(ob);
            }
            filter.getFilterItems().add(new FilterItemInfo("toAdminCU.id", cuidSet, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("jobGradeModuleState.enable", (Object)"1"));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private void initPrompt() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ALL_ADMIN", "TRUE");
        this.prmtPosition.setSelector((KDPromptSelector)new PositionPromptBox2((IUIObject)this, map));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("CU.id"));
        this.prmtPosition.setSelectorCollection(selector);
        this.prmtPosition.setEditable(false);
        JobPromptBox prmt = new JobPromptBox((IUIObject)this);
        HashSet<CtrlUnitInfo> set = new HashSet<CtrlUnitInfo>();
        set.add(this.getCurrentCU());
        prmt.changeContextByCUSet(set);
        this.prmtJob.setSelector((KDPromptSelector)prmt);
        JobGradePromptBox jobBox = new JobGradePromptBox((IUIObject)this);
        HashSet<CtrlUnitInfo> cuSet = new HashSet<CtrlUnitInfo>();
        cuSet.add(this.getCurrentCU());
        jobBox.changeContextByCUSet(cuSet);
        this.prmtJobGrade.setSelector((KDPromptSelector)jobBox);
        this.prmtJobGrade.setEntityViewInfo(this.getEntityViewInfoByCU(cuSet));
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.hroInfo != null) {
            return this.hroInfo.getCU();
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.hroInfo != null) {
            return this.hroInfo;
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCurrentCU().getId());
    }

    private void setJobLevelFilter() throws EASBizException, BOSException {
        JobInfo jobInfo = null;
        jobInfo = this.prmtJob.getData() != null ? (JobInfo)this.prmtJob.getData() : this.editData.getJob();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (jobInfo == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Job.id", (Object)"nodata"));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("Job.id", (Object)jobInfo.getId()));
        }
        evi.setFilter(filterInfo);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.prmtJobGrade.getData() == null) {
            throw new EmployeeException(EmployeeException.EMP_JOBGRADE_NULL);
        }
        if (this.pkJobGradeStartDate.getValue() == null) {
            throw new EmployeeException(EmployeeException.EMP_JOBGRADE_STARTDATE_NULL);
        }
        if (this.pkJobGradeStartDate.getValue() != null && this.pkJobGradeEndDate.getValue() != null && DateTimeUtils.dayAfter((Date)((Date)this.pkJobGradeStartDate.getValue()), (Date)((Date)this.pkJobGradeEndDate.getValue()))) {
            throw new EmployeeException(EmployeeException.EMP_JOBGRADE_STARTDATE_ERROR);
        }
    }

    private void changePrmtJobGradeContextByCUSet(PositionInfo pInfo) {
        if (null != this.prmtJobGrade.getSelector()) {
            JobGradePromptBox jobBox = (JobGradePromptBox)this.prmtJobGrade.getSelector();
            HashSet<CtrlUnitInfo> cuSet = new HashSet<CtrlUnitInfo>();
            CtrlUnitInfo pInfoCu = null;
            try {
                if (null == pInfo || null == pInfo.getId()) {
                    return;
                }
                pInfoCu = OrgHRCommonFactory.getRemoteInstance().getPositionOrgCU(pInfo.getId().toString());
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (pInfoCu == null) {
                MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "PositionAdminOrgHasNoHRO")));
                this.prmtPosition.setValue(null);
                return;
            }
            cuSet.add(pInfoCu);
            this.prmtJobGrade.setEntityViewInfo(this.getEntityViewInfoByCU(cuSet));
            jobBox.changeContextByCUSet(cuSet);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.prmtJobGrade.setData(null);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selector = super.getSelectors();
        selector.add(new SelectorItemInfo("person.id"));
        return selector;
    }
}

