/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.TechnicalPostInfo;
import com.kingdee.eas.hr.base.client.ListEditUI;
import com.kingdee.eas.hr.base.client.TechnicalPostPromptBox;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IPersonTechnicalPost;
import com.kingdee.eas.hr.emp.PersonTechnicalPostCollection;
import com.kingdee.eas.hr.emp.PersonTechnicalPostFactory;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeTechnicalUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.IEmpInfoUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JButton;

public class EmployeeTechnicalUI
extends AbstractEmployeeTechnicalUI
implements IEmpInfoUI {
    private String empId = null;
    private PersonInfo pInfo = null;
    private ArrayList delList = new ArrayList();
    int rowID = 0;

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.refresh();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionInsert_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsert_actionPerformed(e);
        IRow curRow = EmployeeClientUtils.addNewKDTableRow(this.tblMain);
        curRow.getCell("conferDate").setValue((Object)new Date());
        curRow.getCell("isHighTechnical").setValue((Object)false);
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        int rowID = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (rowID == -1) {
            return;
        }
        boolean isHeight = (Boolean)this.tblMain.getRow(rowID).getCell("isHighTechnical").getValue();
        if (isHeight) {
            throw new EmployeeException(EmployeeException.MUST_EXIST_ONE_HEIGHTTECHPOST);
        }
        EmployeeClientUtils.deleteKDTableRow(this.tblMain, this.delList);
    }

    @Override
    public void secondLoad() throws Exception {
        this.firstOnLoad();
    }

    public void firstOnLoad() throws Exception {
        this.refresh();
    }

    private PersonTechnicalPostCollection getPLColl(String empId) throws BOSException {
        IPersonTechnicalPost ipl = PersonTechnicalPostFactory.getRemoteInstance();
        String oql = "select *, technicalPost.*,technicalPost.category.*,technicalPost.level.*";
        oql = oql + " where person.id = '" + empId + "' order by isHighTechnical DESC";
        return ipl.getPersonTechnicalPostCollection(oql);
    }

    private void refresh() throws Exception {
        this.tblMain.removeRows();
        this.loadPersonTechnicalContract();
    }

    private void loadPersonTechnicalContract() throws Exception {
        if (this.getUIContext().get("ID") != null) {
            this.empId = this.getUIContext().get("ID").toString();
        }
        PersonTechnicalPostCollection c = this.getPLColl(this.empId);
        IRow row = null;
        for (int i = 0; i < c.size(); ++i) {
            row = this.tblMain.addRow();
            EmployeeClientUtils.setTableCellValueByInfo(row, c.get(i));
        }
    }

    public void onLoad() throws Exception {
        this.empId = (String)this.getUIContext().get("ID");
        super.onLoad();
        EmployeeClientUtils.initTableBtn((JButton)this.btnInsert, (JButton)this.btnDelete);
        this.tblMain.checkParsed();
        this.setTableCellEditor();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            EmployeeClientUtils.setKDTableViewState(this.tblMain);
            this.btnInsert.setEnabled(false);
            this.btnDelete.setEnabled(false);
        }
        this.tblMain.getColumn("technicalType").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("technicalLevel").getStyleAttributes().setLocked(true);
        this.tblMain.getStyleAttributes().setWrapText(true);
        EmployeeClientUtils.setColumnBackColor(this.tblMain, "technicalPost");
        this.firstOnLoad();
        this.initCellEditLength();
    }

    void initCellEditLength() {
        EmployeeClientUtils.setCellEditor(this.tblMain, "technicalCont");
        EmployeeClientUtils.setCellEditor(this.tblMain, "gradeUnit");
        EmployeeClientUtils.setCellEditor(this.tblMain, "certificateNo");
        EmployeeClientUtils.setCellEditor(this.tblMain, "description");
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    EmployeeTechnicalUI.this.tblMain_editStopped(e);
                }
                catch (Exception exc) {
                    EmployeeTechnicalUI.this.handUIException(exc);
                }
            }

            public void editStopping(KDTEditEvent e) {
                try {
                    EmployeeTechnicalUI.this.tblMain_editStopping(e);
                }
                catch (Exception exc) {
                    EmployeeTechnicalUI.this.handUIException(exc);
                }
            }

            public void editStarted(KDTEditEvent e) {
                try {
                    EmployeeTechnicalUI.this.tblMain_editStarted(e);
                }
                catch (Exception exc) {
                    EmployeeTechnicalUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
    }

    protected void tblMain_editStopping(KDTEditEvent e) throws Exception {
    }

    protected void tblMain_editStarted(KDTEditEvent e) throws Exception {
        if (e.getColIndex() == 4 && ((Boolean)e.getValue()).booleanValue()) {
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                if (e.getRowIndex() == i) continue;
                this.tblMain.getRow(i).getCell("isHighTechnical").setValue((Object)Boolean.FALSE);
            }
        }
    }

    void setTableCellEditor() {
        KDBizPromptBox promptBox = new KDBizPromptBox();
        promptBox.setSelector((KDPromptSelector)new TechnicalPostPromptBox((IUIObject)this));
        promptBox.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    EmployeeTechnicalUI.this.initTechnicalTypeAndLevel(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                EmployeeTechnicalUI.this.rowID = e.getRowIndex();
            }
        });
        this.tblMain.getColumn("technicalPost").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBox));
        this.tblMain.getColumn("conferDate").setEditor(EmployeeClientUtils.getStartDateCellEditor());
        this.tblMain.getColumn("conferDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    void initTechnicalTypeAndLevel(PreChangeEvent e) {
        if (e.getData() != null) {
            TechnicalPostInfo info = (TechnicalPostInfo)e.getData();
            this.tblMain.getRow(this.rowID).getCell("technicalType").setValue((Object)info.getCategory());
            this.tblMain.getRow(this.rowID).getCell("technicalLevel").setValue((Object)info.getLevel());
        } else {
            this.tblMain.getRow(this.rowID).getCell("technicalType").setValue(null);
            this.tblMain.getRow(this.rowID).getCell("technicalLevel").setValue(null);
        }
    }

    @Override
    public void submit() throws Exception {
        this.checkInput();
        IObjectPK[] delArray = new IObjectPK[this.delList.size()];
        for (int i = 0; i < this.delList.size(); ++i) {
            delArray[i] = new ObjectUuidPK((BOSUuid)this.delList.get(i));
        }
        IPersonTechnicalPost ipl = PersonTechnicalPostFactory.getRemoteInstance();
        PersonTechnicalPostCollection techInfos = EmployeeClientUtils.getPersonTechnicalPostCollectionByKDTable(this.tblMain, EmployeeClientUtils.getPersonInfo(this.empId));
        this.checkIsHighestDup(techInfos);
        ipl.saveAll(techInfos, delArray);
        ListEditUI listEditUI = (ListEditUI)this.getUIContext().get("ListEditUI");
        listEditUI.setStatusBarMessage();
        this.refresh();
    }

    private void checkIsHighestDup(PersonTechnicalPostCollection tectInfos) throws EmployeeException {
        int iCounts = 0;
        for (int i = 0; i < tectInfos.size(); ++i) {
            if (!tectInfos.get(i).isIsHighTechnical()) continue;
            ++iCounts;
        }
        if (iCounts == 0) {
            throw new EmployeeException(EmployeeException.MUST_EXIST_LESS_ONE_TECHNICAL);
        }
        if (iCounts > 1) {
            throw new EmployeeException(EmployeeException.MUST_EXIST_ONE_TECHNICAL);
        }
    }

    private void checkInput() throws Exception {
        EmployeeClientUtils.checkHasInputRows(this.tblMain, this.delList);
        EmployeeClientUtils.checkTableCellIsNull(this.tblMain, "technicalPost");
        int iHeightCounts = 0;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            if (!((Boolean)this.tblMain.getRow(i).getCell("isHighTechnical").getValue()).booleanValue()) continue;
            ++iHeightCounts;
        }
        if (iHeightCounts > 1) {
            throw new EmployeeException(EmployeeException.NOT_EXIST_TWO_HEIGHTTECHNOL);
        }
    }

    @Override
    public void setAddNewState() throws Exception {
        EmployeeClientUtils.setAddNewState((CoreUI)this);
        this.refresh();
    }

    @Override
    public void setEmpID(String empId) {
        this.empId = empId;
    }

    @Override
    public void setEnabled(boolean isArchives) {
        if (!isArchives) {
            this.tblMain.setEnabled(false);
            this.btnInsert.setEnabled(false);
            this.btnDelete.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.submit();
    }

    protected void inOnload() throws Exception {
    }
}

