/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.eas.hr.emp.client.HRCellTreeRenderer;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;

public class HRTreeTable {
    public static void setHRTreeTable(final KDTable table1, final String colName) {
        table1.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (table1.getID().equals("JOB")) {
                    return;
                }
                int row = e.getRowIndex();
                int column = e.getColIndex();
                HRTreeTable.cellClicked(table1, colName, row, column, e.getX(), e.getY());
            }
        });
    }

    private static void cellClicked(KDTable table, String colName, int row, int column, int x, int y) {
        if (row > -1 && column == table.getColumnIndex(colName)) {
            if (table.getRow(row) == null || table.getRow(row).getCell(column).getValue() == null || !(table.getRow(row).getCell(column).getValue() instanceof HRCellUserObject)) {
                return;
            }
            HRCellUserObject comUserObject = (HRCellUserObject)table.getRow(row).getCell(column).getValue();
            HRCellTreeRenderer virtureCompanyRender = (HRCellTreeRenderer)table.getRow(row).getCell(column).getRenderer();
            if (virtureCompanyRender.inRect(comUserObject, x, y)) {
                try {
                    HRTreeTable.doExpand(table, colName, comUserObject, row);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static int expandRow(KDTable table, String strColName, int rowIndex) {
        IRow row = table.getRow(rowIndex);
        int rowCount = table.getRowCount();
        HRCellUserObject comUserObject = (HRCellUserObject)row.getCell(strColName).getValue();
        while (++rowIndex < rowCount) {
            IRow row2 = table.getRow(rowIndex);
            HRCellUserObject companyUserObject2 = (HRCellUserObject)row2.getCell(strColName).getValue();
            if (companyUserObject2.getLevel() > comUserObject.getLevel()) {
                row2.getStyleAttributes().setHided(false);
                if (companyUserObject2.isExpanded()) {
                    rowIndex = HRTreeTable.expandRow(table, strColName, rowIndex);
                    continue;
                }
                if (companyUserObject2.isLeaf()) continue;
                rowIndex = HRTreeTable.expandSkipChildren(table, strColName, rowIndex);
                continue;
            }
            --rowIndex;
            break;
        }
        return rowIndex;
    }

    private static int expandSkipChildren(KDTable table, String strColName, int rowIndex) {
        IRow row2;
        HRCellUserObject companyUserObject2;
        IRow row = table.getRow(rowIndex);
        int rowCount = table.getRowCount();
        HRCellUserObject companyUserObject = (HRCellUserObject)row.getCell(strColName).getValue();
        while (++rowIndex < rowCount && (companyUserObject2 = (HRCellUserObject)(row2 = table.getRow(rowIndex)).getCell(strColName).getValue()).getLevel() != companyUserObject.getLevel()) {
        }
        return rowIndex - 1;
    }

    private static void doExpand(KDTable table, String strColName, HRCellUserObject comUserObject, int rowIndex) throws Exception {
        int rowCount = table.getRowCount();
        if (comUserObject.isLeaf()) {
            return;
        }
        table.setRefresh(false);
        if (comUserObject.isExpanded()) {
            IRow row2;
            HRCellUserObject company2;
            for (int i = rowIndex + 1; i < rowCount && (company2 = (HRCellUserObject)(row2 = table.getRow(i)).getCell(strColName).getValue()).getLevel() > comUserObject.getLevel(); ++i) {
                row2.getStyleAttributes().setHided(true);
            }
            comUserObject.setExpanded(false);
        } else if (comUserObject.isHasExpanded()) {
            HRTreeTable.expandRow(table, strColName, rowIndex);
            comUserObject.setExpanded(true);
        } else {
            HRTreeTable.expandRow(table, strColName, rowIndex);
            comUserObject.setExpanded(true);
            comUserObject.setHasExpanded(true);
        }
        table.setRefresh(true);
        table.repaint();
    }
}

