/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.eas.hr.emp.client.EmployeePhoto;
import com.kingdee.eas.hr.emp.client.photoFileNameFilter;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class ImageSourcePanel
extends Canvas {
    private boolean selecting;
    private boolean crisis;
    private int activeHandle = -1;
    private Rectangle[] handles = new Rectangle[8];
    private Rectangle rect = null;
    private BufferedImage srcImage = null;
    private BufferedImage endImg = null;
    private File selectFile = null;
    private EmployeePhoto ep = null;
    private int rx = 0;
    private int ry = 0;
    private int rw = 0;
    private int rh = 0;
    private int maxx = 0;
    private int maxy = 0;
    private int maxw = 0;
    private int maxh = 0;
    private int mrw = 0;
    private int mrh = 0;
    private int tx = 0;
    private int ty = 0;
    private static final float SCALE = 1.4f;
    private static final int MINW = 50;
    private static final int MINH = 70;
    private static final int ISW = 400;
    private static final int ISH = 380;
    private static final int HANDLEWH = 4;

    public ImageSourcePanel() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ImageSourcePanel.this.selecting || ImageSourcePanel.this.activeHandle >= 0) {
                    ImageSourcePanel.this.selecting = false;
                    ImageSourcePanel.this.crisis = false;
                    ImageSourcePanel.this.activeHandle = -1;
                    ImageSourcePanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (ImageSourcePanel.this.rect != null && ((ImageSourcePanel)ImageSourcePanel.this).rect.x + 5 <= e.getX() && e.getX() <= ((ImageSourcePanel)ImageSourcePanel.this).rect.x + ((ImageSourcePanel)ImageSourcePanel.this).rect.width - 5 && ((ImageSourcePanel)ImageSourcePanel.this).rect.y + 5 <= e.getY() && e.getY() <= ((ImageSourcePanel)ImageSourcePanel.this).rect.y + ((ImageSourcePanel)ImageSourcePanel.this).rect.height - 5) {
                    ImageSourcePanel.this.selecting = true;
                    ImageSourcePanel.this.tx = e.getX() - ((ImageSourcePanel)ImageSourcePanel.this).rect.x;
                    ImageSourcePanel.this.ty = e.getY() - ((ImageSourcePanel)ImageSourcePanel.this).rect.y;
                    ImageSourcePanel.this.setCursor(Cursor.getPredefinedCursor(13));
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                for (int i = 0; i < ImageSourcePanel.this.handles.length; ++i) {
                    if (ImageSourcePanel.this.handles[i] == null || !ImageSourcePanel.this.handles[i].contains(e.getX(), e.getY())) continue;
                    ImageSourcePanel.this.activeHandle = i;
                    switch (i) {
                        case 0: 
                        case 4: {
                            ImageSourcePanel.this.setCursor(Cursor.getPredefinedCursor(5));
                            break;
                        }
                        case 1: 
                        case 5: {
                            ImageSourcePanel.this.setCursor(Cursor.getPredefinedCursor(9));
                            break;
                        }
                        case 2: 
                        case 6: {
                            ImageSourcePanel.this.setCursor(Cursor.getPredefinedCursor(4));
                            break;
                        }
                        case 3: 
                        case 7: {
                            ImageSourcePanel.this.setCursor(Cursor.getPredefinedCursor(11));
                        }
                    }
                    return;
                }
                ImageSourcePanel.this.activeHandle = -1;
                if (ImageSourcePanel.this.rect != null && ImageSourcePanel.this.rect.contains(e.getX(), e.getY())) {
                    ImageSourcePanel.this.setCursor(Cursor.getPredefinedCursor(13));
                } else {
                    ImageSourcePanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                ImageSourcePanel.this.update((Graphics2D)ImageSourcePanel.this.getGraphics().create());
                if (ImageSourcePanel.this.activeHandle >= 0) {
                    ImageSourcePanel.this.dragHandle(e.getX(), e.getY());
                } else {
                    ImageSourcePanel.this.dragRect(e.getX(), e.getY());
                }
            }
        });
    }

    private void dragHandle(int ex, int ey) {
        if (this.maxx + 2 <= ex && ex <= this.maxx + this.maxw - 2 && this.maxy + 2 <= ey && ey <= this.maxy + this.maxh - 2) {
            int middleX = this.rect.x + this.rect.width / 2;
            int middleY = this.rect.y + this.rect.height / 2;
            switch (this.activeHandle) {
                case 0: {
                    this.rect.width -= ex - this.rect.x;
                    if (this.rect.width < 50) {
                        this.rect.width = 50;
                        this.crisis = true;
                    } else if (this.rect.width >= this.mrw - 5) {
                        this.rect.width = this.mrw - 5;
                        this.crisis = true;
                    } else {
                        this.crisis = false;
                    }
                    if (this.rect.height < 70) {
                        this.rect.height = 70;
                    }
                    this.rect.y = this.rect.y + this.rect.height - (int)((float)this.rect.width * 1.4f);
                    this.rect.height = (int)((float)this.rect.width * 1.4f);
                    if (this.crisis) {
                        this.rect.x = this.rect.x;
                        break;
                    }
                    this.rect.x = ex;
                    break;
                }
                case 1: {
                    this.rect.height -= ey - this.rect.y;
                    this.rect.width = (int)((float)this.rect.height / 1.4f);
                    if (this.rect.height < 70) {
                        this.rect.height = 70;
                        this.crisis = true;
                    } else if (this.rect.height >= this.mrh - 5) {
                        this.rect.height = this.mrh - 5;
                        this.crisis = true;
                    } else {
                        this.crisis = false;
                    }
                    if (this.rect.width < 50) {
                        this.rect.width = 50;
                    }
                    this.rect.y = this.crisis ? this.rect.y : ey;
                    this.rect.x = middleX - this.rect.width / 2;
                    break;
                }
                case 2: {
                    this.rect.width = ex - this.rect.x;
                    if (this.rect.width < 50) {
                        this.rect.width = 50;
                        this.crisis = true;
                    } else if (this.rect.width >= this.mrw - 5) {
                        this.rect.width = this.mrw - 5;
                        this.crisis = true;
                    } else {
                        this.crisis = false;
                    }
                    if (this.rect.height < 70) {
                        this.rect.height = 70;
                    }
                    this.rect.y = this.rect.y + this.rect.height - (int)((float)this.rect.width * 1.4f);
                    this.rect.height = (int)((float)this.rect.width * 1.4f);
                    break;
                }
                case 3: {
                    this.rect.width = ex - this.rect.x;
                    this.rect.height = (int)((float)this.rect.width * 1.4f);
                    if (this.rect.width < 50) {
                        this.rect.width = 50;
                    }
                    if (this.rect.height < 70) {
                        this.rect.height = 70;
                    }
                    this.rect.y = middleY - this.rect.height / 2;
                    break;
                }
                case 4: {
                    this.rect.width = ex - this.rect.x;
                    this.rect.height = (int)((float)this.rect.width * 1.4f);
                    if (this.rect.width < 50) {
                        this.rect.width = 50;
                    }
                    if (this.rect.height >= 70) break;
                    this.rect.height = 70;
                    break;
                }
                case 5: {
                    this.rect.height = ey - this.rect.y;
                    this.rect.width = (int)((float)this.rect.height / 1.4f);
                    if (this.rect.width < 50) {
                        this.rect.width = 50;
                    }
                    if (this.rect.height < 70) {
                        this.rect.height = 70;
                    }
                    this.rect.x = middleX - this.rect.width / 2;
                    break;
                }
                case 6: {
                    this.rect.width -= ex - this.rect.x;
                    this.rect.height = (int)((float)this.rect.width * 1.4f);
                    if (this.rect.width < 50) {
                        this.rect.width = 50;
                        this.crisis = true;
                    } else if (this.rect.width >= this.mrw - 5) {
                        this.rect.width = this.mrw - 5;
                        this.crisis = true;
                    } else {
                        this.crisis = false;
                    }
                    if (this.rect.height < 70) {
                        this.rect.height = 70;
                    }
                    if (this.crisis) {
                        this.rect.x = this.rect.x;
                        break;
                    }
                    this.rect.x = ex;
                    break;
                }
                case 7: {
                    this.rect.width = this.rect.width - ex + this.rect.x;
                    if (this.rect.width < 50) {
                        this.rect.width = 50;
                        this.crisis = true;
                    } else if (this.rect.width >= this.mrw - 5) {
                        this.rect.width = this.mrw - 5;
                        this.crisis = true;
                    } else {
                        this.crisis = false;
                    }
                    this.rect.x = this.crisis ? this.rect.x : ex;
                    this.rect.height = (int)((float)this.rect.width * 1.4f);
                    this.rect.y = middleY - this.rect.height / 2;
                }
            }
            if (this.maxx + 2 > this.rect.x) {
                this.rect.x = this.maxx + 2;
            }
            if (this.maxy + 2 > this.rect.y) {
                this.rect.y = this.maxy + 2;
            }
            if (this.rect.width >= this.mrw - 5) {
                this.rect.width = this.mrw - 5;
            }
            if (this.rect.height >= this.mrh - 5) {
                this.rect.height = this.mrh - 5;
            }
            if (this.rect.x + this.rect.width > this.maxw + this.maxx - 3) {
                this.rect.x = this.maxx + this.maxw - this.rect.width - 3;
            }
            if (this.rect.y + this.rect.height > this.maxy + this.maxh - 3) {
                this.rect.y = this.maxy + this.maxh - this.rect.height - 3;
            }
        }
    }

    private void dragRect(int ex, int ey) {
        if (this.selecting) {
            this.rect.x = ex - this.tx;
            this.rect.y = ey - this.ty;
            if (this.maxx + 2 > this.rect.x) {
                this.rect.x = this.maxx + 2;
            }
            if (this.maxy + 2 > this.rect.y) {
                this.rect.y = this.maxy + 2;
            }
            if (this.rect.x + this.rect.width > this.maxw + this.maxx - 3) {
                this.rect.x = this.maxx + this.maxw - this.rect.width - 3;
            }
            if (this.rect.y + this.rect.height > this.maxy + this.maxh - 3) {
                this.rect.y = this.maxy + this.maxh - this.rect.height - 3;
            }
        }
    }

    public void drawRectangle(Rectangle rect) {
        Graphics2D graphics = (Graphics2D)this.getGraphics().create();
        graphics.setStroke(new BasicStroke(1.0f));
        graphics.setPaint(Color.BLUE);
        graphics.draw(rect);
        this.handles[0] = new Rectangle(rect.x - 2, rect.y - 2, 4, 4);
        this.handles[1] = new Rectangle(rect.x + rect.width / 2 - 2, rect.y - 2, 4, 4);
        this.handles[2] = new Rectangle(rect.x + rect.width - 2, rect.y - 2, 4, 4);
        this.handles[3] = new Rectangle(rect.x + rect.width - 2, rect.y + rect.height / 2 - 2, 4, 4);
        this.handles[4] = new Rectangle(rect.x + rect.width - 2, rect.y + rect.height - 2, 4, 4);
        this.handles[5] = new Rectangle(rect.x + rect.width / 2 - 2, rect.y + rect.height - 2, 4, 4);
        this.handles[6] = new Rectangle(rect.x - 2, rect.y + rect.height - 2, 4, 4);
        this.handles[7] = new Rectangle(rect.x - 2, rect.y + rect.height / 2 - 2, 4, 4);
        for (Rectangle handle : this.handles) {
            graphics.fill(handle);
        }
        for (Rectangle handle : this.handles) {
            graphics.draw(handle);
        }
    }

    public BufferedImage getCurrentImage(BufferedImage image, Rectangle rect) throws Exception {
        if (this.maxx == 0) {
            return image.getSubimage(rect.x, rect.y - this.maxy, rect.width, rect.height);
        }
        return image.getSubimage(rect.x - this.maxx, rect.y, rect.width, rect.height);
    }

    public void showAddImageDialog() throws Exception {
        FileDialog fd = new FileDialog(new Frame(), "", 0);
        fd.setFilenameFilter(new photoFileNameFilter());
        fd.setVisible(true);
        if (fd.getDirectory() != null) {
            this.selectFile = new File(fd.getDirectory(), fd.getFile());
        }
        if (this.selectFile != null) {
            this.srcImage = ImageIO.read(this.selectFile);
            if (this.srcImage == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)this.getGraphics().create();
            g2.setColor(Color.white);
            g2.fillRect(0, 0, 400, 380);
            int imgWidth = this.srcImage.getWidth();
            int imgHeight = this.srcImage.getHeight();
            float SCALEImg = (float)imgWidth / (float)imgHeight;
            float SCALEpanel = 1.0526316f;
            if (SCALEImg > SCALEpanel) {
                int pHeight = 400 * imgHeight / imgWidth;
                this.ry = (380 - pHeight) / 2;
                this.rh = pHeight;
                this.rx = (int)((400.0f - (float)pHeight / 1.4f) / 2.0f);
                this.rw = (int)((float)this.rh / 1.4f);
            } else {
                int pWidth = 380 * imgWidth / imgHeight;
                this.rx = (400 - pWidth) / 2;
                this.rw = pWidth;
                this.ry = (int)((380.0f - (float)pWidth * 1.4f) / 2.0f);
                this.rh = (int)((float)this.rw * 1.4f);
            }
            if (this.rect != null) {
                this.rect.x = this.rx + 2;
                this.rect.y = this.ry + 2;
                this.rect.width = this.rw - 5;
                this.rect.height = this.rh - 5;
            }
            this.repaint();
            this.ep = new EmployeePhoto();
            this.ep.setImage(this.srcImage);
        }
    }

    @Override
    public void update(Graphics g) {
        if (this.srcImage != null) {
            float SCALEpanel;
            int imgHeight;
            int imgWidth = this.srcImage.getWidth();
            float SCALEImg = (float)imgWidth / (float)(imgHeight = this.srcImage.getHeight());
            if (SCALEImg > (SCALEpanel = 1.0526316f)) {
                int pHeight = 400 * imgHeight / imgWidth;
                this.ry = (380 - pHeight) / 2;
                this.rh = pHeight;
                this.rx = (int)((400.0f - (float)pHeight / 1.4f) / 2.0f);
                this.rw = (int)((float)this.rh / 1.4f);
                this.maxx = 0;
                this.maxy = this.ry;
                this.maxw = 400;
                this.maxh = this.rh;
                this.mrw = this.rw;
                this.mrh = this.rh;
            } else {
                int pWidth = 380 * imgWidth / imgHeight;
                this.rx = (400 - pWidth) / 2;
                this.rw = pWidth;
                this.ry = (int)((380.0f - (float)pWidth * 1.4f) / 2.0f);
                this.rh = (int)((float)this.rw * 1.4f);
                this.maxx = this.rx;
                this.maxy = 0;
                this.maxw = this.rw;
                this.maxh = 380;
                if ((double)(imgHeight / imgWidth) < 1.4) {
                    this.mrw = 271;
                    this.mrh = 380;
                    this.rx = (400 - this.mrw) / 2;
                } else {
                    this.mrw = this.rw;
                    this.mrh = this.rh;
                }
            }
            this.srcImage = this.resizeImage(this.srcImage, this.maxw, this.maxh);
            g.drawImage(this.srcImage, this.maxx, this.maxy, this.maxw, this.maxh, null);
            if (this.rect == null) {
                this.rect = new Rectangle(this.rx + 2, this.ry + 2, this.rw - 5, this.rh - 5);
            }
            if (this.maxx + 2 > this.rect.x) {
                this.rect.x = this.maxx + 2;
            }
            if (!(SCALEImg > SCALEpanel) && (double)(imgHeight / imgWidth) < 1.4) {
                this.rect.x = this.rx + 2;
            }
            if (this.maxy + 2 > this.rect.y) {
                this.rect.y = this.maxy + 2;
            }
            if (this.rect.width >= this.mrw - 5) {
                this.rect.width = this.mrw - 5;
            }
            if (this.rect.height >= this.mrh - 5) {
                this.rect.height = this.mrh - 5;
            }
            if (this.rect.x + this.rect.width > this.maxw + this.maxx - 3) {
                this.rect.x = this.maxx + this.maxw - this.rect.width - 3;
            }
            if (this.rect.y + this.rect.height > this.maxy + this.maxh - 3) {
                this.rect.y = this.maxy + this.maxh - this.rect.height - 3;
            }
            this.rect.x = this.rect.x > 2 ? this.rect.x : 2;
            this.rect.y = this.rect.y > 2 ? this.rect.y : 2;
            this.rect.width = this.rect.width > 395 ? 395 : this.rect.width;
            this.rect.height = this.rect.height > 375 ? 375 : this.rect.height;
            this.drawRectangle(this.rect);
            try {
                this.endImg = this.getCurrentImage(this.srcImage, this.rect);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            EmployeePhoto.icp.setAndDrawCutImage(this.endImg);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.update(g);
    }

    public BufferedImage resizeImage(BufferedImage image, int width, int height) {
        BufferedImage outputImage = new BufferedImage(width, height, 1);
        Graphics graphics = outputImage.getGraphics();
        graphics.drawImage(image, 0, 0, width, height, null);
        graphics.dispose();
        return outputImage;
    }

    public BufferedImage getSrcImage() {
        return this.srcImage;
    }

    public void setSrcImage(BufferedImage srcImage) {
        this.srcImage = srcImage;
    }

    public File getSelectFile() {
        return this.selectFile;
    }

    public void setSelectFile(File selectFile) {
        this.selectFile = selectFile;
    }

    public BufferedImage getEndImg() {
        return this.endImg;
    }

    public void setEndImg(BufferedImage endImg) {
        this.endImg = endImg;
    }

    public boolean isSelecting() {
        return this.selecting;
    }

    public void setSelecting(boolean selecting) {
        this.selecting = selecting;
    }

    public int getActiveHandle() {
        return this.activeHandle;
    }

    public void setActiveHandle(int activeHandle) {
        this.activeHandle = activeHandle;
    }
}

