/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.core.fm.EJBAccessFactory;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.emp.EmpBatchDataHelper;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.FamilyEviteInfo;
import com.kingdee.eas.hr.emp.PersonDegreeFactory;
import com.kingdee.eas.hr.emp.PersonDegreeInfo;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.app.AbstractEmpBatFacadeControllerBean;
import com.kingdee.eas.hr.kt.CadreAuditInfo;
import com.kingdee.eas.hr.kt.CadreIntendanceInfo;
import com.kingdee.eas.hr.kt.CadreTellInfo;
import com.kingdee.eas.hr.org.PersonPlanFactory;
import com.kingdee.eas.hr.org.PosPerPlanInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EmpBatFacadeControllerBean
extends AbstractEmpBatFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.EmpBatFacadeControllerBean");

    @Override
    protected IRowSet _getDefaultScheme(Context ctx, Map param) throws BOSException, EASBizException {
        boolean hasMaintainScheme = false;
        String schID = "";
        if (param.containsKey("schID")) {
            hasMaintainScheme = true;
            schID = (String)param.get("schID");
        }
        if (hasMaintainScheme) {
            StringBuffer sql = new StringBuffer(512);
            sql.append(" select \r\n");
            sql.append(" page.fid as FPageID, \r\n");
            sql.append(" page.FName_" + ctx.getLocale() + " as FPageName, \r\n");
            sql.append(" page.FType as FIsSinglePage, \r\n");
            sql.append(" sch.FID as FSCHID, \r\n");
            sql.append(" sch.FParentID as FEMPSCHID, \r\n");
            sql.append(" 1 as FIsMaintainScheme,\r\n");
            sql.append(" page.FUIName as FUIName,\r\n");
            sql.append(" parent.FDPageContent as FDPageContent, \r\n");
            sql.append(" sch.FPageContent as FPageContent \r\n");
            sql.append(" from T_HR_EmpBESE sch \r\n");
            sql.append(" inner join T_HR_EmpBES parent \r\n");
            sql.append(" on parent.fid = sch.Fparentid \r\n");
            sql.append(" inner join T_HR_EmployeePage page \r\n");
            sql.append(" on page.fid = sch.FEmpPageID \r\n");
            sql.append(" where sch.FParentID = ");
            sql.append(" '" + schID + "'");
            StringBuffer order = new StringBuffer();
            order.append(" order by page.FType desc,sch.FSeq asc ");
            return DbUtil.executeQuery((Context)ctx, (String)(sql.toString() + order.toString()));
        }
        IRowSet rs = this.getDefaultScheme(ctx);
        StringBuffer pageIDs = new StringBuffer();
        try {
            pageIDs.append("(");
            while (rs.next()) {
                String pageID = rs.getString("FID");
                pageIDs.append("'" + pageID + "',");
            }
            pageIDs.delete(pageIDs.length() - 1, pageIDs.length());
            pageIDs.append(")");
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        if (pageIDs.length() == 2) {
            return null;
        }
        StringBuffer sql = new StringBuffer(512);
        sql.append(" select \r\n");
        sql.append(" page.fid as FPageID, \r\n");
        sql.append(" page.FName_" + ctx.getLocale() + " as FPageName, \r\n");
        sql.append(" page.FType as FIsSinglePage, \r\n");
        sql.append(" sch.FID as FSCHID, \r\n");
        sql.append(" sch.FParentID as FEMPSCHID, \r\n");
        sql.append(" 1 as FIsMaintainScheme,\r\n");
        sql.append(" page.FUIName as FUIName,\r\n");
        sql.append(" parent.FDPageContent as FDPageContent, \r\n");
        sql.append(" sch.FPageContent as FPageContent \r\n");
        sql.append(" from T_HR_EmpBESE sch \r\n");
        sql.append(" inner join T_HR_EmpBES parent \r\n");
        sql.append(" on parent.fid = sch.Fparentid \r\n");
        sql.append(" inner join T_HR_EmployeePage page \r\n");
        sql.append(" on page.fid = sch.FEmpPageID \r\n");
        sql.append(" where sch.FParentID in (");
        sql.append(" select FParentID from T_HR_EmpBESE ");
        sql.append(" where FEmpPageID in " + pageIDs + ")");
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer filter = new StringBuffer();
        filter.append(" and sch.FParentID in ");
        filter.append(" (select  FEgisSchemeID  from T_HR_EmpEgisScheme ");
        filter.append(" where FUserID = '");
        filter.append(userID);
        filter.append("' and FIsDefault = 1 )");
        StringBuffer order = new StringBuffer();
        order.append(" order by page.FType desc,sch.FSeq asc ");
        IRowSet rows = null;
        rows = DbUtil.executeQuery((Context)ctx, (String)(sql.toString() + filter.toString() + order.toString()));
        if (rows.size() > 0) {
            return rows;
        }
        sql.delete(0, sql.length());
        sql.append(" select \r\n");
        sql.append(" page.fid as FPageID, \r\n");
        sql.append(" page.FName_" + ctx.getLocale() + " as FPageName, \r\n");
        sql.append(" page.FType as FIsSinglePage, \r\n");
        sql.append(" sch.FID as FSCHID, \r\n");
        sql.append(" 0 as FIsMaintainScheme,\r\n");
        sql.append(" page.FUIName as FUIName,\r\n");
        sql.append(" sch.FPageContent as FPageContent \r\n");
        sql.append(" from T_HR_EmpBatTreConEntry sch \r\n");
        sql.append(" inner join T_HR_EmployeePage page \r\n");
        sql.append(" on page.fid = sch.FEmpPageID \r\n");
        sql.append(" where sch.FParentID in (");
        sql.append(" select FParentID from T_HR_EmpBatTreConEntry ");
        sql.append(" where FEmpPageID in " + pageIDs + ")");
        rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rows.size() > 0) {
            return rows;
        }
        return null;
    }

    protected IRowSet getDefaultScheme(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("SELECT T2.FID FID, T2.FName_");
        sql.append(ctx.getLocale());
        sql.append(" FElementName ,FUIName,FPageContent,FIsBasePage,FUISchemeID ");
        sql.append(" FROM  T_HR_EmployeePage T2 ");
        sql.append(" LEFT OUTER JOIN T_HR_EmployeeEditPageScheme T1 ON T1.FID = T2.FSchemeID ");
        IRowSet rows = null;
        StringBuffer sql2 = null;
        sql2 = new StringBuffer(sql.toString());
        sql2.append("WHERE T1.FID IN(SELECT TOP 1 FSchemeID FROM T_HR_EmployeePersonalScheme WHERE FUserID = '");
        sql2.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        sql2.append("' AND FIsDefault=1 ) ");
        rows = DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
        if (rows.size() > 0) {
            return rows;
        }
        sql2 = new StringBuffer(sql.toString());
        sql2.append("WHERE T1.FID IN (SELECT TOP 1 FSchemeID FROM T_HR_EmployeeRoleScheme WHERE FRoleId in (");
        sql2.append("select FroleId from T_PM_UserRoleOrg where fuserid='");
        sql2.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        sql2.append("' and FOrgId='");
        sql2.append(ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
        sql2.append("')");
        sql2.append(" AND FIsDefault=1 ");
        sql2.append(")");
        rows = DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
        if (rows.size() > 0) {
            return rows;
        }
        HROrgUnitInfo hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        if (hrInfo != null) {
            sql2 = new StringBuffer(sql.toString());
            sql2.append("WHERE T1.FHROrgUnitID = '");
            sql2.append(hrInfo.getId().toString());
            sql2.append("' AND FSchemeType = ");
            sql2.append(4);
            rows = DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
            if (rows.size() > 0) {
                return rows;
            }
        }
        sql2 = new StringBuffer(sql.toString());
        sql2.append(" WHERE FSchemeType = ");
        sql2.append(2);
        rows = DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
        if (rows.size() > 0) {
            return rows;
        }
        sql2 = new StringBuffer(sql.toString());
        sql2.append(" WHERE FSchemeType = ");
        sql2.append(1);
        return DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
    }

    @Override
    protected Map _batchSave(Context ctx, Map param) throws BOSException, EASBizException {
        String saveMode = (String)param.get("SAVE_MODE");
        if ("SAVE_MODE_SINGLE".equals(saveMode)) {
            return this.saveSingle(ctx, param);
        }
        if ("SAVE_MODE_MULTI".equals(saveMode)) {
            return this.saveMulti(ctx, param);
        }
        return null;
    }

    private void doPersonPlanCheck(Context ctx, Map editDataMap) throws EASBizException, BOSException {
        int i;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IPerson iperson = PersonFactory.getLocalInstance((Context)ctx);
        String personEntityName = loader.getEntity(new PersonInfo().getBOSType()).getFullName();
        String personPositionEntityName = loader.getEntity(new PersonPositionInfo().getBOSType()).getFullName();
        CoreBaseCollection personColl = (CoreBaseCollection)editDataMap.get(personEntityName);
        CoreBaseCollection personPositionColl = (CoreBaseCollection)editDataMap.get(personPositionEntityName);
        ArrayList<PosPerPlanInfo> addList = new ArrayList<PosPerPlanInfo>();
        ArrayList<PosPerPlanInfo> delList = new ArrayList<PosPerPlanInfo>();
        HashMap<String, EmployeeTypeInfo> personTypeMap = new HashMap<String, EmployeeTypeInfo>();
        EmployeeTypeInfo oldEmpType = null;
        EmployeeTypeInfo newEmpType = null;
        PersonInfo personInfo = null;
        PersonPositionInfo personPositionInfo = null;
        for (i = 0; i < personColl.size(); ++i) {
            personInfo = (PersonInfo)personColl.get(i);
            if (personInfo.getId() == null) continue;
            personTypeMap.put(personInfo.getId().toString(), personInfo.getEmployeeType());
        }
        for (i = 0; i < personPositionColl.size(); ++i) {
            personPositionInfo = (PersonPositionInfo)personPositionColl.get(i);
            personInfo = personPositionInfo.getPerson();
            EmployeeTypeInfo employeeTypeInfo = newEmpType = personInfo.getEmployeeType() != null ? personInfo.getEmployeeType() : (EmployeeTypeInfo)personTypeMap.get(personInfo.getId().toString());
            if (personPositionInfo.getId() != null) {
                oldEmpType = iperson.getPersonInfo((IObjectPK)new ObjectUuidPK(personInfo.getId().toString())).getEmployeeType();
                delList.add(new PosPerPlanInfo(personInfo.getId().toString(), personPositionInfo.getPrimaryPosition(), false, oldEmpType));
                addList.add(new PosPerPlanInfo(personInfo.getId().toString(), personPositionInfo.getPrimaryPosition(), false, newEmpType));
                continue;
            }
            addList.add(new PosPerPlanInfo(null, personPositionInfo.getPrimaryPosition(), false, newEmpType));
        }
        PersonPlanFactory.getLocalInstance((Context)ctx).canAddPersonBatch(addList, delList);
    }

    private Map saveSingle(Context ctx, Map param) throws BOSException, EASBizException {
        List lst;
        if (param.containsKey("NEW_PERSON_LIST") && (lst = (List)param.get("NEW_PERSON_LIST")) != null) {
            for (int i = 0; i < lst.size(); ++i) {
                PersonInfo pInfo = (PersonInfo)lst.get(i);
                String strCardNo = pInfo.getIdCardNO();
                String strPassportNo = pInfo.getPassportNO();
                if (StringUtils.isEmpty((String)strCardNo) && StringUtils.isEmpty((String)strPassportNo)) {
                    throw new EmployeeException(EmployeeException.BOTH_NO_NOT_ALL_NULL, new Object[]{pInfo.getName()});
                }
                boolean isIDcardVerify = this.isIDcardVerify(ctx);
                if (isIDcardVerify) {
                    if (strCardNo != null && strCardNo.length() != 15 && strCardNo.length() != 18) {
                        throw new BaseException(BaseException.IDCARD_NUMERROR);
                    }
                    if (strCardNo != null) {
                        IDCardCommonUtil util = new IDCardCommonUtil(strCardNo, isIDcardVerify);
                        try {
                            Date birthday = DateTimeUtils.parseDate((String)util.getBirthday(), (String)"yyyy-MM-dd");
                            pInfo.setBirthday(birthday);
                        }
                        catch (ParseException e) {
                            logger.error((Object)e.getMessage());
                        }
                        pInfo.setGender(util.getGenders());
                    }
                }
                PersonFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)pInfo);
            }
        }
        Map selectorMap = (Map)param.get("SELECTOR_MAP");
        Map editDataMap = (Map)param.get("EDITDATA_MAP");
        this.doPersonPlanCheck(ctx, editDataMap);
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        Iterator it = selectorMap.entrySet().iterator();
        while (it.hasNext()) {
            PersonInfo pInfo;
            CoreBaseInfo info;
            int i;
            Map.Entry entry = null;
            entry = it.next();
            String entityName = (String)entry.getKey();
            EntityObjectInfo entity = loader.getEntity((IMetaDataPK)new MetaDataPK(entityName));
            MetaDataPK entityPK = new MetaDataPK(entity.getFullName());
            ICoreBase bizCtrl = entity.isDynamic() ? (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)entityPK) : EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(entity.getType());
            SelectorItemCollection selector = (SelectorItemCollection)entry.getValue();
            SelectorItemCollection sic = new SelectorItemCollection();
            HashSet<String> keySet = new HashSet<String>();
            for (int i2 = 0; i2 < selector.size(); ++i2) {
                SelectorItemInfo sInfo = selector.get(i2);
                String property = sInfo.getPropertyName();
                if (property.indexOf(".") > 0) {
                    String key = property.substring(0, property.indexOf("."));
                    if (keySet.contains(key)) continue;
                    sic.add(key);
                    keySet.add(key);
                    continue;
                }
                sic.add(property);
                keySet.add(property);
            }
            String Language2 = "_" + ContextUtils.getLocaleFromEnv().getLanguage();
            CoreBaseCollection coll = (CoreBaseCollection)editDataMap.get(entityName);
            EmpBatchDataHelper helper = new EmpBatchDataHelper(ctx);
            for (i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                if (info.getId() == null) continue;
                if ("com.kingdee.eas.basedata.person.app.Person".equals(entityName)) {
                    pInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(info.getId()));
                    String strCardNo = pInfo.getIdCardNO();
                    String strPassportNo = pInfo.getPassportNO();
                    if (keySet.contains("idCardNO")) {
                        strCardNo = info.getString("idCardNO");
                    }
                    if (keySet.contains("passportNO")) {
                        strPassportNo = info.getString("passportNO");
                    }
                    if (StringUtils.isEmpty((String)strCardNo) && StringUtils.isEmpty((String)strPassportNo)) {
                        throw new EmployeeException(EmployeeException.BOTH_NO_NOT_ALL_NULL, new Object[]{pInfo.getName()});
                    }
                    boolean isIDcardVerify = this.isIDcardVerify(ctx);
                    if (isIDcardVerify) {
                        if (strCardNo != null && strCardNo.length() != 15 && strCardNo.length() != 18) {
                            throw new BaseException(BaseException.IDCARD_NUMERROR);
                        }
                        if (strCardNo != null) {
                            IDCardCommonUtil util = new IDCardCommonUtil(strCardNo, isIDcardVerify);
                            try {
                                Date birthday = DateTimeUtils.parseDate((String)util.getBirthday(), (String)"yyyy-MM-dd");
                                pInfo.setBirthday(birthday);
                                sic.add("birthday");
                            }
                            catch (ParseException e) {
                                logger.error((Object)e.getMessage());
                            }
                            pInfo.setGender(util.getGenders());
                            sic.add("gender");
                        }
                    }
                }
                ObjectUuidPK pk = new ObjectUuidPK(info.getId());
                CoreBaseInfo oldInfo = bizCtrl.getValue((IObjectPK)pk);
                for (int j = 0; j < sic.size(); ++j) {
                    SelectorItemInfo si = sic.get(j);
                    if (oldInfo.containsKey(si.getPropertyName() + Language2)) {
                        oldInfo.put(si.getPropertyName() + Language2, info.get(si.getPropertyName()));
                        continue;
                    }
                    oldInfo.put(si.getPropertyName(), info.get(si.getPropertyName()));
                }
                this.saveForDiff(oldInfo);
                if (oldInfo instanceof ICommonBOSType) {
                    oldInfo.put("name_l2", info.get("name"));
                }
                bizCtrl.update((IObjectPK)pk, oldInfo);
            }
            for (i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                if (info.getId() != null) continue;
                this.doBeforeAddNewMulti(entityName, helper, info);
                if ("com.kingdee.eas.hr.emp.app.PersonPosition".equals(entityName)) {
                    pInfo = (PersonInfo)info.get("person");
                    PersonPositionInfo ppInfo = (PersonPositionInfo)info;
                    ppInfo.setPersonDep(ppInfo.getPrimaryPosition().getAdminOrgUnit());
                    PositionMemberInfo pmInfo = new PositionMemberInfo();
                    pmInfo.setPosition(ppInfo.getPrimaryPosition());
                    pmInfo.setPerson(pInfo);
                    pmInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                    pmInfo.setIsPrimary(true);
                    PositionMemberFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)pmInfo);
                } else if ("com.kingdee.eas.basedata.person.app.Person".equals(entityName)) continue;
                if (info instanceof ICommonBOSType) {
                    ((ICommonBOSType)info).setBOSType(entity.getType());
                    ((ICommonBOSType)info).setPK((IMetaDataPK)entityPK);
                }
                bizCtrl.addnew(info);
            }
        }
        return null;
    }

    private void saveForDiff(CoreBaseInfo info) {
        if (info.get("employTechPost") != null) {
            info.put("IS_UPDATE_EMPLOYTECHPOST", (Object)true);
        }
        if (info.get("highestTechPost") != null) {
            info.put("IS_UPDATE_HIGHESTTECHPOST", (Object)true);
        }
        if (info.get("highestDegree") != null) {
            info.put("IS_UPDATE_HIGHESTDEGREE", (Object)true);
        }
    }

    private Map saveMulti(Context ctx, Map param) throws BOSException, EASBizException {
        CoreBaseInfo info;
        int i;
        List lst;
        HashMap entityPersonMap = new HashMap();
        String entityName = (String)param.get("ENTITY_NAME");
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity((IMetaDataPK)new MetaDataPK(entityName));
        MetaDataPK entityPK = new MetaDataPK(entity.getFullName());
        ICoreBase bizCtrl = entity.isDynamic() ? (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)entityPK) : EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(entity.getType());
        EmpBatchDataHelper helper = new EmpBatchDataHelper(ctx);
        if (param.containsKey("ADDNEW_ENTRY_LIST")) {
            lst = (List)param.get("ADDNEW_ENTRY_LIST");
            for (i = 0; i < lst.size(); ++i) {
                info = (CoreBaseInfo)lst.get(i);
                this.doBeforeAddNewMulti(entityName, helper, info);
                if (info instanceof ICommonBOSType) {
                    ((ICommonBOSType)info).setBOSType(entity.getType());
                    ((ICommonBOSType)info).setPK((IMetaDataPK)entityPK);
                }
                bizCtrl.addnew(info);
                this.updateEntityPersonMap(entityPersonMap, entityName, info);
            }
        }
        if (param.containsKey("UPDATE_ENTRY_LIST")) {
            lst = (List)param.get("UPDATE_ENTRY_LIST");
            Map map = (Map)param.get("SELECTOR_MAP");
            SelectorItemCollection selector = (SelectorItemCollection)map.get(entityName);
            SelectorItemCollection sic = new SelectorItemCollection();
            HashSet<String> keySet = new HashSet<String>();
            for (int i2 = 0; i2 < selector.size(); ++i2) {
                SelectorItemInfo sInfo = selector.get(i2);
                String property = sInfo.getPropertyName();
                if (property.indexOf(".") > 0) {
                    String key = property.substring(0, property.indexOf("."));
                    if (keySet.contains(key)) continue;
                    sic.add(key);
                    keySet.add(key);
                    continue;
                }
                sic.add(property);
                keySet.add(property);
            }
            if ("com.kingdee.eas.hr.emp.app.PersonDegree".equals(entityName)) {
                Collections.sort((List)lst, (Comparator)new Comparator(){

                    public int compare(Object o1, Object o2) {
                        PersonDegreeInfo info1 = (PersonDegreeInfo)o1;
                        PersonDegreeInfo info2 = (PersonDegreeInfo)o2;
                        if (info1.isIsHighest()) {
                            return -1;
                        }
                        if (info2.isIsHighest()) {
                            return 1;
                        }
                        return 0;
                    }
                });
            }
            if ("com.kingdee.eas.basedata.org.app.PositionMember".equals(entityName)) {
                Collections.sort((List)lst, (Comparator)new Comparator(){

                    public int compare(Object o1, Object o2) {
                        PositionMemberInfo info1 = (PositionMemberInfo)o1;
                        PositionMemberInfo info2 = (PositionMemberInfo)o2;
                        if (info1.isIsPrimary()) {
                            return -1;
                        }
                        if (info2.isIsPrimary()) {
                            return 1;
                        }
                        return 0;
                    }
                });
            }
            String Language2 = "_" + ContextUtils.getLocaleFromEnv().getLanguage();
            for (int i3 = 0; i3 < lst.size(); ++i3) {
                PersonDegreeInfo pInfo;
                CoreBaseInfo info2 = (CoreBaseInfo)lst.get(i3);
                String result = helper.verifyRequired(entityName, info2, keySet);
                if (!StringUtils.isEmpty((String)result)) {
                    throw new EASBizException(new NumericExceptionSubItem("001", result), new Object[0]);
                }
                ObjectUuidPK pk = new ObjectUuidPK(info2.getId());
                CoreBaseInfo oldInfo = bizCtrl.getValue((IObjectPK)pk);
                for (int j = 0; j < sic.size(); ++j) {
                    SelectorItemInfo si = sic.get(j);
                    if ("com.kingdee.eas.hr.train.app.PersonCheckUp".equals(entityName) && (si.getPropertyName().equalsIgnoreCase("remark") || si.getPropertyName().equalsIgnoreCase("certificate") || si.getPropertyName().equalsIgnoreCase("checkUpUnit"))) {
                        oldInfo.put(si.getPropertyName() + Language2, info2.get(si.getPropertyName()));
                        continue;
                    }
                    if (oldInfo.containsKey(si.getPropertyName() + Language2)) {
                        oldInfo.put(si.getPropertyName() + Language2, info2.get(si.getPropertyName()));
                        continue;
                    }
                    oldInfo.put(si.getPropertyName(), info2.get(si.getPropertyName()));
                }
                if ("com.kingdee.eas.hr.emp.app.PersonDegree".equals(entityName) && (pInfo = (PersonDegreeInfo)info2).isIsHighestDegree() && pInfo.getDegree() == null) {
                    throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"227_EmpBatFacadeControllerBean", (Locale)ctx.getOriginLocale())), new Object[0]);
                }
                bizCtrl.update((IObjectPK)pk, oldInfo);
                this.updateEntityPersonMap(entityPersonMap, entityName, info2);
            }
        }
        if (param.containsKey("DELETE_ENTRY_LIST")) {
            lst = (List)param.get("DELETE_ENTRY_LIST");
            for (i = 0; i < lst.size(); ++i) {
                info = (CoreBaseInfo)lst.get(i);
                ObjectUuidPK pk = new ObjectUuidPK(info.getId());
                bizCtrl.delete((IObjectPK)pk);
                this.updateEntityPersonMap(entityPersonMap, entityName, info);
            }
        }
        this.doAfterSave(ctx, entityPersonMap);
        return null;
    }

    private void doBeforeAddNewMulti(String entityName, EmpBatchDataHelper helper, CoreBaseInfo info) throws EASBizException {
        CadreAuditInfo cadreAuditInfo;
        if ("com.kingdee.eas.hr.kt.app.CadreAudit".equals(entityName)) {
            cadreAuditInfo = (CadreAuditInfo)info;
        } else if ("com.kingdee.eas.hr.kt.app.CadreIntendance".equals(entityName)) {
            cadreAuditInfo = (CadreIntendanceInfo)info;
        } else if ("com.kingdee.eas.hr.kt.app.CadreTell".equals(entityName)) {
            cadreAuditInfo = (CadreTellInfo)info;
        } else if ("com.kingdee.eas.hr.emp.app.FamilyEvite".equals(entityName)) {
            FamilyEviteInfo fInfo = (FamilyEviteInfo)info;
            if (fInfo.getPerson() != null) {
                fInfo.setPersonNumber(fInfo.getPerson().getNumber());
            }
            if (fInfo.getPerson2() != null) {
                fInfo.setPersonNumber2(fInfo.getPerson2().getNumber());
            }
        } else if ("com.kingdee.eas.hr.emp.app.PersonPosition".equals(entityName)) {
            PersonPositionInfo pInfo = (PersonPositionInfo)info;
            if (pInfo.get("workTime") == null) {
                pInfo.setWorkTime(0L);
            }
            if (pInfo.get("extWorkTime") == null) {
                pInfo.setExtWorkTime(new BigDecimal(0));
            }
            if (pInfo.get("lenOfActualService") == null) {
                pInfo.setLenOfActualService(new BigDecimal(0));
            }
        }
        String result = helper.verifyRequired(entityName, info);
        if (!StringUtils.isEmpty((String)result)) {
            throw new EASBizException(new NumericExceptionSubItem("001", result), new Object[0]);
        }
    }

    private void doAfterSave(Context ctx, Map entityPersonMap) throws BOSException, EASBizException {
        if (entityPersonMap.containsKey("com.kingdee.eas.hr.emp.app.PersonDegree")) {
            Set idSet = (Set)entityPersonMap.get("com.kingdee.eas.hr.emp.app.PersonDegree");
            Iterator it = idSet.iterator();
            boolean hasLessError = false;
            boolean hasMoreError = false;
            boolean hasEitherError = false;
            StringBuffer lessMsg = new StringBuffer();
            StringBuffer moreMsg = new StringBuffer();
            StringBuffer eitherMsg = new StringBuffer();
            String sql = "select count(fid) from T_HR_PersonDegree where FIsHighest = 1 and FPersonID = ?";
            String sqlE = "select Fdegree,Fdiploma  from T_HR_PersonDegree where FPersonID = ?";
            HashSet<String> pNameSet = new HashSet<String>();
            while (it.hasNext()) {
                String id = (String)it.next();
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id});
                int count = 0;
                try {
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage());
                }
                if (count == 0) {
                    boolean isExist = PersonDegreeFactory.getLocalInstance(ctx).exists(" where person.id = '" + id + "'");
                    if (isExist) {
                        hasLessError = true;
                        PersonInfo pInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(id));
                        lessMsg.append(pInfo.getName() + " ");
                    }
                } else if (count > 1) {
                    hasMoreError = true;
                    PersonInfo pInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(id));
                    moreMsg.append(pInfo.getName() + " ");
                }
                rs = DbUtil.executeQuery((Context)ctx, (String)sqlE, (Object[])new Object[]{id});
                try {
                    while (rs.next()) {
                        String degree = rs.getString("Fdegree");
                        String diploma = rs.getString("Fdiploma");
                        if (!StringUtils.isEmpty((String)degree) || !StringUtils.isEmpty((String)diploma)) continue;
                        hasEitherError = true;
                        PersonInfo pInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(id));
                        pNameSet.add(pInfo.getName());
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            if (hasLessError) {
                throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"228_EmpBatFacadeControllerBean", (Locale)ctx.getOriginLocale()) + lessMsg + ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"229_EmpBatFacadeControllerBean", (Locale)ctx.getOriginLocale())), new Object[0]);
            }
            if (hasMoreError) {
                throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"228_EmpBatFacadeControllerBean", (Locale)ctx.getOriginLocale()) + moreMsg + ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"230_EmpBatFacadeControllerBean", (Locale)ctx.getOriginLocale())), new Object[0]);
            }
            if (hasEitherError) {
                Iterator iterator = pNameSet.iterator();
                while (iterator.hasNext()) {
                    eitherMsg.append(iterator.next() + " ");
                }
                throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"228_EmpBatFacadeControllerBean", (Locale)ctx.getOriginLocale()) + eitherMsg + ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"231_EmpBatFacadeControllerBean", (Locale)ctx.getOriginLocale())), new Object[0]);
            }
        }
    }

    private void updateEntityPersonMap(Map entityPersonMap, String entityName, CoreBaseInfo info) {
        String id = this.getPersonID(entityName, info);
        if (entityPersonMap.containsKey(entityName)) {
            Set idSet = (Set)entityPersonMap.get(entityName);
            idSet.add(id);
            entityPersonMap.put(entityName, idSet);
        } else {
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(id);
            entityPersonMap.put(entityName, idSet);
        }
    }

    private String getPersonID(String entity, CoreBaseInfo info) {
        String id = "";
        id = entity.indexOf("com.kingdee.eas.basedata.person.app.Person") >= 0 ? info.getId().toString() : (entity.indexOf("com.kingdee.eas.hr.emp.app.EmployeeContract") >= 0 || entity.indexOf("com.kingdee.eas.hr.emp.app.EmpDemocracyClan") >= 0 ? ((PersonInfo)info.get("employee")).getId().toString() : ((PersonInfo)info.get("person")).getId().toString());
        return id;
    }

    private boolean isIDcardVerify(Context ctx) throws EASBizException, BOSException {
        String paramNum = "IS_IDCARD_VERIFY";
        String hrOrgId = null;
        HROrgUnitInfo hrOrg = ContextUtil.getCurrentHRUnit((Context)ctx);
        if (hrOrg != null) {
            hrOrgId = hrOrg.getId().toString();
        }
        boolean isIDCardVerify = HRParamUtil.getParamOfHR((Context)ctx, (String)paramNum, (String)hrOrgId);
        return isIDCardVerify;
    }

    @Override
    protected String _checkRef(Context ctx, Set set, String schemeid) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select e.femppagename as name from  T_HR_EmpBatTreConEntry e ");
        sql.append(" inner join T_HR_EmpBatTreCon c ");
        sql.append(" on e.fparentid = c.fid ");
        sql.append(" where c.fempschemeid = '").append(schemeid).append("'");
        sql.append(" and e.femppageid in ").append(this.getStrFromSet(set));
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer buffer = new StringBuffer();
        try {
            while (row.next()) {
                buffer.append(row.getString("name")).append("\u3001");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (buffer.length() > 0) {
            return buffer.deleteCharAt(buffer.length() - 1).toString();
        }
        return buffer.toString();
    }

    private String getStrFromSet(Set set) {
        StringBuffer sb = new StringBuffer();
        Object[] list = set.toArray();
        sb.append("(");
        int size = list.length;
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append("'");
                sb.append((String)list[i]);
                sb.append("')");
                continue;
            }
            if (i != size - 1) {
                sb.append("'");
                sb.append((String)list[i]);
                sb.append("', ");
                continue;
            }
            sb.append("'");
            sb.append((String)list[i]);
            sb.append("')");
        }
        return sb.toString();
    }

    @Override
    protected boolean _checkGroup(Context ctx, String groupID, String schemeID) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("select e.femppageid from T_HR_EmpBatTreConEntry e ");
        sb.append("inner join T_HR_EmpBatTreCon c on e.fparentid = c.fid ");
        sb.append("inner join t_hr_employeepage m on e.femppageid = m.fid ");
        sb.append("where c.fempschemeid = ? ");
        sb.append("and m.fgroupid = ? ");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{schemeID, groupID});
        try {
            if (row.next()) {
                return false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }
}

