/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.basedata.org.HierarchyFactory;
import com.kingdee.eas.basedata.org.HierarchyInfo;
import com.kingdee.eas.basedata.org.PositionHierarchyCollection;
import com.kingdee.eas.basedata.org.PositionHierarchyFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.app.AbstractEmpCollectFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class EmpCollectFacadeControllerBean
extends AbstractEmpCollectFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.EmpCollectFacadeControllerBean");

    private String getCULongNumber(Context ctx) {
        return ContextUtil.getCurrentCtrlUnit((Context)ctx).getLongNumber();
    }

    private int getPHLevel(Context ctx, String positionId) throws BOSException, EASBizException {
        String sql = "SELECT FLevel FROM T_Org_PositionHierarchy where FChildID = ? and FHierarchyID = ?";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{positionId, this.getDefaultHierarchyId(ctx)});
        int level = -1;
        try {
            if (rows.next()) {
                level = rows.getInt("FLevel");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rows);
        }
        return level;
    }

    private int getLevel(Context ctx, String longNumber) throws BOSException, EASBizException {
        if (longNumber == null) {
            longNumber = this.getCULongNumber(ctx);
        }
        String sql = "SELECT FLevel from T_Org_Admin where FLongNumber = ? ";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{longNumber});
        int level = -1;
        try {
            if (rows.next()) {
                level = rows.getInt("FLevel");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rows);
        }
        return level;
    }

    @Override
    protected int[] _getLevels(Context ctx, String longNumber) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT MIN(FLevel) AS MIN , MAX(FLevel) AS MAX ");
        sb.append("FROM T_ORG_Admin ");
        if (longNumber != null) {
            sb.append(" AND (FLongNumber || '%' LIKE ?) \n");
        }
        IRowSet rows = null;
        rows = longNumber == null ? DbUtil.executeQuery((Context)ctx, (String)sb.toString()) : DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{longNumber + "!%"});
        int[] levels = new int[]{-1, -1};
        try {
            if (rows.next()) {
                levels[0] = rows.getInt("MIN");
                levels[1] = rows.getInt("MAX");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rows);
        }
        return levels;
    }

    private String getLangSuffix(Context ctx) {
        return "_" + ctx.getLocale().toString();
    }

    private String getPositionYearSql(Context ctx, boolean isIncludeLastYear) {
        StringBuffer sb = new StringBuffer();
        sb.append("\t\tSELECT A.FLongNumber, 0 AS FIndex, a.FLevel, A.FIsLeaf, A.FAdminOrgID, A.FName,  \n");
        sb.append("\t      CASE WHEN B.FYear IS NULL THEN 0 ELSE B.FYear END AS FYear,  \n");
        sb.append("\t      -100 as FInterval, \n");
        sb.append("\t      CASE WHEN B.FCount IS NULL THEN 0 ELSE B.FCount END AS FCount, \n");
        sb.append("\t      CASE WHEN B.FPartimeCount IS NULL  \n");
        sb.append("\t      THEN 0 ELSE B.FPartimeCount END AS FPartimeCount, \n");
        sb.append("\t      CASE WHEN B.FOffStreCount IS NULL  \n");
        sb.append("\t      THEN 0 ELSE B.FOffStreCount END AS FOffStreCount, \n");
        sb.append("\t      CASE WHEN B.FOnStreCount IS NULL  \n");
        sb.append("\t      THEN 0 ELSE B.FOnStreCount END AS FOnStreCount, \n");
        sb.append("\t      CASE WHEN B.FOnStreCount2 IS NULL  \n");
        sb.append("\t      THEN 0 ELSE B.FOnStreCount2 END AS FOnStreCount2 \n");
        sb.append("\tFROM (SELECT A.FLongNumber, A.FIsLeaf, A.FLevel, A.FChildID AS FAdminOrgID, \n");
        sb.append("\t              B.FName");
        sb.append(this.getLangSuffix(ctx));
        sb.append(" AS FName \n");
        sb.append("\t        FROM T_Org_PositionHierarchy A INNER JOIN \n");
        sb.append("\t              T_Org_Position B ON A.FChildID = B.FID \n");
        sb.append("\t        WHERE A.FHierarchyID = ? AND \n");
        sb.append("\t              A.FLongNumber || '!' LIKE ?) A LEFT OUTER JOIN \n");
        sb.append("\t          (SELECT A.FYear , B.* \n");
        sb.append("\t         FROM (SELECT FID, FYear \n");
        sb.append("\t                 FROM T_HR_PersonFixedTime \n");
        sb.append("\t                 WHERE (FFixedTime IN \n");
        sb.append("\t                           (SELECT MAX(FFixedTime) AS FFixedTime \n");
        sb.append("\t                          FROM T_HR_PersonFixedTime \n");
        sb.append("                          WHERE FIsSuccess = 1 AND ((FFixedTime >= ? AND FFixedTime <= ?) \n");
        if (isIncludeLastYear) {
            sb.append("\t\t\t OR (FFixedTime >= ? AND FFixedTime <= ?)\t \n");
        }
        sb.append("\t                         ) group by FYear ))) A INNER JOIN \n");
        sb.append("\t               T_HR_PersonFixedHistory B ON A.FID = B.FFixedTimeID) B ON  \n");
        sb.append("\t      A.FAdminOrgID = B.FPositionID \n");
        sb.append(" WHERE A.FLevel <= ? \n");
        sb.append("\tORDER BY A.FLongNumber, B.FYear \n");
        logger.debug((Object)"\ngetPositionYearSql : begin \n");
        logger.debug((Object)sb.toString());
        logger.debug((Object)"\ngetPositionYearSql : end \n");
        return sb.toString();
    }

    private String getPositionHalfYearSql(Context ctx, boolean isIncludeLastYear) {
        StringBuffer sb = new StringBuffer();
        sb.append("\t\tSELECT A.FLongNumber, 0 AS FIndex, a.FLevel, A.FIsLeaf, A.FAdminOrgID, A.FName,  \n");
        sb.append("\t      CASE WHEN B.FYear IS NULL THEN 0 ELSE B.FYear END AS FYear,  \n");
        sb.append("\t\t  CASE WHEN B.FHalfYear IS NULL THEN 0 ELSE B.FHalfYear END AS FInterval,   \n");
        sb.append("\t      CASE WHEN B.FCount IS NULL THEN 0 ELSE B.FCount END AS FCount, \n");
        sb.append("\t      CASE WHEN B.FPartimeCount IS NULL  \n");
        sb.append("\t      THEN 0 ELSE B.FPartimeCount END AS FPartimeCount, \n");
        sb.append("\t      CASE WHEN B.FOffStreCount IS NULL  \n");
        sb.append("\t      THEN 0 ELSE B.FOffStreCount END AS FOffStreCount, \n");
        sb.append("\t      CASE WHEN B.FOnStreCount IS NULL  \n");
        sb.append("\t      THEN 0 ELSE B.FOnStreCount END AS FOnStreCount, \n");
        sb.append("\t      CASE WHEN B.FOnStreCount2 IS NULL  \n");
        sb.append("\t      THEN 0 ELSE B.FOnStreCount2 END AS FOnStreCount2 \n");
        sb.append("\tFROM (SELECT A.FLongNumber, A.FIsLeaf, A.FLevel, A.FChildID AS FAdminOrgID, \n");
        sb.append("\t              B.FName");
        sb.append(this.getLangSuffix(ctx));
        sb.append(" AS FName \n");
        sb.append("\t        FROM T_Org_PositionHierarchy A INNER JOIN \n");
        sb.append("\t              T_Org_Position B ON A.FChildID = B.FID \n");
        sb.append("\t        WHERE A.FHierarchyID = ? AND \n");
        sb.append("\t              A.FLongNumber || '!' LIKE ?) A LEFT OUTER JOIN \n");
        sb.append("\t          (SELECT A.FYear AS FYear, A.FHalfYear AS FHalfYear, B.* \n");
        sb.append("\t         FROM (SELECT FID, FYear, FHalfYear \n");
        sb.append("\t                 FROM T_HR_PersonFixedTime \n");
        sb.append("\t                 WHERE (FFixedTime IN \n");
        sb.append("\t                           (SELECT MAX(FFixedTime) AS FFixedTime \n");
        sb.append("\t                          FROM T_HR_PersonFixedTime \n");
        sb.append("                          WHERE FIsSuccess = 1 AND ((FFixedTime >= ? AND FFixedTime <= ?) \n");
        if (isIncludeLastYear) {
            sb.append("\t\t\t OR (FFixedTime >= ? AND FFixedTime <= ?)\t \n");
        }
        sb.append("\t                         ) group by FYear, FHalfYear ))) A INNER JOIN \n");
        sb.append("\t               T_HR_PersonFixedHistory B ON A.FID = B.FFixedTimeID) B ON  \n");
        sb.append("\t      A.FAdminOrgID = B.FPositionID \n");
        sb.append(" WHERE A.FLevel <= ? \n");
        sb.append("\tORDER BY A.FLongNumber, B.FYear, B.FHalfYear \n");
        logger.debug((Object)"\ngetPositionHalfYearSql : begin \n");
        logger.debug((Object)sb.toString());
        logger.debug((Object)"\ngetPositionHalfYearSql : end \n");
        return sb.toString();
    }

    private String getPositionQuarterSql(Context ctx, boolean isIncludeLastYear) {
        StringBuffer sb = new StringBuffer();
        sb.append("\t\tSELECT A.FLongNumber, 0 AS FIndex, a.FLevel, A.FIsLeaf, A.FAdminOrgID, A.FName,  \n");
        sb.append("\t      CASE WHEN B.FYear IS NULL THEN 0 ELSE B.FYear END AS FYear,  \n");
        sb.append("\t      CASE WHEN B.FQuarter IS NULL THEN 0 ELSE B.FQuarter END AS FInterval, \n");
        sb.append("\t      CASE WHEN B.FCount IS NULL THEN 0 ELSE B.FCount END AS FCount,  \n");
        sb.append("\t      CASE WHEN B.FPartimeCount IS NULL  \n");
        sb.append("\t      THEN 0 ELSE B.FPartimeCount END AS FPartimeCount, \n");
        sb.append("\t      CASE WHEN B.FOffStreCount IS NULL  \n");
        sb.append("\t      THEN 0 ELSE B.FOffStreCount END AS FOffStreCount, \n");
        sb.append("\t      CASE WHEN B.FOnStreCount IS NULL  \n");
        sb.append("\t      THEN 0 ELSE B.FOnStreCount END AS FOnStreCount, \n");
        sb.append("\t      CASE WHEN B.FOnStreCount2 IS NULL  \n");
        sb.append("\t      THEN 0 ELSE B.FOnStreCount2 END AS FOnStreCount2 \n");
        sb.append("\tFROM (SELECT A.FLongNumber, A.FIsLeaf, A.FLevel, A.FChildID AS FAdminOrgID, \n");
        sb.append("\t              B.FName");
        sb.append(this.getLangSuffix(ctx));
        sb.append(" AS FName \n");
        sb.append("\t        FROM T_Org_PositionHierarchy A INNER JOIN \n");
        sb.append("\t              T_Org_Position B ON A.FChildID = B.FID \n");
        sb.append("\t        WHERE A.FHierarchyID = ? AND \n");
        sb.append("\t              A.FLongNumber || '!' LIKE ?) A LEFT OUTER JOIN \n");
        sb.append("\t          (SELECT A.FYear AS FYear, A.FQuarter AS FQuarter, B.* \n");
        sb.append("\t         FROM (SELECT FID, FYear, FQuarter \n");
        sb.append("\t                 FROM T_HR_PersonFixedTime \n");
        sb.append("\t                 WHERE (FFixedTime IN \n");
        sb.append("\t                           (SELECT MAX(FFixedTime) AS FFixedTime \n");
        sb.append("\t                          FROM T_HR_PersonFixedTime \n");
        sb.append("                          WHERE FIsSuccess = 1 AND ((FFixedTime >= ? AND FFixedTime <= ?) \n");
        if (isIncludeLastYear) {
            sb.append("\t\t\t OR (FFixedTime >= ? AND FFixedTime <= ?)\t \n");
        }
        sb.append("\t                         ) group by FYear, FQuarter))) A INNER JOIN \n");
        sb.append("\t               T_HR_PersonFixedHistory B ON A.FID = B.FFixedTimeID) B ON  \n");
        sb.append("\t      A.FAdminOrgID = B.FPositionID \n");
        sb.append(" WHERE A.FLevel <= ? \n");
        sb.append("\tORDER BY A.FLongNumber, B.FYear, B.FQuarter \n");
        logger.debug((Object)"\ngetPositionQuarterSql : begin \n");
        logger.debug((Object)sb.toString());
        logger.debug((Object)"\ngetPositionQuarterSql : end \n");
        return sb.toString();
    }

    private String getPositionMonthSql(Context ctx, boolean isIncludeLastYear) {
        StringBuffer sb = new StringBuffer();
        sb.append("\t\tSELECT A.FLongNumber, 0 AS FIndex, a.FLevel, A.FIsLeaf, A.FAdminOrgID, A.FName,  \n");
        sb.append("\t      CASE WHEN B.FYear IS NULL THEN 0 ELSE B.FYear END AS FYear,  \n");
        sb.append("\t      CASE WHEN B.FMonth IS NULL THEN 0 ELSE B.FMonth END AS FInterval, \n");
        sb.append("\t      CASE WHEN B.FCount IS NULL THEN 0 ELSE B.FCount END AS FCount,  \n");
        sb.append("\t      CASE WHEN B.FPartimeCount IS NULL  \n");
        sb.append("\t      THEN 0 ELSE B.FPartimeCount END AS FPartimeCount, \n");
        sb.append("\t      CASE WHEN B.FOffStreCount IS NULL  \n");
        sb.append("\t      THEN 0 ELSE B.FOffStreCount END AS FOffStreCount, \n");
        sb.append("\t      CASE WHEN B.FOnStreCount IS NULL  \n");
        sb.append("\t      THEN 0 ELSE B.FOnStreCount END AS FOnStreCount, \n");
        sb.append("\t      CASE WHEN B.FOnStreCount2 IS NULL  \n");
        sb.append("\t      THEN 0 ELSE B.FOnStreCount2 END AS FOnStreCount2 \n");
        sb.append("\tFROM (SELECT A.FLongNumber, A.FIsLeaf, A.FLevel, A.FChildID AS FAdminOrgID, \n");
        sb.append("\t              B.FName");
        sb.append(this.getLangSuffix(ctx));
        sb.append(" AS FName \n");
        sb.append("\t        FROM T_Org_PositionHierarchy A INNER JOIN \n");
        sb.append("\t              T_Org_Position B ON A.FChildID = B.FID \n");
        sb.append("\t        WHERE A.FHierarchyID = ? AND \n");
        sb.append("\t              A.FLongNumber || '!' LIKE ?) A LEFT OUTER JOIN \n");
        sb.append("\t          (SELECT A.FYear AS FYear, A.FMonth AS FMonth, B.* \n");
        sb.append("\t         FROM (SELECT FID, FYear, FMonth \n");
        sb.append("\t                 FROM T_HR_PersonFixedTime \n");
        sb.append("\t                 WHERE (FFixedTime IN \n");
        sb.append("\t                           (SELECT MAX(FFixedTime) AS FFixedTime \n");
        sb.append("\t                          FROM T_HR_PersonFixedTime \n");
        sb.append("                          WHERE FIsSuccess = 1 AND ((FFixedTime >= ? AND FFixedTime <= ?) \n");
        if (isIncludeLastYear) {
            sb.append("\t\t\t OR (FFixedTime >= ? AND FFixedTime <= ?)\t \n");
        }
        sb.append("\t                         ) group by FYear, FMonth ))) A INNER JOIN \n");
        sb.append("\t               T_HR_PersonFixedHistory B ON A.FID = B.FFixedTimeID) B ON  \n");
        sb.append("\t      A.FAdminOrgID = B.FPositionID \n");
        sb.append(" WHERE A.FLevel <= ? \n");
        sb.append("\tORDER BY A.FLongNumber, B.FYear, B.FMonth \n");
        logger.debug((Object)"\ngetPositionMonthSql : begin \n");
        logger.debug((Object)sb.toString());
        logger.debug((Object)"\ngetPositionMonthSql : end \n");
        return sb.toString();
    }

    private String getYearSql(Context ctx, String adminIds, boolean isIncludeLastYear, String table) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT A.FLongNumber, A.FIndex, A.FIsLeaf, A.FLevel, A.FUnitId AS FAdminOrgID, A.FName, \n");
        sb.append("\tCASE WHEN B.FYear IS NULL THEN 0 ELSE B.FYear END AS FYear,  \n");
        sb.append("\t-100 as FInterval,  \n");
        sb.append("\tCASE WHEN B.FCount IS NULL THEN 0 ELSE B.FCount END AS FCount,  \n");
        sb.append("\tCASE WHEN B.FPartimeCount IS NULL THEN 0 ELSE B.FPartimeCount END AS FPartimeCount,  \n");
        sb.append("\tCASE WHEN B.FOffStreCount IS NULL THEN 0 ELSE B.FOffStreCount END AS FOffStreCount,  \n");
        sb.append("\tCASE WHEN B.FOnStreCount IS NULL THEN 0 ELSE B.FOnStreCount END AS FOnStreCount,  \n");
        sb.append("\tCASE WHEN B.FOnStreCount2 IS NULL THEN 0 ELSE B.FOnStreCount2 END AS FOnStreCount2 \n");
        sb.append("FROM (SELECT FLongNumber, ISNULL(FIndex, -100) AS FIndex, FIsLeaf, FLevel, FID AS FUnitId, FName");
        sb.append(this.getLangSuffix(ctx));
        sb.append(" AS FName  \n");
        sb.append("        FROM T_ORG_Admin WHERE FID IN (");
        sb.append(adminIds);
        sb.append(")");
        sb.append(" \t\t\t  ) A LEFT OUTER JOIN \n");
        sb.append("          (SELECT A.FYear AS FYear, B.* \n");
        sb.append("         FROM (SELECT FID, FYear ");
        sb.append("                 FROM T_HR_PersonFixedTime \n");
        sb.append("                 WHERE (FFixedTime IN \n");
        sb.append("                           (SELECT MAX(FFixedTime) AS FFixedTime FROM  \n");
        sb.append("                         \t(SELECT FFixedTime, YEAR(FFixedTime) AS INTERVAL, YEAR(FFixedTime) AS T_YEAR  \n");
        sb.append("                         \t \t\tFROM T_HR_PersonFixedTime \n");
        sb.append("                         \t \n");
        sb.append("                          WHERE FIsSuccess = 1 AND ((FFixedTime >= ? AND FFixedTime <= ?) \n");
        if (isIncludeLastYear) {
            sb.append("\t\t\t OR (FFixedTime >= ? AND FFixedTime <= ?)\t \n");
        }
        sb.append("\t\t\t\t) ) TIME_INTV  \n");
        sb.append("\t\t\t\tGROUP BY T_YEAR, INTERVAL  \n");
        sb.append("                         ))) A INNER JOIN \n");
        sb.append(table);
        sb.append(" B ON A.FID = B.FFixedTimeID) B ON  \n");
        sb.append("      A.FUnitId = B.FAdminOrgID \n");
        sb.append(" ORDER BY A.FLongNumber, A.FIndex, B.FYear \n");
        logger.debug((Object)"\ngetYearSql : begin \n");
        logger.debug((Object)sb.toString());
        logger.debug((Object)"\ngetYearSql : end \n");
        return sb.toString();
    }

    private String getYearSql(Context ctx, boolean isIncludeLastYear, String longNumber, boolean isIncludeSubCUs) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT A.FLongNumber, A.FIndex, A.FIsLeaf, A.FLevel, A.FUnitId AS FAdminOrgID, A.FName, \n");
        sb.append("\tCASE WHEN B.FYear IS NULL THEN 0 ELSE B.FYear END AS FYear,  \n");
        sb.append("\t-100 as FInterval,  \n");
        sb.append("\tCASE WHEN B.FCount IS NULL THEN 0 ELSE B.FCount END AS FCount,  \n");
        sb.append("\tCASE WHEN B.FPartimeCount IS NULL THEN 0 ELSE B.FPartimeCount END AS FPartimeCount,  \n");
        sb.append("\tCASE WHEN B.FOffStreCount IS NULL THEN 0 ELSE B.FOffStreCount END AS FOffStreCount,  \n");
        sb.append("\tCASE WHEN B.FOnStreCount IS NULL THEN 0 ELSE B.FOnStreCount END AS FOnStreCount,  \n");
        sb.append("\tCASE WHEN B.FOnStreCount2 IS NULL THEN 0 ELSE B.FOnStreCount2 END AS FOnStreCount2 \n");
        sb.append("FROM (SELECT FLongNumber, ISNULL(FIndex, -100) AS FIndex, FIsLeaf, FLevel, FID AS FUnitId, FName");
        sb.append(this.getLangSuffix(ctx));
        sb.append(" AS FName  \n");
        if (isIncludeSubCUs) {
            sb.append("        FROM T_ORG_Admin WHERE (FControlUnitID IN (SELECT FID FROM T_Org_CtrlUnit WHERE FLongNumber || '!' like ? || '!%' )) \n");
        } else {
            sb.append("        FROM T_ORG_Admin WHERE (FControlUnitID IN (SELECT FID FROM T_Org_CtrlUnit WHERE FLongNumber = ?)) \n");
        }
        if (longNumber != null) {
            sb.append(" AND (FLongNumber || '!' LIKE ?) \n");
        }
        sb.append(" \t\t\t   ) A LEFT OUTER JOIN \n");
        sb.append("          (SELECT A.FYear AS FYear, B.* \n");
        sb.append("         FROM (SELECT FID, FYear ");
        sb.append("                 FROM T_HR_PersonFixedTime \n");
        sb.append("                 WHERE (FFixedTime IN \n");
        sb.append("                           (SELECT MAX(FFixedTime) AS FFixedTime \n");
        sb.append("                         FROM T_HR_PersonFixedTime \n");
        sb.append("                          WHERE FIsSuccess = 1 AND ((FFixedTime >= ? AND FFixedTime <= ?) \n");
        if (isIncludeLastYear) {
            sb.append("\t\t\t OR (FFixedTime >= ? AND FFixedTime <= ?)\t \n");
        }
        sb.append("                        ) group by FYear ))) A INNER JOIN \n");
        sb.append("               T_HR_PersonFixedHistory2 B ON A.FID = B.FFixedTimeID) B ON  \n");
        sb.append("      A.FUnitId = B.FAdminOrgID \n");
        sb.append(" WHERE A.FLevel <= ? \n");
        sb.append(" ORDER BY A.FLongNumber, A.FIndex, B.FYear \n");
        logger.debug((Object)"\ngetYearSql : begin \n");
        logger.debug((Object)sb.toString());
        logger.debug((Object)"\ngetYearSql : end \n");
        return sb.toString();
    }

    private String getHalfYearSql(Context ctx, String adminIds, boolean isIncludeLastYear, String table) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT A.FLongNumber, A.FIsLeaf,A.FIndex,  A.FLevel, A.FUnitId AS FAdminOrgID, A.FName,  \n");
        sb.append("CASE WHEN B.FYear IS NULL THEN 0 ELSE B.FYear END AS FYear,   \n");
        sb.append("CASE WHEN B.FHalfYear IS NULL THEN 0 ELSE B.FHalfYear END AS FInterval,   \n");
        sb.append("CASE WHEN B.FCount IS NULL THEN 0 ELSE B.FCount END AS FCount,   \n");
        sb.append("CASE WHEN B.FPartimeCount IS NULL THEN 0 ELSE B.FPartimeCount END AS FPartimeCount,   \n");
        sb.append("CASE WHEN B.FOffStreCount IS NULL THEN 0 ELSE B.FOffStreCount END AS FOffStreCount,   \n");
        sb.append("CASE WHEN B.FOnStreCount IS NULL THEN 0 ELSE B.FOnStreCount END AS FOnStreCount,   \n");
        sb.append("CASE WHEN B.FOnStreCount2 IS NULL THEN 0 ELSE B.FOnStreCount2 END AS FOnStreCount2  \n");
        sb.append("FROM (SELECT FLongNumber, ISNULL(FIndex, -100) AS FIndex, FIsLeaf, FLevel, FID AS FUnitId, FName");
        sb.append(this.getLangSuffix(ctx));
        sb.append("  AS FName  \n");
        sb.append("        FROM T_ORG_Admin WHERE FID IN (");
        sb.append(adminIds);
        sb.append(")");
        sb.append("\t \t\t\t   ) A LEFT OUTER JOIN   \n");
        sb.append("(SELECT A.FYear AS FYear, A.FHalfYear AS FHalfYear, B.*   \n");
        sb.append("FROM (SELECT FID, FYear, FHalfYear   \n");
        sb.append("FROM T_HR_PersonFixedTime   \n");
        sb.append("WHERE (FFixedTime IN   \n");
        sb.append("                           (SELECT MAX(FFixedTime) AS FFixedTime FROM  \n");
        sb.append("                         \t\t(SELECT FFixedTime, CASE WHEN Month(FFixedTime) < 7 THEN 1 WHEN Month(FFixedTime) >7  THEN 2 END AS INTERVAL,  \n");
        sb.append("                         \t\t\tYEAR(FFixedTime) AS T_YEAR \n");
        sb.append("                         \t \t\tFROM T_HR_PersonFixedTime \n");
        sb.append("                         \t \n");
        sb.append("                          WHERE FIsSuccess = 1 AND ((FFixedTime >= ? AND FFixedTime <= ?) \n");
        if (isIncludeLastYear) {
            sb.append("\t\t\t OR (FFixedTime >= ? AND FFixedTime <= ?)\t \n");
        }
        sb.append("\t\t\t\t) ) TIME_INTV  \n");
        sb.append("\t\t\t\tGROUP BY T_YEAR, INTERVAL  \n");
        sb.append("                         ))) A INNER JOIN \n");
        sb.append(table);
        sb.append(" B ON A.FID = B.FFixedTimeID) B ON    \n");
        sb.append("A.FUnitId = B.FAdminOrgID   \n");
        sb.append("ORDER BY A.FLongNumber, A.FIndex, B.FYear, B.FHalfYear   \n");
        logger.debug((Object)"\ngetHalfYearSql : begin \n");
        logger.debug((Object)sb.toString());
        logger.debug((Object)"\ngetHalfYearSql : end \n");
        return sb.toString();
    }

    private String getHalfYearSql(Context ctx, boolean isIncludeLastYear, String longNumber, boolean isIncludeSubCUs) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT A.FLongNumber, A.FIsLeaf,A.FIndex,  A.FLevel, A.FUnitId AS FAdminOrgID, A.FName,  \n");
        sb.append("CASE WHEN B.FYear IS NULL THEN 0 ELSE B.FYear END AS FYear,   \n");
        sb.append("CASE WHEN B.FHalfYear IS NULL THEN 0 ELSE B.FHalfYear END AS FInterval,   \n");
        sb.append("CASE WHEN B.FCount IS NULL THEN 0 ELSE B.FCount END AS FCount,   \n");
        sb.append("CASE WHEN B.FPartimeCount IS NULL THEN 0 ELSE B.FPartimeCount END AS FPartimeCount,   \n");
        sb.append("CASE WHEN B.FOffStreCount IS NULL THEN 0 ELSE B.FOffStreCount END AS FOffStreCount,   \n");
        sb.append("CASE WHEN B.FOnStreCount IS NULL THEN 0 ELSE B.FOnStreCount END AS FOnStreCount,   \n");
        sb.append("CASE WHEN B.FOnStreCount2 IS NULL THEN 0 ELSE B.FOnStreCount2 END AS FOnStreCount2  \n");
        sb.append("FROM (SELECT FLongNumber, ISNULL(FIndex, -100) AS FIndex, FIsLeaf, FLevel, FID AS FUnitId, FName");
        sb.append(this.getLangSuffix(ctx));
        sb.append("  AS FName  \n");
        if (isIncludeSubCUs) {
            sb.append("        FROM T_ORG_Admin WHERE (FControlUnitID IN (SELECT FID FROM T_Org_CtrlUnit WHERE FLongNumber || '!' like ? || '!%' )) \n");
        } else {
            sb.append("        FROM T_ORG_Admin WHERE (FControlUnitID IN (SELECT FID FROM T_Org_CtrlUnit WHERE FLongNumber = ?)) \n");
        }
        if (longNumber != null) {
            sb.append(" AND (FLongNumber || '!' LIKE ?) \n");
        }
        sb.append("\t \t\t\t   ) A LEFT OUTER JOIN   \n");
        sb.append("(SELECT A.FYear AS FYear, A.FHalfYear AS FHalfYear, B.*   \n");
        sb.append("FROM (SELECT FID, FYear, FHalfYear   \n");
        sb.append("FROM T_HR_PersonFixedTime   \n");
        sb.append("WHERE (FFixedTime IN   \n");
        sb.append("(SELECT MAX(FFixedTime) AS FFixedTime   \n");
        sb.append("FROM T_HR_PersonFixedTime   \n");
        sb.append("WHERE FIsSuccess = 1 AND ((FFixedTime >= ? AND    \n");
        sb.append("FFixedTime <= ?)   \n");
        if (isIncludeLastYear) {
            sb.append("OR (FFixedTime >= ? AND FFixedTime <= ?)\t   \n");
        }
        sb.append(") group by FYear, FHalfYear  \n");
        sb.append("))) A INNER JOIN   \n");
        sb.append("T_HR_PersonFixedHistory2 B ON A.FID = B.FFixedTimeID) B ON    \n");
        sb.append("A.FUnitId = B.FAdminOrgID   \n");
        sb.append(" WHERE A.FLevel <= ? \n");
        sb.append("ORDER BY A.FLongNumber, A.FIndex, B.FYear, B.FHalfYear   \n");
        logger.debug((Object)"\ngetHalfYearSql : begin \n");
        logger.debug((Object)sb.toString());
        logger.debug((Object)"\ngetHalfYearSql : end \n");
        return sb.toString();
    }

    private String getQuarterSql(Context ctx, String adminIds, boolean isIncludeLastYear, String table) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT A.FLongNumber, A.FIsLeaf,A.FIndex, A.FLevel, A.FUnitId AS FAdminOrgID, A.FName,   \n");
        sb.append("CASE WHEN B.FYear IS NULL THEN 0 ELSE B.FYear END AS FYear,    \n");
        sb.append("CASE WHEN B.FQuarter IS NULL THEN 0 ELSE B.FQuarter END AS FInterval,    \n");
        sb.append("CASE WHEN B.FCount IS NULL THEN 0 ELSE B.FCount END AS FCount,   ");
        sb.append("CASE WHEN B.FPartimeCount IS NULL THEN 0 ELSE B.FPartimeCount END AS FPartimeCount,    \n");
        sb.append("CASE WHEN B.FOffStreCount IS NULL THEN 0 ELSE B.FOffStreCount END AS FOffStreCount,    \n");
        sb.append("CASE WHEN B.FOnStreCount IS NULL THEN 0 ELSE B.FOnStreCount END AS FOnStreCount,    \n");
        sb.append("CASE WHEN B.FOnStreCount2 IS NULL THEN 0 ELSE B.FOnStreCount2 END AS FOnStreCount2   \n");
        sb.append("FROM (SELECT FLongNumber, ISNULL(FIndex, -100) AS FIndex, FIsLeaf, FLevel, FID AS FUnitId, FName");
        sb.append(this.getLangSuffix(ctx));
        sb.append(" AS FName  \n");
        sb.append("        FROM T_ORG_Admin WHERE FID IN (");
        sb.append(adminIds);
        sb.append(")");
        sb.append("\t \t\t\t   ) A LEFT OUTER JOIN   \n");
        sb.append("(SELECT A.FYear AS FYear, A.FQuarter AS FQuarter, B.*   \n");
        sb.append("FROM (SELECT FID, FYear, FQuarter   \n");
        sb.append("FROM T_HR_PersonFixedTime   \n");
        sb.append("WHERE (FFixedTime IN   \n");
        sb.append("                           (SELECT MAX(FFixedTime) AS FFixedTime FROM  \n");
        sb.append("                         \t\t(SELECT FFixedTime,  CASE WHEN Month(FFixedTime) < 4 THEN 1 WHEN Month(FFixedTime) >=4 AND Month(FFixedTime) < 7 THEN 2  \n");
        sb.append("                         \t\tWHEN Month(FFixedTime) >=7 AND Month(FFixedTime) < 10 THEN 3 WHEN Month(FFixedTime) > 9  THEN 4 END AS INTERVAL,  \n");
        sb.append("                         \t\t\tYEAR(FFixedTime) AS T_YEAR \n");
        sb.append("                         \t \t\tFROM T_HR_PersonFixedTime \n");
        sb.append("                         \t \n");
        sb.append("                          WHERE FIsSuccess = 1 AND ((FFixedTime >= ? AND FFixedTime <= ?) \n");
        if (isIncludeLastYear) {
            sb.append("\t\t\t OR (FFixedTime >= ? AND FFixedTime <= ?)\t \n");
        }
        sb.append("\t\t\t\t) ) TIME_INTV  \n");
        sb.append("\t\t\t\tGROUP BY T_YEAR, INTERVAL  \n");
        sb.append("                         ))) A INNER JOIN \n");
        sb.append(table);
        sb.append(" B ON A.FID = B.FFixedTimeID) B ON    \n");
        sb.append("A.FUnitId = B.FAdminOrgID   \n");
        sb.append("ORDER BY A.FLongNumber, A.FIndex, B.FYear, B.FQuarter   \n");
        logger.debug((Object)"\ngetQuarterSql : begin \n");
        logger.debug((Object)sb.toString());
        logger.debug((Object)"\ngetQuarterSql : end \n");
        return sb.toString();
    }

    private String getQuarterSql(Context ctx, boolean isIncludeLastYear, String longNumber, boolean isIncludeSubCUs) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT A.FLongNumber, A.FIsLeaf,A.FIndex, A.FLevel, A.FUnitId AS FAdminOrgID, A.FName,   \n");
        sb.append("CASE WHEN B.FYear IS NULL THEN 0 ELSE B.FYear END AS FYear,    \n");
        sb.append("CASE WHEN B.FQuarter IS NULL THEN 0 ELSE B.FQuarter END AS FInterval,    \n");
        sb.append("CASE WHEN B.FCount IS NULL THEN 0 ELSE B.FCount END AS FCount,   ");
        sb.append("CASE WHEN B.FPartimeCount IS NULL THEN 0 ELSE B.FPartimeCount END AS FPartimeCount,    \n");
        sb.append("CASE WHEN B.FOffStreCount IS NULL THEN 0 ELSE B.FOffStreCount END AS FOffStreCount,    \n");
        sb.append("CASE WHEN B.FOnStreCount IS NULL THEN 0 ELSE B.FOnStreCount END AS FOnStreCount,    \n");
        sb.append("CASE WHEN B.FOnStreCount2 IS NULL THEN 0 ELSE B.FOnStreCount2 END AS FOnStreCount2   \n");
        sb.append("FROM (SELECT FLongNumber, ISNULL(FIndex, -100) AS FIndex, FIsLeaf, FLevel, FID AS FUnitId, FName");
        sb.append(this.getLangSuffix(ctx));
        sb.append(" AS FName  \n");
        if (isIncludeSubCUs) {
            sb.append("        FROM T_ORG_Admin WHERE (FControlUnitID IN (SELECT FID FROM T_Org_CtrlUnit WHERE FLongNumber || '!' like ? || '!%' )) \n");
        } else {
            sb.append("        FROM T_ORG_Admin WHERE (FControlUnitID IN (SELECT FID FROM T_Org_CtrlUnit WHERE FLongNumber = ?)) \n");
        }
        if (longNumber != null) {
            sb.append(" AND (FLongNumber || '!' LIKE ?) \n");
        }
        sb.append("\t \t\t\t   ) A LEFT OUTER JOIN   \n");
        sb.append("(SELECT A.FYear AS FYear, A.FQuarter AS FQuarter, B.*   \n");
        sb.append("FROM (SELECT FID, FYear, FQuarter   \n");
        sb.append("FROM T_HR_PersonFixedTime   \n");
        sb.append("WHERE (FFixedTime IN   \n");
        sb.append("(SELECT MAX(FFixedTime) AS FFixedTime   \n");
        sb.append("FROM T_HR_PersonFixedTime   \n");
        sb.append("WHERE FIsSuccess = 1 AND ((FFixedTime >= ? AND    \n");
        sb.append("FFixedTime <= ?)   \n");
        if (isIncludeLastYear) {
            sb.append("OR (FFixedTime >= ? AND FFixedTime <= ?)\t   \n");
        }
        sb.append(") group by FYear, FQuarter   \n");
        sb.append("))) A INNER JOIN   \n");
        sb.append("T_HR_PersonFixedHistory2 B ON A.FID = B.FFixedTimeID) B ON    \n");
        sb.append("A.FUnitId = B.FAdminOrgID   \n");
        sb.append(" WHERE A.FLevel <= ?  \n");
        sb.append("ORDER BY A.FLongNumber, A.FIndex, B.FYear, B.FQuarter   \n");
        logger.debug((Object)"\ngetQuarterSql : begin \n");
        logger.debug((Object)sb.toString());
        logger.debug((Object)"\ngetQuarterSql : end \n");
        return sb.toString();
    }

    private String getMonthSql(Context ctx, boolean isIncludeLastYear, String longNumber, boolean isIncludeSubCUs) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT A.FLongNumber, A.FIsLeaf, A.FLevel, A.FIndex, A.FUnitId AS FAdminOrgID, A.FName,  \n");
        sb.append("CASE WHEN B.FYear IS NULL THEN 0 ELSE B.FYear END AS FYear,   \n");
        sb.append("CASE WHEN B.FMonth IS NULL THEN 0 ELSE B.FMonth END AS FInterval,   \n");
        sb.append("CASE WHEN B.FCount IS NULL THEN 0 ELSE B.FCount END AS FCount,   \n");
        sb.append("CASE WHEN B.FPartimeCount IS NULL THEN 0 ELSE B.FPartimeCount END AS FPartimeCount,   \n");
        sb.append("CASE WHEN B.FOffStreCount IS NULL THEN 0 ELSE B.FOffStreCount END AS FOffStreCount,   \n");
        sb.append("CASE WHEN B.FOnStreCount IS NULL THEN 0 ELSE B.FOnStreCount END AS FOnStreCount,   \n");
        sb.append("CASE WHEN B.FOnStreCount2 IS NULL THEN 0 ELSE B.FOnStreCount2 END AS FOnStreCount2  \n");
        sb.append("FROM (SELECT FLongNumber, ISNULL(FIndex, -100) AS FIndex, FIsLeaf, FLevel, FID AS FUnitId, FName");
        sb.append(this.getLangSuffix(ctx));
        sb.append(" AS FName \n");
        if (isIncludeSubCUs) {
            sb.append("        FROM T_ORG_Admin WHERE (FControlUnitID IN (SELECT FID FROM T_Org_CtrlUnit WHERE FLongNumber || '!' like ? || '!%' )) \n");
        } else {
            sb.append("        FROM T_ORG_Admin WHERE (FControlUnitID IN (SELECT FID FROM T_Org_CtrlUnit WHERE FLongNumber = ?)) \n");
        }
        if (longNumber != null) {
            sb.append(" AND (FLongNumber || '!' LIKE ?) \n");
        }
        sb.append("\t \t\t\t   ) A LEFT OUTER JOIN  \n");
        sb.append("(SELECT A.FYear AS FYear, A.FMonth AS FMonth, B.*  \n");
        sb.append("FROM (SELECT FID, FYear, FMonth  \n");
        sb.append("FROM T_HR_PersonFixedTime  \n");
        sb.append("WHERE (FFixedTime IN  \n");
        sb.append("(SELECT MAX(FFixedTime) AS FFixedTime  \n");
        sb.append("FROM T_HR_PersonFixedTime  \n");
        sb.append("WHERE FIsSuccess = 1 AND ((FFixedTime >= ? AND   \n");
        sb.append("FFixedTime <= ?)  \n");
        if (isIncludeLastYear) {
            sb.append("OR (FFixedTime >= ? AND FFixedTime <= ?)\t  \n");
        }
        sb.append(") group by FYear, FMonth ");
        sb.append("))) A INNER JOIN  \n");
        sb.append("T_HR_PersonFixedHistory2 B ON A.FID = B.FFixedTimeID) B ON   \n");
        sb.append("A.FUnitId = B.FAdminOrgID  \n");
        sb.append(" WHERE A.FLevel <= ?  \n");
        sb.append("ORDER BY A.FLongNumber, A.FIndex, B.FYear, B.FMonth  \n");
        logger.debug((Object)"\ngetMonthSql : begin \n");
        logger.debug((Object)sb.toString());
        logger.debug((Object)"\ngetMonthSql : end \n");
        return sb.toString();
    }

    private String getMonthSql(Context ctx, String adminIds, boolean isIncludeLastYear, String table) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT A.FLongNumber, A.FIsLeaf, A.FLevel, A.FIndex, A.FUnitId AS FAdminOrgID, A.FName,  \n");
        sb.append("CASE WHEN B.FYear IS NULL THEN 0 ELSE B.FYear END AS FYear,   \n");
        sb.append("CASE WHEN B.FMonth IS NULL THEN 0 ELSE B.FMonth END AS FInterval,   \n");
        sb.append("CASE WHEN B.FCount IS NULL THEN 0 ELSE B.FCount END AS FCount,   \n");
        sb.append("CASE WHEN B.FPartimeCount IS NULL THEN 0 ELSE B.FPartimeCount END AS FPartimeCount,   \n");
        sb.append("CASE WHEN B.FOffStreCount IS NULL THEN 0 ELSE B.FOffStreCount END AS FOffStreCount,   \n");
        sb.append("CASE WHEN B.FOnStreCount IS NULL THEN 0 ELSE B.FOnStreCount END AS FOnStreCount,   \n");
        sb.append("CASE WHEN B.FOnStreCount2 IS NULL THEN 0 ELSE B.FOnStreCount2 END AS FOnStreCount2  \n");
        sb.append("FROM (SELECT FLongNumber, ISNULL(FIndex, -100) AS FIndex, FIsLeaf, FLevel, FID AS FUnitId, FName");
        sb.append(this.getLangSuffix(ctx));
        sb.append(" AS FName \n");
        sb.append("        FROM T_ORG_Admin WHERE FID IN (");
        sb.append(adminIds);
        sb.append(")");
        sb.append("\t \t\t\t   ) A LEFT OUTER JOIN  \n");
        sb.append("(SELECT A.FYear AS FYear, A.FMonth AS FMonth, B.*  \n");
        sb.append("FROM (SELECT FID, FYear, FMonth  \n");
        sb.append("FROM T_HR_PersonFixedTime  \n");
        sb.append("WHERE (FFixedTime IN  \n");
        sb.append("                           (SELECT MAX(FFixedTime) AS FFixedTime FROM  \n");
        sb.append("                         \t(SELECT FFixedTime, MONTH(FFixedTime) AS INTERVAL, YEAR(FFixedTime) AS T_YEAR  \n");
        sb.append("                         \t \t\tFROM T_HR_PersonFixedTime \n");
        sb.append("                         \t \n");
        sb.append("                          WHERE FIsSuccess = 1 AND ((FFixedTime >= ? AND FFixedTime <= ?) \n");
        if (isIncludeLastYear) {
            sb.append("\t\t\t OR (FFixedTime >= ? AND FFixedTime <= ?)\t \n");
        }
        sb.append("\t\t\t\t) ) TIME_INTV  \n");
        sb.append("\t\t\t\tGROUP BY T_YEAR, INTERVAL  \n");
        sb.append("                         ))) A INNER JOIN \n");
        sb.append(table);
        sb.append(" B ON A.FID = B.FFixedTimeID) B ON   \n");
        sb.append("A.FUnitId = B.FAdminOrgID  \n");
        sb.append("ORDER BY A.FLongNumber, A.FIndex, B.FYear, B.FMonth  \n");
        logger.debug((Object)"\ngetMonthSql : begin \n");
        logger.debug((Object)sb.toString());
        logger.debug((Object)"\ngetMonthSql : end \n");
        return sb.toString();
    }

    private String getDefaultHierarchyId(Context ctx) throws BOSException, EASBizException {
        HierarchyInfo hInfo = HierarchyFactory.getLocalInstance((Context)ctx).getDefaultHierarchy();
        if (hInfo == null) {
            throw new BOSException("no default hierarchy!");
        }
        return hInfo.getId().toString();
    }

    private String getPHLongNumber(Context ctx, String positionId) throws BOSException, EASBizException {
        String hierarchyId = null;
        HierarchyInfo hInfo = HierarchyFactory.getLocalInstance((Context)ctx).getDefaultHierarchy();
        if (hInfo == null) {
            throw new BOSException("no default hierarchy!");
        }
        hierarchyId = hInfo.getId().toString();
        PositionHierarchyCollection c = PositionHierarchyFactory.getLocalInstance((Context)ctx).getPositionHierarchyCollection("select longnumber where child.id = '" + positionId + "' and hierarchy.id = '" + hierarchyId + "'");
        return c.get(0).getLongNumber();
    }

    private String getSql(Context ctx, boolean isIncludeLastYear, String intervalType, String adminIds, String table) {
        if ("YEAR".equalsIgnoreCase(intervalType)) {
            return this.getYearSql(ctx, adminIds, isIncludeLastYear, table);
        }
        if ("QUARTER".equalsIgnoreCase(intervalType)) {
            return this.getQuarterSql(ctx, adminIds, isIncludeLastYear, table);
        }
        if ("HALFYEAR".equalsIgnoreCase(intervalType)) {
            return this.getHalfYearSql(ctx, adminIds, isIncludeLastYear, table);
        }
        return this.getMonthSql(ctx, adminIds, isIncludeLastYear, table);
    }

    private String getSql(Context ctx, boolean isIncludeLastYear, String intervalType, String longNumber, boolean isIncludeSubCUs) {
        if ("YEAR".equalsIgnoreCase(intervalType)) {
            return this.getYearSql(ctx, isIncludeLastYear, longNumber, isIncludeSubCUs);
        }
        if ("QUARTER".equalsIgnoreCase(intervalType)) {
            return this.getQuarterSql(ctx, isIncludeLastYear, longNumber, isIncludeSubCUs);
        }
        if ("HALFYEAR".equalsIgnoreCase(intervalType)) {
            return this.getHalfYearSql(ctx, isIncludeLastYear, longNumber, isIncludeSubCUs);
        }
        return this.getMonthSql(ctx, isIncludeLastYear, longNumber, isIncludeSubCUs);
    }

    private String getPositionSql(Context ctx, boolean isIncludeLastYear, String intervalType) {
        if ("YEAR".equalsIgnoreCase(intervalType)) {
            return this.getPositionYearSql(ctx, isIncludeLastYear);
        }
        if ("QUARTER".equalsIgnoreCase(intervalType)) {
            return this.getPositionQuarterSql(ctx, isIncludeLastYear);
        }
        if ("HALFYEAR".equalsIgnoreCase(intervalType)) {
            return this.getPositionHalfYearSql(ctx, isIncludeLastYear);
        }
        return this.getPositionMonthSql(ctx, isIncludeLastYear);
    }

    private Timestamp getSqlDate(Date date) {
        return new Timestamp(date.getTime());
    }

    private Object[] getParams(Context ctx, Date beginDate, Date endDate, boolean isIncludeLastYear, String longNumber) {
        Date lastBeginDate = DateTimeUtils.addYear((Date)beginDate, (int)-1);
        Date lastEndDate = DateTimeUtils.addYear((Date)endDate, (int)-1);
        Object[] param = null;
        param = longNumber == null ? (!isIncludeLastYear ? new Object[]{this.getCULongNumber(ctx), this.getSqlDate(beginDate), this.getSqlDate(endDate)} : new Object[]{this.getCULongNumber(ctx), this.getSqlDate(beginDate), this.getSqlDate(endDate), this.getSqlDate(lastBeginDate), this.getSqlDate(lastEndDate)}) : (!isIncludeLastYear ? new Object[]{this.getCULongNumber(ctx), longNumber + "!%", this.getSqlDate(beginDate), this.getSqlDate(endDate)} : new Object[]{this.getCULongNumber(ctx), longNumber + "!%", this.getSqlDate(beginDate), this.getSqlDate(endDate), this.getSqlDate(lastBeginDate), this.getSqlDate(lastEndDate)});
        logger.debug((Object)"/n param begin :");
        for (int i = 0; i < param.length; ++i) {
            logger.debug((Object)("/n" + i + ":" + param[i]));
        }
        logger.debug((Object)"/n param end");
        return param;
    }

    private Object[] getParams(Date beginDate, Date endDate) {
        Object[] param = null;
        param = new Object[]{this.getSqlDate(beginDate), this.getSqlDate(endDate)};
        logger.debug((Object)"/n param begin :");
        for (int i = 0; i < param.length; ++i) {
            logger.debug((Object)("/n" + i + ":" + param[i]));
        }
        logger.debug((Object)"/n param end");
        return param;
    }

    private Object[] getParams(Context ctx, Date beginDate, Date endDate, String longNumber, int level) throws EASBizException, BOSException {
        Object[] param = null;
        param = longNumber == null ? new Object[]{this.getCULongNumber(ctx), this.getSqlDate(beginDate), this.getSqlDate(endDate), String.valueOf(this.getLevel(ctx, null) + level)} : new Object[]{this.getCULongNumber(ctx), longNumber + "!%", this.getSqlDate(beginDate), this.getSqlDate(endDate), String.valueOf(this.getLevel(ctx, longNumber) + level)};
        logger.debug((Object)"/n param begin :");
        for (int i = 0; i < param.length; ++i) {
            logger.debug((Object)("/n" + i + ":" + param[i]));
        }
        logger.debug((Object)"/n param end");
        return param;
    }

    private Object[] getParams(Context ctx, Date beginDate, Date endDate, Date lastBeginDate, Date lastEndDate, String longNumber, int level) throws EASBizException, BOSException {
        Object[] param = null;
        param = longNumber == null ? new Object[]{this.getCULongNumber(ctx), this.getSqlDate(beginDate), this.getSqlDate(endDate), this.getSqlDate(lastBeginDate), this.getSqlDate(lastEndDate), String.valueOf(this.getLevel(ctx, null) + level)} : new Object[]{this.getCULongNumber(ctx), longNumber + "!%", this.getSqlDate(beginDate), this.getSqlDate(endDate), this.getSqlDate(lastBeginDate), this.getSqlDate(lastEndDate), String.valueOf(this.getLevel(ctx, longNumber) + level)};
        logger.debug((Object)"\n param begin :");
        for (int i = 0; i < param.length; ++i) {
            logger.debug((Object)("\n" + i + ":" + param[i]));
        }
        logger.debug((Object)"\n param end");
        return param;
    }

    private Object[] getParams(Date beginDate, Date endDate, Date lastBeginDate, Date lastEndDate) {
        Object[] param = null;
        param = new Object[]{this.getSqlDate(beginDate), this.getSqlDate(endDate), this.getSqlDate(lastBeginDate), this.getSqlDate(lastEndDate)};
        logger.debug((Object)"\n param begin :");
        for (int i = 0; i < param.length; ++i) {
            logger.debug((Object)("\n" + i + ":" + param[i]));
        }
        logger.debug((Object)"\n param end");
        return param;
    }

    private Object[] getPositionParams(Context ctx, Date beginDate, Date endDate, Date lastBeginDate, Date lastEndDate, String positionId, int level) throws BOSException, EASBizException {
        Object[] param = null;
        param = new Object[]{this.getDefaultHierarchyId(ctx), this.getPHLongNumber(ctx, positionId) + "!%", this.getSqlDate(beginDate), this.getSqlDate(endDate), this.getSqlDate(lastBeginDate), this.getSqlDate(lastEndDate), this.getPHLevel(ctx, positionId) + level};
        logger.debug((Object)"\n param begin :");
        for (int i = 0; i < param.length; ++i) {
            logger.debug((Object)("\n" + i + ":" + param[i]));
        }
        logger.debug((Object)"\n param end");
        return param;
    }

    private Object[] getPositionParams(Context ctx, Date beginDate, Date endDate, String positionId, int level) throws BOSException, EASBizException {
        Object[] param = null;
        param = new Object[]{this.getDefaultHierarchyId(ctx), this.getPHLongNumber(ctx, positionId) + "!%", this.getSqlDate(beginDate), this.getSqlDate(endDate), String.valueOf(this.getPHLevel(ctx, positionId) + level)};
        logger.debug((Object)"\n param begin :");
        for (int i = 0; i < param.length; ++i) {
            logger.debug((Object)("\n" + i + ":" + param[i]));
        }
        logger.debug((Object)"\n param end");
        return param;
    }

    @Override
    protected IRowSet _getRows(Context ctx, Date beginDate, Date endDate, boolean isIncludeLastYear, String intervalType, String longNumber, boolean isIncludeSubCUs) throws BOSException, EASBizException {
        return DbUtil.executeQuery((Context)ctx, (String)this.getSql(ctx, isIncludeLastYear, intervalType, longNumber, isIncludeSubCUs), (Object[])this.getParams(ctx, beginDate, endDate, isIncludeLastYear, longNumber));
    }

    @Override
    protected IRowSet _getRows(Context ctx, Date beginDate, Date endDate, String intervalType, String longNumber, boolean isIncludeSubCUs, int level) throws BOSException, EASBizException {
        return DbUtil.executeQuery((Context)ctx, (String)this.getSql(ctx, false, intervalType, longNumber, isIncludeSubCUs), (Object[])this.getParams(ctx, beginDate, endDate, longNumber, level));
    }

    @Override
    protected IRowSet _getRows(Context ctx, Date beginDate, Date endDate, Date lastBeginDate, Date lastEndDate, String intervalType, String longNumber, boolean isIncludeSubCUs, int level) throws BOSException, EASBizException {
        return DbUtil.executeQuery((Context)ctx, (String)this.getSql(ctx, true, intervalType, longNumber, isIncludeSubCUs), (Object[])this.getParams(ctx, beginDate, endDate, lastBeginDate, lastEndDate, longNumber, level));
    }

    @Override
    protected IRowSet _getNewRows(Context ctx, Date beginDate, Date endDate, String intervalType, String adminIds, boolean isOnlySelectOrg) throws BOSException, EASBizException {
        if (isOnlySelectOrg) {
            String tempTable = null;
            try {
                tempTable = this.getTempTableName(ctx, adminIds, this.getParams(beginDate, endDate));
                return DbUtil.executeQuery((Context)ctx, (String)this.getSql(ctx, false, intervalType, adminIds, tempTable), (Object[])this.getParams(beginDate, endDate));
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return DbUtil.executeQuery((Context)ctx, (String)this.getSql(ctx, false, intervalType, adminIds, "T_HR_PersonFixedHistory2"), (Object[])this.getParams(beginDate, endDate));
    }

    @Override
    protected IRowSet _getNewRows(Context ctx, Date beginDate, Date endDate, Date lastBeginDate, Date lastEndDate, String intervalType, String adminIds, boolean isOnlySelectOrg) throws BOSException, EASBizException {
        if (isOnlySelectOrg) {
            String tempTable = null;
            try {
                tempTable = this.getTempTableName(ctx, adminIds, this.getParams(beginDate, endDate, lastBeginDate, lastEndDate));
                return DbUtil.executeQuery((Context)ctx, (String)this.getSql(ctx, true, intervalType, adminIds, tempTable), (Object[])this.getParams(beginDate, endDate, lastBeginDate, lastEndDate));
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return DbUtil.executeQuery((Context)ctx, (String)this.getSql(ctx, true, intervalType, adminIds, "T_HR_PersonFixedHistory2"), (Object[])this.getParams(beginDate, endDate, lastBeginDate, lastEndDate));
    }

    @Override
    protected IRowSet _getPositionRows(Context ctx, Date beginDate, Date endDate, Date lastBeginDate, Date lastEndDate, String intervalType, String positionId, int level) throws BOSException, EASBizException {
        return DbUtil.executeQuery((Context)ctx, (String)this.getPositionSql(ctx, true, intervalType), (Object[])this.getPositionParams(ctx, beginDate, endDate, lastBeginDate, lastEndDate, positionId, level));
    }

    @Override
    protected IRowSet _getPositionRows(Context ctx, Date beginDate, Date endDate, String intervalType, String positionId, int level) throws BOSException, EASBizException {
        return DbUtil.executeQuery((Context)ctx, (String)this.getPositionSql(ctx, false, intervalType), (Object[])this.getPositionParams(ctx, beginDate, endDate, positionId, level));
    }

    @Override
    protected IRowSet _getAdminRows(Context ctx, Date beginDate, Date endDate, Date lastBeginDate, Date lastEndDate, String intervalType, String adminIds) throws BOSException {
        String createTempTable = " create Table Temp_ZYDPERSONFIX2(FAdminOrgID VARCHAR(44),FFixedTimeID VARCHAR(44),FCount INT DEFAULT 0,FPartimeCount INT DEFAULT 0,FOffStreCount INT DEFAULT 0,FOnStreCount INT DEFAULT 0,FOnStreCount2 INT DEFAULT 0) ";
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tempTable = null;
        try {
            tempTable = pool.createTempTable(createTempTable);
            if (!StringUtils.isEmpty((String)tempTable)) {
                Object[] params = this.getParams(beginDate, endDate, lastBeginDate, lastEndDate);
                DbUtil.execute((Context)ctx, (String)("insert into " + tempTable + "(FFixedTimeID,FAdminOrgID,FCount,FPartimeCount,FOffStreCount,FOnStreCount,FOnStreCount2) " + this.getAdminRowsSql(true, adminIds)), (Object[])params);
                IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)this.getSql(ctx, true, intervalType, adminIds, tempTable), (Object[])params);
                return iRowSet;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!StringUtils.isEmpty((String)tempTable)) {
                pool.releaseTable(tempTable);
            }
        }
        return null;
    }

    private String getAdminRowsSql(boolean isIncludeLastYear, String adminIds) {
        StringBuffer selectData = new StringBuffer();
        selectData.append("select h.FFixedTimeID,h.FAdminOrgID,sum(h.FCount) as FCount,sum(h.FPartimeCount) as FPartimeCount,sum(h.FOffStreCount) as FOffStreCount,sum(h.FOnStreCount) as FOnStreCount,sum(h.FOnStreCount2) as FOnStreCount2 ");
        selectData.append(" from t_hr_personfixedhistory h");
        selectData.append(" inner join t_hr_personfixedtime t on h.FFixedTimeID = t.fid");
        selectData.append(" where t.FIsSuccess = 1 AND ((t.FFixedTime >= ? AND t.FFixedTime <= ?) ");
        if (isIncludeLastYear) {
            selectData.append(" OR (t.FFixedTime >= ? AND t.FFixedTime <= ?)");
        }
        selectData.append(") and h.FAdminOrgID in (");
        selectData.append(adminIds);
        selectData.append(") group by h.FFixedTimeID,h.FAdminOrgID");
        return selectData.toString();
    }

    @Override
    protected IRowSet _getAdminRows(Context ctx, Date beginDate, Date endDate, String intervalType, String adminIds) throws BOSException, EASBizException {
        String createTempTable = " create Table Temp_ZYDPERSONFIX2(FAdminOrgID VARCHAR(44),FFixedTimeID VARCHAR(44),FCount INT DEFAULT 0,FPartimeCount INT DEFAULT 0,FOffStreCount INT DEFAULT 0,FOnStreCount INT DEFAULT 0,FOnStreCount2 INT DEFAULT 0) ";
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tempTable = null;
        try {
            tempTable = pool.createTempTable(createTempTable);
            if (!StringUtils.isEmpty((String)tempTable)) {
                Object[] params = this.getParams(beginDate, endDate);
                DbUtil.execute((Context)ctx, (String)("insert into " + tempTable + "(FFixedTimeID,FAdminOrgID,FCount,FPartimeCount,FOffStreCount,FOnStreCount,FOnStreCount2) " + this.getAdminRowsSql(false, adminIds)), (Object[])params);
                IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)this.getSql(ctx, false, intervalType, adminIds, tempTable), (Object[])params);
                return iRowSet;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!StringUtils.isEmpty((String)tempTable)) {
                pool.releaseTable(tempTable);
            }
        }
        return null;
    }

    public String getTempTableName(Context ctx, String adminIds, Object[] param) throws Exception {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tempTable = null;
        String createTempTable = "create table Temp_DHDCUNSELECTORG(FFixedTimeID VARCHAR(44), FAdminOrgID VARCHAR(44), FLongNumber NVARCHAR(80), FCount INT DEFAULT 0,FPartimeCount INT DEFAULT 0,FOffStreCount INT DEFAULT 0,FOnStreCount INT DEFAULT 0,FOnStreCount2 INT DEFAULT 0) ";
        tempTable = pool.createTempTable(createTempTable);
        String tempTable2 = null;
        tempTable2 = pool.createTempTable(createTempTable);
        DbUtil.execute((Context)ctx, (String)("insert into " + tempTable + "(FFixedTimeID,FAdminOrgID,FLongNumber,FCount,FPartimeCount,FOffStreCount,FOnStreCount,FOnStreCount2) " + this.getAdminRowsSql2(param.length == 4, adminIds)), (Object[])param);
        DbUtil.execute((Context)ctx, (String)("insert into " + tempTable2 + "(FFixedTimeID,FAdminOrgID,FLongNumber,FCount,FPartimeCount,FOffStreCount,FOnStreCount,FOnStreCount2) " + this.getAdminRowsSql2(param.length == 4, adminIds)), (Object[])param);
        int dbType = -1;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            dbType = KSqlUtil.getDbType((Connection)conn);
        }
        catch (SQLException e) {
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        if (dbType != 1) {
            StringBuffer sb = new StringBuffer(1024);
            sb.append("\n");
            sb.append("update ").append(tempTable).append("\n");
            sb.append("set FCount =(\n");
            sb.append("select sum(fcount) from ").append(tempTable2).append("  as tb\n");
            sb.append("where tb.FFixedTimeID = ").append(tempTable).append(".FFixedTimeID and (tb.FAdminOrgID = ");
            sb.append(tempTable).append(".FAdminOrgID or tb.FLongNumber like concat(").append(tempTable).append(".FLongNumber,'!%')));\n");
            sb.append("update ").append(tempTable).append("\n");
            sb.append("set FPartimeCount =(\n");
            sb.append("select sum(FPartimeCount) from ").append(tempTable2).append("  as tb\n");
            sb.append("where tb.FFixedTimeID = ").append(tempTable).append(".FFixedTimeID and (tb.FAdminOrgID = ");
            sb.append(tempTable).append(".FAdminOrgID or tb.FLongNumber like concat(").append(tempTable).append(".FLongNumber,'!%')));\n");
            sb.append("update ").append(tempTable).append("\n");
            sb.append("set FOffStreCount =(\n");
            sb.append("select sum(FOffStreCount) from ").append(tempTable2).append("  as tb\n");
            sb.append("where tb.FFixedTimeID = ").append(tempTable).append(".FFixedTimeID and (tb.FAdminOrgID = ");
            sb.append(tempTable).append(".FAdminOrgID or tb.FLongNumber like concat(").append(tempTable).append(".FLongNumber,'!%')));\n");
            sb.append("update ").append(tempTable).append("\n");
            sb.append("set FOnStreCount =(\n");
            sb.append("select sum(FOnStreCount) from ").append(tempTable2).append("  as tb\n");
            sb.append("where tb.FFixedTimeID = ").append(tempTable).append(".FFixedTimeID and (tb.FAdminOrgID = ");
            sb.append(tempTable).append(".FAdminOrgID or tb.FLongNumber like concat(").append(tempTable).append(".FLongNumber,'!%')));\n");
            sb.append("update ").append(tempTable).append("\n");
            sb.append("set FOnStreCount2 =(\n");
            sb.append("select sum(FOnStreCount2) from ").append(tempTable2).append("  as tb\n");
            sb.append("where tb.FFixedTimeID = ").append(tempTable).append(".FFixedTimeID and (tb.FAdminOrgID = ");
            sb.append(tempTable).append(".FAdminOrgID or tb.FLongNumber like concat(").append(tempTable).append(".FLongNumber,'!%')));\n");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        } else {
            StringBuffer sb1 = new StringBuffer(1024);
            sb1.append("\n");
            sb1.append("update ").append(tempTable).append("\n");
            sb1.append("set FCount =(\n");
            sb1.append("select sum(fcount) from ").append(tempTable2).append("  as tb\n");
            sb1.append("where tb.FFixedTimeID = ").append(tempTable).append(".FFixedTimeID and (tb.FAdminOrgID = ");
            sb1.append(tempTable).append(".FAdminOrgID or charindex (concat(").append(tempTable).append(".FLongNumber,'!'),tb.FLongNumber)=1));\n");
            DbUtil.execute((Context)ctx, (String)sb1.toString());
            StringBuffer sb2 = new StringBuffer(1024);
            sb2.append("update ").append(tempTable).append("\n");
            sb2.append("set FPartimeCount =(\n");
            sb2.append("select sum(FPartimeCount) from ").append(tempTable2).append("  as tb\n");
            sb2.append("where tb.FFixedTimeID = ").append(tempTable).append(".FFixedTimeID and (tb.FAdminOrgID = ");
            sb2.append(tempTable).append(".FAdminOrgID or charindex (concat(").append(tempTable).append(".FLongNumber,'!'),tb.FLongNumber)=1));\n");
            DbUtil.execute((Context)ctx, (String)sb2.toString());
            StringBuffer sb3 = new StringBuffer(1024);
            sb3.append("update ").append(tempTable).append("\n");
            sb3.append("set FOffStreCount =(\n");
            sb3.append("select sum(FOffStreCount) from ").append(tempTable2).append("  as tb\n");
            sb3.append("where tb.FFixedTimeID = ").append(tempTable).append(".FFixedTimeID and (tb.FAdminOrgID = ");
            sb3.append(tempTable).append(".FAdminOrgID or charindex (concat(").append(tempTable).append(".FLongNumber,'!'),tb.FLongNumber)=1));\n");
            DbUtil.execute((Context)ctx, (String)sb3.toString());
            StringBuffer sb4 = new StringBuffer(1024);
            sb4.append("update ").append(tempTable).append("\n");
            sb4.append("set FOnStreCount =(\n");
            sb4.append("select sum(FOnStreCount) from ").append(tempTable2).append("  as tb\n");
            sb4.append("where tb.FFixedTimeID = ").append(tempTable).append(".FFixedTimeID and (tb.FAdminOrgID = ");
            sb4.append(tempTable).append(".FAdminOrgID or charindex (concat(").append(tempTable).append(".FLongNumber,'!'),tb.FLongNumber)=1));\n");
            DbUtil.execute((Context)ctx, (String)sb4.toString());
            StringBuffer sb5 = new StringBuffer(1024);
            sb5.append("update ").append(tempTable).append("\n");
            sb5.append("set FOnStreCount2 =(\n");
            sb5.append("select sum(FOnStreCount2) from ").append(tempTable2).append("  as tb\n");
            sb5.append("where tb.FFixedTimeID = ").append(tempTable).append(".FFixedTimeID and (tb.FAdminOrgID = ");
            sb5.append(tempTable).append(".FAdminOrgID or charindex (concat(").append(tempTable).append(".FLongNumber,'!'),tb.FLongNumber)=1));\n");
            DbUtil.execute((Context)ctx, (String)sb5.toString());
        }
        if (!StringUtils.isEmpty((String)tempTable2)) {
            pool.releaseTable(tempTable2);
        }
        return tempTable;
    }

    private String getAdminRowsSql2(boolean isIncludeLastYear, String adminIds) {
        StringBuffer selectData = new StringBuffer();
        selectData.append(" select FFixedTimeID,FAdminOrgID,a.FLongNumber,FCount,FPartimeCount,FOffStreCount,FOnStreCount,FOnStreCount2 ");
        selectData.append(" from ( ");
        selectData.append(" select h.FFixedTimeID,h.FAdminOrgID,sum(h.FCount) as FCount,sum(h.FPartimeCount) as FPartimeCount,sum(h.FOffStreCount) as FOffStreCount,sum(h.FOnStreCount) as FOnStreCount,sum(h.FOnStreCount2) as FOnStreCount2 ");
        selectData.append(" from t_hr_personfixedhistory h");
        selectData.append(" inner join t_hr_personfixedtime t on h.FFixedTimeID = t.fid ");
        selectData.append(" where t.FIsSuccess = 1 AND ((t.FFixedTime >= ? AND t.FFixedTime <= ?) ");
        if (isIncludeLastYear) {
            selectData.append(" OR (t.FFixedTime >= ? AND t.FFixedTime <= ?) ");
        }
        selectData.append(" ) and h.FAdminOrgID in ( ");
        selectData.append(adminIds);
        selectData.append(" ) group by h.FFixedTimeID,h.FAdminOrgID ");
        selectData.append(" ) b ");
        selectData.append(" left join t_org_admin a on b.FAdminOrgID = a.fid ");
        return selectData.toString();
    }
}

