/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.OrgStringUtil;
import com.kingdee.eas.hr.emp.EmpDynamicScheduleRowInfo;
import com.kingdee.eas.hr.emp.app.AbstractEmpDynamicScheduleFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;

public class EmpDynamicScheduleFacadeControllerBean
extends AbstractEmpDynamicScheduleFacadeControllerBean {
    @Override
    protected List _getReportData(Context ctx, Map filter) throws BOSException, EASBizException {
        boolean isOrgMult;
        int whereIndex;
        String evStr;
        String tempTable = null;
        EntityViewInfo evInfo = (EntityViewInfo)filter.get("EntityViewInfo");
        if (evInfo != null && (evStr = evInfo.toString()) != null && (whereIndex = evStr.indexOf("WHERE")) >= 0) {
            tempTable = this.createEmpFlowTempTable(ctx, filter);
        }
        ArrayList<EmpDynamicScheduleRowInfo> list = new ArrayList<EmpDynamicScheduleRowInfo>();
        EmpDynamicScheduleRowInfo rowInfo = null;
        AdminOrgUnitCollection col = new AdminOrgUnitCollection();
        AdminOrgUnitInfo adminInfo = null;
        Object[] adminInfos = null;
        HashMap nodeMap = (HashMap)filter.get("NodeMap");
        DefaultKingdeeTreeNode root = null;
        boolean bl = isOrgMult = Boolean.valueOf(true).equals(filter.get("rdOrgMult")) || "true".equals(filter.get("rdOrgMult"));
        if (isOrgMult) {
            adminInfos = OrgStringUtil.string2OrgInfoArr((Context)ctx, (String)((String)filter.get("bizAdminOrgMult")), (boolean)false);
            adminInfos = OrgStringUtil.getRootAdminsFromTree((Map)nodeMap, (Object[])adminInfos).toArray();
            root = OrgStringUtil.reBuildTreeNodeByOrgs((Map)nodeMap, (Object[])adminInfos);
        } else {
            ObjectUuidPK pk = null;
            if (filter.get("SelectOrg") != null) {
                pk = new ObjectUuidPK(BOSUuid.read((String)((String)filter.get("SelectOrg"))));
            }
            if (pk != null) {
                adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo(pk);
            }
            if (adminInfo != null) {
                root = (DefaultKingdeeTreeNode)nodeMap.get(adminInfo.getId().toString());
            } else {
                HROrgUnitInfo hroInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
                if (hroInfo == null) {
                    return null;
                }
                try {
                    root = this.getRootNew(ctx, hroInfo.getId().toString(), true);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        if (root == null) {
            return null;
        }
        this.buildAdminNode(col, root);
        AdminOrgUnitInfo unitInfo = null;
        String whereStr = null;
        if (isOrgMult) {
            whereStr = " WHERE " + OrgStringUtil.getOrgsSqlIncludeChild((String)"T2.FID", (String)"T2.FLongNumber", (Object[])adminInfos);
        } else if (adminInfo != null) {
            whereStr = " WHERE (T2.FLongNumber = '" + adminInfo.getLongNumber() + "'  OR  T2.FLongNumber LIKE '" + adminInfo.getLongNumber() + "!%' )";
        }
        int level = 0;
        String startDate = this.getFixedDataStr((Date)filter.get("FStartDate"));
        String endDate = this.getFixedDataStr((Date)filter.get("FEndDate"));
        IRowSet inPersonRows = this.getInPersonCount(ctx, whereStr, startDate, endDate, tempTable);
        IRowSet outRows = this.getOutCount(ctx, whereStr, startDate, endDate, tempTable);
        IRowSet inRows = this.getINCount(ctx, whereStr, startDate, endDate, tempTable);
        IRowSet dimissionRows = this.getDimissionCount(ctx, whereStr, startDate, endDate, tempTable);
        IRowSet refuseRows = this.getRefuseCount(ctx, whereStr, startDate, endDate, tempTable);
        IRowSet retireRows = this.getRetireCount(ctx, whereStr, startDate, endDate, tempTable);
        HashMap inPersonMaps = this.getPersonCountByRowSet(inPersonRows);
        HashMap outMaps = this.getPersonCountByRowSet(outRows);
        HashMap inMaps = this.getPersonCountByRowSet(inRows);
        HashMap dimissionMaps = this.getPersonCountByRowSet(dimissionRows);
        HashMap refuseMaps = this.getPersonCountByRowSet(refuseRows);
        HashMap retireMaps = this.getPersonCountByRowSet(retireRows);
        String adminSql = "SELECT FLongNumber FROM T_ORG_Admin ";
        if (isOrgMult) {
            whereStr = " WHERE " + OrgStringUtil.getOrgsSqlIncludeChild((String)"T_ORG_Admin.FID", (String)"T_ORG_Admin.FLongNumber", (Object[])adminInfos);
        } else if (adminInfo != null) {
            adminSql = adminSql + " WHERE (T_ORG_Admin.FLongNumber = '" + adminInfo.getLongNumber() + "'  OR  T_ORG_Admin.FLongNumber LIKE '" + adminInfo.getLongNumber() + "!%' )";
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)adminSql);
        this.collectOrgData(ctx, inPersonMaps, rows);
        this.collectOrgData(ctx, outMaps, rows);
        this.collectOrgData(ctx, inMaps, rows);
        this.collectOrgData(ctx, dimissionMaps, rows);
        this.collectOrgData(ctx, refuseMaps, rows);
        this.collectOrgData(ctx, retireMaps, rows);
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            unitInfo = col.get(i);
            if (adminInfo != null && unitInfo.getLevel() == adminInfo.getLevel() + level - 1) {
                unitInfo.setIsLeaf(true);
            }
            rowInfo = new EmpDynamicScheduleRowInfo();
            rowInfo.adminInfo = unitInfo;
            if (inPersonMaps.get(unitInfo.getLongNumber()) != null) {
                rowInfo.inPerson = (Integer)inPersonMaps.get(unitInfo.getLongNumber());
            }
            if (outMaps.get(unitInfo.getLongNumber()) != null) {
                rowInfo.out = (Integer)outMaps.get(unitInfo.getLongNumber());
            }
            if (inMaps.get(unitInfo.getLongNumber()) != null) {
                rowInfo.in = (Integer)inMaps.get(unitInfo.getLongNumber());
            }
            if (dimissionMaps.get(unitInfo.getLongNumber()) != null) {
                rowInfo.dimission = (Integer)dimissionMaps.get(unitInfo.getLongNumber());
            }
            if (refuseMaps.get(unitInfo.getLongNumber()) != null) {
                rowInfo.refuse = (Integer)refuseMaps.get(unitInfo.getLongNumber());
            }
            if (retireMaps.get(unitInfo.getLongNumber()) != null) {
                rowInfo.retire = (Integer)retireMaps.get(unitInfo.getLongNumber());
            }
            rowInfo.scale = Integer.toString(rowInfo.inPerson) + ":" + Integer.toString(rowInfo.dimission + rowInfo.refuse + rowInfo.retire);
            list.add(rowInfo);
        }
        return list;
    }

    private void collectOrgData(Context ctx, HashMap map, IRowSet rows) throws BOSException, EASBizException {
        ArrayList<String> keyList = new ArrayList<String>();
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            keyList.add(iter.next().toString());
        }
        try {
            rows.beforeFirst();
            while (rows.next()) {
                if (keyList.contains(rows.getString("FLongNumber"))) continue;
                keyList.add(rows.getString("FLongNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        for (int i = 0; i < keyList.size(); ++i) {
            if (map.get(keyList.get(i).toString()) != null) continue;
            map.put(keyList.get(i).toString(), 0);
        }
        Collections.sort(keyList);
        Object iter2 = null;
        Object key = null;
        Object key2 = null;
        int sum = 0;
        int size = keyList.size();
        for (int i = 0; i < size; ++i) {
            key = keyList.get(i);
            sum = Integer.parseInt(map.get(key).toString());
            for (int j = i + 1; j < size && keyList.get(j).toString().indexOf(key + "!") > -1; ++j) {
                if (!map.containsKey(keyList.get(j))) continue;
                sum += Integer.parseInt(map.get(keyList.get(j)).toString());
            }
            map.put(key, sum);
        }
    }

    private void buildAdminNode(AdminOrgUnitCollection col, DefaultKingdeeTreeNode root) {
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)root.getUserObject();
        if (adminInfo != null) {
            adminInfo.setLevel(root.getLevel());
            adminInfo.setIsLeaf(root.isLeaf());
            col.add(adminInfo);
        }
        int size = root.getChildCount();
        for (int i = 0; i < size; ++i) {
            this.buildAdminNode(col, (DefaultKingdeeTreeNode)root.getChildAt(i));
        }
    }

    private IRowSet getInPersonCount(Context ctx, String whereStr, String startDate, String endDate, String tempTable) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT T2.FLongNumber FItem, COUNT(1) numCount FROM T_HR_AffairHistory T1 ");
        sql.append(" INNER JOIN T_ORG_Admin T2 ON T1.FNewDeptID = T2.FID ");
        sql.append(whereStr);
        this.appendDateWhere(sql, startDate, endDate);
        sql.append(" AND T1.FAffairType=");
        sql.append(0);
        if (tempTable != null) {
            this.addTempTableFilter(tempTable, sql);
        }
        sql.append(" GROUP BY T2.FLongNumber ");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private IRowSet getOutCount(Context ctx, String whereStr, String startDate, String endDate, String tempTable) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT T2.FLongNumber FItem, COUNT(1) numCount FROM T_HR_AffairHistory T1 ");
        sql.append(" INNER JOIN T_ORG_Admin T2 ON T1.FOldDeptID = T2.FID ");
        sql.append(whereStr);
        this.appendDateWhere(sql, startDate, endDate);
        sql.append(" AND T1.FAffairType=");
        sql.append(2);
        sql.append(" AND (T1.FOldInOutType=");
        sql.append(0);
        sql.append(" OR T1.FOldInOutType=");
        sql.append(-1);
        sql.append(") ");
        if (tempTable != null) {
            this.addTempTableFilter(tempTable, sql);
        }
        sql.append(" GROUP BY T2.FLongNumber ");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private IRowSet getINCount(Context ctx, String whereStr, String startDate, String endDate, String tempTable) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT T2.FLongNumber FItem, COUNT(1) numCount FROM T_HR_AffairHistory T1 ");
        sql.append(" INNER JOIN T_ORG_Admin T2 ON T1.FNewDeptID = T2.FID ");
        sql.append(whereStr);
        this.appendDateWhere(sql, startDate, endDate);
        sql.append(" AND T1.FAffairType=");
        sql.append(2);
        sql.append(" AND (T1.FNewInOutType=");
        sql.append(0);
        sql.append(" OR T1.FNewInOutType=");
        sql.append(1);
        sql.append(") ");
        if (tempTable != null) {
            this.addTempTableFilter(tempTable, sql);
        }
        sql.append(" GROUP BY T2.FLongNumber ");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private IRowSet getDimissionCount(Context ctx, String whereStr, String startDate, String endDate, String tempTable) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT T2.FLongNumber FItem, COUNT(1) numCount FROM T_HR_AffairHistory T1 ");
        sql.append(" INNER JOIN T_ORG_Admin T2 ON T1.FOldDeptID = T2.FID ");
        sql.append(whereStr);
        this.appendDateWhere(sql, startDate, endDate);
        sql.append(" AND T1.FAffairType=");
        sql.append(3);
        if (tempTable != null) {
            this.addTempTableFilter(tempTable, sql);
        }
        sql.append(" GROUP BY T2.FLongNumber ");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private IRowSet getRefuseCount(Context ctx, String whereStr, String startDate, String endDate, String tempTable) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT T2.FLongNumber FItem, COUNT(1) numCount FROM T_HR_AffairHistory T1 ");
        sql.append(" INNER JOIN T_ORG_Admin T2 ON T1.FOldDeptID = T2.FID ");
        sql.append(whereStr);
        this.appendDateWhere(sql, startDate, endDate);
        sql.append(" AND T1.FAffairType=");
        sql.append(4);
        if (tempTable != null) {
            this.addTempTableFilter(tempTable, sql);
        }
        sql.append(" GROUP BY T2.FLongNumber ");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private IRowSet getRetireCount(Context ctx, String whereStr, String startDate, String endDate, String tempTable) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT T2.FLongNumber FItem, COUNT(1) numCount FROM T_HR_AffairHistory T1 ");
        sql.append(" INNER JOIN T_ORG_Admin T2 ON T1.FOldDeptID = T2.FID ");
        sql.append(whereStr);
        this.appendDateWhere(sql, startDate, endDate);
        sql.append(" AND T1.FAffairType=");
        sql.append(5);
        if (tempTable != null) {
            this.addTempTableFilter(tempTable, sql);
        }
        sql.append(" GROUP BY T2.FLongNumber ");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private HashMap getPersonCountByRowSet(IRowSet rows) throws BOSException, EASBizException {
        if (rows == null) {
            return new HashMap();
        }
        int size = rows.size();
        HashMap<String, String> maps = null;
        maps = size > 0 ? new HashMap(size) : new HashMap<String, String>();
        try {
            while (rows.next()) {
                maps.put(rows.getString("FItem"), rows.getString("numCount"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return maps;
    }

    private void appendDateWhere(StringBuffer sql, String startDate, String endDate) {
        sql.append(" AND (T1.FEffectDate >= {ts'");
        sql.append(startDate);
        sql.append("'} AND T1.FEffectDate<= {ts'");
        sql.append(endDate);
        sql.append("'}) ");
    }

    private String getFixedDataStr(Date date) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        return sf.format(date);
    }

    private DefaultKingdeeTreeNode getRootNew(Context ctx, String hrOrgUnitID, boolean useOrgRangeFilter) throws Exception {
        String firstLongNumber;
        IHROrgUnit ihro = HROrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitCollection aouc = ihro.getAdminOrgUnitCollectionWithOrgRangeFilter(hrOrgUnitID);
        if (!useOrgRangeFilter) {
            aouc = ihro.getAdminOrgUnitCollection(hrOrgUnitID);
        }
        HashMap<String, DefaultKingdeeTreeNode> hm = new HashMap<String, DefaultKingdeeTreeNode>();
        AdminOrgUnitInfo aoui = null;
        if (AdminOrgUnitFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"))) {
            aoui = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
        }
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode(aoui);
        OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)root);
        if (aouc.size() == 0) {
            return null;
        }
        String rootLongNumber = firstLongNumber = aouc.get(0).getLongNumber();
        if (firstLongNumber.indexOf("!") != -1) {
            rootLongNumber = firstLongNumber.substring(0, firstLongNumber.indexOf("!"));
        }
        hm.put(rootLongNumber, root);
        String longNumber = "";
        String parLongNumber = "";
        DefaultKingdeeTreeNode node = null;
        int n = aouc.size();
        for (int i = 0; i < n; ++i) {
            parLongNumber = longNumber = aouc.get(i).getLongNumber();
            while (!hm.containsKey(parLongNumber) && parLongNumber.lastIndexOf("!") != -1) {
                parLongNumber = parLongNumber.substring(0, parLongNumber.lastIndexOf("!"));
            }
            node = new DefaultKingdeeTreeNode((Object)aouc.get(i));
            hm.put(longNumber, node);
            if (parLongNumber.equals(longNumber)) {
                root = node;
                continue;
            }
            ((DefaultKingdeeTreeNode)hm.get(parLongNumber)).add((MutableTreeNode)node);
        }
        return root;
    }

    private String createEmpFlowTempTable(Context ctx, Map params) throws BOSException {
        String tempTable = null;
        Connection conn = null;
        PreparedStatement ps = null;
        Object sql = null;
        IMetaDataPK queryPK = (IMetaDataPK)params.get("QueryPK");
        EntityViewInfo evInfo = (EntityViewInfo)params.get("EntityViewInfo");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(evInfo);
        StringBuffer buf = new StringBuffer(" SELECT T.ID FROM (");
        String sqlQuery = queryExcu.getSQL();
        if (StringUtils.indexOfIgnoreCase((String)sqlQuery, (String)"ORDER BY") > 0) {
            sqlQuery = sqlQuery.substring(0, StringUtils.indexOfIgnoreCase((String)sqlQuery, (String)"ORDER BY"));
        }
        String tmpStr = sqlQuery.substring(sqlQuery.indexOf("FROM"), sqlQuery.length());
        String endSql = " SELECT \"PERSON\".FID \"ID\" " + tmpStr;
        buf.append(endSql);
        buf.append(") AS T ");
        String optSql = null;
        try {
            optSql = KSqlUtil.optimize((String)buf.toString());
        }
        catch (SqlTranslateException e1) {
            throw new BOSException((Throwable)e1);
        }
        buf = new StringBuffer(optSql);
        String createSql = "create table t_temp_tempempDyn(fid varchar(44) not null)";
        try {
            tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createSql);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        String insertSql = "insert into " + tempTable + " " + buf.toString();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(insertSql);
            ps.execute();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return tempTable;
    }

    private void addTempTableFilter(String tempTable, StringBuffer sql) throws BOSException, EASBizException {
        if (tempTable != null && tempTable.length() > 0) {
            sql.append(" AND T1.FPERSONID IN ( SELECT FID FROM ");
            sql.append(tempTable);
            sql.append(") ");
        }
    }
}

