/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.qing.data.util.DateUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryCollection;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryFactory;
import com.kingdee.eas.hr.base.AffairActioniOperateException;
import com.kingdee.eas.hr.base.ConstellationInfo;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFacadeFactory;
import com.kingdee.eas.hr.base.EmployeePageConstant;
import com.kingdee.eas.hr.base.HRAffairActionTransactionLogInfo;
import com.kingdee.eas.hr.base.HRBizData;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.HRBizDefineTypeEnum;
import com.kingdee.eas.hr.base.LogActionTypeEnum;
import com.kingdee.eas.hr.base.PropertyRelateSettingCollection;
import com.kingdee.eas.hr.base.PropertyRelateSettingFactory;
import com.kingdee.eas.hr.base.ZodiacInfo;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.base.app.his.HistoryVersionUtil;
import com.kingdee.eas.hr.base.app.util.EmpLaborRelationUtil;
import com.kingdee.eas.hr.base.check.SHRAffairActionCheckTool;
import com.kingdee.eas.hr.base.util.EmpEnrollUserPermHelper;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.util.SHRMathUtils;
import com.kingdee.eas.hr.contract.util.ContractUtils;
import com.kingdee.eas.hr.emp.CredentialsTypeInfo;
import com.kingdee.eas.hr.emp.EmpBatchException;
import com.kingdee.eas.hr.emp.EmpQuickAddNewInfoFactory;
import com.kingdee.eas.hr.emp.EmpQuickAddNewInfoInfo;
import com.kingdee.eas.hr.emp.IPersonOtherInfo;
import com.kingdee.eas.hr.emp.IPersonPhoto;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonBankRecordFactory;
import com.kingdee.eas.hr.emp.PersonBankRecordInfo;
import com.kingdee.eas.hr.emp.PersonChangeFactory;
import com.kingdee.eas.hr.emp.PersonChangeInfo;
import com.kingdee.eas.hr.emp.PersonOptFacadeFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoCollection;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.hr.emp.PersonPhotoInfo;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.app.AbstractEmpQuickAddNewInfoBatchFacadeControllerBean;
import com.kingdee.eas.hr.emp.app.EmpQuickAddNewInfoUtil;
import com.kingdee.eas.hr.emp.app.PersonOptBaseInfo;
import com.kingdee.eas.hr.emp.app.util.EmpPostRankUtil;
import com.kingdee.eas.hr.emp.app.util.RecEntryServiceUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpCheckCredentialsTypeUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpDoPersonCredentialsTypeUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptPersonContactMethodUtil;
import com.kingdee.eas.hr.org.HRAdminOrgException;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.org.util.OrgAdjLockManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.ml.util.MutilanUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class EmpQuickAddNewInfoBatchFacadeControllerBean
extends AbstractEmpQuickAddNewInfoBatchFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.EmpQuickAddNewInfoBatchFacadeControllerBean");
    private static final String TEMP_PERSONID = "tempId";
    String enrollAgain_ChangeNumber = "false";
    String enrollAgain_NotChangeNumber = "true";

    @Override
    protected IObjectPK _consecutiveEnroll(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String positionId;
        EmpQuickAddNewInfoInfo info = (EmpQuickAddNewInfoInfo)model;
        String string = positionId = info.getPosition().getId() != null ? info.getPosition().getId().toString() : null;
        if (!StringUtils.isEmpty((String)positionId)) {
            OrgAdjLockManager.checkIfOrgLocked((Context)ctx, null, (String)positionId);
        }
        if (info.getEFFDT() == null) {
            info.setEFFDT(info.getEnterDate());
        }
        if (info.getJoinGroupDate() == null) {
            info.setJoinGroupDate(info.getEnterDate());
        }
        HashMap objMap = this.preparePersonAddNewInfo(ctx, info);
        PersonInfo pInfo = null;
        if (info.getJoinGroupDate().after(new Date())) {
            Object[] params = new String[]{HRUtilExtend.getDateStringWithoutMininute((Date)new Date())};
            throw new HRAdminOrgException(HRAdminOrgException.ERROR_FUTURE_EFFDT, params);
        }
        if (this.isEnrollAgain(info)) {
            pInfo = this.PersonEnrollAgain(ctx, info);
            this.doWhthPersonOtherInfo(ctx, pInfo);
            objMap.remove(EmployeePageConstant.personEntity);
            objMap.remove(EmployeePageConstant.PersonPositionEntity);
            objMap.remove(EmployeePageConstant.empPosOrgEntity);
            objMap.remove(EmployeePageConstant.empLaborRelationEntity);
            objMap.remove(EmployeePageConstant.personOtherEntity);
        } else {
            PersonInfo personInfoOri;
            PersonOptBaseInfo baseInfo = new PersonOptBaseInfo();
            pInfo = (PersonInfo)objMap.get(EmployeePageConstant.personEntity);
            this.setPersonBaseInfo(pInfo, info);
            pInfo.setEFFDT(info.getJoinGroupDate());
            pInfo.setHrOrgUnit(info.getHrOrgUnit());
            HRAffairActionTransactionLogInfo logInfo = new HRAffairActionTransactionLogInfo();
            BOSUuid logPk = BOSUuid.create((BOSObjectType)logInfo.getBOSType());
            pInfo.put("entryid", (Object)logPk.toString());
            baseInfo.setPerson(pInfo);
            baseInfo.setFromInitialize(false);
            AdminOrgUnitInfo adminOrg = EmpQuickAddNewInfoUtil.getAdminInfoByPosition(ctx, info.getPosition());
            if (info.get("isOverrideImportPerson") != null && ((Boolean)info.get("isOverrideImportPerson")).booleanValue()) {
                personInfoOri = (PersonInfo)info.get("originalPersonInfo");
                pInfo.setNumber(personInfoOri.getNumber());
                info.setNumber(personInfoOri.getNumber());
            } else if (info.get("notNeedGenerateObjectNumber") == null) {
                if (info.get("true") != null) {
                    pInfo.put("true", (Object)"true");
                }
                HRUtilExtend.setPersonNumber((Context)ctx, (PersonInfo)pInfo, (AdminOrgUnitInfo)adminOrg);
                info.setNumber(pInfo.getNumber());
            }
            pInfo.put("notNeedGenerateObjectNumber", (Object)true);
            EmpQuickAddNewInfoUtil.setBirthdayAndSexOfPerson(ctx, info, adminOrg, pInfo);
            EmpQuickAddNewInfoUtil.checkEnrollPerson(ctx, info);
            EmpQuickAddNewInfoBatchFacadeControllerBean.isPersonInAffairProcess(ctx, info.getNumber());
            this.checkJobLevelGradeRange(ctx, info);
            this.doWithPersonPositionInfo(ctx, baseInfo, info, objMap, adminOrg);
            this.doWithPersonOtherInfo(baseInfo, info, objMap);
            baseInfo.setPersonPhoto((PersonPhotoInfo)objMap.get(EmployeePageConstant.personPhotoEntity));
            if (info.get("isOverrideImportPerson") != null && ((Boolean)info.get("isOverrideImportPerson")).booleanValue()) {
                personInfoOri = (PersonInfo)info.get("originalPersonInfo");
                pInfo.setId(personInfoOri.getId());
            }
            IObjectPK pk = PersonOptFacadeFactory.getLocalInstance(ctx).personAddNew(info.getJoinGroupDate(), baseInfo);
            pInfo.setId(BOSUuid.read((String)pk.toString()));
            objMap.remove(EmployeePageConstant.personEntity);
            objMap.remove(EmployeePageConstant.PersonPositionEntity);
            objMap.remove(EmployeePageConstant.empPosOrgEntity);
            objMap.remove(EmployeePageConstant.empLaborRelationEntity);
            objMap.remove(EmployeePageConstant.personOtherEntity);
            HRBizData bizData = EmpQuickAddNewInfoUtil.infosConvertToBizData(ctx, info, pInfo);
            bizData.setActionSource(LogActionTypeEnum.quickAddNew);
            bizData.setLogPK(logPk.toString());
            EmpPosOrgRelationFacadeFactory.getLocalInstance((Context)ctx).operateHRBizDefine(bizData);
        }
        this.doWithEmpLaborRelatioinFields(ctx, info, pInfo);
        this.operateOtherInfos(ctx, objMap, pInfo);
        this.doWithPersonPhoto(ctx, model, pInfo);
        try {
            this.doWithPersonContract(ctx, info, pInfo);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        HRUtilExtend.assableCell((CoreBaseInfo)info, (String)"telNum");
        this.checkAndSetCredentialsType(ctx, info, pInfo);
        return EmpQuickAddNewInfoFactory.getLocalInstance(ctx).addnew(info);
    }

    private void checkJobLevelGradeRange(Context ctx, EmpQuickAddNewInfoInfo info) throws EASBizException, BOSException {
        boolean isRelatePositionJobRange = HRParamUtil.isRelatePositionJobRange((Context)ctx);
        JobLevelInfo jobLevel = info.getJobLevel();
        JobGradeInfo jobGrade = info.getJobGrade();
        if (isRelatePositionJobRange) {
            PositionInfo posInfo = info.getPosition();
            if (posInfo == null || posInfo.getId() == null) {
                return;
            }
            EmpPostRankUtil.checkJobLevelGradeRangeInPosition(ctx, jobLevel, jobGrade, posInfo.getId().toString());
        } else {
            if (info.getHrOrgUnit() == null || info.getHrOrgUnit().getId() == null) {
                return;
            }
            String hrOrgId = info.getHrOrgUnit().getId().toString();
            EmpPostRankUtil.checkJobLevelGradeRangeInHrOrg(ctx, jobLevel, jobGrade, hrOrgId);
        }
    }

    @Override
    protected void _doWithPersonInfoOverride(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmpQuickAddNewInfoInfo info = (EmpQuickAddNewInfoInfo)model;
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PersonCollection personColl = iPerson.getPersonCollection("where number = '" + info.getNumber().toString() + "'");
        this.deletePersonInfo(ctx, personColl.get(0).getId().toString());
        info.put("isOverrideImportPerson", true);
        info.put("originalPersonInfo", personColl.get(0));
        this._consecutiveEnroll(ctx, (IObjectValue)info);
    }

    private void deletePersonInfo(Context ctx, String personId) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_PersonPosition where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_ORG_PositionMember where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_EmpInnerWorkExp where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_EmpOrgRelation where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_EmpLaborRelation where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_PersonLoan where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_FluctuationInOut where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from t_bd_person where fid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_EmpPostRank where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_PersonPositionHis where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_EmpLaborRelationHis where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_EmpFlowInOut where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_EmpPostExperienceHis where fpersonid='" + personId + "'"));
        DbUtil.execute((Context)ctx, (String)("delete from t_bd_personHis where FHistoryRelateID='" + personId + "'"));
    }

    private void doWithPersonPhoto(Context ctx, IObjectValue model, PersonInfo pInfo) throws BOSException, EASBizException {
        boolean isCardImg = false;
        if (model.get("photo") != null && !"".equals(model.get("photo")) && model.get("photo").toString().startsWith("data:image/jpg;base64,")) {
            try {
                String photoStr = model.get("photo").toString();
                photoStr = photoStr.replace("data:image/jpg;base64,", "");
                IPersonPhoto iPP = PersonPhotoFactory.getLocalInstance(ctx);
                byte[] bytes = Base64.decode((String)photoStr);
                if (bytes != null) {
                    for (int i = 0; i < bytes.length; ++i) {
                        if (bytes[i] >= 0) continue;
                        int n = i;
                        bytes[n] = (byte)(bytes[n] + 256);
                    }
                    PersonPhotoInfo pphoto = new PersonPhotoInfo();
                    pphoto.setPerson(pInfo);
                    pphoto.setImageDataSource(bytes);
                    pphoto.setImageData(this.reducePhoto(bytes));
                    pphoto.setSourceImageHeight(126);
                    pphoto.setSourceImageWidth(102);
                    String imgContentType = "image/jpg";
                    pphoto.setImageContentType(imgContentType);
                    iPP.addnew(pphoto);
                    isCardImg = true;
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (model.get(TEMP_PERSONID) != null && !"".equals(model.get(TEMP_PERSONID))) {
            String tempperid = model.get(TEMP_PERSONID).toString();
            IPersonPhoto personPhoto = PersonPhotoFactory.getLocalInstance(ctx);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)tempperid));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            CoreBaseCollection coll = personPhoto.getCollection(entityViewInfo);
            PersonPhotoInfo personPhotoInfo = null;
            if (coll.size() > 0) {
                personPhotoInfo = (PersonPhotoInfo)coll.get(0);
                if (isCardImg) {
                    personPhoto.delete((IObjectPK)new ObjectUuidPK(personPhotoInfo.getId()));
                    return;
                }
                PersonPhotoInfo addPhoto = new PersonPhotoInfo();
                addPhoto.setPerson(pInfo);
                addPhoto.setImageDataSource(personPhotoInfo.getImageDataSource());
                addPhoto.setImageData(personPhotoInfo.getImageData());
                addPhoto.setSourceImageHeight(personPhotoInfo.getSourceImageHeight());
                addPhoto.setSourceImageWidth(personPhotoInfo.getSourceImageWidth());
                addPhoto.setImageContentType(personPhotoInfo.getImageContentType());
                personPhoto.addnew(addPhoto);
                personPhoto.delete((IObjectPK)new ObjectUuidPK(personPhotoInfo.getId()));
            }
        }
    }

    private void doWithPersonPositionInfo(Context ctx, PersonOptBaseInfo baseInfo, EmpQuickAddNewInfoInfo info, HashMap<String, IObjectValue> objMap, AdminOrgUnitInfo adminOrg) throws BOSException, EASBizException {
        PersonPositionInfo ppInfo = (PersonPositionInfo)objMap.get(EmployeePageConstant.PersonPositionEntity);
        ppInfo.setPersonDep(adminOrg);
        if (info.getJoinGroupDate() == null) {
            info.setJoinGroupDate(info.getEnterDate());
        }
        ppInfo.setJoinGroupDate(info.getJoinGroupDate());
        ppInfo.setJoinGroupDateCur(info.getEnterDate());
        ppInfo.setCompany(HRUtilExtend.getCompany((Context)ctx, (AdminOrgUnitInfo)adminOrg));
        ppInfo.setJoinDate(info.getEnterDate());
        ppInfo.setPrimaryPosition(info.getPosition());
        ppInfo.setEFFDT(info.getEnterDate());
        ppInfo.setLEFFDT(HistoryUtil.getMaxDate());
        ppInfo.setStartDateTime(ppInfo.getEFFDT());
        ppInfo.setEndDateTime(HistoryVersionUtil.getMaxEndDate());
        ppInfo.setVersion(1);
        ppInfo.setIsLatestInAday(true);
        baseInfo.setPersonPosition(ppInfo);
    }

    private void doWithEmpLaborRelatioinFields(Context ctx, EmpQuickAddNewInfoInfo info, PersonInfo personInfo) throws EASBizException, BOSException {
        EmpLaborRelationInfo.EnrollInfo enrollInfo = new EmpLaborRelationInfo.EnrollInfo();
        enrollInfo.setEnrollAgain(this.isEnrollAgain(info));
        enrollInfo.setEnrollDate(info.getEnterDate());
        enrollInfo.setPlanFormalDate(info.getPlanFormalDate());
        enrollInfo.setTryoutMonth(info.getProbation());
        EmpLaborRelationUtil.doWithEnrollEmpLaborRelatioinFields((Context)ctx, (EmpLaborRelationInfo.EnrollInfo)enrollInfo, (String)personInfo.getId().toString());
    }

    private void doWithPersonOtherInfo(PersonOptBaseInfo baseInfo, EmpQuickAddNewInfoInfo addNewInfo, HashMap<String, IObjectValue> objMap) {
        PersonOtherInfoInfo personOtherInfo = null;
        personOtherInfo = (PersonOtherInfoInfo)objMap.get(EmployeePageConstant.personOtherEntity);
        if (personOtherInfo == null) {
            personOtherInfo = new PersonOtherInfoInfo();
        }
        PersonInfo personInfo = baseInfo.getPerson();
        if (personOtherInfo != null) {
            Enumeration e = personOtherInfo.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.equals("id") || key.equals("person") || key.equals(HistoryConstant.EFFDT)) continue;
                personInfo.put(key, personOtherInfo.get(key));
            }
        }
        baseInfo.setPerson(personInfo);
    }

    private PersonInfo PersonEnrollAgain(Context ctx, EmpQuickAddNewInfoInfo info) throws BOSException, EASBizException, AffairActioniOperateException {
        PersonInfo personInfo = new PersonInfo();
        personInfo.setIdCardNO(info.getIdCardNO());
        personInfo.setPassportNO(info.getPassportNO());
        PersonInfo pInfo = SHRAffairActionCheckTool.getPersonInfoByIdCardNo((Context)ctx, (PersonInfo)personInfo);
        HRAffairActionTransactionLogInfo logInfo = new HRAffairActionTransactionLogInfo();
        BOSUuid logPk = BOSUuid.create((BOSObjectType)logInfo.getBOSType());
        pInfo.put("entryid", (Object)logPk.toString());
        String oldNumber = pInfo.getNumber();
        EmpPosOrgRelationQueryHelper queryHelper = new EmpPosOrgRelationQueryHelper();
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        EmpPosOrgRelationCollection relaColl = queryHelper.getAppointDateActivePrimaryPosition(ctx, pInfo.getId().toString(), curDate);
        if (relaColl.size() > 0) {
            int i;
            PersonChangeInfo changeInfo = new PersonChangeInfo();
            String actionId = info.getActionDef().getId().toString();
            HRBizDefineInfo action = HRBizDefineFactory.getLocalInstance((Context)ctx).getHRBizDefineInfo((IObjectPK)new ObjectUuidPK(actionId));
            if (!HRBizDefineTypeEnum.ENROLLAGAIN.equals((Object)action.getBizDefineType())) {
                throw new EmpBatchException(EmpBatchException.NOT_ENROLLAGAIN_ACTION);
            }
            changeInfo.setActionDef(action);
            changeInfo.setPerson(pInfo);
            changeInfo.setOldAdmin(relaColl.get(0).getAdminOrg());
            changeInfo.setOldPosition(relaColl.get(0).getPosition());
            changeInfo.setOldLaborRelState(relaColl.get(0).getLaborRelation().getLaborRelationState());
            changeInfo.setNewPosition(info.getPosition());
            if (info.getAdminOrg() == null) {
                changeInfo.setNewAdmin(EmpQuickAddNewInfoUtil.getAdminInfoByPosition(ctx, info.getPosition()));
            } else {
                changeInfo.setNewAdmin(info.getAdminOrg());
            }
            changeInfo.setNewLaborRelState(info.getLaborRelationState());
            changeInfo.setEFFDT(info.getEFFDT());
            changeInfo.setActionType(info.getActionType());
            changeInfo.setActionReason(info.getActionReason());
            changeInfo.put("jobGrade", info.getJobGrade());
            changeInfo.put("jobLevel", info.getJobLevel());
            PersonChangeFactory.getLocalInstance(ctx).save(changeInfo);
            String useOldNumber = (String)info.get("useOldNumber");
            String oql = "select * where person.id='" + pInfo.getId() + "'";
            IPersonPosition iPersonPosition = PersonPositionFactory.getLocalInstance(ctx);
            PersonPositionInfo posInfo = iPersonPosition.getPersonPositionInfo(oql);
            posInfo.setIsEnrollAgain(true);
            posInfo.setEFFDT(info.getEFFDT());
            posInfo.setTryoutMonth(info.getProbation());
            if (info.getJobGrade() != null) {
                posInfo.setJobGrade(info.getJobGrade());
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("isEnrollAgain"));
            selector.add(new SelectorItemInfo("EFFDT"));
            selector.add(new SelectorItemInfo("tryoutMonth"));
            if (info.getProbation() > 0 && info.getEFFDT() != null) {
                posInfo.setFormalDate(DateTimeUtils.addMonth((Date)info.getEFFDT(), (int)info.getProbation()));
                selector.add(new SelectorItemInfo("formalDate"));
            } else {
                posInfo.setFormalDate(null);
                selector.add(new SelectorItemInfo("formalDate"));
            }
            String sql = "select * where relateEntity ='com.kingdee.eas.hr.emp.app.PersonPosition'";
            PropertyRelateSettingCollection proRelSetColl = PropertyRelateSettingFactory.getLocalInstance((Context)ctx).getPropertyRelateSettingCollection(sql);
            for (i = 0; i < proRelSetColl.size(); ++i) {
                if (!info.containsKey(proRelSetColl.get(i).getNumber()) || info.get(proRelSetColl.get(i).getNumber()) == null) continue;
                posInfo.put(proRelSetColl.get(i).getRelatePropertyName(), info.get(proRelSetColl.get(i).getNumber()));
                selector.add(new SelectorItemInfo(proRelSetColl.get(i).getRelatePropertyName()));
            }
            iPersonPosition.updatePartial(posInfo, selector);
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("EFFDT"));
            selector.add(new SelectorItemInfo("employeeType"));
            selector.add(new SelectorItemInfo("idCardBeginDate"));
            selector.add(new SelectorItemInfo("idCardEndDate"));
            selector.add(new SelectorItemInfo("nativePlace"));
            selector.add(new SelectorItemInfo("idCardAddress"));
            selector.add(new SelectorItemInfo("idCardIssueOrg"));
            selector.add(new SelectorItemInfo("folk"));
            selector.add(new SelectorItemInfo("hireDate"));
            selector.add(new SelectorItemInfo("cell"));
            selector.add(new SelectorItemInfo("ncell"));
            selector.add(new SelectorItemInfo("globalRoaming"));
            selector.add(new SelectorItemInfo("email"));
            this.setPersonBaseInfo(pInfo, info);
            HRUtilExtend.assableCell((CoreBaseInfo)pInfo, (String)"cell");
            sql = "select * where relateEntity ='com.kingdee.eas.basedata.person.app.Person'";
            proRelSetColl = PropertyRelateSettingFactory.getLocalInstance((Context)ctx).getPropertyRelateSettingCollection(sql);
            for (i = 0; i < proRelSetColl.size(); ++i) {
                if (!info.containsKey(proRelSetColl.get(i).getNumber()) || info.get(proRelSetColl.get(i).getNumber()) == null) continue;
                pInfo.put(proRelSetColl.get(i).getRelatePropertyName(), info.get(proRelSetColl.get(i).getNumber()));
                selector.add(new SelectorItemInfo(proRelSetColl.get(i).getRelatePropertyName()));
            }
            pInfo.setEFFDT(info.getEFFDT());
            pInfo.setEmployeeType(info.getLaborRelationState());
            pInfo.setGender(info.getGender());
            if (this.enrollAgain_ChangeNumber.equals(useOldNumber)) {
                pInfo.setNumber(info.getNumber());
                BOSUuid personId = pInfo.getId();
                if (personId != null) {
                    pInfo.setId(null);
                }
                HRUtilExtend.setPersonNumber((Context)ctx, (PersonInfo)pInfo, (AdminOrgUnitInfo)posInfo.getPersonDep());
                pInfo.setId(personId);
                selector.add(new SelectorItemInfo("number"));
            } else if (this.enrollAgain_NotChangeNumber.equals(useOldNumber)) {
                pInfo.setNumber(oldNumber);
            }
        } else {
            throw new AffairActioniOperateException(AffairActioniOperateException.EMPPOSRELATIONERROR);
        }
        pInfo.put("IS_FROM_SHR_OPTAction", (Object)Boolean.TRUE);
        PersonFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(pInfo.getId().toString()), (CoreBaseInfo)pInfo);
        SHREmpOptPersonContactMethodUtil.doWithPersonContactMethod(ctx, pInfo);
        RecEntryServiceUtil.doWithResumeInfo(ctx, pInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        PositionInfo positionInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(info.getPosition().getId()), sic);
        EmpEnrollUserPermHelper.autoCallBackUser((Context)ctx, (PersonInfo)pInfo, (AdminOrgUnitInfo)positionInfo.getAdminOrgUnit());
        EmpEnrollUserPermHelper.updateUserNumber((Context)ctx, (PersonInfo)pInfo, (AdminOrgUnitInfo)positionInfo.getAdminOrgUnit());
        return pInfo;
    }

    private byte[] reducePhoto(byte[] imageData) throws IOException {
        int nwidth = 100;
        int nheight = 120;
        BufferedImage read = ImageIO.read(new ByteArrayInputStream(imageData));
        Image scaledInstance = read.getScaledInstance(nwidth, nheight, 4);
        BufferedImage tag = new BufferedImage(nwidth, nheight, 1);
        tag.getGraphics().drawImage(scaledInstance, 0, 0, null);
        tag.getGraphics().dispose();
        tag.flush();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)tag, "JPEG", output);
        byte[] byteArray = output.toByteArray();
        output.close();
        return byteArray;
    }

    public static void isPersonInAffairProcess(Context ctx, String number) throws BOSException, AffairActioniOperateException {
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        sic.add(new SelectorItemInfo("id"));
        filter.getFilterItems().add(new FilterItemInfo("empNumber", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)2));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)curDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)3));
        filter.setMaskString(" #0 and (#1 or #2 or #3 or (#4 and #5))");
        viewInfo.setSelector(sic);
        viewInfo.setFilter(filter);
        EmpEnrollBizBillEntryCollection col = EmpEnrollBizBillEntryFactory.getLocalInstance((Context)ctx).getEmpEnrollBizBillEntryCollection(viewInfo);
        if (col.size() > 0) {
            throw new AffairActioniOperateException(AffairActioniOperateException.ENROLLISEXISTS);
        }
    }

    private void operateOtherInfos(Context ctx, HashMap<String, IObjectValue> objMap, PersonInfo info) throws EASBizException, BOSException {
        Iterator<Map.Entry<String, IObjectValue>> it = objMap.entrySet().iterator();
        IMetaDataLoader metaDataloader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        while (it.hasNext()) {
            PersonBankRecordInfo personBankRecordInfo;
            Map.Entry<String, IObjectValue> entry = it.next();
            MetaDataPK entityPK = new MetaDataPK(entry.getKey());
            EntityObjectInfo entityInfo = metaDataloader.getEntity((IMetaDataPK)entityPK);
            ICoreBase iCoreBase = null;
            IObjectValue objValue = entry.getValue();
            objValue.put("person", (Object)info);
            this.setPersonBankRecordId(ctx, objValue);
            if (objValue instanceof PersonBankRecordInfo && (StringUtils.isEmpty((String)(personBankRecordInfo = (PersonBankRecordInfo)objValue).getAccountNum()) || personBankRecordInfo.getBank() == null)) continue;
            iCoreBase = (ICoreBase)BOSObjectFactory.getLocalBOSObjectFactory((Context)ctx).createCommonBOSObject((IMetaDataPK)entityPK);
            if (entityInfo.isDynamic() && entry.getValue() instanceof ICommonBOSType) {
                ICommonBOSType commonObject = (ICommonBOSType)entry.getValue();
                commonObject.setBOSType(entityInfo.getType());
                commonObject.setPK((IMetaDataPK)entityPK);
            }
            iCoreBase.submit((CoreBaseInfo)entry.getValue());
        }
    }

    private HashMap preparePersonAddNewInfo(Context ctx, EmpQuickAddNewInfoInfo info) throws BOSException, InvalidDAOMetaDataException {
        PropertyRelateSettingCollection proRelSetColl = PropertyRelateSettingFactory.getLocalInstance((Context)ctx).getPropertyRelateSettingCollection();
        HashMap<String, IObjectValue> objMap = new HashMap<String, IObjectValue>();
        TreeSet<String> set = new TreeSet<String>();
        for (int i = 0; i < proRelSetColl.size(); ++i) {
            IObjectValue objValue = (IObjectValue)objMap.get(proRelSetColl.get(i).getRelateEntity());
            if (objValue == null && info.containsKey(proRelSetColl.get(i).getNumber())) {
                objValue = this.createObjInfo(ctx, proRelSetColl.get(i).getRelateEntity());
                if (!(objValue instanceof PersonInfo)) {
                    objValue.put("person", null);
                }
                objValue.put(HistoryConstant.EFFDT, (Object)info.getEFFDT());
                objMap.put(proRelSetColl.get(i).getRelateEntity(), objValue);
            }
            if (!info.containsKey(proRelSetColl.get(i).getNumber()) || objValue == null) continue;
            objValue.put(proRelSetColl.get(i).getRelatePropertyName(), info.get(proRelSetColl.get(i).getNumber()));
            if (info.get(proRelSetColl.get(i).getNumber()) != null || proRelSetColl.get(i).getJudgeRelate() != 1) continue;
            set.add(proRelSetColl.get(i).getRelateEntity());
        }
        for (String deleteItem : set) {
            objMap.remove(deleteItem);
        }
        return objMap;
    }

    private IObjectValue createObjInfo(Context ctx, String relateEntity) throws InvalidDAOMetaDataException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return Utils.newObjectValueInstance((EntityObjectInfo)loader.getEntity((IMetaDataPK)new MetaDataPK(relateEntity)));
    }

    private void setPersonBaseInfo(PersonInfo personInfo, EmpQuickAddNewInfoInfo info) {
        if (info.getLaborRelationState() != null) {
            personInfo.setEmployeeType(info.getLaborRelationState());
        }
        personInfo.setEFFDT(info.getEFFDT());
        if (info.getIdCardStartDate() != null) {
            personInfo.setIdCardBeginDate(info.getIdCardStartDate());
        }
        if (info.getIdCardEndDate() != null) {
            personInfo.setIdCardEndDate(info.getIdCardEndDate());
        }
        if (info.getNativePlace() != null) {
            MutilanUtils.setMultiFieldValueBeanToBean((IObjectValue)info, (String)"nativePlace", (IObjectValue)personInfo, (String)"nativePlace");
        }
        if (info.getIdCardAddress() != null) {
            personInfo.setIdCardAddress(info.getIdCardAddress());
        }
        if (!StringUtils.isEmpty((String)info.getGlobalRoaming()) && !StringUtils.isEmpty((String)info.getNCell())) {
            personInfo.setGlobalRoaming(info.getGlobalRoaming().trim());
            personInfo.setNCell(info.getNCell().trim());
        }
        if (info.getTelNum() != null) {
            personInfo.setCell(info.getTelNum());
        }
        if (info.getIdCardIssued() != null) {
            personInfo.setIdCardIssueOrg(info.getIdCardIssued());
        }
        if (info.getIdCardIssued() != null) {
            personInfo.setIdCardIssueOrg(info.getIdCardIssued());
        }
        if (info.getEmail() != null) {
            personInfo.setEmail(info.getEmail());
        }
        if (null != info.getName()) {
            if (!StringUtil.isEmpty((String)info.getName(LocaleUtils.locale_l1))) {
                personInfo.setName(info.getName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            }
            if (!StringUtil.isEmpty((String)info.getName(LocaleUtils.locale_l2))) {
                personInfo.setName(info.getName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            }
            if (!StringUtil.isEmpty((String)info.getName(LocaleUtils.locale_l3))) {
                personInfo.setName(info.getName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            }
        }
        if (info.getLastName() != null) {
            if (!StringUtil.isEmpty((String)info.getLastName(LocaleUtils.locale_l1))) {
                personInfo.setLastName(info.getLastName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            }
            if (!StringUtil.isEmpty((String)info.getLastName(LocaleUtils.locale_l2))) {
                personInfo.setLastName(info.getLastName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            }
            if (!StringUtil.isEmpty((String)info.getLastName(LocaleUtils.locale_l3))) {
                personInfo.setLastName(info.getLastName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            }
        }
        if (info.getFirstName() != null) {
            if (!StringUtil.isEmpty((String)info.getFirstName(LocaleUtils.locale_l1))) {
                personInfo.setFirstName(info.getFirstName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            }
            if (!StringUtil.isEmpty((String)info.getFirstName(LocaleUtils.locale_l2))) {
                personInfo.setFirstName(info.getFirstName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            }
            if (!StringUtil.isEmpty((String)info.getFirstName(LocaleUtils.locale_l3))) {
                personInfo.setFirstName(info.getFirstName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            }
        }
        if (info.getMiddleName() != null) {
            if (!StringUtil.isEmpty((String)info.getMiddleName(LocaleUtils.locale_l1))) {
                personInfo.setMiddleName(info.getMiddleName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            }
            if (!StringUtil.isEmpty((String)info.getMiddleName(LocaleUtils.locale_l2))) {
                personInfo.setMiddleName(info.getMiddleName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            }
            if (!StringUtil.isEmpty((String)info.getMiddleName(LocaleUtils.locale_l3))) {
                personInfo.setMiddleName(info.getMiddleName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            }
        }
        if (info.getDescription() != null) {
            if (!StringUtil.isEmpty((String)info.getDescription(LocaleUtils.locale_l1))) {
                personInfo.setDescription(info.getDescription(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            }
            if (!StringUtil.isEmpty((String)info.getDescription(LocaleUtils.locale_l2))) {
                personInfo.setDescription(info.getDescription(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            }
            if (!StringUtil.isEmpty((String)info.getDescription(LocaleUtils.locale_l3))) {
                personInfo.setDescription(info.getDescription(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            }
        }
        if (info.getEnterDate() != null) {
            personInfo.setHireDate(info.getEnterDate());
        }
        personInfo.setGender(info.getGender());
        this.setPersonOtherInfo(personInfo, info);
    }

    private void setPersonOtherInfo(PersonInfo personInfo, EmpQuickAddNewInfoInfo info) {
        if (info.get("idCardLongEffect") != null) {
            personInfo.setBoolean("idCardLongEffect", info.isIdCardLongEffect());
        }
        if (null != info.getConstellation()) {
            personInfo.setBOSUuid("constellation", info.getConstellation().getId());
        }
        if (null != info.getZodiac()) {
            personInfo.setBOSUuid("zodiac", info.getZodiac().getId());
        }
        if (null != info.getJobStartDate()) {
            personInfo.put("jobStartDate", (Object)info.getJobStartDate());
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void setPersonBankRecordId(Context ctx, IObjectValue objValue) throws BOSException, EASBizException {
        if (objValue instanceof PersonBankRecordInfo) {
            PersonBankRecordInfo personBankRecordInfo = (PersonBankRecordInfo)objValue;
            String oql = "where person = '" + personBankRecordInfo.getPerson().getId().toString() + "' and accountNum = '" + personBankRecordInfo.getAccountNum() + "'";
            if (PersonBankRecordFactory.getLocalInstance(ctx).exists(oql)) {
                PersonBankRecordInfo personBankInfo = PersonBankRecordFactory.getLocalInstance(ctx).getPersonBankRecordInfo("where person = '" + personBankRecordInfo.getPerson().getId().toString() + "' and accountNum = '" + personBankRecordInfo.getAccountNum() + "'");
                personBankRecordInfo.setId(personBankInfo.getId());
            }
        }
    }

    private boolean isEnrollAgain(EmpQuickAddNewInfoInfo info) {
        return info.get("EMPEnrollAgainInfo") != null;
    }

    protected void checkAndSetCredentialsType(Context ctx, EmpQuickAddNewInfoInfo entryInfo, PersonInfo pInfo) throws EASBizException, BOSException {
        if (!entryInfo.containsKey("credentialsType") && entryInfo.getCredentialsType() == null && !StringUtils.isEmpty((String)entryInfo.getPassportNO())) {
            CredentialsTypeInfo typeInfo = new CredentialsTypeInfo();
            typeInfo.setId(BOSUuid.read((String)"DKku/T51SlSsPipwUmJ8WVlu4mQ="));
            entryInfo.setCredentialsType(typeInfo);
        }
        SHREmpCheckCredentialsTypeUtil.checkCredentiaslTypeForEmp(ctx, (CoreBaseInfo)entryInfo, pInfo.getId().toString());
        SHREmpDoPersonCredentialsTypeUtil.setCredentialsTypeIntoPerson(ctx, pInfo, (CoreBaseInfo)entryInfo);
        SHREmpDoPersonCredentialsTypeUtil.setCredentialsTypeIntoPersonOtherInfo(ctx, pInfo, entryInfo);
    }

    private void doWhthPersonOtherInfo(Context ctx, PersonInfo info) throws BOSException, EASBizException {
        PersonOtherInfoInfo otherInfo = this.getPersonOtherInfoInfo(ctx, info);
        if (otherInfo == null) {
            otherInfo = new PersonOtherInfoInfo();
            otherInfo.setPerson(info);
            this.assemblePersonOtherInfo(ctx, info, otherInfo);
            PersonOtherInfoFactory.getLocalInstance(ctx).addnew(otherInfo);
        } else {
            this.assemblePersonOtherInfo(ctx, info, otherInfo);
            PersonOtherInfoFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(otherInfo.getId().toString()), otherInfo);
        }
    }

    private void assemblePersonOtherInfo(Context ctx, PersonInfo personInfo, PersonOtherInfoInfo otherInfo) throws EASBizException, BOSException {
        String entityName = "com.kingdee.eas.hr.emp.app.PersonOtherInfo";
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        PropertyCollection propColl = entityInfo.getPropertiesRuntime();
        int size = propColl.size();
        for (int i = 0; i < size; ++i) {
            String propName = propColl.get(i).getName();
            Enumeration e = personInfo.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!propName.equalsIgnoreCase(key) || this.isPersonOtherInfoExcludeField(key)) continue;
                if (propName.equalsIgnoreCase("zodiac") && personInfo.get("zodiac") != null) {
                    ZodiacInfo z = new ZodiacInfo();
                    if (personInfo.get("zodiac") instanceof ZodiacInfo) {
                        z = (ZodiacInfo)personInfo.get("zodiac");
                    } else {
                        z.setId(BOSUuid.read((String)personInfo.get("zodiac").toString()));
                    }
                    otherInfo.put(propColl.get(i).getName(), z);
                    continue;
                }
                if (propName.equalsIgnoreCase("constellation") && personInfo.get("constellation") != null) {
                    ConstellationInfo c = new ConstellationInfo();
                    if (personInfo.get("constellation") instanceof ConstellationInfo) {
                        c = (ConstellationInfo)personInfo.get("constellation");
                    } else {
                        c.setId(BOSUuid.read((String)personInfo.get("constellation").toString()));
                    }
                    otherInfo.put(propColl.get(i).getName(), c);
                    continue;
                }
                otherInfo.put(propColl.get(i).getName(), personInfo.get(propName));
            }
        }
        otherInfo.setPerson(personInfo);
        otherInfo.setEFFDT(personInfo.getEFFDT());
        if (otherInfo.getAge() == 0 && personInfo.getBirthday() != null) {
            this.calculateAge(personInfo, otherInfo);
        }
        if (otherInfo.getSocialServiceYears() == 0.0 && otherInfo.getJobStartDate() != null) {
            this.calculateSocialServiceYears(ctx, otherInfo);
        }
        if (personInfo.getBirthday() != null) {
            String[] birthDay = DateUtils.DateToString((Date)personInfo.getBirthday(), (String)"yyyy-MM-dd").split("-");
            otherInfo.setBornYear(Integer.valueOf(birthDay[0]));
            otherInfo.setBornMonth(Integer.valueOf(birthDay[1]));
            otherInfo.setBornDay(Integer.valueOf(birthDay[2]));
        } else {
            otherInfo.put("bornYear", null);
            otherInfo.put("bornMonth", null);
            otherInfo.put("bornDay", null);
        }
    }

    private void calculateAge(PersonInfo personInfo, PersonOtherInfoInfo otherInfo) {
        Date birthDate = personInfo.getBirthday();
        Date endDate = otherInfo.getDeathDate();
        if (endDate == null) {
            endDate = DateTimeUtils.truncateDate((Date)new Date());
        }
        int yearValue = DateTimeUtils.getYear((Date)endDate) - DateTimeUtils.getYear((Date)birthDate);
        int tempValue = 0;
        int birthMonth = DateTimeUtils.getMonth((Date)birthDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        int birthDay = DateTimeUtils.getDay((Date)birthDate);
        int endDay = DateTimeUtils.getDay((Date)endDate);
        tempValue = endMonth < birthMonth ? -1 : (endMonth > birthMonth ? 0 : (endDay < birthDay ? -1 : 0));
        otherInfo.setAge(yearValue + tempValue);
    }

    private void calculateSocialServiceYears(Context ctx, PersonOtherInfoInfo otherInfo) throws EASBizException, BOSException {
        int dayValue;
        int monthValue;
        int yearValue;
        double workTime;
        Date beginDate = otherInfo.getJobStartDate();
        Date endDate = otherInfo.getRetireDate();
        double adjustValue = otherInfo.getAdjustSerVal();
        if (endDate == null) {
            endDate = DateTimeUtils.truncateDate((Date)new Date());
        }
        if ((workTime = (double)(yearValue = DateTimeUtils.getYear((Date)endDate) - DateTimeUtils.getYear((Date)beginDate)) + (double)(monthValue = DateTimeUtils.getMonth((Date)endDate) - DateTimeUtils.getMonth((Date)beginDate)) / 12.0 + (double)((float)(dayValue = DateTimeUtils.getDay((Date)endDate) - DateTimeUtils.getDay((Date)beginDate)) / 365.0f) - adjustValue) < 0.0) {
            workTime = 0.0;
        }
        workTime = SHRMathUtils.getRoundValueBySysParam((Context)ctx, (double)workTime);
        otherInfo.setSocialServiceYears(workTime);
    }

    private boolean isPersonOtherInfoExcludeField(String key) {
        return key.equals("id") || key.equals("person") || key.equals("hasBURelation");
    }

    private PersonOtherInfoInfo getPersonOtherInfoInfo(Context ctx, PersonInfo info) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)info.getId().toString()));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.birthday"));
        selector.add(new SelectorItemInfo("age"));
        IPersonOtherInfo iPersonOtherInfo = PersonOtherInfoFactory.getLocalInstance(ctx);
        PersonOtherInfoCollection coll = iPersonOtherInfo.getPersonOtherInfoCollection(viewInfo);
        PersonOtherInfoInfo otherInfo = null;
        if (coll.size() > 0) {
            otherInfo = coll.get(0);
        }
        return otherInfo;
    }

    private void doWithPersonContract(Context ctx, EmpQuickAddNewInfoInfo model, PersonInfo pInfo) throws BOSException, EASBizException {
        if (this.isEnrollAgain(model) && pInfo.getId() != null) {
            ContractUtils.processPersonContractStateWithEnrollAgain((Context)ctx, (String)pInfo.getId().toString());
        }
    }
}

