/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryCollection;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryFactory;
import com.kingdee.eas.hr.base.AffairActioniOperateException;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.EmpLaborRelationHisInfo;
import com.kingdee.eas.hr.base.EmpPositionInfo;
import com.kingdee.eas.hr.base.HRBizData;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.PositionStatuEnum;
import com.kingdee.eas.hr.base.app.his.HistoryVersionUtil;
import com.kingdee.eas.hr.base.app.util.HRBizDefineAppUtils;
import com.kingdee.eas.hr.base.app.util.SHRSameDatePersonChangeUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.base.util.ShrIDCardNOPassportCheckUtil;
import com.kingdee.eas.hr.emp.EmpQuickAddNewInfoInfo;
import com.kingdee.eas.hr.emp.app.util.GetJobInfosUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptBizManageTool;
import com.kingdee.eas.hr.org.JobSequenceInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.util.Date;

public class EmpQuickAddNewInfoUtil {
    public static final String HRBIZDEFINE_INIT = "P/OSDCPfQXqU0TB/LQoA6uZovtk=";

    protected static HRBizData infosConvertToBizData(Context ctx, EmpQuickAddNewInfoInfo info, PersonInfo pInfo) throws EASBizException, BOSException {
        HRBizData bizData = new HRBizData();
        if (info.getActionDef() == null) {
            throw new AffairActioniOperateException(AffairActioniOperateException.HRBIZDEFINENOTNULL);
        }
        if (info.getEFFDT() == null) {
            throw new AffairActioniOperateException(AffairActioniOperateException.EFFECTDATEISNULL);
        }
        bizData.setPersonInfo(pInfo);
        if (info.getActionDef() != null) {
            HRBizDefineInfo hrbizDefineInfo = HRBizDefineAppUtils.getHRBizDefineInfo((Context)ctx, (String)info.getActionDef().getId().toString());
            bizData.setHrbizDefine(hrbizDefineInfo);
        }
        bizData.setActionReason(info.getActionReason());
        bizData.setActionType(info.getActionType());
        if (info.getId() != null) {
            bizData.setEntryID(info.getId().toString());
        }
        bizData.setStartDate(info.getEFFDT());
        EmpPositionInfo oldPositionInfo = new EmpPositionInfo();
        oldPositionInfo.setPersonInfo(pInfo);
        bizData.setOldPosition(oldPositionInfo);
        EmpPositionInfo newPositionInfo = new EmpPositionInfo();
        AdminOrgUnitInfo adminOrgUnitInfo = info.getAdminOrg();
        AdminOrgUnitInfo companyInfo = info.getCompany();
        if (adminOrgUnitInfo == null) {
            adminOrgUnitInfo = EmpQuickAddNewInfoUtil.getAdminInfoByPosition(ctx, info.getPosition());
        }
        if (adminOrgUnitInfo != null && companyInfo == null) {
            companyInfo = HRUtilExtend.getCompany((Context)ctx, (AdminOrgUnitInfo)adminOrgUnitInfo);
        }
        newPositionInfo.setCompany(companyInfo);
        newPositionInfo.setAdminInfo(adminOrgUnitInfo);
        newPositionInfo.setPositionInfo(info.getPosition());
        newPositionInfo.setPositionStateEnum(PositionStatuEnum.Active);
        newPositionInfo.setEmployeeType(info.getLaborRelationState());
        newPositionInfo.setPersonInfo(pInfo);
        EmpLaborRelationHisInfo empLaborRelationHisInfo = new EmpLaborRelationHisInfo();
        empLaborRelationHisInfo.setEmployerUnit(info.getEmployerUnit());
        newPositionInfo.setEmpLabrRelationHisInfo(empLaborRelationHisInfo);
        bizData.setNewPosition(newPositionInfo);
        bizData.setCompany(HRUtilExtend.getCompany((Context)ctx, (AdminOrgUnitInfo)adminOrgUnitInfo));
        bizData.setRemark(info.getDescription());
        JobInfo jobInfo = (JobInfo)GetJobInfosUtil.geJogFamilyInfo(ctx, info.getPosition()).get("jobInfo");
        JobSequenceInfo jobSequenceInfo = GetJobInfosUtil.getJobSequenceInfo(ctx, jobInfo, info.getJobGrade());
        bizData.setJobGradeInfo(info.getJobGrade());
        bizData.setJobLevelInfo(info.getJobLevel());
        bizData.setJobSequenceInfo(jobSequenceInfo);
        bizData.setHrOrgUnitInfo(SHREmpOptBizManageTool.getManageHROByAdminOrg(ctx, bizData.getNewPosition().getAdminInfo().getId().toString()));
        bizData.setUseDefault(true);
        if (HRBIZDEFINE_INIT.equals(info.getActionDef().getId().toString())) {
            bizData.setSameDatePersonChange(false);
            bizData.setStartDateTime(bizData.getStartDate());
            bizData.setPreEndDateTime(HistoryVersionUtil.getPreRecordEndDateTime((Date)bizData.getStartDate()));
        } else {
            SHRSameDatePersonChangeUtil util = new SHRSameDatePersonChangeUtil();
            String personId = pInfo.getId().toString();
            boolean isSameDatePersonChange = util.isSameDatePersonChange(ctx, personId, info.getEFFDT(), 1);
            if (isSameDatePersonChange) {
                bizData.setSameDatePersonChange(true);
                bizData.setStartDateTime(HistoryVersionUtil.getStartDateTimeFromEFFDT((Date)bizData.getStartDate()));
                bizData.setPreEndDateTime(HistoryVersionUtil.getPreRecordEndDateTime((Date)bizData.getStartDateTime()));
            } else {
                bizData.setSameDatePersonChange(false);
                bizData.setStartDateTime(bizData.getStartDate());
                bizData.setPreEndDateTime(HistoryVersionUtil.getPreRecordEndDateTime((Date)bizData.getStartDate()));
            }
        }
        return bizData;
    }

    protected static void setBirthdayAndSexOfPerson(Context ctx, EmpQuickAddNewInfoInfo info, AdminOrgUnitInfo adminOrg, PersonInfo pInfo) throws BOSException, EASBizException {
        String idCardNO = info.getIdCardNO();
        HROrgUnitInfo hrOrgUnit = info.getHrOrgUnit();
        String paramNum = "IS_IDCARD_VERIFY";
        if (!StringUtils.isEmpty((String)idCardNO)) {
            IDCardCommonUtil iDCardCommonUtil = null;
            boolean isIDCardVerify = false;
            if (hrOrgUnit != null) {
                isIDCardVerify = HRParamUtil.getParamOfHR((Context)ctx, (String)paramNum, (String)hrOrgUnit.getId().toString());
            }
            try {
                iDCardCommonUtil = new IDCardCommonUtil(idCardNO, isIDCardVerify);
                String birthday = "";
                Genders sex = null;
                if (isIDCardVerify) {
                    birthday = iDCardCommonUtil.getBirthday();
                    sex = iDCardCommonUtil.getGenders();
                }
                if (pInfo.getGender() == null) {
                    pInfo.setGender(sex);
                }
                if (pInfo.getBirthday() == null && !StringUtils.isEmpty((String)birthday)) {
                    pInfo.setBirthday(DateTimeUtils.parseDate((String)birthday));
                }
            }
            catch (BaseException e) {
                throw e;
            }
            catch (ParseException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected static AdminOrgUnitInfo getAdminInfoByPosition(Context ctx, PositionInfo position) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        PositionInfo pInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(position.getId().toString()), sic);
        return pInfo.getAdminOrgUnit();
    }

    protected static void checkEnrollPerson(Context ctx, EmpQuickAddNewInfoInfo info) throws BOSException, EASBizException {
        String idCardNo = info.getIdCardNO();
        if (!StringUtils.isEmpty((String)idCardNo)) {
            info.setIdCardNO(IDCardCommonUtil.upperIdCardNo((String)idCardNo));
        }
        String passportNo = info.getPassportNO();
        ShrIDCardNOPassportCheckUtil.checkIsIdCardNOPassportDuplicate((Context)ctx, (String)idCardNo, (String)passportNo, null, null, null, (boolean)true, null);
    }

    protected static void checkPersonInAffairProcess(Context ctx, String number) throws BOSException, AffairActioniOperateException {
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        sic.add(new SelectorItemInfo("id"));
        filter.getFilterItems().add(new FilterItemInfo("empNumber", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)2));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)curDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)3));
        filter.setMaskString(" #0 and (#1 or #2 or #3 or (#4 and #5))");
        viewInfo.setSelector(sic);
        viewInfo.setFilter(filter);
        EmpEnrollBizBillEntryCollection col = EmpEnrollBizBillEntryFactory.getLocalInstance((Context)ctx).getEmpEnrollBizBillEntryCollection(viewInfo);
        if (col.size() > 0) {
            throw new AffairActioniOperateException(AffairActioniOperateException.ENROLLISEXISTS);
        }
    }
}

