/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.EmployeeEntityPropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.EmpBatTreConEntryFactory;
import com.kingdee.eas.hr.emp.EmpEditPageSchemeException;
import com.kingdee.eas.hr.emp.EmployeeEditPageSchemeInfo;
import com.kingdee.eas.hr.emp.EmployeePageCollection;
import com.kingdee.eas.hr.emp.EmployeePageFactory;
import com.kingdee.eas.hr.emp.EmployeePageInfo;
import com.kingdee.eas.hr.emp.IEmployeePage;
import com.kingdee.eas.hr.emp.app.AbstractEmployeePageControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class EmployeePageControllerBean
extends AbstractEmployeePageControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.EmployeePageControllerBean");

    @Override
    protected void _importSingleLinePages(Context ctx, BOSUuid schemeId, ArrayList ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() == 0 || schemeId == null) {
            return;
        }
        StringBuffer sql = new StringBuffer("SELECT FUIName,FName_");
        sql.append(ctx.getLocale());
        sql.append(",FType FROM T_HR_EmployeeSystemPage WHERE FID IN(");
        int length = ids.size();
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append(ids.get(i));
        }
        sql.append(")");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            EmployeePageInfo info = null;
            IEmployeePage iEP = EmployeePageFactory.getLocalInstance(ctx);
            EmployeeEditPageSchemeInfo schemeInfo = null;
            StringBuffer oql = null;
            while (rows.next()) {
                info = new EmployeePageInfo();
                info.setUiName(rows.getString(1));
                if (info.getUiName().equals("com.kingdee.eas.hr.emp.client.EmployeeBaseInfoUI")) {
                    info.setBasePage(true);
                }
                info.setName(rows.getString(2));
                info.setType(rows.getBoolean(3));
                info.setSystemPage(true);
                schemeInfo = new EmployeeEditPageSchemeInfo();
                schemeInfo.setId(schemeId);
                info.setScheme(schemeInfo);
                oql = new StringBuffer("WHERE scheme='");
                oql.append(schemeId.toString());
                oql.append("' AND uiName='");
                oql.append(info.getUiName());
                oql.append("'");
                if (iEP.exists(oql.toString())) continue;
                iEP.addnew(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmployeePageInfo info = (EmployeePageInfo)model;
        if (info.get("Page_PropertyList") != null) {
            ArrayList propertyList = (ArrayList)info.get("Page_PropertyList");
            if (info.isType()) {
                info.setPageContent(this.convertListToXML(ctx, info, propertyList));
            } else {
                info.setPageContent(this.convertListToXML2(ctx, info, propertyList));
            }
        }
        return super._submit(ctx, (IObjectValue)info);
    }

    private String convertListToXML2(Context ctx, EmployeePageInfo info, ArrayList propertyList) throws BOSException, EASBizException {
        Document doc = new Document();
        Element root = new Element("ui");
        doc.setRootElement(root);
        Element fieldList = new Element("fieldList");
        root.addContent((Content)fieldList);
        EmployeeEntityPropertyInfo epInfo = null;
        int size = propertyList.size();
        for (int i = 0; i < size; ++i) {
            epInfo = (EmployeeEntityPropertyInfo)propertyList.get(i);
            Element field = new Element("field");
            field.addContent((Content)new Element("name").setText(epInfo.getPropertyName()));
            field.addContent((Content)new Element("displayName").setText(epInfo.getPropertyAlias()));
            field.addContent((Content)new Element("isHide").setText(Boolean.toString(epInfo.isHide())));
            field.addContent((Content)new Element("width").setText(Integer.toString(epInfo.getPropertyLength())));
            field.addContent((Content)new Element("isSort").setText(Boolean.toString(epInfo.isSort())));
            fieldList.addContent((Content)field);
        }
        if (info.get("EditUI_Name") != null) {
            Element editUINameElement = new Element("editUIName");
            editUINameElement.addContent((Content)new Element("name").setText(info.get("EditUI_Name").toString()));
            root.addContent((Content)editUINameElement);
        }
        if (info.get("MainQuery_Name") != null) {
            Element mainQueryPKElement = new Element("mainQueryPK");
            mainQueryPKElement.addContent((Content)new Element("name").setText(info.get("MainQuery_Name").toString()));
            root.addContent((Content)mainQueryPKElement);
        }
        if (info.get("BOSType_Name") != null) {
            Element bosTypeElement = new Element("bosType");
            bosTypeElement.addContent((Content)new Element("name").setText(info.get("BOSType_Name").toString()));
            root.addContent((Content)bosTypeElement);
        }
        return null;
    }

    private String convertListToXML(Context ctx, EmployeePageInfo info, ArrayList propertyList) throws BOSException, EASBizException {
        Document doc = new Document();
        Element root = new Element("ui");
        doc.setRootElement(root);
        Element fieldList = new Element("fieldList");
        root.addContent((Content)fieldList);
        String sql = "SELECT FEntityName,FEntityInfoName,FType,FQueryInfo,FSelector FROM T_HR_F7Info";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
        EmployeeEntityPropertyInfo epInfo = null;
        EntityObjectInfo entityInfo = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        HashMap entityMap = new HashMap();
        int size = propertyList.size();
        for (int i = 0; i < size; ++i) {
            epInfo = (EmployeeEntityPropertyInfo)propertyList.get(i);
            Element field = new Element("field");
            field.addContent((Content)new Element("name").setText(epInfo.getPropertyName()));
            field.addContent((Content)new Element("displayName").setText(epInfo.getPropertyAlias()));
            field.addContent((Content)new Element("entityName").setText(epInfo.getEntityName()));
            field.addContent((Content)new Element("entityDisplayName").setText(epInfo.getEntityAlias()));
            field.addContent((Content)new Element("notNull").setText(Boolean.toString(epInfo.isNotNull())));
            field.addContent((Content)new Element("enable").setText(Boolean.toString(epInfo.isEnable())));
            if (epInfo.isSystemProperty()) {
                field.addContent((Content)new Element("systemProperty").setText(Boolean.toString(epInfo.isSystemProperty())));
            }
            Element dataType = new Element("dataType");
            field.addContent((Content)dataType);
            entityInfo = entityMap.get(epInfo.getEntityName()) == null ? loader.getEntity((IMetaDataPK)new MetaDataPK(epInfo.getEntityName())) : (EntityObjectInfo)entityMap.get(epInfo.getEntityName());
            PropertyInfo propertyInfo = entityInfo.getPropertyByName(epInfo.getPropertyName());
            if (propertyInfo instanceof OwnPropertyInfo) {
                dataType.addContent((Content)new Element("name").setText(((OwnPropertyInfo)propertyInfo).getDataType().getName()));
                if (((OwnPropertyInfo)propertyInfo).getDataType().equals((Object)DataType.STRING)) {
                    int stringLength = ((OwnPropertyInfo)propertyInfo).getMappingField().getLength();
                    dataType.addContent((Content)new Element("length").setText(Integer.toString(stringLength)));
                    if (((OwnPropertyInfo)propertyInfo).isMultilingual()) {
                        dataType.addContent((Content)new Element("isMultiLang").setText(String.valueOf(((OwnPropertyInfo)propertyInfo).isMultilingual())));
                    }
                } else if (((OwnPropertyInfo)propertyInfo).getDataType().equals((Object)DataType.ENUM)) {
                    dataType.addContent((Content)new Element("enumName").setText(((OwnPropertyInfo)propertyInfo).getEnumType().getFullName()));
                }
            }
            if (propertyInfo instanceof LinkPropertyInfo) {
                this.addF7Info(dataType, rows, ((LinkPropertyInfo)propertyInfo).getRelationship().getSupplierObject());
            }
            fieldList.addContent((Content)field);
        }
        if (info.get("DISPLAYTYPE") != null) {
            Element displayTypeElement = new Element("displayType");
            displayTypeElement.setText(((Boolean)info.get("DISPLAYTYPE")).toString());
            root.addContent((Content)displayTypeElement);
        }
        if (info.get("MultiLinePage_List") != null) {
            ArrayList pageList = (ArrayList)info.get("MultiLinePage_List");
            EmployeePageInfo pageInfo = null;
            Element pageListElement = new Element("pageList");
            root.addContent((Content)pageListElement);
            Element pageInfoElement = null;
            int size2 = pageList.size();
            for (int i = 0; i < size2; ++i) {
                pageInfo = (EmployeePageInfo)pageList.get(i);
                pageInfoElement = new Element("pageInfo");
                pageInfoElement.addContent((Content)new Element("id").setText(pageInfo.getId().toString()));
                pageInfoElement.addContent((Content)new Element("name").setText(pageInfo.getName()));
                pageInfoElement.addContent((Content)new Element("canAdd").setText(((Boolean)pageInfo.get("CANADD")).toString()));
                pageInfoElement.addContent((Content)new Element("canView").setText(((Boolean)pageInfo.get("CANVIEW")).toString()));
                pageInfoElement.addContent((Content)new Element("canEdit").setText(((Boolean)pageInfo.get("CANEDIT")).toString()));
                pageInfoElement.addContent((Content)new Element("canDelete").setText(((Boolean)pageInfo.get("CANDELETE")).toString()));
                pageInfoElement.addContent((Content)new Element("displayHeight").setText(((Integer)pageInfo.get("DISPLAYHEIGHT")).toString()));
                pageListElement.addContent((Content)pageInfoElement);
            }
        }
        return null;
    }

    private void addF7Info(Element dataType, IRowSet rows, EntityObjectInfo entityObjectInfo) throws BOSException, EASBizException {
        try {
            String defaultF7Query;
            rows.beforeFirst();
            boolean hasF7Info = false;
            String entityName = entityObjectInfo.getFullName();
            while (rows.next()) {
                if (!rows.getString("FEntityName").equals(entityName)) continue;
                if (rows.getInt("FType") == 0) {
                    dataType.addContent((Content)new Element("name").setText("CommonF7"));
                } else {
                    dataType.addContent((Content)new Element("name").setText("CustomF7"));
                    dataType.addContent((Content)new Element("selector").setText(rows.getString("FSelector")));
                }
                dataType.addContent((Content)new Element("queryInfo").setText(rows.getString("FQueryInfo")));
                dataType.addContent((Content)new Element("refEntity").setText(rows.getString("FEntityInfoName")));
                hasF7Info = true;
                break;
            }
            if (!hasF7Info && (defaultF7Query = entityObjectInfo.getExtendedProperty("defaultF7Query")) != null) {
                dataType.addContent((Content)new Element("name").setText("CommonF7"));
                dataType.addContent((Content)new Element("refEntity").setText(entityObjectInfo.getObjectValueClass()));
                dataType.addContent((Content)new Element("queryInfo").setText(defaultF7Query));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _updatePageGroup(Context ctx, ArrayList ids, String groupId) throws BOSException, EASBizException {
        if (ids == null || ids.size() == 0) {
            return;
        }
        StringBuffer sql = null;
        if (StringUtils.isEmpty((String)groupId)) {
            sql = new StringBuffer("SELECT FSchemeID FROM T_HR_EmployeePage ");
            sql.append("WHERE FID = '");
            sql.append(ids.get(0).toString());
            sql.append("'");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String schemeId = "";
            try {
                while (rows.next()) {
                    schemeId = rows.getString("FSchemeID");
                }
                sql = new StringBuffer("SELECT 1 FROM T_HR_EmployeePage ");
                sql.append("WHERE FIsBasePage = 1 AND FGroupID IS NOT NULL ");
                sql.append("AND FSchemeID = '");
                sql.append(schemeId);
                sql.append("'");
                sql.append(" AND FID NOT IN(");
                int size = ids.size() - 1;
                for (int i = 0; i < size; ++i) {
                    sql.append("'");
                    sql.append(ids.get(i));
                    sql.append("',");
                }
                sql.append("'");
                sql.append(ids.get(ids.size() - 1));
                sql.append("')");
                rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (!rows.next()) {
                    throw new EmpEditPageSchemeException(EmpEditPageSchemeException.FORBID_DEL_SYSTEMPAGE);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        sql = new StringBuffer("UPDATE T_HR_EmployeePage ");
        if (StringUtils.isEmpty((String)groupId)) {
            sql.append("SET FGroupID=NULL,FINDEX=0 ");
        } else {
            sql.append("SET FINDEX=1000,FGroupID='");
            sql.append(groupId);
            sql.append("'");
        }
        sql.append(" WHERE FID IN(");
        int size = ids.size() - 1;
        for (int i = 0; i < size; ++i) {
            sql.append("'");
            sql.append(ids.get(i));
            sql.append("',");
        }
        sql.append("'");
        sql.append(ids.get(ids.size() - 1));
        sql.append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EmployeePageInfo info = this.getEmployeePageInfo(ctx, pk);
        if (info.isBasePage()) {
            throw new EmpEditPageSchemeException(EmpEditPageSchemeException.FORBID_DEL_SYSTEMPAGE);
        }
        EmpBatTreConEntryFactory.getLocalInstance(ctx).delete("where empPage ='" + pk.toString() + "'");
        super._delete(ctx, pk);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        if (arrayPK == null) {
            return;
        }
        int size = arrayPK.length;
        for (int i = 0; i < size; ++i) {
            this._delete(ctx, arrayPK[i]);
        }
    }

    @Override
    protected void _updatePageIndex(Context ctx, String[] ids, int[] orders) throws BOSException, EASBizException {
        if (ids == null || orders == null) {
            return;
        }
        String sql = "UPDATE T_HR_EmployeePage SET FIndex=? WHERE FID=? ";
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql);
            for (int i = 0; i < ids.length; ++i) {
                pstmt.setInt(1, orders[i]);
                pstmt.setString(2, ids[i]);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)con);
    }

    @Override
    protected void _updateIsDynMutiPage(Context ctx, ArrayList pageList, EmployeePageInfo employeePageInfo) throws BOSException, EASBizException {
        if (pageList == null || pageList.size() <= 0 || employeePageInfo == null) {
            return;
        }
        int size = pageList.size();
        StringBuffer updateSql = new StringBuffer();
        int indexOf = 0;
        String groupId = null;
        if (employeePageInfo.getGroup() != null && employeePageInfo.getGroup().getId() != null) {
            groupId = employeePageInfo.getGroup().getId().toString();
        }
        indexOf = employeePageInfo.getIndexOf();
        for (int i = 0; i < size; ++i) {
            if (pageList.get(i) instanceof EmployeePageInfo) {
                if (i == 0) {
                    if (groupId != null) {
                        updateSql.append("update t_hr_employeepage set fisdynmutipage = 1 , fgroupid = '");
                        updateSql.append(groupId).append("' , findex = ");
                        updateSql.append(indexOf).append("  where fid in('");
                        updateSql.append(((EmployeePageInfo)pageList.get(i)).getId().toString());
                        continue;
                    }
                    updateSql.append("update t_hr_employeepage set fisdynmutipage = 1 , findex =");
                    updateSql.append(indexOf).append(" where fid in('");
                    updateSql.append(((EmployeePageInfo)pageList.get(i)).getId().toString());
                    continue;
                }
                updateSql.append("','").append(((EmployeePageInfo)pageList.get(i)).getId().toString());
                continue;
            }
            if (!(pageList.get(i) instanceof String) && !(pageList.get(i) instanceof BOSUuid)) continue;
            if (i == 0) {
                updateSql.append("update t_hr_employeepage set fisdynmutipage = null,fgroupid =null,findex =1000 where fid in('");
                updateSql.append(pageList.get(i));
                continue;
            }
            updateSql.append("','").append(pageList.get(i));
        }
        updateSql.append("')");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    private ArrayList getMutiPageIdInDynPage(Context ctx, String schemeId, String id) throws Exception {
        StringBuffer oql = new StringBuffer("select id, number, pageContent where scheme.id ='");
        oql.append(schemeId).append("' and pageContent like '%<id>%' and id ='");
        oql.append(id).append("';");
        ArrayList<String> ids = new ArrayList<String>();
        IEmployeePage iEP = EmployeePageFactory.getLocalInstance(ctx);
        EmployeePageCollection empPageCol = iEP.getEmployeePageCollection(oql.toString());
        if (empPageCol != null && empPageCol.size() > 0) {
            int size = empPageCol.size();
            for (int i = 0; i < size; ++i) {
                SAXBuilder builder;
                Document document;
                Element root;
                Element pageInfo;
                if (empPageCol.get(i) == null && StringUtils.isEmpty((String)empPageCol.get(i).getPageContent()) || (pageInfo = (root = (document = (builder = new SAXBuilder()).build((Reader)new StringReader(empPageCol.get(i).getPageContent()))).getRootElement()).getChild("pageList")) == null || pageInfo.getChildren() == null) continue;
                Element field = null;
                int childSize = pageInfo.getChildren().size();
                for (int j = 0; j < childSize; ++j) {
                    field = (Element)pageInfo.getChildren().get(j);
                    String pageId = field.getChildText("id");
                    if (pageId == null || ids.contains(pageId)) continue;
                    ids.add(pageId);
                }
            }
        }
        return ids;
    }

    @Override
    protected void _updatePageIndex(Context ctx, String[] ids, int[] orders, EmployeeEditPageSchemeInfo pageSchemeInfo) throws BOSException {
        if (ids == null || orders == null) {
            return;
        }
        String sql = "UPDATE T_HR_EmployeePage SET FIndex=? WHERE FID=? ";
        String updateSql = "update t_hr_employeepage set findex = ? where fid = ?";
        Connection con = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt2 = null;
        try {
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql);
            pstmt2 = con.prepareStatement(updateSql);
            for (int i = 0; i < ids.length; ++i) {
                pstmt.setInt(1, orders[i]);
                pstmt.setString(2, ids[i]);
                pstmt.addBatch();
                try {
                    ArrayList idList = this.getMutiPageIdInDynPage(ctx, pageSchemeInfo.getId().toString(), ids[i]);
                    if (idList == null || idList.size() <= 0) continue;
                    int listSize = idList.size();
                    for (int j = 0; j < listSize; ++j) {
                        pstmt2.setInt(1, orders[i]);
                        pstmt2.setString(2, (String)idList.get(j));
                        pstmt2.addBatch();
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            pstmt.executeBatch();
            pstmt2.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)con);
                SQLUtils.cleanup(pstmt2, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)con);
        SQLUtils.cleanup((Statement)pstmt2, (Connection)con);
    }

    @Override
    protected void _updateDynMutiPageSortCode(Context ctx, ArrayList ids, int[] orders) throws BOSException {
        String sql = "UPDATE T_HR_EMPLOYEEPAGE SET FDynMutiPageSortCode = ? WHERE FID = ?";
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql);
            int size = ids.size();
            for (int i = 0; i < size; ++i) {
                pstmt.setInt(1, orders[i]);
                pstmt.setString(2, (String)ids.get(i));
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)con);
    }
}

