/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.server.IQueryDataAccess;
import com.kingdee.bos.dao.query.server.QueryDataAccessFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.hr.affair.AffairUtilFacadeFactory;
import com.kingdee.eas.hr.affair.IAffairUtilFacade;
import com.kingdee.eas.hr.emp.EmployeeEditPageSchemeFactory;
import com.kingdee.eas.hr.emp.IEmployeeEditPageScheme;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.app.AbstractEmployeeTreeEditUIHandler;
import com.kingdee.eas.hr.org.OrgHRCommonFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;

public class EmployeeTreeEditUIHandler
extends AbstractEmployeeTreeEditUIHandler {
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        this.getPersonalWorkbenchScheme(context);
        this.getCurrentClientName(context);
        this.executeQuery(context);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)context);
        String personId = this.getPrimaryPosition(context, userInfo);
        this.getPersonPositionCollectionAndAdminOrgHRO(context, personId);
    }

    private String getPrimaryPosition(Context context, UserInfo userInfo) throws BOSException, EASBizException {
        String personId = null;
        if (null != userInfo && null != userInfo.getPerson()) {
            personId = userInfo.getPerson().getId().toString();
            PersonFactory.getLocalInstance((Context)context).getPrimaryPosition(BOSUuid.read((String)personId));
        }
        return personId;
    }

    private void getPersonPositionCollectionAndAdminOrgHRO(Context context, String personId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)personId)) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
            viewInfo.setFilter(filter);
            SelectorItemCollection selector = viewInfo.getSelector();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("personDep.id"));
            PersonPositionCollection ppCol = PersonPositionFactory.getLocalInstance(context).getPersonPositionCollection(viewInfo);
            if (ppCol != null && ppCol.size() > 0 && ppCol.get(0).getPersonDep() != null) {
                String personDep = ppCol.get(0).getPersonDep().getId().toString();
                OrgHRCommonFactory.getLocalInstance((Context)context).getAdminOrgHRO(personDep);
            }
        }
    }

    private void getPersonalWorkbenchScheme(Context context) throws BOSException, EASBizException {
        IEmployeeEditPageScheme iEEPS = EmployeeEditPageSchemeFactory.getLocalInstance(context);
        iEEPS.getPersonalWorkbenchScheme();
    }

    private void getCurrentClientName(Context context) throws BOSException, EASBizException {
        IAffairUtilFacade iAffairUtilFacade = AffairUtilFacadeFactory.getLocalInstance((Context)context);
        iAffairUtilFacade.getCurrentClientName();
    }

    private void executeQuery(Context context) throws BOSException {
        IQueryDataAccess qda = QueryDataAccessFactory.getLocalInstance((Context)context);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        String empId = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)context);
        if (null != userInfo && null != userInfo.getPerson()) {
            empId = userInfo.getPerson().getId().toString();
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)empId));
            viewInfo.setFilter(fi);
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.person.app.PersonAndPrimaryPositionQuery");
            qda.getRowSet((IMetaDataPK)queryPK, viewInfo, new HashMap(), new QueryExecuteOption(), 0, Integer.MAX_VALUE);
        }
    }
}

