/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.util.PersonChangeConvertToBizBillUtil;
import com.kingdee.eas.hr.base.AffairActioniOperateException;
import com.kingdee.eas.hr.base.AssignTypeEnum;
import com.kingdee.eas.hr.base.EmpHRORelationHisInfo;
import com.kingdee.eas.hr.base.EmpLaborRelationHisInfo;
import com.kingdee.eas.hr.base.EmpOptBURelaConfigInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFacadeFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmpPositionInfo;
import com.kingdee.eas.hr.base.HRBizData;
import com.kingdee.eas.hr.base.HRBizDefineCheckUtil;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.HRBizDefineTypeEnum;
import com.kingdee.eas.hr.base.LogActionTypeEnum;
import com.kingdee.eas.hr.base.PositionStatuEnum;
import com.kingdee.eas.hr.base.app.his.HistoryVersionUtil;
import com.kingdee.eas.hr.base.app.util.EmpOptBURelaConfigHelper;
import com.kingdee.eas.hr.base.app.util.HRBizDefineAppUtils;
import com.kingdee.eas.hr.base.app.util.SHREmpHRORelationHisUtil;
import com.kingdee.eas.hr.base.app.util.SHRSameDatePersonChangeUtil;
import com.kingdee.eas.hr.base.util.CheckEmployeeTypeOperatorUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.EmployeeBizException;
import com.kingdee.eas.hr.emp.PersonChangeInfo;
import com.kingdee.eas.hr.emp.app.AbstractPersonChangeControllerBean;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptBizManageTool;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptEmpLaborRelationUtil;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.org.util.OrgAdjLockManager;
import com.kingdee.shr.base.bizmanage.constant.CommonConstants;
import com.kingdee.util.StringUtils;
import java.util.Date;
import org.apache.log4j.Logger;

public class PersonChangeControllerBean
extends AbstractPersonChangeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.PersonChangeControllerBean");

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        return this._getValue(ctx, pk);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EmpPosOrgRelationInfo orgRelationInfo = EmpPosOrgRelationFacadeFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationValue(pk.toString());
        PersonChangeInfo changeInfo = new PersonChangeInfo();
        changeInfo.setOldPosition(orgRelationInfo.getPosition());
        changeInfo.setOldAdmin(orgRelationInfo.getAdminOrg());
        changeInfo.setOldLaborRelState(orgRelationInfo.getLaborRelation().getLaborRelationState());
        changeInfo.setPerson(orgRelationInfo.getPerson());
        changeInfo.setId(BOSUuid.create((BOSObjectType)changeInfo.getBOSType()));
        changeInfo.setEmpPosOrgRelation(orgRelationInfo);
        return changeInfo;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HRBizDefineTypeEnum bizTypeEnum;
        String personId;
        EmpLaborRelationHisInfo hisInfo;
        HROrgUnitInfo hrOrgUnit;
        PersonChangeInfo changeInfo = (PersonChangeInfo)model;
        super._save(ctx, model);
        this.checkValid(ctx, changeInfo);
        HRBizData bizData = new HRBizData();
        bizData.setPersonInfo(changeInfo.getPerson());
        String logPk = changeInfo.getPerson().getString("entryid");
        if (!StringUtils.isEmpty((String)logPk)) {
            bizData.setLogPK(logPk);
        }
        if ((hrOrgUnit = changeInfo.getHrOrgUnit()) == null) {
            EmpHRORelationHisInfo empHRORelationHisInfo = SHREmpOptBizManageTool.getEmpHRORelationHisInfo(ctx, changeInfo.getPerson().getId().toString());
            if (empHRORelationHisInfo == null) {
                throw new EmployeeBizException(EmployeeBizException.EXIST_PERSON_NO_HRORGUNIT, new Object[]{changeInfo.getPerson().getNumber()});
            }
            hrOrgUnit = empHRORelationHisInfo.getHrOrgUnit();
        }
        bizData.setOldHrOrgUnitInfo(SHREmpOptBizManageTool.getEmpHRORelationHisInfo(ctx, changeInfo.getPerson().getId().toString()).getHrOrgUnit());
        HRBizDefineInfo hrBizDefineInfo = HRBizDefineAppUtils.getHRBizDefineInfo((Context)ctx, (String)changeInfo.getActionDef().getId().toString());
        bizData.setHrbizDefine(hrBizDefineInfo);
        bizData.setActionType(changeInfo.getActionType());
        bizData.setActionReason(changeInfo.getActionReason());
        bizData.setStartDate(changeInfo.getEFFDT());
        EmpPositionInfo oldPositionInfo = new EmpPositionInfo();
        oldPositionInfo.setCompany(HRUtilExtend.getCompany((Context)ctx, (AdminOrgUnitInfo)changeInfo.getOldAdmin()));
        oldPositionInfo.setAdminInfo(changeInfo.getOldAdmin());
        oldPositionInfo.setPositionInfo(changeInfo.getOldPosition());
        oldPositionInfo.setPersonInfo(changeInfo.getPerson());
        oldPositionInfo.setEmployeeType(changeInfo.getOldLaborRelState());
        if (changeInfo.getOldLaborRelState() == null && changeInfo.getPerson() != null && changeInfo.getPerson().getId() != null && (hisInfo = SHREmpOptEmpLaborRelationUtil.getPointDateEmpLaborRelationHis(ctx, personId = changeInfo.getPerson().getId().toString(), changeInfo.getEFFDT())) != null) {
            oldPositionInfo.setEmployeeType(hisInfo.getLaborRelationState());
            oldPositionInfo.setEmpLabrRelationHisInfo(hisInfo);
        }
        bizData.setOldPosition(oldPositionInfo);
        EmpPositionInfo newPositionInfo = new EmpPositionInfo();
        newPositionInfo.setCompany(HRUtilExtend.getCompany((Context)ctx, (AdminOrgUnitInfo)changeInfo.getNewAdmin()));
        newPositionInfo.setAdminInfo(changeInfo.getNewAdmin());
        newPositionInfo.setPositionInfo(changeInfo.getNewPosition());
        newPositionInfo.setPositionStateEnum(PositionStatuEnum.Active);
        newPositionInfo.setPersonInfo(changeInfo.getPerson());
        newPositionInfo.setEmployeeType(changeInfo.getNewLaborRelState());
        EmpLaborRelationHisInfo empLarborRelationHisInfo = new EmpLaborRelationHisInfo();
        empLarborRelationHisInfo.setEmployerUnit(hrOrgUnit);
        newPositionInfo.setEmpLabrRelationHisInfo(empLarborRelationHisInfo);
        bizData.setNewPosition(newPositionInfo);
        bizData.setCompany(HRUtilExtend.getCompany((Context)ctx, (AdminOrgUnitInfo)changeInfo.getNewAdmin()));
        if (changeInfo.get("IsFromOrgAdjSchm") == "true") {
            bizData.setActionSource(LogActionTypeEnum.AdminAdjust);
        } else {
            bizData.setActionSource(LogActionTypeEnum.employeeModify);
        }
        bizData.setRemark(changeInfo.getRemark());
        if (changeInfo.getNewPosition() != null) {
            if (changeInfo.get("jobGrade") != null) {
                bizData.setJobGradeInfo((JobGradeInfo)changeInfo.get("jobGrade"));
            }
            if (changeInfo.get("jobLevel") != null) {
                bizData.setJobLevelInfo((JobLevelInfo)changeInfo.get("jobLevel"));
            }
        }
        if ((bizTypeEnum = changeInfo.getActionDef().getBizDefineType()) == HRBizDefineTypeEnum.EMPHIRE || bizTypeEnum == HRBizDefineTypeEnum.FLUCTUACTION || bizTypeEnum == HRBizDefineTypeEnum.RESIGN || bizTypeEnum == HRBizDefineTypeEnum.RETIRE || bizTypeEnum == HRBizDefineTypeEnum.REINVITE || bizTypeEnum == HRBizDefineTypeEnum.REINVITEFIRE) {
            if (model.get("INTE_OTHER") != null) {
                PersonChangeConvertToBizBillUtil.batchOperateEmployeeChange((Context)ctx, (IObjectValue)model);
            }
        } else {
            SHRSameDatePersonChangeUtil util;
            boolean isSameDatePersonChange;
            String personID = changeInfo.getPerson().getId().toString();
            Date effdt = changeInfo.getEFFDT();
            String targetEmpTypeId = "";
            String targetPositionId = "";
            String actionId = "";
            String targetOrgAdminId = "";
            if (newPositionInfo.getEmployeeType() != null) {
                targetEmpTypeId = newPositionInfo.getEmployeeType().getId().toString();
            }
            if (newPositionInfo.getPositionInfo() != null) {
                targetPositionId = newPositionInfo.getPositionInfo().getId().toString();
            }
            if (changeInfo.getActionDef() != null) {
                actionId = changeInfo.getActionDef().getId().toString();
            }
            if (newPositionInfo.getAdminInfo() != null) {
                targetOrgAdminId = newPositionInfo.getAdminInfo().getId().toString();
            }
            CheckEmployeeTypeOperatorUtil.checkPersonAfterDateModify((Context)ctx, (String)personID, (Date)effdt, (String)actionId, (String)targetEmpTypeId, (String)targetPositionId, (String)targetOrgAdminId);
            EmpOptBURelaConfigInfo configInfo = EmpOptBURelaConfigHelper.getInstance().getEmpOptBURelaConfigInfo(ctx, hrBizDefineInfo.getId().toString());
            if (configInfo != null) {
                if (0 == configInfo.getHrOrgType().getValue()) {
                    bizData.setHrOrgUnitInfo(hrOrgUnit);
                } else if (1 == configInfo.getHrOrgType().getValue()) {
                    bizData.setHrOrgUnitInfo(SHREmpOptBizManageTool.getManageHROByAdminOrg(ctx, bizData.getNewPosition().getAdminInfo().getId().toString()));
                }
                if (0 == configInfo.getUseDefaultType().getValue()) {
                    bizData.setUseDefault(false);
                } else if (1 == configInfo.getUseDefaultType().getValue()) {
                    bizData.setUseDefault(true);
                } else if (2 == configInfo.getUseDefaultType().getValue()) {
                    bizData.setUseDefault(true);
                }
            } else if (HRBizDefineCheckUtil.needTargetPosition((HRBizDefineInfo)hrBizDefineInfo)) {
                HROrgUnitInfo onWayHROrgUnitInfo = SHREmpHRORelationHisUtil.getOnWayHROrgUnitInfo((Context)ctx, (String)bizData.getNewPosition().getAdminInfo().getId().toString(), (String)CommonConstants.BIZMANAGETYPE_EMP01);
                if (null == onWayHROrgUnitInfo) {
                    bizData.setHrOrgUnitInfo(SHREmpOptBizManageTool.getManageHROByAdminOrg(ctx, bizData.getNewPosition().getAdminInfo().getId().toString()));
                } else {
                    bizData.setHrOrgUnitInfo(onWayHROrgUnitInfo);
                }
                bizData.setUseDefault(true);
            } else {
                bizData.setHrOrgUnitInfo(hrOrgUnit);
                bizData.setUseDefault(true);
            }
            boolean isMainAssign = true;
            if (changeInfo.getEmpPosOrgRelation() != null && changeInfo.getEmpPosOrgRelation().getAssignType() != null) {
                isMainAssign = 1 == changeInfo.getEmpPosOrgRelation().getAssignType().getValue();
            }
            String personId2 = changeInfo.getPerson().getId().toString();
            Date effetDate = changeInfo.getEFFDT();
            bizData.setSameDatePersonChange(false);
            bizData.setStartDateTime(bizData.getStartDate());
            bizData.setPreEndDateTime(HistoryVersionUtil.getPreRecordEndDateTime((Date)bizData.getStartDate()));
            if (("true".equals(changeInfo.get("IsFromOrgAdjSchm")) && isMainAssign || AssignTypeEnum.MAIN.equals((Object)hrBizDefineInfo.getAssignType())) && (isSameDatePersonChange = (util = new SHRSameDatePersonChangeUtil()).isSameDatePersonChange(ctx, personId2, effetDate, 1))) {
                bizData.setSameDatePersonChange(true);
                bizData.setStartDateTime(HistoryVersionUtil.getStartDateTimeFromEFFDT((Date)bizData.getStartDate()));
                bizData.setPreEndDateTime(HistoryVersionUtil.getPreRecordEndDateTime((Date)bizData.getStartDateTime()));
                String oql = "where person.id ='" + personId2 + "' and startDateTime> " + HRUtilExtend.getDateStringWithMinuteTs((Date)bizData.getStartDateTime()) + " and assignType = 1 and isinner =1  order by endDateTime desc";
                EmpPosOrgRelationCollection collection = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(oql);
                if (collection.size() > 0) {
                    EmpPosOrgRelationInfo maxInfo = collection.get(0);
                    Date maxStartDateTime = maxInfo.getStartDateTime();
                    bizData.setStartDateTime(HistoryVersionUtil.getStartDateTimeFromMax((Date)maxStartDateTime));
                    bizData.setPreEndDateTime(HistoryVersionUtil.getPreRecordEndDateTime((Date)bizData.getStartDateTime()));
                }
            }
            EmpPosOrgRelationFacadeFactory.getLocalInstance((Context)ctx).operateHRBizDefine(bizData);
        }
        return new ObjectUuidPK(BOSUuid.create((BOSObjectType)model.getBOSType()).toString());
    }

    private void checkValid(Context ctx, PersonChangeInfo changeInfo) throws EASBizException {
        if (changeInfo.getEFFDT() == null) {
            throw new AffairActioniOperateException(AffairActioniOperateException.EFFECTDATEISNULL);
        }
        if (changeInfo.getActionDef() == null) {
            throw new AffairActioniOperateException(AffairActioniOperateException.HRBIZDEFINENOTNULL);
        }
        if (changeInfo.get("IsFromOrgAdjSchm") != "true") {
            String oldAdminId = changeInfo.getOldAdmin() != null ? changeInfo.getOldAdmin().getId().toString() : null;
            String oldPositionId = changeInfo.getOldPosition() != null ? changeInfo.getOldPosition().getId().toString() : null;
            String newAdminId = changeInfo.getNewAdmin() != null ? changeInfo.getNewAdmin().getId().toString() : null;
            String newPositionId = changeInfo.getNewPosition() != null ? changeInfo.getNewPosition().getId().toString() : null;
            try {
                OrgAdjLockManager.checkIfOrgLocked((Context)ctx, (String)oldAdminId, (String)oldPositionId);
                OrgAdjLockManager.checkIfOrgLocked((Context)ctx, (String)newAdminId, (String)newPositionId);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this._save(ctx, model);
    }
}

