/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryFactory;
import com.kingdee.eas.hr.affair.IEmpEnrollBizBillEntry;
import com.kingdee.eas.hr.base.util.File2ObsUtils;
import com.kingdee.eas.hr.emp.EmpQuickAddNewInfoFactory;
import com.kingdee.eas.hr.emp.IEmpQuickAddNewInfo;
import com.kingdee.eas.hr.emp.IPersonContactMethod;
import com.kingdee.eas.hr.emp.PersonContactMethodFactory;
import com.kingdee.eas.hr.emp.app.AbstractPersonOthersControllerBean;
import com.kingdee.eas.hr.emp.app.util.PersonPhotoUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.preentry.IPEPersonContact;
import com.kingdee.shr.preentry.IPreEntry;
import com.kingdee.shr.preentry.PEPersonContactFactory;
import com.kingdee.shr.preentry.PreEntryFactory;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonOthersControllerBean
extends AbstractPersonOthersControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(PersonOthersControllerBean.class);
    private static int GLOBAL_NUM = 100;

    @Override
    protected void _doDeal(Context ctx) throws BOSException, EASBizException {
        logger.info("PersonOthersControllerBean start.....");
        PersonPhotoUtil.cleanPersonPhotoInDB(ctx);
        this.useOSB(ctx);
        this.cleanGojs(ctx);
        this.validRemarkLength(ctx);
        this.dowithReference(ctx);
        this.dowithPersoTel(ctx);
        this.clearEmpNumberTab(ctx, "T_HR_GetEmpNumTable", 5000);
        logger.info("PersonOthersControllerBean end......");
    }

    private void cleanGojs(Context ctx) throws BOSException {
        try {
            int doDelete = 0;
            String delectGoJSSql = "select count(*) count from t_hr_hrinit where fkey = 'IS_Delect_GoJS' and fvalue = 'true'";
            IRowSet delectGoJSRowSet = DbUtil.executeQuery((Context)ctx, (String)delectGoJSSql);
            while (delectGoJSRowSet.next()) {
                doDelete = delectGoJSRowSet.getInt("count");
            }
            if (doDelete > 0) {
                StringBuffer rootPathSb = new StringBuffer();
                rootPathSb.append(SHRSyssettingUtil.getShrWebWarPath());
                rootPathSb.append(File.separator).append("addon");
                rootPathSb.append(File.separator).append("orgchart");
                rootPathSb.append(File.separator).append("web");
                String rootPath = rootPathSb.toString();
                ArrayList<String> delectFileList = new ArrayList<String>();
                delectFileList.add(rootPath + File.separator + "tmp" + File.separator + "a.css");
                delectFileList.add(rootPath + File.separator + "tmp" + File.separator + "shrGojsdeploy.js");
                delectFileList.add(rootPath + File.separator + "webviews" + File.separator + "jslib" + File.separator + "GoJS" + File.separator + "go.js");
                delectFileList.add(rootPath + File.separator + "jslib" + File.separator + "js" + File.separator + "go.js");
                delectFileList.add(rootPath + File.separator + "jslib" + File.separator + "js" + File.separator + "go-debug.js");
                String fileName = null;
                int count = delectFileList.size();
                for (int i = 0; i < count; ++i) {
                    fileName = (String)delectFileList.get(i);
                    File file = new File(fileName);
                    if (!file.exists()) continue;
                    file.delete();
                }
                String initGoJSSql = "update t_hr_hrinit set fvalue = 'false' where fkey = 'IS_Delect_GoJS'";
                DbUtil.execute((Context)ctx, (String)initGoJSSql);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void useOSB(Context ctx) throws EASBizException, BOSException {
        boolean isUseOSB = File2ObsUtils.isUseOBS((Context)ctx);
        if (!isUseOSB) {
            try {
                int doPhoto = 0;
                String personPhotoSql = "select count(*) count from t_hr_hrinit where fkey = 'IS_Generate_PhotoFile' and fvalue = 'true'";
                IRowSet personPhotoRowSet = DbUtil.executeQuery((Context)ctx, (String)personPhotoSql);
                while (personPhotoRowSet.next()) {
                    doPhoto = personPhotoRowSet.getInt("count");
                }
                if (doPhoto > 0) {
                    PersonPhotoUtil.allPhoto2File(ctx);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void validRemarkLength(Context ctx) throws BOSException {
        String[] targetTables = new String[]{"T_HR_EMPFLOWINOUT", "T_HR_EmpOrgRelation"};
        String[] billTables = new String[]{"T_HR_EmpEnrollBizBillEntry", "T_HR_EmpHireBizBillEntry", "T_HR_FluctuationBizBillEntry", "T_HR_FlucOutBizBillEntry", "T_HR_FlucInBizBillEntry", "T_HR_LoanBizBillEntry", "T_HR_LoanOutBizBillEntry", "T_HR_LoanInBizBillEntry", "T_HR_LoanBackBizBillEntry", "T_HR_ResignBizBillEntry", "T_HR_RetireBizBillEntry", "T_HR_ReinviteBizBillEntry", "T_HR_ReinviteFireBizBillEntry", "T_HR_PluralityAddBizBillEntry", "T_HR_PluralityDelBizBillEntry", "T_HR_PluralityRBBE"};
        int maxLength = 0;
        int tempLength = 0;
        for (String billTable : billTables) {
            tempLength = this.getColLength(ctx, billTable, "FDescription");
            if (maxLength >= tempLength) continue;
            maxLength = tempLength;
        }
        for (String targetTable : targetTables) {
            tempLength = this.getColLength(ctx, targetTable, "FRemark");
            String columnType = this.getTableColumnType(ctx, targetTable, "FRemark");
            if (maxLength <= tempLength && (columnType == null || "NVARCHAR".equalsIgnoreCase(columnType) || "NVARCHAR2".equalsIgnoreCase(columnType))) continue;
            this.alterTableColumnLength(ctx, targetTable, "FRemark", maxLength);
        }
    }

    private String getTableColumnType(Context ctx, String tblName, String columnName) throws BOSException {
        String dataType = null;
        String sql = null;
        String dbType = (String)ctx.get((Object)"dbType");
        if ("Oracle".equals(dbType)) {
            sql = "SELECT COLUMN_NAME, DATA_TYPE, CHAR_LENGTH FROM USER_TAB_COLUMNS WHERE  (COLUMN_NAME='" + columnName + "' or COLUMN_NAME='" + columnName.toUpperCase() + "') and ( TABLE_NAME = '" + tblName + "' or TABLE_NAME = '" + tblName.toUpperCase() + "')";
        } else if ("MS SQL Server".equals(dbType)) {
            sql = "SELECT syscol.name,systype.name,syscol.prec,syscol.xprec,syscol.xscale FROM syscolumns syscol left join sysobjects sysobj on syscol.id = sysobj.id left join systypes systype on syscol.xtype=systype.xtype WHERE  systype.name!='sysname' and (SYSOBJ.NAME = '" + tblName + "' or SYSOBJ.NAME = '" + tblName.toUpperCase() + "' ) and ( syscol.name='" + columnName + "' or syscol.name='" + columnName.toUpperCase() + "')";
        }
        if (sql != null) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, sql);
            try {
                if (rs.next()) {
                    dataType = rs.getString(2);
                }
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        return dataType;
    }

    private int getColLength(Context ctx, String tbName, String colName) throws BOSException {
        int length = 0;
        String lengthCol = "length";
        String dbType = (String)ctx.get((Object)"dbType");
        StringBuffer sb = new StringBuffer();
        if ("Oracle".equalsIgnoreCase(dbType)) {
            sb.append("select DATA_LENGTH from KSQL_USERCOLUMNS where KSQL_COL_NAME ='").append(colName).append("' and KSQL_COL_TABNAME='").append(tbName).append("'");
            lengthCol = "DATA_LENGTH";
        } else {
            sb.append("select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='").append(colName).append("' and KSQL_COL_TABNAME='").append(tbName).append("'");
            lengthCol = "length";
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (rs.next()) {
                length = rs.getInt(lengthCol);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        return length;
    }

    private void alterTableColumnLength(Context ctx, String tbName, String colName, int maxLength) {
        StringBuffer sb = new StringBuffer("If exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='").append(colName).append("' and KSQL_COL_TABNAME='").append(tbName).append("')").append(" ALTER TABLE ").append(tbName).append(" ALTER COLUMN ").append(colName).append(" NVARCHAR(").append(maxLength).append(")");
        try {
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void dowithReference(Context ctx) throws BOSException {
        StringBuffer positionref = new StringBuffer();
        positionref.append("if not exists(SELECT * from t_sys_entityref where FBOSType = '74AE612E'  and FRefTableName='T_HR_EmpOrgRelation')").append("insert into t_sys_entityref(FBOSType, FRefTableName, FRefFieldName, FOrder, FIsBOSFK, FEntityName, FEntityAlias_L1, FEntityAlias_L2, FEntityAlias_L3, FRefEntityName, FRefEntityAlias_L1, FRefEntityAlias_L2, FRefEntityAlias_L3)").append("values").append("('74AE612E', 'T_HR_EmpOrgRelation', 'FPositionID', 1, 1, 'Position', 'Position', '\u804c\u4f4d', '\u8077\u4f4d', 'EmpPosOrgRelation', 'EmpPosOrgRelation', '\u5458\u5de5\u53d8\u52a8\u8bb0\u5f55', '\u54e1\u5de5\u8b8a\u52d5\u8a18\u9304');");
        DbUtil.execute((Context)ctx, (String)positionref.toString());
        StringBuffer personref = new StringBuffer();
        personref.append("if not exists(SELECT * from t_sys_entityref where FBOSType = '80EF7DED'  and FRefTableName='T_HR_EmpOrgRelation')").append("insert into t_sys_entityref(FBOSType, FRefTableName, FRefFieldName, FOrder, FIsBOSFK, FEntityName, FEntityAlias_L1, FEntityAlias_L2, FEntityAlias_L3, FRefEntityName, FRefEntityAlias_L1, FRefEntityAlias_L2, FRefEntityAlias_L3)").append("values").append("('80EF7DED', 'T_HR_EmpOrgRelation', 'FPersonID', 1, 1, 'Person', 'Person', '\u5458\u5de5_\u4e2a\u4eba\u4fe1\u606f', '\u54e1\u5de5_\u500b\u4eba\u4fe1\u606f', 'EmpPosOrgRelation', 'EmpPosOrgRelation', '\u5458\u5de5\u53d8\u52a8\u8bb0\u5f55', '\u54e1\u5de5\u8b8a\u52d5\u8a18\u9304');");
        DbUtil.execute((Context)ctx, (String)personref.toString());
    }

    private void dowithPersoTel(Context ctx) throws BOSException, EASBizException {
        IPersonContactMethod iPersonContactMethod = PersonContactMethodFactory.getLocalInstance(ctx);
        this.upgradeTel(ctx, (ICoreBase)iPersonContactMethod, "mobile", GLOBAL_NUM);
        IEmpEnrollBizBillEntry iEmpEnrollBizBillEntry = EmpEnrollBizBillEntryFactory.getLocalInstance((Context)ctx);
        this.upgradeTel(ctx, (ICoreBase)iEmpEnrollBizBillEntry, "telNum", GLOBAL_NUM);
        IEmpQuickAddNewInfo iEmpQuickAddNewInfo = EmpQuickAddNewInfoFactory.getLocalInstance(ctx);
        this.upgradeTel(ctx, (ICoreBase)iEmpQuickAddNewInfo, "telNum", GLOBAL_NUM);
        IPreEntry iPreEntry = PreEntryFactory.getLocalInstance((Context)ctx);
        this.upgradeTel(ctx, (ICoreBase)iPreEntry, "cellPhone", GLOBAL_NUM);
        IPEPersonContact iPEPersonContact = PEPersonContactFactory.getLocalInstance((Context)ctx);
        this.upgradeTel(ctx, (ICoreBase)iPEPersonContact, "mobile", GLOBAL_NUM);
    }

    private void upgradeTel(Context ctx, ICoreBase iCoreBase, String telField, int gLOBAL_NUM) throws BOSException, EASBizException {
        CoreBaseCollection pcmColl = null;
        do {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setTopCount(gLOBAL_NUM);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(telField, null, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("globalRoaming", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("nCell", null, CompareType.EQUALS));
            filter.setMaskString("#0 and (#1 or #2)");
            entityViewInfo.setFilter(filter);
            pcmColl = iCoreBase.getCollection(entityViewInfo);
            if (pcmColl == null || pcmColl.size() == 0) break;
            for (int i = 0; i < pcmColl.size(); ++i) {
                String mobile;
                CoreBaseInfo pcmInfo = pcmColl.get(i);
                String string = mobile = pcmInfo.get(telField) != null ? pcmInfo.get(telField).toString() : "";
                if (StringUtils.isEmpty((String)mobile)) continue;
                String[] t = mobile.split("-");
                if (t.length > 1) {
                    pcmInfo.put("globalRoaming", (Object)t[0]);
                    pcmInfo.put("nCell", (Object)t[1]);
                    continue;
                }
                pcmInfo.put("globalRoaming", (Object)"+86");
                pcmInfo.put("nCell", (Object)t[0]);
            }
            iCoreBase.saveBatchData(pcmColl);
        } while (pcmColl.size() >= gLOBAL_NUM);
    }

    private void clearEmpNumberTab(Context ctx, String tbName, int limit) {
        int total = 0;
        int clearRow = 0;
        String countSql = " SELECT count(*)  as total FROM " + tbName;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)countSql);
            if (rs.next()) {
                total = rs.getInt("total");
            }
            if (total > limit) {
                clearRow = total - limit;
                String clearDataSql = "DELETE FROM " + tbName + " WHERE fid in ( SELECT  top " + clearRow + " fid FROM " + tbName + " order by  FLASTUPDATETIME asc)";
                DbUtil.execute((Context)ctx, (String)clearDataSql);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error("Clear T_HR_GetEmpNumTable failed!", (Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error("Clear T_HR_GetEmpNumTable failed!", (Throwable)e);
        }
    }
}

