/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonWorkExpCollection;
import com.kingdee.eas.hr.emp.PersonWorkExpInfo;
import com.kingdee.eas.hr.emp.app.AbstractPersonWorkExpControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.HashSet;

public class PersonWorkExpControllerBean
extends AbstractPersonWorkExpControllerBean {
    @Override
    protected IObjectCollection _getRecordsByPerson(Context ctx, BOSUuid personId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return this.getPersonWorkExpCollection(ctx, evi);
    }

    private IObjectPK[] addAndUpdate(Context ctx, PersonWorkExpCollection workExpColl) throws EASBizException, BOSException {
        ArrayList<IObjectPK> idList = new ArrayList<IObjectPK>();
        for (int i = 0; i < workExpColl.size(); ++i) {
            if (workExpColl.get(i).getId() == null) {
                idList.add(this._addnew(ctx, (IObjectValue)workExpColl.get(i)));
                continue;
            }
            this._update(ctx, (IObjectPK)new ObjectUuidPK(workExpColl.get(i).getId()), (IObjectValue)workExpColl.get(i));
        }
        ObjectUuidPK[] newList = new ObjectUuidPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            newList[i] = (IObjectPK)idList.get(i);
        }
        return newList;
    }

    private void deleteList(Context ctx, IObjectPK[] deleteList) throws EASBizException, BOSException {
        if (deleteList == null || deleteList.length == 0) {
            return;
        }
        HashSet<IObjectPK> set = new HashSet<IObjectPK>();
        for (int i = 0; i < deleteList.length; ++i) {
            set.add(deleteList[i]);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        this._delete(ctx, filter);
    }

    @Override
    protected IObjectPK[] _saveAll(Context ctx, IObjectCollection records, IObjectPK[] deleteList) throws BOSException, EASBizException {
        this.deleteList(ctx, deleteList);
        return this.addAndUpdate(ctx, (PersonWorkExpCollection)records);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PersonWorkExpInfo info = (PersonWorkExpInfo)model;
        if (info.getHrOrgUnit() == null) {
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        if (null != info.getEndDate() && null != info.getBeginDate() && info.getEndDate().before(info.getBeginDate())) {
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_ENDDATEREAL);
        }
        if (info.get("FROM_IMPORT_SYSTEM") != null) {
            HRUtil.canUpdateEmployee((Context)ctx, (PersonInfo)info.getPerson());
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        this.updateJobFirstDate(ctx, info);
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PersonWorkExpInfo info = (PersonWorkExpInfo)model;
        if (info.get("FROM_IMPORT_SYSTEM") != null) {
            HRUtil.canUpdateEmployee((Context)ctx, (PersonInfo)info.getPerson());
        }
        if (null != info.getEndDate() && null != info.getBeginDate() && info.getEndDate().before(info.getBeginDate())) {
            throw new EmployeeException(EmployeeException.EFFECTDATE_NOT_DY_ENDDATEREAL);
        }
        super._update(ctx, pk, model);
        this.updateJobFirstDate(ctx, info);
    }

    private boolean isJobFirstDate(Context ctx) throws BOSException, EASBizException {
        boolean isFirst = false;
        String paramName = "IS_JOBDATE_FIRST";
        if (ContextUtil.getCurrentHRUnit((Context)ctx) != null) {
            BOSUuid orgId = ContextUtil.getCurrentHRUnit((Context)ctx).getId();
            IParamControl iParam = ParamControlFactory.getLocalInstance((Context)ctx);
            String val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(orgId), paramName);
            if (val != null && Boolean.TRUE.toString().equals(val)) {
                isFirst = true;
            }
        }
        return isFirst;
    }

    private void updateJobFirstDate(Context ctx, PersonWorkExpInfo info) throws BOSException, EASBizException {
        if (this.isJobFirstDate(ctx)) {
            PersonPositionFactory.getLocalInstance(ctx).updateJobFirstDate(info.getPerson().getId().toString());
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.number"));
        selector.add(new SelectorItemInfo("person.name"));
        PersonWorkExpInfo info = (PersonWorkExpInfo)this.getValue(ctx, pk, selector);
        return info.getPerson().getNumber() + info.getPerson().getName();
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PersonWorkExpInfo info = this.getPersonWorkExpInfo(ctx, pk);
        super._delete(ctx, pk);
    }
}

