/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.WSEmployeeCollection;
import com.kingdee.eas.hr.emp.WSEmployeeInfo;
import com.kingdee.eas.hr.emp.app.AbstractWSEmployeeControllerBean;
import com.kingdee.eas.hr.emp.app.EmployeeDataImport;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class WSEmployeeControllerBean
extends AbstractWSEmployeeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.WSEmployeeControllerBean");

    @Override
    protected void _importPersonInfo(Context ctx, IObjectValue wsEmpInfo) throws BOSException, EASBizException {
        WSEmployeeInfo info = (WSEmployeeInfo)wsEmpInfo;
        Hashtable hsData = this.convertInfoToImpData(info);
        EmployeeDataImport im = new EmployeeDataImport();
        PersonInfo pInfo = null;
        try {
            pInfo = (PersonInfo)im.transmit(hsData, ctx);
            im.submit((CoreBaseInfo)pInfo, ctx);
        }
        catch (TaskExternalException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _importPersonCollection(Context ctx, IObjectCollection wsEmpCollection) throws BOSException, EASBizException {
        WSEmployeeCollection coll = (WSEmployeeCollection)wsEmpCollection;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            this._importPersonInfo(ctx, (IObjectValue)coll.get(i));
        }
    }

    private Hashtable convertInfoToImpData(WSEmployeeInfo info) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        hash.put("FNumber", info.getNumber());
        hash.put("FName_L1", info.getName_L1());
        hash.put("FName_L2", info.getName_L2());
        hash.put("FName_L3", info.getName_L3());
        hash.put("FPositionID", info.getPositionNumber());
        hash.put("FIsPrimary", info.getIsPrimary());
        hash.put("FEmployeeTypeID", info.getEmployeeTypeNumber());
        hash.put("FEmployeeClassifyID", info.getEmployeeClassifyNumber());
        hash.put("FJobGrade", info.getJobGrade());
        hash.put("FWorkTime", info.getWorkTime());
        hash.put("FExtWorkTime", info.getExtWorkTime());
        hash.put("FLenOfActualService", info.getLenOfActualService());
        hash.put("FBirthday", info.getBirthday());
        hash.put("FINDate", info.getInDate());
        hash.put("FGender", info.getGender());
        hash.put("FPassportNO", info.getPassportNO());
        hash.put("FIDCardNO", info.getIDCardNO());
        hash.put("FDescription_L1", info.getDescription_L1());
        hash.put("FDescription_L2", info.getDescription_L2());
        hash.put("FDescription_L3", info.getDescription_L3());
        hash.put("FCreatorNumber", info.getCreatorNumber());
        hash.put("FCreateTime", info.getCreateTime());
        return hash;
    }

    @Override
    protected String _getAddressList(Context ctx, String name) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.person.app.PersonQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("name", (Object)(name + "%"), CompareType.LIKE));
        viewInfo.setFilter(fi);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        StringBuffer info = null;
        try {
            while (rows.next()) {
                if (info == null) {
                    info = new StringBuffer("");
                }
                info.append(rows.getString("name"));
                info.append("\n");
                if (rows.getString("email") != null) {
                    info.append(rows.getString("email"));
                    info.append("\n");
                }
                if (rows.getString("officePhone") != null) {
                    info.append(rows.getString("officePhone"));
                    info.append("\n");
                }
                if (rows.getString("cell") == null) continue;
                info.append(rows.getString("cell"));
                info.append("\n");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (info != null) {
            return info.toString();
        }
        return null;
    }

    @Override
    protected String _getAdminPositionByPerson(Context ctx, String name) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app.PrimaryAdminPositionOfPersonQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("person.name", (Object)(name + "%"), CompareType.LIKE));
        viewInfo.setFilter(fi);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        StringBuffer info = null;
        try {
            while (rows.next()) {
                if (info == null) {
                    info = new StringBuffer("");
                }
                info.append(rows.getString("person.name"));
                info.append("\n");
                if (rows.getString("primaryPosition.name") != null) {
                    info.append(rows.getString("primaryPosition.name"));
                    info.append("\n");
                }
                if (rows.getString("personDep.name") == null) continue;
                info.append(rows.getString("personDep.name"));
                info.append("\n");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (info != null) {
            return info.toString();
        }
        return null;
    }
}

