/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.impl.HistoryGeneratorParam;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.ShrSqlEnum;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.shr.baseconfig.StructureConfigCollection;
import com.kingdee.shr.baseconfig.StructureConfigFilterColumnInfo;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.baseconfig.service.api.impl.CommonSHRSqlBuilder;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EmpSHRSqlBuilder
extends CommonSHRSqlBuilder {
    public static final String EMPQUERY = "EMPQUERY";
    public static final String AFFAIRQUERY = "AFFAIRQUERY";
    public static final String CURRENTQUERY = "CURRENTQUERY";
    private static final String EMP_HRO_RELATION_ENTITY_METADATA = "com.kingdee.eas.hr.base.app.EmpHRORelationHis";
    private static final String EMP_ORG_RELATION_ENTITY_METADATA = "com.kingdee.eas.hr.base.app.EmpPosOrgRelation";
    private static final String ADMIN_ORG_FIELD = "adminOrgUnit";
    private static final String HR_ORG_FIELD = "hrOrg";
    private static final Logger logger = Logger.getLogger(EmpSHRSqlBuilder.class);
    private static StructureConfigCollection empConfigCollection = new StructureConfigCollection();
    private Map<String, String> adminMap = new HashMap<String, String>();
    private Map<String, String> hrMap = new HashMap<String, String>();
    private static final String[] EMP_NEED_ADD_STRUCTURECONFIG_NUMBERS = new String[]{"person", "empOrgRelation", "empHRORelationHis", "hrOrg", "adminOrgUnit"};
    private static final String[] EMP_NEED_ADD_STRUCTURECONFIG_ID = new String[]{"KPsvwyt9QNSH3ipDR/Hl9Dk1Eio=", "W81G3d1nSzqx8J0na6yNDDk1Eio=", "e74AAAByYUA5NRIq", "xNIAAAAPePU5NRIq", "KGRi+ChjQWea0lZH2gReNjk1Eio="};

    private void loadEmpConfigCollection() throws BOSException, EASBizException {
        boolean isNeedLoad = false;
        if (empConfigCollection.size() != EMP_NEED_ADD_STRUCTURECONFIG_NUMBERS.length) {
            isNeedLoad = true;
        }
        if (isNeedLoad) {
            empConfigCollection = new StructureConfigCollection();
            for (int index = 0; index < EMP_NEED_ADD_STRUCTURECONFIG_NUMBERS.length; ++index) {
                StructureConfigInfo structureConfigByKey = StructureConfigConvertHelper.getStructureConfigByKey((Context)this.ctx, (String)EMP_NEED_ADD_STRUCTURECONFIG_NUMBERS[index], (String)this.param.getScheme());
                if (structureConfigByKey == null) continue;
                empConfigCollection.add(structureConfigByKey);
            }
        }
    }

    protected FilterInfo privateDataSourceCustomFilter(String scheme, Map configParam, String effdtStr, Date effdt) throws EASBizException, BOSException {
        FilterInfo customFilter = null;
        String permItemId = (String)configParam.get("permItemId");
        if (scheme.equals("001")) {
            customFilter = this.getEffdtFilter(effdt);
        }
        return customFilter;
    }

    protected FilterInfo getEffdtFilter(Date effet) {
        if (effet == null) {
            effet = DateTimeUtils.truncateDate((Date)new Date());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.effdt", (Object)effet, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.leffdt", (Object)effet, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("pp.effdt", (Object)effet, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("pp.leffdt", (Object)effet, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("EMPORGRELATION.effdt", (Object)effet, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("EMPORGRELATION.leffdt", (Object)effet, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("empHRORelationHis.effdt", (Object)effet, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("empHRORelationHis.leffdt", (Object)effet, CompareType.GREATER_EQUALS));
        return filter;
    }

    public FilterInfo getEFFDTFilter(Date effet) {
        return this.getEffdtFilter(effet);
    }

    protected void recordOrgInfo(EntityObjectInfo clientEntity, StructureConfigInfo clientInfo, String clientField, String leftJoinField) {
        try {
            StructureConfigInfo parentConfigInfo;
            if ("com.kingdee.eas.basedata.org.app.AdminOrgUnit".equals(clientEntity.getFullName()) && "FID".equals(clientField) && EMP_ORG_RELATION_ENTITY_METADATA.equals((parentConfigInfo = StructureConfigConvertHelper.getStructureConfigByID((Context)this.ctx, (String)clientInfo.getParent().getId().toString(), (String)this.param.getScheme())).getEntityName())) {
                this.permissFields.put("admin", leftJoinField);
                this.adminMap.put("admin", leftJoinField);
            }
            if ("com.kingdee.eas.basedata.org.app.HROrgUnit".equals(clientEntity.getFullName()) && "FID".equals(clientField) && EMP_HRO_RELATION_ENTITY_METADATA.equals((parentConfigInfo = StructureConfigConvertHelper.getStructureConfigByID((Context)this.ctx, (String)clientInfo.getParent().getId().toString(), (String)this.param.getScheme())).getEntityName())) {
                this.permissFields.put("hr", leftJoinField);
                this.hrMap.put("hr", leftJoinField);
            }
            if (EMP_HRO_RELATION_ENTITY_METADATA.equals(clientEntity.getFullName())) {
                if (!this.hrMap.containsKey("hr")) {
                    this.permissFields.put("hr", "\"hrOrg\".FID");
                }
                if (!this.adminMap.containsKey("admin")) {
                    this.permissFields.put("admin", "\"adminOrgUnit\".FID");
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void recordArchivesInfo(EntityObjectInfo clientEntity, StructureConfigInfo configInfo) {
        super.recordArchivesInfo(clientEntity, configInfo);
    }

    protected void afterGetAllTableInfoForReport(StructureConfigCollection tableCollection) {
        super.afterGetAllTableInfoForReport(tableCollection);
        try {
            this.loadEmpConfigCollection();
            for (int index = 0; index < empConfigCollection.size(); ++index) {
                if (tableCollection.contains(empConfigCollection.get(index))) continue;
                tableCollection.add(empConfigCollection.get(index));
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected StringBuffer getFromOnSql(StructureConfigInfo configInfo, StructureConfigInfo relateInfo, Map<String, HistoryGeneratorParam> hisParamMap) throws EASBizException, BOSException {
        StringBuffer sql = super.getFromOnSql(configInfo, relateInfo, hisParamMap);
        if (this.param.isHistoryMode()) {
            if (this.param.getInfoCtr().containsKey(EMPQUERY) && "com.kingdee.eas.hr.emp.app.EmpPostRank".equals(configInfo.getEntityName()) && EMP_ORG_RELATION_ENTITY_METADATA.equals(relateInfo.getEntityName())) {
                this.hisModleHandlerDateFilter(configInfo, sql);
            }
            if (this.param.getInfoCtr().containsKey(AFFAIRQUERY) && ("com.kingdee.eas.basedata.org.app.AdminOrgUnit".equals(configInfo.getEntityName()) && EMP_ORG_RELATION_ENTITY_METADATA.equals(relateInfo.getEntityName()) || "com.kingdee.eas.basedata.org.app.Position".equals(configInfo.getEntityName()) && EMP_ORG_RELATION_ENTITY_METADATA.equals(relateInfo.getEntityName()) || "com.kingdee.eas.hr.emp.app.EmpPostRank".equals(configInfo.getEntityName()) && EMP_ORG_RELATION_ENTITY_METADATA.equals(relateInfo.getEntityName()) || "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equals(configInfo.getEntityName()) && "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equals(relateInfo.getEntityName()) || "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equals(configInfo.getEntityName()) && "com.kingdee.eas.hr.emp.app.EmpPostRank".equals(relateInfo.getEntityName()) || "com.kingdee.eas.hr.emp.app.PersonOtherInfo".equals(configInfo.getEntityName()) && "com.kingdee.eas.basedata.person.app.Person".equals(relateInfo.getEntityName()) || "com.kingdee.eas.hr.org.app.PositionExtend".equals(configInfo.getEntityName()) && "com.kingdee.eas.basedata.org.app.Position".equals(relateInfo.getEntityName()))) {
                String leftJoinTableNameAlias = this.getQuoTableAlias(configInfo);
                String rightJoinTableNameAlias = this.getQuoTableAlias(relateInfo);
                sql.append(" AND ");
                sql.append(leftJoinTableNameAlias).append(".FEFFDT <= ").append(rightJoinTableNameAlias).append(".FLEFFDT");
                sql.append(" AND ");
                sql.append(leftJoinTableNameAlias).append(".FLEFFDT >= ").append(rightJoinTableNameAlias).append(".FLEFFDT");
            }
        } else if (this.param.getInfoCtr().containsKey(CURRENTQUERY) && ("com.kingdee.eas.hr.emp.app.PersonPosition".equals(configInfo.getEntityName()) && EMP_ORG_RELATION_ENTITY_METADATA.equals(relateInfo.getEntityName()) || "com.kingdee.eas.hr.base.app.EmpLaborRelation".equals(configInfo.getEntityName()) && EMP_ORG_RELATION_ENTITY_METADATA.equals(relateInfo.getEntityName()))) {
            sql = this.removeDateTimeOnSQL(configInfo, relateInfo, hisParamMap);
        }
        return sql;
    }

    protected StringBuffer removeDateTimeOnSQL(StructureConfigInfo configInfo, StructureConfigInfo relateInfo, Map<String, HistoryGeneratorParam> hisParamMap) throws EASBizException, BOSException {
        String multi;
        StringBuffer sql = new StringBuffer();
        StructureConfigInfo clientInfo = configInfo;
        EntityObjectInfo clientEntity = this.getEntityObject(clientInfo.getEntityName());
        EntityObjectInfo parentEntity = this.getEntityObject(clientInfo.getParent().getEntityName());
        int total = clientInfo.getFilterColumn().size();
        for (int i = 0; i < total; ++i) {
            StructureConfigFilterColumnInfo contectedColumn = clientInfo.getFilterColumn().get(i);
            if ("startDateTime".equalsIgnoreCase(contectedColumn.getClientColumn()) || "endDateTime".equalsIgnoreCase(contectedColumn.getClientColumn())) continue;
            if (i > 0) {
                sql.append(" AND ");
            }
            String clientField = this.getRelationFieldTableColumn(clientEntity, contectedColumn.getClientColumn(), contectedColumn.getClientColumnAlias());
            StringBuffer client = new StringBuffer();
            this.appendAliasQueAndFiled(client, this.getTableAlias(clientInfo), clientField);
            String leftJoinField = this.getColumnHisotryName(this.historyReplayColumn, client.toString());
            sql.append(leftJoinField);
            if (contectedColumn.getCompareType() == null || contectedColumn.getCompareType().getValue() == null) {
                sql.append(" = ");
            } else {
                sql.append(contectedColumn.getCompareType().getValue());
            }
            if (contectedColumn.getParentColumn() != null) {
                String parentField = this.getQuoTableAlias(clientInfo.getParent()) + "." + this.getRelationFieldTableColumn(parentEntity, contectedColumn.getParentColumn(), contectedColumn.getParentColumnAlias());
                sql.append(this.getColumnHisotryName(this.historyReplayColumn, parentField.toUpperCase()));
                continue;
            }
            String fixValue = contectedColumn.getFixValue();
            if ("@baseDate".equalsIgnoreCase(fixValue)) {
                fixValue = this.getValueStringOnly(this.param.getFilterDate());
            }
            sql.append(fixValue);
        }
        if (this.param.getInfoCtr().containsKey(this.getTableAlias(clientInfo)) && "true".equals(multi = (String)this.param.getInfoCtr().get(this.getTableAlias(clientInfo))) && clientInfo.isMultiRow() && clientInfo.isSupportSingleView() && !StringUtils.isEmpty((String)clientInfo.getSingleCondition())) {
            this.addSingleCondition(clientInfo, sql);
        }
        return sql;
    }

    protected void handleSingleViewValue(StructureConfigInfo info) {
        Map infoCtrl;
        super.handleSingleViewValue(info);
        ShrSqlEnum currentQuerySource = this.param.getShrSqlEnum();
        if (currentQuerySource.equals((Object)ShrSqlEnum.REPORT)) {
            Map map = this.param.getInfoCtr();
        } else if ((this.param.getInfoCtr().containsKey(EMPQUERY) || this.param.getInfoCtr().containsKey(AFFAIRQUERY)) && (infoCtrl = this.param.getInfoCtr()).containsKey("EMPPOSTRANK")) {
            infoCtrl.remove("EMPPOSTRANK");
        }
    }

    protected void hisModleHandlerDateFilter(StructureConfigInfo clientInfo, StringBuffer sql) {
        if (this.param.getInfoCtr().containsKey(AFFAIRQUERY)) {
            return;
        }
        super.hisModleHandlerDateFilter(clientInfo, sql);
    }
}

