/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.ConstellationCollection;
import com.kingdee.eas.hr.base.ConstellationFactory;
import com.kingdee.eas.hr.base.ConstellationInfo;
import com.kingdee.eas.hr.base.ZodiacCollection;
import com.kingdee.eas.hr.base.ZodiacFactory;
import com.kingdee.eas.hr.base.ZodiacInfo;
import com.kingdee.eas.hr.emp.EmployeeBizException;
import com.kingdee.eas.hr.emp.app.util.SimpleCalendar;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class EMPhelper {
    private static final String YEAR = "1900";
    private static final String NUMBER_NAME_SPLIT = "##";

    public static String getEmpHROrgUnitID(Context ctx, String empId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FToUnitID FROM T_BD_Person ");
        sql.append("INNER JOIN T_ORG_PositionMember ");
        sql.append("ON (T_BD_Person.FID=T_ORG_PositionMember.FPersonID AND T_ORG_PositionMember.FIsPrimary=1) ");
        sql.append("INNER JOIN T_ORG_Position ON T_ORG_PositionMember.FPositionID=T_ORG_Position.FID ");
        sql.append("INNER JOIN T_ORG_Admin ON T_ORG_Position.FAdminOrgUnitID=T_ORG_Admin.FID ");
        sql.append("INNER JOIN T_ORG_UnitRelation  ");
        sql.append("ON (T_ORG_Admin.FID=T_ORG_UnitRelation.FFromUnitID ");
        sql.append("AND T_ORG_UnitRelation.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5') ");
        sql.append("WHERE T_BD_Person.FID = '");
        sql.append(empId);
        sql.append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                return rows.getString("FToUnitID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static String getPositionHROrgUnitID(Context ctx, String PrimaryPositonid) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FToUnitID FROM T_ORG_Position INNER JOIN T_ORG_Admin ON T_ORG_Position.FAdminOrgUnitID=T_ORG_Admin.FID INNER JOIN T_ORG_UnitRelation  ON (T_ORG_Admin.FID=T_ORG_UnitRelation.FFromUnitID AND T_ORG_UnitRelation.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5') WHERE  T_ORG_Position.FID = '");
        sql.append(PrimaryPositonid);
        sql.append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                return rows.getString("FToUnitID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static String getPrimaryPositionId(PositionMemberCollection pmColl) {
        for (int size = pmColl.size() - 1; size >= 0; --size) {
            PositionMemberInfo p = pmColl.get(size);
            if (!p.isIsPrimary()) continue;
            return p.getPosition().getId().toString();
        }
        return "";
    }

    public static <T> Map<String, String> getConZocByBirthDay(Context ctx, T birthDay) throws BOSException, ParseException, EmployeeBizException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (null == birthDay) {
            return resultMap;
        }
        String birthDayStr = null;
        if (birthDay instanceof String && !"".equals(birthDay)) {
            birthDayStr = (String)birthDay;
            Date birthDayDate = DateTimeUtils.parseDate((String)birthDayStr);
            birthDayStr = DateTimeUtils.format((Date)birthDayDate, (String)"yyyy-MM-dd");
        } else if (birthDay instanceof Date) {
            birthDayStr = DateTimeUtils.format((Date)((Date)birthDay), (String)"yyyy-MM-dd");
        }
        if (StringUtils.isEmpty(birthDayStr)) {
            return resultMap;
        }
        String[] dateArr = birthDayStr.split("-");
        if (dateArr.length == 0) {
            return resultMap;
        }
        int month = Integer.valueOf(dateArr[1]);
        int day = Integer.valueOf(dateArr[2]);
        if (month == 2 && day == 29) {
            --day;
        }
        Date spDate = DateTimeUtils.parseDate((String)("1900-" + month + "-" + day), (String)"yyyy-MM-dd");
        SimpleCalendar.Element element = SimpleCalendar.getCalendarDetail(birthDayStr, "yyyy-MM-dd");
        FilterInfo zocFilterInfo = new FilterInfo();
        SelectorItemCollection zocSelector = new SelectorItemCollection();
        EntityViewInfo zocView = new EntityViewInfo();
        zocFilterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        zocSelector.add(new SelectorItemInfo("id"));
        zocSelector.add(new SelectorItemInfo("state"));
        zocSelector.add(new SelectorItemInfo("name"));
        zocView.setFilter(zocFilterInfo);
        zocView.setSelector(zocSelector);
        ZodiacCollection zc = ZodiacFactory.getLocalInstance((Context)ctx).getZodiacCollection(zocView);
        if (null != zc && 0 < zc.size() && null != element.getZodiac()) {
            for (int i = 0; i < zc.size(); ++i) {
                if (!element.getZodiac().equals(zc.get(i).getName())) continue;
                String zodiac = zc.get(i).getName();
                BOSUuid zodiacId = zc.get(i).getId();
                resultMap.put("zodiac", zodiac);
                resultMap.put("zodiacId", zodiacId.toString());
                break;
            }
        }
        FilterInfo conFilterInfo = new FilterInfo();
        SelectorItemCollection conSelector = new SelectorItemCollection();
        EntityViewInfo conView = new EntityViewInfo();
        conFilterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        conSelector.add(new SelectorItemInfo("id"));
        conSelector.add(new SelectorItemInfo("constellaEndDate"));
        conSelector.add(new SelectorItemInfo("constellaStartDate"));
        conSelector.add(new SelectorItemInfo("state"));
        conSelector.add(new SelectorItemInfo("name"));
        conView.setFilter(conFilterInfo);
        conView.setSelector(conSelector);
        ConstellationCollection cc = ConstellationFactory.getLocalInstance((Context)ctx).getConstellationCollection(conView);
        if (null != cc && 0 < cc.size()) {
            ConstellationInfo cInfo = null;
            for (int i = 0; i < cc.size(); ++i) {
                cInfo = cc.get(i);
                if (cInfo.getConstellaStartDate().after(cInfo.getConstellaEndDate())) {
                    cInfo.setConstellaEndDate(DateTimeUtils.addYear((Date)cInfo.getConstellaEndDate(), (int)1));
                    Date nowDate = DateTimeUtils.addYear((Date)spDate, (int)1);
                    if (nowDate.before(cInfo.getConstellaEndDate())) {
                        String constellation = cInfo.getName();
                        BOSUuid constellationId = cInfo.getId();
                        resultMap.put("constellation", constellation);
                        resultMap.put("constellationId", constellationId.toString());
                        break;
                    }
                }
                if (EMPhelper.isEffectiveDate(spDate, cInfo.getConstellaStartDate(), cInfo.getConstellaEndDate())) continue;
                String constellation = cInfo.getName();
                BOSUuid constellationId = cInfo.getId();
                resultMap.put("constellation", constellation);
                resultMap.put("constellationId", constellationId.toString());
                break;
            }
        }
        return resultMap;
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return false;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return !date.after(begin) || !date.before(end);
    }

    public static boolean isEffectiveStratAndEndDate(Date sTime, Date eTaime, Date startTime, Date endTime) {
        block6: {
            block4: {
                Calendar end;
                Calendar begin;
                Calendar eDate;
                Calendar sDate;
                block5: {
                    if (sTime.getTime() == startTime.getTime() || sTime.getTime() == endTime.getTime() || eTaime.getTime() == startTime.getTime() || eTaime.getTime() == endTime.getTime()) {
                        return false;
                    }
                    sDate = Calendar.getInstance();
                    sDate.setTime(sTime);
                    eDate = Calendar.getInstance();
                    eDate.setTime(eTaime);
                    begin = Calendar.getInstance();
                    begin.setTime(startTime);
                    end = Calendar.getInstance();
                    end.setTime(endTime);
                    if (sDate.after(begin) && sDate.before(end) || eDate.after(begin) && eDate.before(end) || sDate.before(begin) && eDate.after(begin)) break block4;
                    if (!sDate.after(end) || !eDate.after(begin)) break block5;
                    if (true > true) break block4;
                }
                if (!sDate.equals(begin) && !sDate.equals(end) && !eDate.equals(begin) && !eDate.equals(end)) break block6;
            }
            return false;
        }
        return true;
    }

    public static ConstellationInfo getConstellationByName(Context ctx, String name) throws BOSException {
        ConstellationInfo cc = new ConstellationInfo();
        String costellatNumber = "";
        String costellatName = name;
        if (!StringUtils.isEmpty((String)name) && name.contains(NUMBER_NAME_SPLIT)) {
            String[] costellatArr = name.split(NUMBER_NAME_SPLIT);
            costellatNumber = costellatArr[0];
            costellatName = costellatArr[1];
        }
        String l = com.kingdee.shr.base.syssetting.util.LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sql = new StringBuffer("select FID, FName_").append(l).append(" from T_hr_constellation where FName_").append(l).append(" = '").append(costellatName).append("'");
        if (!StringUtils.isEmpty((String)costellatNumber)) {
            sql.append(" and fNumber = '" + costellatNumber + "'");
        }
        try {
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (set.next()) {
                cc.setId(BOSUuid.read((String)set.getString("FID")));
                cc.setName(set.getString("FName_" + l), LocaleUtils.getLocale((String)l));
            }
        }
        catch (UuidException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        return cc;
    }

    public static ZodiacInfo getZodiacByName(Context ctx, String name) throws BOSException {
        ZodiacInfo zc = new ZodiacInfo();
        String zodiacNumber = "";
        String zidiacName = name;
        if (!StringUtils.isEmpty((String)name) && name.contains(NUMBER_NAME_SPLIT)) {
            String[] zodiacArr = name.split(NUMBER_NAME_SPLIT);
            zodiacNumber = zodiacArr[0];
            zidiacName = zodiacArr[1];
        }
        String l = com.kingdee.shr.base.syssetting.util.LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sql = new StringBuffer("select FID, FName_").append(l).append(" from T_HR_ZODIAC where FName_").append(l).append(" = '").append(zidiacName).append("'");
        if (!StringUtils.isEmpty((String)zodiacNumber)) {
            sql.append(" and fNumber = '" + zodiacNumber + "'");
        }
        try {
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (set.next()) {
                zc.setId(BOSUuid.read((String)set.getString("FID")));
                zc.setName(set.getString("FName_" + l), LocaleUtils.getLocale((String)l));
            }
        }
        catch (UuidException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        return zc;
    }

    public static boolean checkSpecialDate(Date sDate, Date eDate, Date startDate, Date endDate) throws ParseException {
        if (sDate.after(eDate)) {
            eDate = DateTimeUtils.addYear((Date)eDate, (int)1);
        }
        if (startDate.after(endDate)) {
            endDate = DateTimeUtils.addYear((Date)endDate, (int)1);
        }
        return EMPhelper.isEffectiveStratAndEndDate(sDate, eDate, startDate, endDate);
    }
}

