/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.org.HRAdminOrgException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;

public class SHREmpOptOrgnizationTool {
    public static void checkAdminOrgUnitLayerType(Context ctx, AdminOrgUnitInfo adminInfo) throws BOSException, EASBizException {
        if (adminInfo == null || adminInfo.getId() == null || "00000000-0000-0000-0000-000000000000CCE7AED4".equals(adminInfo.getId().toString())) {
            return;
        }
        if (adminInfo.getUnitLayerType() == null || adminInfo.getUnitLayerType().getId() == null) {
            throw new HRAdminOrgException(HRAdminOrgException.ERROR_ADMINORGTYPE_NULL);
        }
        String parentOrgId = adminInfo.getParent() != null && adminInfo.getParent().getId() != null ? adminInfo.getParent().getId().toString() : null;
        AdminOrgUnitInfo parentOrgInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(parentOrgId));
        if (parentOrgInfo.getUnitLayerType() == null || parentOrgInfo.getUnitLayerType().getId() == null) {
            throw new HRAdminOrgException(HRAdminOrgException.ERROR_PARENTORGTYPE_NULL);
        }
        String adminAffiliationTypeId = SHREmpOptOrgnizationTool.getAdminAffiliationTypeId(ctx, adminInfo.getUnitLayerType().getId().toString());
        String parentAdminAffiliationTypeId = SHREmpOptOrgnizationTool.getAdminAffiliationTypeId(ctx, parentOrgInfo.getUnitLayerType().getId().toString());
        SHREmpOptOrgnizationTool.compareAdminAffiliationType(parentAdminAffiliationTypeId, adminAffiliationTypeId);
    }

    public static void checkAdminOrgUnitLayerTypeChange(Context ctx, AdminOrgUnitInfo adminInfo) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(adminInfo.getId());
        if (!AdminOrgUnitFactory.getLocalInstance((Context)ctx).exists((IObjectPK)pk)) {
            return;
        }
        AdminOrgUnitInfo oldAdminOrg = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)pk);
        if (adminInfo.getUnitLayerType() == null || adminInfo.getUnitLayerType().getId() == null) {
            throw new HRAdminOrgException(HRAdminOrgException.ERROR_ADMINORGTYPE_NULL);
        }
        if (oldAdminOrg.getUnitLayerType() != null && oldAdminOrg.getUnitLayerType().getId() != null) {
            String adminAffiliationTypeId = SHREmpOptOrgnizationTool.getAdminAffiliationTypeId(ctx, adminInfo.getUnitLayerType().getId().toString());
            if (StringUtils.isEmpty((String)adminAffiliationTypeId)) {
                throw new HRAdminOrgException(HRAdminOrgException.ERROR_ADMINAFFILIATIONTYPE_NULL);
            }
            String OldAdminAffiliationTypeId = SHREmpOptOrgnizationTool.getAdminAffiliationTypeId(ctx, oldAdminOrg.getUnitLayerType().getId().toString());
            if (!adminAffiliationTypeId.equals(OldAdminAffiliationTypeId) && SHREmpOptOrgnizationTool.existSubOrgPos(ctx, adminInfo.getId().toString())) {
                throw new HRAdminOrgException(HRAdminOrgException.ERROR_ADMINORGTYPE_CHANGELIMIT);
            }
        }
    }

    public static void compareAdminAffiliationType(String parentTypeId, String typeId) throws EASBizException {
        if (parentTypeId == null || typeId == null) {
            throw new HRAdminOrgException(HRAdminOrgException.ERROR_ADMINAFFILIATIONTYPE_NULL);
        }
        if ("US3TP3eIJgbgU0A+qMDqhoRbQ4A=".equals(typeId)) {
            if ("US3TP3eJJgbgU0A+qMDqhoRbQ4A=".equals(parentTypeId) || "US3TP3eKJgbgU0A+qMDqhoRbQ4A=".equals(parentTypeId)) {
                throw new HRAdminOrgException(HRAdminOrgException.ERROR_GROUPPARENTLIMIT);
            }
        } else if ("US3TP3eJJgbgU0A+qMDqhoRbQ4A=".equals(typeId) || "US3TP3eKJgbgU0A+qMDqhoRbQ4A=".equals(typeId)) {
            // empty if block
        }
    }

    public static boolean isUpgradeFinished(Context ctx) throws BOSException {
        boolean isUpgradeFinished = true;
        String sql = "SELECT FID FROM T_HR_SHRMvDataConfig WHERE FMoveStatus <> 1";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.size() > 0) {
            isUpgradeFinished = false;
        }
        return isUpgradeFinished;
    }

    public static boolean isEASHRUpgrade850Finished(Context ctx) throws BOSException {
        IRowSet rs3;
        boolean isUpgradeFinished = false;
        boolean isNeedCheckEASUpGrade = false;
        String sql = "SELECT * FROM t_hr_hrinit where (FKEY = 'SHR_DB_TYPE' or FID = 'dGom6Al0F/DgU8gEEawdG0xvIAU=' ) and FVALUE = '20'";
        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs2.size() > 0 && (rs3 = DbUtil.executeQuery((Context)ctx, (String)(sql = "SELECT * FROM T_ORG_BASEUNIT WHERE FID not in ('00000000-0000-0000-0000-000000000000CCE7AED4','11111111-1111-1111-1111-111111111111CCE7AED4')").toString())).size() > 0) {
            isNeedCheckEASUpGrade = true;
        }
        if (isNeedCheckEASUpGrade) {
            sql = "select fvalue from t_hr_hrinit  where fkey='MVDT_GUIDE_FINISH' and fvalue=1";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.size() > 0) {
                isUpgradeFinished = true;
            }
        } else {
            isUpgradeFinished = true;
        }
        return isUpgradeFinished;
    }

    public static boolean isAllUpgrade850Finished(Context ctx) throws BOSException {
        return SHREmpOptOrgnizationTool.isUpgradeFinished(ctx) && SHREmpOptOrgnizationTool.isEASHRUpgrade850Finished(ctx);
    }

    public static boolean existSubOrgPos(Context ctx, String orgId) throws BOSException, EASBizException {
        String sql1 = "select fid from T_ORG_Admin where  FParentID = ?";
        String sql2 = "select fid from T_ORG_Position where  FAdminOrgUnitID = ?";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new Object[]{orgId});
        IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)sql2, (Object[])new Object[]{orgId});
        return rowSet1.size() > 0 || rowSet2.size() > 0;
    }

    public static String getAdminAffiliationTypeId(Context ctx, String layerId) throws BOSException {
        if (layerId == null) {
            return null;
        }
        String adminAffiliationTypeId = null;
        StringBuffer oql = new StringBuffer();
        oql.append("select type.fid as typeId from T_Org_LayerType layer ");
        oql.append(" inner join T_ORG_AdminAffiliationType  type on type.fid = layer.FAdminAffiliationType");
        oql.append(" where layer.FID ='").append(layerId).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        try {
            if (rs.next()) {
                adminAffiliationTypeId = rs.getString("typeId");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return adminAffiliationTypeId;
    }

    public static String getAdminAffiliationTypeIdByOrg(Context ctx, String orgId) throws BOSException {
        if (orgId == null) {
            return null;
        }
        String adminAffiliationTypeId = null;
        StringBuffer oql = new StringBuffer();
        oql.append("select type.fid as typeId from T_ORG_admin org ");
        oql.append(" inner join T_Org_LayerType layer on layer.fid = org.FLayerTypeID");
        oql.append(" inner join T_ORG_AdminAffiliationType  type on type.fid = layer.FAdminAffiliationType");
        oql.append(" where org.FID ='").append(orgId).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        try {
            if (rs.next()) {
                adminAffiliationTypeId = rs.getString("typeId");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return adminAffiliationTypeId;
    }

    public static AdminOrgUnitInfo getAdminOrgUnitByPosition(Context ctx, String positionId) throws EASBizException, BOSException {
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        String oql = "select adminOrgUnit.id,adminOrgUnit.name,adminOrgUnit.displayName,adminOrgUnit.company.id,adminOrgUnit.company.name,adminOrgUnit.company.displayName,adminOrgUnit.department.id,adminOrgUnit.department.name,adminOrgUnit.department.displayName where id ='" + positionId + "'";
        PositionInfo positionInfo = null;
        PositionCollection posColl = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection(oql);
        if (posColl.size() > 0) {
            positionInfo = posColl.get(0);
            adminOrgUnitInfo = positionInfo.getAdminOrgUnit();
        }
        return adminOrgUnitInfo;
    }
}

