/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.probation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseContentDimensionCollection;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseContentDimensionDetailCollection;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseContentDimensionDetailInfo;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseContentDimensionInfo;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseContentDimensionLevelCollection;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseContentDimensionLevelInfo;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseContentFactory;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseContentInfo;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseEvaluateJudesCollection;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseEvaluateJudesFactory;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseEvaluateJudesInfo;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseTempDimensionCollection;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseTempDimensionDetailCollection;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseTempDimensionDetailInfo;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseTempDimensionInfo;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseTempDimensionLevelCollection;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseTempDimensionLevelInfo;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseTempFactory;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseTempInfo;
import com.kingdee.eas.hr.emp.probation.app.AbstractProbationAppraiseOptFacadeControllerBean;
import com.kingdee.eas.hr.emp.probation.app.ProabtionAppraiseEvaluateState;
import com.kingdee.eas.hr.emp.probation.util.ProbationGoalUtil;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.util.StringUtils;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProbationAppraiseOptFacadeControllerBean
extends AbstractProbationAppraiseOptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.probation.app.ProbationAppraiseOptFacadeControllerBean");

    @Override
    protected boolean _generateAppraiseEvaluate(Context ctx, String billId, String personId, Set judgeIdSet) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        BOSUuid contentId = null;
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        if (!ProbationAppraiseContentFactory.getLocalInstance(ctx).exists(filterInfo)) {
            ProbationAppraiseTempInfo tempInfo;
            BOSObjectType bostype = BOSUuid.read((String)billId).getType();
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)bostype.toString()));
            IHRBillBase ihrBillBase = (IHRBillBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityInfo.getFullName()));
            HRBillBaseInfo hrBillBaseInfo = ihrBillBase.getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId));
            IObjectCollection entryCollection = (IObjectCollection)hrBillBaseInfo.get("entrys");
            String tempId = "";
            if (entryCollection != null && entryCollection.size() > 0 && entryCollection.getObject(0).get("probationAppraiseTemp") != null) {
                tempInfo = (ProbationAppraiseTempInfo)entryCollection.getObject(0).get("probationAppraiseTemp");
                tempId = tempInfo.getId().toString();
            }
            if (StringUtils.isEmpty((String)tempId)) {
                tempId = ProbationGoalUtil.getRangeTempId(ctx, personId, this.isConditionAnd(ctx), 3);
            }
            tempInfo = ProbationAppraiseTempFactory.getLocalInstance(ctx).getProbationAppraiseTempInfo((IObjectPK)new ObjectUuidPK(tempId), this.getTempSelectors());
            IObjectPK contentPk = this.generateAppraiseContent(ctx, tempInfo, billId);
            contentId = BOSUuid.read((String)contentPk.toString());
        } else {
            ProbationAppraiseContentInfo probationAppraiseContentInfo = ProbationAppraiseContentFactory.getLocalInstance(ctx).getProbationAppraiseContentInfo("select id where billId = '" + billId + "'");
            contentId = probationAppraiseContentInfo.getId();
        }
        ProbationAppraiseContentInfo contentInfo = new ProbationAppraiseContentInfo();
        contentInfo.setId(contentId);
        coreBaseCollection = judgeIdSet == null || judgeIdSet.size() == 0 ? this.assembleProbationAppraiseEvaluateJudes(ctx, personId, judgeIdSet, billId, contentInfo) : this.assembleProbationAppraiseEvaluateJudes(ctx, personId, judgeIdSet, billId, contentInfo);
        ProbationAppraiseEvaluateJudesFactory.getLocalInstance(ctx).saveBatchData(coreBaseCollection);
        return true;
    }

    protected CoreBaseCollection assembleProbationAppraiseEvaluateJudes(Context ctx, String personId, Set judgeIdSet, String billId, ProbationAppraiseContentInfo contentInfo) throws BOSException {
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        if (judgeIdSet == null || judgeIdSet.size() == 0) {
            ProbationAppraiseEvaluateJudesInfo info = this.getProbationEvaluateJudes(ctx, billId, personId, personId, true);
            info.setBillId(billId);
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personId));
            info.setPerson(personInfo);
            info.setContent(contentInfo);
            PersonInfo judges = new PersonInfo();
            judges.setId(BOSUuid.read((String)personId));
            info.setJudges(judges);
            info.setState(ProabtionAppraiseEvaluateState.SAVE);
            info.setIsSelfAssessment(true);
            coreBaseCollection.add((CoreBaseInfo)info);
        }
        for (Object judgeId : judgeIdSet) {
            String juId = judgeId.toString();
            ProbationAppraiseEvaluateJudesInfo info = this.getProbationEvaluateJudes(ctx, billId, personId, juId, false);
            info.setBillId(billId);
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personId));
            info.setPerson(personInfo);
            info.setContent(contentInfo);
            PersonInfo judges = new PersonInfo();
            judges.setId(BOSUuid.read((String)juId));
            info.setJudges(judges);
            info.setState(ProabtionAppraiseEvaluateState.SAVE);
            info.setIsSelfAssessment(false);
            coreBaseCollection.add((CoreBaseInfo)info);
        }
        return coreBaseCollection;
    }

    protected ProbationAppraiseEvaluateJudesInfo getProbationEvaluateJudes(Context ctx, String billId, String personId, String juId, boolean isSelfAssessment) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filterInfo.getFilterItems().add(new FilterItemInfo("judges.id", (Object)juId));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSelfAssessment", (Object)isSelfAssessment));
        view.setFilter(filterInfo);
        ProbationAppraiseEvaluateJudesCollection coll = ProbationAppraiseEvaluateJudesFactory.getLocalInstance(ctx).getProbationAppraiseEvaluateJudesCollection(view);
        ProbationAppraiseEvaluateJudesInfo info = null;
        info = coll != null && coll.size() > 0 ? coll.get(0) : new ProbationAppraiseEvaluateJudesInfo();
        return info;
    }

    public IObjectPK generateAppraiseContent(Context ctx, ProbationAppraiseTempInfo tempInfo, String billId) throws BOSException, EASBizException {
        ProbationAppraiseContentInfo probationAppraiseContentInfo = new ProbationAppraiseContentInfo();
        probationAppraiseContentInfo.setBillId(billId);
        probationAppraiseContentInfo.setTemp(tempInfo);
        probationAppraiseContentInfo.setScoringMethod(tempInfo.getScoringMethod());
        probationAppraiseContentInfo.setLowestPoint(tempInfo.getLowestPoint());
        probationAppraiseContentInfo.setHighestPoint(tempInfo.getHighestPoint());
        probationAppraiseContentInfo.getDimensions().addCollection(this.getDimensionByTemp(ctx, tempInfo));
        IObjectPK pk = ProbationAppraiseContentFactory.getLocalInstance(ctx).save((CoreBaseInfo)probationAppraiseContentInfo);
        return pk;
    }

    public ProbationAppraiseContentDimensionCollection getDimensionByTemp(Context ctx, ProbationAppraiseTempInfo tempInfo) {
        ProbationAppraiseTempDimensionCollection tempDimensionCollection = tempInfo.getDimensions();
        ProbationAppraiseContentDimensionCollection dimensionCollection = new ProbationAppraiseContentDimensionCollection();
        for (int i = 0; i < tempDimensionCollection.size(); ++i) {
            ProbationAppraiseTempDimensionInfo tempDimensionInfo = tempDimensionCollection.get(i);
            ProbationAppraiseContentDimensionInfo info = new ProbationAppraiseContentDimensionInfo();
            info.setName(tempDimensionInfo.getName());
            info.setRateType(tempDimensionInfo.getRateType());
            info.setIsRate(tempDimensionInfo.isIsRate());
            info.setIsWeight(tempDimensionInfo.isIsWeight());
            info.setWeight(tempDimensionInfo.getWeight());
            info.setIndex(tempDimensionInfo.getIndex());
            info.getDetail().addCollection(this.getDimensionDetailByTemp(ctx, tempDimensionInfo));
            info.getLevel().addCollection(this.getDimensionLevelyTemp(ctx, tempDimensionInfo));
            dimensionCollection.add(info);
        }
        return dimensionCollection;
    }

    public ProbationAppraiseContentDimensionDetailCollection getDimensionDetailByTemp(Context ctx, ProbationAppraiseTempDimensionInfo tempDimensionInfo) {
        ProbationAppraiseTempDimensionDetailCollection tempDimensionDetailCollection = tempDimensionInfo.getDetail();
        ProbationAppraiseContentDimensionDetailCollection dimensionDetailCollection = new ProbationAppraiseContentDimensionDetailCollection();
        for (int i = 0; i < tempDimensionDetailCollection.size(); ++i) {
            ProbationAppraiseTempDimensionDetailInfo tempDimensionDetailInfo = tempDimensionDetailCollection.get(i);
            ProbationAppraiseContentDimensionDetailInfo info = new ProbationAppraiseContentDimensionDetailInfo();
            info.setName(tempDimensionDetailInfo.getName());
            info.setDescription(tempDimensionDetailInfo.getDescription());
            info.setLowestPoint(tempDimensionDetailInfo.getLowestPoint());
            info.setHighestPoint(tempDimensionDetailInfo.getHighestPoint());
            info.setIndex(tempDimensionDetailInfo.getIndex());
            dimensionDetailCollection.add(info);
        }
        return dimensionDetailCollection;
    }

    public ProbationAppraiseContentDimensionLevelCollection getDimensionLevelyTemp(Context ctx, ProbationAppraiseTempDimensionInfo tempDimensionInfo) {
        ProbationAppraiseTempDimensionLevelCollection tempDimensionLevelCollection = tempDimensionInfo.getLevel();
        ProbationAppraiseContentDimensionLevelCollection dimensionLevelCollection = new ProbationAppraiseContentDimensionLevelCollection();
        for (int i = 0; i < tempDimensionLevelCollection.size(); ++i) {
            ProbationAppraiseTempDimensionLevelInfo tempDimensionDetailInfo = tempDimensionLevelCollection.get(i);
            ProbationAppraiseContentDimensionLevelInfo info = new ProbationAppraiseContentDimensionLevelInfo();
            info.setName(tempDimensionDetailInfo.getName());
            info.setNumber(tempDimensionDetailInfo.getNumber());
            info.setDescription(tempDimensionDetailInfo.getDescription());
            info.setIndex(tempDimensionDetailInfo.getIndex());
            dimensionLevelCollection.add(info);
        }
        return dimensionLevelCollection;
    }

    @Override
    protected boolean _deleteAppraiseEvaluate(Context ctx, String billId, String personId, Set judgeIdSet) throws BOSException, EASBizException {
        IObjectPK[] pks;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        if (judgeIdSet != null && judgeIdSet.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("judges.id", (Object)judgeIdSet, CompareType.INCLUDE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("judges.id", (Object)personId));
        }
        for (IObjectPK pk : pks = ProbationAppraiseEvaluateJudesFactory.getLocalInstance(ctx).delete(filterInfo)) {
            this.deleteAttachment(ctx, pk.toString());
        }
        return true;
    }

    private void deleteAttachment(Context ctx, String boId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("boID", (Object)boId));
        SHRAttachmentExtFactory.getLocalInstance((Context)ctx).delete(filter);
        BoAttchAssoFactory.getLocalInstance((Context)ctx).deleteAllAssociationsByBoID(boId);
    }

    protected SelectorItemCollection getTempSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isSelfAssessment"));
        sic.add(new SelectorItemInfo("scoringMethod"));
        sic.add(new SelectorItemInfo("highestPoint"));
        sic.add(new SelectorItemInfo("lowestPoint"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("dimensions.id"));
        sic.add(new SelectorItemInfo("dimensions.name"));
        sic.add(new SelectorItemInfo("dimensions.number"));
        sic.add(new SelectorItemInfo("dimensions.rateType"));
        sic.add(new SelectorItemInfo("dimensions.isRate"));
        sic.add(new SelectorItemInfo("dimensions.isWeight"));
        sic.add(new SelectorItemInfo("dimensions.weight"));
        sic.add(new SelectorItemInfo("dimensions.index"));
        sic.add(new SelectorItemInfo("dimensions.detail.id"));
        sic.add(new SelectorItemInfo("dimensions.detail.name"));
        sic.add(new SelectorItemInfo("dimensions.detail.description"));
        sic.add(new SelectorItemInfo("dimensions.detail.lowestPoint"));
        sic.add(new SelectorItemInfo("dimensions.detail.highestPoint"));
        sic.add(new SelectorItemInfo("dimensions.detail.index"));
        sic.add(new SelectorItemInfo("dimensions.level.id"));
        sic.add(new SelectorItemInfo("dimensions.level.name"));
        sic.add(new SelectorItemInfo("dimensions.level.number"));
        sic.add(new SelectorItemInfo("dimensions.level.index"));
        return sic;
    }

    protected Boolean isConditionAnd(Context ctx) {
        return true;
    }
}

