/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.probation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.DirectSenderAgent;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.AffairActioniOperateException;
import com.kingdee.eas.hr.base.EmpHRORelationHisFactory;
import com.kingdee.eas.hr.base.EmpHRORelationHisInfo;
import com.kingdee.eas.hr.base.EmpLaborRelationCollection;
import com.kingdee.eas.hr.base.EmpLaborRelationFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.emp.PersonOtherInfoCollection;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptBizManageTool;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptEmpLaborRelationUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptEmpOrgRelationTool;
import com.kingdee.eas.hr.emp.probation.IPersonProbationTrainPlan;
import com.kingdee.eas.hr.emp.probation.PersonProbationTrainPlanCollection;
import com.kingdee.eas.hr.emp.probation.PersonProbationTrainPlanFactory;
import com.kingdee.eas.hr.emp.probation.PersonProbationTrainPlanInfo;
import com.kingdee.eas.hr.emp.probation.ProbationException;
import com.kingdee.eas.hr.emp.probation.ProbationGoalBizBillInfo;
import com.kingdee.eas.hr.emp.probation.ProbationSetCollection;
import com.kingdee.eas.hr.emp.probation.ProbationSetFactory;
import com.kingdee.eas.hr.emp.probation.ProbationSetInfo;
import com.kingdee.eas.hr.emp.probation.ProbationTrainLogFactory;
import com.kingdee.eas.hr.emp.probation.ProbationTrainLogInfo;
import com.kingdee.eas.hr.emp.probation.ProbationTrainProgramFactory;
import com.kingdee.eas.hr.emp.probation.ProbationTrainProgramInfo;
import com.kingdee.eas.hr.emp.probation.app.GenerateTrainResult;
import com.kingdee.eas.hr.emp.probation.app.ProbationTrainStateEnum;
import com.kingdee.eas.hr.emp.probation.util.ProbationAppraiseUtil;
import com.kingdee.eas.hr.emp.probation.util.ProbationGoalUtil;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.osf.ServiceLocatorException;
import com.kingdee.shr.osf.service.ServiceLocator;
import com.kingdee.shr.shareservice.ActivityJobInfoFactory;
import com.kingdee.shr.shareservice.ActivitySolutionFactory;
import com.kingdee.shr.shareservice.ActivitySolutionInfo;
import com.kingdee.shr.shareservice.CoActivityJobOptFacadeFactory;
import com.kingdee.shr.shareservice.util.JobUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProbationTrainPlanUtil {
    private static final Logger logger = LoggerFactory.getLogger(ProbationTrainPlanUtil.class);

    public static boolean generateActivity(Context ctx, PersonProbationTrainPlanInfo trainPlanInfo) throws EASBizException, BOSException {
        boolean result = false;
        Date beginDate = trainPlanInfo.getBeginDate();
        ProbationSetInfo setInfo = ProbationTrainPlanUtil.getPeriodSetItem(ctx);
        boolean isAutoTrainPeriod = setInfo != null ? setInfo.isIsAutoTrainPeriod() : false;
        int aheadDays = setInfo != null ? setInfo.getAheadDays() : 0;
        Date nowDate = new Date();
        if (logger.isInfoEnabled()) {
            logger.info("ProbationTrainPlanUtil.isAutoTrainPeriod: " + isAutoTrainPeriod);
        }
        if (isAutoTrainPeriod) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(nowDate);
            calendar.add(5, aheadDays);
            Date futureDate = calendar.getTime();
            if (futureDate.after(beginDate)) {
                result = true;
            }
        } else if (nowDate.after(beginDate)) {
            result = true;
        }
        String planState = trainPlanInfo.getPlanState();
        if (result && ProbationTrainStateEnum.PLANSTATE_UNSTART.getAlias().equals(planState)) {
            ProbationTrainPlanUtil.generateActivityNow(ctx, trainPlanInfo);
        }
        return result;
    }

    public static boolean generateActivity(Context ctx, PersonProbationTrainPlanInfo trainPlanInfo, int aheadDays, boolean isAutoTrainPeriod) throws EASBizException, BOSException {
        boolean result = false;
        Date beginDate = trainPlanInfo.getBeginDate();
        Date nowDate = new Date();
        if (isAutoTrainPeriod) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(nowDate);
            calendar.add(5, aheadDays);
            Date futureDate = calendar.getTime();
            if (futureDate.after(beginDate)) {
                result = true;
            }
        } else if (nowDate.after(beginDate)) {
            result = true;
        }
        String planState = trainPlanInfo.getPlanState();
        if (result && ProbationTrainStateEnum.PLANSTATE_UNSTART.getAlias().equals(planState)) {
            ProbationTrainPlanUtil.generateActivityNow(ctx, trainPlanInfo);
        }
        return result;
    }

    public static void generateActivityNow(Context ctx, PersonProbationTrainPlanInfo trainPlanInfo) throws EASBizException, BOSException {
        String billId = trainPlanInfo.getId().toString();
        ActivitySolutionInfo activitySolution = trainPlanInfo.getActivitySolution();
        if (activitySolution == null) {
            throw new ProbationException(ProbationException.ACTIVITY_MUST);
        }
        String activitySolutionId = trainPlanInfo.getActivitySolution().getId().toString();
        activitySolution = ActivitySolutionFactory.getLocalInstance((Context)ctx).getActivitySolutionInfo((IObjectPK)new ObjectUuidPK(activitySolutionId));
        String activityNumber = activitySolution.getNumber();
        if (logger.isInfoEnabled()) {
            logger.info("ProbationTrainPlanUtil.generateActivityNow: " + billId + ", activityNumber: " + activityNumber);
        }
        CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).createJobBySolution(null, activityNumber, billId, null);
    }

    public static int getPersonProbationTrainPlanMaxPeriod(Context ctx, String personId) throws ProbationException, BOSException {
        int periodNum = 0;
        String careerId = ProbationTrainPlanUtil.getPersonCareerID(ctx, personId);
        String oql = "select periodNum where person = '" + personId + "' and careerId = '" + careerId + "' order by periodNum desc";
        try {
            PersonProbationTrainPlanCollection coll = PersonProbationTrainPlanFactory.getLocalInstance(ctx).getPersonProbationTrainPlanCollection(oql);
            if (coll.size() > 0) {
                periodNum = coll.get(0).getPeriodNum();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new ProbationException(ProbationException.TRAIN_PLAN_FIELD);
        }
        if (logger.isInfoEnabled()) {
            logger.info("ProbationTrainPlanUtil.periodNum: " + periodNum + ", careerId: " + careerId);
        }
        return periodNum;
    }

    public static Map<String, String> getProbationTrainPlanName(Context ctx, String personId, int index) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        PersonInfo person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId), sic);
        HashMap<String, String> nameMap = new HashMap<String, String>();
        String msg_L1 = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"PLAN_NAME", (Locale)LocaleUtils.locale_l1);
        String msg_L2 = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"PLAN_NAME", (Locale)LocaleUtils.locale_l2);
        String msg_L3 = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"PLAN_NAME", (Locale)LocaleUtils.locale_l3);
        String planName_L1 = person.getName(LocaleUtils.locale_l1) + msg_L1 + index;
        String planName_L2 = person.getName(LocaleUtils.locale_l2) + msg_L2 + index;
        String planName_L3 = person.getName(LocaleUtils.locale_l3) + msg_L3 + index;
        nameMap.put("L1", planName_L1);
        nameMap.put("L2", planName_L2);
        nameMap.put("L3", planName_L3);
        return nameMap;
    }

    public static PersonProbationTrainPlanInfo getPersonProbationTrainPlanInfoByBillId(Context ctx, String billId) throws BOSException, EASBizException {
        PersonProbationTrainPlanInfo info = null;
        String oql = " where id = '" + billId + "'";
        IPersonProbationTrainPlan trainPlanInstance = PersonProbationTrainPlanFactory.getLocalInstance(ctx);
        PersonProbationTrainPlanCollection trainPlanColl = trainPlanInstance.getPersonProbationTrainPlanCollection(oql);
        if (trainPlanColl.size() <= 0) {
            throw new ProbationException(ProbationException.TRAIN_PLAN_MUST);
        }
        info = trainPlanColl.get(0);
        return info;
    }

    public static Date getPersonEnrollDate(Context ctx, String personId) throws BOSException, ProbationException {
        String oql = " where person = '" + personId + "'";
        EmpLaborRelationCollection laborColl = EmpLaborRelationFactory.getLocalInstance((Context)ctx).getEmpLaborRelationCollection(oql);
        if (laborColl.size() > 0) {
            return laborColl.get(0).getEnterDate();
        }
        throw new ProbationException(ProbationException.PERSON_ENTERDATE_ERROR);
    }

    public static PersonInfo getPeronTutor(Context ctx, String personId) throws BOSException, ProbationException {
        String oql = " where person = '" + personId + "'";
        PersonOtherInfoCollection otherColl = PersonOtherInfoFactory.getLocalInstance(ctx).getPersonOtherInfoCollection(oql);
        if (otherColl.size() == 0) {
            throw new ProbationException(ProbationException.PERSON_NOT_EXIST);
        }
        PersonOtherInfoInfo info = otherColl.get(0);
        if (info.getTutor() == null) {
            throw new ProbationException(ProbationException.PERSON_TUTOR_MUST);
        }
        return info.getTutor();
    }

    public static Map<String, Object> getProbationActivitySolutionRange(Context ctx, String hrOrg, String bosType) throws BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        MetaDataPK query = MetaDataPK.create((String)"com.kingdee.shr.shareservice.app.ActivitySolutionQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)query);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("activityType.bosType", (Object)bosType, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("baseInfo.state", (Object)"1", CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("state", (Object)"100", CompareType.EQUALS));
        if (!StringUtils.isEmpty((String)hrOrg)) {
            fi.getFilterItems().add(new FilterItemInfo("hrOrgUse.id", (Object)hrOrg, CompareType.EQUALS));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(fi);
        exec.setObjectView(viewInfo);
        try {
            int totalCount = exec.getRowCount();
            if (totalCount != 1) {
                return null;
            }
            IRowSet resultSet = exec.executeQuery();
            while (resultSet.next()) {
                ActivitySolutionInfo info = new ActivitySolutionInfo();
                info.setId(BOSUuid.read((String)resultSet.getString("BASEINFO.ID")));
                info.setName(resultSet.getString("BASEINFO.NAME"));
                result.put("onlyOne", true);
                result.put("activitySolution", info);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean checkPersonProbationTrainState(Context ctx, String personId) throws BOSException {
        boolean result = false;
        String careerId = ProbationTrainPlanUtil.getPersonCareerID(ctx, personId);
        String oql = " where person = '" + personId + "' and careerID = '" + careerId + "'";
        PersonProbationTrainPlanCollection coll = PersonProbationTrainPlanFactory.getLocalInstance(ctx).getPersonProbationTrainPlanCollection(oql);
        if (coll.size() > 0) {
            result = true;
        }
        return result;
    }

    public static boolean checkPersonProbationTrainState(Context ctx, String personId, String careerId) throws BOSException {
        boolean result = false;
        String oql = " where person = '" + personId + "' and careerID = '" + careerId + "'";
        PersonProbationTrainPlanCollection coll = PersonProbationTrainPlanFactory.getLocalInstance(ctx).getPersonProbationTrainPlanCollection(oql);
        if (coll.size() > 0) {
            result = true;
        }
        return result;
    }

    public static void checkPeronEmpType(Context ctx, String personId, PersonInfo tutor) throws BOSException, EASBizException {
        boolean tutorExist;
        boolean personExist = ProbationGoalUtil.checkPersonInService(ctx, personId);
        if (!personExist) {
            throw new ProbationException(ProbationException.PERSON_NOTINSERVICE);
        }
        if (tutor == null) {
            tutor = ProbationTrainPlanUtil.getPeronTutor(ctx, personId);
        }
        if (!(tutorExist = ProbationGoalUtil.checkPersonInService(ctx, tutor.getId().toString()))) {
            throw new ProbationException(ProbationException.TUTOR_NOTINSERVICE);
        }
    }

    public static boolean checkTrainPlanStateForAbort(Context ctx, String periodId) throws BOSException {
        boolean result = true;
        String oql = " where id = '" + periodId + "'";
        PersonProbationTrainPlanCollection coll = PersonProbationTrainPlanFactory.getLocalInstance(ctx).getPersonProbationTrainPlanCollection(oql);
        if (coll.size() > 0) {
            PersonProbationTrainPlanInfo info = coll.get(0);
            if (logger.isInfoEnabled()) {
                logger.info("ProbationTrainPlanUtil.getPlanState: " + info.getPlanState());
            }
            if (ProbationTrainStateEnum.PLANSTATE_END.getAlias().equals(info.getPlanState()) || ProbationTrainStateEnum.PLANSTATE_ABORT.getAlias().equals(info.getPlanState())) {
                result = false;
            }
        }
        return result;
    }

    public static boolean checkTrainPlanStateForDelete(Context ctx, String periodId) throws BOSException {
        boolean result = false;
        String oql = " where id = '" + periodId + "'";
        PersonProbationTrainPlanCollection coll = PersonProbationTrainPlanFactory.getLocalInstance(ctx).getPersonProbationTrainPlanCollection(oql);
        if (coll.size() > 0) {
            PersonProbationTrainPlanInfo info = coll.get(0);
            if (logger.isInfoEnabled()) {
                logger.info("ProbationTrainPlanUtil.getPlanState: " + info.getPlanState());
            }
            if (ProbationTrainStateEnum.PLANSTATE_UNSTART.getAlias().equals(info.getPlanState()) || ProbationTrainStateEnum.PLANSTATE_ABORT.getAlias().equals(info.getPlanState())) {
                result = true;
            }
        }
        return result;
    }

    public static boolean checkTrainPlanStateForReset(Context ctx, String periodId, boolean verifyProbation) throws BOSException, EASBizException {
        boolean result = true;
        String oql = " where id = '" + periodId + "'";
        PersonProbationTrainPlanCollection coll = PersonProbationTrainPlanFactory.getLocalInstance(ctx).getPersonProbationTrainPlanCollection(oql);
        if (coll.size() > 0) {
            EmpLaborRelationInfo empLaborRelationInfo;
            PersonInfo personInfo;
            PersonProbationTrainPlanInfo info = coll.get(0);
            if (logger.isInfoEnabled()) {
                logger.info("ProbationTrainPlanUtil.getPlanState: " + info.getPlanState());
            }
            if (ProbationTrainStateEnum.PLANSTATE_UNSTART.getAlias().equals(info.getPlanState())) {
                result = false;
            }
            if (verifyProbation && (personInfo = info.getPerson()) != null && (empLaborRelationInfo = SHREmpOptEmpLaborRelationUtil.getPersonCurrentEmpLaborRelationInfo(ctx, personInfo.getId().toString())) != null) {
                EmployeeTypeInfo employeeTypeInfo = empLaborRelationInfo.getLaborRelationState();
                Set<String> inEmpTypeSet = ProbationAppraiseUtil.getHrBizDefineInEmpTypeSet(ctx, "com.kingdee.eas.hr.affair.app.EmpHireBizBill.form");
                if (!inEmpTypeSet.contains(employeeTypeInfo.getId().toString())) {
                    throw new ProbationException(ProbationException.CHECK_PERSON_PROBATION);
                }
            }
        }
        return result;
    }

    public static boolean checkIsLastActivity(Context ctx, String trainPlanId) throws BOSException, EASBizException {
        boolean result = false;
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bill", (Object)trainPlanId, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("jobState", (Object)"0", CompareType.EQUALS));
        boolean exist = ActivityJobInfoFactory.getLocalInstance((Context)ctx).exists(fi);
        if (!exist) {
            result = true;
        }
        return result;
    }

    public static boolean getEmpHRORelationUseDefault(Context ctx, HRBillBaseInfo entry, int type) throws BOSException, EASBizException {
        boolean result = false;
        EmpHRORelationHisInfo buInfo = null;
        String personId = "";
        switch (type) {
            case 1: {
                ProbationGoalBizBillInfo goalInfo = (ProbationGoalBizBillInfo)entry;
                personId = goalInfo.getPerson() != null ? goalInfo.getPerson().getId().toString() : "";
                break;
            }
            case 2: {
                PersonProbationTrainPlanInfo planInfo = (PersonProbationTrainPlanInfo)entry;
                String string = personId = planInfo.getPerson() != null ? planInfo.getPerson().getId().toString() : "";
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("ProbationTrainPlanUtil.personId: " + personId + ", type: " + type);
        }
        if (!StringUtils.isEmpty((String)personId)) {
            EmpPosOrgRelationInfo info = SHREmpOptEmpOrgRelationTool.getCurrntMainEmpOrgRelationInfo(ctx, personId);
            if (info != null && "P/OSDCPfQXqU0TB/LQoA6uZovtk=".equals(info.getAction().getId().toString())) {
                buInfo = SHREmpOptBizManageTool.getEmpHRORelationHisInfo(ctx, personId);
                if (buInfo == null) {
                    if (EmpHRORelationHisFactory.getLocalInstance((Context)ctx).exists("where person.id = '" + personId + "' and isInner = 1")) {
                        throw new AffairActioniOperateException(AffairActioniOperateException.UPDATING_PERSON_BURELA);
                    }
                    throw new AffairActioniOperateException(AffairActioniOperateException.ERROR_PERSONINIT_NO_EMPHRO);
                }
            } else {
                buInfo = SHREmpOptBizManageTool.getEmpHRORelationHisInfo(ctx, personId);
                if (buInfo == null) {
                    throw new AffairActioniOperateException(AffairActioniOperateException.UPDATING_PERSON_BURELA);
                }
            }
        }
        if (buInfo != null) {
            result = buInfo.isUseDefault();
        }
        return result;
    }

    public static ProbationSetInfo getPeriodSetItem(Context ctx) throws BOSException, ProbationException {
        ProbationSetInfo setInfo = null;
        String oql = " where number = 'probationSet'";
        ProbationSetCollection psColl = ProbationSetFactory.getLocalInstance(ctx).getProbationSetCollection(oql);
        if (psColl.size() > 0) {
            setInfo = psColl.get(0);
        }
        return setInfo;
    }

    public static void recordGenerateTrainLog(Context ctx, String personId, String planInfoIds, boolean isFromJob, GenerateTrainResult result, String msg) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)personId)) {
            return;
        }
        ProbationTrainLogInfo logInfo = new ProbationTrainLogInfo();
        PersonInfo person = new PersonInfo();
        person.setId(BOSUuid.read((String)personId));
        String careerID = ProbationTrainPlanUtil.getPersonCareerID(ctx, personId);
        logInfo.setPerson(person);
        logInfo.setIsFromJob(isFromJob);
        logInfo.setGenerateResult(result);
        logInfo.setDescription(msg);
        logInfo.setCareerID(careerID);
        logInfo.setTrainPlans(planInfoIds);
        ProbationTrainLogFactory.getLocalInstance(ctx).save((CoreBaseInfo)logInfo);
    }

    public static String getPersonCareerID(Context ctx, String personId) throws BOSException {
        String careerID = "career1";
        String oql = " where person = '" + personId + "'";
        EmpLaborRelationCollection laborColl = EmpLaborRelationFactory.getLocalInstance((Context)ctx).getEmpLaborRelationCollection(oql);
        if (laborColl.size() > 0) {
            careerID = laborColl.get(0).getCareerId();
        }
        return careerID;
    }

    public static void abortPersonTrainPeriod(Context ctx, PersonProbationTrainPlanInfo trainPlanInfo, String abortReason, String planState) throws EASBizException, BOSException {
        trainPlanInfo.setAbortReason(abortReason);
        trainPlanInfo.setPlanState(planState);
        trainPlanInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        trainPlanInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        SelectorItemCollection sicoll = new SelectorItemCollection();
        sicoll.add(new SelectorItemInfo("planState"));
        sicoll.add(new SelectorItemInfo("abortReason"));
        sicoll.add(new SelectorItemInfo("lastUpdateTime"));
        sicoll.add(new SelectorItemInfo("lastUpdateUser"));
        PersonProbationTrainPlanFactory.getLocalInstance(ctx).updatePartial(trainPlanInfo, sicoll);
        PersonInfo person = trainPlanInfo.getPerson();
        if (person != null && StringUtils.isEmpty((String)person.getName())) {
            SelectorItemCollection sicollPerson = new SelectorItemCollection();
            sicollPerson.add(new SelectorItemInfo("id"));
            sicollPerson.add(new SelectorItemInfo("name"));
            sicollPerson.add(new SelectorItemInfo("number"));
            person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(person.getId()), sicollPerson);
        }
    }

    public static void abortActivity(Context ctx, PersonProbationTrainPlanInfo trainPlanInfo, String abortReason) throws EASBizException, BOSException {
        String trainPlanId = trainPlanInfo.getId().toString();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("billId", trainPlanId);
        if (logger.isInfoEnabled()) {
            logger.info("ProbationTrainPlanUtil.abortActivity: " + trainPlanId);
        }
        CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).reverseJob(param);
    }

    public static void sendActivityAbortNotice(Context ctx, PersonProbationTrainPlanInfo trainPlanInfo, Set<String> receiver, int type) {
        String trainPlanName = trainPlanInfo.getName();
        String abortReason = trainPlanInfo.getAbortReason();
        PersonInfo person = trainPlanInfo.getPerson();
        if (receiver.size() > 0) {
            try {
                ProbationTrainPlanUtil.sendActivityAbortMessage(ctx, person, trainPlanName, abortReason, receiver, type);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    public static String convertSetToString(Set<String> entityNameSet) {
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = entityNameSet.iterator();
        while (it.hasNext()) {
            sb.append("'" + it.next() + "'");
            sb.append(",");
        }
        sb = sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    protected static void sendActivityAbortMessage(Context ctx, PersonInfo person, String trainPlanName, String abortReason, Set<String> receivers, int type) throws BOSException {
        for (String receiver : receivers) {
            Message message = MessageFactory.newMessage();
            message.setBooleanHeader("isSendCommon", Boolean.TRUE.booleanValue());
            message.setIntHeader("type", 0);
            message.setIntHeader("bizType", 70);
            message.setIntHeader("priority", 10);
            message.setIntHeader("sourceStatus", 0);
            message.setStringHeader("solution", ctx.getSolution());
            message.setStringHeader("databaseCenter", ctx.getAIS());
            message.setStringHeader("senderId", ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            if (StringUtils.isEmpty((String)person.getName())) {
                String personOql = "select id,name,number where id = '" + person.getId().toString() + "'";
                PersonCollection personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(personOql);
                if (personColl.size() > 0) {
                    person = personColl.get(0);
                }
            }
            String msg = "";
            String abortMsg = "";
            String bodyContend = "";
            if (type == 1) {
                msg = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"ABORT_NOTICE", (Context)ctx);
                abortMsg = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"ABORT_LABEL", (Context)ctx);
                bodyContend = MessageFormat.format(abortMsg, abortReason);
            } else if (type == 2) {
                msg = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"RESET_NOTICE", (Context)ctx);
            }
            String titleContend_L1 = MessageFormat.format(msg, person.getName(LocaleUtils.locale_l1), trainPlanName);
            String titleContend_L2 = MessageFormat.format(msg, person.getName(LocaleUtils.locale_l2), trainPlanName);
            String titleContend_L3 = MessageFormat.format(msg, person.getName(LocaleUtils.locale_l3), trainPlanName);
            message.setLocaleStringHeader("title", titleContend_L1, LocaleUtils.locale_l1);
            message.setLocaleStringHeader("title", titleContend_L2, LocaleUtils.locale_l2);
            message.setLocaleStringHeader("title", titleContend_L3, LocaleUtils.locale_l3);
            message.setLocaleStringHeader("sender", ContextUtil.getCurrentUserInfo((Context)ctx).getName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            message.setLocaleStringHeader("sender", ContextUtil.getCurrentUserInfo((Context)ctx).getName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            message.setLocaleStringHeader("sender", ContextUtil.getCurrentUserInfo((Context)ctx).getName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            String sysAutoSendl1 = SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"sys_auto_send", (Locale)LocaleUtils.locale_l1);
            String sysAutoSendl2 = SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"sys_auto_send", (Locale)LocaleUtils.locale_l2);
            String sysAutoSendl3 = SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"sys_auto_send", (Locale)LocaleUtils.locale_l3);
            message.setLocaleStringHeader("initiatorName", sysAutoSendl1, LocaleUtils.locale_l1);
            message.setLocaleStringHeader("initiatorName", sysAutoSendl2, LocaleUtils.locale_l2);
            message.setLocaleStringHeader("initiatorName", sysAutoSendl3, LocaleUtils.locale_l3);
            message.setLocaleStringHeader("body", bodyContend, LocaleUtils.locale_l1);
            message.setLocaleStringHeader("body", bodyContend, LocaleUtils.locale_l2);
            message.setLocaleStringHeader("body", bodyContend, LocaleUtils.locale_l3);
            message.setStringHeader("receiver", receiver);
            DirectSenderAgent.getSenderAgent().sendMessage(message);
        }
    }

    public static PersonProbationTrainPlanInfo updateTrainPlanToLatestInfo(Context ctx, PersonProbationTrainPlanInfo planInfo) throws ServiceLocatorException, BOSException, EASBizException {
        if (planInfo.getPerson() == null) {
            throw new ProbationException(ProbationException.PERSON_NOT_EXIST);
        }
        String personId = planInfo.getPerson().getId().toString();
        IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "getPersonPosOrgInfo");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("personID", personId);
        List personRefInfoList = (List)imsf.process(ctx, param);
        if (personRefInfoList == null || personRefInfoList.size() < 1) {
            throw new ProbationException(ProbationException.PERSON_NOT_EXIST);
        }
        Map personRefInfo = (Map)personRefInfoList.get(0);
        Map hrOrgUnitMap = (Map)personRefInfo.get("hrOrgUnit");
        Map adminOrgMap = (Map)personRefInfo.get("adminOrg");
        Map companyMap = (Map)personRefInfo.get("company");
        Map departmentMap = (Map)personRefInfo.get("department");
        HROrgUnitInfo hrOrgUnit = new HROrgUnitInfo();
        BOSUuid hrOrgUnitId = hrOrgUnitMap.get("id") != null ? BOSUuid.read((String)((String)hrOrgUnitMap.get("id"))) : null;
        hrOrgUnit.setId(hrOrgUnitId);
        AdminOrgUnitInfo adminOrgUnit = new AdminOrgUnitInfo();
        BOSUuid adminOrgUnitId = adminOrgMap.get("id") != null ? BOSUuid.read((String)((String)adminOrgMap.get("id"))) : null;
        adminOrgUnit.setId(adminOrgUnitId);
        AdminOrgUnitInfo company = new AdminOrgUnitInfo();
        BOSUuid companyId = companyMap.get("id") != null ? BOSUuid.read((String)((String)companyMap.get("id"))) : null;
        company.setId(companyId);
        AdminOrgUnitInfo department = new AdminOrgUnitInfo();
        BOSUuid departmentId = departmentMap.get("id") != null ? BOSUuid.read((String)((String)departmentMap.get("id"))) : null;
        department.setId(departmentId);
        planInfo.setHrOrgUnit(hrOrgUnit);
        planInfo.setAdminOrg(adminOrgUnit);
        planInfo.setCompany(company);
        planInfo.setDepartment(department);
        Map empPostRankMap = (Map)personRefInfo.get("oldEmpPostRank");
        Map positionMap = (Map)personRefInfo.get("position");
        JobGradeInfo jobGrade = new JobGradeInfo();
        BOSUuid jobGradeId = empPostRankMap.get("jobGradeId") != null ? BOSUuid.read((String)((String)empPostRankMap.get("jobGradeId"))) : null;
        jobGrade.setId(jobGradeId);
        JobLevelInfo jobLevel = new JobLevelInfo();
        BOSUuid jobLevelId = empPostRankMap.get("jobLevelId") != null ? BOSUuid.read((String)((String)empPostRankMap.get("jobLevelId"))) : null;
        jobLevel.setId(jobLevelId);
        PositionInfo position = new PositionInfo();
        BOSUuid positionId = positionMap.get("id") != null ? BOSUuid.read((String)((String)positionMap.get("id"))) : null;
        position.setId(positionId);
        planInfo.setJobLevel(jobLevel);
        planInfo.setJobGrade(jobGrade);
        planInfo.setPosition(position);
        Map personMap = (Map)personRefInfo.get("person");
        PersonInfo person = new PersonInfo();
        person.setId(BOSUuid.read((String)personId));
        String empNumber = (String)personMap.get("number");
        String personName = (String)personMap.get("name");
        String tutorId = (String)personMap.get("tutorId");
        person.setName(personName);
        person.setNumber(empNumber);
        planInfo.setPerson(person);
        planInfo.setEmpNumber(empNumber);
        PersonInfo tutor = new PersonInfo();
        tutor.setId(BOSUuid.read((String)tutorId));
        planInfo.setTutor(tutor);
        return planInfo;
    }

    public void updatePersonProbationBillOnPositionChange(Context ctx, String personId, AdminOrgUnitInfo adminOrg, PositionInfo position) {
        String oql = " select person.name, * where person = '" + personId + "' and planState = '" + ProbationTrainStateEnum.PLANSTATE_UNSTART.getAlias() + "'";
        try {
            CoreBaseCollection saveData = new CoreBaseCollection();
            PersonProbationTrainPlanCollection coll = PersonProbationTrainPlanFactory.getLocalInstance(ctx).getPersonProbationTrainPlanCollection(oql);
            for (int i = 0; i < coll.size(); ++i) {
                PersonProbationTrainPlanInfo trainPlanInfo = coll.get(i);
                trainPlanInfo.setAdminOrg(adminOrg);
                trainPlanInfo.setCompany(adminOrg.getCompany());
                trainPlanInfo.setDepartment(adminOrg.getDepartment());
                trainPlanInfo.setPosition(position);
                saveData.add((CoreBaseInfo)trainPlanInfo);
            }
            PersonProbationTrainPlanFactory.getLocalInstance(ctx).updateBatchData(saveData);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    public void updatePersonProbationBillOnJobLevelChange(Context ctx, String personId, JobLevelInfo jobLevel, JobGradeInfo jobGrade) {
        String oql = " select person.name, * where person = '" + personId + "' and planState = '" + ProbationTrainStateEnum.PLANSTATE_UNSTART.getAlias() + "'";
        try {
            CoreBaseCollection saveData = new CoreBaseCollection();
            PersonProbationTrainPlanCollection coll = PersonProbationTrainPlanFactory.getLocalInstance(ctx).getPersonProbationTrainPlanCollection(oql);
            for (int i = 0; i < coll.size(); ++i) {
                PersonProbationTrainPlanInfo trainPlanInfo = coll.get(i);
                trainPlanInfo.setJobLevel(jobLevel);
                trainPlanInfo.setJobGrade(jobGrade);
                saveData.add((CoreBaseInfo)trainPlanInfo);
            }
            PersonProbationTrainPlanFactory.getLocalInstance(ctx).updateBatchData(saveData);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    public static void abortPersonProbationBillAfterResign(Context ctx, String personId) throws BOSException, EASBizException {
        String oql = " select person.name, * where person = '" + personId + "' and planState <> '" + ProbationTrainStateEnum.PLANSTATE_END.getAlias() + "' and planState <> '" + ProbationTrainStateEnum.PLANSTATE_ABORT.getAlias() + "'";
        PersonProbationTrainPlanCollection coll = PersonProbationTrainPlanFactory.getLocalInstance(ctx).getPersonProbationTrainPlanCollection(oql);
        String abortReason = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"PERSON_RESIGN", (Context)ctx);
        for (int i = 0; i < coll.size(); ++i) {
            PersonProbationTrainPlanInfo trainPlanInfo = coll.get(i);
            ProbationTrainPlanUtil.abortPersonTrainPeriod(ctx, trainPlanInfo, abortReason, ProbationTrainStateEnum.PLANSTATE_ABORT.toString());
            Set receiver = JobUtils.getExecutor((Context)ctx, (String)trainPlanInfo.getId().toString(), (int)3);
            ProbationTrainPlanUtil.abortActivity(ctx, trainPlanInfo, abortReason);
            ProbationTrainPlanUtil.sendActivityAbortNotice(ctx, trainPlanInfo, receiver, 1);
        }
    }

    public static void setPeronTutor(Context ctx, String personId, PersonInfo tutor) throws BOSException, EASBizException {
        if (logger.isInfoEnabled()) {
            logger.info("ProbationTrainPlanUtil.setPeronTutor: " + personId);
        }
        CoreBaseCollection saveData = new CoreBaseCollection();
        String oql = " where person = '" + personId + "' and planState = '" + ProbationTrainStateEnum.PLANSTATE_UNSTART.getAlias() + "'";
        PersonProbationTrainPlanCollection coll = PersonProbationTrainPlanFactory.getLocalInstance(ctx).getPersonProbationTrainPlanCollection(oql);
        for (int i = 0; i < coll.size(); ++i) {
            PersonProbationTrainPlanInfo planInfo = coll.get(i);
            planInfo.setTutor(tutor);
            saveData.add((CoreBaseInfo)planInfo);
        }
        PersonProbationTrainPlanFactory.getLocalInstance(ctx).updateBatchData(saveData);
    }

    public static ProbationTrainProgramInfo getFitestProbationTrainProgram(Context ctx, String personId) throws BOSException, EASBizException {
        String programId = ProbationGoalUtil.getRangeTempId(ctx, personId, ProbationTrainPlanUtil.isConditionAnd(ctx), 2);
        if (StringUtils.isEmpty((String)programId)) {
            throw new ProbationException(ProbationException.FITEST_TRAIN);
        }
        ProbationTrainProgramInfo programInfo = ProbationTrainProgramFactory.getLocalInstance(ctx).getProbationTrainProgramInfo((IObjectPK)new ObjectUuidPK(programId));
        return programInfo;
    }

    protected static Boolean isConditionAnd(Context ctx) {
        return true;
    }

    public static boolean checkPersonCanDelete(Context ctx, String personId) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        return !PersonProbationTrainPlanFactory.getLocalInstance(ctx).exists(filterInfo);
    }
}

